/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNEntryHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNMerger;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNObjectsPool;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea$1;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea$2;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry16;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLogImpl;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLogRunner;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.ISVNMergerFactory;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNMergeResult;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNAdminArea {
    protected static final String ADM_KILLME = "KILLME";
    private static volatile boolean ourIsCleanupSafe;
    protected Map myBaseProperties;
    protected Map myProperties;
    protected Map myWCProperties;
    protected Map myEntries;
    protected boolean myWasLocked;
    private ISVNCommitParameters myCommitParameters;
    private Map myRevertProperties;
    private File myDirectory;
    private SVNWCAccess myWCAccess;
    private File myAdminRoot;
    private int myWCFormatVersion;

    public static synchronized void setSafeCleanup(boolean bl2) {
        ourIsCleanupSafe = bl2;
    }

    public static synchronized boolean isSafeCleanup() {
        return ourIsCleanupSafe;
    }

    public abstract boolean isLocked();

    public abstract boolean isVersioned();

    protected abstract boolean isEntryPropertyApplicable(String var1);

    public abstract boolean lock(boolean var1);

    public abstract boolean unlock();

    public abstract SVNVersionedProperties getBaseProperties(String var1);

    public abstract SVNVersionedProperties getRevertProperties(String var1);

    public abstract SVNVersionedProperties getWCProperties(String var1);

    public abstract SVNVersionedProperties getProperties(String var1);

    public abstract void saveVersionedProperties(SVNLog var1, boolean var2);

    public abstract void installProperties(String var1, SVNProperties var2, SVNProperties var3, SVNLog var4, boolean var5, boolean var6);

    public abstract void saveWCProperties(boolean var1);

    public abstract void saveEntries(boolean var1);

    public abstract String getThisDirName();

    public abstract boolean hasPropModifications(String var1);

    public abstract boolean hasProperties(String var1);

    public abstract SVNAdminArea createVersionedDirectory(File var1, String var2, String var3, String var4, long var5, boolean var7, SVNDepth var8);

    public abstract void postCommit(String var1, long var2, boolean var4, boolean var5, SVNErrorCode var6);

    public abstract void handleKillMe();

    public abstract boolean hasTreeConflict(String var1);

    public abstract SVNTreeConflictDescription getTreeConflict(String var1);

    public abstract void addTreeConflict(SVNTreeConflictDescription var1);

    public abstract SVNTreeConflictDescription deleteTreeConflict(String var1);

    public abstract void setFileExternalLocation(String var1, SVNURL var2, SVNRevision var3, SVNRevision var4, SVNURL var5);

    public abstract int getFormatVersion();

    public void updateURL(String string, boolean bl2) {
        SVNWCAccess sVNWCAccess = this.getWCAccess();
        Iterator iterator = this.entries(false);
        while (iterator.hasNext()) {
            SVNEntry sVNEntry = (SVNEntry)iterator.next();
            if (!this.getThisDirName().equals(sVNEntry.getName()) && sVNEntry.isDirectory() && bl2) {
                SVNAdminArea sVNAdminArea = sVNWCAccess.retrieve(this.getFile(sVNEntry.getName()));
                if (sVNAdminArea == null) continue;
                String string2 = SVNPathUtil.append(string, SVNEncodingUtil.uriEncode(sVNEntry.getName()));
                sVNAdminArea.updateURL(string2, bl2);
                continue;
            }
            sVNEntry.setURL(this.getThisDirName().equals(sVNEntry.getName()) ? string : SVNPathUtil.append(string, SVNEncodingUtil.uriEncode(sVNEntry.getName())));
        }
        this.saveEntries(false);
    }

    public boolean hasTextModifications(String string, boolean bl2) {
        return this.hasTextModifications(string, bl2, true, false);
    }

    public boolean hasTextModifications(String string, boolean bl2, boolean bl3, boolean bl4) {
        File file;
        File file2 = this.getFile(string);
        SVNFileType sVNFileType = SVNFileType.getType(file2);
        if (sVNFileType != SVNFileType.FILE && sVNFileType != SVNFileType.SYMLINK) {
            return false;
        }
        if (sVNFileType == SVNFileType.SYMLINK) {
            bl2 = true;
        }
        SVNEntry sVNEntry = null;
        if (!bl2) {
            boolean bl5 = false;
            try {
                sVNEntry = this.getEntry(string, false);
            }
            catch (SVNException sVNException) {
                bl5 = true;
            }
            if (!bl5 && sVNEntry == null) {
                bl5 = true;
            }
            if (!bl5 && this.isEntryPropertyApplicable("svn:entry:working-size") && sVNEntry.getWorkingSize() != -1L && SVNFileUtil.getFileLength(file2) != sVNEntry.getWorkingSize()) {
                bl5 = true;
            }
            if (!bl5) {
                String string2 = sVNEntry.getTextTime();
                if (string2 == null) {
                    bl5 = true;
                } else {
                    long l2;
                    long l3 = SVNDate.parseDateAsMilliseconds(string2);
                    if (l3 != (l2 = SVNFileUtil.getFileLastModified(file2))) {
                        bl5 = true;
                    }
                }
            }
            if (!bl5) {
                return false;
            }
        }
        if (!(file = this.getBaseFile(string, false)).isFile()) {
            return true;
        }
        boolean bl6 = this.compareAndVerify(file2, file, bl3, bl4);
        if (!bl6 && this.isLocked()) {
            SVNHashMap sVNHashMap = new SVNHashMap();
            sVNHashMap.put("svn:entry:working-size", Long.toString(SVNFileUtil.getFileLength(file2)));
            sVNHashMap.put("svn:entry:text-time", SVNDate.formatDate(new Date(SVNFileUtil.getFileLastModified(file2))));
            this.modifyEntry(string, sVNHashMap, true, false);
        }
        return bl6;
    }

    public boolean hasVersionedFileTextChanges(File file, File file2, boolean bl2) {
        return this.compareAndVerify(file, file2, bl2, false);
    }

    public String getRelativePath(SVNAdminArea sVNAdminArea) {
        String string = sVNAdminArea.getRoot().getAbsolutePath();
        String string2 = this.getRoot().getAbsolutePath();
        String string3 = string2.substring(string.length());
        if ((string3 = string3.replace(File.separatorChar, '/')).startsWith("/")) {
            string3 = string3.substring(1);
        }
        if (string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }

    public boolean tweakEntry(String string, String string2, String string3, long l2, boolean bl2) {
        boolean bl3 = false;
        SVNEntry sVNEntry = this.getEntry(string, true);
        if (sVNEntry == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No such entry: ''{0}''", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (!(string2 == null || sVNEntry.getURL() != null && string2.equals(sVNEntry.getURL()))) {
            bl3 = true;
            sVNEntry.setURL(string2);
        }
        if (string3 != null && (sVNEntry.getRepositoryRootURL() == null || !string3.equals(sVNEntry.getRepositoryRoot())) && sVNEntry.getURL() != null && SVNPathUtil.isAncestor(string3, sVNEntry.getURL())) {
            boolean bl4 = true;
            if (this.getThisDirName().equals(sVNEntry.getName())) {
                Iterator iterator = this.entries(true);
                while (iterator.hasNext()) {
                    SVNEntry sVNEntry2 = (SVNEntry)iterator.next();
                    if (sVNEntry2.getRepositoryRoot() != null || sVNEntry2.getURL() == null || SVNPathUtil.isAncestor(string3, sVNEntry.getURL())) continue;
                    bl4 = false;
                    break;
                }
            }
            if (bl4) {
                bl3 = true;
                sVNEntry.setRepositoryRoot(string3);
            }
        }
        if (!(l2 < 0L || sVNEntry.isScheduledForAddition() || sVNEntry.isScheduledForReplacement() || sVNEntry.isCopied() || sVNEntry.getRevision() == l2)) {
            bl3 = true;
            sVNEntry.setRevision(l2);
        }
        if (bl2 && (sVNEntry.isDeleted() || sVNEntry.isAbsent() && sVNEntry.getRevision() != l2)) {
            this.deleteEntry(string);
            bl3 = true;
        }
        return bl3;
    }

    public boolean isKillMe() {
        return this.getAdminFile(ADM_KILLME).isFile();
    }

    public boolean markResolved(String string, boolean bl2, boolean bl3, SVNConflictChoice sVNConflictChoice) {
        Object object;
        Object object2;
        SVNEntry sVNEntry = this.getEntry(string, true);
        if (sVNEntry == null) {
            return false;
        }
        String string2 = null;
        File file = null;
        boolean bl4 = false;
        if (sVNConflictChoice == SVNConflictChoice.BASE) {
            string2 = sVNEntry.getConflictOld();
        } else if (sVNConflictChoice == SVNConflictChoice.MINE_FULL) {
            string2 = sVNEntry.getConflictWorking();
        } else if (sVNConflictChoice == SVNConflictChoice.THEIRS_FULL) {
            string2 = sVNEntry.getConflictNew();
        } else if (sVNConflictChoice == SVNConflictChoice.THEIRS_CONFLICT || sVNConflictChoice == SVNConflictChoice.MINE_CONFLICT) {
            if (sVNEntry.getConflictOld() != null && sVNEntry.getConflictNew() != null && sVNEntry.getConflictWorking() != null) {
                Object object3;
                SVNDiffConflictChoiceStyle sVNDiffConflictChoiceStyle;
                object2 = sVNEntry.getConflictOld();
                String string3 = sVNEntry.getConflictNew();
                object = sVNEntry.getConflictWorking();
                ISVNMergerFactory iSVNMergerFactory = this.myWCAccess.getOptions().getMergerFactory();
                File file2 = SVNPathUtil.isAbsolute((String)object2) ? new File((String)object2) : this.getFile((String)object2);
                File file3 = SVNPathUtil.isAbsolute(string3) ? new File(string3) : this.getFile(string3);
                File file4 = SVNPathUtil.isAbsolute((String)object) ? new File((String)object) : this.getFile((String)object);
                byte[] byArray = ("<<<<<<< " + (String)object).getBytes();
                byte[] byArray2 = (">>>>>>> " + string3).getBytes();
                byte[] byArray3 = "=======".getBytes();
                ISVNMerger iSVNMerger = iSVNMergerFactory.createMerger(byArray, byArray3, byArray2);
                SVNDiffConflictChoiceStyle sVNDiffConflictChoiceStyle2 = sVNDiffConflictChoiceStyle = sVNConflictChoice == SVNConflictChoice.THEIRS_CONFLICT ? SVNDiffConflictChoiceStyle.CHOOSE_LATEST : SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED;
                if (iSVNMerger instanceof DefaultSVNMerger) {
                    object3 = (DefaultSVNMerger)iSVNMerger;
                    ((DefaultSVNMerger)object3).setDiffConflictStyle(sVNDiffConflictChoiceStyle);
                }
                file = SVNAdminUtil.createTmpFile(this);
                object3 = new SVNMergeFileSet(this, null, file2, file4, string, file3, file, null, null);
                String string4 = ".working";
                String string5 = ".old";
                String string6 = ".new";
                ((SVNMergeFileSet)object3).setMergeLabels(string5, string4, string6);
                iSVNMerger.mergeText((SVNMergeFileSet)object3, false, null);
                ((SVNMergeFileSet)object3).dispose();
                bl4 = true;
            }
        } else if (sVNConflictChoice != SVNConflictChoice.MERGED) {
            object2 = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Invalid 'conflict_result' argument");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.DEFAULT);
        }
        if (string2 != null) {
            file = this.getFile(string2);
        }
        if (file != null) {
            SVNFileUtil.copyFile(file, this.getFile(string), false);
            if (bl4) {
                SVNFileUtil.deleteFile(file);
            }
        }
        if (!bl2 && !bl3) {
            return false;
        }
        boolean bl5 = false;
        boolean bl6 = false;
        if (bl2 && sVNEntry.getConflictOld() != null) {
            object = this.getFile(sVNEntry.getConflictOld());
            bl5 |= ((File)object).isFile();
            bl6 = true;
            SVNFileUtil.deleteFile((File)object);
        }
        if (bl2 && sVNEntry.getConflictNew() != null) {
            object = this.getFile(sVNEntry.getConflictNew());
            bl5 |= ((File)object).isFile();
            bl6 = true;
            SVNFileUtil.deleteFile((File)object);
        }
        if (bl2 && sVNEntry.getConflictWorking() != null) {
            object = this.getFile(sVNEntry.getConflictWorking());
            bl5 |= ((File)object).isFile();
            bl6 = true;
            SVNFileUtil.deleteFile((File)object);
        }
        if (bl3 && sVNEntry.getPropRejectFile() != null) {
            object = this.getFile(sVNEntry.getPropRejectFile());
            bl5 |= ((File)object).isFile();
            bl6 = true;
            SVNFileUtil.deleteFile((File)object);
        }
        if (bl6) {
            if (bl2) {
                sVNEntry.setConflictOld(null);
                sVNEntry.setConflictNew(null);
                sVNEntry.setConflictWorking(null);
            }
            if (bl3) {
                sVNEntry.setPropRejectFile(null);
            }
            this.saveEntries(false);
        }
        return bl5;
    }

    public void restoreFile(String string) {
        boolean bl2;
        SVNVersionedProperties sVNVersionedProperties = this.getProperties(string);
        SVNEntry sVNEntry = this.getEntry(string, true);
        boolean bl3 = sVNVersionedProperties.getPropertyValue("svn:special") != null;
        File file = this.getBaseFile(string, false);
        File file2 = this.getFile(string);
        SVNTranslator.translate(this, string, SVNFileUtil.getBasePath(file), SVNFileUtil.getBasePath(file2), true);
        boolean bl4 = sVNVersionedProperties.getPropertyValue("svn:executable") != null;
        boolean bl5 = bl2 = sVNVersionedProperties.getPropertyValue("svn:needs-lock") != null;
        if (bl2) {
            SVNFileUtil.setReadonly(file2, sVNEntry.getLockToken() == null);
        }
        if (bl4) {
            SVNFileUtil.setExecutable(file2, true);
        }
        this.markResolved(string, true, false, SVNConflictChoice.MERGED);
        if (this.myWCAccess.getOptions().isUseCommitTimes() && !bl3) {
            sVNEntry.setTextTime(sVNEntry.getCommittedDate());
            long l2 = SVNDate.parseDate(sVNEntry.getCommittedDate()).getTime();
            SVNFileUtil.setLastModified(file2, l2);
        } else {
            long l3 = System.currentTimeMillis();
            SVNFileUtil.setLastModified(file2, l3);
            sVNEntry.setTextTime(SVNDate.formatDate(new Date(file2.lastModified())));
        }
        this.saveEntries(false);
    }

    public SVNStatusType mergeProperties(String string, SVNProperties sVNProperties, SVNProperties sVNProperties2, String string2, String string3, boolean bl2, boolean bl3, SVNLog sVNLog) {
        SVNVersionedProperties sVNVersionedProperties = this.getProperties(string);
        SVNVersionedProperties sVNVersionedProperties2 = this.getBaseProperties(string);
        return this.mergeProperties(string, sVNProperties, sVNVersionedProperties2.asMap(), sVNVersionedProperties.asMap(), sVNProperties2, string2, string3, bl2, bl3, sVNLog);
    }

    public SVNStatusType mergeProperties(String string, SVNProperties sVNProperties, SVNProperties sVNProperties2, SVNProperties sVNProperties3, SVNProperties sVNProperties4, String string2, String string3, boolean bl2, boolean bl3, SVNLog sVNLog) {
        string2 = string2 == null ? "(modified)" : string2;
        string3 = string3 == null ? "(latest)" : string3;
        byte[] byArray = ("<<<<<<< " + string2).getBytes();
        byte[] byArray2 = (">>>>>>> " + string3).getBytes();
        byte[] byArray3 = "=======".getBytes();
        ISVNMergerFactory iSVNMergerFactory = this.myWCAccess.getOptions().getMergerFactory();
        ISVNMerger iSVNMerger = iSVNMergerFactory.createMerger(byArray, byArray3, byArray2);
        sVNProperties4 = sVNProperties4 == null ? new SVNProperties() : sVNProperties4;
        SVNMergeResult sVNMergeResult = iSVNMerger.mergeProperties(string, sVNProperties3, sVNProperties2, sVNProperties, sVNProperties4, this, sVNLog, bl2, bl3);
        return sVNMergeResult.getMergeStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType mergeText(String string, File file, File file2, File file3, String string2, String string3, String string4, SVNProperties sVNProperties, boolean bl2, SVNDiffOptions sVNDiffOptions, SVNLog sVNLog) {
        SVNMergeResult sVNMergeResult;
        Object object;
        Object object2;
        SVNEntry sVNEntry = this.getEntry(string, false);
        if (sVNEntry == null && file3 == null) {
            return SVNStatusType.MISSING;
        }
        boolean bl3 = sVNLog == null;
        sVNLog = sVNLog == null ? this.getLog() : sVNLog;
        SVNVersionedProperties sVNVersionedProperties = this.getProperties(string);
        String string5 = null;
        if (sVNProperties != null && sVNProperties.containsName("svn:mime-type")) {
            string5 = sVNProperties.getStringValue("svn:mime-type");
        } else if (file3 == null) {
            string5 = sVNVersionedProperties.getStringPropertyValue("svn:mime-type");
        }
        string2 = string2 == null ? ".working" : string2;
        string3 = string3 == null ? ".old" : string3;
        string4 = string4 == null ? ".new" : string4;
        byte[] byArray = ("<<<<<<< " + string2).getBytes();
        byte[] byArray2 = (">>>>>>> " + string4).getBytes();
        byte[] byArray3 = "=======".getBytes();
        ISVNMergerFactory iSVNMergerFactory = this.myWCAccess.getOptions().getMergerFactory();
        ISVNMerger iSVNMerger = iSVNMergerFactory.createMerger(byArray, byArray3, byArray2);
        String string6 = string;
        if (file3 != null && (string6 = ((String)(object2 = file3.getAbsolutePath().replace(File.separatorChar, '/'))).substring(((String)(object = this.getRoot().getAbsolutePath().replace(File.separatorChar, '/'))).length())).startsWith("/")) {
            string6 = string6.substring(1);
        }
        object2 = SVNTranslator.detranslateWorkingCopy(this, string6, sVNProperties, false);
        file = SVNTranslator.maybeUpdateTargetEOLs(this, file, sVNProperties);
        object = SVNAdminUtil.createTmpFile(this);
        SVNMergeFileSet sVNMergeFileSet = new SVNMergeFileSet(this, sVNLog, file, (File)object2, string, file2, (File)object, file3, string5);
        sVNMergeFileSet.setMergeLabels(string3, string2, string4);
        try {
            sVNMergeResult = iSVNMerger.mergeText(sVNMergeFileSet, bl2, sVNDiffOptions);
        }
        finally {
            if (bl2) {
                SVNFileUtil.deleteFile((File)object);
            }
        }
        sVNMergeFileSet.dispose();
        if (bl3) {
            sVNLog.save();
        }
        return sVNMergeResult.getMergeStatus();
    }

    public InputStream getBaseFileForReading(String string, boolean bl2) {
        String string2 = bl2 ? "tmp/" : "";
        string2 = string2 + "text-base/" + string + ".svn-base";
        File file = this.getAdminFile(string2);
        return SVNFileUtil.openFileForReading(file, SVNLogType.WC);
    }

    public OutputStream getBaseFileForWriting(String string) {
        String string2 = string;
        File file = this.getBaseFile(string, true);
        try {
            OutputStream outputStream = SVNFileUtil.openFileForWriting(file);
            return new SVNAdminArea$1(this, string2, file, outputStream);
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage().wrap("Your .svn/tmp directory may be missing or corrupt; run 'svn cleanup' and try again");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            return null;
        }
    }

    public String getPropertyTime(String string) {
        String string2 = this.getThisDirName().equals(string) ? "dir-props" : "props/" + string + ".svn-work";
        File file = this.getAdminFile(string2);
        return SVNDate.formatDate(new Date(SVNFileUtil.getFileLastModified(file)));
    }

    public SVNLog getLog() {
        int n2 = 0;
        File file = null;
        File file2 = null;
        while ((file = this.getAdminFile("log" + (n2 == 0 ? "" : "." + n2))).exists()) {
            ++n2;
        }
        file2 = this.getAdminFile("tmp/log" + (n2 == 0 ? "" : "." + n2));
        return new SVNLogImpl(file, file2, this);
    }

    public void runLogs() {
        this.runLogs(false);
    }

    public void runLogs(boolean bl2) {
        File[] fileArray;
        SVNLogRunner sVNLogRunner = new SVNLogRunner(bl2);
        int n2 = 0;
        SVNLogImpl sVNLogImpl = null;
        sVNLogRunner.logStarted(this);
        try {
            fileArray = null;
            while (true) {
                if (this.getWCAccess() != null) {
                    this.getWCAccess().checkCancelled();
                }
                if (((SVNLog)(sVNLogImpl = new SVNLogImpl((File)(fileArray = this.getAdminFile("log" + (n2 == 0 ? "" : "." + n2))), null, this))).exists()) {
                    sVNLogImpl.run(sVNLogRunner);
                    SVNAdminArea.markLogProcessed((File)fileArray);
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            sVNLogRunner.logFailed(this);
            if (throwable instanceof SVNException) {
                throw (SVNException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.UNKNOWN), throwable);
        }
        sVNLogRunner.logCompleted(this);
        fileArray = this.getAdminDirectory().listFiles();
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (!fileArray[i2].getName().startsWith("log") || !fileArray[i2].isFile()) continue;
                SVNFileUtil.deleteFile(fileArray[i2]);
            }
        }
    }

    public void removeFromRevisionControl(String string, boolean bl2, boolean bl3) {
        Object object;
        this.getWCAccess().checkCancelled();
        boolean bl4 = !this.getThisDirName().equals(string);
        boolean bl5 = false;
        SVNEntry sVNEntry = this.getVersionedEntry(string, true);
        if (bl4) {
            SVNErrorMessage sVNErrorMessage;
            boolean bl6;
            object = this.getFile(string);
            boolean bl7 = bl6 = this.getProperties(string).getPropertyValue("svn:special") != null;
            boolean bl8 = !SVNFileUtil.symlinksSupported() ? false : SVNFileType.getType((File)object) == SVNFileType.SYMLINK;
            boolean bl9 = false;
            if (bl6 || !bl8) {
                bl9 = this.hasTextModifications(string, false);
                if (bl3 && bl9) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD, "File ''{0}'' has local modifications", object);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
            }
            SVNPropertiesManager.deleteWCProperties(this, string, false);
            this.deleteEntry(string);
            this.saveEntries(false);
            SVNFileUtil.deleteFile(this.getFile(SVNAdminUtil.getTextBasePath(string, false)));
            SVNFileUtil.deleteFile(this.getFile(SVNAdminUtil.getPropBasePath(string, sVNEntry.getKind(), false)));
            SVNFileUtil.deleteFile(this.getFile(SVNAdminUtil.getPropPath(string, sVNEntry.getKind(), false)));
            if (bl2) {
                if (bl9 || !bl6 && bl8) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                } else if (this.myCommitParameters == null || this.myCommitParameters.onFileDeletion((File)object)) {
                    SVNFileUtil.deleteFile((File)object);
                }
            }
        } else {
            object = this.getEntry(this.getThisDirName(), false);
            ((SVNEntry)object).setIncomplete(true);
            this.saveEntries(false);
            SVNPropertiesManager.deleteWCProperties(this, this.getThisDirName(), false);
            Object object2 = this.entries(false);
            while (object2.hasNext()) {
                String string2;
                SVNEntry sVNEntry2 = (SVNEntry)object2.next();
                String string3 = string2 = this.getThisDirName().equals(sVNEntry2.getName()) ? null : sVNEntry2.getName();
                if (sVNEntry2.isFile()) {
                    try {
                        this.removeFromRevisionControl(string2, bl2, bl3);
                        continue;
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                            if (bl3) {
                                throw sVNException;
                            }
                            bl5 = true;
                            continue;
                        }
                        throw sVNException;
                    }
                }
                if (string2 == null || !sVNEntry2.isDirectory()) continue;
                File file = this.getFile(string2);
                if (this.getWCAccess().isMissing(file) || sVNEntry2.getDepth() == SVNDepth.EXCLUDE) {
                    this.deleteEntry(string2);
                    continue;
                }
                try {
                    SVNAdminArea sVNAdminArea = this.getWCAccess().retrieve(file);
                    sVNAdminArea.removeFromRevisionControl(this.getThisDirName(), bl2, bl3);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                        if (bl3) {
                            throw sVNException;
                        }
                        bl5 = true;
                        continue;
                    }
                    throw sVNException;
                }
            }
            if (!this.getWCAccess().isWCRoot(this.getRoot()) && ((SVNEntry)(object2 = this.getWCAccess().retrieve(this.getRoot().getParentFile()).getEntry(this.getRoot().getName(), false))).getDepth() != SVNDepth.EXCLUDE) {
                this.getWCAccess().retrieve(this.getRoot().getParentFile()).deleteEntry(this.getRoot().getName());
                this.getWCAccess().retrieve(this.getRoot().getParentFile()).saveEntries(false);
            }
            this.destroyAdminArea();
            if (bl2 && !bl5 && (this.myCommitParameters == null || this.myCommitParameters.onDirectoryDeletion(this.getRoot())) && !this.getRoot().delete()) {
                bl5 = true;
            }
        }
        if (bl5 && this.myCommitParameters == null) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
    }

    public void extendLockToTree() {
        boolean bl2 = this.isLocked();
        SVNAdminArea$2 sVNAdminArea$2 = new SVNAdminArea$2(this, bl2);
        this.getWCAccess().walkEntries(this.getRoot(), sVNAdminArea$2, false, SVNDepth.INFINITY);
    }

    public void foldScheduling(String string, Map map, boolean bl2) {
        SVNErrorMessage sVNErrorMessage;
        Object object;
        if (!map.containsKey("svn:entry:schedule") || bl2) {
            return;
        }
        String string2 = (String)map.get("svn:entry:schedule");
        string2 = "".equals(string2) ? null : string2;
        SVNEntry sVNEntry = this.getEntry(string, true);
        if (sVNEntry == null) {
            if ("add".equals(string2)) {
                return;
            }
            object = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "''{0}'' is not under version control", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = this.getEntry(this.getThisDirName(), true);
        if (!this.getThisDirName().equals(sVNEntry.getName()) && ((SVNEntry)object).isScheduledForDeletion()) {
            if ("add".equals(string2)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t add ''{0}'' to deleted directory; try undeleting its parent directory first", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else if ("replace".equals(string2)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t replace ''{0}'' in deleted directory; try undeleting its parent directory first", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        }
        if (sVNEntry.isAbsent() && "add".equals(string2)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "''{0}'' is marked as absent, so it cannot be scheduled for addition", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if ("add".equals(sVNEntry.getSchedule())) {
            if ("delete".equals(string2)) {
                if (!sVNEntry.isDeleted()) {
                    this.deleteEntry(string);
                } else {
                    map.put("svn:entry:schedule", null);
                }
            } else {
                map.remove("svn:entry:schedule");
            }
        } else if ("delete".equals(sVNEntry.getSchedule())) {
            if ("delete".equals(string2)) {
                map.remove("svn:entry:schedule");
            } else if ("add".equals(string2)) {
                map.put("svn:entry:schedule", "replace");
            }
        } else if ("replace".equals(sVNEntry.getSchedule())) {
            if ("delete".equals(string2)) {
                map.put("svn:entry:schedule", "delete");
            } else if ("add".equals(string2) || "replace".equals(string2)) {
                map.remove("svn:entry:schedule");
            }
        } else if ("add".equals(string2) && !sVNEntry.isDeleted()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Entry ''{0}'' is already under version control", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        } else if (string2 == null) {
            map.remove("svn:entry:schedule");
        }
    }

    public SVNEntry modifyEntry(String string, Map map, boolean bl2, boolean bl3) {
        Object object;
        SVNEntry sVNEntry;
        if (string == null) {
            string = this.getThisDirName();
        }
        boolean bl4 = false;
        if (map.containsKey("svn:entry:schedule")) {
            sVNEntry = this.getEntry(string, true);
            this.foldScheduling(string, map, bl3);
            object = this.getEntry(string, true);
            if (sVNEntry != null && object == null) {
                bl4 = true;
            }
        }
        sVNEntry = null;
        if (!bl4) {
            sVNEntry = this.getEntry(string, true);
            if (sVNEntry == null) {
                sVNEntry = this.addEntry(string);
            }
            object = map.keySet().iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (this.isEntryPropertyApplicable(string2)) continue;
                object.remove();
            }
            sVNEntry.applyChanges(map);
            if (!sVNEntry.isDirectory() && (object = this.getEntry(this.getThisDirName(), true)) != null) {
                if (!SVNRevision.isValidRevisionNumber(sVNEntry.getRevision())) {
                    sVNEntry.setRevision(((SVNEntry)object).getRevision());
                }
                if (sVNEntry.getURL() == null) {
                    sVNEntry.setParentURL(((SVNEntry)object).getURL());
                }
                if (sVNEntry.getRepositoryRoot() == null) {
                    sVNEntry.setRepositoryRoot(((SVNEntry)object).getRepositoryRoot());
                }
                if (sVNEntry.getUUID() == null && !sVNEntry.isScheduledForAddition() && !sVNEntry.isScheduledForReplacement()) {
                    sVNEntry.setUUID(((SVNEntry)object).getUUID());
                }
                if (this.isEntryPropertyApplicable("svn:entry:cachable-props") && sVNEntry.getCachableProperties() == null) {
                    sVNEntry.setCachableProperties(((SVNEntry)object).getCachableProperties());
                }
            }
            if (map.containsKey("svn:entry:schedule")) {
                if (sVNEntry.isScheduledForDeletion()) {
                    sVNEntry.setCopied(false);
                    sVNEntry.setCopyFromRevision(-1L);
                    sVNEntry.setCopyFromURL(null);
                } else {
                    sVNEntry.setKeepLocal(false);
                }
            }
        }
        if (bl2) {
            this.saveEntries(false);
        }
        return sVNEntry;
    }

    public void deleteEntry(String string) {
        Map map = this.loadEntries();
        if (map != null) {
            map.remove(string);
        }
    }

    public SVNEntry getEntry(String string, boolean bl2) {
        Map map = this.loadEntries();
        if (map != null && map.containsKey(string)) {
            SVNEntry sVNEntry = (SVNEntry)map.get(string);
            if (!bl2 && sVNEntry.isHidden()) {
                return null;
            }
            return sVNEntry;
        }
        return null;
    }

    public SVNEntry getVersionedEntry(String string, boolean bl2) {
        SVNEntry sVNEntry = this.getEntry(string, bl2);
        if (sVNEntry == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)this.getFile(string));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return sVNEntry;
    }

    public SVNEntry addEntry(String string) {
        Map map = this.loadEntries();
        if (map == null) {
            map = this.myEntries = new SVNHashMap();
        }
        SVNEntry sVNEntry = map.containsKey(string) ? (SVNEntry)map.get(string) : new SVNEntry16(this, string);
        map.put(string, sVNEntry);
        return sVNEntry;
    }

    public Iterator entries(boolean bl2) {
        Map map = this.loadEntries();
        if (map == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList arrayList = new ArrayList(map.values());
        if (!bl2) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                SVNEntry sVNEntry = (SVNEntry)iterator.next();
                if (!sVNEntry.isHidden()) continue;
                iterator.remove();
            }
        }
        return arrayList.iterator();
    }

    public Map getEntries() {
        return this.loadEntries();
    }

    public void cleanup() {
        this.getWCAccess().checkCancelled();
        Iterator iterator = this.entries(false);
        while (iterator.hasNext()) {
            SVNEntry sVNEntry = (SVNEntry)iterator.next();
            if (sVNEntry.getKind() == SVNNodeKind.DIR && !this.getThisDirName().equals(sVNEntry.getName())) {
                File file = this.getFile(sVNEntry.getName());
                if (!file.isDirectory()) continue;
                try {
                    SVNAdminArea sVNAdminArea = this.getWCAccess().open(file, true, true, 0);
                    sVNAdminArea.cleanup();
                    continue;
                }
                catch (SVNException sVNException) {
                    if (sVNException instanceof SVNCancelException) {
                        throw sVNException;
                    }
                    if (SVNAdminArea.isSafeCleanup()) continue;
                    throw sVNException;
                }
            }
            this.hasPropModifications(sVNEntry.getName());
            if (sVNEntry.getKind() != SVNNodeKind.FILE) continue;
            this.hasTextModifications(sVNEntry.getName(), false);
        }
        if (this.isKillMe()) {
            this.removeFromRevisionControl(this.getThisDirName(), true, false);
        } else {
            this.runLogs(true);
        }
        SVNFileUtil.deleteAll(this.getAdminFile("tmp"), false);
    }

    public boolean hasTextConflict(String string) {
        SVNEntry sVNEntry = this.getEntry(string, false);
        if (sVNEntry == null || sVNEntry.getKind() != SVNNodeKind.FILE) {
            return false;
        }
        boolean bl2 = false;
        if (sVNEntry.getConflictNew() != null) {
            boolean bl3 = bl2 = SVNFileType.getType(this.getFile(sVNEntry.getConflictNew())) == SVNFileType.FILE;
        }
        if (!bl2 && sVNEntry.getConflictWorking() != null) {
            boolean bl4 = bl2 = SVNFileType.getType(this.getFile(sVNEntry.getConflictWorking())) == SVNFileType.FILE;
        }
        if (!bl2 && sVNEntry.getConflictOld() != null) {
            bl2 = SVNFileType.getType(this.getFile(sVNEntry.getConflictOld())) == SVNFileType.FILE;
        }
        return bl2;
    }

    public boolean hasPropConflict(String string) {
        SVNEntry sVNEntry = this.getEntry(string, false);
        if (sVNEntry != null && sVNEntry.getPropRejectFile() != null) {
            return SVNFileType.getType(this.getFile(sVNEntry.getPropRejectFile())) == SVNFileType.FILE;
        }
        return false;
    }

    public File getRoot() {
        return this.myDirectory;
    }

    public File getAdminTempDirectory() {
        return this.getAdminFile("tmp");
    }

    public File getAdminDirectory() {
        return this.myAdminRoot;
    }

    public File getAdminFile(String string) {
        return new File(this.getAdminDirectory(), string);
    }

    public File getFile(String string) {
        if (string == null) {
            return null;
        }
        return new File(this.getRoot(), string);
    }

    public SVNWCAccess getWCAccess() {
        return this.myWCAccess;
    }

    public void setWCAccess(SVNWCAccess sVNWCAccess) {
        this.myWCAccess = sVNWCAccess;
    }

    public void closeVersionedProperties() {
        this.myProperties = null;
        this.myBaseProperties = null;
    }

    public void closeWCProperties() {
        this.myWCProperties = null;
    }

    public void closeEntries() {
        this.myEntries = null;
    }

    public File getBaseFile(String string, boolean bl2) {
        String string2 = bl2 ? "tmp/" : "";
        string2 = string2 + "text-base/" + string + ".svn-base";
        return this.getAdminFile(string2);
    }

    public int getWorkingCopyFormatVersion() {
        return this.myWCFormatVersion;
    }

    public void setWorkingCopyFormatVersion(int n2) {
        this.myWCFormatVersion = n2;
    }

    public void close() {
    }

    protected abstract void writeEntries(Writer var1);

    protected abstract Map fetchEntries();

    protected abstract boolean readExtraOptions(BufferedReader var1, SVNEntry var2);

    protected abstract int writeExtraOptions(Writer var1, String var2, SVNEntry var3, int var4);

    protected SVNAdminArea(File file) {
        this.myDirectory = file;
        this.myAdminRoot = new File(file, SVNFileUtil.getAdminDirectoryName());
    }

    public File getBasePropertiesFile(String string, boolean bl2) {
        String string2 = !bl2 ? "" : "tmp/";
        string2 = string2 + (this.getThisDirName().equals(string) ? "dir-prop-base" : "prop-base/" + string + ".svn-base");
        File file = this.getAdminFile(string2);
        return file;
    }

    public File getRevertPropertiesFile(String string, boolean bl2) {
        String string2 = !bl2 ? "" : "tmp/";
        string2 = string2 + (this.getThisDirName().equals(string) ? "dir-prop-revert" : "prop-base/" + string + ".svn-revert");
        File file = this.getAdminFile(string2);
        return file;
    }

    public File getPropertiesFile(String string, boolean bl2) {
        String string2 = !bl2 ? "" : "tmp/";
        string2 = string2 + (this.getThisDirName().equals(string) ? "dir-props" : "props/" + string + ".svn-work");
        File file = this.getAdminFile(string2);
        return file;
    }

    protected Map loadEntries() {
        if (this.myEntries != null) {
            return this.myEntries;
        }
        this.myEntries = this.fetchEntries();
        if (this.myEntries != null) {
            SVNAdminArea.resolveDefaults(this.myEntries);
        }
        return this.myEntries;
    }

    protected Map getBasePropertiesStorage(boolean bl2) {
        if (this.myBaseProperties == null && bl2) {
            this.myBaseProperties = new SVNHashMap();
        }
        return this.myBaseProperties;
    }

    protected Map getRevertPropertiesStorage(boolean bl2) {
        if (this.myRevertProperties == null && bl2) {
            this.myRevertProperties = new SVNHashMap();
        }
        return this.myRevertProperties;
    }

    protected Map getPropertiesStorage(boolean bl2) {
        if (this.myProperties == null && bl2) {
            this.myProperties = new SVNHashMap();
        }
        return this.myProperties;
    }

    protected Map getWCPropertiesStorage(boolean bl2) {
        if (this.myWCProperties == null && bl2) {
            this.myWCProperties = new SVNHashMap();
        }
        return this.myWCProperties;
    }

    public static String asString(String[] stringArray, String string) {
        String string2 = null;
        if (stringArray != null) {
            string2 = "";
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                string2 = string2 + stringArray[i2];
                if (i2 >= stringArray.length - 1) continue;
                string2 = string2 + string;
            }
        }
        return string2;
    }

    public static String[] fromString(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        int n3 = -1;
        while ((n3 = string.indexOf(string2, n2)) != -1) {
            linkedList.add(string.substring(n2, n3));
            for (n2 = n3; n2 < string.length() && string.charAt(n2) == ' '; ++n2) {
            }
        }
        if (n2 < string.length()) {
            linkedList.add(string.substring(n2));
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public void commit(String string, SVNCommitInfo sVNCommitInfo, SVNProperties sVNProperties, boolean bl2, boolean bl3, boolean bl4, Collection collection, ISVNCommitParameters iSVNCommitParameters) {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        SVNAdminArea sVNAdminArea = this.getWCAccess().retrieve(this.getWCAccess().getAnchor());
        String string2 = this.getRelativePath(sVNAdminArea);
        String string3 = string2 = this.getThisDirName().equals(string) ? string2 : SVNPathUtil.append(string2, string);
        if (!collection.contains(string2)) {
            object4 = this.getEntry(string, true);
            if (object4 != null && ((SVNEntry)object4).getCopyFromURL() != null) {
                return;
            }
            if (object4 != null && ((SVNEntry)object4).isFile() && ((SVNEntry)object4).isScheduledForAddition() && !((File)(object3 = this.getBaseFile(string, true))).isFile()) {
                return;
            }
        }
        object4 = this.getLog();
        object3 = null;
        if (!this.getThisDirName().equals(string)) {
            ((SVNLog)object4).logRemoveRevertFile(string, this, true);
            ((SVNLog)object4).logRemoveRevertFile(string, this, false);
            serializable = this.getBaseFile(string, true);
            object2 = SVNFileType.getType((File)serializable);
            if (object2 == SVNFileType.NONE) {
                serializable = this.getBaseFile(string, false);
                object2 = SVNFileType.getType((File)serializable);
            }
            if (object2 == SVNFileType.FILE) {
                object3 = SVNFileUtil.computeChecksum((File)serializable);
            }
            bl3 = false;
        }
        serializable = new SVNProperties();
        if (sVNCommitInfo != null) {
            ((SVNProperties)serializable).put("name", string);
            ((SVNProperties)serializable).put(SVNProperty.shortPropertyName("svn:entry:committed-rev"), Long.toString(sVNCommitInfo.getNewRevision()));
            ((SVNProperties)serializable).put(SVNProperty.shortPropertyName("svn:entry:committed-date"), SVNDate.formatDate(sVNCommitInfo.getDate()));
            ((SVNProperties)serializable).put(SVNProperty.shortPropertyName("svn:entry:last-author"), sVNCommitInfo.getAuthor());
            ((SVNLog)object4).addCommand("modify-entry", (SVNProperties)serializable, false);
            ((SVNProperties)serializable).clear();
        }
        if (object3 != null) {
            ((SVNProperties)serializable).put("name", string);
            ((SVNProperties)serializable).put(SVNProperty.shortPropertyName("svn:entry:checksum"), (String)object3);
            ((SVNLog)object4).addCommand("modify-entry", (SVNProperties)serializable, false);
            ((SVNProperties)serializable).clear();
        }
        if (bl2) {
            ((SVNProperties)serializable).put("name", string);
            ((SVNLog)object4).addCommand("delete-lock", (SVNProperties)serializable, false);
            ((SVNProperties)serializable).clear();
        }
        if (bl4) {
            ((SVNProperties)serializable).put("name", string);
            ((SVNLog)object4).addCommand("delete-changelist", (SVNProperties)serializable, false);
            ((SVNProperties)serializable).clear();
        }
        ((SVNProperties)serializable).put("name", string);
        ((SVNProperties)serializable).put("revision", sVNCommitInfo == null ? null : Long.toString(sVNCommitInfo.getNewRevision()));
        if (!collection.contains(string2)) {
            ((SVNProperties)serializable).put("implicit", "true");
        }
        ((SVNLog)object4).addCommand("committed", (SVNProperties)serializable, false);
        ((SVNProperties)serializable).clear();
        if (sVNProperties != null && !sVNProperties.isEmpty()) {
            for (Object object5 : sVNProperties.nameSet()) {
                object = sVNProperties.getSVNPropertyValue((String)object5);
                ((SVNProperties)serializable).put("name", string);
                ((SVNProperties)serializable).put("propname", (String)object5);
                ((SVNProperties)serializable).put("propval", (SVNPropertyValue)object);
                ((SVNLog)object4).addCommand("modify-wcprop", (SVNProperties)serializable, false);
                ((SVNProperties)serializable).clear();
            }
        }
        ((SVNLog)object4).save();
        this.runLogs();
        if (bl3) {
            object2 = this.entries(true);
            while (object2.hasNext()) {
                Object object5;
                object5 = (SVNEntry)object2.next();
                if (((SVNEntry)object5).isThisDir() || ((SVNEntry)object5).getDepth() == SVNDepth.EXCLUDE) continue;
                if (((SVNEntry)object5).getKind() == SVNNodeKind.DIR) {
                    object = this.getFile(((SVNEntry)object5).getName());
                    SVNAdminArea sVNAdminArea2 = this.getWCAccess().retrieve((File)object);
                    if (sVNAdminArea2 == null) continue;
                    sVNAdminArea2.commit(this.getThisDirName(), sVNCommitInfo, null, bl2, true, bl4, collection, iSVNCommitParameters);
                    continue;
                }
                if (((SVNEntry)object5).isScheduledForDeletion() && ((SVNEntry)(object = this.getEntry(this.getThisDirName(), true))).isScheduledForReplacement()) continue;
                this.commit(((SVNEntry)object5).getName(), sVNCommitInfo, null, bl2, false, bl4, collection, iSVNCommitParameters);
            }
        }
    }

    public void walkThisDirectory(ISVNEntryHandler iSVNEntryHandler, boolean bl2, SVNDepth sVNDepth) {
        File file = this.getRoot();
        SVNEntry sVNEntry = this.getEntry(this.getThisDirName(), bl2);
        if (sVNEntry == null) {
            iSVNEntryHandler.handleError(file, SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Directory ''{0}'' has no THIS_DIR entry", (Object)file));
            return;
        }
        try {
            iSVNEntryHandler.handleEntry(file, sVNEntry);
        }
        catch (SVNException sVNException) {
            iSVNEntryHandler.handleError(file, sVNException.getErrorMessage());
        }
        if (sVNDepth == SVNDepth.EMPTY) {
            return;
        }
        Iterator iterator = this.entries(bl2);
        while (iterator.hasNext()) {
            this.getWCAccess().checkCancelled();
            SVNEntry sVNEntry2 = (SVNEntry)iterator.next();
            if (this.getThisDirName().equals(sVNEntry2.getName())) continue;
            File file2 = this.getFile(sVNEntry2.getName());
            if (sVNEntry2.isFile() || sVNDepth.compareTo(SVNDepth.IMMEDIATES) >= 0) {
                try {
                    iSVNEntryHandler.handleEntry(file2, sVNEntry2);
                }
                catch (SVNException sVNException) {
                    iSVNEntryHandler.handleError(file2, sVNException.getErrorMessage());
                }
            }
            if (!sVNEntry2.isDirectory() || sVNEntry2.isHidden() || sVNDepth.compareTo(SVNDepth.IMMEDIATES) < 0) continue;
            SVNAdminArea sVNAdminArea = null;
            SVNDepth sVNDepth2 = sVNDepth;
            if (sVNDepth == SVNDepth.IMMEDIATES) {
                sVNDepth2 = SVNDepth.EMPTY;
            }
            try {
                sVNAdminArea = this.getWCAccess().retrieve(file2);
            }
            catch (SVNException sVNException) {
                iSVNEntryHandler.handleError(file2, sVNException.getErrorMessage());
            }
            if (sVNAdminArea == null) continue;
            sVNAdminArea.walkThisDirectory(iSVNEntryHandler, bl2, sVNDepth2);
        }
    }

    public void setCommitParameters(ISVNCommitParameters iSVNCommitParameters) {
        this.myCommitParameters = iSVNCommitParameters;
    }

    protected void setLocked(boolean bl2) {
        this.myWasLocked = bl2;
    }

    private void destroyAdminArea() {
        if (!this.isLocked()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Write-lock stolen in ''{0}''", (Object)this.getRoot());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        SVNFileUtil.deleteAll(this.getAdminDirectory(), this.getWCAccess());
        this.getWCAccess().closeAdminArea(this.getRoot());
    }

    private static void markLogProcessed(File file) {
        SVNFileUtil.setReadonly(file, false);
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file);
        }
        finally {
            if (outputStream != null) {
                SVNFileUtil.closeFile(outputStream);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean compareAndVerify(File var1_1, File var2_2, boolean var3_3, boolean var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void resolveDefaults(Map map) {
        Object object;
        SVNEntry sVNEntry = (SVNEntry)map.get("");
        if (sVNEntry == null) {
            object = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Missing default entry");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (sVNEntry.getRevision() < 0L) {
            object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_REVISION, "Default entry has no revision number");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (sVNEntry.getURL() == null) {
            object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Default entry is missing no URL");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        for (String string : map.keySet()) {
            SVNEntry sVNEntry2 = (SVNEntry)map.get(string);
            if (sVNEntry2 == null || sVNEntry2 == sVNEntry || sVNEntry2.isDirectory() || !sVNEntry2.isFile()) continue;
            if (sVNEntry2.getRevision() < 0L) {
                sVNEntry2.setRevision(sVNEntry.getRevision());
            }
            if (sVNEntry2.getURL() == null) {
                sVNEntry2.setURL(SVNPathUtil.append(sVNEntry.getURL(), SVNEncodingUtil.uriEncode(sVNEntry2.getName())));
            }
            if (sVNEntry2.getUUID() == null && !sVNEntry2.isScheduledForAddition() && !sVNEntry2.isScheduledForReplacement()) {
                sVNEntry2.setUUID(sVNEntry.getUUID());
            }
            if (sVNEntry2.getCachableProperties() != null) continue;
            sVNEntry2.setCachableProperties(sVNEntry.getCachableProperties());
        }
    }

    protected abstract SVNVersionedProperties formatBaseProperties(SVNProperties var1);

    protected abstract SVNVersionedProperties formatProperties(SVNEntry var1, SVNProperties var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFormatFile(File file, boolean bl2) {
        OutputStream outputStream = null;
        try {
            file = bl2 ? this.getAdminFile("format") : file;
            outputStream = SVNFileUtil.openFileForWriting(file);
            outputStream.write(String.valueOf(this.getFormatVersion()).getBytes("UTF-8"));
            outputStream.write(10);
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(outputStream);
                throw throwable;
            }
            SVNFileUtil.closeFile(outputStream);
        }
        SVNFileUtil.closeFile(outputStream);
    }

    public SVNAdminArea formatWC(SVNAdminArea sVNAdminArea) {
        File file = sVNAdminArea.getAdminFile("log");
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.FILE) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "Changing working copy format failed: found a log file at '" + file + "'");
            return sVNAdminArea;
        }
        SVNLog sVNLog = this.getLog();
        SVNProperties sVNProperties = new SVNProperties();
        sVNProperties.put("format", String.valueOf(this.getFormatVersion()));
        sVNLog.addCommand("upgrade-format", sVNProperties, false);
        sVNProperties.clear();
        this.setWCAccess(sVNAdminArea.getWCAccess());
        this.myEntries = new SVNHashMap();
        Map map = this.getBasePropertiesStorage(true);
        Map map2 = this.getPropertiesStorage(true);
        Iterator iterator = sVNAdminArea.entries(true);
        while (iterator.hasNext()) {
            SVNEntry sVNEntry = (SVNEntry)iterator.next();
            SVNEntry16 sVNEntry16 = new SVNEntry16(this.createEntryHashMap(sVNEntry.asMap()), this, sVNEntry.getName());
            this.myEntries.put(sVNEntry.getName(), sVNEntry16);
            if (sVNEntry.getKind() != SVNNodeKind.FILE && !sVNAdminArea.getThisDirName().equals(sVNEntry.getName())) continue;
            SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getBaseProperties(sVNEntry.getName());
            SVNVersionedProperties sVNVersionedProperties2 = this.formatBaseProperties(sVNVersionedProperties.asMap());
            map.put(sVNEntry.getName(), sVNVersionedProperties2);
            sVNVersionedProperties2.setModified(true);
            SVNVersionedProperties sVNVersionedProperties3 = sVNAdminArea.getProperties(sVNEntry.getName());
            SVNVersionedProperties sVNVersionedProperties4 = this.formatProperties(sVNEntry, sVNVersionedProperties3.asMap());
            map2.put(sVNEntry.getName(), sVNVersionedProperties4);
            sVNVersionedProperties4.setModified(true);
            this.handleCharsetProperty(sVNAdminArea, sVNLog, sVNEntry16, sVNVersionedProperties2);
            this.handlePropTime(sVNLog, sVNEntry16);
            SVNVersionedProperties sVNVersionedProperties5 = sVNAdminArea.getWCProperties(sVNEntry.getName());
            if (sVNVersionedProperties5 == null) continue;
            sVNLog.logChangedWCProperties(sVNEntry.getName(), sVNVersionedProperties5.asMap());
        }
        this.saveVersionedProperties(sVNLog, true);
        sVNLog.save();
        if (this.getFormatVersion() != 4) {
            SVNFileUtil.deleteFile(this.getAdminFile("README.txt"));
            SVNFileUtil.deleteFile(this.getAdminFile("empty-file"));
            SVNFileUtil.deleteAll(this.getAdminFile("wcprops"), true);
            SVNFileUtil.deleteAll(this.getAdminFile("tmp/wcprops"), true);
            SVNFileUtil.deleteAll(this.getAdminFile("dir-wcprops"), true);
            SVNFileUtil.deleteAll(this.getAdminFile("all-wcprops"), true);
        } else {
            this.getAdminFile("wcprops").mkdir();
            this.getAdminFile("tmp/wcprops").mkdir();
            SVNFileUtil.createEmptyFile(this.getAdminFile("empty-file"));
            SVNAdminUtil.createReadmeFile(this.getAdminDirectory());
        }
        this.runLogs();
        return this;
    }

    private void handleCharsetProperty(SVNAdminArea sVNAdminArea, SVNLog sVNLog, SVNEntry sVNEntry, SVNVersionedProperties sVNVersionedProperties) {
        SVNProperties sVNProperties = new SVNProperties();
        SVNPropertyValue sVNPropertyValue = sVNVersionedProperties.getPropertyValue("svnkit:charset");
        String string = sVNVersionedProperties.getStringPropertyValue("svn:mime-type");
        String string2 = sVNPropertyValue == null ? null : sVNPropertyValue.getString();
        if ((string2 = SVNTranslator.getCharset(string2, string, this.getAdminFile(sVNEntry.getName()).toString(), this.getWCAccess().getOptions())) != null && !SVNProperty.isUTF8(string2)) {
            File file = SVNAdminUtil.createTmpFile(this, "detranslated", ".tmp", true);
            String string3 = SVNPathUtil.getRelativePath(this.getRoot().getAbsolutePath(), file.getAbsolutePath());
            File file2 = SVNAdminUtil.createTmpFile(this, "props", ".tmp", true);
            String string4 = SVNPathUtil.getRelativePath(this.getRoot().getAbsolutePath(), file2.getAbsolutePath());
            if (this.getFormatVersion() == 9) {
                sVNVersionedProperties.setPropertyValue("svnkit:charset", SVNPropertyValue.create("UTF-8"));
                SVNWCProperties sVNWCProperties = new SVNWCProperties(file2, string4);
                sVNWCProperties.setProperties(sVNVersionedProperties.asMap());
                sVNVersionedProperties.setPropertyValue("svnkit:charset", sVNPropertyValue);
                File file3 = SVNAdminUtil.createTmpFile(this, sVNEntry.getName(), ".tmp", true);
                String string5 = SVNPathUtil.getRelativePath(this.getRoot().getAbsolutePath(), file3.getAbsolutePath());
                sVNProperties.put("name", SVNAdminUtil.getPropBasePath(sVNEntry.getName(), SVNNodeKind.FILE, false));
                sVNProperties.put("dest", string5);
                sVNLog.addCommand("cp", sVNProperties, false);
                sVNProperties.clear();
                sVNProperties.put("name", string4);
                sVNProperties.put("dest", SVNAdminUtil.getPropBasePath(sVNEntry.getName(), SVNNodeKind.FILE, false));
                sVNLog.addCommand("mv", sVNProperties, false);
                sVNProperties.clear();
                sVNProperties.put("name", sVNEntry.getName());
                sVNProperties.put("dest", string3);
                sVNLog.addCommand("cp-and-detranslate", sVNProperties, false);
                sVNProperties.clear();
                sVNProperties.put("dest", SVNAdminUtil.getPropBasePath(sVNEntry.getName(), SVNNodeKind.FILE, false));
                sVNProperties.put("name", string5);
                sVNLog.addCommand("mv", sVNProperties, false);
                sVNProperties.clear();
                sVNProperties.put("name", string3);
                sVNProperties.put("dest", sVNEntry.getName());
                sVNLog.addCommand("cp-and-translate", sVNProperties, false);
                sVNProperties.clear();
                sVNProperties.put("name", string3);
                sVNLog.addCommand("rm", sVNProperties, false);
                sVNProperties.clear();
            } else if (sVNAdminArea.getFormatVersion() == 9) {
                sVNProperties.put("name", sVNEntry.getName());
                sVNProperties.put("dest", string3);
                sVNLog.addCommand("cp-and-detranslate", sVNProperties, false);
                sVNProperties.clear();
                sVNVersionedProperties.setPropertyValue("svnkit:charset", SVNPropertyValue.create("UTF-8"));
                SVNWCProperties sVNWCProperties = new SVNWCProperties(file2, string4);
                sVNWCProperties.setProperties(sVNVersionedProperties.asMap());
                sVNVersionedProperties.setPropertyValue("svnkit:charset", sVNPropertyValue);
                sVNProperties.put("name", string4);
                sVNProperties.put("dest", SVNAdminUtil.getPropBasePath(sVNEntry.getName(), SVNNodeKind.FILE, false));
                sVNLog.addCommand("mv", sVNProperties, false);
                sVNProperties.clear();
                sVNProperties.put("name", string3);
                sVNProperties.put("dest", sVNEntry.getName());
                sVNLog.addCommand("cp-and-translate", sVNProperties, false);
                sVNProperties.clear();
                sVNProperties.put("name", string3);
                sVNLog.addCommand("rm", sVNProperties, false);
                sVNProperties.clear();
            }
        }
    }

    private void handlePropTime(SVNLog sVNLog, SVNEntry sVNEntry) {
        if (this.getFormatVersion() == 4) {
            return;
        }
        SVNProperties sVNProperties = new SVNProperties();
        sVNProperties.put("name", sVNEntry.getName());
        sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:prop-time"), SVNDate.formatDate(new Date(0L), true));
        sVNLog.addCommand("modify-entry", sVNProperties, false);
    }

    public void postUpgradeFormat(int n2) {
        if (n2 == this.getFormatVersion()) {
            this.createFormatFile(null, true);
            return;
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Unexpected format number:\n   expected: {0}\n     actual: {1}", new Object[]{this.getFormatVersion(), n2});
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    protected SVNHashMap createEntryHashMap(Map map) {
        if (this.getObjectsPool() != null) {
            return new SVNEntryHashMap(map, this.getObjectsPool());
        }
        return new SVNHashMap(map);
    }

    public SVNObjectsPool getObjectsPool() {
        return this.myWCAccess != null ? this.myWCAccess.getObjectsPool() : null;
    }
}

