/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.ISVNPropertyComparator;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties$1;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCProperties {
    public static final String SVN_HASH_TERMINATOR = "END";
    private File myFile;
    private String myPath;

    public SVNWCProperties(File file, String string) {
        this.myFile = file;
        this.myPath = string;
    }

    public File getFile() {
        return this.myFile;
    }

    public String getPath() {
        return this.myPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection properties(Collection collection) {
        Collection collection2 = collection = collection == null ? new TreeSet() : collection;
        if (this.isEmpty()) {
            return collection;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
        try {
            while (SVNWCProperties.readProperty('K', inputStream, byteArrayOutputStream)) {
                collection.add(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
                byteArrayOutputStream.reset();
                SVNWCProperties.readProperty('V', inputStream, null);
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNProperties asMap() {
        SVNProperties sVNProperties = new SVNProperties();
        if (this.isEmpty()) {
            return sVNProperties;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
        try {
            while (SVNWCProperties.readProperty('K', inputStream, byteArrayOutputStream)) {
                String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
                byteArrayOutputStream.reset();
                SVNWCProperties.readProperty('V', inputStream, byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                sVNProperties.put(string, byArray);
                byteArrayOutputStream.reset();
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read properties file ''{0}'': {1}", this.getFile(), iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
        return sVNProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareTo(SVNWCProperties sVNWCProperties, ISVNPropertyComparator iSVNPropertyComparator) {
        Object object2;
        boolean bl2 = true;
        Collection collection = this.properties(null);
        Collection collection2 = sVNWCProperties.properties(null);
        TreeSet treeSet = new TreeSet(collection);
        treeSet.removeAll(collection2);
        for (Object object2 : treeSet) {
            iSVNPropertyComparator.propertyDeleted((String)object2);
            bl2 = false;
        }
        treeSet = new TreeSet(collection2);
        treeSet.removeAll(collection);
        Object object3 = null;
        object2 = null;
        File file = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        InputStream inputStream3 = null;
        for (String string : treeSet) {
            block19: {
                try {
                    object3 = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp", true);
                    outputStream = SVNFileUtil.openFileForWriting((File)object3);
                    sVNWCProperties.getPropertyValue(string, outputStream);
                    SVNFileUtil.closeFile(outputStream);
                    inputStream = SVNFileUtil.openFileForReading((File)object3, SVNLogType.WC);
                    iSVNPropertyComparator.propertyAdded(string, inputStream, (int)((File)object3).length());
                    bl2 = false;
                    SVNFileUtil.closeFile(inputStream);
                    if (object3 == null) break block19;
                    ((File)object3).delete();
                }
                catch (Throwable throwable) {
                    if (object3 != null) {
                        ((File)object3).delete();
                    }
                    SVNFileUtil.closeFile(outputStream);
                    SVNFileUtil.closeFile(inputStream);
                    object3 = null;
                    inputStream = null;
                    outputStream = null;
                    throw throwable;
                }
            }
            SVNFileUtil.closeFile(outputStream);
            SVNFileUtil.closeFile(inputStream);
            object3 = null;
            inputStream = null;
            outputStream = null;
        }
        collection2.retainAll(collection);
        for (String string : collection2) {
            block20: {
                try {
                    object2 = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp1", true);
                    file = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp2", true);
                    outputStream = SVNFileUtil.openFileForWriting((File)object2);
                    this.getPropertyValue(string, outputStream);
                    outputStream.close();
                    outputStream = SVNFileUtil.openFileForWriting(file);
                    sVNWCProperties.getPropertyValue(string, outputStream);
                    outputStream.close();
                    if (file.length() != ((File)object2).length()) {
                        inputStream = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
                        iSVNPropertyComparator.propertyChanged(string, inputStream, (int)file.length());
                        bl2 = false;
                        SVNFileUtil.closeFile(inputStream);
                    } else {
                        inputStream2 = SVNFileUtil.openFileForReading((File)object2, SVNLogType.WC);
                        inputStream3 = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
                        boolean bl3 = false;
                        int n2 = 0;
                        while ((long)n2 < ((File)object2).length()) {
                            if (inputStream2.read() != inputStream3.read()) {
                                bl3 = true;
                                break;
                            }
                            ++n2;
                        }
                        SVNFileUtil.closeFile(inputStream2);
                        SVNFileUtil.closeFile(inputStream3);
                        if (bl3) {
                            inputStream3 = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
                            iSVNPropertyComparator.propertyChanged(string, inputStream3, (int)file.length());
                            bl2 = false;
                            SVNFileUtil.closeFile(inputStream3);
                        }
                    }
                    if (file == null) break block20;
                    file.delete();
                }
                catch (IOException iOException) {
                    block21: {
                        try {
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
                            if (file == null) break block21;
                            file.delete();
                        }
                        catch (Throwable throwable) {
                            if (file != null) {
                                file.delete();
                            }
                            if (object2 != null) {
                                ((File)object2).delete();
                            }
                            SVNFileUtil.closeFile(outputStream);
                            SVNFileUtil.closeFile(inputStream);
                            SVNFileUtil.closeFile(inputStream2);
                            SVNFileUtil.closeFile(inputStream3);
                            outputStream = null;
                            file = null;
                            object2 = null;
                            inputStream3 = null;
                            inputStream2 = null;
                            inputStream = null;
                            throw throwable;
                        }
                    }
                    if (object2 != null) {
                        ((File)object2).delete();
                    }
                    SVNFileUtil.closeFile(outputStream);
                    SVNFileUtil.closeFile(inputStream);
                    SVNFileUtil.closeFile(inputStream2);
                    SVNFileUtil.closeFile(inputStream3);
                    outputStream = null;
                    file = null;
                    object2 = null;
                    inputStream3 = null;
                    inputStream2 = null;
                    inputStream = null;
                    continue;
                }
            }
            if (object2 != null) {
                ((File)object2).delete();
            }
            SVNFileUtil.closeFile(outputStream);
            SVNFileUtil.closeFile(inputStream);
            SVNFileUtil.closeFile(inputStream2);
            SVNFileUtil.closeFile(inputStream3);
            outputStream = null;
            file = null;
            object2 = null;
            inputStream3 = null;
            inputStream2 = null;
            inputStream = null;
        }
        return bl2;
    }

    public String getPropertyValue(String string) {
        if (this.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if ((byteArrayOutputStream = (ByteArrayOutputStream)this.getPropertyValue(string, byteArrayOutputStream)) != null && byteArrayOutputStream.size() >= 0) {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            try {
                return new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byArray);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getPropertyValue(String string, OutputStream outputStream) {
        if (this.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
        try {
            while (SVNWCProperties.readProperty('K', inputStream, byteArrayOutputStream)) {
                String string2 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
                byteArrayOutputStream.reset();
                if (string2.equals(string)) {
                    SVNWCProperties.readProperty('V', inputStream, outputStream);
                    OutputStream outputStream2 = outputStream;
                    return outputStream2;
                }
                SVNWCProperties.readProperty('V', inputStream, null);
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
        return null;
    }

    public void setPropertyValue(String string, SVNPropertyValue sVNPropertyValue) {
        byte[] byArray = SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue);
        int n2 = byArray != null && byArray.length >= 0 ? byArray.length : -1;
        this.setPropertyValue(string, byArray != null ? new ByteArrayInputStream(byArray) : null, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyValue(String string, InputStream inputStream, int n2) {
        InputStream inputStream2 = null;
        OutputStream outputStream = null;
        File file = null;
        boolean bl2 = false;
        try {
            file = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp", true);
            if (!this.isEmpty()) {
                inputStream2 = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
            }
            bl2 = !SVNWCProperties.copyProperties(inputStream2, outputStream = SVNFileUtil.openFileForWriting(file), string, inputStream, n2);
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(inputStream2);
            SVNFileUtil.closeFile(outputStream);
            throw throwable;
        }
        SVNFileUtil.closeFile(inputStream2);
        SVNFileUtil.closeFile(outputStream);
        if (file != null) {
            if (!bl2) {
                SVNFileUtil.rename(file, this.getFile());
                SVNFileUtil.setReadonly(this.getFile(), true);
            } else {
                SVNFileUtil.deleteFile(file);
                SVNFileUtil.deleteFile(this.getFile());
            }
        }
    }

    public void setProperties(SVNProperties sVNProperties) {
        if (sVNProperties != null) {
            for (String string : sVNProperties.nameSet()) {
                SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string);
                this.setPropertyValue(string, sVNPropertyValue);
            }
        }
    }

    public SVNProperties compareTo(SVNWCProperties sVNWCProperties) {
        SVNProperties sVNProperties = new SVNProperties();
        this.compareTo(sVNWCProperties, new SVNWCProperties$1(this, sVNProperties));
        return sVNProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperties(SVNProperties sVNProperties, File file, File file2, String string) {
        OutputStream outputStream = null;
        try {
            if (file2 != null) {
                file2.getParentFile().mkdirs();
            } else {
                file.getParentFile().mkdirs();
            }
            outputStream = SVNFileUtil.openFileForWriting(file2 != null ? file2 : file);
            SVNWCProperties.setProperties(sVNProperties, outputStream, string);
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(outputStream);
            throw throwable;
        }
        SVNFileUtil.closeFile(outputStream);
        if (file2 != null && file != null) {
            file.getParentFile().mkdirs();
            SVNFileUtil.rename(file2, file);
        }
        if (file != null) {
            SVNFileUtil.setReadonly(file, true);
        }
    }

    public static void setProperties(SVNProperties sVNProperties, OutputStream outputStream, String string) {
        try {
            Object[] objectArray = sVNProperties.nameSet().toArray();
            Arrays.sort(objectArray);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                String string2 = (String)objectArray[i2];
                SVNWCProperties.writeProperty(outputStream, 'K', string2.getBytes("UTF-8"));
                SVNWCProperties.writeProperty(outputStream, 'V', SVNPropertyValue.getPropertyAsBytes(sVNProperties.getSVNPropertyValue(string2)));
            }
            if (string != null) {
                outputStream.write(string.getBytes("UTF-8"));
                outputStream.write(10);
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
        }
    }

    public static void appendProperty(String string, SVNPropertyValue sVNPropertyValue, OutputStream outputStream) {
        if (string == null || sVNPropertyValue == null) {
            return;
        }
        byte[] byArray = SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue);
        try {
            SVNWCProperties.writeProperty(outputStream, 'K', string.getBytes("UTF-8"));
            SVNWCProperties.writeProperty(outputStream, 'V', byArray);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
        }
    }

    public static void appendPropertyDeleted(String string, OutputStream outputStream) {
        if (string == null) {
            return;
        }
        try {
            SVNWCProperties.writeProperty(outputStream, 'D', string.getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
        }
    }

    private static boolean copyProperties(InputStream inputStream, OutputStream outputStream, String string, InputStream inputStream2, int n2) {
        int n3 = 0;
        try {
            if (inputStream != null) {
                int n4 = 0;
                while ((n4 = SVNWCProperties.readLength(inputStream, 'K')) > 0) {
                    byte[] byArray = new byte[n4];
                    SVNFileUtil.readIntoBuffer(inputStream, byArray, 0, byArray.length);
                    inputStream.read();
                    if (string.equals(new String(byArray, "UTF-8"))) {
                        SVNWCProperties.readProperty('V', inputStream, null);
                        continue;
                    }
                    SVNWCProperties.writeProperty(outputStream, 'K', byArray);
                    n4 = SVNWCProperties.readLength(inputStream, 'V');
                    SVNWCProperties.writeProperty(outputStream, 'V', inputStream, n4);
                    inputStream.read();
                    ++n3;
                }
            }
            if (inputStream2 != null && n2 >= 0) {
                byte[] byArray = string.getBytes("UTF-8");
                SVNWCProperties.writeProperty(outputStream, 'K', byArray);
                SVNWCProperties.writeProperty(outputStream, 'V', inputStream2, n2);
                ++n3;
            }
            if (n3 > 0) {
                outputStream.write(new byte[]{69, 78, 68, 10});
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
        }
        return n3 > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean readProperty(char c2, InputStream inputStream, OutputStream outputStream) {
        int n2 = SVNWCProperties.readLength(inputStream, c2);
        if (n2 < 0) {
            return false;
        }
        if (outputStream != null) {
            byte[] byArray = new byte[n2];
            int n3 = SVNFileUtil.readIntoBuffer(inputStream, byArray, 0, byArray.length);
            if (n3 < 0) return false;
            outputStream.write(byArray, 0, n3);
        } else {
            while (n2 > 0) {
                n2 = (int)((long)n2 - inputStream.skip(n2));
            }
        }
        if (inputStream.read() != 10) return false;
        return true;
    }

    private static void writeProperty(OutputStream outputStream, char c2, byte[] byArray) {
        outputStream.write((byte)c2);
        outputStream.write(32);
        outputStream.write(Integer.toString(byArray.length).getBytes("UTF-8"));
        outputStream.write(10);
        outputStream.write(byArray);
        outputStream.write(10);
    }

    private static void writeProperty(OutputStream outputStream, char c2, InputStream inputStream, int n2) {
        outputStream.write((byte)c2);
        outputStream.write(32);
        outputStream.write(Integer.toString(n2).getBytes("UTF-8"));
        outputStream.write(10);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = inputStream.read();
            outputStream.write(n3);
        }
        outputStream.write(10);
    }

    private static int readLength(InputStream inputStream, char c2) {
        byte[] byArray = new byte[255];
        int n2 = SVNFileUtil.readIntoBuffer(inputStream, byArray, 0, 4);
        if (n2 != 4) {
            throw new IOException("invalid properties file format");
        }
        if (byArray[0] == 69 && byArray[1] == 78 && byArray[2] == 68 && byArray[3] == 10) {
            return -1;
        }
        if (byArray[0] == c2 && byArray[1] == 32) {
            int n3 = 4;
            if (byArray[3] != 10) {
                while (true) {
                    int n4;
                    if ((n4 = inputStream.read()) < 0) {
                        throw new IOException("invalid properties file format");
                    }
                    if (n4 != 10) {
                        byArray[n3] = (byte)(0xFF & n4);
                        ++n3;
                        continue;
                    }
                    break;
                }
            } else {
                n3 = 3;
            }
            String string = new String(byArray, 2, n3 - 2, "UTF-8");
            return Integer.parseInt(string.trim());
        }
        throw new IOException("invalid properties file format");
    }

    public boolean isEmpty() {
        return !this.getFile().exists() || this.getFile().length() <= 4L;
    }
}

