/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager$1;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager$2;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCManager {
    public static final int SCHEDULE = 1;
    public static final int COPIED = 2;
    public static final int KEEP_LOCAL = 4;

    public static void add(File file, SVNAdminArea sVNAdminArea, SVNURL sVNURL, SVNRevision sVNRevision, SVNDepth sVNDepth) {
        SVNWCManager.add(file, sVNAdminArea, sVNURL, sVNRevision.getNumber(), sVNDepth);
    }

    public static void add(File file, SVNAdminArea sVNAdminArea, SVNURL sVNURL, long l2, SVNDepth sVNDepth) {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        SVNWCAccess sVNWCAccess = sVNAdminArea.getWCAccess();
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.NONE) {
            object4 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' not found", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
        } else if (sVNFileType == SVNFileType.UNKNOWN) {
            object4 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "Unsupported node kind for path ''{0}''", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
        }
        object4 = sVNFileType == SVNFileType.SYMLINK ? sVNWCAccess.probeTry(file.getParentFile(), true, sVNURL != null ? -1 : 0) : sVNWCAccess.probeTry(file, true, sVNURL != null ? -1 : 0);
        SVNEntry sVNEntry = null;
        if (object4 != null) {
            sVNEntry = sVNWCAccess.getEntry(file, true);
        }
        boolean bl2 = false;
        SVNNodeKind sVNNodeKind = SVNFileType.getNodeKind(sVNFileType);
        if (sVNEntry != null) {
            if (sVNURL == null && !sVNEntry.isScheduledForDeletion() && !sVNEntry.isDeleted() || sVNEntry.getDepth() == SVNDepth.EXCLUDE) {
                object3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            } else if (sVNEntry.getKind() != sVNNodeKind) {
                object3 = SVNErrorMessage.create(SVNErrorCode.WC_NODE_KIND_CHANGE, "Can''t replace ''{0}'' with a node of a different type; the deletion must be committed and the parent updated before adding ''{0}''", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            bl2 = sVNEntry.isScheduledForDeletion();
        }
        if ((object3 = sVNWCAccess.getEntry(file.getParentFile(), false)) == null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Can''t find parent directory''s entry while trying to add ''{0}''", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        if (((SVNEntry)object3).isScheduledForDeletion()) {
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t add ''{0}'' to a parent directory scheduled for deletion", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        serializable = new SVNHashMap();
        String string = file.getName();
        if (sVNURL != null) {
            if (((SVNEntry)object3).getRepositoryRoot() != null && !SVNPathUtil.isAncestor(((SVNEntry)object3).getRepositoryRoot(), sVNURL.toString())) {
                object2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "The URL ''{0}'' has a different repository root than its parent", (Object)sVNURL);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
            }
            serializable.put("svn:entry:copyfrom-url", sVNURL.toString());
            serializable.put("svn:entry:copyfrom-rev", SVNProperty.toString(l2));
            serializable.put("svn:entry:copied", Boolean.TRUE.toString());
        }
        if (bl2) {
            serializable.put("svn:entry:checksum", null);
            serializable.put("svn:entry:has-props", Boolean.FALSE.toString());
            serializable.put("svn:entry:has-prop-mods", Boolean.FALSE.toString());
        }
        serializable.put("svn:entry:schedule", "add");
        serializable.put("svn:entry:kind", SVNFileType.getNodeKind(sVNFileType).toString());
        if (!bl2 && sVNURL == null) {
            serializable.put("svn:entry:revision", "0");
        }
        sVNAdminArea.modifyEntry(string, (Map)((Object)serializable), true, false);
        if (sVNEntry != null && sVNURL == null) {
            object2 = SVNAdminUtil.getPropPath(string, sVNEntry.getKind(), false);
            object = ((SVNAdminArea)object4).getFile((String)object2);
            SVNFileUtil.deleteFile((File)object);
        }
        if (bl2) {
            object2 = new SVNProperties();
            if (sVNEntry.getKind() == SVNNodeKind.FILE) {
                object = sVNAdminArea.getLog();
                ((SVNProperties)object2).put("name", SVNAdminUtil.getTextBasePath(sVNEntry.getName(), false));
                ((SVNProperties)object2).put("dest", SVNAdminUtil.getTextRevertPath(sVNEntry.getName(), false));
                ((SVNLog)object).addCommand("mv", (SVNProperties)object2, false);
                ((SVNLog)object).save();
                sVNAdminArea.runLogs();
            }
            SVNWCManager.createRevertProperties(sVNWCAccess, file, true);
        }
        if (sVNNodeKind == SVNNodeKind.DIR) {
            boolean bl3 = false;
            if (sVNURL == null) {
                object = sVNWCAccess.getEntry(file.getParentFile(), false);
                SVNURL sVNURL2 = ((SVNEntry)object).getSVNURL().appendPath(string, false);
                SVNURL sVNURL3 = ((SVNEntry)object).getRepositoryRootURL();
                String string2 = ((SVNEntry)object).getUUID();
                bl3 = !SVNWCManager.ensureAdminAreaExists(file, sVNURL2.toString(), sVNURL3 != null ? sVNURL3.toString() : null, string2, 0L, sVNDepth == null ? SVNDepth.INFINITY : sVNDepth);
            } else {
                object = ((SVNEntry)object3).getRepositoryRootURL();
                boolean bl4 = bl3 = !SVNWCManager.ensureAdminAreaExists(file, sVNURL.toString(), object != null ? ((SVNURL)object).toString() : null, ((SVNEntry)object3).getUUID(), l2, sVNDepth == null ? SVNDepth.INFINITY : sVNDepth);
            }
            if (sVNEntry == null || sVNEntry.isDeleted() || !bl3) {
                object4 = sVNWCAccess.open(file, true, sVNURL != null ? -1 : 0);
            }
            serializable.put("svn:entry:incomplete", null);
            serializable.put("svn:entry:schedule", bl2 ? "replace" : "add");
            ((SVNAdminArea)object4).modifyEntry(((SVNAdminArea)object4).getThisDirName(), (Map)((Object)serializable), true, true);
            if (sVNURL != null) {
                object = ((SVNEntry)object3).getSVNURL().appendPath(string, false);
                SVNWCManager.updateCleanup(file, sVNWCAccess, ((SVNURL)object).toString(), ((SVNEntry)object3).getRepositoryRoot(), -1L, false, null, SVNDepth.INFINITY, false);
                SVNWCManager.markTree((SVNAdminArea)object4, null, true, false, 6);
                SVNPropertiesManager.deleteWCProperties((SVNAdminArea)object4, null, true);
            }
        }
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(string), sVNNodeKind, null, 0L, sVNURL != null ? SVNEventAction.COPY : SVNEventAction.ADD, null, null, null);
        sVNAdminArea.getWCAccess().handleEvent(sVNEvent);
    }

    public static void markEntry(SVNAdminArea sVNAdminArea, SVNEntry sVNEntry, String string, boolean bl2, boolean bl3, int n2) {
        Object object;
        if (sVNAdminArea.getThisDirName().equals(sVNEntry.getName())) {
            return;
        }
        SVNHashMap sVNHashMap = new SVNHashMap();
        File file = sVNAdminArea.getFile(sVNEntry.getName());
        if (sVNEntry.getKind() == SVNNodeKind.DIR) {
            object = sVNAdminArea.getWCAccess().retrieve(file);
            SVNWCManager.markTree((SVNAdminArea)object, string, bl2, bl3, n2);
        }
        if ((n2 & 1) != 0) {
            sVNHashMap.put("svn:entry:schedule", string);
        }
        if ((n2 & 2) != 0) {
            sVNHashMap.put("svn:entry:copied", bl2 ? Boolean.TRUE.toString() : null);
        }
        sVNAdminArea.modifyEntry(sVNEntry.getName(), sVNHashMap, true, false);
        if (bl2) {
            SVNPropertiesManager.deleteWCProperties(sVNAdminArea, sVNEntry.getName(), false);
        }
        if ("delete".equals(string)) {
            object = SVNEventFactory.createSVNEvent(file, SVNNodeKind.UNKNOWN, null, 0L, SVNEventAction.DELETE, null, null, null);
            sVNAdminArea.getWCAccess().handleEvent((SVNEvent)object);
        }
    }

    public static void markTree(SVNAdminArea sVNAdminArea, String string, boolean bl2, boolean bl3, int n2) {
        SVNEntry sVNEntry;
        Object object = sVNAdminArea.entries(false);
        while (object.hasNext()) {
            sVNEntry = (SVNEntry)object.next();
            SVNWCManager.markEntry(sVNAdminArea, sVNEntry, string, bl2, bl3, n2);
        }
        object = new SVNHashMap();
        sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
        if (!sVNEntry.isScheduledForAddition() || !"delete".equals(string)) {
            if ((n2 & 1) != 0) {
                object.put("svn:entry:schedule", string);
            }
            if ((n2 & 2) != 0) {
                object.put("svn:entry:copied", bl2 ? Boolean.TRUE.toString() : null);
            }
        }
        if ((n2 & 4) != 0 && bl3) {
            object.put("svn:entry:keep-local", SVNProperty.toString(true));
        }
        if (object.size() > 0) {
            sVNAdminArea.modifyEntry(sVNAdminArea.getThisDirName(), (Map)object, true, false);
            object.clear();
        }
        sVNAdminArea.saveEntries(false);
    }

    public static void markTreeCancellable(SVNAdminArea sVNAdminArea, String string, boolean bl2, boolean bl3, int n2) {
        Object object;
        SVNHashMap sVNHashMap = new SVNHashMap();
        SVNHashMap sVNHashMap2 = new SVNHashMap();
        Object object2 = sVNAdminArea.entries(false);
        while (object2.hasNext()) {
            SVNEntry sVNEntry = (SVNEntry)object2.next();
            if (sVNAdminArea.getThisDirName().equals(sVNEntry.getName())) continue;
            Object object3 = sVNAdminArea.getFile(sVNEntry.getName());
            if (sVNEntry.getKind() == SVNNodeKind.DIR) {
                object = sVNAdminArea.getWCAccess().retrieve((File)object3);
                sVNHashMap2.put(sVNEntry.getName(), object);
                continue;
            }
            if ((n2 & 1) != 0) {
                sVNHashMap.put("svn:entry:schedule", string);
            }
            if ((n2 & 2) != 0) {
                sVNHashMap.put("svn:entry:copied", bl2 ? Boolean.TRUE.toString() : null);
            }
            sVNAdminArea.modifyEntry(sVNEntry.getName(), sVNHashMap, true, false);
            sVNHashMap.clear();
            if (!"delete".equals(string)) continue;
            object = SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(sVNEntry.getName()), SVNNodeKind.UNKNOWN, null, 0L, SVNEventAction.DELETE, null, null, null);
            sVNAdminArea.getWCAccess().handleEvent((SVNEvent)object);
        }
        object2 = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
        if (!((SVNEntry)object2).isScheduledForAddition() || !"delete".equals(string)) {
            if ((n2 & 1) != 0) {
                sVNHashMap.put("svn:entry:schedule", string);
            }
            if ((n2 & 2) != 0) {
                sVNHashMap.put("svn:entry:copied", bl2 ? Boolean.TRUE.toString() : null);
            }
            if (bl3) {
                sVNHashMap.put("svn:entry:keep-local", SVNProperty.toString(true));
            }
            sVNAdminArea.modifyEntry(sVNAdminArea.getThisDirName(), sVNHashMap, true, false);
            sVNHashMap.clear();
        }
        sVNAdminArea.saveEntries(false);
        sVNAdminArea.getWCAccess().checkCancelled();
        for (Object object3 : sVNHashMap2.keySet()) {
            object = (SVNAdminArea)sVNHashMap2.get(object3);
            if ((n2 & 1) != 0) {
                sVNHashMap.put("svn:entry:schedule", string);
            }
            if ((n2 & 2) != 0) {
                sVNHashMap.put("svn:entry:copied", bl2 ? Boolean.TRUE.toString() : null);
            }
            sVNAdminArea.modifyEntry((String)object3, sVNHashMap, true, false);
            sVNHashMap.clear();
            if ("delete".equals(string)) {
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNAdminArea.getFile((String)object3), SVNNodeKind.UNKNOWN, null, 0L, SVNEventAction.DELETE, null, null, null);
                sVNAdminArea.getWCAccess().handleEvent(sVNEvent);
            }
            sVNAdminArea.saveEntries(false);
            SVNWCManager.markTree((SVNAdminArea)object, string, bl2, bl3, n2);
        }
    }

    public static void updateCleanup(File file, SVNWCAccess sVNWCAccess, String string, String string2, long l2, boolean bl2, Collection collection, SVNDepth sVNDepth, boolean bl3) {
        SVNEntry sVNEntry = sVNWCAccess.getEntry(file, true);
        if (sVNEntry == null) {
            return;
        }
        Collection collection2 = collection = collection == null ? Collections.EMPTY_LIST : collection;
        if (sVNEntry.isFile() || sVNEntry.isDirectory() && (sVNEntry.isAbsent() || sVNEntry.isDeleted() || sVNEntry.getDepth() == SVNDepth.EXCLUDE)) {
            if (collection.contains(file)) {
                return;
            }
            SVNAdminArea sVNAdminArea = sVNWCAccess.retrieve(file.getParentFile());
            if (bl3 && !sVNAdminArea.isLocked()) {
                return;
            }
            if (sVNAdminArea.tweakEntry(file.getName(), string, string2, l2, false)) {
                sVNAdminArea.saveEntries(false);
            }
        } else if (sVNEntry.isDirectory()) {
            SVNAdminArea sVNAdminArea = sVNWCAccess.retrieve(file);
            if (bl3 && !sVNAdminArea.isLocked()) {
                return;
            }
            SVNWCManager.tweakEntries(sVNAdminArea, string, string2, l2, bl2, collection, sVNDepth, bl3);
        } else {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unrecognized node kind: ''{0}''", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    private static void tweakEntries(SVNAdminArea sVNAdminArea, String string, String string2, long l2, boolean bl2, Collection collection, SVNDepth sVNDepth, boolean bl3) {
        if (collection.contains(sVNAdminArea.getRoot())) {
            return;
        }
        boolean bl4 = false;
        bl4 = sVNAdminArea.tweakEntry(sVNAdminArea.getThisDirName(), string, string2, l2, false);
        if (sVNDepth == SVNDepth.UNKNOWN) {
            sVNDepth = SVNDepth.INFINITY;
        }
        if (sVNDepth.compareTo(SVNDepth.EMPTY) > 0) {
            Iterator iterator = sVNAdminArea.entries(true);
            while (iterator.hasNext()) {
                SVNEntry sVNEntry = (SVNEntry)iterator.next();
                if (sVNAdminArea.getThisDirName().equals(sVNEntry.getName())) continue;
                File file = sVNAdminArea.getFile(sVNEntry.getName());
                boolean bl5 = collection.contains(file);
                String string3 = null;
                if (string != null) {
                    string3 = SVNPathUtil.append(string, SVNEncodingUtil.uriEncode(sVNEntry.getName()));
                }
                if (sVNEntry.isFile() || sVNEntry.isAbsent() || sVNEntry.isDeleted() || sVNEntry.getDepth() == SVNDepth.EXCLUDE) {
                    if (bl5) continue;
                    bl4 |= sVNAdminArea.tweakEntry(sVNEntry.getName(), string3, string2, l2, true);
                    continue;
                }
                if (!sVNEntry.isDirectory() || sVNDepth != SVNDepth.INFINITY && sVNDepth != SVNDepth.IMMEDIATES) continue;
                SVNDepth sVNDepth2 = sVNDepth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : sVNDepth;
                File file2 = sVNAdminArea.getFile(sVNEntry.getName());
                if (bl2 && sVNAdminArea.getWCAccess().isMissing(file2)) {
                    if (sVNEntry.isScheduledForAddition() || bl5) continue;
                    sVNAdminArea.deleteEntry(sVNEntry.getName());
                    sVNAdminArea.getWCAccess().handleEvent(SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(sVNEntry.getName()), sVNEntry.getKind(), null, sVNEntry.getRevision(), SVNEventAction.UPDATE_DELETE, null, null, null));
                    continue;
                }
                SVNAdminArea sVNAdminArea2 = sVNAdminArea.getWCAccess().retrieve(file2);
                if (bl3 && !sVNAdminArea2.isLocked()) continue;
                SVNWCManager.tweakEntries(sVNAdminArea2, string3, string2, l2, bl2, collection, sVNDepth2, bl3);
            }
        }
        if (bl4) {
            sVNAdminArea.saveEntries(false);
        }
    }

    public static boolean ensureAdminAreaExists(File file, String string, String string2, String string3, long l2, SVNDepth sVNDepth) {
        Object object;
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType != SVNFileType.DIRECTORY && sVNFileType != SVNFileType.NONE) {
            object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' is not a directory", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (sVNFileType == SVNFileType.NONE) {
            SVNAdminAreaFactory.createVersionedDirectory(file, string, string2, string3, l2, sVNDepth);
            return true;
        }
        object = SVNWCAccess.newInstance(null);
        try {
            ((SVNWCAccess)object).open(file, false, 0);
            SVNEntry sVNEntry = ((SVNWCAccess)object).getVersionedEntry(file, false);
            if (!sVNEntry.isScheduledForDeletion()) {
                SVNErrorMessage sVNErrorMessage;
                if (sVNEntry.getRevision() != l2) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Revision {0} doesn''t match existing revision {1} in ''{2}''", l2, sVNEntry.getRevision(), file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                if (!sVNEntry.getURL().equals(string)) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "URL {0} doesn''t match existing URL {1} in ''{2}''", string, sVNEntry.getURL(), file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
            }
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                SVNAdminAreaFactory.createVersionedDirectory(file, string, string2, string3, l2, sVNDepth);
                boolean bl2 = true;
                return bl2;
            }
            throw sVNException;
        }
        finally {
            ((SVNWCAccess)object).close();
        }
        return false;
    }

    public static void canDelete(File file, ISVNOptions iSVNOptions, ISVNEventHandler iSVNEventHandler) {
        SVNStatusClient sVNStatusClient = new SVNStatusClient((ISVNAuthenticationManager)null, iSVNOptions);
        if (iSVNEventHandler != null) {
            sVNStatusClient.setEventHandler(new SVNWCManager$1(iSVNEventHandler));
        }
        sVNStatusClient.doStatus(file, SVNRevision.UNDEFINED, SVNDepth.INFINITY, false, false, false, false, new SVNWCManager$2(), null);
    }

    public static void delete(SVNWCAccess sVNWCAccess, SVNAdminArea sVNAdminArea, File file, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        SVNAdminArea sVNAdminArea2 = sVNWCAccess.probeTry(file, true, -1);
        SVNEntry sVNEntry = null;
        if (sVNAdminArea2 == null) {
            SVNWCManager.doDeleteUnversionedFiles(sVNWCAccess, file, bl2);
            return;
        }
        sVNEntry = sVNWCAccess.getEntry(file, false);
        if (sVNEntry == null) {
            SVNWCManager.doDeleteUnversionedFiles(sVNWCAccess, file, bl2);
            return;
        }
        if (sVNEntry.getExternalFilePath() != null) {
            Object object3;
            String string = sVNAdminArea2.getProperties(sVNAdminArea2.getThisDirName()).getStringPropertyValue("svn:externals");
            String string2 = sVNEntry.getName();
            if (string != null) {
                object3 = SVNExternal.parseExternals("", string);
                for (int i2 = 0; i2 < ((SVNExternal[])object3).length; ++i2) {
                    if (!string2.equals(object3[i2].getPath())) continue;
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CANNOT_DELETE_FILE_EXTERNAL, "Cannot remove the file external at ''{0}''; please propedit or propdel the svn:externals description that created it", (Object)file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
            }
            sVNAdminArea2.removeFromRevisionControl(string2, bl2, false);
            object3 = SVNEventFactory.createSVNEvent(file, SVNNodeKind.UNKNOWN, null, 0L, SVNEventAction.DELETE, null, null, null);
            sVNWCAccess.handleEvent((SVNEvent)object3);
            return;
        }
        String string = sVNEntry.getSchedule();
        SVNNodeKind sVNNodeKind = sVNEntry.getKind();
        boolean bl4 = sVNEntry.isCopied();
        boolean bl5 = false;
        String string3 = file.getName();
        if (sVNNodeKind == SVNNodeKind.DIR) {
            object2 = sVNWCAccess.retrieve(file.getParentFile());
            object = ((SVNAdminArea)object2).getEntry(string3, true);
            boolean bl6 = bl5 = object != null ? ((SVNEntry)object).isDeleted() : false;
            if (!bl5 && "add".equals(string)) {
                if (sVNAdminArea2 != sVNAdminArea) {
                    sVNAdminArea2.removeFromRevisionControl("", false, false);
                } else {
                    ((SVNAdminArea)object2).deleteEntry(string3);
                    ((SVNAdminArea)object2).saveEntries(false);
                }
            } else if (sVNAdminArea2 != sVNAdminArea) {
                if (bl3) {
                    SVNWCManager.markTreeCancellable(sVNAdminArea2, "delete", false, !bl2, 1);
                } else {
                    SVNWCManager.markTree(sVNAdminArea2, "delete", false, !bl2, 5);
                }
            }
        }
        if (sVNNodeKind != SVNNodeKind.DIR || !"add".equals(string) || bl5) {
            object2 = sVNAdminArea.getLog();
            object = new SVNProperties();
            ((SVNProperties)object).put("name", string3);
            ((SVNProperties)object).put(SVNProperty.shortPropertyName("svn:entry:schedule"), "delete");
            ((SVNLog)object2).addCommand("modify-entry", (SVNProperties)object, false);
            ((SVNProperties)object).clear();
            if ("replace".equals(string) && bl4) {
                if (sVNNodeKind != SVNNodeKind.DIR) {
                    ((SVNProperties)object).put("name", SVNAdminUtil.getTextRevertPath(string3, false));
                    ((SVNProperties)object).put("dest", SVNAdminUtil.getTextBasePath(string3, false));
                    ((SVNLog)object2).addCommand("mv", (SVNProperties)object, false);
                    ((SVNProperties)object).clear();
                }
                ((SVNProperties)object).put("name", SVNAdminUtil.getPropRevertPath(string3, sVNNodeKind, false));
                ((SVNProperties)object).put("dest", SVNAdminUtil.getPropBasePath(string3, sVNNodeKind, false));
                ((SVNLog)object2).addCommand("mv", (SVNProperties)object, false);
                ((SVNProperties)object).clear();
            }
            if ("add".equals(string)) {
                ((SVNProperties)object).put("name", SVNAdminUtil.getPropPath(string3, sVNNodeKind, false));
                ((SVNLog)object2).addCommand("rm", (SVNProperties)object, false);
                ((SVNProperties)object).clear();
                ((SVNProperties)object).put("name", SVNAdminUtil.getPropBasePath(string3, sVNNodeKind, false));
                ((SVNLog)object2).addCommand("rm", (SVNProperties)object, false);
                ((SVNProperties)object).clear();
                ((SVNProperties)object).put("name", SVNAdminUtil.getTextBasePath(string3, false));
                ((SVNLog)object2).addCommand("rm", (SVNProperties)object, false);
                ((SVNProperties)object).clear();
            }
            ((SVNLog)object2).save();
            sVNAdminArea.runLogs();
        }
        object2 = SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(string3), SVNNodeKind.UNKNOWN, null, 0L, SVNEventAction.DELETE, null, null, null);
        sVNWCAccess.handleEvent((SVNEvent)object2);
        if ("add".equals(string)) {
            SVNWCManager.doDeleteUnversionedFiles(sVNWCAccess, file, bl2);
        } else {
            SVNWCManager.doEraseFromWC(file, sVNAdminArea, sVNNodeKind, bl2);
        }
    }

    public static void doDeleteUnversionedFiles(SVNWCAccess sVNWCAccess, File file, boolean bl2) {
        sVNWCAccess.checkCancelled();
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.NONE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "''{0}'' does not exist", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        } else if (sVNFileType != SVNFileType.FILE && sVNFileType != SVNFileType.DIRECTORY && sVNFileType != SVNFileType.SYMLINK) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unsupported node kind for path ''{0}''", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (bl2) {
            SVNFileUtil.deleteAll(file, true, sVNWCAccess.getEventHandler());
        }
    }

    public static void doEraseFromWC(File file, SVNAdminArea sVNAdminArea, SVNNodeKind sVNNodeKind, boolean bl2) {
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.NONE) {
            return;
        }
        sVNAdminArea.getWCAccess().checkCancelled();
        if (sVNNodeKind == SVNNodeKind.FILE) {
            if (bl2) {
                SVNFileUtil.deleteFile(file);
            }
        } else if (sVNNodeKind == SVNNodeKind.DIR) {
            SVNAdminArea sVNAdminArea2 = null;
            try {
                sVNAdminArea2 = sVNAdminArea.getWCAccess().retrieve(file);
            }
            catch (SVNException sVNException) {
                if (!file.exists()) {
                    return;
                }
                throw sVNException;
            }
            SVNHashSet sVNHashSet = new SVNHashSet();
            File[] fileArray = sVNAdminArea2.entries(false);
            while (fileArray.hasNext()) {
                SVNEntry sVNEntry = (SVNEntry)fileArray.next();
                sVNHashSet.add(sVNEntry.getName());
                if (sVNAdminArea2.getThisDirName().equals(sVNEntry.getName())) continue;
                File file2 = sVNAdminArea2.getFile(sVNEntry.getName());
                SVNWCManager.doEraseFromWC(file2, sVNAdminArea2, sVNEntry.getKind(), bl2);
            }
            fileArray = SVNFileListUtil.listFiles(file);
            for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
                if (SVNFileUtil.getAdminDirectoryName().equals(fileArray[i2].getName()) || sVNHashSet.contains(fileArray[i2].getName())) continue;
                SVNWCManager.doDeleteUnversionedFiles(sVNAdminArea.getWCAccess(), fileArray[i2], bl2);
            }
        }
    }

    public static void addRepositoryFile(SVNAdminArea sVNAdminArea, String string, File file, File file2, SVNProperties sVNProperties, SVNProperties sVNProperties2, String string2, long l2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        SVNEntry sVNEntry = sVNAdminArea.getVersionedEntry(sVNAdminArea.getThisDirName(), false);
        String string3 = SVNPathUtil.append(sVNEntry.getURL(), SVNEncodingUtil.uriEncode(string));
        if (string2 != null && sVNEntry.getRepositoryRoot() != null && !SVNPathUtil.isAncestor(sVNEntry.getRepositoryRoot(), string2)) {
            object4 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Copyfrom-url ''{0}'' has different repository root than ''{1}''", string2, sVNEntry.getRepositoryRoot());
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
        }
        object4 = sVNAdminArea.getEntry(string, false);
        SVNLog sVNLog = sVNAdminArea.getLog();
        SVNProperties sVNProperties3 = new SVNProperties();
        if (object4 != null && ((SVNEntry)object4).isScheduledForDeletion()) {
            object3 = SVNAdminUtil.getTextRevertPath(string, false);
            object2 = SVNAdminUtil.getTextBasePath(string, false);
            object = SVNAdminUtil.getPropRevertPath(string, SVNNodeKind.FILE, false);
            String string4 = SVNAdminUtil.getPropBasePath(string, SVNNodeKind.FILE, false);
            sVNProperties3.put("name", (String)object2);
            sVNProperties3.put("dest", (String)object3);
            sVNLog.addCommand("mv", sVNProperties3, false);
            sVNProperties3.clear();
            if (sVNAdminArea.getFile(string4).isFile()) {
                sVNProperties3.put("name", string4);
                sVNProperties3.put("dest", (String)object);
                sVNLog.addCommand("mv", sVNProperties3, false);
                sVNProperties3.clear();
            } else {
                String string5 = SVNAdminUtil.getPropBasePath(string, SVNNodeKind.FILE, false);
                SVNWCProperties.setProperties(new SVNProperties(), null, sVNAdminArea.getFile(string5), "END");
                sVNProperties3.put("name", string5);
                sVNProperties3.put("dest", (String)object);
                sVNLog.addCommand("mv", sVNProperties3, false);
                sVNProperties3.clear();
            }
        }
        object3 = new SVNProperties();
        ((SVNProperties)object3).put(SVNProperty.shortPropertyName("svn:entry:schedule"), "add");
        if (string2 != null) {
            ((SVNProperties)object3).put(SVNProperty.shortPropertyName("svn:entry:copied"), SVNProperty.toString(true));
            ((SVNProperties)object3).put(SVNProperty.shortPropertyName("svn:entry:copyfrom-url"), string2);
            ((SVNProperties)object3).put(SVNProperty.shortPropertyName("svn:entry:copyfrom-rev"), SVNProperty.toString(l2));
        }
        sVNLog.logChangedEntryProperties(string, (SVNProperties)object3);
        ((SVNProperties)object3).clear();
        sVNLog.logTweakEntry(string, string3, object4 != null ? ((SVNEntry)object4).getRevision() : sVNEntry.getRevision());
        SVNWCManager.addProperties(sVNAdminArea, string, sVNProperties, true, sVNLog);
        SVNWCManager.addProperties(sVNAdminArea, string, sVNProperties2, false, sVNLog);
        object2 = sVNAdminArea.getBaseFile(string, true);
        if (!((File)object2).equals(file2) && file2 != null) {
            SVNFileUtil.rename(file2, (File)object2);
        }
        if (file != null) {
            object = SVNFileUtil.createUniqueFile(sVNAdminArea.getRoot(), string, ".tmp", false);
            SVNFileUtil.rename(file, (File)object);
            if (sVNProperties != null && sVNProperties.containsName("svn:special")) {
                sVNProperties3.put("name", ((File)object).getName());
                sVNProperties3.put("dest", string);
                sVNProperties3.put("arg1", "true");
                sVNLog.addCommand("cp", sVNProperties3, false);
                sVNProperties3.clear();
                sVNProperties3.put("name", ((File)object).getName());
                sVNLog.addCommand("rm", sVNProperties3, false);
                sVNProperties3.clear();
            } else {
                sVNProperties3.put("name", ((File)object).getName());
                sVNProperties3.put("dest", string);
                sVNLog.addCommand("mv", sVNProperties3, false);
                sVNProperties3.clear();
            }
        } else {
            sVNProperties3.put("name", SVNAdminUtil.getTextBasePath(string, true));
            sVNProperties3.put("dest", string);
            sVNLog.addCommand("cp-and-translate", sVNProperties3, false);
            sVNProperties3.clear();
            sVNProperties3.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
            sVNProperties3.put(SVNProperty.shortPropertyName("svn:entry:working-size"), "working");
            sVNLog.logChangedEntryProperties(string, sVNProperties3);
            sVNProperties3.clear();
        }
        sVNProperties3.put("name", SVNAdminUtil.getTextBasePath(string, true));
        sVNProperties3.put("dest", SVNAdminUtil.getTextBasePath(string, false));
        sVNLog.addCommand("mv", sVNProperties3, false);
        sVNProperties3.clear();
        sVNProperties3.put("name", SVNAdminUtil.getTextBasePath(string, false));
        sVNLog.addCommand("readonly", sVNProperties3, false);
        sVNProperties3.clear();
        object = SVNFileUtil.computeChecksum(sVNAdminArea.getBaseFile(string, true));
        ((SVNProperties)object3).put(SVNProperty.shortPropertyName("svn:entry:checksum"), (String)object);
        sVNLog.logChangedEntryProperties(string, (SVNProperties)object3);
        ((SVNProperties)object3).clear();
        sVNLog.save();
        sVNAdminArea.runLogs();
    }

    public static void addProperties(SVNAdminArea sVNAdminArea, String string, SVNProperties sVNProperties, boolean bl2, SVNLog sVNLog) {
        if (sVNProperties == null || sVNProperties.isEmpty()) {
            return;
        }
        SVNProperties sVNProperties2 = new SVNProperties();
        SVNProperties sVNProperties3 = new SVNProperties();
        SVNProperties sVNProperties4 = new SVNProperties();
        for (Object object : sVNProperties.nameSet()) {
            Object object2 = sVNProperties.getSVNPropertyValue((String)object);
            if (SVNProperty.isEntryProperty((String)object)) {
                sVNProperties3.put(SVNProperty.shortPropertyName((String)object), (SVNPropertyValue)object2);
                continue;
            }
            if (SVNProperty.isWorkingCopyProperty((String)object)) {
                sVNProperties4.put((String)object, (SVNPropertyValue)object2);
                continue;
            }
            sVNProperties2.put((String)object, (SVNPropertyValue)object2);
        }
        SVNVersionedProperties sVNVersionedProperties = bl2 ? sVNAdminArea.getBaseProperties(string) : sVNAdminArea.getProperties(string);
        sVNVersionedProperties.removeAll();
        for (Object object2 : sVNProperties2.nameSet()) {
            SVNPropertyValue sVNPropertyValue = sVNProperties2.getSVNPropertyValue((String)object2);
            sVNVersionedProperties.setPropertyValue((String)object2, sVNPropertyValue);
        }
        sVNAdminArea.saveVersionedProperties(sVNLog, false);
        sVNLog.logChangedEntryProperties(string, sVNProperties3);
        sVNLog.logChangedWCProperties(string, sVNProperties4);
    }

    public static boolean isEntrySwitched(File file, SVNEntry sVNEntry) {
        Object object;
        File file2 = (file = new File(SVNPathUtil.validateFilePath(file.getAbsolutePath())).getAbsoluteFile()).getParentFile();
        if (file2 == null) {
            return false;
        }
        SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(null);
        SVNAdminArea sVNAdminArea = null;
        SVNEntry sVNEntry2 = null;
        try {
            sVNAdminArea = sVNWCAccess.open(file2, false, 0);
            sVNEntry2 = sVNAdminArea.getVersionedEntry(sVNAdminArea.getThisDirName(), false);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                boolean bl2 = false;
                return bl2;
            }
            throw sVNException;
        }
        finally {
            sVNWCAccess.close();
        }
        SVNURL sVNURL = sVNEntry2.getSVNURL();
        SVNURL sVNURL2 = sVNEntry.getSVNURL();
        if (sVNURL == null || sVNURL2 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Cannot find a URL for ''{0}''", (Object)(sVNURL == null ? file2 : file));
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        return !sVNURL2.equals(object = sVNURL.appendPath(file.getName(), false));
    }

    public static void crop(SVNAdminAreaInfo sVNAdminAreaInfo, SVNDepth sVNDepth) {
        Object object;
        SVNEntry sVNEntry;
        Object object2;
        if (sVNDepth == SVNDepth.INFINITY) {
            return;
        }
        if (sVNDepth.compareTo(SVNDepth.EXCLUDE) < 0 || sVNDepth.compareTo(SVNDepth.INFINITY) >= 0) {
            object2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Can only crop a working copy with a restrictive depth");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        object2 = sVNAdminAreaInfo.getWCAccess();
        File file = sVNAdminAreaInfo.getAnchor().getRoot();
        if (!"".equals(sVNAdminAreaInfo.getTargetName())) {
            file = new File(file, sVNAdminAreaInfo.getTargetName());
        }
        if ((sVNEntry = ((SVNWCAccess)object2).getEntry(file, false)) == null || !sVNEntry.isDirectory()) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Can only crop directories");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (sVNEntry.isScheduledForDeletion()) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot crop ''{0}'': it is going to be removed from repository. Try commit instead", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (sVNDepth == SVNDepth.EXCLUDE) {
            boolean bl2;
            Object object3;
            SVNURL sVNURL;
            if (file.getParentFile() == null) {
                object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot exclude root directory");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object = ((SVNWCAccess)object2).getAdminArea(file.getParentFile());
            SVNEntry sVNEntry2 = null;
            if (object == null) {
                try {
                    object = ((SVNWCAccess)object2).probeOpen(file.getParentFile(), false, 0);
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
            }
            if (object != null) {
                sVNEntry2 = ((SVNWCAccess)object2).getEntry(file.getParentFile(), false);
            }
            if (sVNEntry2 != null && !(sVNURL = sVNEntry2.getSVNURL().appendPath(file.getName(), false)).equals(sVNEntry.getSVNURL())) {
                object3 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot crop ''{0}'': it is a switched path", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            boolean bl3 = bl2 = !sVNEntry.isScheduledForAddition() && !sVNEntry.isScheduledForReplacement() || sVNEntry.isCopied();
            if (sVNEntry2 != null && bl2 && sVNEntry2.getDepth().compareTo(SVNDepth.FILES) > 0) {
                object3 = ((SVNAdminArea)object).getEntry(file.getName(), false);
                ((SVNEntry)object3).setDepth(SVNDepth.EXCLUDE);
                ((SVNAdminArea)object).saveEntries(true);
            }
            object3 = ((SVNWCAccess)object2).retrieve(file);
            try {
                ((SVNAdminArea)object3).removeFromRevisionControl(((SVNAdminArea)object3).getThisDirName(), true, false);
            }
            catch (SVNException sVNException) {
                SVNWCManager.handleLeftLocalModificationsError(sVNException);
            }
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_DELETE, null, null, null);
            ((SVNWCAccess)object2).handleEvent(sVNEvent);
            return;
        }
        SVNWCManager.cropChildren((SVNWCAccess)object2, file, sVNDepth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActualTarget(File file) {
        try (SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(null);){
            SVNNodeKind sVNNodeKind;
            sVNWCAccess.probeOpen(file, false, 0);
            boolean bl2 = sVNWCAccess.isWCRoot(file);
            SVNEntry sVNEntry = sVNWCAccess.getEntry(file, false);
            SVNNodeKind sVNNodeKind2 = sVNNodeKind = sVNEntry != null ? sVNEntry.getKind() : SVNNodeKind.FILE;
            if (sVNNodeKind == SVNNodeKind.FILE || !bl2) {
                String string = file.getName();
                return string;
            }
        }
        return "";
    }

    public static void createRevertProperties(SVNWCAccess sVNWCAccess, File file, boolean bl2) {
        SVNEntry sVNEntry = sVNWCAccess.getVersionedEntry(file, false);
        String string = SVNAdminUtil.getPropRevertPath(sVNEntry.getName(), sVNEntry.getKind(), false);
        String string2 = SVNAdminUtil.getPropBasePath(sVNEntry.getName(), sVNEntry.getKind(), false);
        SVNAdminArea sVNAdminArea = sVNEntry.getAdminArea();
        SVNLog sVNLog = sVNAdminArea.getLog();
        File file2 = sVNAdminArea.getFile(string2);
        if (file2.isFile()) {
            SVNProperties sVNProperties = new SVNProperties();
            sVNProperties.put("name", string2);
            sVNProperties.put("dest", string);
            if (bl2) {
                sVNLog.addCommand("mv", sVNProperties, false);
            } else {
                sVNLog.addCommand("cp", sVNProperties, false);
            }
        } else {
            String string3 = SVNAdminUtil.getPropRevertPath(sVNEntry.getName(), sVNEntry.getKind(), true);
            File file3 = sVNAdminArea.getFile(string3);
            SVNWCProperties.setProperties(new SVNProperties(), file3, null, "END");
            SVNProperties sVNProperties = new SVNProperties();
            sVNProperties.put("name", string3);
            sVNProperties.put("dest", string);
            sVNLog.addCommand("mv", sVNProperties, false);
        }
        sVNLog.save();
        sVNAdminArea.runLogs();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void cropChildren(SVNWCAccess sVNWCAccess, File file, SVNDepth sVNDepth) {
        SVNAdminArea sVNAdminArea = sVNWCAccess.retrieve(file);
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
        if (sVNEntry.getDepth().compareTo(sVNDepth) > 0) {
            sVNEntry.setDepth(sVNDepth);
            sVNAdminArea.saveEntries(false);
        }
        Iterator iterator = sVNAdminArea.entries(true);
        while (true) {
            Object object;
            File file2;
            SVNEntry sVNEntry2;
            block13: {
                if (!iterator.hasNext()) {
                    return;
                }
                sVNEntry2 = (SVNEntry)iterator.next();
                if (sVNEntry2.isThisDir()) continue;
                file2 = new File(file, sVNEntry2.getName());
                if (sVNEntry2.isFile()) {
                    if (sVNDepth != SVNDepth.EMPTY) continue;
                    try {
                        sVNAdminArea.removeFromRevisionControl(sVNEntry2.getName(), true, false);
                    }
                    catch (SVNException sVNException) {
                        SVNWCManager.handleLeftLocalModificationsError(sVNException);
                    }
                } else {
                    if (sVNEntry2.isDirectory()) {
                        if (sVNEntry2.getDepth() == SVNDepth.EXCLUDE) {
                            if (sVNDepth.compareTo(SVNDepth.IMMEDIATES) >= 0) continue;
                            sVNAdminArea.deleteEntry(sVNEntry2.getName());
                            sVNAdminArea.saveEntries(false);
                            continue;
                        }
                        if (sVNDepth.compareTo(SVNDepth.IMMEDIATES) < 0) {
                            object = sVNWCAccess.retrieve(file2);
                            try {
                                ((SVNAdminArea)object).removeFromRevisionControl(((SVNAdminArea)object).getThisDirName(), true, false);
                            }
                            catch (SVNException sVNException) {
                                SVNWCManager.handleLeftLocalModificationsError(sVNException);
                            }
                            break block13;
                        } else {
                            SVNWCManager.cropChildren(sVNWCAccess, file2, SVNDepth.EMPTY);
                            continue;
                        }
                    }
                    object = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown entry kind for ''{0}''", (Object)file2);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                }
            }
            object = SVNEventFactory.createSVNEvent(file2, sVNEntry2.getKind(), null, -1L, SVNEventAction.UPDATE_DELETE, null, null, null);
            sVNWCAccess.handleEvent((SVNEvent)object);
        }
    }

    private static void handleLeftLocalModificationsError(SVNException sVNException) {
        SVNException sVNException2 = null;
        sVNException2 = sVNException;
        while (sVNException2 != null && sVNException2.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            sVNException2 = sVNException2.getCause() instanceof SVNException ? (SVNException)sVNException2.getCause() : null;
        }
        if (sVNException2 != null) {
            return;
        }
        throw sVNException;
    }
}

