/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNFileFetcher;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor15$SVNDirectoryInfo;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor15$SVNFileInfo;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNCleanupHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNUpdateEditor15
implements ISVNUpdateEditor,
ISVNCleanupHandler {
    private String mySwitchURL;
    private String myTarget;
    private String myTargetURL;
    private String myRootURL;
    private SVNAdminAreaInfo myAdminInfo;
    private SVNUpdateEditor15$SVNDirectoryInfo myCurrentDirectory;
    private SVNUpdateEditor15$SVNFileInfo myCurrentFile;
    private long myTargetRevision;
    private boolean myIsRootOpen;
    private boolean myIsTargetDeleted;
    private boolean myIsUnversionedObstructionsAllowed;
    private boolean myIsDepthSticky;
    private Collection mySkippedPaths;
    private SVNWCAccess myWCAccess;
    private SVNDeltaProcessor myDeltaProcessor;
    private SVNDepth myRequestedDepth;
    private String[] myExtensionPatterns;
    private ISVNFileFetcher myFileFetcher;
    private boolean myIsLockOnDemand;

    private SVNUpdateEditor15(SVNAdminAreaInfo sVNAdminAreaInfo, String string, boolean bl2, boolean bl3, SVNDepth sVNDepth, String[] stringArray, String string2, String string3, ISVNFileFetcher iSVNFileFetcher, boolean bl4) {
        this.myAdminInfo = sVNAdminAreaInfo;
        this.myWCAccess = sVNAdminAreaInfo.getWCAccess();
        this.myIsUnversionedObstructionsAllowed = bl2;
        this.myTarget = sVNAdminAreaInfo.getTargetName();
        this.mySwitchURL = string;
        this.myTargetRevision = -1L;
        this.myRequestedDepth = sVNDepth;
        this.myIsDepthSticky = bl3;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myExtensionPatterns = stringArray;
        this.myFileFetcher = iSVNFileFetcher;
        this.myTargetURL = string2;
        this.myRootURL = string3;
        this.myIsLockOnDemand = bl4;
        if (this.myTarget != null) {
            this.myTargetURL = SVNPathUtil.append(this.myTargetURL, SVNEncodingUtil.uriEncode(this.myTarget));
        }
        if ("".equals(this.myTarget)) {
            this.myTarget = null;
        }
    }

    @Override
    public void targetRevision(long l2) {
        this.myTargetRevision = l2;
    }

    @Override
    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    @Override
    public void openRoot(long l2) {
        this.myIsRootOpen = true;
        this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
        this.myWCAccess.registerCleanupHandler(this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory);
        if (this.myTarget == null) {
            SVNAdminArea sVNAdminArea = this.myCurrentDirectory.getAdminArea();
            SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
            if (sVNEntry != null) {
                this.myCurrentDirectory.myAmbientDepth = sVNEntry.getDepth();
                this.myCurrentDirectory.myPreviousRevision = sVNEntry.getRevision();
            }
            SVNHashMap sVNHashMap = new SVNHashMap();
            sVNHashMap.put("svn:entry:revision", Long.toString(this.myTargetRevision));
            sVNHashMap.put("svn:entry:url", this.myCurrentDirectory.URL);
            sVNHashMap.put("svn:entry:incomplete", Boolean.TRUE.toString());
            if (this.myRootURL != null && SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
                sVNHashMap.put("svn:entry:repos", this.myRootURL);
            }
            sVNAdminArea.modifyEntry(sVNAdminArea.getThisDirName(), sVNHashMap, true, false);
            if (this.mySwitchURL != null) {
                this.clearWCProperty(this.myCurrentDirectory.getAdminArea(), null);
            }
        } else if (this.mySwitchURL != null) {
            if (this.myAdminInfo.getTarget() == this.myAdminInfo.getAnchor()) {
                this.clearWCProperty(this.myAdminInfo.getTarget(), this.myTarget);
            } else {
                this.clearWCProperty(this.myAdminInfo.getTarget(), null);
            }
        }
    }

    @Override
    public void deleteEntry(String string, long l2) {
        Object object;
        this.checkIfPathIsUnderRoot(string);
        String string2 = SVNPathUtil.tail(string);
        SVNAdminArea sVNAdminArea = this.myCurrentDirectory.getAdminArea();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(string2, true);
        if (sVNEntry == null) {
            return;
        }
        SVNLog sVNLog = this.myCurrentDirectory.getLog();
        SVNProperties sVNProperties = new SVNProperties();
        sVNProperties.put("name", string2);
        sVNLog.addCommand("delete-entry", sVNProperties, false);
        SVNNodeKind sVNNodeKind = sVNEntry.getKind();
        long l3 = sVNEntry.getRevision();
        boolean bl2 = sVNEntry.isDeleted();
        SVNURL sVNURL = sVNEntry.getSVNURL();
        if (string.equals(this.myTarget)) {
            sVNProperties.put("name", string2);
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:kind"), sVNNodeKind == SVNNodeKind.DIR ? "dir" : "file");
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:revision"), Long.toString(this.myTargetRevision));
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:deleted"), Boolean.TRUE.toString());
            sVNLog.addCommand("modify-entry", sVNProperties, false);
            this.myIsTargetDeleted = true;
        }
        try {
            this.myCurrentDirectory.flushLog();
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage().wrap("Error writing log file for ''{0}''", this.myCurrentDirectory.getPath());
            SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.WC);
        }
        if (this.myIsLockOnDemand && sVNNodeKind == SVNNodeKind.DIR && (object = this.myWCAccess.getAdminArea(sVNAdminArea.getFile(string2))) != null && !((SVNAdminArea)object).isLocked()) {
            ((SVNAdminArea)object).lock(false);
        }
        if (this.mySwitchURL != null && sVNNodeKind == SVNNodeKind.DIR) {
            object = this.myWCAccess.retrieve(sVNAdminArea.getFile(string2));
            try {
                ((SVNAdminArea)object).removeFromRevisionControl(((SVNAdminArea)object).getThisDirName(), true, true);
            }
            catch (SVNException sVNException) {
                this.handleLeftLocalModificationsError(sVNException);
            }
        }
        try {
            this.myCurrentDirectory.runLogs();
        }
        catch (SVNException sVNException) {
            this.handleLeftLocalModificationsError(sVNException);
        }
        if (bl2) {
            return;
        }
        object = SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(string2), sVNNodeKind, null, -1L, SVNEventAction.UPDATE_DELETE, null, null, null);
        ((SVNEvent)object).setPreviousRevision(l3);
        ((SVNEvent)object).setPreviousURL(sVNURL);
        this.myWCAccess.handleEvent((SVNEvent)object);
    }

    private void handleLeftLocalModificationsError(SVNException sVNException) {
        SVNException sVNException2 = null;
        sVNException2 = sVNException;
        while (sVNException2 != null && sVNException2.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            sVNException2 = sVNException2.getCause() instanceof SVNException ? (SVNException)sVNException2.getCause() : null;
        }
        if (sVNException2 != null) {
            return;
        }
        throw sVNException;
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        Object object;
        Object object2;
        Object object3;
        SVNAdminArea sVNAdminArea = this.myCurrentDirectory.getAdminArea();
        SVNUpdateEditor15$SVNDirectoryInfo sVNUpdateEditor15$SVNDirectoryInfo = this.myCurrentDirectory;
        this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, string, true);
        this.myCurrentDirectory.myPreviousRevision = -1L;
        this.myCurrentDirectory.myAmbientDepth = string.equals(this.myTarget) ? (this.myRequestedDepth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : this.myRequestedDepth) : (this.myRequestedDepth == SVNDepth.IMMEDIATES || this.myRequestedDepth == SVNDepth.UNKNOWN && sVNUpdateEditor15$SVNDirectoryInfo.myAmbientDepth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : SVNDepth.INFINITY);
        sVNUpdateEditor15$SVNDirectoryInfo.flushLog();
        this.checkIfPathIsUnderRoot(string);
        String string3 = SVNPathUtil.tail(string);
        File file = sVNAdminArea.getFile(string3);
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.UNKNOWN) {
            object3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': a non-directory object of the same name already exists", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
        }
        if (sVNFileType == SVNFileType.DIRECTORY) {
            SVNErrorMessage sVNErrorMessage;
            object3 = null;
            try {
                object3 = SVNWCAccess.newInstance(null).open(file, false, 0);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                    throw sVNException;
                }
                if (this.myIsUnversionedObstructionsAllowed) {
                    this.myCurrentDirectory.isExisted = true;
                }
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': an unversioned directory of the same name already exists", (Object)this.myCurrentDirectory.getPath());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            if (object3 != null) {
                object2 = ((SVNAdminArea)object3).getEntry(((SVNAdminArea)object3).getThisDirName(), false);
                if (object2 != null && ((SVNEntry)object2).isScheduledForAddition() && !((SVNEntry)object2).isCopied()) {
                    this.myCurrentDirectory.isAddExisted = true;
                } else {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': a versioned directory of the same name already exists", (Object)this.myCurrentDirectory.getPath());
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
            }
        }
        if (SVNFileUtil.getAdminDirectoryName().equals(string3)) {
            object3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'':  object of the same name as the administrative directory", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
        }
        if (string2 != null || SVNRevision.isValidRevisionNumber(l2)) {
            object3 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Failed to add directory ''{0}'': copyfrom arguments not yet supported", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
        }
        object3 = sVNAdminArea.getEntry(string3, false);
        object2 = new SVNHashMap();
        object2.put("svn:entry:kind", "dir");
        object2.put("svn:entry:absent", null);
        object2.put("svn:entry:deleted", null);
        boolean bl2 = false;
        if (this.myCurrentDirectory.isAddExisted) {
            object2.put("svn:entry:schedule", null);
            bl2 = true;
        }
        object3 = sVNAdminArea.modifyEntry(string3, (Map)object2, true, bl2);
        if (this.myCurrentDirectory.isAddExisted) {
            object2.put("svn:entry:revision", Long.toString(this.myTargetRevision));
            if (this.mySwitchURL != null) {
                object2.put("svn:entry:url", this.myCurrentDirectory.URL);
            }
            object = this.myCurrentDirectory.getAdminArea();
            ((SVNAdminArea)object).modifyEntry(((SVNAdminArea)object).getThisDirName(), (Map)object2, true, true);
        }
        object = null;
        if (SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
            object = this.myRootURL;
        }
        if (this.myWCAccess.getAdminArea(file) != null) {
            this.myWCAccess.closeAdminArea(file);
        }
        if (SVNWCManager.ensureAdminAreaExists(file, this.myCurrentDirectory.URL, (String)object, null, this.myTargetRevision, this.myCurrentDirectory.myAmbientDepth)) {
            SVNFileUtil.deleteFile(new File(file, SVNFileUtil.getAdminDirectoryName() + "/lock"));
        }
        SVNAdminArea sVNAdminArea2 = this.myWCAccess.open(file, true, 0);
        this.myWCAccess.registerCleanupHandler(sVNAdminArea2, this.myCurrentDirectory);
        if (!this.myCurrentDirectory.isAddExisted) {
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(((SVNEntry)object3).getName()), SVNNodeKind.DIR, null, this.myTargetRevision, this.myCurrentDirectory.isExisted ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_ADD, null, null, null);
            sVNEvent.setPreviousRevision(this.myCurrentDirectory.myPreviousRevision);
            sVNEvent.setPreviousURL(((SVNEntry)object3).getSVNURL());
            sVNEvent.setURL(this.myCurrentDirectory.URL != null ? SVNURL.parseURIEncoded(this.myCurrentDirectory.URL) : null);
            this.myWCAccess.handleEvent(sVNEvent);
        }
    }

    @Override
    public void openDir(String string, long l2) {
        this.myCurrentDirectory.flushLog();
        this.checkIfPathIsUnderRoot(string);
        this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, string, false);
        SVNAdminArea sVNAdminArea = this.myCurrentDirectory.getAdminArea();
        this.myWCAccess.registerCleanupHandler(sVNAdminArea, this.myCurrentDirectory);
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), true);
        if (sVNEntry != null) {
            this.myCurrentDirectory.myPreviousRevision = sVNEntry.getRevision();
            this.myCurrentDirectory.myAmbientDepth = sVNEntry.getDepth();
            boolean bl2 = sVNAdminArea.hasPropConflict(sVNAdminArea.getThisDirName());
            if (bl2) {
                this.myCurrentDirectory.isSkipped = true;
                Collection collection = this.getSkippedPaths();
                collection.add(sVNAdminArea.getRoot());
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNAdminArea.getRoot(), SVNNodeKind.DIR, null, this.myTargetRevision, SVNStatusType.INAPPLICABLE, SVNStatusType.CONFLICTED, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.SKIP, SVNEventAction.UPDATE_UPDATE, null, null);
                sVNEvent.setPreviousRevision(sVNEntry.getRevision());
                sVNEvent.setURL(sVNEntry.getSVNURL());
                this.myWCAccess.handleEvent(sVNEvent);
                return;
            }
        } else {
            this.myCurrentDirectory.myPreviousRevision = -1L;
        }
        SVNHashMap sVNHashMap = new SVNHashMap();
        sVNHashMap.put("svn:entry:revision", Long.toString(this.myTargetRevision));
        sVNHashMap.put("svn:entry:url", this.myCurrentDirectory.URL);
        sVNHashMap.put("svn:entry:incomplete", Boolean.TRUE.toString());
        if (this.myRootURL != null && SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
            sVNHashMap.put("svn:entry:repos", this.myRootURL);
        }
        sVNEntry = sVNAdminArea.modifyEntry(sVNAdminArea.getThisDirName(), sVNHashMap, true, false);
        if (this.mySwitchURL != null) {
            this.clearWCProperty(this.myCurrentDirectory.getAdminArea(), null);
        }
    }

    private Collection getSkippedPaths() {
        if (this.mySkippedPaths == null) {
            this.mySkippedPaths = new LinkedList();
        }
        return this.mySkippedPaths;
    }

    @Override
    public void absentDir(String string) {
        this.absentEntry(string, SVNNodeKind.DIR);
    }

    @Override
    public void absentFile(String string) {
        this.absentEntry(string, SVNNodeKind.FILE);
    }

    private void absentEntry(String string, SVNNodeKind sVNNodeKind) {
        Serializable serializable;
        String string2 = SVNPathUtil.tail(string);
        SVNAdminArea sVNAdminArea = this.myCurrentDirectory.getAdminArea();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(string2, false);
        if (sVNEntry != null && sVNEntry.isScheduledForAddition()) {
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to mark ''{0}'' absent: item of the same name is already scheduled for addition", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        serializable = new SVNHashMap();
        serializable.put("svn:entry:revision", Long.toString(this.myTargetRevision));
        serializable.put("svn:entry:kind", sVNNodeKind.toString());
        serializable.put("svn:entry:deleted", null);
        serializable.put("svn:entry:absent", Boolean.TRUE.toString());
        sVNEntry = sVNAdminArea.modifyEntry(string2, (Map)((Object)serializable), true, false);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (!this.myCurrentDirectory.isSkipped) {
            this.myCurrentDirectory.propertyChanged(string, sVNPropertyValue);
        }
    }

    private void clearWCProperty(SVNAdminArea sVNAdminArea, String string) {
        if (sVNAdminArea == null) {
            return;
        }
        Iterator iterator = sVNAdminArea.entries(false);
        while (iterator.hasNext()) {
            Object object;
            SVNEntry sVNEntry = (SVNEntry)iterator.next();
            if (string != null) {
                if (!sVNEntry.isFile() || !string.equals(sVNEntry.getName())) continue;
                object = sVNAdminArea.getWCProperties(sVNEntry.getName());
                ((SVNVersionedProperties)object).setPropertyValue("svn:wc:ra_dav:version-url", null);
                sVNAdminArea.saveWCProperties(false);
                continue;
            }
            if (sVNEntry.isFile() || sVNAdminArea.getThisDirName().equals(sVNEntry.getName())) {
                object = sVNAdminArea.getWCProperties(sVNEntry.getName());
                ((SVNVersionedProperties)object).setPropertyValue("svn:wc:ra_dav:version-url", null);
                sVNAdminArea.saveWCProperties(false);
                continue;
            }
            object = this.myAdminInfo.getWCAccess().getAdminArea(sVNAdminArea.getFile(sVNEntry.getName()));
            this.clearWCProperty((SVNAdminArea)object, null);
        }
    }

    @Override
    public void closeDir() {
        Object object;
        Object object2;
        SVNProperties sVNProperties = this.myCurrentDirectory.getChangedWCProperties();
        SVNProperties sVNProperties2 = this.myCurrentDirectory.getChangedEntryProperties();
        SVNProperties sVNProperties3 = this.myCurrentDirectory.getChangedProperties();
        SVNStatusType sVNStatusType = SVNStatusType.UNKNOWN;
        SVNAdminArea sVNAdminArea = this.myCurrentDirectory.getAdminArea();
        if (this.myAdminInfo.isIncomplete(this.myCurrentDirectory.getPath())) {
            object2 = sVNAdminArea.getBaseProperties(sVNAdminArea.getThisDirName());
            object = ((SVNVersionedProperties)object2).asMap();
            if (sVNProperties3 == null) {
                sVNProperties3 = new SVNProperties();
            }
            for (Object object3 : ((SVNProperties)object).nameSet()) {
                if (sVNProperties3.containsName((String)object3)) continue;
                sVNProperties3.put((String)object3, SVNPropertyValue.create(null));
            }
        }
        if (sVNProperties != null || sVNProperties2 != null || sVNProperties3 != null) {
            object2 = this.myCurrentDirectory.getLog();
            if (sVNProperties3 != null && !sVNProperties3.isEmpty()) {
                Object object3;
                if (sVNProperties3.containsName("svn:externals")) {
                    object = sVNAdminArea.getProperties(sVNAdminArea.getThisDirName()).getStringPropertyValue("svn:externals");
                    String string = sVNProperties3.getStringValue("svn:externals");
                    object3 = this.myCurrentDirectory.getPath();
                    if (object == null && string != null) {
                        this.myAdminInfo.addExternal((String)object3, (String)object, string);
                        this.myAdminInfo.addDepth((String)object3, this.myCurrentDirectory.myAmbientDepth);
                    } else if (object != null && string == null) {
                        this.myAdminInfo.addExternal((String)object3, (String)object, string);
                        this.myAdminInfo.addDepth((String)object3, this.myCurrentDirectory.myAmbientDepth);
                    } else if (object != null && !((String)object).equals(string)) {
                        this.myAdminInfo.addExternal((String)object3, (String)object, string);
                        this.myAdminInfo.addDepth((String)object3, this.myCurrentDirectory.myAmbientDepth);
                    }
                }
                object = sVNAdminArea.getBaseProperties(sVNAdminArea.getThisDirName());
                try {
                    sVNStatusType = sVNAdminArea.mergeProperties(sVNAdminArea.getThisDirName(), ((SVNVersionedProperties)object).asMap(), sVNProperties3, null, null, true, false, (SVNLog)object2);
                }
                catch (SVNException sVNException) {
                    object3 = sVNException.getErrorMessage().wrap("Couldn't do property merge");
                    SVNErrorManager.error((SVNErrorMessage)object3, sVNException, SVNLogType.WC);
                }
            }
            ((SVNLog)object2).logChangedEntryProperties(sVNAdminArea.getThisDirName(), sVNProperties2);
            ((SVNLog)object2).logChangedWCProperties(sVNAdminArea.getThisDirName(), sVNProperties);
        }
        this.myCurrentDirectory.flushLog();
        this.myCurrentDirectory.runLogs();
        this.maybeBumpDirInfo(this.myCurrentDirectory);
        if (!(this.myCurrentDirectory.isSkipped || !this.myCurrentDirectory.isAddExisted && this.myCurrentDirectory.IsAdded || sVNAdminArea == this.myAdminInfo.getAnchor() && !"".equals(this.myAdminInfo.getTargetName()))) {
            Object object4 = object2 = this.myCurrentDirectory.isAddExisted || this.myCurrentDirectory.isExisted ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_UPDATE;
            if (sVNStatusType == SVNStatusType.UNKNOWN && object2 != SVNEventAction.UPDATE_EXISTS) {
                object2 = SVNEventAction.UPDATE_NONE;
            }
            object = SVNEventFactory.createSVNEvent(sVNAdminArea.getRoot(), SVNNodeKind.DIR, null, this.myTargetRevision, SVNStatusType.UNKNOWN, sVNStatusType, null, (SVNEventAction)object2, null, null, null);
            ((SVNEvent)object).setPreviousRevision(this.myCurrentDirectory.myPreviousRevision);
            ((SVNEvent)object).setURL(this.myCurrentDirectory.URL != null ? SVNURL.parseURIEncoded(this.myCurrentDirectory.URL) : null);
            this.myWCAccess.handleEvent((SVNEvent)object);
        }
        this.myCurrentDirectory = this.myCurrentDirectory.Parent;
    }

    @Override
    public SVNCommitInfo closeEdit() {
        if (this.myTarget != null && this.myWCAccess.isMissing(this.myAdminInfo.getAnchor().getFile(this.myTarget))) {
            this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
            this.myWCAccess.registerCleanupHandler(this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory);
            this.deleteEntry(this.myTarget, this.myTargetRevision);
        }
        if (!this.myIsRootOpen) {
            if (this.myCurrentDirectory == null) {
                this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
            }
            this.completeDirectory(this.myCurrentDirectory);
        }
        if (!this.myIsTargetDeleted) {
            File file = this.myTarget != null ? this.myAdminInfo.getAnchor().getFile(this.myTarget) : this.myAdminInfo.getAnchor().getRoot();
            SVNWCManager.updateCleanup(file, this.myWCAccess, this.mySwitchURL, this.myRootURL, this.myTargetRevision, true, this.mySkippedPaths, this.myRequestedDepth, this.myIsLockOnDemand);
        }
        return null;
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        this.myCurrentFile = this.addFile(this.myCurrentDirectory, string, string2, l2);
    }

    @Override
    public void openFile(String string, long l2) {
        this.myCurrentFile = this.openFile(string, this.myCurrentDirectory);
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        this.changeFileProperty(string2, sVNPropertyValue, this.myCurrentFile);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        Serializable serializable;
        String string3;
        if (this.myCurrentFile.isSkipped) {
            return;
        }
        this.myCurrentFile.receivedTextDelta = true;
        SVNAdminArea sVNAdminArea = this.myCurrentFile.getAdminArea();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(this.myCurrentFile.Name, false);
        boolean bl2 = sVNEntry != null && sVNEntry.isScheduledForReplacement();
        boolean bl3 = bl2;
        if (bl3) {
            this.myCurrentFile.baseFile = sVNAdminArea.getFile(SVNAdminUtil.getTextRevertPath(this.myCurrentFile.Name, false));
            this.myCurrentFile.newBaseFile = sVNAdminArea.getFile(SVNAdminUtil.getTextRevertPath(this.myCurrentFile.Name, true));
        } else {
            this.myCurrentFile.baseFile = sVNAdminArea.getBaseFile(this.myCurrentFile.Name, false);
            this.myCurrentFile.newBaseFile = sVNAdminArea.getBaseFile(this.myCurrentFile.Name, true);
        }
        String string4 = string3 = sVNEntry != null ? sVNEntry.getChecksum() : null;
        if (!bl2 && string2 != null && string3 != null && !string2.equals(string3)) {
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch for ''{0}''; expected: ''{1}'', recorded: ''{2}''", this.myCurrentFile.baseFile, string2, string3);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        serializable = null;
        if (!this.myCurrentFile.IsAdded) {
            serializable = this.myCurrentFile.baseFile;
        } else if (SVNUpdateEditor15$SVNFileInfo.access$000(this.myCurrentFile) != null) {
            serializable = SVNUpdateEditor15$SVNFileInfo.access$000(this.myCurrentFile);
        }
        if (bl2 || string3 == null) {
            string3 = string2;
        }
        File file = this.myCurrentFile.newBaseFile;
        if (string3 != null) {
            this.myCurrentFile.expectedSrcChecksum = string3;
            InputStream inputStream = serializable != null && serializable.exists() ? SVNFileUtil.openFileForReading(serializable) : SVNFileUtil.DUMMY_IN;
            SVNUpdateEditor15$SVNFileInfo.access$102(this.myCurrentFile, inputStream != SVNFileUtil.DUMMY_IN ? new SVNChecksumInputStream(inputStream, "MD5") : null);
            this.myDeltaProcessor.applyTextDelta(SVNUpdateEditor15$SVNFileInfo.access$100(this.myCurrentFile) != null ? SVNUpdateEditor15$SVNFileInfo.access$100(this.myCurrentFile) : inputStream, file, true);
        } else {
            this.myDeltaProcessor.applyTextDelta((File)serializable, file, true);
        }
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        if (!this.myCurrentFile.isSkipped) {
            try {
                this.myDeltaProcessor.textDeltaChunk(sVNDiffWindow);
            }
            catch (SVNException sVNException) {
                this.myDeltaProcessor.textDeltaEnd();
                SVNFileUtil.deleteFile(this.myCurrentFile.newBaseFile);
                this.myCurrentFile.newBaseFile = null;
                throw sVNException;
            }
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String string) {
        if (!this.myCurrentFile.isSkipped) {
            this.myCurrentFile.Checksum = this.myDeltaProcessor.textDeltaEnd();
        }
        if (this.myCurrentFile.expectedSrcChecksum != null) {
            String string2;
            String string3 = string2 = SVNUpdateEditor15$SVNFileInfo.access$100(this.myCurrentFile) != null ? SVNUpdateEditor15$SVNFileInfo.access$100(this.myCurrentFile).getDigest() : null;
            if (!this.myCurrentFile.expectedSrcChecksum.equals(string2)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch while updating ''{0}''; expected: ''{1}'', actual: ''{2}''", this.myCurrentFile.baseFile, this.myCurrentFile.expectedSrcChecksum, string2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        }
    }

    @Override
    public void closeFile(String string, String string2) {
        this.closeFile(string2, this.myCurrentFile, this.myCurrentDirectory);
        this.myCurrentFile = null;
    }

    @Override
    public void abortEdit() {
    }

    private void checkIfPathIsUnderRoot(String string) {
        if (SVNFileUtil.isWindows && string != null) {
            String string2 = string.replace(File.separatorChar, '/');
            int n2 = -1;
            while (string2.length() > 0 && (n2 = string2.indexOf("..")) != -1) {
                if (n2 == 0 || string2.charAt(n2 - 1) == '/') {
                    SVNErrorMessage sVNErrorMessage;
                    int n3;
                    for (n3 = n2 + 2; n3 < string2.length(); ++n3) {
                        if (string2.charAt(n3) == '.') continue;
                        if (string2.charAt(n3) != '/') break;
                        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' is not in the working copy", (Object)string);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    if (n3 == string2.length()) {
                        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' is not in the working copy", (Object)string);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    string2 = string2.substring(n3);
                    continue;
                }
                string2 = string2.substring(n2 + 2);
            }
        }
    }

    private void maybeBumpDirInfo(SVNUpdateEditor15$SVNDirectoryInfo sVNUpdateEditor15$SVNDirectoryInfo) {
        while (sVNUpdateEditor15$SVNDirectoryInfo != null) {
            --sVNUpdateEditor15$SVNDirectoryInfo.RefCount;
            if (sVNUpdateEditor15$SVNDirectoryInfo.RefCount > 0) {
                return;
            }
            if (!sVNUpdateEditor15$SVNDirectoryInfo.isSkipped) {
                this.completeDirectory(sVNUpdateEditor15$SVNDirectoryInfo);
            }
            sVNUpdateEditor15$SVNDirectoryInfo = sVNUpdateEditor15$SVNDirectoryInfo.Parent;
        }
    }

    private void completeDirectory(SVNUpdateEditor15$SVNDirectoryInfo sVNUpdateEditor15$SVNDirectoryInfo) {
        Object object;
        Serializable serializable;
        if (sVNUpdateEditor15$SVNDirectoryInfo.Parent == null && this.myTarget != null) {
            return;
        }
        SVNAdminArea sVNAdminArea = sVNUpdateEditor15$SVNDirectoryInfo.getAdminArea();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), true);
        if (sVNEntry == null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No ''.'' entry found in ''{0}''", (Object)sVNAdminArea.getRoot());
            SVNErrorManager.error(serializable, SVNLogType.WC);
        }
        sVNEntry.setIncomplete(false);
        if (!this.myIsDepthSticky && sVNEntry.isThisDir() && this.myRequestedDepth == SVNDepth.IMMEDIATES) {
            int n2 = SVNPathUtil.getSegmentsCount(sVNUpdateEditor15$SVNDirectoryInfo.getPath());
            if (this.myTarget != null && !"".equals(this.myTarget)) {
                --n2;
            }
            if (n2 > 0 && ((object = sVNUpdateEditor15$SVNDirectoryInfo.myAmbientDepth) == null || object == SVNDepth.UNKNOWN || ((SVNDepth)object).compareTo(SVNDepth.EMPTY) > 0)) {
                sVNEntry.setIncomplete(true);
            }
        }
        serializable = this.myAdminInfo.getTarget().getRoot();
        if (this.myIsDepthSticky && (this.myRequestedDepth == SVNDepth.INFINITY || sVNAdminArea.getRoot().equals(serializable) && this.myRequestedDepth.compareTo(sVNEntry.getDepth()) > 0)) {
            sVNEntry.setDepth(this.myRequestedDepth);
            this.myAdminInfo.addDepth(sVNUpdateEditor15$SVNDirectoryInfo.getPath(), this.myRequestedDepth);
        }
        object = sVNAdminArea.entries(true);
        while (object.hasNext()) {
            SVNEntry sVNEntry2 = (SVNEntry)object.next();
            if (sVNEntry2.isDeleted()) {
                if (!sVNEntry2.isScheduledForAddition()) {
                    sVNAdminArea.deleteEntry(sVNEntry2.getName());
                    continue;
                }
                SVNHashMap sVNHashMap = new SVNHashMap();
                sVNHashMap.put("svn:entry:deleted", null);
                sVNAdminArea.modifyEntry(sVNEntry2.getName(), sVNHashMap, false, false);
                continue;
            }
            if (sVNEntry2.isAbsent() && sVNEntry2.getRevision() != this.myTargetRevision) {
                sVNAdminArea.deleteEntry(sVNEntry2.getName());
                continue;
            }
            if (sVNEntry2.getKind() != SVNNodeKind.DIR || !this.myWCAccess.isMissing(sVNAdminArea.getFile(sVNEntry2.getName())) || sVNEntry2.isAbsent() || sVNEntry2.isScheduledForAddition()) continue;
            sVNAdminArea.deleteEntry(sVNEntry2.getName());
            this.myWCAccess.handleEvent(SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(sVNEntry2.getName()), sVNEntry2.getKind(), null, sVNEntry2.getRevision(), SVNEventAction.UPDATE_DELETE, null, null, null));
        }
        sVNAdminArea.saveEntries(true);
    }

    private SVNUpdateEditor15$SVNFileInfo addFile(SVNUpdateEditor15$SVNDirectoryInfo sVNUpdateEditor15$SVNDirectoryInfo, String string, String string2, long l2) {
        if (string2 != null || SVNRevision.isValidRevisionNumber(l2)) {
            if (string2 == null || !SVNRevision.isValidRevisionNumber(l2)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "Bad copyfrom arguments received.");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            }
            return this.addFileWithHistory(sVNUpdateEditor15$SVNDirectoryInfo, string, string2, l2);
        }
        this.checkIfPathIsUnderRoot(string);
        SVNUpdateEditor15$SVNFileInfo sVNUpdateEditor15$SVNFileInfo = this.createFileInfo(sVNUpdateEditor15$SVNDirectoryInfo, string, true);
        SVNAdminArea sVNAdminArea = sVNUpdateEditor15$SVNDirectoryInfo.getAdminArea();
        SVNFileType sVNFileType = SVNFileType.getType(sVNAdminArea.getFile(sVNUpdateEditor15$SVNFileInfo.Name));
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNUpdateEditor15$SVNFileInfo.Name, true);
        if (sVNFileType != SVNFileType.NONE) {
            if (this.myIsUnversionedObstructionsAllowed || sVNEntry != null && sVNEntry.isScheduledForAddition()) {
                SVNErrorMessage sVNErrorMessage;
                if (sVNEntry != null && sVNEntry.isCopied()) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': a file of the same name is already scheduled for addition with history", (Object)string);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                if (sVNFileType != SVNFileType.FILE) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': a non-file object of the same name already exists", (Object)string);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                if (sVNEntry != null) {
                    sVNUpdateEditor15$SVNFileInfo.isAddExisted = true;
                } else {
                    sVNUpdateEditor15$SVNFileInfo.isExisted = true;
                }
            } else {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': object of the same name already exists", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        }
        return sVNUpdateEditor15$SVNFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNUpdateEditor15$SVNFileInfo addFileWithHistory(SVNUpdateEditor15$SVNDirectoryInfo sVNUpdateEditor15$SVNDirectoryInfo, String string, String string2, long l2) {
        SVNProperties sVNProperties;
        SVNProperties sVNProperties2;
        SVNUpdateEditor15$SVNFileInfo sVNUpdateEditor15$SVNFileInfo;
        block14: {
            Object object;
            block13: {
                SVNEntry sVNEntry;
                SVNAdminArea sVNAdminArea;
                block11: {
                    sVNUpdateEditor15$SVNFileInfo = this.addFile(sVNUpdateEditor15$SVNDirectoryInfo, string, null, -1L);
                    sVNUpdateEditor15$SVNFileInfo.addedWithHistory = true;
                    sVNAdminArea = sVNUpdateEditor15$SVNDirectoryInfo.getAdminArea();
                    SVNEntry sVNEntry2 = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
                    sVNEntry = null;
                    try {
                        sVNEntry = this.locateCopyFrom(string2, l2, sVNAdminArea.getRoot(), sVNEntry2);
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND) break block11;
                        throw sVNException;
                    }
                }
                SVNUpdateEditor15$SVNFileInfo.access$002(sVNUpdateEditor15$SVNFileInfo, SVNAdminUtil.createTmpFile(sVNAdminArea));
                sVNProperties2 = null;
                sVNProperties = null;
                if (sVNEntry == null) break block13;
                SVNAdminArea sVNAdminArea2 = sVNEntry.getAdminArea();
                String string3 = null;
                if (sVNEntry.isScheduledForReplacement() && sVNEntry.getCopyFromURL() != null) {
                    string3 = SVNAdminUtil.getTextRevertPath(sVNEntry.getName(), false);
                    sVNProperties = sVNProperties2 = sVNAdminArea2.getRevertProperties(sVNEntry.getName()).asMap();
                } else {
                    string3 = SVNAdminUtil.getTextBasePath(sVNEntry.getName(), false);
                    sVNProperties2 = sVNAdminArea2.getBaseProperties(sVNEntry.getName()).asMap();
                    sVNProperties = sVNAdminArea2.getProperties(sVNEntry.getName()).asMap();
                }
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    inputStream = SVNFileUtil.openFileForReading(sVNAdminArea2.getFile(string3));
                    outputStream = SVNFileUtil.openFileForWriting(SVNUpdateEditor15$SVNFileInfo.access$000(sVNUpdateEditor15$SVNFileInfo));
                    SVNChecksumOutputStream sVNChecksumOutputStream = new SVNChecksumOutputStream(outputStream, "MD5", true);
                    outputStream = sVNChecksumOutputStream;
                    FSRepositoryUtil.copy(inputStream, outputStream, this.myWCAccess);
                    sVNUpdateEditor15$SVNFileInfo.copiedBaseChecksum = sVNChecksumOutputStream.getDigest();
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(inputStream);
                    SVNFileUtil.closeFile(outputStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile(inputStream);
                SVNFileUtil.closeFile(outputStream);
                if (sVNAdminArea2.hasTextModifications(sVNEntry.getName(), false, true, false)) {
                    SVNUpdateEditor15$SVNFileInfo.access$202(sVNUpdateEditor15$SVNFileInfo, SVNAdminUtil.createTmpFile(sVNAdminArea));
                    SVNFileUtil.copyFile(sVNAdminArea2.getFile(sVNEntry.getName()), SVNUpdateEditor15$SVNFileInfo.access$200(sVNUpdateEditor15$SVNFileInfo), true);
                }
                break block14;
            }
            if (this.myFileFetcher == null) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "No fetch_func supplied to update_editor.");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
            }
            sVNProperties2 = new SVNProperties();
            object = null;
            try {
                object = SVNFileUtil.openFileForWriting(SVNUpdateEditor15$SVNFileInfo.access$000(sVNUpdateEditor15$SVNFileInfo));
                SVNChecksumOutputStream sVNChecksumOutputStream = new SVNChecksumOutputStream((OutputStream)object, "MD5", true);
                object = sVNChecksumOutputStream;
                this.myFileFetcher.fetchFile(string2, l2, (OutputStream)object, sVNProperties2);
                sVNUpdateEditor15$SVNFileInfo.copiedBaseChecksum = sVNChecksumOutputStream.getDigest();
            }
            finally {
                SVNFileUtil.closeFile((OutputStream)object);
            }
            sVNProperties = sVNProperties2;
        }
        SVNUpdateEditor15$SVNFileInfo.access$302(sVNUpdateEditor15$SVNFileInfo, sVNProperties2.getRegularProperties());
        SVNUpdateEditor15$SVNFileInfo.access$402(sVNUpdateEditor15$SVNFileInfo, sVNProperties.getRegularProperties());
        return sVNUpdateEditor15$SVNFileInfo;
    }

    private SVNEntry locateCopyFrom(String string, long l2, File file, SVNEntry sVNEntry) {
        Object object;
        Object object2;
        if (sVNEntry.getRepositoryRoot() == null || sVNEntry.getURL() == null) {
            object2 = SVNErrorMessage.create(SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND, "Destination directory of add-with-history is missing a URL");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        file = new File(SVNPathUtil.validateFilePath(file.getAbsolutePath())).getAbsoluteFile();
        object2 = SVNPathUtil.getPathAsChild(sVNEntry.getRepositoryRootURL().toDecodedString(), sVNEntry.getSVNURL().toDecodedString());
        if (object2 == null) {
            if (sVNEntry.getURL().equals(sVNEntry.getRepositoryRoot())) {
                object2 = "";
            } else {
                object = SVNErrorMessage.create(SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND, "Destination URLs are broken");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
        }
        object2 = "/" + (String)object2;
        String string2 = SVNPathUtil.getCommonPathAncestor((String)(object2 = SVNPathUtil.canonicalizePath((String)object2)), (String)(object = SVNPathUtil.removeTail(string)));
        if ("".equals(string2)) {
            return null;
        }
        int n2 = SVNPathUtil.getSegmentsCount((String)object2) - SVNPathUtil.getSegmentsCount(string2);
        File file2 = file;
        for (int n3 = 0; n3 < n2 && file2 != null; file2 = file2.getParentFile(), ++n3) {
        }
        if (file2 == null) {
            return null;
        }
        SVNFileType sVNFileType = SVNFileType.getType(file2);
        if (sVNFileType != SVNFileType.DIRECTORY) {
            return null;
        }
        SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(null);
        SVNAdminArea sVNAdminArea = null;
        try {
            sVNAdminArea = sVNWCAccess.open(file2, false, 0);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                sVNWCAccess.close();
                return null;
            }
            throw sVNException;
        }
        SVNEntry sVNEntry2 = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
        if (sVNEntry.getUUID() != null && sVNEntry2.getUUID() != null && !sVNEntry.getUUID().equals(sVNEntry2.getUUID())) {
            sVNWCAccess.close();
            return null;
        }
        SVNURL sVNURL = sVNEntry.getRepositoryRootURL().appendPath(string2, false);
        if (!sVNURL.equals(sVNEntry2.getSVNURL())) {
            sVNWCAccess.close();
            return null;
        }
        String string3 = SVNPathUtil.getPathAsChild(string2, string);
        file2 = new File(file2, string3);
        File file3 = file2.getParentFile();
        sVNFileType = SVNFileType.getType(file2);
        if (sVNFileType != SVNFileType.FILE) {
            sVNWCAccess.close();
            return null;
        }
        try {
            sVNWCAccess.close();
            sVNAdminArea = sVNWCAccess.open(file3, false, 0);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                sVNWCAccess.close();
                return null;
            }
            throw sVNException;
        }
        SVNEntry sVNEntry3 = sVNAdminArea.getEntry(file2.getName(), false);
        if (sVNEntry3 == null) {
            sVNWCAccess.close();
            return null;
        }
        if (sVNEntry3.getUUID() != null && sVNEntry.getUUID() != null && !sVNEntry3.getUUID().equals(sVNEntry.getUUID())) {
            sVNWCAccess.close();
            return null;
        }
        SVNURL sVNURL2 = sVNEntry3.getRepositoryRootURL().appendPath(string, false);
        if (!sVNURL2.equals(sVNEntry3.getSVNURL())) {
            sVNWCAccess.close();
            return null;
        }
        if (!SVNRevision.isValidRevisionNumber(sVNEntry3.getCommittedRevision()) || !SVNRevision.isValidRevisionNumber(sVNEntry3.getRevision())) {
            sVNWCAccess.close();
            return null;
        }
        if (sVNEntry3.getCommittedRevision() > l2 || l2 > sVNEntry3.getRevision()) {
            sVNWCAccess.close();
            return null;
        }
        return sVNEntry3;
    }

    private void changeFileProperty(String string, SVNPropertyValue sVNPropertyValue, SVNUpdateEditor15$SVNFileInfo sVNUpdateEditor15$SVNFileInfo) {
        if (!sVNUpdateEditor15$SVNFileInfo.isSkipped) {
            sVNUpdateEditor15$SVNFileInfo.propertyChanged(string, sVNPropertyValue);
            if (this.myWCAccess.getOptions().isUseCommitTimes() && "svn:entry:committed-date".equals(string)) {
                sVNUpdateEditor15$SVNFileInfo.CommitTime = sVNPropertyValue.getString();
                if (sVNUpdateEditor15$SVNFileInfo.CommitTime != null) {
                    sVNUpdateEditor15$SVNFileInfo.CommitTime = sVNUpdateEditor15$SVNFileInfo.CommitTime.trim();
                }
            }
        }
    }

    private SVNUpdateEditor15$SVNFileInfo openFile(String string, SVNUpdateEditor15$SVNDirectoryInfo sVNUpdateEditor15$SVNDirectoryInfo) {
        this.checkIfPathIsUnderRoot(string);
        SVNUpdateEditor15$SVNFileInfo sVNUpdateEditor15$SVNFileInfo = this.createFileInfo(sVNUpdateEditor15$SVNDirectoryInfo, string, false);
        SVNAdminArea sVNAdminArea = sVNUpdateEditor15$SVNDirectoryInfo.getAdminArea();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNUpdateEditor15$SVNFileInfo.Name, true);
        if (sVNEntry == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "File ''{0}'' in directory ''{1}'' is not a versioned resource", sVNUpdateEditor15$SVNFileInfo.Name, sVNAdminArea.getRoot());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl2 = sVNAdminArea.hasTextConflict(sVNUpdateEditor15$SVNFileInfo.Name);
        boolean bl3 = sVNAdminArea.hasPropConflict(sVNUpdateEditor15$SVNFileInfo.Name);
        if (bl2 || bl3) {
            sVNUpdateEditor15$SVNFileInfo.isSkipped = true;
            Collection collection = this.getSkippedPaths();
            File file = new File(this.myAdminInfo.getAnchor().getRoot(), string);
            collection.add(file);
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(sVNUpdateEditor15$SVNFileInfo.Name), SVNNodeKind.FILE, null, this.myTargetRevision, bl2 ? SVNStatusType.CONFLICTED : SVNStatusType.UNKNOWN, bl3 ? SVNStatusType.CONFLICTED : SVNStatusType.UNKNOWN, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.SKIP, SVNEventAction.UPDATE_UPDATE, null, null);
            sVNEvent.setPreviousRevision(sVNEntry.getRevision());
            sVNEvent.setURL(sVNEntry.getSVNURL());
            this.myWCAccess.handleEvent(sVNEvent);
        }
        return sVNUpdateEditor15$SVNFileInfo;
    }

    private void closeFile(String string, SVNUpdateEditor15$SVNFileInfo sVNUpdateEditor15$SVNFileInfo, SVNUpdateEditor15$SVNDirectoryInfo sVNUpdateEditor15$SVNDirectoryInfo) {
        Object object;
        Object object2;
        Object object3;
        String string2;
        Object object4;
        boolean bl2;
        Object object5;
        if (sVNUpdateEditor15$SVNFileInfo.isSkipped) {
            this.maybeBumpDirInfo(sVNUpdateEditor15$SVNDirectoryInfo);
            return;
        }
        if (sVNUpdateEditor15$SVNFileInfo.addedWithHistory && !sVNUpdateEditor15$SVNFileInfo.receivedTextDelta) {
            boolean bl3;
            SVNErrorManager.assertionFailure(sVNUpdateEditor15$SVNFileInfo.baseFile == null && sVNUpdateEditor15$SVNFileInfo.newBaseFile == null && SVNUpdateEditor15$SVNFileInfo.access$000(sVNUpdateEditor15$SVNFileInfo) != null, null, SVNLogType.WC);
            object5 = sVNUpdateEditor15$SVNFileInfo.getAdminArea();
            SVNEntry sVNEntry = ((SVNAdminArea)object5).getEntry(sVNUpdateEditor15$SVNFileInfo.Name, false);
            boolean bl4 = sVNEntry != null && sVNEntry.isScheduledForReplacement();
            boolean bl5 = bl3 = bl4 && sVNEntry.getCopyFromURL() != null;
            if (bl3) {
                sVNUpdateEditor15$SVNFileInfo.baseFile = ((SVNAdminArea)object5).getFile(SVNAdminUtil.getTextRevertPath(sVNUpdateEditor15$SVNFileInfo.Name, false));
                sVNUpdateEditor15$SVNFileInfo.newBaseFile = ((SVNAdminArea)object5).getFile(SVNAdminUtil.getTextRevertPath(sVNUpdateEditor15$SVNFileInfo.Name, true));
            } else {
                sVNUpdateEditor15$SVNFileInfo.baseFile = ((SVNAdminArea)object5).getBaseFile(sVNUpdateEditor15$SVNFileInfo.Name, false);
                sVNUpdateEditor15$SVNFileInfo.newBaseFile = ((SVNAdminArea)object5).getBaseFile(sVNUpdateEditor15$SVNFileInfo.Name, true);
            }
            SVNFileUtil.copyFile(SVNUpdateEditor15$SVNFileInfo.access$000(sVNUpdateEditor15$SVNFileInfo), sVNUpdateEditor15$SVNFileInfo.newBaseFile, true);
            sVNUpdateEditor15$SVNFileInfo.Checksum = sVNUpdateEditor15$SVNFileInfo.copiedBaseChecksum;
        }
        object5 = null;
        boolean bl6 = bl2 = sVNUpdateEditor15$SVNFileInfo.newBaseFile != null;
        if (string != null && bl2) {
            if (sVNUpdateEditor15$SVNFileInfo.Checksum != null && !string.equals(sVNUpdateEditor15$SVNFileInfo.Checksum)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", sVNUpdateEditor15$SVNFileInfo.getPath(), string, sVNUpdateEditor15$SVNFileInfo.Checksum);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            object5 = string;
        }
        SVNAdminArea sVNAdminArea = sVNUpdateEditor15$SVNFileInfo.getAdminArea();
        SVNLog sVNLog = sVNUpdateEditor15$SVNDirectoryInfo.getLog();
        String string3 = sVNUpdateEditor15$SVNFileInfo.Name;
        SVNEntry sVNEntry = sVNAdminArea.getEntry(string3, false);
        if (sVNEntry == null && !sVNUpdateEditor15$SVNFileInfo.IsAdded) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", (Object)sVNUpdateEditor15$SVNFileInfo.getPath());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        long l2 = sVNEntry != null ? sVNEntry.getRevision() : -1L;
        SVNURL sVNURL = sVNEntry != null ? sVNEntry.getSVNURL() : null;
        SVNProperties sVNProperties = sVNUpdateEditor15$SVNFileInfo.getChangedWCProperties();
        SVNProperties sVNProperties2 = sVNUpdateEditor15$SVNFileInfo.getChangedEntryProperties();
        SVNProperties sVNProperties3 = sVNUpdateEditor15$SVNFileInfo.getChangedProperties();
        String string4 = sVNUpdateEditor15$SVNFileInfo.CommitTime;
        SVNProperties sVNProperties4 = new SVNProperties();
        SVNStatusType sVNStatusType = SVNStatusType.UNCHANGED;
        SVNStatusType sVNStatusType2 = SVNStatusType.LOCK_UNCHANGED;
        if (this.myAdminInfo.isIncomplete(sVNUpdateEditor15$SVNFileInfo.getPath()) && sVNEntry != null) {
            SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getBaseProperties(sVNEntry.getName());
            object4 = sVNVersionedProperties.asMap();
            if (sVNProperties3 == null) {
                sVNProperties3 = new SVNProperties();
            }
            for (String string5 : ((SVNProperties)object4).nameSet()) {
                if (sVNProperties3.containsName(string5)) continue;
                sVNProperties3.put(string5, SVNPropertyValue.create(null));
            }
        }
        boolean bl7 = false;
        if (sVNProperties3 != null && !sVNProperties3.isEmpty()) {
            bl7 = sVNProperties3.containsName("svn:executable") || sVNProperties3.containsName("svn:needs-lock") || sVNProperties3.containsName("svn:keywords") || sVNProperties3.containsName("svn:eol-style") || sVNProperties3.containsName("svnkit:charset") || sVNProperties3.containsName("svn:special");
        }
        object4 = sVNAdminArea.mergeProperties(string3, null, SVNUpdateEditor15$SVNFileInfo.access$300(sVNUpdateEditor15$SVNFileInfo), SVNUpdateEditor15$SVNFileInfo.access$400(sVNUpdateEditor15$SVNFileInfo), sVNProperties3, null, null, true, false, sVNLog);
        if (sVNProperties2 != null) {
            sVNStatusType2 = sVNLog.logChangedEntryProperties(string3, sVNProperties2);
        }
        if (sVNProperties != null) {
            sVNLog.logChangedWCProperties(string3, sVNProperties);
        }
        boolean bl8 = false;
        if (SVNUpdateEditor15$SVNFileInfo.access$200(sVNUpdateEditor15$SVNFileInfo) != null) {
            bl8 = true;
        } else if (sVNEntry != null && sVNEntry.getExternalFilePath() != null && sVNEntry.isScheduledForAddition()) {
            bl8 = false;
        } else if (!sVNUpdateEditor15$SVNFileInfo.isExisted) {
            bl8 = sVNAdminArea.hasTextModifications(string3, false, false, false);
        } else if (bl2) {
            bl8 = sVNAdminArea.hasVersionedFileTextChanges(sVNAdminArea.getFile(string3), sVNUpdateEditor15$SVNFileInfo.newBaseFile, false);
        }
        boolean bl9 = sVNEntry != null && sVNEntry.isScheduledForReplacement();
        SVNProperties sVNProperties5 = new SVNProperties();
        if (sVNUpdateEditor15$SVNFileInfo.isAddExisted) {
            sVNProperties5.put("force", "true");
            sVNProperties5.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "");
        }
        sVNLog.logTweakEntry(string3, sVNUpdateEditor15$SVNFileInfo.URL, this.myTargetRevision);
        String string6 = sVNAdminArea.getRoot().getAbsolutePath().replace(File.separatorChar, '/');
        String string7 = null;
        if (sVNUpdateEditor15$SVNFileInfo.baseFile != null && (string7 = (string2 = sVNUpdateEditor15$SVNFileInfo.baseFile.getAbsolutePath().replace(File.separatorChar, '/')).substring(string6.length())).startsWith("/")) {
            string7 = string7.substring(1);
        }
        string2 = null;
        if (sVNUpdateEditor15$SVNFileInfo.newBaseFile != null && (string2 = ((String)(object3 = sVNUpdateEditor15$SVNFileInfo.newBaseFile.getAbsolutePath().replace(File.separatorChar, '/'))).substring(string6.length())).startsWith("/")) {
            string2 = string2.substring(1);
        }
        object3 = SVNStatusType.UNCHANGED;
        File file = sVNAdminArea.getFile(string3);
        boolean bl10 = false;
        if (string2 != null) {
            sVNStatusType = SVNStatusType.CHANGED;
            if (!bl8 && !bl9) {
                if (sVNEntry == null || !sVNEntry.isScheduledForDeletion()) {
                    sVNProperties4.put("name", string2);
                    sVNProperties4.put("dest", string3);
                    sVNLog.addCommand("cp-and-translate", sVNProperties4, false);
                    sVNProperties4.clear();
                }
            } else {
                object2 = SVNFileType.getType(file);
                if (object2 == SVNFileType.NONE && !sVNUpdateEditor15$SVNFileInfo.addedWithHistory) {
                    sVNProperties4.put("name", string2);
                    sVNProperties4.put("dest", string3);
                    sVNLog.addCommand("cp-and-translate", sVNProperties4, false);
                    sVNProperties4.clear();
                } else if (!sVNUpdateEditor15$SVNFileInfo.isExisted) {
                    String string8;
                    int n2;
                    int n3;
                    object = sVNUpdateEditor15$SVNFileInfo.baseFile;
                    String string9 = null;
                    if (this.myExtensionPatterns != null && this.myExtensionPatterns.length > 0) {
                        n3 = string3.lastIndexOf(46);
                        if (n3 != -1 && n3 != 0 && n3 != string3.length() - 1) {
                            string9 = string3.substring(n3 + 1);
                        }
                        if (string9 != null && !"".equals(string9)) {
                            n2 = 0;
                            for (int i2 = 0; i2 < this.myExtensionPatterns.length && (n2 = (int)(DefaultSVNOptions.matches(string8 = this.myExtensionPatterns[i2], string9) ? 1 : 0)) == 0; ++i2) {
                            }
                            if (n2 == 0) {
                                string9 = null;
                            }
                        }
                    }
                    n3 = 0;
                    n2 = 0;
                    if (sVNUpdateEditor15$SVNFileInfo.isAddExisted && !bl9) {
                        n3 = 1;
                        object = SVNAdminUtil.createTmpFile(sVNAdminArea);
                    } else if (SVNUpdateEditor15$SVNFileInfo.access$000(sVNUpdateEditor15$SVNFileInfo) != null) {
                        n2 = 1;
                        n3 = 1;
                        object = SVNUpdateEditor15$SVNFileInfo.access$000(sVNUpdateEditor15$SVNFileInfo);
                    }
                    String string10 = ((File)object).getAbsolutePath().replace(File.separatorChar, '/');
                    string8 = string10.substring(string6.length());
                    if (string8.startsWith("/")) {
                        string8 = string8.substring(1);
                    }
                    String string11 = null;
                    string11 = sVNUpdateEditor15$SVNFileInfo.addedWithHistory ? ".copied" + (string9 != null ? "." + string9 : "") : ".r" + sVNEntry.getRevision() + (string9 != null ? "." + string9 : "");
                    String string12 = ".r" + this.myTargetRevision + (string9 != null ? "." + string9 : "");
                    String string13 = ".mine" + (string9 != null ? "." + string9 : "");
                    object3 = sVNAdminArea.mergeText(string3, (File)object, sVNAdminArea.getFile(string2), SVNUpdateEditor15$SVNFileInfo.access$200(sVNUpdateEditor15$SVNFileInfo), string13, string11, string12, sVNProperties3, false, null, sVNLog);
                    if (object3 == SVNStatusType.UNCHANGED) {
                        sVNStatusType = SVNStatusType.MERGED;
                    }
                    if (n3 != 0) {
                        sVNProperties4.put("name", string8);
                        sVNLog.addCommand("rm", sVNProperties4, false);
                        sVNProperties4.clear();
                        if (n2 != 0) {
                            bl10 = true;
                        }
                    }
                    if (SVNUpdateEditor15$SVNFileInfo.access$200(sVNUpdateEditor15$SVNFileInfo) != null) {
                        String string14 = SVNUpdateEditor15$SVNFileInfo.access$200(sVNUpdateEditor15$SVNFileInfo).getAbsolutePath().replace(File.separatorChar, '/');
                        String string15 = string14.substring(string6.length());
                        if (string15.startsWith("/")) {
                            string15 = string15.substring(1);
                        }
                        sVNProperties4.put("name", string15);
                        sVNLog.addCommand("rm", sVNProperties4, false);
                        sVNProperties4.clear();
                    }
                }
            }
        } else {
            if (bl7 && (file.exists() || SVNFileType.getType(file) == SVNFileType.SYMLINK)) {
                object2 = SVNAdminUtil.getTextBasePath(string3, true);
                sVNProperties4.put("name", string3);
                sVNProperties4.put("dest", (String)object2);
                sVNLog.addCommand("cp-and-detranslate", sVNProperties4, false);
                sVNProperties4.clear();
                sVNProperties4.put("name", (String)object2);
                sVNProperties4.put("dest", string3);
                sVNLog.addCommand("cp-and-translate", sVNProperties4, false);
                sVNProperties4.clear();
            }
            if (sVNStatusType2 == SVNStatusType.LOCK_UNLOCKED) {
                sVNProperties4.put("name", string3);
                sVNLog.addCommand("maybe-readonly", sVNProperties4, false);
                sVNProperties4.clear();
            }
        }
        if (string2 != null) {
            sVNProperties4.put("name", string2);
            sVNProperties4.put("dest", string7);
            sVNLog.addCommand("mv", sVNProperties4, false);
            sVNProperties4.clear();
            sVNProperties4.put("name", string7);
            sVNLog.addCommand("readonly", sVNProperties4, false);
            sVNProperties4.clear();
            if (!bl9) {
                sVNProperties5.put(SVNProperty.shortPropertyName("svn:entry:checksum"), (String)object5);
            }
        }
        if (sVNProperties5.size() > 0) {
            sVNProperties5.put("name", string3);
            sVNLog.addCommand("modify-entry", sVNProperties5, false);
        }
        if (!bl8 && (sVNUpdateEditor15$SVNFileInfo.IsAdded || sVNEntry.getSchedule() == null)) {
            if (string4 != null && !sVNUpdateEditor15$SVNFileInfo.isExisted) {
                sVNProperties4.put("name", string3);
                sVNProperties4.put("timestamp", string4);
                sVNLog.addCommand("set-timestamp", sVNProperties4, false);
                sVNProperties4.clear();
            }
            if (string2 != null || bl7) {
                sVNProperties4.put("name", string3);
                sVNProperties4.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
                sVNLog.addCommand("modify-entry", sVNProperties4, false);
                sVNProperties4.clear();
            }
            sVNProperties4.put("name", string3);
            sVNProperties4.put(SVNProperty.shortPropertyName("svn:entry:working-size"), "working");
            sVNLog.addCommand("modify-entry", sVNProperties4, false);
            sVNProperties4.clear();
        }
        if (SVNUpdateEditor15$SVNFileInfo.access$000(sVNUpdateEditor15$SVNFileInfo) != null && !bl10) {
            object2 = SVNUpdateEditor15$SVNFileInfo.access$000(sVNUpdateEditor15$SVNFileInfo).getAbsolutePath().replace(File.separatorChar, '/');
            object = ((String)object2).substring(string6.length());
            if (((String)object).startsWith("/")) {
                object = ((String)object).substring(1);
            }
            sVNProperties4.put("name", (String)object);
            sVNLog.addCommand("rm", sVNProperties4, false);
            sVNProperties4.clear();
        }
        this.maybeBumpDirInfo(sVNUpdateEditor15$SVNDirectoryInfo);
        if (object3 == SVNStatusType.CONFLICTED_UNRESOLVED) {
            sVNStatusType = SVNStatusType.CONFLICTED_UNRESOLVED;
        } else if (object3 == SVNStatusType.CONFLICTED) {
            sVNStatusType = SVNStatusType.CONFLICTED;
        } else if (sVNUpdateEditor15$SVNFileInfo.newBaseFile != null) {
            sVNStatusType = bl8 ? SVNStatusType.MERGED : SVNStatusType.CHANGED;
        }
        if (sVNStatusType != SVNStatusType.UNCHANGED || object4 != SVNStatusType.UNCHANGED || sVNStatusType2 != SVNStatusType.LOCK_UNCHANGED) {
            object2 = SVNEventAction.UPDATE_UPDATE;
            if (sVNUpdateEditor15$SVNFileInfo.isExisted || sVNUpdateEditor15$SVNFileInfo.isAddExisted) {
                if (sVNStatusType != SVNStatusType.CONFLICTED_UNRESOLVED && sVNStatusType != SVNStatusType.CONFLICTED) {
                    object2 = SVNEventAction.UPDATE_EXISTS;
                }
            } else if (sVNUpdateEditor15$SVNFileInfo.IsAdded) {
                object2 = SVNEventAction.UPDATE_ADD;
            }
            object = SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(sVNUpdateEditor15$SVNFileInfo.Name), SVNNodeKind.FILE, null, this.myTargetRevision, sVNStatusType, (SVNStatusType)object4, sVNStatusType2, (SVNEventAction)object2, null, null, null);
            ((SVNEvent)object).setPreviousRevision(l2);
            ((SVNEvent)object).setPreviousURL(sVNURL);
            ((SVNEvent)object).setURL(sVNUpdateEditor15$SVNFileInfo.URL != null ? SVNURL.parseURIEncoded(sVNUpdateEditor15$SVNFileInfo.URL) : null);
            this.myWCAccess.handleEvent((SVNEvent)object);
        }
    }

    private SVNUpdateEditor15$SVNFileInfo createFileInfo(SVNUpdateEditor15$SVNDirectoryInfo sVNUpdateEditor15$SVNDirectoryInfo, String string, boolean bl2) {
        SVNUpdateEditor15$SVNFileInfo sVNUpdateEditor15$SVNFileInfo = new SVNUpdateEditor15$SVNFileInfo(this, sVNUpdateEditor15$SVNDirectoryInfo, string);
        sVNUpdateEditor15$SVNFileInfo.IsAdded = bl2;
        sVNUpdateEditor15$SVNFileInfo.Name = SVNPathUtil.tail(string);
        sVNUpdateEditor15$SVNFileInfo.isExisted = false;
        sVNUpdateEditor15$SVNFileInfo.isAddExisted = false;
        sVNUpdateEditor15$SVNFileInfo.isSkipped = false;
        sVNUpdateEditor15$SVNFileInfo.baseFile = null;
        sVNUpdateEditor15$SVNFileInfo.newBaseFile = null;
        SVNAdminArea sVNAdminArea = sVNUpdateEditor15$SVNDirectoryInfo.getAdminArea();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNUpdateEditor15$SVNFileInfo.Name, true);
        sVNUpdateEditor15$SVNFileInfo.URL = this.mySwitchURL != null || sVNEntry == null ? SVNPathUtil.append(sVNUpdateEditor15$SVNDirectoryInfo.URL, SVNEncodingUtil.uriEncode(sVNUpdateEditor15$SVNFileInfo.Name)) : sVNEntry.getURL();
        ++sVNUpdateEditor15$SVNDirectoryInfo.RefCount;
        return sVNUpdateEditor15$SVNFileInfo;
    }

    private SVNUpdateEditor15$SVNDirectoryInfo createDirectoryInfo(SVNUpdateEditor15$SVNDirectoryInfo sVNUpdateEditor15$SVNDirectoryInfo, String string, boolean bl2) {
        String string2;
        SVNUpdateEditor15$SVNDirectoryInfo sVNUpdateEditor15$SVNDirectoryInfo2 = new SVNUpdateEditor15$SVNDirectoryInfo(this, string);
        sVNUpdateEditor15$SVNDirectoryInfo2.Parent = sVNUpdateEditor15$SVNDirectoryInfo;
        sVNUpdateEditor15$SVNDirectoryInfo2.IsAdded = bl2;
        String string3 = string2 = string != null ? SVNPathUtil.tail(string) : "";
        if (this.mySwitchURL == null) {
            SVNAdminArea sVNAdminArea = null;
            SVNEntry sVNEntry = null;
            File file = new File(this.myAdminInfo.getAnchor().getRoot(), sVNUpdateEditor15$SVNDirectoryInfo2.getPath());
            try {
                sVNAdminArea = this.myWCAccess.getAdminArea(file);
                if (sVNAdminArea != null) {
                    sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            if (sVNAdminArea != null && sVNEntry != null) {
                sVNUpdateEditor15$SVNDirectoryInfo2.URL = sVNEntry.getURL();
            }
            if (sVNUpdateEditor15$SVNDirectoryInfo2.URL == null && sVNUpdateEditor15$SVNDirectoryInfo != null) {
                sVNUpdateEditor15$SVNDirectoryInfo2.URL = SVNPathUtil.append(sVNUpdateEditor15$SVNDirectoryInfo.URL, SVNEncodingUtil.uriEncode(string2));
            } else if (sVNUpdateEditor15$SVNDirectoryInfo2.URL == null && sVNUpdateEditor15$SVNDirectoryInfo == null) {
                sVNUpdateEditor15$SVNDirectoryInfo2.URL = this.myTargetURL;
            }
        } else {
            sVNUpdateEditor15$SVNDirectoryInfo2.URL = sVNUpdateEditor15$SVNDirectoryInfo == null ? (this.myTarget == null ? this.mySwitchURL : SVNPathUtil.removeTail(this.mySwitchURL)) : (this.myTarget != null && sVNUpdateEditor15$SVNDirectoryInfo.Parent == null ? this.mySwitchURL : SVNPathUtil.append(sVNUpdateEditor15$SVNDirectoryInfo.URL, SVNEncodingUtil.uriEncode(string2)));
        }
        sVNUpdateEditor15$SVNDirectoryInfo2.RefCount = 1;
        sVNUpdateEditor15$SVNDirectoryInfo2.isSkipped = false;
        if (sVNUpdateEditor15$SVNDirectoryInfo2.Parent != null) {
            ++sVNUpdateEditor15$SVNDirectoryInfo2.Parent.RefCount;
        }
        sVNUpdateEditor15$SVNDirectoryInfo2.isExisted = false;
        sVNUpdateEditor15$SVNDirectoryInfo2.isAddExisted = false;
        SVNUpdateEditor15$SVNDirectoryInfo.access$502(sVNUpdateEditor15$SVNDirectoryInfo2, null);
        sVNUpdateEditor15$SVNDirectoryInfo2.myAmbientDepth = SVNDepth.UNKNOWN;
        return sVNUpdateEditor15$SVNDirectoryInfo2;
    }

    public static SVNUpdateEditor15 createUpdateEditor(SVNAdminAreaInfo sVNAdminAreaInfo, String string, boolean bl2, boolean bl3, SVNDepth sVNDepth, String[] stringArray, ISVNFileFetcher iSVNFileFetcher, boolean bl4) {
        Object object;
        if (sVNDepth == SVNDepth.UNKNOWN) {
            bl3 = false;
        }
        SVNEntry sVNEntry = sVNAdminAreaInfo.getAnchor().getEntry(sVNAdminAreaInfo.getAnchor().getThisDirName(), false);
        if (string != null && sVNEntry != null && sVNEntry.getRepositoryRoot() != null && !SVNPathUtil.isAncestor(sVNEntry.getRepositoryRoot(), string)) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}''\nis not the same repository as\n''{1}''", string, sVNEntry.getRepositoryRoot());
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = new SVNUpdateEditor15(sVNAdminAreaInfo, string, bl2, bl3, sVNDepth, stringArray, sVNEntry != null ? sVNEntry.getURL() : null, sVNEntry != null ? sVNEntry.getRepositoryRoot() : null, iSVNFileFetcher, bl4);
        sVNAdminAreaInfo.getTarget().closeEntries();
        return object;
    }

    @Override
    public void cleanup(SVNAdminArea sVNAdminArea) {
        sVNAdminArea.runLogs();
    }

    static /* synthetic */ SVNAdminAreaInfo access$600(SVNUpdateEditor15 sVNUpdateEditor15) {
        return sVNUpdateEditor15.myAdminInfo;
    }

    static /* synthetic */ boolean access$700(SVNUpdateEditor15 sVNUpdateEditor15) {
        return sVNUpdateEditor15.myIsLockOnDemand;
    }
}

