/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNFileFetcher;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor$1;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor$2;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor$SVNDirectoryInfo;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor$SVNFileInfo;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNCleanupHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNUpdateEditor
implements ISVNUpdateEditor,
ISVNCleanupHandler {
    private String mySwitchURL;
    private String myTarget;
    private String myTargetURL;
    private String myRootURL;
    private SVNAdminAreaInfo myAdminInfo;
    private SVNUpdateEditor$SVNDirectoryInfo myCurrentDirectory;
    private SVNUpdateEditor$SVNFileInfo myCurrentFile;
    private long myTargetRevision;
    private boolean myIsRootOpen;
    private boolean myIsTargetDeleted;
    private boolean myIsUnversionedObstructionsAllowed;
    private boolean myIsDepthSticky;
    private Collection mySkippedTrees;
    private Collection myDeletedTrees;
    private SVNWCAccess myWCAccess;
    private SVNDeltaProcessor myDeltaProcessor;
    private SVNDepth myRequestedDepth;
    private String[] myExtensionPatterns;
    private ISVNFileFetcher myFileFetcher;
    private boolean myIsLockOnDemand;

    private SVNUpdateEditor(SVNAdminAreaInfo sVNAdminAreaInfo, String string, boolean bl2, boolean bl3, SVNDepth sVNDepth, String[] stringArray, String string2, String string3, ISVNFileFetcher iSVNFileFetcher, boolean bl4) {
        this.myAdminInfo = sVNAdminAreaInfo;
        this.myWCAccess = sVNAdminAreaInfo.getWCAccess();
        this.myIsUnversionedObstructionsAllowed = bl2;
        this.myTarget = sVNAdminAreaInfo.getTargetName();
        this.mySwitchURL = string;
        this.myTargetRevision = -1L;
        this.myRequestedDepth = sVNDepth;
        this.myIsDepthSticky = bl3;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myExtensionPatterns = stringArray;
        this.myFileFetcher = iSVNFileFetcher;
        this.myTargetURL = string2;
        this.myRootURL = string3;
        this.myIsLockOnDemand = bl4;
        if (this.myTarget != null) {
            this.myTargetURL = SVNPathUtil.append(this.myTargetURL, SVNEncodingUtil.uriEncode(this.myTarget));
        }
        if ("".equals(this.myTarget)) {
            this.myTarget = null;
        }
    }

    private Collection getSkippedTrees() {
        if (this.mySkippedTrees == null) {
            this.mySkippedTrees = new LinkedList();
        }
        return this.mySkippedTrees;
    }

    private Collection getDeletedTrees() {
        if (this.myDeletedTrees == null) {
            this.myDeletedTrees = new LinkedList();
        }
        return this.myDeletedTrees;
    }

    private void addSkippedTree(File file) {
        this.getSkippedTrees().add(file);
    }

    private void addDeletedTree(File file) {
        this.getDeletedTrees().add(file);
    }

    private boolean inSkippedTree(File file) {
        while (file != null && !file.equals(this.myAdminInfo.getAnchor().getRoot())) {
            if (this.getSkippedTrees().contains(file)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    private boolean inDeletedTree(File file, boolean bl2) {
        if (!bl2) {
            file = file.getParentFile();
        }
        while (file != null && !file.equals(this.myAdminInfo.getAnchor().getRoot())) {
            if (this.getDeletedTrees().contains(file)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    @Override
    public void targetRevision(long l2) {
        this.myTargetRevision = l2;
    }

    @Override
    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    @Override
    public void openRoot(long l2) {
        this.myIsRootOpen = true;
        this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
        this.myWCAccess.registerCleanupHandler(this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory);
        if (this.myTarget == null) {
            SVNAdminArea sVNAdminArea = this.myCurrentDirectory.getAdminArea();
            SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
            if (sVNEntry != null) {
                this.myCurrentDirectory.myAmbientDepth = sVNEntry.getDepth();
                this.myCurrentDirectory.wasIncomplete = sVNEntry.isIncomplete();
                this.myCurrentDirectory.myPreviousRevision = sVNEntry.getRevision();
            }
            SVNHashMap sVNHashMap = new SVNHashMap();
            sVNHashMap.put("svn:entry:revision", Long.toString(this.myTargetRevision));
            sVNHashMap.put("svn:entry:url", this.myCurrentDirectory.URL);
            sVNHashMap.put("svn:entry:incomplete", Boolean.TRUE.toString());
            if (this.myRootURL != null && SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
                sVNHashMap.put("svn:entry:repos", this.myRootURL);
            }
            sVNAdminArea.modifyEntry(sVNAdminArea.getThisDirName(), sVNHashMap, true, false);
            if (this.mySwitchURL != null) {
                this.clearWCProperty(this.myCurrentDirectory.getAdminArea(), null);
            }
        } else if (this.mySwitchURL != null) {
            if (this.myAdminInfo.getTarget() == this.myAdminInfo.getAnchor()) {
                this.clearWCProperty(this.myAdminInfo.getTarget(), this.myTarget);
            } else {
                this.clearWCProperty(this.myAdminInfo.getTarget(), null);
            }
        }
    }

    private void doDeleteEntry(String string, SVNAdminArea sVNAdminArea, SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo, SVNURL sVNURL) {
        SVNErrorMessage sVNErrorMessage;
        Object object;
        Object object2;
        File file = this.myAdminInfo.getAnchor().getFile(string);
        String string2 = SVNPathUtil.tail(string);
        SVNEntry sVNEntry = this.myWCAccess.getVersionedEntry(file, true);
        sVNUpdateEditor$SVNDirectoryInfo.anyChangesInChildren = true;
        if (sVNEntry.getDepth() == SVNDepth.EXCLUDE) {
            sVNAdminArea.deleteEntry(string2);
            sVNAdminArea.saveEntries(true);
            if (string.equals(this.myTarget)) {
                this.myIsTargetDeleted = true;
            }
            return;
        }
        SVNNodeKind sVNNodeKind = sVNEntry.getKind();
        long l2 = sVNEntry.getRevision();
        SVNURL sVNURL2 = sVNEntry.getSVNURL();
        if (this.inSkippedTree(file) && !this.inDeletedTree(file, true)) {
            return;
        }
        File file2 = this.alreadyInTreeConflict(file);
        if (file2 != null) {
            this.addSkippedTree(file);
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, sVNEntry.getKind(), null, this.myTargetRevision, SVNEventAction.SKIP, SVNEventAction.UPDATE_DELETE, null, null);
            sVNEvent.setPreviousRevision(l2);
            sVNEvent.setPreviousURL(sVNURL2);
            this.myWCAccess.handleEvent(sVNEvent);
            return;
        }
        SVNLog sVNLog = sVNUpdateEditor$SVNDirectoryInfo == null ? sVNAdminArea.getLog() : sVNUpdateEditor$SVNDirectoryInfo.getLog();
        SVNTreeConflictDescription sVNTreeConflictDescription = sVNNodeKind == SVNNodeKind.DIR && this.myWCAccess.isMissing(file) && (sVNEntry.isScheduledForDeletion() || sVNEntry.isScheduledForReplacement()) ? null : this.checkTreeConflict(file, sVNEntry, sVNAdminArea, sVNLog, SVNConflictAction.DELETE, SVNNodeKind.NONE, sVNURL);
        if (sVNTreeConflictDescription != null) {
            this.addSkippedTree(file);
            object2 = SVNEventFactory.createSVNEvent(file, sVNEntry.getKind(), null, this.myTargetRevision, SVNEventAction.TREE_CONFLICT, SVNEventAction.UPDATE_DELETE, null, null);
            ((SVNEvent)object2).setPreviousRevision(sVNEntry.getRevision());
            ((SVNEvent)object2).setPreviousURL(sVNEntry.getSVNURL());
            this.myWCAccess.handleEvent((SVNEvent)object2);
            if (sVNTreeConflictDescription.getConflictReason() == SVNConflictReason.EDITED) {
                if (sVNUpdateEditor$SVNDirectoryInfo != null) {
                    sVNUpdateEditor$SVNDirectoryInfo.flushLog();
                    sVNUpdateEditor$SVNDirectoryInfo.runLogs();
                } else if (sVNLog != null) {
                    sVNLog.save();
                    sVNAdminArea.runLogs();
                }
                this.scheduleExistingEntryForReAdd(sVNEntry, file, sVNURL, true);
                return;
            }
            if (sVNTreeConflictDescription.getConflictReason() == SVNConflictReason.DELETED) {
                if (sVNEntry.isScheduledForReplacement()) {
                    if (sVNUpdateEditor$SVNDirectoryInfo != null) {
                        sVNUpdateEditor$SVNDirectoryInfo.flushLog();
                        sVNUpdateEditor$SVNDirectoryInfo.runLogs();
                    } else if (sVNLog != null) {
                        sVNLog.save();
                        sVNAdminArea.runLogs();
                    }
                    this.scheduleExistingEntryForReAdd(sVNEntry, file, sVNURL, false);
                    return;
                }
            } else {
                object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unexpected tree conflict reason");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
        }
        sVNLog = sVNUpdateEditor$SVNDirectoryInfo == null ? sVNAdminArea.getLog() : sVNUpdateEditor$SVNDirectoryInfo.getLog();
        object2 = new SVNProperties();
        ((SVNProperties)object2).put("name", string2);
        sVNLog.addCommand("delete-entry", (SVNProperties)object2, false);
        ((SVNProperties)object2).clear();
        if (string.equals(this.myTarget)) {
            ((SVNProperties)object2).put("name", string2);
            ((SVNProperties)object2).put(SVNProperty.shortPropertyName("svn:entry:kind"), sVNNodeKind == SVNNodeKind.DIR ? "dir" : "file");
            ((SVNProperties)object2).put(SVNProperty.shortPropertyName("svn:entry:revision"), Long.toString(this.myTargetRevision));
            ((SVNProperties)object2).put(SVNProperty.shortPropertyName("svn:entry:deleted"), Boolean.TRUE.toString());
            sVNLog.addCommand("modify-entry", (SVNProperties)object2, false);
            this.myIsTargetDeleted = true;
        }
        try {
            if (sVNUpdateEditor$SVNDirectoryInfo != null) {
                sVNUpdateEditor$SVNDirectoryInfo.flushLog();
            } else if (sVNLog != null) {
                sVNLog.save();
            }
        }
        catch (SVNException sVNException) {
            sVNErrorMessage = sVNException.getErrorMessage().wrap("Error writing log file for ''{0}''", sVNUpdateEditor$SVNDirectoryInfo.getPath());
            SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.WC);
        }
        if (this.myIsLockOnDemand && sVNNodeKind == SVNNodeKind.DIR && (object = this.myWCAccess.getAdminArea(sVNAdminArea.getFile(string2))) != null && !((SVNAdminArea)object).isLocked()) {
            ((SVNAdminArea)object).lock(false);
        }
        if (this.mySwitchURL != null && sVNNodeKind == SVNNodeKind.DIR && (object = this.myWCAccess.retrieve(sVNAdminArea.getFile(string2))) != null) {
            try {
                ((SVNAdminArea)object).removeFromRevisionControl(((SVNAdminArea)object).getThisDirName(), true, false);
            }
            catch (SVNException sVNException) {
                this.handleLeftLocalModificationsError(sVNException);
            }
        }
        try {
            if (sVNUpdateEditor$SVNDirectoryInfo != null) {
                sVNUpdateEditor$SVNDirectoryInfo.runLogs();
            } else {
                sVNAdminArea.runLogs();
            }
        }
        catch (SVNException sVNException) {
            sVNErrorMessage = sVNException.getErrorMessage().wrap("Error running log file for ''{0}''", sVNAdminArea.getRoot());
            SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.WC);
        }
        if (sVNTreeConflictDescription == null && !this.inDeletedTree(file, true)) {
            object = SVNEventFactory.createSVNEvent(file, sVNNodeKind, null, this.myTargetRevision, SVNEventAction.UPDATE_DELETE, null, null, null);
            ((SVNEvent)object).setPreviousRevision(l2);
            ((SVNEvent)object).setPreviousURL(sVNURL2);
            this.myWCAccess.handleEvent((SVNEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File alreadyInTreeConflict(File file) {
        Object object;
        File file2 = file;
        ArrayList<File> arrayList = new ArrayList<File>();
        try (SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(this.myWCAccess);){
            sVNWCAccess.probeOpen(file2, false, 0);
            object = sVNWCAccess.getEntry(file, true);
            if (object != null) {
                arrayList.add(file2);
            }
        }
        sVNWCAccess = SVNWCAccess.newInstance(this.myWCAccess);
        try {
            for (file2 = file2.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
                object = sVNWCAccess.probeOpen(file2, false, 0);
                if (object == null) {
                    break;
                }
                boolean bl2 = sVNWCAccess.isWCRoot(file2);
                if (bl2) {
                    break;
                }
                arrayList.add(file2);
            }
        }
        finally {
            sVNWCAccess.close();
        }
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            file2 = (File)arrayList.get(i2);
            SVNTreeConflictDescription sVNTreeConflictDescription = sVNWCAccess.getTreeConflict(file2);
            if (sVNTreeConflictDescription == null) continue;
            return file2;
        }
        return null;
    }

    private SVNTreeConflictDescription checkTreeConflict(File file, SVNEntry sVNEntry, SVNAdminArea sVNAdminArea, SVNLog sVNLog, SVNConflictAction sVNConflictAction, SVNNodeKind sVNNodeKind, SVNURL sVNURL) {
        Object object;
        Object object2;
        Object object3 = false;
        boolean bl2 = this.inDeletedTree(file, false);
        SVNConflictReason sVNConflictReason = null;
        if (sVNConflictAction == SVNConflictAction.EDIT) {
            if ((sVNEntry.isScheduledForDeletion() || sVNEntry.isScheduledForReplacement()) && !bl2) {
                sVNConflictReason = SVNConflictReason.DELETED;
            }
        } else if (sVNConflictAction == SVNConflictAction.ADD) {
            if (sVNEntry != null && sVNEntry.getExternalFilePath() == null) {
                sVNConflictReason = SVNConflictReason.ADDED;
            }
        } else if (sVNConflictAction == SVNConflictAction.DELETE) {
            if (sVNEntry.isScheduledForDeletion() || sVNEntry.isScheduledForReplacement()) {
                if (!bl2) {
                    sVNConflictReason = SVNConflictReason.DELETED;
                }
            } else {
                boolean bl3 = false;
                if (sVNEntry.isFile()) {
                    bl3 = this.entryHasLocalModifications(sVNAdminArea, file, SVNNodeKind.FILE, sVNEntry.getSchedule());
                    if (sVNEntry.isScheduledForDeletion()) {
                        object3 = true;
                    }
                } else if (sVNEntry.isDirectory() && ((SVNAdminArea)(object2 = this.myWCAccess.probeRetrieve(file))).getRoot().equals(file)) {
                    object = new boolean[1];
                    bl3 = this.treeHasLocalModifications((SVNAdminArea)object2, (boolean[])object);
                    object3 = object[0];
                }
                if (bl3) {
                    sVNConflictReason = object3 ? SVNConflictReason.DELETED : SVNConflictReason.EDITED;
                }
            }
        }
        if (sVNConflictReason != null) {
            Object object4;
            SVNNodeKind sVNNodeKind2 = sVNEntry.isScheduledForAddition() ? SVNNodeKind.NONE : (sVNEntry.isScheduledForDeletion() ? SVNNodeKind.UNKNOWN : sVNEntry.getKind());
            object2 = sVNEntry.getRepositoryRootURL();
            object = SVNPathUtil.getPathAsChild(((SVNURL)object2).getPath(), sVNEntry.getSVNURL().getPath());
            object = object != null ? object : "/";
            SVNConflictVersion sVNConflictVersion = new SVNConflictVersion((SVNURL)object2, (String)object, sVNEntry.getRevision(), sVNNodeKind2);
            if (this.mySwitchURL != null) {
                if (sVNURL != null) {
                    object = SVNPathUtil.getPathAsChild(((SVNURL)object2).getPath(), sVNURL.getPath());
                } else {
                    object4 = SVNURL.parseURIEncoded(this.mySwitchURL);
                    object = SVNPathUtil.getPathAsChild(((SVNURL)object2).getPath(), ((SVNURL)object4).getPath());
                }
            }
            object4 = new SVNConflictVersion((SVNURL)object2, (String)object, this.myTargetRevision, sVNNodeKind);
            SVNTreeConflictDescription sVNTreeConflictDescription = new SVNTreeConflictDescription(file, sVNEntry.getKind(), sVNConflictAction, sVNConflictReason, this.mySwitchURL != null ? SVNOperation.SWITCH : SVNOperation.UPDATE, sVNConflictVersion, (SVNConflictVersion)object4);
            SVNProperties sVNProperties = this.getTreeConflictCreationAttributes(sVNAdminArea, sVNTreeConflictDescription);
            sVNLog.addCommand("add-tree-conflict", sVNProperties, false);
            return sVNTreeConflictDescription;
        }
        return null;
    }

    public boolean treeHasLocalModifications(SVNAdminArea sVNAdminArea, boolean[] blArray) {
        boolean[] blArray2 = new boolean[]{false};
        if (blArray != null) {
            blArray[0] = true;
        }
        SVNUpdateEditor$1 sVNUpdateEditor$1 = new SVNUpdateEditor$1(this, blArray2, blArray);
        sVNAdminArea.walkThisDirectory(sVNUpdateEditor$1, false, SVNDepth.INFINITY);
        return blArray2[0];
    }

    private boolean entryHasLocalModifications(SVNAdminArea sVNAdminArea, File file, SVNNodeKind sVNNodeKind, String string) {
        boolean bl2;
        if (string != null) {
            bl2 = true;
        } else {
            SVNAdminArea sVNAdminArea2;
            boolean bl3 = false;
            if (sVNNodeKind == SVNNodeKind.FILE) {
                bl3 = sVNAdminArea.hasTextModifications(file.getName(), false);
            }
            boolean bl4 = sVNNodeKind == SVNNodeKind.FILE ? sVNAdminArea.hasPropModifications(file.getName()) : (file.equals(sVNAdminArea.getRoot()) ? sVNAdminArea.hasPropModifications(sVNAdminArea.getThisDirName()) : ((sVNAdminArea2 = this.myWCAccess.probeRetrieve(file)).getRoot().equals(file) ? sVNAdminArea2.hasPropModifications(sVNAdminArea2.getThisDirName()) : sVNAdminArea2.hasPropConflict(file.getName())));
            bl2 = bl3 || bl4;
        }
        return bl2;
    }

    private void scheduleExistingEntryForReAdd(SVNEntry sVNEntry, File file, SVNURL sVNURL, boolean bl2) {
        SVNAdminArea sVNAdminArea;
        File file2 = file.getParentFile();
        String string = file.getName();
        SVNHashMap sVNHashMap = new SVNHashMap();
        sVNHashMap.put("svn:entry:url", sVNURL.toString());
        sVNHashMap.put("svn:entry:schedule", "add");
        if (bl2) {
            sVNHashMap.put("svn:entry:copyfrom-url", sVNEntry.getURL());
            sVNHashMap.put("svn:entry:copyfrom-rev", String.valueOf(sVNEntry.getRevision()));
            sVNHashMap.put("svn:entry:copied", Boolean.TRUE.toString());
        }
        if (this.myIsLockOnDemand && sVNEntry.isDirectory() && (sVNAdminArea = this.myWCAccess.getAdminArea(file)) != null && !sVNAdminArea.isLocked()) {
            sVNAdminArea.lock(false);
        }
        sVNAdminArea = this.myWCAccess.retrieve(sVNEntry.isDirectory() ? file : file2);
        sVNAdminArea.modifyEntry(sVNEntry.isDirectory() ? sVNAdminArea.getThisDirName() : string, sVNHashMap, true, true);
        if (sVNEntry.isDirectory()) {
            SVNUpdateEditor$2 sVNUpdateEditor$2 = new SVNUpdateEditor$2(this, file, sVNAdminArea);
            sVNAdminArea.walkThisDirectory(sVNUpdateEditor$2, false, SVNDepth.INFINITY);
            SVNAdminArea sVNAdminArea2 = this.myWCAccess.retrieve(file2);
            sVNAdminArea2.getVersionedEntry(sVNAdminArea2.getThisDirName(), true);
            sVNAdminArea2.modifyEntry(string, sVNHashMap, true, true);
        }
    }

    @Override
    public void deleteEntry(String string, long l2) {
        this.checkIfPathIsUnderRoot(string);
        String string2 = SVNPathUtil.tail(string);
        SVNURL sVNURL = SVNURL.parseURIEncoded(this.myCurrentDirectory.URL);
        SVNURL sVNURL2 = sVNURL.appendPath(string2, false);
        this.checkIfPathIsUnderRoot(string);
        this.doDeleteEntry(string, this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory, sVNURL2);
    }

    private void handleLeftLocalModificationsError(SVNException sVNException) {
        SVNException sVNException2 = null;
        sVNException2 = sVNException;
        while (sVNException2 != null && sVNException2.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            sVNException2 = sVNException2.getCause() instanceof SVNException ? (SVNException)sVNException2.getCause() : null;
        }
        if (sVNException2 != null) {
            return;
        }
        throw sVNException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDir(String string, String string2, long l2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        SVNAdminArea sVNAdminArea;
        boolean bl2;
        String string3;
        File file;
        block42: {
            Object object5;
            block41: {
                Object object6;
                file = this.myAdminInfo.getAnchor().getFile(string);
                string3 = SVNPathUtil.tail(string);
                bl2 = this.inDeletedTree(file, true);
                sVNAdminArea = this.myCurrentDirectory.getAdminArea();
                SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo = this.myCurrentDirectory;
                this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, string, true);
                this.myCurrentDirectory.myPreviousRevision = -1L;
                this.myCurrentDirectory.myAmbientDepth = string.equals(this.myTarget) ? (this.myRequestedDepth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : this.myRequestedDepth) : (this.myRequestedDepth == SVNDepth.IMMEDIATES || this.myRequestedDepth == SVNDepth.UNKNOWN && sVNUpdateEditor$SVNDirectoryInfo.myAmbientDepth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : SVNDepth.INFINITY);
                sVNUpdateEditor$SVNDirectoryInfo.flushLog();
                this.checkIfPathIsUnderRoot(string);
                if (this.inSkippedTree(file) && !bl2) {
                    return;
                }
                File file2 = this.alreadyInTreeConflict(file);
                if (file2 != null) {
                    this.addSkippedTree(file);
                    object6 = SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, this.myTargetRevision, SVNEventAction.SKIP, SVNEventAction.UPDATE_ADD, null, null);
                    this.myWCAccess.handleEvent((SVNEvent)object6);
                }
                if ((object6 = SVNFileType.getType(file)) == SVNFileType.FILE || object6 == SVNFileType.UNKNOWN) {
                    object4 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': a non-directory object of the same name already exists", (Object)string);
                    SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
                } else if (object6 == SVNFileType.NONE && (object4 = sVNAdminArea.getEntry(string3, false)) != null && ((SVNEntry)object4).isDirectory() && ((SVNEntry)object4).isScheduledForDeletion()) {
                    this.addDeletedTree(file);
                    bl2 = true;
                }
                if (object6 == SVNFileType.DIRECTORY) {
                    Object object7;
                    object4 = null;
                    try {
                        object4 = SVNWCAccess.newInstance(null).open(file, false, 0);
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                            throw sVNException;
                        }
                        if (this.myIsUnversionedObstructionsAllowed) {
                            this.myCurrentDirectory.isExisted = true;
                        }
                        object7 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': an unversioned directory of the same name already exists", (Object)this.myCurrentDirectory.getPath());
                        SVNErrorManager.error((SVNErrorMessage)object7, SVNLogType.WC);
                    }
                    if (object4 != null) {
                        try {
                            object3 = ((SVNAdminArea)object4).getEntry(((SVNAdminArea)object4).getThisDirName(), false);
                            object7 = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
                            object5 = (SVNEntry)sVNAdminArea.getEntries().get(string3);
                            if (object3 != null && object7 != null && ((SVNEntry)object3).getUUID() != null && ((SVNEntry)object7).getUUID() != null && !((SVNEntry)object3).getUUID().equals(((SVNEntry)object7).getUUID())) {
                                object2 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "UUID mismatch: existing directory ''{0}'' was checked out from a different repository", (Object)this.myCurrentDirectory.getPath());
                                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                            }
                            if (object3 != null && this.mySwitchURL == null && this.myCurrentDirectory.URL != null && !this.myCurrentDirectory.URL.equals(((SVNEntry)object3).getURL())) {
                                object2 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "URL ''{0}'' of existing directory ''{1}'' does not match expected URL ''{2}''", ((SVNEntry)object3).getURL(), this.myCurrentDirectory.getPath(), this.myCurrentDirectory.URL);
                                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                            }
                            if (object5 == null) {
                                object2 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': a versioned directory of the same name already exists", (Object)this.myCurrentDirectory.getPath());
                                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                            }
                            if (object3 != null && (((SVNEntry)object3).isScheduledForAddition() || ((SVNEntry)object3).isScheduledForReplacement()) && !((SVNEntry)object3).isCopied()) {
                                this.myCurrentDirectory.isAddExisted = true;
                                break block41;
                            }
                            object2 = SVNURL.parseURIEncoded(this.myCurrentDirectory.URL);
                            object = this.checkTreeConflict(file, (SVNEntry)object3, sVNAdminArea, sVNUpdateEditor$SVNDirectoryInfo.getLog(), SVNConflictAction.ADD, SVNNodeKind.DIR, (SVNURL)object2);
                            try {
                                sVNUpdateEditor$SVNDirectoryInfo.flushLog();
                            }
                            catch (SVNException sVNException) {
                                SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage().wrap("Error writing log file for ''{0}''", sVNUpdateEditor$SVNDirectoryInfo.getPath());
                                SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.WC);
                            }
                            if (object != null) {
                                this.addSkippedTree(file);
                                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, this.myTargetRevision, SVNEventAction.TREE_CONFLICT, SVNEventAction.UPDATE_ADD, null, null);
                                if (object3 != null) {
                                    sVNEvent.setPreviousRevision(((SVNEntry)object3).getRevision());
                                    sVNEvent.setPreviousURL(((SVNEntry)object3).getSVNURL());
                                }
                                this.myWCAccess.handleEvent(sVNEvent);
                                return;
                            }
                        }
                        finally {
                            ((SVNAdminArea)object4).getWCAccess().close();
                        }
                    }
                }
            }
            if (SVNFileUtil.getAdminDirectoryName().equals(string3)) {
                object4 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'':  object of the same name as the administrative directory", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
            }
            if (string2 != null || SVNRevision.isValidRevisionNumber(l2)) {
                object4 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Failed to add directory ''{0}'': copyfrom arguments not yet supported", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
            }
            object4 = sVNAdminArea.getEntry(string3, false);
            object3 = new SVNHashMap();
            object3.put("svn:entry:kind", "dir");
            object3.put("svn:entry:absent", null);
            object3.put("svn:entry:deleted", null);
            boolean bl3 = false;
            if (this.myCurrentDirectory.isAddExisted) {
                object3.put("svn:entry:schedule", null);
                bl3 = true;
            }
            object4 = sVNAdminArea.modifyEntry(string3, (Map)object3, true, bl3);
            if (this.myCurrentDirectory.isAddExisted) {
                object3.put("svn:entry:revision", Long.toString(this.myTargetRevision));
                if (this.mySwitchURL != null) {
                    object3.put("svn:entry:url", this.myCurrentDirectory.URL);
                }
                object5 = this.myCurrentDirectory.getAdminArea();
                ((SVNAdminArea)object5).modifyEntry(((SVNAdminArea)object5).getThisDirName(), (Map)object3, true, true);
            }
            object5 = null;
            if (this.myRootURL != null && SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
                object5 = this.myRootURL;
            }
            SVNWCManager.ensureAdminAreaExists(file, this.myCurrentDirectory.URL, (String)object5, null, this.myTargetRevision, this.myCurrentDirectory.myAmbientDepth);
            object2 = null;
            if (!this.myAdminInfo.getAnchor().getRoot().equals(file)) {
                object = this.myWCAccess.getEventHandler();
                try {
                    this.myWCAccess.setEventHandler(null);
                    object2 = this.myWCAccess.open(file, true, 0);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                        object2 = this.myWCAccess.retrieve(file);
                        break block42;
                    }
                    throw sVNException;
                }
                finally {
                    this.myWCAccess.setEventHandler((ISVNEventHandler)object);
                }
            }
        }
        if (bl2) {
            object3.clear();
            object3.put("svn:entry:schedule", "delete");
            sVNAdminArea.modifyEntry(string3, (Map)object3, true, false);
            object2 = this.myWCAccess.retrieve(file);
            ((SVNAdminArea)object2).modifyEntry(((SVNAdminArea)object2).getThisDirName(), (Map)object3, true, false);
        }
        try {
            object2 = this.myWCAccess.open(file, true, 0);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                object2 = this.myWCAccess.retrieve(file);
            }
            throw sVNException;
        }
        if (object2 != null) {
            this.myWCAccess.registerCleanupHandler((SVNAdminArea)object2, this.myCurrentDirectory);
        }
        if (!this.myCurrentDirectory.isAddExisted && !bl2) {
            object = SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(((SVNEntry)object4).getName()), SVNNodeKind.DIR, null, this.myTargetRevision, this.myCurrentDirectory.isExisted ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_ADD, null, null, null);
            ((SVNEvent)object).setPreviousRevision(this.myCurrentDirectory.myPreviousRevision);
            ((SVNEvent)object).setPreviousURL(((SVNEntry)object4).getSVNURL());
            ((SVNEvent)object).setURL(this.myCurrentDirectory.URL != null ? SVNURL.parseURIEncoded(this.myCurrentDirectory.URL) : null);
            this.myWCAccess.handleEvent((SVNEvent)object);
        }
    }

    @Override
    public void openDir(String string, long l2) {
        Object object;
        SVNConflictDescription sVNConflictDescription;
        this.myCurrentDirectory.flushLog();
        this.checkIfPathIsUnderRoot(string);
        SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo = this.myCurrentDirectory;
        this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, string, false);
        SVNAdminArea sVNAdminArea = this.myCurrentDirectory.getAdminArea();
        this.myWCAccess.registerCleanupHandler(sVNAdminArea, this.myCurrentDirectory);
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), true);
        if (sVNEntry != null) {
            this.myCurrentDirectory.myPreviousRevision = sVNEntry.getRevision();
            this.myCurrentDirectory.myAmbientDepth = sVNEntry.getDepth();
            this.myCurrentDirectory.wasIncomplete = sVNEntry.isIncomplete();
        } else {
            this.myCurrentDirectory.myPreviousRevision = -1L;
        }
        File file = this.myAdminInfo.getAnchor().getFile(string);
        if (this.inSkippedTree(file) && !this.inDeletedTree(file, true)) {
            this.myCurrentDirectory.isSkipped = true;
            return;
        }
        File file2 = this.alreadyInTreeConflict(file);
        if (file2 != null) {
            sVNConflictDescription = null;
        } else {
            SVNURL sVNURL = SVNURL.parseURIEncoded(this.myCurrentDirectory.URL);
            sVNConflictDescription = this.checkTreeConflict(file, sVNEntry, sVNUpdateEditor$SVNDirectoryInfo.getAdminArea(), sVNUpdateEditor$SVNDirectoryInfo.getLog(), SVNConflictAction.EDIT, SVNNodeKind.DIR, sVNURL);
            if (sVNConflictDescription != null && sVNConflictDescription.getConflictAction() == SVNConflictAction.EDIT) {
                this.myCurrentDirectory.treeConflictCreationAttributes = this.getTreeConflictCreationAttributes(sVNUpdateEditor$SVNDirectoryInfo.getAdminArea(), (SVNTreeConflictDescription)sVNConflictDescription);
            }
        }
        if (sVNConflictDescription != null && sVNConflictDescription.getConflictReason() == SVNConflictReason.DELETED && !this.inDeletedTree(file, true)) {
            this.addDeletedTree(file);
        }
        boolean bl2 = sVNAdminArea.hasPropConflict(sVNAdminArea.getThisDirName());
        if (file2 != null || sVNConflictDescription != null || bl2) {
            if (!this.inDeletedTree(file, true)) {
                this.myCurrentDirectory.isSkipped = true;
            }
            this.addSkippedTree(file);
            if (!this.inDeletedTree(file, false)) {
                object = bl2 ? SVNEventAction.SKIP : SVNEventAction.TREE_CONFLICT;
                SVNStatusType sVNStatusType = bl2 ? SVNStatusType.CONFLICTED : null;
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, this.myTargetRevision, null, sVNStatusType, null, (SVNEventAction)object, SVNEventAction.UPDATE_UPDATE, null, null);
                sVNEvent.setPreviousRevision(this.myCurrentDirectory.myPreviousRevision);
                if (this.myCurrentDirectory.URL != null) {
                    sVNEvent.setURL(SVNURL.parseURIEncoded(this.myCurrentDirectory.URL));
                }
                if (sVNEntry != null) {
                    sVNEvent.setPreviousURL(sVNEntry.getSVNURL());
                }
                this.myWCAccess.handleEvent(sVNEvent);
            }
            if (bl2 || sVNConflictDescription != null && sVNConflictDescription.getConflictReason() != SVNConflictReason.DELETED) {
                return;
            }
        }
        object = new SVNHashMap();
        object.put("svn:entry:revision", Long.toString(this.myTargetRevision));
        object.put("svn:entry:url", this.myCurrentDirectory.URL);
        object.put("svn:entry:incomplete", Boolean.TRUE.toString());
        if (this.myRootURL != null && SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
            object.put("svn:entry:repos", this.myRootURL);
        }
        sVNEntry = sVNAdminArea.modifyEntry(sVNAdminArea.getThisDirName(), (Map)object, true, false);
    }

    @Override
    public void absentDir(String string) {
        this.absentEntry(string, SVNNodeKind.DIR);
    }

    @Override
    public void absentFile(String string) {
        this.absentEntry(string, SVNNodeKind.FILE);
    }

    private void absentEntry(String string, SVNNodeKind sVNNodeKind) {
        Serializable serializable;
        String string2 = SVNPathUtil.tail(string);
        SVNAdminArea sVNAdminArea = this.myCurrentDirectory.getAdminArea();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(string2, false);
        if (sVNEntry != null && sVNEntry.isScheduledForAddition()) {
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to mark ''{0}'' absent: item of the same name is already scheduled for addition", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        serializable = new SVNHashMap();
        serializable.put("svn:entry:revision", Long.toString(this.myTargetRevision));
        serializable.put("svn:entry:kind", sVNNodeKind.toString());
        serializable.put("svn:entry:deleted", null);
        serializable.put("svn:entry:absent", Boolean.TRUE.toString());
        sVNEntry = sVNAdminArea.modifyEntry(string2, (Map)((Object)serializable), true, false);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (!this.myCurrentDirectory.isSkipped) {
            this.myCurrentDirectory.propertyChanged(string, sVNPropertyValue);
        }
    }

    private void clearWCProperty(SVNAdminArea sVNAdminArea, String string) {
        if (sVNAdminArea == null) {
            return;
        }
        Iterator iterator = sVNAdminArea.entries(false);
        while (iterator.hasNext()) {
            Object object;
            SVNEntry sVNEntry = (SVNEntry)iterator.next();
            if (string != null) {
                if (!sVNEntry.isFile() || !string.equals(sVNEntry.getName())) continue;
                object = sVNAdminArea.getWCProperties(sVNEntry.getName());
                ((SVNVersionedProperties)object).setPropertyValue("svn:wc:ra_dav:version-url", null);
                sVNAdminArea.saveWCProperties(false);
                continue;
            }
            if (sVNEntry.isFile() || sVNAdminArea.getThisDirName().equals(sVNEntry.getName())) {
                object = sVNAdminArea.getWCProperties(sVNEntry.getName());
                ((SVNVersionedProperties)object).setPropertyValue("svn:wc:ra_dav:version-url", null);
                sVNAdminArea.saveWCProperties(false);
                continue;
            }
            object = this.myAdminInfo.getWCAccess().getAdminArea(sVNAdminArea.getFile(sVNEntry.getName()));
            this.clearWCProperty((SVNAdminArea)object, null);
        }
    }

    @Override
    public void closeDir() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        File file = this.myAdminInfo.getAnchor().getFile(this.myCurrentDirectory.getPath());
        if (this.inSkippedTree(file) && !this.inDeletedTree(file, true)) {
            this.maybeBumpDirInfo(this.myCurrentDirectory);
            this.myCurrentDirectory = this.myCurrentDirectory.Parent;
            return;
        }
        SVNProperties sVNProperties = this.myCurrentDirectory.getChangedWCProperties();
        SVNProperties sVNProperties2 = this.myCurrentDirectory.getChangedEntryProperties();
        SVNProperties sVNProperties3 = this.myCurrentDirectory.getChangedProperties();
        if (!this.myCurrentDirectory.anyChangesInChildren && (sVNProperties3 == null || sVNProperties3.isEmpty())) {
            if (this.myCurrentDirectory.treeConflictCreationAttributes != null && (object4 = this.myCurrentDirectory.Parent) != null) {
                object3 = ((SVNUpdateEditor$SVNDirectoryInfo)object4).getLog();
                ((SVNLog)object3).deleteCommandsByNameAndAttributes("add-tree-conflict", this.myCurrentDirectory.treeConflictCreationAttributes, false);
            }
        } else {
            object4 = this.myCurrentDirectory.Parent;
            if (object4 != null) {
                ((SVNUpdateEditor$SVNDirectoryInfo)object4).anyChangesInChildren = true;
            }
        }
        object4 = SVNStatusType.UNKNOWN;
        object3 = this.myCurrentDirectory.getAdminArea();
        if (this.myCurrentDirectory.wasIncomplete) {
            object2 = ((SVNAdminArea)object3).getBaseProperties(((SVNAdminArea)object3).getThisDirName());
            object = ((SVNVersionedProperties)object2).asMap();
            if (sVNProperties3 == null) {
                sVNProperties3 = new SVNProperties();
            }
            for (Object object5 : ((SVNProperties)object).nameSet()) {
                if (sVNProperties3.containsName((String)object5)) continue;
                sVNProperties3.put((String)object5, SVNPropertyValue.create(null));
            }
        }
        if (sVNProperties != null || sVNProperties2 != null || sVNProperties3 != null) {
            object2 = this.myCurrentDirectory.getLog();
            if (sVNProperties3 != null && !sVNProperties3.isEmpty()) {
                Object object5;
                if (sVNProperties3.containsName("svn:externals")) {
                    object = ((SVNAdminArea)object3).getProperties(((SVNAdminArea)object3).getThisDirName()).getStringPropertyValue("svn:externals");
                    String string = sVNProperties3.getStringValue("svn:externals");
                    object5 = this.myCurrentDirectory.getPath();
                    if (object == null && string != null) {
                        this.myAdminInfo.addExternal((String)object5, (String)object, string);
                        this.myAdminInfo.addDepth((String)object5, this.myCurrentDirectory.myAmbientDepth);
                    } else if (object != null && string == null) {
                        this.myAdminInfo.addExternal((String)object5, (String)object, string);
                        this.myAdminInfo.addDepth((String)object5, this.myCurrentDirectory.myAmbientDepth);
                    } else if (object != null && !((String)object).equals(string)) {
                        this.myAdminInfo.addExternal((String)object5, (String)object, string);
                        this.myAdminInfo.addDepth((String)object5, this.myCurrentDirectory.myAmbientDepth);
                    }
                }
                object = ((SVNAdminArea)object3).getBaseProperties(((SVNAdminArea)object3).getThisDirName());
                try {
                    object4 = ((SVNAdminArea)object3).mergeProperties(((SVNAdminArea)object3).getThisDirName(), ((SVNVersionedProperties)object).asMap(), sVNProperties3, null, null, true, false, (SVNLog)object2);
                }
                catch (SVNException sVNException) {
                    object5 = sVNException.getErrorMessage().wrap("Couldn't do property merge");
                    SVNErrorManager.error((SVNErrorMessage)object5, sVNException, SVNLogType.WC);
                }
            }
            ((SVNLog)object2).logChangedEntryProperties(((SVNAdminArea)object3).getThisDirName(), sVNProperties2);
            ((SVNLog)object2).logChangedWCProperties(((SVNAdminArea)object3).getThisDirName(), sVNProperties);
        }
        this.myCurrentDirectory.flushLog();
        this.myCurrentDirectory.runLogs();
        this.maybeBumpDirInfo(this.myCurrentDirectory);
        this.handleDuplicateEntries();
        if (!(this.myCurrentDirectory.isSkipped || !this.myCurrentDirectory.isAddExisted && this.myCurrentDirectory.IsAdded || this.inDeletedTree(file, true) || object3 == this.myAdminInfo.getAnchor() && !"".equals(this.myAdminInfo.getTargetName()))) {
            Object object6 = object2 = this.myCurrentDirectory.isAddExisted || this.myCurrentDirectory.isExisted ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_UPDATE;
            if (object4 == SVNStatusType.UNKNOWN && object2 != SVNEventAction.UPDATE_EXISTS) {
                object2 = SVNEventAction.UPDATE_NONE;
            }
            object = SVNEventFactory.createSVNEvent(((SVNAdminArea)object3).getRoot(), SVNNodeKind.DIR, null, this.myTargetRevision, SVNStatusType.UNKNOWN, (SVNStatusType)object4, null, (SVNEventAction)object2, null, null, null);
            ((SVNEvent)object).setPreviousRevision(this.myCurrentDirectory.myPreviousRevision);
            ((SVNEvent)object).setURL(this.myCurrentDirectory.URL != null ? SVNURL.parseURIEncoded(this.myCurrentDirectory.URL) : null);
            this.myWCAccess.handleEvent((SVNEvent)object);
        }
        this.myCurrentDirectory = this.myCurrentDirectory.Parent;
    }

    private void handleDuplicateEntries() {
        Object object;
        Object object22;
        if (!SVNFileUtil.isCaseInsensitiveFS()) {
            return;
        }
        SVNAdminArea sVNAdminArea = this.myCurrentDirectory.getAdminArea();
        Map map = sVNAdminArea.getEntries();
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        for (Object object22 : map.keySet()) {
            object = (SVNEntry)map.get(object22);
            if (object == null || ((SVNEntry)object).getKind() != SVNNodeKind.FILE || ((SVNEntry)object).isHidden() || hashSet.add(object22 = ((String)object22).toLowerCase())) continue;
            hashSet2.add(object22);
        }
        if (hashSet2.isEmpty()) {
            return;
        }
        Object object3 = null;
        object22 = map.keySet().iterator();
        while (object22.hasNext()) {
            this.myCurrentDirectory.flushLog();
            object3 = this.myCurrentDirectory.getLog();
            object = (String)object22.next();
            SVNEntry sVNEntry = (SVNEntry)map.get(object);
            if (sVNEntry == null || sVNEntry.getKind() != SVNNodeKind.FILE || sVNEntry.isHidden() || !hashSet2.contains(((String)object).toLowerCase())) continue;
            SVNProperties sVNProperties = new SVNProperties();
            sVNProperties.put("name", (String)object);
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:absent"), Boolean.TRUE.toString());
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:checksum"), "nameconflict");
            ((SVNLog)object3).addCommand("modify-entry", sVNProperties, false);
            sVNProperties.clear();
            sVNProperties.put("name", SVNAdminUtil.getTextBasePath((String)object, false));
            ((SVNLog)object3).addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
            sVNProperties.put("name", SVNAdminUtil.getTextRevertPath((String)object, false));
            ((SVNLog)object3).addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
            sVNProperties.put("name", SVNAdminUtil.getPropBasePath((String)object, SVNNodeKind.FILE, false));
            ((SVNLog)object3).addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
            sVNProperties.put("name", SVNAdminUtil.getPropPath((String)object, SVNNodeKind.FILE, false));
            ((SVNLog)object3).addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
            sVNProperties.put("name", SVNAdminUtil.getPropRevertPath((String)object, SVNNodeKind.FILE, false));
            ((SVNLog)object3).addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
            sVNProperties.put("name", sVNEntry.getName());
            ((SVNLog)object3).addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNAdminArea.getFile((String)object), SVNNodeKind.FILE, null, this.myTargetRevision, SVNEventAction.UPDATE_DELETE, null, null, null);
            this.myWCAccess.handleEvent(sVNEvent);
        }
        this.myCurrentDirectory.flushLog();
        this.myCurrentDirectory.runLogs();
    }

    @Override
    public SVNCommitInfo closeEdit() {
        if (this.myTarget != null && this.myWCAccess.isMissing(this.myAdminInfo.getAnchor().getFile(this.myTarget))) {
            this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
            this.myWCAccess.registerCleanupHandler(this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory);
            this.doDeleteEntry(this.myTarget, this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory, null);
        }
        if (!this.myIsRootOpen) {
            if (this.myCurrentDirectory == null) {
                this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
            }
            this.completeDirectory(this.myCurrentDirectory);
        }
        if (!this.myIsTargetDeleted) {
            File file = this.myTarget != null ? this.myAdminInfo.getAnchor().getFile(this.myTarget) : this.myAdminInfo.getAnchor().getRoot();
            this.getSkippedTrees().removeAll(this.getDeletedTrees());
            SVNWCManager.updateCleanup(file, this.myWCAccess, this.mySwitchURL, this.myRootURL, this.myTargetRevision, true, this.getSkippedTrees(), this.myRequestedDepth, this.myIsLockOnDemand);
        }
        return null;
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        this.myCurrentFile = this.addFile(this.myCurrentDirectory, string, string2, l2);
    }

    @Override
    public void openFile(String string, long l2) {
        this.myCurrentFile = this.openFile(string, this.myCurrentDirectory);
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        this.changeFileProperty(string2, sVNPropertyValue, this.myCurrentFile);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        Serializable serializable;
        String string3;
        if (this.myCurrentFile.isSkipped) {
            return;
        }
        this.myCurrentFile.receivedTextDelta = true;
        SVNAdminArea sVNAdminArea = this.myCurrentFile.getAdminArea();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(this.myCurrentFile.name, false);
        boolean bl2 = sVNEntry != null && sVNEntry.isScheduledForReplacement();
        boolean bl3 = bl2;
        if (bl3) {
            this.myCurrentFile.baseFile = sVNAdminArea.getFile(SVNAdminUtil.getTextRevertPath(this.myCurrentFile.name, false));
            this.myCurrentFile.newBaseFile = sVNAdminArea.getFile(SVNAdminUtil.getTextRevertPath(this.myCurrentFile.name, true));
        } else {
            this.myCurrentFile.baseFile = sVNAdminArea.getBaseFile(this.myCurrentFile.name, false);
            this.myCurrentFile.newBaseFile = sVNAdminArea.getBaseFile(this.myCurrentFile.name, true);
        }
        String string4 = string3 = sVNEntry != null ? sVNEntry.getChecksum() : null;
        if (!bl2 && string2 != null && string3 != null && !string2.equals(string3)) {
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch for ''{0}''; expected: ''{1}'', recorded: ''{2}''", this.myCurrentFile.baseFile, string2, string3);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        serializable = null;
        if (!this.myCurrentFile.IsAdded) {
            serializable = this.myCurrentFile.baseFile;
        } else if (SVNUpdateEditor$SVNFileInfo.access$300(this.myCurrentFile) != null) {
            serializable = SVNUpdateEditor$SVNFileInfo.access$300(this.myCurrentFile);
        }
        if (bl2 || string3 == null) {
            string3 = string2;
        }
        File file = this.myCurrentFile.newBaseFile;
        if (string3 != null) {
            this.myCurrentFile.expectedSrcChecksum = string3;
            InputStream inputStream = serializable != null && serializable.exists() ? SVNFileUtil.openFileForReading(serializable) : SVNFileUtil.DUMMY_IN;
            SVNUpdateEditor$SVNFileInfo.access$402(this.myCurrentFile, inputStream != SVNFileUtil.DUMMY_IN ? new SVNChecksumInputStream(inputStream, "MD5") : null);
            this.myDeltaProcessor.applyTextDelta(SVNUpdateEditor$SVNFileInfo.access$400(this.myCurrentFile) != null ? SVNUpdateEditor$SVNFileInfo.access$400(this.myCurrentFile) : inputStream, file, true);
        } else {
            this.myDeltaProcessor.applyTextDelta((File)serializable, file, true);
        }
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        if (!this.myCurrentFile.isSkipped) {
            try {
                this.myDeltaProcessor.textDeltaChunk(sVNDiffWindow);
            }
            catch (SVNException sVNException) {
                this.myDeltaProcessor.textDeltaEnd();
                SVNFileUtil.deleteFile(this.myCurrentFile.newBaseFile);
                this.myCurrentFile.newBaseFile = null;
                throw sVNException;
            }
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String string) {
        if (!this.myCurrentFile.isSkipped) {
            this.myCurrentFile.checksum = this.myDeltaProcessor.textDeltaEnd();
        }
        if (this.myCurrentFile.expectedSrcChecksum != null) {
            String string2;
            String string3 = string2 = SVNUpdateEditor$SVNFileInfo.access$400(this.myCurrentFile) != null ? SVNUpdateEditor$SVNFileInfo.access$400(this.myCurrentFile).getDigest() : null;
            if (!this.myCurrentFile.expectedSrcChecksum.equals(string2)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch while updating ''{0}''; expected: ''{1}'', actual: ''{2}''", this.myCurrentFile.baseFile, this.myCurrentFile.expectedSrcChecksum, string2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        }
    }

    @Override
    public void closeFile(String string, String string2) {
        this.closeFile(string2, this.myCurrentFile, this.myCurrentDirectory);
        this.myCurrentFile = null;
    }

    @Override
    public void abortEdit() {
    }

    private void checkIfPathIsUnderRoot(String string) {
        if (SVNFileUtil.isWindows && string != null) {
            String string2 = string.replace(File.separatorChar, '/');
            int n2 = -1;
            while (string2.length() > 0 && (n2 = string2.indexOf("..")) != -1) {
                if (n2 == 0 || string2.charAt(n2 - 1) == '/') {
                    SVNErrorMessage sVNErrorMessage;
                    int n3;
                    for (n3 = n2 + 2; n3 < string2.length(); ++n3) {
                        if (string2.charAt(n3) == '.') continue;
                        if (string2.charAt(n3) != '/') break;
                        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' is not in the working copy", (Object)string);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    if (n3 == string2.length()) {
                        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' is not in the working copy", (Object)string);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    string2 = string2.substring(n3);
                    continue;
                }
                string2 = string2.substring(n2 + 2);
            }
        }
    }

    private void maybeBumpDirInfo(SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo) {
        while (sVNUpdateEditor$SVNDirectoryInfo != null) {
            --sVNUpdateEditor$SVNDirectoryInfo.RefCount;
            if (sVNUpdateEditor$SVNDirectoryInfo.RefCount > 0) {
                return;
            }
            if (!sVNUpdateEditor$SVNDirectoryInfo.isSkipped) {
                this.completeDirectory(sVNUpdateEditor$SVNDirectoryInfo);
            }
            sVNUpdateEditor$SVNDirectoryInfo = sVNUpdateEditor$SVNDirectoryInfo.Parent;
        }
    }

    private void completeDirectory(SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo) {
        Object object;
        File file = this.myAdminInfo.getAnchor().getFile(sVNUpdateEditor$SVNDirectoryInfo.getPath());
        if (this.inSkippedTree(file) && !this.inDeletedTree(file, true)) {
            return;
        }
        if (sVNUpdateEditor$SVNDirectoryInfo.Parent == null && this.myTarget != null) {
            SVNAdminArea sVNAdminArea;
            SVNEntry sVNEntry;
            if ((this.myIsDepthSticky || this.myTarget != null) && (sVNEntry = (sVNAdminArea = sVNUpdateEditor$SVNDirectoryInfo.getAdminArea()).getEntry(this.myTarget, true)) != null && sVNEntry.getDepth() == SVNDepth.EXCLUDE) {
                File file2 = this.myAdminInfo.getAnchor().getFile(this.myTarget);
                SVNAdminArea sVNAdminArea2 = this.myWCAccess.getAdminArea(file2);
                if (sVNAdminArea2 == null && sVNEntry.isDirectory()) {
                    this.doDeleteEntry(this.myTarget, this.myAdminInfo.getAnchor(), null, null);
                } else {
                    sVNEntry.setDepth(SVNDepth.INFINITY);
                    sVNAdminArea.saveEntries(false);
                }
            }
            return;
        }
        SVNAdminArea sVNAdminArea = sVNUpdateEditor$SVNDirectoryInfo.getAdminArea();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), true);
        if (sVNEntry == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No ''.'' entry found in ''{0}''", (Object)sVNAdminArea.getRoot());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        sVNEntry.setIncomplete(false);
        if (!this.myIsDepthSticky && sVNEntry.isThisDir() && this.myRequestedDepth == SVNDepth.IMMEDIATES) {
            int n2 = SVNPathUtil.getSegmentsCount(sVNUpdateEditor$SVNDirectoryInfo.getPath());
            if (this.myTarget != null && !"".equals(this.myTarget)) {
                --n2;
            }
            if (n2 > 0 && ((object = sVNUpdateEditor$SVNDirectoryInfo.myAmbientDepth) == null || object == SVNDepth.UNKNOWN || ((SVNDepth)object).compareTo(SVNDepth.EMPTY) > 0)) {
                sVNEntry.setIncomplete(true);
            }
        }
        File file3 = this.myAdminInfo.getTarget().getRoot();
        if (this.myIsDepthSticky && (this.myRequestedDepth == SVNDepth.INFINITY || sVNAdminArea.getRoot().equals(file3) && this.myRequestedDepth.compareTo(sVNEntry.getDepth()) > 0)) {
            sVNEntry.setDepth(this.myRequestedDepth);
            this.myAdminInfo.addDepth(sVNUpdateEditor$SVNDirectoryInfo.getPath(), this.myRequestedDepth);
        }
        object = sVNAdminArea.entries(true);
        while (object.hasNext()) {
            SVNEntry sVNEntry2 = (SVNEntry)object.next();
            if (sVNEntry2.isDeleted()) {
                if (!sVNEntry2.isScheduledForAddition()) {
                    sVNAdminArea.deleteEntry(sVNEntry2.getName());
                    continue;
                }
                SVNHashMap sVNHashMap = new SVNHashMap();
                sVNHashMap.put("svn:entry:deleted", null);
                sVNAdminArea.modifyEntry(sVNEntry2.getName(), sVNHashMap, false, false);
                continue;
            }
            if (sVNEntry2.isAbsent() && sVNEntry2.getRevision() != this.myTargetRevision) {
                sVNAdminArea.deleteEntry(sVNEntry2.getName());
                continue;
            }
            if (sVNEntry2.getKind() != SVNNodeKind.DIR) continue;
            if (sVNEntry2.getDepth() == SVNDepth.EXCLUDE) {
                if (!this.myIsDepthSticky || this.myRequestedDepth.compareTo(SVNDepth.IMMEDIATES) < 0) continue;
                sVNEntry2.setDepth(SVNDepth.INFINITY);
                continue;
            }
            if (!this.myWCAccess.isMissing(sVNAdminArea.getFile(sVNEntry2.getName())) || sVNEntry2.isAbsent() || sVNEntry2.isScheduledForAddition()) continue;
            sVNAdminArea.deleteEntry(sVNEntry2.getName());
            this.myWCAccess.handleEvent(SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(sVNEntry2.getName()), sVNEntry2.getKind(), null, sVNEntry2.getRevision(), SVNEventAction.UPDATE_DELETE, null, null, null));
        }
        sVNAdminArea.saveEntries(true);
    }

    private SVNUpdateEditor$SVNFileInfo addFile(SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo, String string, String string2, long l2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        File file = this.myAdminInfo.getAnchor().getFile(string);
        boolean bl2 = this.inDeletedTree(file, true);
        if (!(string2 == null && !SVNRevision.isValidRevisionNumber(l2) || string2 != null && SVNRevision.isValidRevisionNumber(l2))) {
            object4 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "Bad copyfrom arguments received.");
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.DEFAULT);
        }
        object4 = this.createFileInfo(this.myCurrentDirectory, string, true);
        if (this.inSkippedTree(file) && !bl2) {
            ((SVNUpdateEditor$SVNFileInfo)object4).isSkipped = true;
            return object4;
        }
        SVNUpdateEditor$SVNFileInfo.access$502((SVNUpdateEditor$SVNFileInfo)object4, bl2);
        this.checkIfPathIsUnderRoot(string);
        SVNAdminArea sVNAdminArea = sVNUpdateEditor$SVNDirectoryInfo.getAdminArea();
        SVNFileType sVNFileType = SVNFileType.getType(sVNAdminArea.getFile(((SVNUpdateEditor$SVNFileInfo)object4).name));
        SVNEntry sVNEntry = sVNAdminArea.getEntry(((SVNUpdateEditor$SVNFileInfo)object4).name, false);
        File file2 = this.alreadyInTreeConflict(file);
        if (file2 != null) {
            ((SVNUpdateEditor$SVNFileInfo)object4).isSkipped = true;
            this.addSkippedTree(file);
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, this.myTargetRevision, SVNEventAction.SKIP, SVNEventAction.UPDATE_ADD, null, null);
            if (sVNEntry != null) {
                sVNEvent.setPreviousRevision(sVNEntry.getRevision());
                sVNEvent.setPreviousURL(sVNEntry.getSVNURL());
            }
            this.myWCAccess.handleEvent(sVNEvent);
            return object4;
        }
        if (sVNFileType == SVNFileType.DIRECTORY || sVNFileType == SVNFileType.UNKNOWN) {
            object3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': a non-file object of the same name already exists", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
        }
        if (sVNEntry != null && sVNFileType == SVNFileType.NONE && sVNEntry.isDirectory() && sVNEntry.isScheduledForAddition()) {
            sVNAdminArea.deleteEntry(sVNEntry.getName());
            sVNAdminArea.saveEntries(false);
            sVNEntry = null;
        }
        if (sVNEntry == null && (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK)) {
            if (this.myIsUnversionedObstructionsAllowed) {
                ((SVNUpdateEditor$SVNFileInfo)object4).isExisted = true;
            } else {
                object3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': an unversioned file of the same name already exists", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
        }
        if (sVNEntry != null) {
            object3 = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
            if (sVNEntry.getUUID() != null && !sVNEntry.getUUID().equals(((SVNEntry)object3).getUUID())) {
                object2 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "UUID mismatch: existing file ''{0}'' was checked out from a different repository", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
            }
            if (this.mySwitchURL == null) {
                boolean bl3;
                boolean bl4 = bl3 = ((SVNUpdateEditor$SVNFileInfo)object4).URL == sVNEntry.getURL() || ((SVNUpdateEditor$SVNFileInfo)object4).URL != null && ((SVNUpdateEditor$SVNFileInfo)object4).URL.equals(sVNEntry.getURL());
                if (!bl3) {
                    object = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "URL ''{0}'' of existing file ''{1}'' does not match expected URL ''{2}''", sVNEntry.getURL(), file, ((SVNUpdateEditor$SVNFileInfo)object4).URL);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                }
            }
        }
        if (sVNEntry != null && (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK)) {
            if ((sVNEntry.isScheduledForAddition() || sVNEntry.isScheduledForReplacement()) && !sVNEntry.isCopied()) {
                ((SVNUpdateEditor$SVNFileInfo)object4).isAddExisted = true;
            } else {
                object3 = sVNUpdateEditor$SVNDirectoryInfo.getLog();
                object = this.checkTreeConflict(file, sVNEntry, sVNAdminArea, (SVNLog)object3, SVNConflictAction.ADD, SVNNodeKind.FILE, (SVNURL)(object2 = SVNURL.parseURIEncoded(((SVNUpdateEditor$SVNFileInfo)object4).URL)));
                if (object != null) {
                    this.addSkippedTree(file);
                    ((SVNUpdateEditor$SVNFileInfo)object4).isSkipped = true;
                    SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, this.myTargetRevision, SVNEventAction.TREE_CONFLICT, SVNEventAction.UPDATE_ADD, null, null);
                    sVNEvent.setPreviousRevision(sVNEntry.getRevision());
                    sVNEvent.setPreviousURL(sVNEntry.getSVNURL());
                    this.myWCAccess.handleEvent(sVNEvent);
                    return object4;
                }
            }
        }
        if (string2 != null && !((SVNUpdateEditor$SVNFileInfo)object4).isSkipped) {
            return this.addFileWithHistory(sVNUpdateEditor$SVNDirectoryInfo, (SVNUpdateEditor$SVNFileInfo)object4, string2, l2);
        }
        return object4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNUpdateEditor$SVNFileInfo addFileWithHistory(SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo, SVNUpdateEditor$SVNFileInfo sVNUpdateEditor$SVNFileInfo, String string, long l2) {
        SVNProperties sVNProperties;
        SVNProperties sVNProperties2;
        block14: {
            Object object;
            block13: {
                SVNEntry sVNEntry;
                SVNAdminArea sVNAdminArea;
                block11: {
                    sVNUpdateEditor$SVNFileInfo.addedWithHistory = true;
                    sVNAdminArea = sVNUpdateEditor$SVNDirectoryInfo.getAdminArea();
                    SVNEntry sVNEntry2 = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
                    sVNEntry = null;
                    try {
                        sVNEntry = this.locateCopyFrom(string, l2, sVNAdminArea.getRoot(), sVNEntry2);
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND) break block11;
                        throw sVNException;
                    }
                }
                SVNUpdateEditor$SVNFileInfo.access$302(sVNUpdateEditor$SVNFileInfo, SVNAdminUtil.createTmpFile(sVNAdminArea));
                sVNProperties2 = null;
                sVNProperties = null;
                if (sVNEntry == null) break block13;
                SVNAdminArea sVNAdminArea2 = sVNEntry.getAdminArea();
                String string2 = null;
                if (sVNEntry.isScheduledForReplacement() && sVNEntry.getCopyFromURL() != null) {
                    string2 = SVNAdminUtil.getTextRevertPath(sVNEntry.getName(), false);
                    sVNProperties = sVNProperties2 = sVNAdminArea2.getRevertProperties(sVNEntry.getName()).asMap();
                } else {
                    string2 = SVNAdminUtil.getTextBasePath(sVNEntry.getName(), false);
                    sVNProperties2 = sVNAdminArea2.getBaseProperties(sVNEntry.getName()).asMap();
                    sVNProperties = sVNAdminArea2.getProperties(sVNEntry.getName()).asMap();
                }
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    inputStream = SVNFileUtil.openFileForReading(sVNAdminArea2.getFile(string2));
                    outputStream = SVNFileUtil.openFileForWriting(SVNUpdateEditor$SVNFileInfo.access$300(sVNUpdateEditor$SVNFileInfo));
                    SVNChecksumOutputStream sVNChecksumOutputStream = new SVNChecksumOutputStream(outputStream, "MD5", true);
                    outputStream = sVNChecksumOutputStream;
                    FSRepositoryUtil.copy(inputStream, outputStream, this.myWCAccess);
                    sVNUpdateEditor$SVNFileInfo.copiedBaseChecksum = sVNChecksumOutputStream.getDigest();
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(inputStream);
                    SVNFileUtil.closeFile(outputStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile(inputStream);
                SVNFileUtil.closeFile(outputStream);
                if (sVNAdminArea2.hasTextModifications(sVNEntry.getName(), false, true, false)) {
                    SVNUpdateEditor$SVNFileInfo.access$602(sVNUpdateEditor$SVNFileInfo, SVNAdminUtil.createTmpFile(sVNAdminArea));
                    SVNFileUtil.copyFile(sVNAdminArea2.getFile(sVNEntry.getName()), SVNUpdateEditor$SVNFileInfo.access$600(sVNUpdateEditor$SVNFileInfo), true);
                }
                break block14;
            }
            if (this.myFileFetcher == null) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "No fetch_func supplied to update_editor.");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
            }
            sVNProperties2 = new SVNProperties();
            object = null;
            try {
                object = SVNFileUtil.openFileForWriting(SVNUpdateEditor$SVNFileInfo.access$300(sVNUpdateEditor$SVNFileInfo));
                SVNChecksumOutputStream sVNChecksumOutputStream = new SVNChecksumOutputStream((OutputStream)object, "MD5", true);
                object = sVNChecksumOutputStream;
                this.myFileFetcher.fetchFile(string, l2, (OutputStream)object, sVNProperties2);
                sVNUpdateEditor$SVNFileInfo.copiedBaseChecksum = sVNChecksumOutputStream.getDigest();
            }
            finally {
                SVNFileUtil.closeFile((OutputStream)object);
            }
            sVNProperties = sVNProperties2;
        }
        SVNUpdateEditor$SVNFileInfo.access$702(sVNUpdateEditor$SVNFileInfo, sVNProperties2.getRegularProperties());
        SVNUpdateEditor$SVNFileInfo.access$802(sVNUpdateEditor$SVNFileInfo, sVNProperties.getRegularProperties());
        return sVNUpdateEditor$SVNFileInfo;
    }

    private SVNEntry locateCopyFrom(String string, long l2, File file, SVNEntry sVNEntry) {
        Object object;
        Object object2;
        if (sVNEntry.getRepositoryRoot() == null || sVNEntry.getURL() == null) {
            object2 = SVNErrorMessage.create(SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND, "Destination directory of add-with-history is missing a URL");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        file = new File(SVNPathUtil.validateFilePath(file.getAbsolutePath())).getAbsoluteFile();
        object2 = SVNPathUtil.getPathAsChild(sVNEntry.getRepositoryRootURL().toDecodedString(), sVNEntry.getSVNURL().toDecodedString());
        if (object2 == null) {
            if (sVNEntry.getURL().equals(sVNEntry.getRepositoryRoot())) {
                object2 = "";
            } else {
                object = SVNErrorMessage.create(SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND, "Destination URLs are broken");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
        }
        object2 = "/" + (String)object2;
        String string2 = SVNPathUtil.getCommonPathAncestor((String)(object2 = SVNPathUtil.canonicalizePath((String)object2)), (String)(object = SVNPathUtil.removeTail(string)));
        if ("".equals(string2)) {
            return null;
        }
        int n2 = SVNPathUtil.getSegmentsCount((String)object2) - SVNPathUtil.getSegmentsCount(string2);
        File file2 = file;
        for (int n3 = 0; n3 < n2 && file2 != null; file2 = file2.getParentFile(), ++n3) {
        }
        if (file2 == null) {
            return null;
        }
        SVNFileType sVNFileType = SVNFileType.getType(file2);
        if (sVNFileType != SVNFileType.DIRECTORY) {
            return null;
        }
        SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(null);
        SVNAdminArea sVNAdminArea = null;
        try {
            sVNAdminArea = sVNWCAccess.open(file2, false, 0);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                sVNWCAccess.close();
                return null;
            }
            throw sVNException;
        }
        SVNEntry sVNEntry2 = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
        if (sVNEntry.getUUID() != null && sVNEntry2.getUUID() != null && !sVNEntry.getUUID().equals(sVNEntry2.getUUID())) {
            sVNWCAccess.close();
            return null;
        }
        SVNURL sVNURL = sVNEntry.getRepositoryRootURL().appendPath(string2, false);
        if (!sVNURL.equals(sVNEntry2.getSVNURL())) {
            sVNWCAccess.close();
            return null;
        }
        String string3 = SVNPathUtil.getPathAsChild(string2, string);
        file2 = new File(file2, string3);
        File file3 = file2.getParentFile();
        sVNFileType = SVNFileType.getType(file2);
        if (sVNFileType != SVNFileType.FILE) {
            sVNWCAccess.close();
            return null;
        }
        try {
            sVNWCAccess.close();
            sVNAdminArea = sVNWCAccess.open(file3, false, 0);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                sVNWCAccess.close();
                return null;
            }
            throw sVNException;
        }
        SVNEntry sVNEntry3 = sVNAdminArea.getEntry(file2.getName(), false);
        if (sVNEntry3 == null) {
            sVNWCAccess.close();
            return null;
        }
        if (sVNEntry3.getUUID() != null && sVNEntry.getUUID() != null && !sVNEntry3.getUUID().equals(sVNEntry.getUUID())) {
            sVNWCAccess.close();
            return null;
        }
        SVNURL sVNURL2 = sVNEntry3.getRepositoryRootURL().appendPath(string, false);
        if (!sVNURL2.equals(sVNEntry3.getSVNURL())) {
            sVNWCAccess.close();
            return null;
        }
        if (!SVNRevision.isValidRevisionNumber(sVNEntry3.getCommittedRevision()) || !SVNRevision.isValidRevisionNumber(sVNEntry3.getRevision())) {
            sVNWCAccess.close();
            return null;
        }
        if (sVNEntry3.getCommittedRevision() > l2 || l2 > sVNEntry3.getRevision()) {
            sVNWCAccess.close();
            return null;
        }
        return sVNEntry3;
    }

    private void changeFileProperty(String string, SVNPropertyValue sVNPropertyValue, SVNUpdateEditor$SVNFileInfo sVNUpdateEditor$SVNFileInfo) {
        if (!sVNUpdateEditor$SVNFileInfo.isSkipped) {
            sVNUpdateEditor$SVNFileInfo.propertyChanged(string, sVNPropertyValue);
            if (this.myWCAccess.getOptions().isUseCommitTimes() && "svn:entry:committed-date".equals(string)) {
                sVNUpdateEditor$SVNFileInfo.commitTime = sVNPropertyValue.getString();
                if (sVNUpdateEditor$SVNFileInfo.commitTime != null) {
                    sVNUpdateEditor$SVNFileInfo.commitTime = sVNUpdateEditor$SVNFileInfo.commitTime.trim();
                }
            }
        }
    }

    public SVNUpdateEditor$SVNFileInfo openFile(String string, SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo) {
        SVNURL sVNURL;
        Object object;
        this.checkIfPathIsUnderRoot(string);
        File file = this.myAdminInfo.getAnchor().getFile(string);
        SVNUpdateEditor$SVNFileInfo sVNUpdateEditor$SVNFileInfo = this.createFileInfo(sVNUpdateEditor$SVNDirectoryInfo, string, false);
        SVNAdminArea sVNAdminArea = sVNUpdateEditor$SVNDirectoryInfo.getAdminArea();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNUpdateEditor$SVNFileInfo.name, true);
        if (sVNEntry == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "File ''{0}'' in directory ''{1}'' is not a versioned resource", sVNUpdateEditor$SVNFileInfo.name, sVNAdminArea.getRoot());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl2 = this.inDeletedTree(file, true);
        if (this.inSkippedTree(file) && !bl2) {
            sVNUpdateEditor$SVNFileInfo.isSkipped = true;
            return sVNUpdateEditor$SVNFileInfo;
        }
        File file2 = this.alreadyInTreeConflict(file);
        SVNConflictDescription sVNConflictDescription = null;
        if (file2 == null && (sVNConflictDescription = this.checkTreeConflict(file, sVNEntry, sVNAdminArea, (SVNLog)(object = sVNUpdateEditor$SVNDirectoryInfo.getLog()), SVNConflictAction.EDIT, SVNNodeKind.FILE, sVNURL = SVNURL.parseURIEncoded(sVNUpdateEditor$SVNFileInfo.URL))) != null && sVNConflictDescription.getConflictAction() == SVNConflictAction.EDIT) {
            sVNUpdateEditor$SVNFileInfo.treeConflictCreationAttributes = this.getTreeConflictCreationAttributes(sVNAdminArea, (SVNTreeConflictDescription)sVNConflictDescription);
        }
        object = SVNPathUtil.tail(string);
        boolean bl3 = sVNAdminArea.hasTextConflict((String)object);
        boolean bl4 = sVNAdminArea.hasPropConflict((String)object);
        if (sVNConflictDescription != null && sVNConflictDescription.getConflictReason() == SVNConflictReason.DELETED && !bl2) {
            this.addDeletedTree(file);
            bl2 = true;
        }
        SVNUpdateEditor$SVNFileInfo.access$502(sVNUpdateEditor$SVNFileInfo, bl2);
        if (file2 != null || sVNConflictDescription != null || bl3 || bl4) {
            if (!bl2) {
                sVNUpdateEditor$SVNFileInfo.isSkipped = true;
            }
            this.addSkippedTree(file);
            if (!this.inDeletedTree(file, false)) {
                SVNEventAction sVNEventAction = sVNConflictDescription != null ? SVNEventAction.TREE_CONFLICT : SVNEventAction.SKIP;
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, this.myTargetRevision, bl3 ? SVNStatusType.CONFLICTED : SVNStatusType.UNKNOWN, bl4 ? SVNStatusType.CONFLICTED : SVNStatusType.UNKNOWN, SVNStatusType.LOCK_INAPPLICABLE, sVNEventAction, SVNEventAction.UPDATE_UPDATE, null, null);
                sVNEvent.setPreviousRevision(sVNEntry.getRevision());
                sVNEvent.setURL(sVNEntry.getSVNURL());
                this.myWCAccess.handleEvent(sVNEvent);
            }
        }
        return sVNUpdateEditor$SVNFileInfo;
    }

    private SVNProperties getTreeConflictCreationAttributes(SVNAdminArea sVNAdminArea, SVNTreeConflictDescription sVNTreeConflictDescription) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        sVNHashMap.put(sVNTreeConflictDescription.getPath(), sVNTreeConflictDescription);
        String string = SVNTreeConflictUtil.getTreeConflictData(sVNHashMap);
        SVNProperties sVNProperties = new SVNProperties();
        sVNProperties.put("name", sVNAdminArea.getThisDirName());
        sVNProperties.put("data", string);
        return sVNProperties;
    }

    private void closeFile(String string, SVNUpdateEditor$SVNFileInfo sVNUpdateEditor$SVNFileInfo, SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo) {
        Object object;
        Object object2;
        Object object3;
        String string2;
        Object object4;
        boolean bl2;
        Object object5;
        if (sVNUpdateEditor$SVNFileInfo.isSkipped) {
            this.maybeBumpDirInfo(sVNUpdateEditor$SVNDirectoryInfo);
            return;
        }
        if (!sVNUpdateEditor$SVNFileInfo.receivedTextDelta && (sVNUpdateEditor$SVNFileInfo.getChangedProperties() == null || sVNUpdateEditor$SVNFileInfo.getChangedProperties().isEmpty())) {
            if (sVNUpdateEditor$SVNFileInfo.treeConflictCreationAttributes != null) {
                sVNUpdateEditor$SVNDirectoryInfo.getLog().deleteCommandsByNameAndAttributes("add-tree-conflict", sVNUpdateEditor$SVNFileInfo.treeConflictCreationAttributes, false);
            }
        } else {
            sVNUpdateEditor$SVNDirectoryInfo.anyChangesInChildren = true;
        }
        File file = this.myAdminInfo.getAnchor().getFile(sVNUpdateEditor$SVNFileInfo.getPath());
        if (sVNUpdateEditor$SVNFileInfo.addedWithHistory && !sVNUpdateEditor$SVNFileInfo.receivedTextDelta) {
            boolean bl3;
            SVNErrorManager.assertionFailure(sVNUpdateEditor$SVNFileInfo.baseFile == null && sVNUpdateEditor$SVNFileInfo.newBaseFile == null && SVNUpdateEditor$SVNFileInfo.access$300(sVNUpdateEditor$SVNFileInfo) != null, null, SVNLogType.WC);
            object5 = sVNUpdateEditor$SVNFileInfo.getAdminArea();
            SVNEntry sVNEntry = ((SVNAdminArea)object5).getEntry(sVNUpdateEditor$SVNFileInfo.name, false);
            boolean bl4 = sVNEntry != null && sVNEntry.isScheduledForReplacement();
            boolean bl5 = bl3 = bl4 && sVNEntry.getCopyFromURL() != null;
            if (bl3) {
                sVNUpdateEditor$SVNFileInfo.baseFile = ((SVNAdminArea)object5).getFile(SVNAdminUtil.getTextRevertPath(sVNUpdateEditor$SVNFileInfo.name, false));
                sVNUpdateEditor$SVNFileInfo.newBaseFile = ((SVNAdminArea)object5).getFile(SVNAdminUtil.getTextRevertPath(sVNUpdateEditor$SVNFileInfo.name, true));
            } else {
                sVNUpdateEditor$SVNFileInfo.baseFile = ((SVNAdminArea)object5).getBaseFile(sVNUpdateEditor$SVNFileInfo.name, false);
                sVNUpdateEditor$SVNFileInfo.newBaseFile = ((SVNAdminArea)object5).getBaseFile(sVNUpdateEditor$SVNFileInfo.name, true);
            }
            SVNFileUtil.copyFile(SVNUpdateEditor$SVNFileInfo.access$300(sVNUpdateEditor$SVNFileInfo), sVNUpdateEditor$SVNFileInfo.newBaseFile, true);
            sVNUpdateEditor$SVNFileInfo.checksum = sVNUpdateEditor$SVNFileInfo.copiedBaseChecksum;
        }
        object5 = null;
        boolean bl6 = bl2 = sVNUpdateEditor$SVNFileInfo.newBaseFile != null;
        if (string != null && bl2) {
            if (sVNUpdateEditor$SVNFileInfo.checksum != null && !string.equals(sVNUpdateEditor$SVNFileInfo.checksum)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", sVNUpdateEditor$SVNFileInfo.getPath(), string, sVNUpdateEditor$SVNFileInfo.checksum);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            object5 = string;
        }
        SVNAdminArea sVNAdminArea = sVNUpdateEditor$SVNFileInfo.getAdminArea();
        SVNLog sVNLog = sVNUpdateEditor$SVNDirectoryInfo.getLog();
        String string3 = sVNUpdateEditor$SVNFileInfo.name;
        SVNEntry sVNEntry = sVNAdminArea.getEntry(string3, false);
        if (sVNEntry == null && !sVNUpdateEditor$SVNFileInfo.IsAdded) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", (Object)sVNUpdateEditor$SVNFileInfo.getPath());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        long l2 = sVNEntry != null ? sVNEntry.getRevision() : -1L;
        SVNURL sVNURL = sVNEntry != null ? sVNEntry.getSVNURL() : null;
        SVNProperties sVNProperties = sVNUpdateEditor$SVNFileInfo.getChangedWCProperties();
        SVNProperties sVNProperties2 = sVNUpdateEditor$SVNFileInfo.getChangedEntryProperties();
        SVNProperties sVNProperties3 = sVNUpdateEditor$SVNFileInfo.getChangedProperties();
        String string4 = sVNUpdateEditor$SVNFileInfo.commitTime;
        SVNProperties sVNProperties4 = new SVNProperties();
        SVNStatusType sVNStatusType = SVNStatusType.UNCHANGED;
        SVNStatusType sVNStatusType2 = SVNStatusType.LOCK_UNCHANGED;
        if (this.myAdminInfo.isIncomplete(sVNUpdateEditor$SVNFileInfo.getPath()) && sVNEntry != null) {
            SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getBaseProperties(sVNEntry.getName());
            object4 = sVNVersionedProperties.asMap();
            if (sVNProperties3 == null) {
                sVNProperties3 = new SVNProperties();
            }
            for (String string5 : ((SVNProperties)object4).nameSet()) {
                if (sVNProperties3.containsName(string5)) continue;
                sVNProperties3.put(string5, SVNPropertyValue.create(null));
            }
        }
        boolean bl7 = false;
        if (sVNProperties3 != null && !sVNProperties3.isEmpty()) {
            bl7 = sVNProperties3.containsName("svn:executable") || sVNProperties3.containsName("svn:needs-lock") || sVNProperties3.containsName("svn:keywords") || sVNProperties3.containsName("svn:eol-style") || sVNProperties3.containsName("svnkit:charset") || sVNProperties3.containsName("svn:special");
        }
        object4 = sVNAdminArea.mergeProperties(string3, null, SVNUpdateEditor$SVNFileInfo.access$700(sVNUpdateEditor$SVNFileInfo), SVNUpdateEditor$SVNFileInfo.access$800(sVNUpdateEditor$SVNFileInfo), sVNProperties3, null, null, true, false, sVNLog);
        if (sVNProperties2 != null) {
            sVNStatusType2 = sVNLog.logChangedEntryProperties(string3, sVNProperties2);
        }
        if (sVNProperties != null) {
            sVNLog.logChangedWCProperties(string3, sVNProperties);
        }
        boolean bl8 = false;
        if (SVNUpdateEditor$SVNFileInfo.access$600(sVNUpdateEditor$SVNFileInfo) != null) {
            bl8 = true;
        } else if (sVNEntry != null && sVNEntry.getExternalFilePath() != null && sVNEntry.isScheduledForAddition()) {
            bl8 = false;
        } else if (!sVNUpdateEditor$SVNFileInfo.isExisted) {
            bl8 = sVNAdminArea.hasTextModifications(string3, false, false, false);
        } else if (bl2) {
            bl8 = sVNAdminArea.hasVersionedFileTextChanges(sVNAdminArea.getFile(string3), sVNUpdateEditor$SVNFileInfo.newBaseFile, false);
        }
        boolean bl9 = sVNEntry != null && sVNEntry.isScheduledForReplacement();
        SVNProperties sVNProperties5 = new SVNProperties();
        if (sVNUpdateEditor$SVNFileInfo.isAddExisted) {
            sVNProperties5.put("force", "true");
            sVNProperties5.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "");
        }
        sVNLog.logTweakEntry(string3, sVNUpdateEditor$SVNFileInfo.URL, this.myTargetRevision);
        String string6 = sVNAdminArea.getRoot().getAbsolutePath().replace(File.separatorChar, '/');
        String string7 = null;
        if (sVNUpdateEditor$SVNFileInfo.baseFile != null && (string7 = (string2 = sVNUpdateEditor$SVNFileInfo.baseFile.getAbsolutePath().replace(File.separatorChar, '/')).substring(string6.length())).startsWith("/")) {
            string7 = string7.substring(1);
        }
        string2 = null;
        if (sVNUpdateEditor$SVNFileInfo.newBaseFile != null && (string2 = ((String)(object3 = sVNUpdateEditor$SVNFileInfo.newBaseFile.getAbsolutePath().replace(File.separatorChar, '/'))).substring(string6.length())).startsWith("/")) {
            string2 = string2.substring(1);
        }
        object3 = SVNStatusType.UNCHANGED;
        File file2 = sVNAdminArea.getFile(string3);
        boolean bl10 = false;
        if (string2 != null) {
            sVNStatusType = SVNStatusType.CHANGED;
            if (!bl9) {
                if (!bl8) {
                    if (!SVNUpdateEditor$SVNFileInfo.access$500(sVNUpdateEditor$SVNFileInfo)) {
                        sVNProperties4.put("name", string2);
                        sVNProperties4.put("dest", string3);
                        sVNLog.addCommand("cp-and-translate", sVNProperties4, false);
                        sVNProperties4.clear();
                    }
                } else {
                    object2 = SVNFileType.getType(file2);
                    if (object2 == SVNFileType.NONE && !sVNUpdateEditor$SVNFileInfo.addedWithHistory) {
                        sVNProperties4.put("name", string2);
                        sVNProperties4.put("dest", string3);
                        sVNLog.addCommand("cp-and-translate", sVNProperties4, false);
                        sVNProperties4.clear();
                    } else if (!sVNUpdateEditor$SVNFileInfo.isExisted) {
                        String string8;
                        int n2;
                        int n3;
                        object = null;
                        if (this.myExtensionPatterns != null && this.myExtensionPatterns.length > 0) {
                            n3 = string3.lastIndexOf(46);
                            if (n3 != -1 && n3 != 0 && n3 != string3.length() - 1) {
                                object = string3.substring(n3 + 1);
                            }
                            if (object != null && !"".equals(object)) {
                                n2 = 0;
                                for (int i2 = 0; i2 < this.myExtensionPatterns.length && (n2 = (int)(DefaultSVNOptions.matches(string8 = this.myExtensionPatterns[i2], (String)object) ? 1 : 0)) == 0; ++i2) {
                                }
                                if (n2 == 0) {
                                    object = null;
                                }
                            }
                        }
                        n3 = 0;
                        n2 = 0;
                        File file3 = sVNUpdateEditor$SVNFileInfo.baseFile;
                        if (sVNUpdateEditor$SVNFileInfo.isAddExisted && !bl9) {
                            n3 = 1;
                            file3 = SVNAdminUtil.createTmpFile(sVNAdminArea);
                        } else if (SVNUpdateEditor$SVNFileInfo.access$300(sVNUpdateEditor$SVNFileInfo) != null) {
                            n2 = 1;
                            n3 = 1;
                            file3 = SVNUpdateEditor$SVNFileInfo.access$300(sVNUpdateEditor$SVNFileInfo);
                        }
                        string8 = file3.getAbsolutePath().replace(File.separatorChar, '/');
                        String string9 = string8.substring(string6.length());
                        if (string9.startsWith("/")) {
                            string9 = string9.substring(1);
                        }
                        String string10 = null;
                        string10 = sVNUpdateEditor$SVNFileInfo.addedWithHistory ? ".copied" + (object != null ? "." + (String)object : "") : ".r" + sVNEntry.getRevision() + (object != null ? "." + (String)object : "");
                        String string11 = ".r" + this.myTargetRevision + (object != null ? "." + (String)object : "");
                        String string12 = ".mine" + (object != null ? "." + (String)object : "");
                        object3 = sVNAdminArea.mergeText(string3, file3, sVNAdminArea.getFile(string2), SVNUpdateEditor$SVNFileInfo.access$600(sVNUpdateEditor$SVNFileInfo), string12, string10, string11, sVNProperties3, false, null, sVNLog);
                        if (object3 == SVNStatusType.UNCHANGED) {
                            sVNStatusType = SVNStatusType.MERGED;
                        }
                        if (n3 != 0) {
                            sVNProperties4.put("name", string9);
                            sVNLog.addCommand("rm", sVNProperties4, false);
                            sVNProperties4.clear();
                            if (n2 != 0) {
                                bl10 = true;
                            }
                        }
                        if (SVNUpdateEditor$SVNFileInfo.access$600(sVNUpdateEditor$SVNFileInfo) != null) {
                            String string13 = SVNUpdateEditor$SVNFileInfo.access$600(sVNUpdateEditor$SVNFileInfo).getAbsolutePath().replace(File.separatorChar, '/');
                            String string14 = string13.substring(string6.length());
                            if (string14.startsWith("/")) {
                                string14 = string14.substring(1);
                            }
                            sVNProperties4.put("name", string14);
                            sVNLog.addCommand("rm", sVNProperties4, false);
                            sVNProperties4.clear();
                        }
                    }
                }
            }
        } else {
            if (bl7 && (file2.exists() || SVNFileType.getType(file2) == SVNFileType.SYMLINK)) {
                object2 = SVNAdminUtil.getTextBasePath(string3, true);
                sVNProperties4.put("name", string3);
                sVNProperties4.put("dest", (String)object2);
                sVNLog.addCommand("cp-and-detranslate", sVNProperties4, false);
                sVNProperties4.clear();
                sVNProperties4.put("name", (String)object2);
                sVNProperties4.put("dest", string3);
                sVNLog.addCommand("cp-and-translate", sVNProperties4, false);
                sVNProperties4.clear();
            }
            if (sVNStatusType2 == SVNStatusType.LOCK_UNLOCKED) {
                sVNProperties4.put("name", string3);
                sVNLog.addCommand("maybe-readonly", sVNProperties4, false);
                sVNProperties4.clear();
            }
        }
        if (string2 != null) {
            sVNProperties4.put("name", string2);
            sVNProperties4.put("dest", string7);
            sVNLog.addCommand("mv", sVNProperties4, false);
            sVNProperties4.clear();
            sVNProperties4.put("name", string7);
            sVNLog.addCommand("readonly", sVNProperties4, false);
            sVNProperties4.clear();
            sVNProperties5.put(SVNProperty.shortPropertyName("svn:entry:checksum"), (String)object5);
        }
        if (SVNUpdateEditor$SVNFileInfo.access$500(sVNUpdateEditor$SVNFileInfo) && !bl9) {
            sVNProperties5.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "delete");
        }
        if (sVNProperties5.size() > 0) {
            sVNProperties5.put("name", string3);
            sVNLog.addCommand("modify-entry", sVNProperties5, false);
        }
        if (!bl8 && (sVNUpdateEditor$SVNFileInfo.IsAdded || sVNEntry.getSchedule() == null)) {
            if (string4 != null && !sVNUpdateEditor$SVNFileInfo.isExisted) {
                sVNProperties4.put("name", string3);
                sVNProperties4.put("timestamp", string4);
                sVNLog.addCommand("set-timestamp", sVNProperties4, false);
                sVNProperties4.clear();
            }
            if ((string2 != null || bl7) && !SVNUpdateEditor$SVNFileInfo.access$500(sVNUpdateEditor$SVNFileInfo)) {
                sVNProperties4.put("name", string3);
                sVNProperties4.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
                sVNLog.addCommand("modify-entry", sVNProperties4, false);
                sVNProperties4.clear();
            }
            sVNProperties4.put("name", string3);
            sVNProperties4.put(SVNProperty.shortPropertyName("svn:entry:working-size"), "working");
            sVNLog.addCommand("modify-entry", sVNProperties4, false);
            sVNProperties4.clear();
        }
        if (SVNUpdateEditor$SVNFileInfo.access$300(sVNUpdateEditor$SVNFileInfo) != null && !bl10) {
            object2 = SVNUpdateEditor$SVNFileInfo.access$300(sVNUpdateEditor$SVNFileInfo).getAbsolutePath().replace(File.separatorChar, '/');
            object = ((String)object2).substring(string6.length());
            if (((String)object).startsWith("/")) {
                object = ((String)object).substring(1);
            }
            sVNProperties4.put("name", (String)object);
            sVNLog.addCommand("rm", sVNProperties4, false);
            sVNProperties4.clear();
        }
        this.maybeBumpDirInfo(sVNUpdateEditor$SVNDirectoryInfo);
        if (object3 == SVNStatusType.CONFLICTED_UNRESOLVED) {
            sVNStatusType = SVNStatusType.CONFLICTED_UNRESOLVED;
        } else if (object3 == SVNStatusType.CONFLICTED) {
            sVNStatusType = SVNStatusType.CONFLICTED;
        } else if (sVNUpdateEditor$SVNFileInfo.newBaseFile != null) {
            sVNStatusType = bl8 ? SVNStatusType.MERGED : SVNStatusType.CHANGED;
        }
        if ((sVNStatusType != SVNStatusType.UNCHANGED || object4 != SVNStatusType.UNCHANGED || sVNStatusType2 != SVNStatusType.LOCK_UNCHANGED || SVNUpdateEditor$SVNFileInfo.access$900(sVNUpdateEditor$SVNFileInfo)) && !this.inDeletedTree(file, true)) {
            object = object2 = SVNEventAction.UPDATE_UPDATE;
            if (SVNUpdateEditor$SVNFileInfo.access$900(sVNUpdateEditor$SVNFileInfo)) {
                object2 = SVNEventAction.TREE_CONFLICT;
            } else if (sVNUpdateEditor$SVNFileInfo.isExisted || sVNUpdateEditor$SVNFileInfo.isAddExisted) {
                if (sVNStatusType != SVNStatusType.CONFLICTED_UNRESOLVED && sVNStatusType != SVNStatusType.CONFLICTED) {
                    object = object2 = SVNEventAction.UPDATE_EXISTS;
                }
            } else if (sVNUpdateEditor$SVNFileInfo.IsAdded) {
                object = object2 = SVNEventAction.UPDATE_ADD;
            }
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, this.myTargetRevision, sVNStatusType, (SVNStatusType)object4, sVNStatusType2, (SVNEventAction)object2, (SVNEventAction)object, null, null);
            sVNEvent.setPreviousRevision(l2);
            sVNEvent.setPreviousURL(sVNURL);
            sVNEvent.setURL(sVNUpdateEditor$SVNFileInfo.URL != null ? SVNURL.parseURIEncoded(sVNUpdateEditor$SVNFileInfo.URL) : null);
            this.myWCAccess.handleEvent(sVNEvent);
        }
    }

    private SVNUpdateEditor$SVNFileInfo createFileInfo(SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo, String string, boolean bl2) {
        SVNUpdateEditor$SVNFileInfo sVNUpdateEditor$SVNFileInfo = new SVNUpdateEditor$SVNFileInfo(this, sVNUpdateEditor$SVNDirectoryInfo, string);
        sVNUpdateEditor$SVNFileInfo.IsAdded = bl2;
        sVNUpdateEditor$SVNFileInfo.name = SVNPathUtil.tail(string);
        sVNUpdateEditor$SVNFileInfo.isExisted = false;
        sVNUpdateEditor$SVNFileInfo.isAddExisted = false;
        sVNUpdateEditor$SVNFileInfo.isSkipped = false;
        SVNUpdateEditor$SVNFileInfo.access$902(sVNUpdateEditor$SVNFileInfo, false);
        SVNUpdateEditor$SVNFileInfo.access$502(sVNUpdateEditor$SVNFileInfo, false);
        sVNUpdateEditor$SVNFileInfo.baseFile = null;
        sVNUpdateEditor$SVNFileInfo.newBaseFile = null;
        SVNAdminArea sVNAdminArea = sVNUpdateEditor$SVNDirectoryInfo.getAdminArea();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNUpdateEditor$SVNFileInfo.name, true);
        sVNUpdateEditor$SVNFileInfo.URL = this.mySwitchURL != null || sVNEntry == null ? SVNPathUtil.append(sVNUpdateEditor$SVNDirectoryInfo.URL, SVNEncodingUtil.uriEncode(sVNUpdateEditor$SVNFileInfo.name)) : sVNEntry.getURL();
        ++sVNUpdateEditor$SVNDirectoryInfo.RefCount;
        return sVNUpdateEditor$SVNFileInfo;
    }

    private SVNUpdateEditor$SVNDirectoryInfo createDirectoryInfo(SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo, String string, boolean bl2) {
        String string2;
        SVNUpdateEditor$SVNDirectoryInfo sVNUpdateEditor$SVNDirectoryInfo2 = new SVNUpdateEditor$SVNDirectoryInfo(this, string);
        sVNUpdateEditor$SVNDirectoryInfo2.Parent = sVNUpdateEditor$SVNDirectoryInfo;
        sVNUpdateEditor$SVNDirectoryInfo2.IsAdded = bl2;
        String string3 = string2 = string != null ? SVNPathUtil.tail(string) : "";
        if (this.mySwitchURL == null) {
            SVNAdminArea sVNAdminArea = null;
            SVNEntry sVNEntry = null;
            File file = new File(this.myAdminInfo.getAnchor().getRoot(), sVNUpdateEditor$SVNDirectoryInfo2.getPath());
            try {
                sVNAdminArea = this.myWCAccess.getAdminArea(file);
                if (sVNAdminArea != null) {
                    sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            if (sVNAdminArea != null && sVNEntry != null) {
                sVNUpdateEditor$SVNDirectoryInfo2.URL = sVNEntry.getURL();
            }
            if (sVNUpdateEditor$SVNDirectoryInfo2.URL == null && sVNUpdateEditor$SVNDirectoryInfo != null) {
                sVNUpdateEditor$SVNDirectoryInfo2.URL = SVNPathUtil.append(sVNUpdateEditor$SVNDirectoryInfo.URL, SVNEncodingUtil.uriEncode(string2));
            } else if (sVNUpdateEditor$SVNDirectoryInfo2.URL == null && sVNUpdateEditor$SVNDirectoryInfo == null) {
                sVNUpdateEditor$SVNDirectoryInfo2.URL = this.myTargetURL;
            }
        } else {
            sVNUpdateEditor$SVNDirectoryInfo2.URL = sVNUpdateEditor$SVNDirectoryInfo == null ? (this.myTarget == null ? this.mySwitchURL : SVNPathUtil.removeTail(this.mySwitchURL)) : (this.myTarget != null && sVNUpdateEditor$SVNDirectoryInfo.Parent == null ? this.mySwitchURL : SVNPathUtil.append(sVNUpdateEditor$SVNDirectoryInfo.URL, SVNEncodingUtil.uriEncode(string2)));
        }
        sVNUpdateEditor$SVNDirectoryInfo2.RefCount = 1;
        sVNUpdateEditor$SVNDirectoryInfo2.isSkipped = false;
        if (sVNUpdateEditor$SVNDirectoryInfo2.Parent != null) {
            ++sVNUpdateEditor$SVNDirectoryInfo2.Parent.RefCount;
        }
        sVNUpdateEditor$SVNDirectoryInfo2.isExisted = false;
        sVNUpdateEditor$SVNDirectoryInfo2.isAddExisted = false;
        SVNUpdateEditor$SVNDirectoryInfo.access$1002(sVNUpdateEditor$SVNDirectoryInfo2, null);
        sVNUpdateEditor$SVNDirectoryInfo2.myAmbientDepth = SVNDepth.UNKNOWN;
        sVNUpdateEditor$SVNDirectoryInfo2.wasIncomplete = false;
        return sVNUpdateEditor$SVNDirectoryInfo2;
    }

    public static SVNUpdateEditor createUpdateEditor(SVNAdminAreaInfo sVNAdminAreaInfo, String string, boolean bl2, boolean bl3, SVNDepth sVNDepth, String[] stringArray, ISVNFileFetcher iSVNFileFetcher, boolean bl4) {
        Object object;
        if (sVNDepth == SVNDepth.UNKNOWN) {
            bl3 = false;
        }
        SVNEntry sVNEntry = sVNAdminAreaInfo.getAnchor().getEntry(sVNAdminAreaInfo.getAnchor().getThisDirName(), false);
        if (string != null && sVNEntry != null && sVNEntry.getRepositoryRoot() != null && !SVNPathUtil.isAncestor(sVNEntry.getRepositoryRoot(), string)) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}''\nis not the same repository as\n''{1}''", string, sVNEntry.getRepositoryRoot());
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = new SVNUpdateEditor(sVNAdminAreaInfo, string, bl2, bl3, sVNDepth, stringArray, sVNEntry != null ? sVNEntry.getURL() : null, sVNEntry != null ? sVNEntry.getRepositoryRoot() : null, iSVNFileFetcher, bl4);
        sVNAdminAreaInfo.getTarget().closeEntries();
        return object;
    }

    @Override
    public void cleanup(SVNAdminArea sVNAdminArea) {
        sVNAdminArea.runLogs();
    }

    static /* synthetic */ SVNWCAccess access$000(SVNUpdateEditor sVNUpdateEditor) {
        return sVNUpdateEditor.myWCAccess;
    }

    static /* synthetic */ boolean access$100(SVNUpdateEditor sVNUpdateEditor, SVNAdminArea sVNAdminArea, File file, SVNNodeKind sVNNodeKind, String string) {
        return sVNUpdateEditor.entryHasLocalModifications(sVNAdminArea, file, sVNNodeKind, string);
    }

    static /* synthetic */ boolean access$200(SVNUpdateEditor sVNUpdateEditor) {
        return sVNUpdateEditor.myIsLockOnDemand;
    }

    static /* synthetic */ SVNAdminAreaInfo access$1100(SVNUpdateEditor sVNUpdateEditor) {
        return sVNUpdateEditor.myAdminInfo;
    }
}

