/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNTreeConflictUtil {
    public static Map readTreeConflicts(File file, String string) {
        byte[] byArray;
        if (string == null) {
            return new SVNHashMap();
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return SVNTreeConflictUtil.readTreeConflicts(file, byArray);
    }

    public static Map readTreeConflicts(File file, byte[] byArray) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        if (byArray == null) {
            return sVNHashMap;
        }
        SVNSkel sVNSkel = SVNSkel.parse(byArray);
        if (sVNSkel == null || sVNSkel.isAtom()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Error parsing tree conflict skel");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        for (SVNSkel sVNSkel2 : sVNSkel.getList()) {
            SVNTreeConflictDescription sVNTreeConflictDescription = SVNTreeConflictUtil.readSingleTreeConflict(sVNSkel2, file);
            if (sVNTreeConflictDescription == null) continue;
            sVNHashMap.put(sVNTreeConflictDescription.getPath(), sVNTreeConflictDescription);
        }
        return sVNHashMap;
    }

    public static SVNTreeConflictDescription readSingleTreeConflict(SVNSkel sVNSkel, File file) {
        Object object;
        Object object2;
        if (!SVNTreeConflictUtil.isValidConflict(sVNSkel)) {
            object2 = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Invalid conflict info in tree conflict description");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        if (sVNSkel.getChild(1).getData().length == 0) {
            object2 = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Empty 'victim' field in tree conflict description");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        object2 = sVNSkel.getChild(1).getValue();
        SVNNodeKind sVNNodeKind = SVNTreeConflictUtil.getNodeKind(sVNSkel.getChild(2).getValue());
        if (sVNNodeKind != SVNNodeKind.FILE && sVNNodeKind != SVNNodeKind.DIR) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Invalid 'node_kind' field in tree conflict description");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = SVNTreeConflictUtil.getOperation(sVNSkel.getChild(3).getValue());
        SVNConflictAction sVNConflictAction = SVNTreeConflictUtil.getAction(sVNSkel.getChild(4).getValue());
        SVNConflictReason sVNConflictReason = SVNTreeConflictUtil.getConflictReason(sVNSkel.getChild(5).getValue());
        SVNConflictVersion sVNConflictVersion = SVNTreeConflictUtil.readConflictVersion(sVNSkel.getChild(6));
        SVNConflictVersion sVNConflictVersion2 = SVNTreeConflictUtil.readConflictVersion(sVNSkel.getChild(7));
        return new SVNTreeConflictDescription(new File(file, (String)object2), sVNNodeKind, sVNConflictAction, sVNConflictReason, (SVNOperation)object, sVNConflictVersion, sVNConflictVersion2);
    }

    private static SVNConflictVersion readConflictVersion(SVNSkel sVNSkel) {
        SVNURL sVNURL;
        Object object;
        if (!SVNTreeConflictUtil.isValidVersionInfo(sVNSkel)) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Invalid version info in tree conflict description");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        SVNURL sVNURL2 = sVNURL = ((String)(object = sVNSkel.getChild(1).getValue())).length() == 0 ? null : SVNURL.parseURIEncoded((String)object);
        if (sVNURL == null) {
            return null;
        }
        long l2 = Long.parseLong(sVNSkel.getChild(2).getValue());
        String string = sVNSkel.getChild(3).getValue();
        string = string.length() == 0 ? null : string;
        SVNNodeKind sVNNodeKind = SVNTreeConflictUtil.getNodeKind(sVNSkel.getChild(4).getValue());
        return new SVNConflictVersion(sVNURL, string, l2, sVNNodeKind);
    }

    private static boolean isValidVersionInfo(SVNSkel sVNSkel) {
        if (sVNSkel.getListSize() != 5 || !sVNSkel.getChild(0).contentEquals("version")) {
            return false;
        }
        return sVNSkel.containsAtomsOnly();
    }

    private static boolean isValidConflict(SVNSkel sVNSkel) {
        if (sVNSkel == null) {
            return false;
        }
        if (sVNSkel.getListSize() != 8 || !sVNSkel.getChild(0).contentEquals("conflict")) {
            return false;
        }
        for (int i2 = 1; i2 < 6; ++i2) {
            SVNSkel sVNSkel2 = sVNSkel.getChild(i2);
            if (sVNSkel2.isAtom()) continue;
            return false;
        }
        return SVNTreeConflictUtil.isValidVersionInfo(sVNSkel.getChild(6)) && SVNTreeConflictUtil.isValidVersionInfo(sVNSkel.getChild(7));
    }

    public static String getTreeConflictData(Map map) {
        String string;
        if (map == null) {
            return null;
        }
        byte[] byArray = SVNTreeConflictUtil.getTreeConflictRawData(map);
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        return string;
    }

    public static byte[] getTreeConflictRawData(Map map) {
        if (map == null) {
            return null;
        }
        SVNConflictVersion sVNConflictVersion = new SVNConflictVersion(null, null, -1L, SVNNodeKind.UNKNOWN);
        SVNSkel sVNSkel = SVNSkel.createEmptyList();
        for (SVNTreeConflictDescription sVNTreeConflictDescription : map.values()) {
            SVNSkel sVNSkel2 = SVNTreeConflictUtil.getConflictSkel(sVNConflictVersion, sVNTreeConflictDescription);
            if (!SVNTreeConflictUtil.isValidConflict(sVNSkel2)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Failed to create valid conflict description skel: ''{0}''", (Object)sVNSkel.toString());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            sVNSkel.prepend(sVNSkel2);
        }
        return sVNSkel.unparse();
    }

    public static String getSingleTreeConflictData(SVNTreeConflictDescription sVNTreeConflictDescription) {
        String string;
        if (sVNTreeConflictDescription == null) {
            return null;
        }
        byte[] byArray = SVNTreeConflictUtil.getSingleTreeConflictRawData(sVNTreeConflictDescription);
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        return string;
    }

    public static byte[] getSingleTreeConflictRawData(SVNTreeConflictDescription sVNTreeConflictDescription) {
        SVNConflictVersion sVNConflictVersion = new SVNConflictVersion(null, null, -1L, SVNNodeKind.UNKNOWN);
        SVNSkel sVNSkel = SVNTreeConflictUtil.getConflictSkel(sVNConflictVersion, sVNTreeConflictDescription);
        if (!SVNTreeConflictUtil.isValidConflict(sVNSkel)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Failed to create valid conflict description skel: ''{0}''", (Object)sVNSkel.toString());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return sVNSkel.unparse();
    }

    public static SVNSkel getConflictSkel(SVNConflictVersion sVNConflictVersion, SVNTreeConflictDescription sVNTreeConflictDescription) {
        Object object;
        SVNSkel sVNSkel = SVNSkel.createEmptyList();
        SVNConflictVersion sVNConflictVersion2 = sVNTreeConflictDescription.getSourceRightVersion();
        sVNConflictVersion2 = sVNConflictVersion2 == null ? sVNConflictVersion : sVNConflictVersion2;
        SVNTreeConflictUtil.prependVersionInfo(sVNSkel, sVNConflictVersion2);
        SVNConflictVersion sVNConflictVersion3 = sVNTreeConflictDescription.getSourceLeftVersion();
        sVNConflictVersion3 = sVNConflictVersion3 == null ? sVNConflictVersion : sVNConflictVersion3;
        SVNTreeConflictUtil.prependVersionInfo(sVNSkel, sVNConflictVersion3);
        sVNSkel.prepend(SVNSkel.createAtom(sVNTreeConflictDescription.getConflictReason().toString()));
        sVNSkel.prepend(SVNSkel.createAtom(sVNTreeConflictDescription.getConflictAction().toString()));
        sVNSkel.prepend(SVNSkel.createAtom(sVNTreeConflictDescription.getOperation().toString()));
        if (sVNTreeConflictDescription.getNodeKind() != SVNNodeKind.DIR && sVNTreeConflictDescription.getNodeKind() != SVNNodeKind.FILE) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Invalid 'node_kind' field in tree conflict description");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        sVNSkel.prepend(SVNSkel.createAtom(SVNTreeConflictUtil.getNodeKindString(sVNTreeConflictDescription.getNodeKind())));
        object = sVNTreeConflictDescription.getPath().getName();
        if (((String)object).length() == 0) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Empty path basename in tree conflict description");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        sVNSkel.prepend(SVNSkel.createAtom((String)object));
        sVNSkel.prepend(SVNSkel.createAtom("conflict"));
        return sVNSkel;
    }

    public static String getHumanReadableConflictDescription(SVNTreeConflictDescription sVNTreeConflictDescription) {
        SVNNodeKind sVNNodeKind = SVNNodeKind.UNKNOWN;
        if (sVNTreeConflictDescription.getConflictAction() == SVNConflictAction.EDIT || sVNTreeConflictDescription.getConflictAction() == SVNConflictAction.DELETE) {
            if (sVNTreeConflictDescription.getSourceLeftVersion() != null) {
                sVNNodeKind = sVNTreeConflictDescription.getSourceLeftVersion().getKind();
            }
        } else if ((sVNTreeConflictDescription.getConflictAction() == SVNConflictAction.ADD || sVNTreeConflictDescription.getConflictAction() == SVNConflictAction.REPLACE) && sVNTreeConflictDescription.getSourceRightVersion() != null) {
            sVNNodeKind = sVNTreeConflictDescription.getSourceRightVersion().getKind();
        }
        String string = SVNTreeConflictUtil.getReasonString(sVNTreeConflictDescription);
        String string2 = SVNTreeConflictUtil.getActionString(sVNNodeKind, sVNTreeConflictDescription);
        String string3 = sVNTreeConflictDescription.getOperation().getName();
        String string4 = SVNTreeConflictUtil.getNodeKindString(sVNTreeConflictDescription.getNodeKind());
        if (string4.length() > 0) {
            string4 = string4 + " ";
        }
        String string5 = String.format("local %s%s, incoming %s upon %s", string4, string, string2, string3);
        return string5;
    }

    public static String getHumanReadableConflictVersion(SVNConflictVersion sVNConflictVersion) {
        String string;
        if (sVNConflictVersion == null) {
            return "(none)";
        }
        String string2 = string = sVNConflictVersion.getRepositoryRoot() != null ? sVNConflictVersion.getRepositoryRoot().toString() : null;
        string = string != null && sVNConflictVersion.getPath() != null ? string + "/" + sVNConflictVersion.getPath() : (string != null ? string + "/..." : (sVNConflictVersion.getPath() != null ? sVNConflictVersion.getPath() : "..."));
        return "(" + SVNTreeConflictUtil.getNodeKindString(sVNConflictVersion.getKind()) + ") " + string + "@" + sVNConflictVersion.getPegRevision();
    }

    private static String getReasonString(SVNTreeConflictDescription sVNTreeConflictDescription) {
        SVNConflictReason sVNConflictReason = sVNTreeConflictDescription.getConflictReason();
        if (sVNConflictReason == SVNConflictReason.EDITED) {
            return "edit";
        }
        if (sVNConflictReason == SVNConflictReason.OBSTRUCTED) {
            return "obstruction";
        }
        if (sVNConflictReason == SVNConflictReason.DELETED) {
            return "delete";
        }
        if (sVNConflictReason == SVNConflictReason.MISSING) {
            if (sVNTreeConflictDescription.getOperation() == SVNOperation.MERGE) {
                return "missing or deleted or moved away";
            }
            return "missing";
        }
        if (sVNConflictReason == SVNConflictReason.UNVERSIONED) {
            return "unversioned";
        }
        if (sVNConflictReason == SVNConflictReason.ADDED) {
            return "add";
        }
        if (sVNConflictReason == SVNConflictReason.REPLACED) {
            return "replace";
        }
        if (sVNConflictReason == SVNConflictReason.MOVED_AWAY) {
            return "moved away";
        }
        if (sVNConflictReason == SVNConflictReason.MOVED_HERE) {
            return "moved here";
        }
        return null;
    }

    private static String getActionString(SVNNodeKind sVNNodeKind, SVNTreeConflictDescription sVNTreeConflictDescription) {
        if (sVNNodeKind == SVNNodeKind.FILE) {
            SVNConflictAction sVNConflictAction = sVNTreeConflictDescription.getConflictAction();
            if (sVNConflictAction == SVNConflictAction.ADD) {
                return "file add";
            }
            if (sVNConflictAction == SVNConflictAction.EDIT) {
                return "file edit";
            }
            if (sVNConflictAction == SVNConflictAction.DELETE) {
                return "file delete or move";
            }
            if (sVNConflictAction == SVNConflictAction.REPLACE) {
                return "replace with file";
            }
        } else if (sVNNodeKind == SVNNodeKind.DIR) {
            SVNConflictAction sVNConflictAction = sVNTreeConflictDescription.getConflictAction();
            if (sVNConflictAction == SVNConflictAction.ADD) {
                return "dir add";
            }
            if (sVNConflictAction == SVNConflictAction.EDIT) {
                return "dir edit";
            }
            if (sVNConflictAction == SVNConflictAction.DELETE) {
                return "dir delete or move";
            }
            if (sVNConflictAction == SVNConflictAction.REPLACE) {
                return "replace with dir";
            }
        } else if (sVNNodeKind == SVNNodeKind.NONE || sVNNodeKind == SVNNodeKind.UNKNOWN) {
            SVNConflictAction sVNConflictAction = sVNTreeConflictDescription.getConflictAction();
            if (sVNConflictAction == SVNConflictAction.ADD) {
                return "add";
            }
            if (sVNConflictAction == SVNConflictAction.EDIT) {
                return "edit";
            }
            if (sVNConflictAction == SVNConflictAction.DELETE) {
                return "delete or move";
            }
            if (sVNConflictAction == SVNConflictAction.REPLACE) {
                return "replace";
            }
        }
        return null;
    }

    private static SVNSkel prependVersionInfo(SVNSkel sVNSkel, SVNConflictVersion sVNConflictVersion) {
        sVNSkel = sVNSkel == null ? SVNSkel.createEmptyList() : sVNSkel;
        SVNSkel sVNSkel2 = SVNSkel.createEmptyList();
        sVNSkel2.prepend(SVNSkel.createAtom(SVNTreeConflictUtil.getNodeKindString(sVNConflictVersion.getKind())));
        String string = sVNConflictVersion.getPath() == null ? "" : sVNConflictVersion.getPath();
        sVNSkel2.prepend(SVNSkel.createAtom(string));
        sVNSkel2.prepend(SVNSkel.createAtom(String.valueOf(sVNConflictVersion.getPegRevision())));
        String string2 = sVNConflictVersion.getRepositoryRoot() == null ? "" : sVNConflictVersion.getRepositoryRoot().toString();
        sVNSkel2.prepend(SVNSkel.createAtom(string2));
        sVNSkel2.prepend(SVNSkel.createAtom("version"));
        if (!SVNTreeConflictUtil.isValidVersionInfo(sVNSkel2)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Failed to create valid conflict version skel: ''{0}''", (Object)sVNSkel2.toString());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        sVNSkel.prepend(sVNSkel2);
        return sVNSkel;
    }

    private static SVNNodeKind getNodeKind(String string) {
        if ("".equals(string)) {
            return SVNNodeKind.UNKNOWN;
        }
        SVNNodeKind sVNNodeKind = SVNNodeKind.parseKind(string);
        if (sVNNodeKind == SVNNodeKind.UNKNOWN) {
            SVNTreeConflictUtil.mappingError("node kind");
        }
        return sVNNodeKind;
    }

    private static String getNodeKindString(SVNNodeKind sVNNodeKind) {
        if (sVNNodeKind == SVNNodeKind.UNKNOWN) {
            return "";
        }
        return sVNNodeKind.toString();
    }

    private static SVNOperation getOperation(String string) {
        SVNOperation sVNOperation = SVNOperation.fromString(string);
        if (sVNOperation == null) {
            SVNTreeConflictUtil.mappingError("operation");
        }
        return sVNOperation;
    }

    private static SVNConflictAction getAction(String string) {
        SVNConflictAction sVNConflictAction = SVNConflictAction.fromString(string);
        if (sVNConflictAction == null) {
            SVNTreeConflictUtil.mappingError("conflict action");
        }
        return sVNConflictAction;
    }

    private static SVNConflictReason getConflictReason(String string) {
        SVNConflictReason sVNConflictReason = SVNConflictReason.fromString(string);
        if (sVNConflictReason == null) {
            SVNTreeConflictUtil.mappingError("conflict reason");
        }
        return sVNConflictReason;
    }

    private static void mappingError(String string) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Unknown {0} value in tree conflict description", (Object)string);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }
}

