/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.OutputStream;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;

public class SVNSynchronizeEditor
implements ISVNEditor {
    private ISVNEditor myWrappedEditor;
    private boolean myIsRootOpened;
    private long myBaseRevision;
    private SVNCommitInfo myCommitInfo;
    private ISVNLogEntryHandler myHandler;
    private SVNRepository myTargetRepository;
    private int myNormalizedNodePropsCounter;
    private SVNProperties myRevisionProperties;

    public SVNSynchronizeEditor(SVNRepository sVNRepository, ISVNLogEntryHandler iSVNLogEntryHandler, long l2, SVNProperties sVNProperties) {
        this.myTargetRepository = sVNRepository;
        this.myIsRootOpened = false;
        this.myBaseRevision = l2;
        this.myHandler = iSVNLogEntryHandler;
        this.myNormalizedNodePropsCounter = 0;
        this.myRevisionProperties = sVNProperties;
    }

    public void reset(long l2, SVNProperties sVNProperties) {
        this.myWrappedEditor = null;
        this.myCommitInfo = null;
        this.myIsRootOpened = false;
        this.myBaseRevision = l2;
        this.myNormalizedNodePropsCounter = 0;
        this.myRevisionProperties = sVNProperties;
    }

    @Override
    public void abortEdit() {
        this.getWrappedEditor().abortEdit();
    }

    private ISVNEditor getWrappedEditor() {
        if (this.myWrappedEditor == null) {
            this.myWrappedEditor = this.myTargetRepository.getCommitEditor(null, null, false, this.myRevisionProperties, null);
        }
        return this.myWrappedEditor;
    }

    @Override
    public void absentDir(String string) {
        this.getWrappedEditor().absentDir(string);
    }

    @Override
    public void absentFile(String string) {
        this.getWrappedEditor().absentFile(string);
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        this.getWrappedEditor().addDir(string, string2, l2);
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        this.getWrappedEditor().addFile(string, string2, l2);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (SVNProperty.isRegularProperty(string)) {
            String string2;
            if (SVNPropertiesManager.propNeedsTranslation(string) && (string2 = SVNAdminClient.normalizeString(SVNPropertyValue.getPropertyAsString(sVNPropertyValue))) != null) {
                sVNPropertyValue = SVNPropertyValue.create(string2);
                ++this.myNormalizedNodePropsCounter;
            }
            this.getWrappedEditor().changeDirProperty(string, sVNPropertyValue);
        }
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (SVNProperty.isRegularProperty(string2)) {
            String string3;
            if (SVNPropertiesManager.propNeedsTranslation(string2) && (string3 = SVNAdminClient.normalizeString(SVNPropertyValue.getPropertyAsString(sVNPropertyValue))) != null) {
                sVNPropertyValue = SVNPropertyValue.create(string3);
                ++this.myNormalizedNodePropsCounter;
            }
            this.getWrappedEditor().changeFileProperty(string, string2, sVNPropertyValue);
        }
    }

    @Override
    public void closeDir() {
        this.getWrappedEditor().closeDir();
    }

    @Override
    public SVNCommitInfo closeEdit() {
        ISVNEditor iSVNEditor = this.getWrappedEditor();
        if (!this.myIsRootOpened) {
            iSVNEditor.openRoot(this.myBaseRevision);
        }
        this.myCommitInfo = iSVNEditor.closeEdit();
        if (this.myHandler != null) {
            SVNLogEntry sVNLogEntry = new SVNLogEntry(null, this.myCommitInfo.getNewRevision(), this.myCommitInfo.getAuthor(), this.myCommitInfo.getDate(), null);
            this.myHandler.handleLogEntry(sVNLogEntry);
        }
        return this.myCommitInfo;
    }

    @Override
    public void closeFile(String string, String string2) {
        this.getWrappedEditor().closeFile(string, string2);
    }

    @Override
    public void deleteEntry(String string, long l2) {
        this.getWrappedEditor().deleteEntry(string, l2);
    }

    @Override
    public void openDir(String string, long l2) {
        this.getWrappedEditor().openDir(string, l2);
    }

    @Override
    public void openFile(String string, long l2) {
        this.getWrappedEditor().openFile(string, l2);
    }

    @Override
    public void openRoot(long l2) {
        this.getWrappedEditor().openRoot(l2);
        this.myIsRootOpened = true;
    }

    @Override
    public void targetRevision(long l2) {
        this.getWrappedEditor().targetRevision(l2);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        this.getWrappedEditor().applyTextDelta(string, string2);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        return this.getWrappedEditor().textDeltaChunk(string, sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        this.getWrappedEditor().textDeltaEnd(string);
    }

    public SVNCommitInfo getCommitInfo() {
        return this.myCommitInfo;
    }

    public int getNormalizedNodePropsCounter() {
        return this.myNormalizedNodePropsCounter;
    }
}

