/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSubstitutor {
    private static final byte[] ALL = new byte[]{36, 13, 10};
    private static final byte[] EOLS = new byte[]{13, 10};
    private static final byte[] KEYWORDS = new byte[]{36};
    private static final int KEYWORD_MAX_LENGTH = 255;
    private boolean myIsRepair;
    private boolean myIsExpand;
    private Map myKeywords;
    private byte[] myEOL;
    private byte[] myLastEOL;
    private byte[] myInteresting;
    private byte[] myEOLBuffer;
    private byte[] myKeywordBuffer;
    private int[] myLastEOLLength = new int[]{0};
    private int myKeywordBufferLength;
    private int myEOLBufferLength;

    public SVNSubstitutor(byte[] byArray, boolean bl2, Map map, boolean bl3) {
        this.myEOL = byArray;
        this.myKeywords = map;
        this.myIsExpand = bl3;
        this.myIsRepair = bl2;
        this.myInteresting = byArray != null && map != null ? ALL : (byArray != null ? EOLS : KEYWORDS);
        this.myEOLBuffer = new byte[2];
        this.myLastEOL = new byte[2];
        this.myKeywordBuffer = new byte[255];
        this.myEOLBufferLength = 0;
        this.myKeywordBufferLength = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ByteBuffer translateChunk(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer == null) {
            if (this.myEOLBufferLength > 0) {
                byteBuffer2 = SVNSubstitutor.substituteEOL(byteBuffer2, this.myEOL, this.myEOL.length, this.myLastEOL, this.myLastEOLLength, this.myEOLBuffer, this.myEOLBufferLength, this.myIsRepair);
                this.myEOLBufferLength = 0;
            }
            if (this.myKeywordBufferLength <= 0) return byteBuffer2;
            byteBuffer2 = SVNSubstitutor.write(byteBuffer2, this.myKeywordBuffer, 0, this.myKeywordBufferLength);
            this.myKeywordBufferLength = 0;
            return byteBuffer2;
        }
        int n2 = 0;
        block5: while (byteBuffer.hasRemaining()) {
            byte by;
            block23: {
                by = byteBuffer.get(byteBuffer.position());
                if (this.myEOLBufferLength > 0) {
                    if (by == 10) {
                        this.myEOLBuffer[this.myEOLBufferLength++] = byteBuffer.get();
                    }
                    byteBuffer2 = SVNSubstitutor.substituteEOL(byteBuffer2, this.myEOL, this.myEOL.length, this.myLastEOL, this.myLastEOLLength, this.myEOLBuffer, this.myEOLBufferLength, this.myIsRepair);
                    this.myEOLBufferLength = 0;
                } else {
                    if (this.myKeywordBufferLength > 0 && by == 36) {
                        this.myKeywordBuffer[this.myKeywordBufferLength++] = byteBuffer.get();
                        byte[] byArray = this.matchKeyword(this.myKeywordBuffer, 0, this.myKeywordBufferLength);
                        if (byArray == null) {
                            --this.myKeywordBufferLength;
                            SVNSubstitutor.unread(byteBuffer, 1);
                        }
                        int n3 = -1;
                        if (byArray == null || (n3 = this.translateKeyword(this.myKeywordBuffer, 0, this.myKeywordBufferLength, byArray)) >= 0 || this.myKeywordBufferLength >= 255) {
                            if (n3 >= 0) {
                                this.myKeywordBufferLength = n3;
                            }
                            byteBuffer2 = SVNSubstitutor.write(byteBuffer2, this.myKeywordBuffer, 0, this.myKeywordBufferLength);
                            n2 = 0;
                            this.myKeywordBufferLength = 0;
                            break block23;
                        } else {
                            if (n2 != 0) continue;
                            n2 = this.myKeywordBufferLength - 1;
                            continue;
                        }
                    }
                    if (this.myKeywordBufferLength == 254 || this.myKeywordBufferLength > 0 && (by == 13 || by == 10)) {
                        if (n2 > 0) {
                            SVNSubstitutor.unread(byteBuffer, this.myKeywordBufferLength - n2);
                            this.myKeywordBufferLength = n2;
                            n2 = 0;
                        }
                        byteBuffer2 = SVNSubstitutor.write(byteBuffer2, this.myKeywordBuffer, 0, this.myKeywordBufferLength);
                        this.myKeywordBufferLength = 0;
                    } else if (this.myKeywordBufferLength > 0) {
                        this.myKeywordBuffer[this.myKeywordBufferLength++] = byteBuffer.get();
                        continue;
                    }
                }
            }
            int n4 = 0;
            while (byteBuffer.position() + n4 < byteBuffer.limit() && !this.isInteresting(byteBuffer.get(byteBuffer.position() + n4))) {
                ++n4;
            }
            if (n4 > 0) {
                byteBuffer2 = SVNSubstitutor.write(byteBuffer2, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n4);
            }
            byteBuffer.position(byteBuffer.position() + n4);
            if (!byteBuffer.hasRemaining()) continue;
            by = byteBuffer.get();
            switch (by) {
                case 36: {
                    this.myKeywordBuffer[this.myKeywordBufferLength++] = by;
                    break;
                }
                case 13: {
                    this.myEOLBuffer[this.myEOLBufferLength++] = by;
                    break;
                }
                case 10: {
                    this.myEOLBuffer[this.myEOLBufferLength++] = by;
                    byteBuffer2 = SVNSubstitutor.substituteEOL(byteBuffer2, this.myEOL, this.myEOL.length, this.myLastEOL, this.myLastEOLLength, this.myEOLBuffer, this.myEOLBufferLength, this.myIsRepair);
                    this.myEOLBufferLength = 0;
                    continue block5;
                }
            }
        }
        return byteBuffer2;
    }

    private boolean isInteresting(byte by) {
        for (int i2 = 0; i2 < this.myInteresting.length; ++i2) {
            if (by != this.myInteresting[i2]) continue;
            return true;
        }
        return false;
    }

    private byte[] matchKeyword(byte[] byArray, int n2, int n3) {
        if (this.myKeywords == null) {
            return null;
        }
        String string = null;
        int n4 = 0;
        try {
            for (int i2 = 0; i2 < n3 - 2 && byArray[n2 + i2 + 1] != 58; ++i2) {
                ++n4;
            }
            if (n4 == 0) {
                return null;
            }
            string = new String(byArray, n2 + 1, n4, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (string != null && this.myKeywords.containsKey(string)) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n2 + 1, byArray2, 0, n4);
            return byArray2;
        }
        return null;
    }

    private int translateKeyword(byte[] byArray, int n2, int n3, byte[] byArray2) {
        String string;
        if (this.myKeywords == null) {
            return -1;
        }
        try {
            string = new String(byArray2, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return -1;
        }
        byte[] byArray3 = (byte[])this.myKeywords.get(string);
        if (this.myKeywords.containsKey(string)) {
            if (!this.myIsExpand) {
                byArray3 = null;
            }
            return SVNSubstitutor.substituteKeyword(byArray, n2, n3, byArray2, byArray3);
        }
        return -1;
    }

    private static void unread(ByteBuffer byteBuffer, int n2) {
        byteBuffer.position(byteBuffer.position() - n2);
    }

    private static int substituteKeyword(byte[] byArray, int n2, int n3, byte[] byArray2, byte[] byArray3) {
        int n4;
        if (n3 < byArray2.length + 2) {
            return -1;
        }
        for (n4 = 0; n4 < byArray2.length; ++n4) {
            if (byArray2[n4] == byArray[n2 + 1 + n4]) continue;
            return -1;
        }
        int n5 = n2 + 1 + byArray2.length;
        if (byArray[n5] == 58 && byArray[n5 + 1] == 58 && byArray[n5 + 2] == 32 && (byArray[n2 + n3 - 2] == 32 || byArray[n2 + n3 - 2] == 35) && 6 + byArray2.length < n3) {
            if (byArray3 == null) {
                n5 += 2;
                while (byArray[n5] != 36) {
                    byArray[n5++] = 32;
                }
            } else {
                n4 = n3 - (6 + byArray2.length);
                if (byArray3.length <= n4) {
                    System.arraycopy(byArray3, 0, byArray, n5 + 3, byArray3.length);
                    n5 += 3 + byArray3.length;
                    while (byArray[n5] != 36) {
                        byArray[n5++] = 32;
                    }
                } else {
                    System.arraycopy(byArray3, 0, byArray, n5 + 3, n4);
                    byArray[n2 + n3 - 2] = 35;
                    byArray[n2 + n3 - 1] = 36;
                }
            }
            return n3;
        }
        if (byArray[n5] == 36 || byArray[n5] == 58 && byArray[n5 + 1] == 36) {
            if (byArray3 != null) {
                byArray[n5] = 58;
                byArray[n5 + 1] = 32;
                if (byArray3.length > 0) {
                    n4 = byArray3.length;
                    if (n4 > 250 - byArray2.length) {
                        n4 = 250 - byArray2.length;
                    }
                    System.arraycopy(byArray3, 0, byArray, n5 + 2, n4);
                    byArray[n5 + 2 + n4] = 32;
                    byArray[n5 + 3 + n4] = 36;
                    n3 = 5 + byArray2.length + n4;
                } else {
                    byArray[n5 + 2] = 36;
                    n3 = 4 + byArray2.length;
                }
            }
            return n3;
        }
        if (n3 >= byArray2.length + 4 && byArray[n5] == 58 && byArray[n5 + 1] == 32 && byArray[n2 + n3 - 2] == 32) {
            if (byArray3 == null) {
                byArray[n5] = 36;
                n3 = 2 + byArray2.length;
            } else {
                byArray[n5] = 58;
                byArray[n5 + 1] = 32;
                if (byArray3.length > 0) {
                    n4 = byArray3.length;
                    if (n4 > 250 - byArray2.length) {
                        n4 = 250 - byArray2.length;
                    }
                    System.arraycopy(byArray3, 0, byArray, n5 + 2, n4);
                    byArray[n5 + 2 + n4] = 32;
                    byArray[n5 + 3 + n4] = 36;
                    n3 = 5 + byArray2.length + n4;
                } else {
                    byArray[n5 + 2] = 36;
                    n3 = 4 + byArray2.length;
                }
            }
            return n3;
        }
        return -1;
    }

    private static ByteBuffer substituteEOL(ByteBuffer byteBuffer, byte[] byArray, int n2, byte[] byArray2, int[] nArray, byte[] byArray3, int n3, boolean bl2) {
        if (nArray[0] > 0) {
            if (!(bl2 || nArray[0] == n3 && Arrays.equals(byArray2, byArray3))) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_INCONSISTENT_EOL);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            }
        } else {
            nArray[0] = n3;
            byArray2[0] = byArray3[0];
            byArray2[1] = byArray3[1];
        }
        return SVNSubstitutor.write(byteBuffer, byArray, 0, n2);
    }

    private static ByteBuffer write(ByteBuffer byteBuffer, byte[] byArray, int n2, int n3) {
        if (byteBuffer.remaining() < n3) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate((byteBuffer.position() + n3) * 3 / 2);
            byteBuffer.flip();
            byteBuffer = byteBuffer2.put(byteBuffer);
        }
        return byteBuffer.put(byArray, n2, n3);
    }
}

