/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNStatusReporter
implements ISVNReporter,
ISVNReporterBaton {
    private ISVNReporter myReporter;
    private ISVNReporterBaton myBaton;
    private SVNURL myCommonAncestorLocation;
    private SVNRepository myRepository;
    private SVNURL myRepositoryRoot;
    private Map myLocks;
    private SVNStatusEditor myEditor;

    public SVNStatusReporter(SVNRepository sVNRepository, ISVNReporterBaton iSVNReporterBaton, SVNStatusEditor sVNStatusEditor) {
        this.myBaton = iSVNReporterBaton;
        this.myRepository = sVNRepository;
        this.myCommonAncestorLocation = sVNRepository.getLocation();
        this.myEditor = sVNStatusEditor;
        this.myLocks = new SVNHashMap();
    }

    public SVNLock getLock(SVNURL sVNURL) {
        String string;
        if (this.myRepositoryRoot == null || this.myLocks.isEmpty() || sVNURL == null) {
            return null;
        }
        String string2 = sVNURL.getPath();
        String string3 = string2.equals(string = this.myRepositoryRoot.getPath()) ? "/" : string2.substring(string.length());
        return (SVNLock)this.myLocks.get(string3);
    }

    @Override
    public void report(ISVNReporter iSVNReporter) {
        this.myReporter = iSVNReporter;
        this.myBaton.report(this);
    }

    @Override
    public void setPath(String string, String string2, long l2, boolean bl2) {
        this.setPath(string, string2, l2, SVNDepth.INFINITY, bl2);
    }

    @Override
    public void deletePath(String string) {
        this.myReporter.deletePath(string);
    }

    @Override
    public void linkPath(SVNURL sVNURL, String string, String string2, long l2, boolean bl2) {
        this.linkPath(sVNURL, string, string2, l2, SVNDepth.INFINITY, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishReport() {
        SVNLock[] sVNLockArray = null;
        SVNURL sVNURL = this.myRepository.getLocation();
        try {
            this.myRepositoryRoot = this.myRepository.getRepositoryRoot(true);
            this.myRepository.setLocation(this.myCommonAncestorLocation, false);
            sVNLockArray = this.myRepository.getLocks("");
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage() == null || sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                throw sVNException;
            }
        }
        finally {
            this.myRepository.setLocation(sVNURL, false);
            this.myRepository.closeSession();
        }
        if (sVNLockArray != null) {
            for (int i2 = 0; i2 < sVNLockArray.length; ++i2) {
                SVNLock sVNLock = sVNLockArray[i2];
                this.myLocks.put(sVNLock.getPath(), sVNLock);
            }
        }
        this.myEditor.setRepositoryInfo(this.myRepositoryRoot, this.myLocks);
        this.myReporter.finishReport();
    }

    @Override
    public void abortReport() {
        this.myReporter.abortReport();
    }

    @Override
    public void linkPath(SVNURL sVNURL, String string, String string2, long l2, SVNDepth sVNDepth, boolean bl2) {
        SVNURL sVNURL2 = SVNURLUtil.getCommonURLAncestor(sVNURL, this.myCommonAncestorLocation);
        if (sVNURL2 == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Can not determine common ancestor of ''{0}'' and ''{1}'';\nprobably these entries belong to different repositories.", sVNURL, this.myCommonAncestorLocation);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (SVNPathUtil.getPathAsChild(sVNURL2.getPath(), this.myCommonAncestorLocation.getPath()) != null) {
            this.myCommonAncestorLocation = sVNURL2;
        }
        this.myReporter.linkPath(sVNURL, string, string2, l2, sVNDepth, bl2);
    }

    @Override
    public void setPath(String string, String string2, long l2, SVNDepth sVNDepth, boolean bl2) {
        this.myReporter.setPath(string, string2, l2, sVNDepth, bl2);
    }
}

