/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor$DefaultSVNStatusFileProvider;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor$WrapperSVNStatusFileProvider;
import org.tmatesoft.svn.core.internal.wc.SVNStatusUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNStatusEditor {
    private SVNWCAccess myWCAccess;
    private SVNAdminAreaInfo myAdminInfo;
    private boolean myIsReportAll;
    private boolean myIsNoIgnore;
    private SVNDepth myDepth;
    private ISVNStatusHandler myStatusHandler;
    private Map myExternalsMap;
    private Collection myGlobalIgnores;
    protected SVNURL myRepositoryRoot;
    private Map myRepositoryLocks;
    private long myTargetRevision;
    private String myWCRootPath;
    private ISVNStatusFileProvider myFileProvider;
    private ISVNStatusFileProvider myDefaultFileProvider;

    public SVNStatusEditor(ISVNOptions iSVNOptions, SVNWCAccess sVNWCAccess, SVNAdminAreaInfo sVNAdminAreaInfo, boolean bl2, boolean bl3, SVNDepth sVNDepth, ISVNStatusHandler iSVNStatusHandler) {
        this.myWCAccess = sVNWCAccess;
        this.myAdminInfo = sVNAdminAreaInfo;
        this.myIsNoIgnore = bl2;
        this.myIsReportAll = bl3;
        this.myDepth = sVNDepth;
        this.myStatusHandler = iSVNStatusHandler;
        this.myExternalsMap = new SVNHashMap();
        this.myGlobalIgnores = SVNStatusEditor.getGlobalIgnores(iSVNOptions);
        this.myTargetRevision = -1L;
        this.myFileProvider = this.myDefaultFileProvider = new SVNStatusEditor$DefaultSVNStatusFileProvider();
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public void targetRevision(long l2) {
        this.myTargetRevision = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo closeEdit() {
        try {
            if (this.hasTarget()) {
                File file = this.myAdminInfo.getAnchor().getFile(this.myAdminInfo.getTargetName());
                SVNFileType sVNFileType = SVNFileType.getType(file);
                if (sVNFileType == SVNFileType.DIRECTORY) {
                    SVNEntry sVNEntry = this.myWCAccess.getEntry(file, false);
                    if (sVNEntry == null) {
                        this.getDirStatus(null, this.myAdminInfo.getAnchor(), this.myAdminInfo.getTargetName(), SVNDepth.EMPTY, this.myIsReportAll, true, null, true, this.myStatusHandler);
                    } else {
                        SVNAdminArea sVNAdminArea = this.myWCAccess.retrieve(file);
                        this.getDirStatus(null, sVNAdminArea, null, this.myDepth, this.myIsReportAll, this.myIsNoIgnore, null, false, this.myStatusHandler);
                    }
                } else {
                    this.getDirStatus(null, this.myAdminInfo.getAnchor(), this.myAdminInfo.getTargetName(), SVNDepth.EMPTY, this.myIsReportAll, true, null, true, this.myStatusHandler);
                }
            } else {
                this.getDirStatus(null, this.myAdminInfo.getAnchor(), null, this.myDepth, this.myIsReportAll, this.myIsNoIgnore, null, false, this.myStatusHandler);
            }
        }
        finally {
            this.cleanup();
        }
        return null;
    }

    public void setRepositoryInfo(SVNURL sVNURL, Map map) {
        this.myRepositoryRoot = sVNURL;
        this.myRepositoryLocks = map;
    }

    protected void getDirStatus(SVNEntry sVNEntry, SVNAdminArea sVNAdminArea, String string, SVNDepth sVNDepth, boolean bl2, boolean bl3, Collection collection, boolean bl4, ISVNStatusHandler iSVNStatusHandler) {
        Object object;
        Object object22;
        Object object3;
        this.myWCAccess.checkCancelled();
        sVNDepth = sVNDepth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : sVNDepth;
        TreeMap treeMap = this.myFileProvider.getChildrenFiles(sVNAdminArea.getRoot());
        SVNEntry sVNEntry2 = this.myWCAccess.getEntry(sVNAdminArea.getRoot(), false);
        String string2 = sVNAdminArea.getProperties(sVNAdminArea.getThisDirName()).getStringPropertyValue("svn:externals");
        if (string2 != null) {
            object3 = sVNAdminArea.getRelativePath(this.myAdminInfo.getAnchor());
            this.myAdminInfo.addExternal((String)object3, string2, string2);
            this.myAdminInfo.addDepth((String)object3, sVNEntry2.getDepth());
            object22 = SVNExternal.parseExternals(sVNAdminArea.getRelativePath(this.myAdminInfo.getAnchor()), string2);
            for (int i2 = 0; i2 < ((SVNExternal[])object22).length; ++i2) {
                object = object22[i2];
                this.myExternalsMap.put(SVNPathUtil.append((String)object3, ((SVNExternal)object).getPath()), object);
            }
        }
        if (string != null) {
            object3 = (File)treeMap.get(string);
            object22 = sVNAdminArea.getEntry(string, false);
            if (object22 != null) {
                SVNFileType sVNFileType = SVNFileType.getType((File)object3);
                boolean bl5 = sVNFileType == SVNFileType.SYMLINK;
                SVNNodeKind sVNNodeKind = SVNFileType.getNodeKind(sVNFileType);
                this.handleDirEntry(sVNAdminArea, string, sVNEntry2, (SVNEntry)object22, sVNNodeKind, bl5, sVNDepth, bl2, bl3, iSVNStatusHandler);
            } else if (object3 != null) {
                SVNFileType sVNFileType;
                if (collection == null) {
                    collection = SVNStatusEditor.getIgnorePatterns(sVNAdminArea, this.myGlobalIgnores);
                }
                boolean bl6 = (sVNFileType = SVNFileType.getType((File)object3)) == SVNFileType.SYMLINK;
                SVNNodeKind sVNNodeKind = SVNFileType.getNodeKind(sVNFileType);
                this.sendUnversionedStatus((File)object3, string, sVNNodeKind, bl6, sVNAdminArea, collection, bl3, iSVNStatusHandler);
            } else {
                SVNTreeConflictDescription sVNTreeConflictDescription = this.myWCAccess.getTreeConflict(sVNAdminArea.getFile(string));
                if (sVNTreeConflictDescription != null) {
                    if (collection == null) {
                        collection = SVNStatusEditor.getIgnorePatterns(sVNAdminArea, this.myGlobalIgnores);
                    }
                    this.sendUnversionedStatus(sVNAdminArea.getFile(string), string, SVNNodeKind.NONE, false, sVNAdminArea, collection, true, iSVNStatusHandler);
                }
            }
            return;
        }
        if (!bl4 && (object3 = this.assembleStatus(sVNAdminArea.getRoot(), sVNAdminArea, sVNEntry2, sVNEntry, SVNNodeKind.DIR, false, this.isReportAll(), false)) != null && iSVNStatusHandler != null) {
            iSVNStatusHandler.handleStatus((SVNStatus)object3);
        }
        if (sVNDepth == SVNDepth.EMPTY) {
            return;
        }
        treeMap = new TreeMap(treeMap);
        for (Object object22 : treeMap.keySet()) {
            SVNEntry sVNEntry3 = sVNAdminArea.getEntry((String)object22, true);
            if (SVNStatusEditor.isNameConflict(sVNEntry3) || sVNEntry3 != null && !sVNEntry3.isHidden() || SVNFileUtil.getAdminDirectoryName().equals(object22)) continue;
            object = (File)treeMap.get(object22);
            if (sVNDepth == SVNDepth.FILES && ((File)object).isDirectory()) continue;
            if (collection == null) {
                collection = SVNStatusEditor.getIgnorePatterns(sVNAdminArea, this.myGlobalIgnores);
            }
            this.sendUnversionedStatus((File)object, (String)object22, SVNNodeKind.NONE, false, sVNAdminArea, collection, bl3, iSVNStatusHandler);
        }
        object3 = SVNTreeConflictUtil.readTreeConflicts(sVNAdminArea.getRoot(), sVNEntry2.getTreeConflictData());
        for (File file : object3.keySet()) {
            if (treeMap.containsKey(file.getName()) || sVNAdminArea.getEntry(file.getName(), false) != null) continue;
            if (collection == null) {
                collection = SVNStatusEditor.getIgnorePatterns(sVNAdminArea, this.myGlobalIgnores);
            }
            this.sendUnversionedStatus(file, file.getName(), SVNNodeKind.NONE, false, sVNAdminArea, collection, bl3, iSVNStatusHandler);
        }
        object22 = sVNAdminArea.entries(true);
        while (object22.hasNext()) {
            SVNEntry sVNEntry4 = (SVNEntry)object22.next();
            if (SVNStatusEditor.isNameConflict(sVNEntry4)) {
                object = new SVNStatus(sVNEntry4.getSVNURL(), sVNAdminArea.getFile(sVNEntry4.getName()), sVNEntry4.getKind(), SVNRevision.create(sVNEntry4.getRevision()), SVNRevision.create(sVNEntry4.getCommittedRevision()), SVNDate.parseDate(sVNEntry4.getCommittedDate()), sVNEntry4.getAuthor(), SVNStatusType.STATUS_NAME_CONFLICT, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, false, sVNEntry4.isCopied(), false, false, null, null, null, null, sVNEntry4.getCopyFromURL(), SVNRevision.create(sVNEntry4.getCopyFromRevision()), null, null, sVNEntry4.asMap(), sVNEntry4.getChangelistName(), sVNAdminArea.getFormatVersion(), null);
                ((SVNStatus)object).setDepth(sVNEntry4.isDirectory() ? sVNEntry4.getDepth() : SVNDepth.UNKNOWN);
                ((SVNStatus)object).setEntry(sVNEntry4);
                ((SVNStatus)object).setRepositoryRootURL(this.myRepositoryRoot);
                iSVNStatusHandler.handleStatus((SVNStatus)object);
                continue;
            }
            if (sVNEntry4.isHidden() || sVNAdminArea.getThisDirName().equals(sVNEntry4.getName()) || sVNDepth == SVNDepth.FILES && sVNEntry4.isDirectory()) continue;
            object = (File)treeMap.get(sVNEntry4.getName());
            SVNFileType sVNFileType = SVNFileType.getType((File)object);
            boolean bl7 = sVNFileType == SVNFileType.SYMLINK;
            SVNNodeKind sVNNodeKind = SVNFileType.getNodeKind(sVNFileType);
            this.handleDirEntry(sVNAdminArea, sVNEntry4.getName(), sVNEntry2, sVNEntry4, sVNNodeKind, bl7, sVNDepth == SVNDepth.INFINITY ? sVNDepth : SVNDepth.EMPTY, bl2, bl3, iSVNStatusHandler);
        }
    }

    public static boolean isNameConflict(SVNEntry sVNEntry) {
        return sVNEntry != null && sVNEntry.isAbsent() && "nameconflict".equals(sVNEntry.getChecksum());
    }

    protected void cleanup() {
        if (this.hasTarget()) {
            this.myAdminInfo.removeExternal("");
            this.myAdminInfo.removeDepth("");
        }
    }

    protected SVNAdminArea getAnchor() {
        return this.myAdminInfo.getAnchor();
    }

    protected SVNWCAccess getWCAccess() {
        return this.myWCAccess;
    }

    protected SVNDepth getDepth() {
        return this.myDepth;
    }

    protected boolean isReportAll() {
        return this.myIsReportAll;
    }

    protected boolean isNoIgnore() {
        return this.myIsNoIgnore;
    }

    protected SVNAdminAreaInfo getAdminAreaInfo() {
        return this.myAdminInfo;
    }

    protected ISVNStatusHandler getDefaultHandler() {
        return this.myStatusHandler;
    }

    protected boolean hasTarget() {
        return this.myAdminInfo.getTargetName() != null && !"".equals(this.myAdminInfo.getTargetName());
    }

    protected SVNLock getLock(SVNURL sVNURL) {
        return SVNStatusUtil.getLock(this.myRepositoryLocks, sVNURL, this.myRepositoryRoot);
    }

    private void handleDirEntry(SVNAdminArea sVNAdminArea, String string, SVNEntry sVNEntry, SVNEntry sVNEntry2, SVNNodeKind sVNNodeKind, boolean bl2, SVNDepth sVNDepth, boolean bl3, boolean bl4, ISVNStatusHandler iSVNStatusHandler) {
        File file = sVNAdminArea.getFile(string);
        if (sVNNodeKind == SVNNodeKind.DIR) {
            SVNEntry sVNEntry3 = sVNEntry2;
            if (sVNEntry2.getKind() == sVNNodeKind) {
                sVNEntry3 = this.myWCAccess.getVersionedEntry(file, false);
            }
            if (sVNEntry3 != sVNEntry2 && (sVNDepth == SVNDepth.UNKNOWN || sVNDepth == SVNDepth.IMMEDIATES || sVNDepth == SVNDepth.INFINITY)) {
                SVNAdminArea sVNAdminArea2 = this.myWCAccess.retrieve(file);
                this.getDirStatus(sVNEntry, sVNAdminArea2, null, sVNDepth, bl3, bl4, null, false, iSVNStatusHandler);
            } else if (sVNEntry3 != sVNEntry2) {
                SVNAdminArea sVNAdminArea3 = this.myWCAccess.retrieve(file);
                SVNStatus sVNStatus = this.assembleStatus(file, sVNAdminArea3, sVNEntry3, sVNEntry, sVNNodeKind, bl2, bl3, false);
                if (sVNStatus != null && iSVNStatusHandler != null) {
                    iSVNStatusHandler.handleStatus(sVNStatus);
                }
            } else {
                SVNStatus sVNStatus = this.assembleStatus(file, sVNAdminArea, sVNEntry3, sVNEntry, sVNNodeKind, bl2, bl3, false);
                if (sVNStatus != null && iSVNStatusHandler != null) {
                    iSVNStatusHandler.handleStatus(sVNStatus);
                }
            }
        } else {
            SVNStatus sVNStatus = this.assembleStatus(file, sVNAdminArea, sVNEntry2, sVNEntry, sVNNodeKind, bl2, bl3, false);
            if (sVNStatus != null && iSVNStatusHandler != null) {
                iSVNStatusHandler.handleStatus(sVNStatus);
            }
        }
    }

    private void sendUnversionedStatus(File file, String string, SVNNodeKind sVNNodeKind, boolean bl2, SVNAdminArea sVNAdminArea, Collection collection, boolean bl3, ISVNStatusHandler iSVNStatusHandler) {
        String string2 = sVNAdminArea.getRelativePath(this.myAdminInfo.getAnchor());
        string2 = SVNPathUtil.append(string2, string);
        boolean bl4 = SVNStatusEditor.isIgnored(collection, file, this.getWCRootRelativePath(collection, file));
        boolean bl5 = this.isExternal(string2);
        SVNStatus sVNStatus = this.assembleStatus(file, sVNAdminArea, null, null, sVNNodeKind, bl2, true, bl4);
        if (sVNStatus != null) {
            if (bl5) {
                sVNStatus.setContentsStatus(SVNStatusType.STATUS_EXTERNAL);
            }
            if (iSVNStatusHandler != null && (bl3 || !bl4 || bl5 || sVNStatus.getRemoteLock() != null)) {
                iSVNStatusHandler.handleStatus(sVNStatus);
            }
        }
    }

    protected SVNStatus assembleStatus(File file, SVNAdminArea sVNAdminArea, SVNEntry sVNEntry, SVNEntry sVNEntry2, SVNNodeKind sVNNodeKind, boolean bl2, boolean bl3, boolean bl4) {
        return SVNStatusUtil.assembleStatus(file, sVNAdminArea, sVNEntry, sVNEntry2, sVNNodeKind, bl2, bl3, bl4, this.myRepositoryLocks, this.myRepositoryRoot, this.myWCAccess);
    }

    protected String getWCRootPath() {
        if (this.myWCRootPath == null) {
            try {
                File file = SVNWCUtil.getWorkingCopyRoot(this.myAdminInfo.getAnchor().getRoot(), true);
                if (file != null) {
                    this.myWCRootPath = file.getAbsolutePath().replace(File.separatorChar, '/');
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return this.myWCRootPath;
    }

    protected String getWCRootRelativePath(Collection collection, File file) {
        boolean bl2 = false;
        for (String string : collection) {
            if (!string.startsWith("/")) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return null;
        }
        Object object = null;
        if (this.getWCRootPath() != null) {
            object = file.getAbsolutePath().replace(File.separatorChar, '/');
            object = SVNPathUtil.getPathAsChild(this.getWCRootPath(), (String)object);
            if (object != null && !((String)object).startsWith("/")) {
                object = "/" + (String)object;
            }
        }
        return object;
    }

    private boolean isExternal(String string) {
        if (!this.myExternalsMap.containsKey(string)) {
            for (String string2 : this.myExternalsMap.keySet()) {
                if (!string2.startsWith(string + "/")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static Collection getIgnorePatterns(SVNAdminArea sVNAdminArea, Collection collection) {
        String string = sVNAdminArea.getProperties("").getStringPropertyValue("svn:ignore");
        if (string != null) {
            SVNHashSet sVNHashSet = new SVNHashSet();
            sVNHashSet.addAll(collection);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() <= 0) continue;
                sVNHashSet.add(string2);
            }
            return sVNHashSet;
        }
        return collection;
    }

    public static Collection getGlobalIgnores(ISVNOptions iSVNOptions) {
        String[] stringArray;
        if (iSVNOptions != null && (stringArray = iSVNOptions.getIgnorePatterns()) != null) {
            SVNHashSet sVNHashSet = new SVNHashSet();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                sVNHashSet.add(stringArray[i2]);
            }
            return sVNHashSet;
        }
        return Collections.EMPTY_SET;
    }

    public static boolean isIgnored(Collection collection, File file) {
        return SVNStatusEditor.isIgnored(collection, file, null);
    }

    public static boolean isIgnored(Collection collection, File file, String string) {
        boolean bl2;
        String string2 = file.getName();
        String string3 = null;
        boolean bl3 = bl2 = SVNFileType.getType(file) == SVNFileType.DIRECTORY;
        if (bl2) {
            string3 = string2 + "/";
        }
        for (String string4 : collection) {
            if (string4.startsWith("/") && string != null) {
                if (!DefaultSVNOptions.matches(string4, string) && (!bl2 || !DefaultSVNOptions.matches(string4, string + "/"))) continue;
                return true;
            }
            if (DefaultSVNOptions.matches(string4, string2)) {
                return true;
            }
            if (!bl2 || !DefaultSVNOptions.matches(string4, string3)) continue;
            return true;
        }
        return false;
    }

    public void setFileProvider(ISVNStatusFileProvider iSVNStatusFileProvider) {
        this.myFileProvider = new SVNStatusEditor$WrapperSVNStatusFileProvider(this.myDefaultFileProvider, iSVNStatusFileProvider);
    }
}

