/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteStatusEditor$DirectoryInfo;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteStatusEditor$FileInfo;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNRemoteStatusEditor
extends SVNStatusEditor
implements ISVNEditor,
ISVNStatusHandler {
    private boolean myIsRootOpen;
    private SVNStatus myAnchorStatus;
    private SVNRemoteStatusEditor$DirectoryInfo myDirectoryInfo;
    private SVNRemoteStatusEditor$FileInfo myFileInfo;

    public SVNRemoteStatusEditor(ISVNOptions iSVNOptions, SVNWCAccess sVNWCAccess, SVNAdminAreaInfo sVNAdminAreaInfo, boolean bl2, boolean bl3, SVNDepth sVNDepth, ISVNStatusHandler iSVNStatusHandler) {
        super(iSVNOptions, sVNWCAccess, sVNAdminAreaInfo, bl2, bl3, sVNDepth, iSVNStatusHandler);
        this.myAnchorStatus = this.createStatus(sVNAdminAreaInfo.getAnchor().getRoot());
    }

    @Override
    public void setRepositoryInfo(SVNURL sVNURL, Map map) {
        super.setRepositoryInfo(sVNURL, map);
        if (this.myAnchorStatus.getRepositoryRootURL() == null) {
            this.myAnchorStatus.setRepositoryRootURL(this.myRepositoryRoot);
        }
        if (this.myAnchorStatus.getURL() != null && this.myAnchorStatus.getRepositoryRootURL() != null) {
            this.myAnchorStatus.setRepositoryRelativePath(SVNURLUtil.getRelativeURL(this.myAnchorStatus.getRepositoryRootURL(), this.myAnchorStatus.getURL(), false));
        }
    }

    @Override
    public void openRoot(long l2) {
        this.myIsRootOpen = true;
        this.myDirectoryInfo = new SVNRemoteStatusEditor$DirectoryInfo(this, null, null);
    }

    @Override
    public void deleteEntry(String string, long l2) {
        String string2;
        File file;
        File file2 = this.getAnchor().getFile(string);
        SVNEntry sVNEntry = this.getWCAccess().getVersionedEntry(file2, false);
        if (sVNEntry.getKind() == SVNNodeKind.DIR) {
            file = file2;
            string2 = "";
        } else {
            file = file2.getParentFile();
            string2 = file2.getName();
        }
        SVNAdminArea sVNAdminArea = null;
        try {
            sVNAdminArea = this.getWCAccess().retrieve(file);
        }
        catch (SVNException sVNException) {
            SVNFileType sVNFileType = SVNFileType.getType(file2);
            if (sVNFileType == SVNFileType.NONE && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                return;
            }
            throw sVNException;
        }
        if (sVNAdminArea.getEntry(string2, false) != null) {
            this.tweakStatusHash(this.myDirectoryInfo, this.myDirectoryInfo, file2, SVNStatusType.STATUS_DELETED, SVNStatusType.STATUS_NONE, null, SVNRevision.create(l2));
            SVNStatus sVNStatus = (SVNStatus)this.myDirectoryInfo.myChildrenStatuses.get(file2);
            if (sVNStatus != null) {
                sVNStatus.setRemoteStatus(null, null, null, sVNAdminArea.getEntry(string2, false).getKind());
            }
        }
        if (this.myDirectoryInfo.myParent != null && !this.hasTarget()) {
            this.tweakStatusHash(this.myDirectoryInfo.myParent, this.myDirectoryInfo, this.myDirectoryInfo.myPath, SVNStatusType.STATUS_MODIFIED, SVNStatusType.STATUS_NONE, null, null);
        } else if (!this.hasTarget() && this.myDirectoryInfo.myParent == null) {
            this.myDirectoryInfo.myIsContentsChanged = true;
        }
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        this.myDirectoryInfo = new SVNRemoteStatusEditor$DirectoryInfo(this, string, this.myDirectoryInfo);
        this.myDirectoryInfo.myIsAdded = true;
        this.myDirectoryInfo.myParent.myIsContentsChanged = true;
    }

    @Override
    public void openDir(String string, long l2) {
        this.myDirectoryInfo = new SVNRemoteStatusEditor$DirectoryInfo(this, string, this.myDirectoryInfo);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (!string.startsWith("svn:entry:") && !string.startsWith("svn:wc:")) {
            this.myDirectoryInfo.myIsPropertiesChanged = true;
        }
        if ("svn:entry:committed-rev".equals(string) && sVNPropertyValue != null) {
            try {
                long l2 = Long.parseLong(sVNPropertyValue.getString());
                this.myDirectoryInfo.myRemoteRevision = SVNRevision.create(l2);
            }
            catch (NumberFormatException numberFormatException) {
                this.myDirectoryInfo.myRemoteRevision = SVNRevision.UNDEFINED;
            }
        } else if ("svn:entry:committed-date".equals(string) && sVNPropertyValue != null) {
            this.myDirectoryInfo.myRemoteDate = SVNDate.parseDate(sVNPropertyValue.getString());
        } else if ("svn:entry:last-author".equals(string) && sVNPropertyValue != null) {
            this.myDirectoryInfo.myRemoteAuthor = sVNPropertyValue.getString();
        }
    }

    @Override
    public void closeDir() {
        Object object;
        Object object2;
        SVNRemoteStatusEditor$DirectoryInfo sVNRemoteStatusEditor$DirectoryInfo = this.myDirectoryInfo.myParent;
        if (this.myDirectoryInfo.myIsAdded || this.myDirectoryInfo.myIsPropertiesChanged || this.myDirectoryInfo.myIsContentsChanged || this.myDirectoryInfo.myRemoteRevision != null && this.myDirectoryInfo.myRemoteRevision != SVNRevision.UNDEFINED) {
            if (this.myDirectoryInfo.myIsAdded) {
                object2 = SVNStatusType.STATUS_ADDED;
                object = this.myDirectoryInfo.myIsPropertiesChanged ? SVNStatusType.STATUS_ADDED : SVNStatusType.STATUS_NONE;
            } else {
                object2 = this.myDirectoryInfo.myIsContentsChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
                Object object3 = object = this.myDirectoryInfo.myIsPropertiesChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            }
            if (sVNRemoteStatusEditor$DirectoryInfo != null) {
                this.tweakStatusHash(sVNRemoteStatusEditor$DirectoryInfo, this.myDirectoryInfo, this.myDirectoryInfo.myPath, (SVNStatusType)object2, (SVNStatusType)object, null, null);
            }
        }
        if (sVNRemoteStatusEditor$DirectoryInfo != null && this.myDirectoryInfo.myDepth != SVNDepth.EXCLUDE) {
            boolean bl2 = false;
            object = (SVNStatus)sVNRemoteStatusEditor$DirectoryInfo.myChildrenStatuses.get(this.myDirectoryInfo.myPath);
            if (object != null && (((SVNStatus)object).getRemoteContentsStatus() == SVNStatusType.STATUS_DELETED || ((SVNStatus)object).getRemoteContentsStatus() == SVNStatusType.STATUS_REPLACED)) {
                bl2 = true;
            }
            this.handleStatusHash(object != null ? ((SVNStatus)object).getEntry() : null, this.myDirectoryInfo.myChildrenStatuses, bl2, this.myDirectoryInfo.myDepth);
            if (this.isSendableStatus((SVNStatus)object)) {
                this.getDefaultHandler().handleStatus((SVNStatus)object);
            }
            sVNRemoteStatusEditor$DirectoryInfo.myChildrenStatuses.remove(this.myDirectoryInfo.myPath);
        } else if (sVNRemoteStatusEditor$DirectoryInfo == null) {
            if (this.hasTarget()) {
                object2 = this.getAnchor().getFile(this.getAdminAreaInfo().getTargetName());
                object = (SVNStatus)this.myDirectoryInfo.myChildrenStatuses.get(object2);
                if (object != null) {
                    if (((SVNStatus)object).getKind() == SVNNodeKind.DIR) {
                        SVNAdminArea sVNAdminArea = this.getWCAccess().retrieve((File)object2);
                        this.getDirStatus(null, sVNAdminArea, null, this.getDepth(), this.isReportAll(), this.isNoIgnore(), null, true, this.getDefaultHandler());
                    }
                    if (this.isSendableStatus((SVNStatus)object)) {
                        this.getDefaultHandler().handleStatus((SVNStatus)object);
                    }
                }
            } else {
                this.handleStatusHash(this.myAnchorStatus.getEntry(), this.myDirectoryInfo.myChildrenStatuses, false, this.getDepth());
                if (this.myDirectoryInfo != null && this.myDirectoryInfo.myParent == null) {
                    this.tweakAnchorStatus(this.myDirectoryInfo);
                }
                if (this.isSendableStatus(this.myAnchorStatus)) {
                    this.getDefaultHandler().handleStatus(this.myAnchorStatus);
                }
            }
        }
        this.myDirectoryInfo = this.myDirectoryInfo.myParent;
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        this.myFileInfo = new SVNRemoteStatusEditor$FileInfo(this, this.myDirectoryInfo, string, true);
        this.myDirectoryInfo.myIsContentsChanged = true;
    }

    @Override
    public void openFile(String string, long l2) {
        this.myFileInfo = new SVNRemoteStatusEditor$FileInfo(this, this.myDirectoryInfo, string, false);
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (!string2.startsWith("svn:entry:") && !string2.startsWith("svn:wc:")) {
            this.myFileInfo.myIsPropertiesChanged = true;
        }
        if ("svn:entry:committed-rev".equals(string2) && sVNPropertyValue != null) {
            try {
                long l2 = Long.parseLong(sVNPropertyValue.getString());
                this.myFileInfo.myRemoteRevision = SVNRevision.create(l2);
            }
            catch (NumberFormatException numberFormatException) {
                this.myFileInfo.myRemoteRevision = SVNRevision.UNDEFINED;
            }
        } else if ("svn:entry:committed-date".equals(string2) && sVNPropertyValue != null) {
            this.myFileInfo.myRemoteDate = SVNDate.parseDate(sVNPropertyValue.getString());
        } else if ("svn:entry:last-author".equals(string2) && sVNPropertyValue != null) {
            this.myFileInfo.myRemoteAuthor = sVNPropertyValue.getString();
        }
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        this.myFileInfo.myIsContentsChanged = true;
    }

    @Override
    public void closeFile(String string, String string2) {
        SVNStatusType sVNStatusType;
        SVNStatusType sVNStatusType2;
        if (!(this.myFileInfo.myIsAdded || this.myFileInfo.myIsPropertiesChanged || this.myFileInfo.myIsContentsChanged)) {
            return;
        }
        SVNLock sVNLock = null;
        if (this.myFileInfo.myIsAdded) {
            sVNStatusType2 = SVNStatusType.STATUS_ADDED;
            sVNStatusType = this.myFileInfo.myIsPropertiesChanged ? SVNStatusType.STATUS_ADDED : SVNStatusType.STATUS_NONE;
        } else {
            sVNStatusType2 = this.myFileInfo.myIsContentsChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            sVNStatusType = this.myFileInfo.myIsPropertiesChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
        }
        sVNLock = this.getLock(this.myFileInfo.myURL);
        this.tweakStatusHash(this.myFileInfo, this.myFileInfo.myPath, sVNStatusType2, sVNStatusType, sVNLock);
        this.myFileInfo = null;
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        return null;
    }

    @Override
    public void textDeltaEnd(String string) {
    }

    @Override
    public SVNCommitInfo closeEdit() {
        if (this.myIsRootOpen) {
            this.cleanup();
        } else {
            super.closeEdit();
        }
        return new SVNCommitInfo(this.getTargetRevision(), null, null);
    }

    @Override
    public void abortEdit() {
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    private void handleStatusHash(SVNEntry sVNEntry, Map map, boolean bl2, SVNDepth sVNDepth) {
        ISVNStatusHandler iSVNStatusHandler = bl2 ? this : this.getDefaultHandler();
        for (File file : map.keySet()) {
            SVNStatus sVNStatus = (SVNStatus)map.get(file);
            if (sVNStatus.getContentsStatus() != SVNStatusType.STATUS_OBSTRUCTED && sVNStatus.getContentsStatus() != SVNStatusType.STATUS_MISSING && sVNStatus.getEntry() != null && sVNStatus.getKind() == SVNNodeKind.DIR && (sVNDepth == SVNDepth.UNKNOWN || sVNDepth == SVNDepth.IMMEDIATES || sVNDepth == SVNDepth.INFINITY)) {
                SVNAdminArea sVNAdminArea = this.getWCAccess().retrieve(file);
                SVNDepth sVNDepth2 = sVNDepth;
                if (sVNDepth2 == SVNDepth.IMMEDIATES) {
                    sVNDepth2 = SVNDepth.EMPTY;
                }
                this.getDirStatus(sVNEntry, sVNAdminArea, null, sVNDepth2, this.isReportAll(), this.isNoIgnore(), null, true, iSVNStatusHandler);
            }
            if (bl2) {
                sVNStatus.setRemoteStatus(SVNStatusType.STATUS_DELETED, null, null, null);
            }
            if (!this.isSendableStatus(sVNStatus)) continue;
            iSVNStatusHandler.handleStatus(sVNStatus);
        }
    }

    private void tweakStatusHash(SVNRemoteStatusEditor$FileInfo sVNRemoteStatusEditor$FileInfo, File file, SVNStatusType sVNStatusType, SVNStatusType sVNStatusType2, SVNLock sVNLock) {
        Map map = sVNRemoteStatusEditor$FileInfo.myParent.myChildrenStatuses;
        SVNStatus sVNStatus = (SVNStatus)map.get(sVNRemoteStatusEditor$FileInfo.myPath);
        if (sVNStatus == null) {
            if (sVNStatusType != SVNStatusType.STATUS_ADDED) {
                return;
            }
            sVNStatus = this.createStatus(file);
            map.put(sVNRemoteStatusEditor$FileInfo.myPath, sVNStatus);
        }
        if (sVNStatusType == SVNStatusType.STATUS_ADDED && sVNStatus.getRemoteContentsStatus() == SVNStatusType.STATUS_DELETED) {
            sVNStatusType = SVNStatusType.STATUS_REPLACED;
        }
        sVNStatus.setRemoteStatus(sVNRemoteStatusEditor$FileInfo.myURL, sVNStatusType, sVNStatusType2, sVNLock, sVNRemoteStatusEditor$FileInfo.myRemoteKind, sVNRemoteStatusEditor$FileInfo.myRemoteRevision, sVNRemoteStatusEditor$FileInfo.myRemoteDate, sVNRemoteStatusEditor$FileInfo.myRemoteAuthor);
        sVNStatus.setRepositoryRootURL(this.myRepositoryRoot);
        if (sVNStatus.getRemoteURL() != null) {
            sVNStatus.setRepositoryRelativePath(SVNURLUtil.getRelativeURL(this.myRepositoryRoot, sVNStatus.getRemoteURL(), false));
        }
    }

    private void tweakStatusHash(SVNRemoteStatusEditor$DirectoryInfo sVNRemoteStatusEditor$DirectoryInfo, SVNRemoteStatusEditor$DirectoryInfo sVNRemoteStatusEditor$DirectoryInfo2, File file, SVNStatusType sVNStatusType, SVNStatusType sVNStatusType2, SVNLock sVNLock, SVNRevision sVNRevision) {
        Map map = sVNRemoteStatusEditor$DirectoryInfo.myChildrenStatuses;
        SVNStatus sVNStatus = (SVNStatus)map.get(file);
        if (sVNStatus == null) {
            if (sVNStatusType != SVNStatusType.STATUS_ADDED) {
                return;
            }
            sVNStatus = this.createStatus(file);
            map.put(file, sVNStatus);
        }
        if (sVNStatusType == SVNStatusType.STATUS_ADDED && sVNStatus.getRemoteContentsStatus() == SVNStatusType.STATUS_DELETED) {
            sVNStatusType = SVNStatusType.STATUS_REPLACED;
        }
        if (sVNStatusType == SVNStatusType.STATUS_DELETED) {
            SVNURL sVNURL = sVNRemoteStatusEditor$DirectoryInfo.myURL;
            if (sVNRemoteStatusEditor$DirectoryInfo2 != null) {
                if (sVNRemoteStatusEditor$DirectoryInfo2.myURL != null) {
                    sVNURL = sVNRemoteStatusEditor$DirectoryInfo2.myURL.appendPath(SVNFileUtil.getFileName(file), false);
                }
            } else if (sVNRemoteStatusEditor$DirectoryInfo.myURL != null) {
                sVNURL = sVNRemoteStatusEditor$DirectoryInfo.myURL.appendPath(SVNFileUtil.getFileName(file), false);
            }
            if (sVNRevision == SVNRevision.UNDEFINED) {
                sVNRevision = sVNRemoteStatusEditor$DirectoryInfo.myRemoteRevision;
            }
            sVNStatus.setRemoteStatus(sVNURL, sVNStatusType, sVNStatusType2, sVNLock, SVNNodeKind.NONE, sVNRevision, null, null);
        } else if (sVNRemoteStatusEditor$DirectoryInfo2 == null) {
            sVNStatus.setRemoteStatus(sVNRemoteStatusEditor$DirectoryInfo.myURL, sVNStatusType, sVNStatusType2, sVNLock, sVNRemoteStatusEditor$DirectoryInfo.myRemoteKind, sVNRemoteStatusEditor$DirectoryInfo.myRemoteRevision, sVNRemoteStatusEditor$DirectoryInfo.myRemoteDate, sVNRemoteStatusEditor$DirectoryInfo.myRemoteAuthor);
        } else {
            sVNStatus.setRemoteStatus(sVNRemoteStatusEditor$DirectoryInfo2.myURL, sVNStatusType, sVNStatusType2, sVNLock, sVNRemoteStatusEditor$DirectoryInfo2.myRemoteKind, sVNRemoteStatusEditor$DirectoryInfo2.myRemoteRevision, sVNRemoteStatusEditor$DirectoryInfo2.myRemoteDate, sVNRemoteStatusEditor$DirectoryInfo2.myRemoteAuthor);
        }
        sVNStatus.setRepositoryRootURL(this.myRepositoryRoot);
        if (sVNStatus.getRemoteURL() != null) {
            sVNStatus.setRepositoryRelativePath(SVNURLUtil.getRelativeURL(this.myRepositoryRoot, sVNStatus.getRemoteURL(), false));
        }
    }

    private void tweakAnchorStatus(SVNRemoteStatusEditor$DirectoryInfo sVNRemoteStatusEditor$DirectoryInfo) {
        if (sVNRemoteStatusEditor$DirectoryInfo != null && (sVNRemoteStatusEditor$DirectoryInfo.myIsContentsChanged || sVNRemoteStatusEditor$DirectoryInfo.myIsPropertiesChanged)) {
            SVNStatusType sVNStatusType = sVNRemoteStatusEditor$DirectoryInfo.myIsContentsChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            SVNStatusType sVNStatusType2 = sVNRemoteStatusEditor$DirectoryInfo.myIsPropertiesChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            this.myAnchorStatus.setRemoteStatus(this.myDirectoryInfo.myURL, sVNStatusType, sVNStatusType2, null, SVNNodeKind.DIR, this.myDirectoryInfo.myRemoteRevision, this.myDirectoryInfo.myRemoteDate, this.myDirectoryInfo.myRemoteAuthor);
        }
    }

    private boolean isSendableStatus(SVNStatus sVNStatus) {
        if (sVNStatus == null) {
            return false;
        }
        if (sVNStatus.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE) {
            return true;
        }
        if (sVNStatus.getRemotePropertiesStatus() != SVNStatusType.STATUS_NONE) {
            return true;
        }
        if (sVNStatus.getRemoteLock() != null) {
            return true;
        }
        if (sVNStatus.getContentsStatus() == SVNStatusType.STATUS_IGNORED && !this.isNoIgnore()) {
            return false;
        }
        if (this.isReportAll()) {
            return true;
        }
        if (sVNStatus.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED) {
            return true;
        }
        if (sVNStatus.getContentsStatus() != SVNStatusType.STATUS_NONE && sVNStatus.getContentsStatus() != SVNStatusType.STATUS_NORMAL) {
            return true;
        }
        if (sVNStatus.getPropertiesStatus() != SVNStatusType.STATUS_NONE && sVNStatus.getPropertiesStatus() != SVNStatusType.STATUS_NORMAL) {
            return true;
        }
        if (sVNStatus.getTreeConflict() != null) {
            return true;
        }
        return sVNStatus.isLocked() || sVNStatus.isSwitched() || sVNStatus.getLocalLock() != null || sVNStatus.getChangelistName() != null || sVNStatus.isFileExternal();
    }

    private SVNStatus createStatus(File file) {
        SVNAdminArea sVNAdminArea;
        SVNEntry sVNEntry = this.getWCAccess().getEntry(file, false);
        SVNEntry sVNEntry2 = null;
        if (sVNEntry != null && (sVNAdminArea = this.getWCAccess().getAdminArea(file.getParentFile())) != null) {
            sVNEntry2 = this.getWCAccess().getEntry(file.getParentFile(), false);
        }
        return this.assembleStatus(file, sVNEntry != null ? this.getWCAccess().probeRetrieve(file) : null, sVNEntry, sVNEntry2, SVNNodeKind.UNKNOWN, false, true, false);
    }

    @Override
    public void handleStatus(SVNStatus sVNStatus) {
        sVNStatus.setRemoteStatus(SVNStatusType.STATUS_DELETED, null, null, null);
        this.getDefaultHandler().handleStatus(sVNStatus);
    }

    static /* synthetic */ SVNStatus access$000(SVNRemoteStatusEditor sVNRemoteStatusEditor) {
        return sVNRemoteStatusEditor.myAnchorStatus;
    }
}

