/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.ISVNReusableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteDiffEditor$KindActionState;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteDiffEditor$SVNDirectoryInfo;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteDiffEditor$SVNFileInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNRemoteDiffEditor
implements ISVNReusableEditor {
    protected SVNRepository myRepos;
    protected long myRevision1;
    protected long myRevision2;
    protected File myTarget;
    protected SVNAdminArea myAdminArea;
    protected boolean myIsDryRun;
    protected SVNDeltaProcessor myDeltaProcessor;
    protected ISVNEventHandler myEventHandler;
    protected ISVNEventHandler myCancelHandler;
    protected AbstractDiffCallback myDiffCallback;
    protected SVNRemoteDiffEditor$SVNDirectoryInfo myCurrentDirectory;
    protected SVNRemoteDiffEditor$SVNFileInfo myCurrentFile;
    protected File myTempDirectory;
    protected Collection myTempFiles;
    protected Map myDeletedPaths;
    private boolean myIsUseGlobalTmp;

    public SVNRemoteDiffEditor(SVNAdminArea sVNAdminArea, File file, AbstractDiffCallback abstractDiffCallback, SVNRepository sVNRepository, long l2, long l3, boolean bl2, ISVNEventHandler iSVNEventHandler, ISVNEventHandler iSVNEventHandler2) {
        this.myAdminArea = sVNAdminArea;
        this.myTarget = file;
        this.myDiffCallback = abstractDiffCallback;
        this.myRepos = sVNRepository;
        this.myRevision1 = l2;
        this.myRevision2 = l3;
        this.myEventHandler = iSVNEventHandler;
        this.myCancelHandler = iSVNEventHandler2;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myIsDryRun = bl2;
        this.myDeletedPaths = new SVNHashMap();
    }

    @Override
    public void reset(long l2, long l3) {
        this.myRevision1 = l2;
        this.myRevision2 = l3;
    }

    @Override
    public void targetRevision(long l2) {
        this.myRevision2 = l2;
    }

    @Override
    public void openRoot(long l2) {
        this.myCurrentDirectory = new SVNRemoteDiffEditor$SVNDirectoryInfo(this, null, "", false);
        this.myCurrentDirectory.loadFromRepository(l2);
    }

    @Override
    public void deleteEntry(String string, long l2) {
        if (this.myCurrentDirectory.myIsSkip || this.myCurrentDirectory.myIsTreeConflicted) {
            return;
        }
        SVNNodeKind sVNNodeKind = this.myRepos.checkPath(string, this.myRevision1);
        SVNAdminArea sVNAdminArea = this.retrieve(this.myCurrentDirectory.myWCFile, true);
        this.deleteEntry(string, sVNNodeKind, sVNAdminArea);
    }

    protected void deleteEntry(String string, SVNNodeKind sVNNodeKind, SVNAdminArea sVNAdminArea) {
        SVNStatusType sVNStatusType = SVNStatusType.INAPPLICABLE;
        SVNEventAction sVNEventAction = SVNEventAction.SKIP;
        SVNEventAction sVNEventAction2 = SVNEventAction.UPDATE_DELETE;
        boolean[] blArray = new boolean[]{false};
        if (this.myAdminArea == null || sVNAdminArea != null) {
            if (sVNNodeKind == SVNNodeKind.FILE) {
                SVNRemoteDiffEditor$SVNFileInfo sVNRemoteDiffEditor$SVNFileInfo = new SVNRemoteDiffEditor$SVNFileInfo(this, string, false);
                sVNRemoteDiffEditor$SVNFileInfo.loadFromRepository(this.myRevision1);
                String string2 = sVNRemoteDiffEditor$SVNFileInfo.myBaseProperties.getStringValue("svn:mime-type");
                sVNStatusType = this.getDiffCallback().fileDeleted(string, sVNRemoteDiffEditor$SVNFileInfo.myBaseFile, null, string2, null, sVNRemoteDiffEditor$SVNFileInfo.myBaseProperties, blArray);
            } else if (sVNNodeKind == SVNNodeKind.DIR) {
                sVNStatusType = this.getDiffCallback().directoryDeleted(string, blArray);
            }
            if (sVNStatusType != SVNStatusType.MISSING && sVNStatusType != SVNStatusType.OBSTRUCTED && !blArray[0]) {
                sVNEventAction = SVNEventAction.UPDATE_DELETE;
                if (this.myIsDryRun) {
                    this.getDiffCallback().addDeletedPath(string);
                }
            }
        }
        sVNEventAction = blArray[0] ? SVNEventAction.TREE_CONFLICT : sVNEventAction;
        this.addDeletedPath(string, sVNNodeKind, sVNStatusType, sVNEventAction, sVNEventAction2, blArray[0]);
    }

    protected void addDeletedPath(String string, SVNNodeKind sVNNodeKind, SVNStatusType sVNStatusType, SVNEventAction sVNEventAction, SVNEventAction sVNEventAction2, boolean bl2) {
        if (this.myEventHandler != null) {
            File file = new File(this.myTarget, string);
            SVNRemoteDiffEditor$KindActionState sVNRemoteDiffEditor$KindActionState = new SVNRemoteDiffEditor$KindActionState(this);
            sVNRemoteDiffEditor$KindActionState.myAction = sVNEventAction;
            sVNRemoteDiffEditor$KindActionState.myKind = sVNNodeKind;
            sVNRemoteDiffEditor$KindActionState.myStatus = sVNStatusType;
            sVNRemoteDiffEditor$KindActionState.myExpectedAction = sVNEventAction2;
            sVNRemoteDiffEditor$KindActionState.myIsTreeConflicted = bl2;
            this.myDeletedPaths.put(file, sVNRemoteDiffEditor$KindActionState);
        }
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        SVNRemoteDiffEditor$SVNDirectoryInfo sVNRemoteDiffEditor$SVNDirectoryInfo = this.myCurrentDirectory;
        this.myCurrentDirectory = new SVNRemoteDiffEditor$SVNDirectoryInfo(this, this.myCurrentDirectory, string, true);
        this.myCurrentDirectory.myBaseProperties = new SVNProperties();
        if (sVNRemoteDiffEditor$SVNDirectoryInfo.myIsSkip || sVNRemoteDiffEditor$SVNDirectoryInfo.myIsTreeConflicted) {
            this.myCurrentDirectory.myIsSkip = true;
            return;
        }
        boolean[] blArray = new boolean[]{false};
        SVNStatusType sVNStatusType = this.getDiffCallback().directoryAdded(string, this.myRevision2, blArray);
        this.myCurrentDirectory.myIsTreeConflicted = blArray[0];
        if (this.myEventHandler != null) {
            SVNEventAction sVNEventAction = SVNEventAction.UPDATE_ADD;
            SVNNodeKind sVNNodeKind = SVNNodeKind.DIR;
            SVNRemoteDiffEditor$KindActionState sVNRemoteDiffEditor$KindActionState = (SVNRemoteDiffEditor$KindActionState)this.myDeletedPaths.get(this.myCurrentDirectory.myWCFile);
            if (sVNRemoteDiffEditor$KindActionState != null) {
                sVNNodeKind = sVNRemoteDiffEditor$KindActionState.myKind;
                sVNStatusType = sVNRemoteDiffEditor$KindActionState.myStatus;
                this.myDeletedPaths.remove(this.myCurrentDirectory.myWCFile);
            }
            if (this.myCurrentDirectory.myIsTreeConflicted) {
                sVNEventAction = SVNEventAction.TREE_CONFLICT;
            } else if (sVNRemoteDiffEditor$KindActionState != null) {
                sVNEventAction = sVNRemoteDiffEditor$KindActionState.myAction == SVNEventAction.UPDATE_DELETE ? SVNEventAction.UPDATE_REPLACE : sVNRemoteDiffEditor$KindActionState.myAction;
            } else if (sVNStatusType == SVNStatusType.MISSING || sVNStatusType == SVNStatusType.OBSTRUCTED) {
                sVNEventAction = SVNEventAction.SKIP;
            }
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(this.myCurrentDirectory.myWCFile, sVNNodeKind, null, -1L, sVNStatusType, sVNStatusType, null, sVNEventAction, SVNEventAction.UPDATE_ADD, null, null);
            this.myEventHandler.handleEvent(sVNEvent, -1.0);
        }
    }

    @Override
    public void openDir(String string, long l2) {
        SVNRemoteDiffEditor$SVNDirectoryInfo sVNRemoteDiffEditor$SVNDirectoryInfo = this.myCurrentDirectory;
        this.myCurrentDirectory = new SVNRemoteDiffEditor$SVNDirectoryInfo(this, this.myCurrentDirectory, string, false);
        if (sVNRemoteDiffEditor$SVNDirectoryInfo.myIsSkip || sVNRemoteDiffEditor$SVNDirectoryInfo.myIsTreeConflicted) {
            this.myCurrentDirectory.myIsSkip = true;
            return;
        }
        this.myCurrentDirectory.loadFromRepository(l2);
        boolean[] blArray = new boolean[]{false};
        this.getDiffCallback().directoryOpened(string, l2, blArray);
        this.myCurrentDirectory.myIsTreeConflicted = blArray[0];
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (this.myCurrentDirectory.myIsSkip) {
            return;
        }
        this.myCurrentDirectory.myPropertyDiff.put(string, sVNPropertyValue);
    }

    @Override
    public void closeDir() {
        Object object;
        SVNEventAction sVNEventAction;
        if (this.myCurrentDirectory.myIsSkip) {
            this.myCurrentDirectory = this.myCurrentDirectory.myParent;
            return;
        }
        SVNStatusType sVNStatusType = SVNStatusType.UNKNOWN;
        SVNEventAction sVNEventAction2 = sVNEventAction = SVNEventAction.UPDATE_UPDATE;
        if (this.myIsDryRun) {
            this.getDiffCallback().clearDeletedPaths();
        }
        SVNAdminArea sVNAdminArea = null;
        if (!this.myCurrentDirectory.myPropertyDiff.isEmpty()) {
            try {
                sVNAdminArea = this.retrieve(this.myCurrentDirectory.myWCFile, this.myIsDryRun);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    if (!this.myCurrentDirectory.myIsAdded && this.myEventHandler != null) {
                        sVNEventAction2 = this.myCurrentDirectory.myIsTreeConflicted ? SVNEventAction.TREE_CONFLICT : SVNEventAction.SKIP;
                        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(this.myCurrentDirectory.myWCFile, SVNNodeKind.DIR, null, -1L, SVNStatusType.MISSING, SVNStatusType.MISSING, null, sVNEventAction2, sVNEventAction, null, null);
                        this.myEventHandler.handleEvent(sVNEvent, -1.0);
                    }
                    this.myCurrentDirectory = this.myCurrentDirectory.myParent;
                    return;
                }
                throw sVNException;
            }
            if (!this.myIsDryRun || sVNAdminArea != null) {
                object = new boolean[]{false};
                sVNStatusType = this.getDiffCallback().propertiesChanged(this.myCurrentDirectory.myRepositoryPath, this.myCurrentDirectory.myBaseProperties, this.myCurrentDirectory.myPropertyDiff, (boolean[])object);
                if (object[0] != false) {
                    this.myCurrentDirectory.myIsTreeConflicted = true;
                }
            }
        }
        this.getDiffCallback().directoryClosed(this.myCurrentDirectory.myRepositoryPath, null);
        if (sVNStatusType == SVNStatusType.UNKNOWN) {
            sVNEventAction2 = SVNEventAction.UPDATE_NONE;
        }
        if (!this.myCurrentDirectory.myIsAdded && this.myEventHandler != null) {
            object = this.myDeletedPaths.keySet().iterator();
            while (object.hasNext()) {
                File file = (File)object.next();
                SVNRemoteDiffEditor$KindActionState sVNRemoteDiffEditor$KindActionState = (SVNRemoteDiffEditor$KindActionState)this.myDeletedPaths.get(file);
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, sVNRemoteDiffEditor$KindActionState.myKind, null, -1L, sVNRemoteDiffEditor$KindActionState.myStatus, sVNRemoteDiffEditor$KindActionState.myStatus, SVNStatusType.LOCK_INAPPLICABLE, sVNRemoteDiffEditor$KindActionState.myAction, sVNRemoteDiffEditor$KindActionState.myExpectedAction, null, null);
                this.myEventHandler.handleEvent(sVNEvent, -1.0);
                object.remove();
            }
            sVNEventAction2 = this.myCurrentDirectory.myIsTreeConflicted ? SVNEventAction.TREE_CONFLICT : sVNEventAction2;
            object = SVNEventFactory.createSVNEvent(this.myCurrentDirectory.myWCFile, SVNNodeKind.DIR, null, -1L, SVNStatusType.INAPPLICABLE, sVNStatusType, SVNStatusType.LOCK_INAPPLICABLE, sVNEventAction2, sVNEventAction, null, null);
            this.myEventHandler.handleEvent((SVNEvent)object, -1.0);
        }
        this.myCurrentDirectory = this.myCurrentDirectory.myParent;
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        this.myCurrentFile = this.createFileInfo(string, true);
        if (this.myCurrentDirectory.myIsSkip || this.myCurrentDirectory.myIsTreeConflicted) {
            this.myCurrentFile.myIsSkip = true;
            return;
        }
        this.myCurrentFile.myBaseProperties = new SVNProperties();
        this.myCurrentFile.myBaseFile = SVNFileUtil.createUniqueFile(this.getTempDirectory(), ".diff", ".tmp", this.myIsUseGlobalTmp);
    }

    @Override
    public void openFile(String string, long l2) {
        this.myCurrentFile = this.createFileInfo(string, false);
        if (this.myCurrentDirectory.myIsSkip || this.myCurrentDirectory.myIsTreeConflicted) {
            this.myCurrentFile.myIsSkip = true;
            return;
        }
        this.myCurrentFile.loadFromRepository(l2);
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (this.myCurrentFile.myIsSkip) {
            return;
        }
        this.myCurrentFile.myPropertyDiff.put(string2, sVNPropertyValue);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        if (this.myCurrentFile.myIsSkip) {
            return;
        }
        SVNAdminArea sVNAdminArea = null;
        try {
            sVNAdminArea = this.retrieveParent(this.myCurrentFile.myWCFile, true);
        }
        catch (SVNException sVNException) {
            sVNAdminArea = null;
        }
        this.myCurrentFile.myFile = this.createTempFile(sVNAdminArea, SVNPathUtil.tail(string));
        this.myDeltaProcessor.applyTextDelta(this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, false);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        if (this.myCurrentFile.myIsSkip) {
            return SVNFileUtil.DUMMY_OUT;
        }
        return this.myDeltaProcessor.textDeltaChunk(sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        if (this.myCurrentFile.myIsSkip) {
            return;
        }
        this.myDeltaProcessor.textDeltaEnd();
    }

    @Override
    public void closeFile(String string, String string2) {
        if (this.myCurrentFile.myIsSkip) {
            return;
        }
        boolean[] blArray = new boolean[]{false};
        this.closeFile(string, this.myCurrentFile.myIsAdded, this.myCurrentFile.myWCFile, this.myCurrentFile.myFile, this.myCurrentFile.myPropertyDiff, this.myCurrentFile.myBaseProperties, this.myCurrentFile.myBaseFile, blArray);
        this.myCurrentFile.myIsTreeConflicted = blArray[0];
    }

    protected void closeFile(String string, boolean bl2, File file, File file2, SVNProperties sVNProperties, SVNProperties sVNProperties2, File file3, boolean[] blArray) {
        Object object;
        Object object2;
        SVNEventAction sVNEventAction = bl2 ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
        SVNStatusType[] sVNStatusTypeArray = new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};
        try {
            this.retrieveParent(file, this.myIsDryRun);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                if (this.myEventHandler != null) {
                    SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNStatusType.MISSING, SVNStatusType.UNKNOWN, null, SVNEventAction.SKIP, sVNEventAction, null, null);
                    this.myEventHandler.handleEvent(sVNEvent, -1.0);
                }
                return;
            }
            throw sVNException;
        }
        if (file2 != null || !sVNProperties.isEmpty()) {
            object2 = sVNProperties2.getStringValue("svn:mime-type");
            object = sVNProperties.getStringValue("svn:mime-type");
            sVNStatusTypeArray = bl2 ? this.getDiffCallback().fileAdded(string, file2 != null ? file3 : null, file2, 0L, this.myRevision2, (String)object2, (String)object, sVNProperties2, sVNProperties, blArray) : this.getDiffCallback().fileChanged(string, file2 != null ? file3 : null, file2, this.myRevision1, this.myRevision2, (String)object2, (String)object, sVNProperties2, sVNProperties, blArray);
        }
        if (this.myEventHandler != null) {
            object2 = SVNNodeKind.FILE;
            SVNRemoteDiffEditor$KindActionState sVNRemoteDiffEditor$KindActionState = (SVNRemoteDiffEditor$KindActionState)this.myDeletedPaths.get(file);
            if (sVNRemoteDiffEditor$KindActionState != null) {
                this.myDeletedPaths.remove(file);
                object2 = sVNRemoteDiffEditor$KindActionState.myKind;
                sVNStatusTypeArray[0] = sVNStatusTypeArray[1] = sVNRemoteDiffEditor$KindActionState.myStatus;
            }
            object = blArray != null && blArray.length > 0 && blArray[0] ? SVNEventAction.TREE_CONFLICT : (sVNRemoteDiffEditor$KindActionState != null ? (sVNRemoteDiffEditor$KindActionState.myAction == SVNEventAction.UPDATE_DELETE && bl2 ? SVNEventAction.UPDATE_REPLACE : sVNRemoteDiffEditor$KindActionState.myAction) : (sVNStatusTypeArray[0] == SVNStatusType.MISSING || sVNStatusTypeArray[0] == SVNStatusType.OBSTRUCTED ? SVNEventAction.SKIP : (bl2 ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE)));
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, (SVNNodeKind)object2, null, -1L, sVNStatusTypeArray[0], sVNStatusTypeArray[1], null, (SVNEventAction)object, sVNEventAction, null, null);
            this.myEventHandler.handleEvent(sVNEvent, -1.0);
        }
    }

    @Override
    public SVNCommitInfo closeEdit() {
        return null;
    }

    @Override
    public void abortEdit() {
    }

    @Override
    public void absentDir(String string) {
        if (this.myCurrentDirectory.myWCFile != null) {
            File file = new File(this.myCurrentDirectory.myWCFile, SVNPathUtil.tail(string));
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNEventAction.SKIP, null, null, null);
            this.myEventHandler.handleEvent(sVNEvent, -1.0);
        }
    }

    @Override
    public void absentFile(String string) {
        if (this.myCurrentDirectory.myWCFile != null) {
            File file = new File(this.myCurrentDirectory.myWCFile, SVNPathUtil.tail(string));
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNEventAction.SKIP, null, null, null);
            this.myEventHandler.handleEvent(sVNEvent, -1.0);
        }
    }

    @Override
    public void cleanup() {
        if (this.myTempDirectory != null) {
            SVNFileUtil.deleteAll(this.myTempDirectory, true);
            this.myTempDirectory = null;
        }
        if (this.myTempFiles != null) {
            Iterator iterator = this.myTempFiles.iterator();
            while (iterator.hasNext()) {
                SVNFileUtil.deleteFile((File)iterator.next());
            }
        }
    }

    protected SVNAdminArea retrieve(File file, boolean bl2) {
        if (this.myAdminArea == null) {
            return null;
        }
        try {
            return this.myAdminArea.getWCAccess().retrieve(file);
        }
        catch (SVNException sVNException) {
            if (bl2) {
                return null;
            }
            throw sVNException;
        }
    }

    protected SVNAdminArea retrieveParent(File file, boolean bl2) {
        if (this.myAdminArea == null) {
            return null;
        }
        return this.retrieve(file.getParentFile(), bl2);
    }

    protected AbstractDiffCallback getDiffCallback() {
        return this.myDiffCallback;
    }

    protected File getTempDirectory() {
        if (this.myTempDirectory == null) {
            this.myTempDirectory = this.getDiffCallback().createTempDirectory();
        }
        return this.myTempDirectory;
    }

    protected File createTempFile(SVNAdminArea sVNAdminArea, String string) {
        if (sVNAdminArea != null && sVNAdminArea.isLocked()) {
            File file = sVNAdminArea.getBaseFile(string, true);
            if (this.myTempFiles == null) {
                this.myTempFiles = new SVNHashSet();
            }
            this.myTempFiles.add(file);
            return file;
        }
        return SVNFileUtil.createUniqueFile(this.getTempDirectory(), ".diff", ".tmp", this.myIsUseGlobalTmp);
    }

    protected SVNRemoteDiffEditor$SVNFileInfo createFileInfo(String string, boolean bl2) {
        return new SVNRemoteDiffEditor$SVNFileInfo(this, string, bl2);
    }

    protected void setIsConflicted(boolean[] blArray, boolean bl2) {
        if (blArray != null && blArray.length > 0) {
            blArray[0] = bl2;
        }
    }

    public void setUseGlobalTmp(boolean bl2) {
        this.myIsUseGlobalTmp = bl2;
    }

    static /* synthetic */ boolean access$000(SVNRemoteDiffEditor sVNRemoteDiffEditor) {
        return sVNRemoteDiffEditor.myIsUseGlobalTmp;
    }
}

