/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.ISVNFileContentFetcher;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager$1;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager$2;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPropertiesManager {
    private static final Collection NOT_ALLOWED_FOR_FILE = new SVNHashSet();
    private static final Collection NOT_ALLOWED_FOR_DIR = new SVNHashSet();

    public static void validateRevisionProperties(SVNProperties sVNProperties) {
        if (SVNPropertiesManager.hasSVNProperties(sVNProperties)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Standard properties can't be set explicitly as revision properties");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
    }

    public static boolean setWCProperty(SVNWCAccess sVNWCAccess, File file, String string, SVNPropertyValue sVNPropertyValue, boolean bl2) {
        SVNEntry sVNEntry = sVNWCAccess.getVersionedEntry(file, false);
        SVNAdminArea sVNAdminArea = sVNEntry.getKind() == SVNNodeKind.DIR ? sVNWCAccess.retrieve(file) : sVNWCAccess.retrieve(file.getParentFile());
        SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getWCProperties(sVNEntry.getName());
        SVNPropertyValue sVNPropertyValue2 = sVNVersionedProperties.getPropertyValue(string);
        sVNVersionedProperties.setPropertyValue(string, sVNPropertyValue);
        if (bl2) {
            sVNAdminArea.saveWCProperties(false);
        }
        return sVNPropertyValue2 == null ? sVNPropertyValue != null : !sVNPropertyValue2.equals(sVNPropertyValue);
    }

    public static SVNPropertyValue getWCProperty(SVNWCAccess sVNWCAccess, File file, String string) {
        SVNEntry sVNEntry = sVNWCAccess.getEntry(file, false);
        if (sVNEntry == null) {
            return null;
        }
        SVNAdminArea sVNAdminArea = sVNEntry.getKind() == SVNNodeKind.DIR ? sVNWCAccess.retrieve(file) : sVNWCAccess.retrieve(file.getParentFile());
        return sVNAdminArea.getWCProperties(sVNEntry.getName()).getPropertyValue(string);
    }

    public static void deleteWCProperties(SVNAdminArea sVNAdminArea, String string, boolean bl2) {
        Object object;
        if (string != null && (object = sVNAdminArea.getWCProperties(string)) != null) {
            ((SVNVersionedProperties)object).removeAll();
        }
        if (bl2 || string == null) {
            object = sVNAdminArea.entries(false);
            while (object.hasNext()) {
                SVNEntry sVNEntry = (SVNEntry)object.next();
                SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getWCProperties(sVNEntry.getName());
                if (sVNVersionedProperties != null) {
                    sVNVersionedProperties.removeAll();
                }
                if (sVNEntry.isFile() || sVNAdminArea.getThisDirName().equals(sVNEntry.getName()) || !bl2) continue;
                SVNAdminArea sVNAdminArea2 = sVNAdminArea.getWCAccess().retrieve(sVNAdminArea.getFile(sVNEntry.getName()));
                SVNPropertiesManager.deleteWCProperties(sVNAdminArea2, null, true);
            }
        }
        sVNAdminArea.saveWCProperties(false);
    }

    public static SVNPropertyValue getProperty(SVNWCAccess sVNWCAccess, File file, String string) {
        Object object;
        SVNEntry sVNEntry = sVNWCAccess.getEntry(file, false);
        if (sVNEntry == null) {
            return null;
        }
        String[] stringArray = sVNEntry.getCachableProperties();
        if (stringArray != null && SVNPropertiesManager.contains(stringArray, string)) {
            object = sVNEntry.getPresentProperties();
            if (object == null || !SVNPropertiesManager.contains((String[])object, string)) {
                return null;
            }
            if (SVNProperty.isBooleanProperty(string)) {
                return SVNProperty.getValueOfBooleanProperty(string);
            }
        }
        if (SVNProperty.isWorkingCopyProperty(string)) {
            return SVNPropertiesManager.getWCProperty(sVNWCAccess, file, string);
        }
        if (SVNProperty.isEntryProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.BAD_PROP_KIND, "Property ''{0}'' is an entry property", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        object = sVNEntry.getKind() == SVNNodeKind.DIR ? sVNWCAccess.retrieve(file) : sVNWCAccess.retrieve(file.getParentFile());
        return ((SVNAdminArea)object).getProperties(sVNEntry.getName()).getPropertyValue(string);
    }

    public static boolean setProperty(SVNWCAccess sVNWCAccess, File file, String string, SVNPropertyValue sVNPropertyValue, boolean bl2) {
        boolean bl3;
        Object object;
        Object object2;
        SVNVersionedProperties sVNVersionedProperties;
        SVNPropertyValue sVNPropertyValue2;
        boolean bl4;
        Object object3;
        if (SVNProperty.isWorkingCopyProperty(string)) {
            return SVNPropertiesManager.setWCProperty(sVNWCAccess, file, string, sVNPropertyValue, true);
        }
        if (SVNProperty.isEntryProperty(string)) {
            object3 = SVNErrorMessage.create(SVNErrorCode.BAD_PROP_KIND, "Property ''{0}'' is an entry property", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.DEFAULT);
        }
        SVNAdminArea sVNAdminArea = ((SVNEntry)(object3 = sVNWCAccess.getVersionedEntry(file, false))).isDirectory() ? sVNWCAccess.retrieve(file) : sVNWCAccess.retrieve(file.getParentFile());
        boolean bl5 = bl4 = "svn:eol-style".equals(string) || "svnkit:charset".equals(string);
        if (sVNPropertyValue != null && SVNProperty.isSVNProperty(string)) {
            sVNPropertyValue = SVNPropertiesManager.validatePropertyValue(file, ((SVNEntry)object3).getKind(), string, sVNPropertyValue, bl2, sVNWCAccess.getOptions(), new SVNPropertiesManager$1(file, sVNWCAccess));
        }
        if (((SVNEntry)object3).getKind() == SVNNodeKind.FILE && "svn:executable".equals(string)) {
            if (sVNPropertyValue == null) {
                SVNFileUtil.setExecutable(file, false);
            } else {
                sVNPropertyValue = SVNProperty.getValueOfBooleanProperty(string);
                SVNFileUtil.setExecutable(file, true);
            }
        }
        if (((SVNEntry)object3).getKind() == SVNNodeKind.FILE && "svn:needs-lock".equals(string)) {
            if (sVNPropertyValue == null) {
                SVNFileUtil.setReadonly(file, false);
            } else {
                sVNPropertyValue = SVNProperty.getValueOfBooleanProperty(string);
            }
        }
        SVNEventAction sVNEventAction = (sVNPropertyValue2 = (sVNVersionedProperties = sVNAdminArea.getProperties(((SVNEntry)object3).getName())).getPropertyValue(string)) == null ? (sVNPropertyValue == null ? SVNEventAction.PROPERTY_DELETE_NONEXISTENT : SVNEventAction.PROPERTY_ADD) : (sVNPropertyValue == null ? SVNEventAction.PROPERTY_DELETE : SVNEventAction.PROPERTY_MODIFY);
        if (!bl4 && ((SVNEntry)object3).getKind() == SVNNodeKind.FILE && "svn:keywords".equals(string)) {
            object2 = SVNPropertiesManager.getKeywords(sVNPropertyValue2 == null ? null : sVNPropertyValue2.getString());
            object = SVNPropertiesManager.getKeywords(sVNPropertyValue == null ? null : sVNPropertyValue.getString());
            bl4 = !object2.equals(object);
        }
        object2 = sVNAdminArea.getLog();
        if (bl4) {
            object = new SVNProperties();
            ((SVNProperties)object).put("name", ((SVNEntry)object3).getName());
            ((SVNProperties)object).put(SVNProperty.shortPropertyName("svn:entry:text-time"), (String)null);
            ((SVNLog)object2).addCommand("modify-entry", (SVNProperties)object, false);
        }
        sVNVersionedProperties.setPropertyValue(string, sVNPropertyValue);
        sVNAdminArea.saveVersionedProperties((SVNLog)object2, false);
        ((SVNLog)object2).save();
        sVNAdminArea.runLogs();
        boolean bl6 = sVNPropertyValue2 == null ? sVNPropertyValue != null : (bl3 = !sVNPropertyValue2.equals(sVNPropertyValue));
        if (bl3 || sVNEventAction == SVNEventAction.PROPERTY_DELETE_NONEXISTENT) {
            sVNAdminArea.getWCAccess().handleEvent(new SVNEvent(file, ((SVNEntry)object3).getKind(), null, -1L, null, null, null, null, sVNEventAction, sVNEventAction, null, null, null, null, null));
        }
        return bl3;
    }

    public static SVNStatusType mergeProperties(SVNWCAccess sVNWCAccess, File file, SVNProperties sVNProperties, SVNProperties sVNProperties2, boolean bl2, boolean bl3) {
        SVNEntry sVNEntry = sVNWCAccess.getVersionedEntry(file, false);
        File file2 = null;
        String string = null;
        if (sVNEntry.isDirectory()) {
            file2 = file;
            string = "";
        } else if (sVNEntry.isFile()) {
            file2 = file.getParentFile();
            string = sVNEntry.getName();
        }
        SVNLog sVNLog = null;
        SVNAdminArea sVNAdminArea = sVNWCAccess.retrieve(file2);
        if (!bl3) {
            sVNLog = sVNAdminArea.getLog();
        }
        SVNStatusType sVNStatusType = sVNAdminArea.mergeProperties(string, sVNProperties, sVNProperties2, null, null, bl2, bl3, sVNLog);
        if (!bl3) {
            sVNLog.save();
            sVNAdminArea.runLogs();
        }
        return sVNStatusType;
    }

    public static Map computeAutoProperties(ISVNOptions iSVNOptions, File file, Map map) {
        String string;
        if (!(map = iSVNOptions.applyAutoProperties(file, map)).containsKey("svn:mime-type") && (string = SVNFileUtil.detectMimeType(file, iSVNOptions.getFileExtensionsToMimeTypes())) != null) {
            map.put("svn:mime-type", string);
        }
        if (SVNProperty.isBinaryMimeType((String)map.get("svn:mime-type"))) {
            map.remove("svn:eol-style");
            map.remove("svnkit:charset");
        }
        if (!map.containsKey("svn:executable") && SVNFileUtil.isExecutable(file)) {
            map.put("svn:executable", "");
        }
        return map;
    }

    public static Map getWorkingCopyPropertyValues(File file, SVNEntry sVNEntry, String string, SVNDepth sVNDepth, boolean bl2) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        SVNPropertiesManager$2 sVNPropertiesManager$2 = new SVNPropertiesManager$2(bl2, string, sVNHashMap);
        if (sVNDepth == SVNDepth.UNKNOWN) {
            sVNDepth = SVNDepth.INFINITY;
        }
        SVNAdminArea sVNAdminArea = sVNEntry.getAdminArea();
        if (sVNEntry.isDirectory() && sVNDepth.compareTo(SVNDepth.FILES) >= 0) {
            SVNWCAccess sVNWCAccess = sVNAdminArea.getWCAccess();
            sVNWCAccess.walkEntries(file, sVNPropertiesManager$2, false, sVNDepth);
        } else {
            sVNPropertiesManager$2.handleEntry(file, sVNEntry);
        }
        return sVNHashMap;
    }

    public static void recordWCMergeInfo(File file, Map map, SVNWCAccess sVNWCAccess) {
        SVNPropertyValue sVNPropertyValue = null;
        if (map != null) {
            sVNPropertyValue = SVNPropertyValue.create(SVNMergeInfoUtil.formatMergeInfoToString(map, null));
        }
        SVNPropertiesManager.setProperty(sVNWCAccess, file, "svn:mergeinfo", sVNPropertyValue, true);
    }

    public static Map parseMergeInfo(File file, SVNEntry sVNEntry, boolean bl2) {
        Map map = SVNPropertiesManager.getWorkingCopyPropertyValues(file, sVNEntry, "svn:mergeinfo", SVNDepth.EMPTY, bl2);
        Map map2 = null;
        SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)map.get(file);
        if (sVNPropertyValue != null && sVNPropertyValue.getString() != null) {
            map2 = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(sVNPropertyValue.getString()), map2);
        }
        return map2;
    }

    public static boolean isValidPropertyName(String string) {
        if (string == null || string.length() == 0) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property name is empty");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (!Character.isLetter(string.charAt(0)) && string.charAt(0) != ':' && string.charAt(0) != '_') {
            return false;
        }
        for (int i2 = 1; i2 < string.length(); ++i2) {
            if (Character.isLetterOrDigit(string.charAt(i2)) || string.charAt(i2) == '-' || string.charAt(i2) == '.' || string.charAt(i2) == ':' || string.charAt(i2) == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean propNeedsTranslation(String string) {
        return SVNProperty.isSVNProperty(string);
    }

    private static Collection getKeywords(String string) {
        SVNHashSet sVNHashSet = new SVNHashSet();
        if (string == null || "".equals(string.trim())) {
            return sVNHashSet;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            sVNHashSet.add(stringTokenizer.nextToken().toLowerCase());
        }
        return sVNHashSet;
    }

    private static boolean contains(String[] stringArray, String string) {
        for (int i2 = 0; string != null && i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static SVNPropertyValue validatePropertyValue(Object object, SVNNodeKind sVNNodeKind, String string, SVNPropertyValue sVNPropertyValue, boolean bl2, ISVNOptions iSVNOptions, ISVNFileContentFetcher iSVNFileContentFetcher) {
        Object object2;
        if (sVNPropertyValue == null) {
            return sVNPropertyValue;
        }
        SVNPropertiesManager.validatePropertyName(object, string, sVNNodeKind);
        if (SVNProperty.isSVNProperty(string) && sVNPropertyValue.isString()) {
            object2 = sVNPropertyValue.getString();
            object2 = object2.replaceAll("\r\n", "\n");
            object2 = object2.replace('\r', '\n');
            sVNPropertyValue = SVNPropertyValue.create((String)object2);
        }
        if (!bl2 && "svn:eol-style".equals(string)) {
            if (SVNTranslator.getEOL((sVNPropertyValue = SVNPropertyValue.create(sVNPropertyValue.getString().trim())).getString(), iSVNOptions) == null) {
                object2 = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL, "Unrecognized line ending style for ''{0}''", object);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.DEFAULT);
            }
            SVNPropertiesManager.validateEOLProperty(object, iSVNFileContentFetcher);
        } else if (!bl2 && "svnkit:charset".equals(string)) {
            sVNPropertyValue = SVNPropertyValue.create(sVNPropertyValue.getString().trim());
            try {
                SVNTranslator.getCharset(sVNPropertyValue.getString(), null, object, iSVNOptions);
            }
            catch (SVNException sVNException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Charset ''{0}'' is not supported on this computer", (Object)sVNPropertyValue.getString());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            }
            if (iSVNFileContentFetcher != null && iSVNFileContentFetcher.fileIsBinary()) {
                object2 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has binary mime type property", object);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.DEFAULT);
            }
        } else if (!bl2 && "svn:mime-type".equals(string)) {
            sVNPropertyValue = SVNPropertyValue.create(sVNPropertyValue.getString().trim());
            SVNPropertiesManager.validateMimeType(sVNPropertyValue.getString());
            if (SVNProperty.isBinaryMimeType(sVNPropertyValue.getString()) && iSVNFileContentFetcher != null && iSVNFileContentFetcher.getProperty("svn:eol-style") != null) {
                object2 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has svn:eol-style property set and thus cannot have binary mime type", object);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.DEFAULT);
            }
        } else if ("svn:ignore".equals(string) || "svn:global-ignores".equals(string) || "svn:externals".equals(string)) {
            List list;
            if (!sVNPropertyValue.getString().endsWith("\n")) {
                sVNPropertyValue = SVNPropertyValue.create(sVNPropertyValue.getString().concat("\n"));
            }
            if ("svn:externals".equals(string) && (list = SVNExternal.findTargetDuplications(object2 = SVNExternal.parseExternals(object, sVNPropertyValue.getString()))) != null && list.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                if (list.size() > 1) {
                    stringBuilder.append(" (").append(list.size()).append(" more duplicate targets found)");
                }
                String string2 = object instanceof File ? ((File)object).getAbsolutePath() : new File(object.toString()).getAbsolutePath();
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_DUPLICATE_EXTERNALS_TARGET, "Invalid {0} property on ''{1}'': target ''{2}'' appears more than once{3}", "svn:externals", string2, list.get(0), stringBuilder.toString());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        } else if ("svn:keywords".equals(string)) {
            sVNPropertyValue = SVNPropertyValue.create(sVNPropertyValue.getString().trim());
        } else if ("svn:executable".equals(string) || "svn:special".equals(string) || "svn:needs-lock".equals(string)) {
            sVNPropertyValue = SVNPropertyValue.create("*");
        } else if ("svn:mergeinfo".equals(string)) {
            object2 = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(sVNPropertyValue.getString()), null);
            if (sVNNodeKind != SVNNodeKind.DIR && SVNMergeInfoUtil.isNonInheritable((Map)object2)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Cannot set non-inheritable mergeinfo on a non-directory (''{0}'')", object);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            if (object2 != null) {
                sVNPropertyValue = SVNPropertyValue.create(SVNMergeInfoUtil.formatMergeInfoToString((Map)object2, null));
            }
        }
        return sVNPropertyValue;
    }

    private static boolean hasSVNProperties(SVNProperties sVNProperties) {
        if (sVNProperties == null) {
            return false;
        }
        for (String string : sVNProperties.nameSet()) {
            if (!SVNProperty.isSVNProperty(string)) continue;
            return true;
        }
        return false;
    }

    private static void validatePropertyName(Object object, String string, SVNNodeKind sVNNodeKind) {
        SVNErrorMessage sVNErrorMessage = null;
        if (sVNNodeKind == SVNNodeKind.DIR) {
            if (NOT_ALLOWED_FOR_DIR.contains(string)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot set ''{0}'' on a directory (''{1}'')", string, object);
            }
        } else if (sVNNodeKind == SVNNodeKind.FILE) {
            if (NOT_ALLOWED_FOR_FILE.contains(string)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot set ''{0}'' on a file (''{1}'')", string, object);
            }
        } else {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "''{0}'' is not a file or directory", object);
        }
        if (sVNErrorMessage != null) {
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
    }

    public static void validateMimeType(String string) {
        String string2 = string.indexOf(59) >= 0 ? string.substring(0, string.indexOf(59)) : string;
        SVNErrorMessage sVNErrorMessage = null;
        if (string2.length() == 0) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_MIME_TYPE, "MIME type ''{0}'' has empty media type", (Object)string);
        } else if (string2.indexOf(47) < 0) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_MIME_TYPE, "MIME type ''{0}'' does not contain ''/''", (Object)string);
        } else if (!Character.isLetterOrDigit(string2.charAt(string2.length() - 1))) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_MIME_TYPE, "MIME type ''{0}'' ends with non-alphanumeric character", (Object)string);
        }
        if (sVNErrorMessage != null) {
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
    }

    public static String determineEncodingByMimeType(String string) {
        if (string == null) {
            return null;
        }
        if (!SVNProperty.isTextMimeType(string)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!(string2 = string2.trim()).startsWith("charset") || !(string2 = string2.substring("charset".length()).trim()).startsWith("=")) continue;
            return string2.substring("=".length()).trim();
        }
        return null;
    }

    public static void validateEOLProperty(Object object, ISVNFileContentFetcher iSVNFileContentFetcher) {
        if (iSVNFileContentFetcher == null) {
            return;
        }
        SVNPropertyValue sVNPropertyValue = iSVNFileContentFetcher.getProperty("svnkit:charset");
        OutputStream outputStream = SVNTranslator.getTranslatingOutputStream(SVNFileUtil.DUMMY_OUT, SVNPropertyValue.getPropertyAsString(sVNPropertyValue), new byte[0], false, null, false);
        try {
            iSVNFileContentFetcher.fetchFileContent(outputStream);
        }
        catch (SVNException sVNException) {
            SVNPropertiesManager.handleInconsistentEOL(sVNException, object);
            throw sVNException;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOExceptionWrapper iOExceptionWrapper) {
                SVNPropertiesManager.handleInconsistentEOL(iOExceptionWrapper.getOriginalException(), object);
                throw iOExceptionWrapper.getOriginalException();
            }
            catch (IOException iOException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException), SVNLogType.DEFAULT);
            }
        }
        if (iSVNFileContentFetcher.fileIsBinary()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has binary mime type property", object);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    private static void handleInconsistentEOL(SVNException sVNException, Object object) {
        Serializable serializable;
        SVNErrorMessage sVNErrorMessage;
        for (sVNErrorMessage = sVNException.getErrorMessage(); sVNErrorMessage != null && sVNErrorMessage.getErrorCode() != SVNErrorCode.IO_INCONSISTENT_EOL; sVNErrorMessage = sVNErrorMessage.getChildErrorMessage()) {
        }
        if (sVNErrorMessage != null && sVNErrorMessage.getErrorCode() == SVNErrorCode.IO_INCONSISTENT_EOL) {
            serializable = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has inconsistent newlines", object);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.DEFAULT);
        }
        if ((serializable = sVNException.getCause()) == null) {
            return;
        }
        if (serializable instanceof SVNException) {
            SVNPropertiesManager.handleInconsistentEOL((SVNException)serializable, object);
        } else if (serializable instanceof IOExceptionWrapper) {
            IOExceptionWrapper iOExceptionWrapper = (IOExceptionWrapper)serializable;
            SVNPropertiesManager.handleInconsistentEOL(iOExceptionWrapper.getOriginalException(), object);
        }
    }

    static {
        NOT_ALLOWED_FOR_FILE.add("svn:ignore");
        NOT_ALLOWED_FOR_FILE.add("svn:externals");
        NOT_ALLOWED_FOR_FILE.add("svn:global-ignores");
        NOT_ALLOWED_FOR_FILE.add("svn:auto-props");
        NOT_ALLOWED_FOR_DIR.add("svn:executable");
        NOT_ALLOWED_FOR_DIR.add("svn:keywords");
        NOT_ALLOWED_FOR_DIR.add("svn:eol-style");
        NOT_ALLOWED_FOR_DIR.add("svnkit:charset");
        NOT_ALLOWED_FOR_DIR.add("svn:needs-lock");
        NOT_ALLOWED_FOR_DIR.add("svn:mime-type");
    }
}

