/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPath {
    private String myTarget;
    private SVNRevision myPegRevision = SVNRevision.UNDEFINED;
    private File myFile;

    public SVNPath(String string, SVNRevision sVNRevision) {
        this.myTarget = string;
        this.myPegRevision = sVNRevision;
    }

    public SVNPath(String string) {
        this(string, false);
    }

    public SVNPath(String string, boolean bl2) {
        this.myTarget = string;
        this.parsePegRevision(bl2);
        this.myTarget = SVNPathUtil.canonicalizePath(this.myTarget);
        SVNPath.assertControlChars(this.isURL() ? SVNEncodingUtil.uriDecode(this.myTarget) : this.myTarget);
    }

    public SVNPath(String string, boolean bl2, boolean bl3) {
        this.myTarget = string;
        if (bl3) {
            this.parsePegRevision(bl2);
        }
        this.myTarget = SVNPathUtil.canonicalizePath(this.myTarget);
        SVNPath.assertControlChars(this.isURL() ? SVNEncodingUtil.uriDecode(this.myTarget) : this.myTarget);
    }

    public String getTarget() {
        return this.myTarget;
    }

    public boolean isURL() {
        return SVNPathUtil.isURL(this.myTarget);
    }

    public boolean isFile() {
        return !this.isURL();
    }

    public File getFile() {
        if (this.myFile != null) {
            return this.myFile;
        }
        if (this.isFile()) {
            return new File(this.myTarget).getAbsoluteFile();
        }
        return null;
    }

    public SVNURL getURL() {
        if (this.isURL()) {
            return SVNURL.parseURIEncoded(this.myTarget);
        }
        return null;
    }

    public SVNRevision getPegRevision() {
        return this.myPegRevision;
    }

    private void parsePegRevision(boolean bl2) {
        int n2 = this.myTarget.lastIndexOf(64);
        if (n2 > 0) {
            SVNRevision sVNRevision;
            String string = this.myTarget.substring(n2 + 1);
            if (string.indexOf(47) >= 0) {
                return;
            }
            if (string.length() == 0) {
                if (bl2) {
                    this.myPegRevision = this.isURL() ? SVNRevision.HEAD : SVNRevision.BASE;
                }
                this.myTarget = this.myTarget.substring(0, n2);
                return;
            }
            if (this.isURL() && string.length() > 6 && string.toLowerCase().startsWith("%7b") && string.toLowerCase().endsWith("%7d")) {
                string = SVNEncodingUtil.uriDecode(string);
            }
            if ((sVNRevision = SVNRevision.parse(string)) != SVNRevision.UNDEFINED) {
                if (bl2) {
                    this.myPegRevision = sVNRevision;
                }
                this.myTarget = this.myTarget.substring(0, n2);
                return;
            }
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Syntax error parsing peg revision ''{0}''", (Object)this.myTarget.substring(n2 + 1));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        } else if (n2 == 0) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "''{0}'' is just a peg revision. May be try ''{0}@'' instead?", (Object)this.myTarget);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
    }

    protected static void assertControlChars(String string) {
        if (string != null) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                String string2 = Integer.toHexString(c2);
                if (string2.length() < 2) {
                    string2 = "0" + string2;
                }
                if (!SVNEncodingUtil.isASCIIControlChar(c2)) continue;
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid control character '0x" + string2 + "' in path '" + string + "'");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            }
        }
    }
}

