/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.Collections;
import java.util.Map;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNPasswordCipher$CompositePasswordCipher;
import org.tmatesoft.svn.core.internal.wc.SVNWinCryptPasswordCipher;

public abstract class SVNPasswordCipher {
    public static final String SIMPLE_CIPHER_TYPE = "simple";
    public static final String WINCRYPT_CIPHER_TYPE = "wincrypt";
    private static final SVNPasswordCipher EMPTY_CIPHER = new SVNPasswordCipher$CompositePasswordCipher(Collections.EMPTY_LIST, "simple", null);
    private static final SVNPasswordCipher SIMPLE_CIPHER = new SVNPasswordCipher$CompositePasswordCipher(Collections.EMPTY_LIST, "simple", null);
    private static final SVNPasswordCipher WINCRYPT_CIPHER = new SVNWinCryptPasswordCipher();
    private static Map ourInstances = new SVNHashMap();
    private static String ourDefaultType = "simple";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNPasswordCipher getInstance(String string) {
        if (string == null) {
            return EMPTY_CIPHER;
        }
        Map map = ourInstances;
        synchronized (map) {
            if (ourInstances.containsKey(string)) {
                return (SVNPasswordCipher)ourInstances.get(string);
            }
        }
        return EMPTY_CIPHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasCipher(String string) {
        Map map = ourInstances;
        synchronized (map) {
            return string != null && ourInstances.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultCipherType(String string) {
        Map map = ourInstances;
        synchronized (map) {
            ourDefaultType = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultCipherType() {
        Map map = ourInstances;
        synchronized (map) {
            if (ourDefaultType != null) {
                return ourDefaultType;
            }
            if (!ourInstances.isEmpty()) {
                ourDefaultType = (String)ourInstances.keySet().iterator().next();
                return ourDefaultType;
            }
        }
        return SIMPLE_CIPHER_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCipher(String string, SVNPasswordCipher sVNPasswordCipher) {
        if (string != null && sVNPasswordCipher != null) {
            Map map = ourInstances;
            synchronized (map) {
                if (ourInstances.containsKey(string)) {
                    ((SVNPasswordCipher$CompositePasswordCipher)ourInstances.get(string)).addCipher(sVNPasswordCipher);
                } else {
                    sVNPasswordCipher = new SVNPasswordCipher$CompositePasswordCipher(sVNPasswordCipher);
                    ourInstances.put(string, sVNPasswordCipher);
                }
            }
        }
    }

    protected SVNPasswordCipher() {
    }

    public abstract char[] encrypt(char[] var1);

    public abstract char[] decrypt(char[] var1);

    public abstract String getCipherType();

    static {
        ourInstances.put(SIMPLE_CIPHER_TYPE, SIMPLE_CIPHER);
        if (SVNWinCryptPasswordCipher.isEnabled()) {
            ourInstances.put(WINCRYPT_CIPHER_TYPE, WINCRYPT_CIPHER);
            ourDefaultType = WINCRYPT_CIPHER_TYPE;
        }
    }
}

