/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNGNUDiffGenerator;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNNodeEditor$DiffItem;
import org.tmatesoft.svn.core.internal.wc.SVNNodeEditor$Node;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnPropertiesDiffHandler;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNChangeEntryHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNChangedDirectoriesHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNGNUDiffGenerator;
import org.tmatesoft.svn.core.wc.admin.SVNChangeEntry;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNNodeEditor
implements ISVNEditor {
    private static final char TYPE_REPLACED = 'R';
    private SVNNodeEditor$Node myCurrentNode;
    private SVNNodeEditor$Node myRootNode;
    private FSRoot myBaseRoot;
    private FSFS myFSFS;
    private Map myFiles;
    private ISVNEventHandler myCancelHandler;
    private File myTempDirectory;

    public SVNNodeEditor(FSFS fSFS, FSRoot fSRoot, ISVNEventHandler iSVNEventHandler) {
        this.myBaseRoot = fSRoot;
        this.myFSFS = fSFS;
        this.myCancelHandler = iSVNEventHandler;
        this.myFiles = new SVNHashMap();
    }

    @Override
    public void abortEdit() {
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        this.myCurrentNode = this.addOrOpen(string, 'A', SVNNodeKind.DIR, this.myCurrentNode, string2, l2);
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        SVNNodeEditor$Node sVNNodeEditor$Node = this.addOrOpen(string, 'A', SVNNodeKind.FILE, this.myCurrentNode, string2, l2);
        this.myFiles.put(string, sVNNodeEditor$Node);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        this.myCurrentNode.myHasPropModifications = true;
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        SVNNodeEditor$Node sVNNodeEditor$Node = (SVNNodeEditor$Node)this.myFiles.get(string);
        sVNNodeEditor$Node.myHasPropModifications = true;
    }

    @Override
    public void closeDir() {
        this.myCurrentNode = this.myCurrentNode.myParent;
    }

    @Override
    public SVNCommitInfo closeEdit() {
        return null;
    }

    @Override
    public void closeFile(String string, String string2) {
        this.myFiles.remove(string);
    }

    @Override
    public void deleteEntry(String string, long l2) {
        Object object3;
        String string2 = SVNPathUtil.tail(string);
        Object object2 = null;
        if (this.myCurrentNode != null && this.myCurrentNode.myChildren != null) {
            for (Object object3 : this.myCurrentNode.myChildren) {
                if (!((SVNNodeEditor$Node)object3).myName.equals(string2)) continue;
                object2 = object3;
                break;
            }
        }
        if (object2 == null && this.myCurrentNode != null) {
            object2 = new SVNNodeEditor$Node(this);
            ((SVNNodeEditor$Node)object2).myName = string2;
            ((SVNNodeEditor$Node)object2).myParent = this.myCurrentNode;
            if (this.myCurrentNode.myChildren == null) {
                this.myCurrentNode.myChildren = new LinkedList();
            }
            this.myCurrentNode.myChildren.add(object2);
        }
        ((SVNNodeEditor$Node)object2).myAction = (char)68;
        SVNLocationEntry sVNLocationEntry = this.findRealBaseLocation((SVNNodeEditor$Node)object2);
        object3 = null;
        object3 = !SVNRevision.isValidRevisionNumber(sVNLocationEntry.getRevision()) ? this.myBaseRoot : this.myFSFS.createRevisionRoot(sVNLocationEntry.getRevision());
        SVNNodeKind sVNNodeKind = ((FSRoot)object3).checkNodeKind(sVNLocationEntry.getPath());
        if (sVNNodeKind == SVNNodeKind.NONE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' not found in filesystem", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        ((SVNNodeEditor$Node)object2).myKind = sVNNodeKind;
    }

    @Override
    public void openDir(String string, long l2) {
        this.myCurrentNode = this.addOrOpen(string, 'R', SVNNodeKind.DIR, this.myCurrentNode, null, -1L);
    }

    @Override
    public void openFile(String string, long l2) {
        SVNNodeEditor$Node sVNNodeEditor$Node = this.addOrOpen(string, 'R', SVNNodeKind.FILE, this.myCurrentNode, null, -1L);
        this.myFiles.put(string, sVNNodeEditor$Node);
    }

    @Override
    public void openRoot(long l2) {
        this.myRootNode = this.myCurrentNode = new SVNNodeEditor$Node(this);
        this.myCurrentNode.myName = "";
        this.myCurrentNode.myParent = null;
        this.myCurrentNode.myKind = SVNNodeKind.DIR;
        this.myCurrentNode.myAction = (char)82;
    }

    @Override
    public void targetRevision(long l2) {
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        SVNNodeEditor$Node sVNNodeEditor$Node = (SVNNodeEditor$Node)this.myFiles.get(string);
        sVNNodeEditor$Node.myHasTextModifications = true;
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        return null;
    }

    @Override
    public void textDeltaEnd(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(FSRoot fSRoot, long l2, ISVNGNUDiffGenerator iSVNGNUDiffGenerator, OutputStream outputStream) {
        if (this.myRootNode != null) {
            FSRevisionRoot fSRevisionRoot = fSRoot.getOwner().createRevisionRoot(l2);
            try {
                this.diffImpl(fSRoot, fSRevisionRoot, "/", "/", this.myRootNode, iSVNGNUDiffGenerator, outputStream);
            }
            finally {
                this.cleanup();
            }
        }
    }

    public void traverseTree(boolean bl2, ISVNChangeEntryHandler iSVNChangeEntryHandler) {
        if (this.myRootNode != null) {
            this.traverseChangedTreeImpl(this.myRootNode, "/", bl2, iSVNChangeEntryHandler);
        }
    }

    public void traverseChangedDirs(ISVNChangedDirectoriesHandler iSVNChangedDirectoriesHandler) {
        if (this.myRootNode != null) {
            this.traverseChangedDirsImpl(this.myRootNode, "/", iSVNChangedDirectoriesHandler);
        }
    }

    private void diffImpl(FSRoot fSRoot, FSRevisionRoot fSRevisionRoot, String string, String string2, SVNNodeEditor$Node sVNNodeEditor$Node, ISVNGNUDiffGenerator iSVNGNUDiffGenerator, OutputStream outputStream) {
        Object object;
        Object object22;
        Iterator iterator;
        if (this.myCancelHandler != null) {
            this.myCancelHandler.checkCancelled();
        }
        DefaultSVNGNUDiffGenerator defaultSVNGNUDiffGenerator = null;
        if (iSVNGNUDiffGenerator instanceof DefaultSVNGNUDiffGenerator) {
            defaultSVNGNUDiffGenerator = (DefaultSVNGNUDiffGenerator)iSVNGNUDiffGenerator;
            defaultSVNGNUDiffGenerator.setHeaderWritten(false);
            defaultSVNGNUDiffGenerator.setDiffWritten(false);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (SVNRevision.isValidRevisionNumber(sVNNodeEditor$Node.myCopyFromRevision) && sVNNodeEditor$Node.myCopyFromPath != null) {
            string2 = sVNNodeEditor$Node.myCopyFromPath;
            iSVNGNUDiffGenerator.displayHeader(3, string, string2, sVNNodeEditor$Node.myCopyFromRevision, outputStream);
            fSRevisionRoot = this.myFSFS.createRevisionRoot(sVNNodeEditor$Node.myCopyFromRevision);
            bl2 = true;
            bl3 = true;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        SVNNodeEditor$DiffItem sVNNodeEditor$DiffItem = null;
        SVNNodeEditor$DiffItem sVNNodeEditor$DiffItem2 = null;
        if (sVNNodeEditor$Node.myKind == SVNNodeKind.FILE) {
            if (sVNNodeEditor$Node.myAction == 'R' && sVNNodeEditor$Node.myHasTextModifications) {
                bl4 = true;
                sVNNodeEditor$DiffItem = this.prepareTmpFile(fSRevisionRoot, string2, iSVNGNUDiffGenerator);
                sVNNodeEditor$DiffItem2 = this.prepareTmpFile(fSRoot, string, iSVNGNUDiffGenerator);
            } else if (iSVNGNUDiffGenerator.isDiffCopied() && sVNNodeEditor$Node.myAction == 'A' && bl2) {
                if (sVNNodeEditor$Node.myHasTextModifications) {
                    bl4 = true;
                    sVNNodeEditor$DiffItem = this.prepareTmpFile(fSRevisionRoot, string2, iSVNGNUDiffGenerator);
                    sVNNodeEditor$DiffItem2 = this.prepareTmpFile(fSRoot, string, iSVNGNUDiffGenerator);
                }
            } else if (iSVNGNUDiffGenerator.isDiffAdded() && sVNNodeEditor$Node.myAction == 'A') {
                bl4 = true;
                bl5 = true;
                sVNNodeEditor$DiffItem = this.prepareTmpFile(null, string2, iSVNGNUDiffGenerator);
                sVNNodeEditor$DiffItem2 = this.prepareTmpFile(fSRoot, string, iSVNGNUDiffGenerator);
            } else if (iSVNGNUDiffGenerator.isDiffDeleted() && sVNNodeEditor$Node.myAction == 'D') {
                bl4 = true;
                sVNNodeEditor$DiffItem = this.prepareTmpFile(null, string2, iSVNGNUDiffGenerator);
                sVNNodeEditor$DiffItem2 = this.prepareTmpFile(null, string, iSVNGNUDiffGenerator);
            }
            if (!bl3 && (sVNNodeEditor$Node.myAction != 'R' || sVNNodeEditor$Node.myHasTextModifications)) {
                if (sVNNodeEditor$Node.myAction == 'A') {
                    iSVNGNUDiffGenerator.displayHeader(0, string, null, -1L, outputStream);
                } else if (sVNNodeEditor$Node.myAction == 'D') {
                    iSVNGNUDiffGenerator.displayHeader(1, string, null, -1L, outputStream);
                } else if (sVNNodeEditor$Node.myAction == 'R') {
                    iSVNGNUDiffGenerator.displayHeader(2, string, null, -1L, outputStream);
                }
                bl3 = true;
            }
        }
        SVNProperties sVNProperties = null;
        SVNProperties sVNProperties2 = null;
        String string3 = null;
        if (sVNNodeEditor$Node.myHasPropModifications && sVNNodeEditor$Node.myAction != 'D') {
            iterator = fSRoot.getRevisionNode(string);
            object22 = ((FSRevisionNode)((Object)iterator)).getProperties(fSRoot.getOwner());
            if (sVNNodeEditor$Node.myAction != 'A') {
                object = fSRevisionRoot.getRevisionNode(string2);
                sVNProperties = ((FSRevisionNode)object).getProperties(fSRevisionRoot.getOwner());
            }
            if ((sVNProperties2 = FSRepositoryUtil.getPropsDiffs(sVNProperties, (SVNProperties)object22)).size() > 0) {
                String string4 = string3 = string.startsWith("/") ? string.substring(1) : string;
            }
        }
        if (bl4) {
            boolean bl6;
            if (defaultSVNGNUDiffGenerator != null) {
                if (bl5) {
                    defaultSVNGNUDiffGenerator.setOriginalFile(null, string);
                } else {
                    defaultSVNGNUDiffGenerator.setOriginalFile(fSRevisionRoot, string2);
                }
                defaultSVNGNUDiffGenerator.setNewFile(fSRoot, string);
            }
            iterator = bl5 ? "(rev 0)" : "(rev " + fSRevisionRoot.getRevision() + ")";
            object22 = null;
            if (fSRoot instanceof FSRevisionRoot) {
                object = (FSRevisionRoot)fSRoot;
                object22 = "(rev " + ((FSRevisionRoot)object).getRevision() + ")";
            } else {
                object = (FSTransactionRoot)fSRoot;
                object22 = "(txn " + ((FSTransactionRoot)object).getTxnID() + ")";
            }
            if (iSVNGNUDiffGenerator instanceof ISvnPropertiesDiffHandler) {
                ((ISvnPropertiesDiffHandler)((Object)iSVNGNUDiffGenerator)).handlePropertiesDiff(sVNProperties, sVNProperties2);
            }
            iSVNGNUDiffGenerator.displayFileDiff(string, sVNNodeEditor$DiffItem.myTmpFile, sVNNodeEditor$DiffItem2.myTmpFile, (String)((Object)iterator), (String)object22, sVNNodeEditor$DiffItem.myMimeType, sVNNodeEditor$DiffItem2.myMimeType, outputStream);
            boolean bl7 = bl6 = defaultSVNGNUDiffGenerator != null ? defaultSVNGNUDiffGenerator.isDiffWritten() : true;
            if (!bl6 && !sVNNodeEditor$Node.myHasPropModifications && (sVNNodeEditor$Node.myAction == 'A' && iSVNGNUDiffGenerator.isDiffAdded() || sVNNodeEditor$Node.myAction == 'D' && iSVNGNUDiffGenerator.isDiffDeleted())) {
                int n2 = sVNNodeEditor$Node.myAction == 'A' ? 0 : 1;
                defaultSVNGNUDiffGenerator.setHeaderWritten(false);
                defaultSVNGNUDiffGenerator.displayHeader(n2, string, null, -1L, outputStream);
                defaultSVNGNUDiffGenerator.printHeader(outputStream);
            }
        } else if (bl3) {
            iSVNGNUDiffGenerator.displayHeader(4, string, null, -1L, outputStream);
        }
        if (sVNProperties2 != null && string3 != null) {
            iSVNGNUDiffGenerator.displayPropDiff(string3, sVNProperties, sVNProperties2, outputStream);
        }
        if (sVNNodeEditor$Node.myChildren == null || sVNNodeEditor$Node.myChildren.size() == 0) {
            return;
        }
        for (Object object22 : sVNNodeEditor$Node.myChildren) {
            String string5 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, ((SVNNodeEditor$Node)object22).myName));
            String string6 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string2, ((SVNNodeEditor$Node)object22).myName));
            this.diffImpl(fSRoot, fSRevisionRoot, string5, string6, (SVNNodeEditor$Node)object22, iSVNGNUDiffGenerator, outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNNodeEditor$DiffItem prepareTmpFile(FSRoot fSRoot, String string, ISVNDiffGenerator iSVNDiffGenerator) {
        Object object;
        Object object2;
        String string2 = null;
        if (fSRoot != null && SVNProperty.isBinaryMimeType(string2 = ((SVNProperties)(object2 = ((FSRevisionNode)(object = fSRoot.getRevisionNode(string))).getProperties(fSRoot.getOwner()))).getStringValue("svn:mime-type")) && !iSVNDiffGenerator.isForcedBinaryDiff()) {
            return new SVNNodeEditor$DiffItem(this, string2, null);
        }
        object = this.createTempFile(iSVNDiffGenerator);
        if (fSRoot != null) {
            object2 = null;
            OutputStream outputStream = null;
            try {
                object2 = fSRoot.getFileStreamForPath(new SVNDeltaCombiner(), string);
                outputStream = SVNFileUtil.openFileForWriting((File)object);
                FSRepositoryUtil.copy((InputStream)object2, outputStream, this.myCancelHandler);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile((InputStream)object2);
                SVNFileUtil.closeFile(outputStream);
                throw throwable;
            }
            SVNFileUtil.closeFile((InputStream)object2);
            SVNFileUtil.closeFile(outputStream);
        }
        return new SVNNodeEditor$DiffItem(this, string2, (File)object);
    }

    private File createTempFile(ISVNDiffGenerator iSVNDiffGenerator) {
        File file = null;
        try {
            return File.createTempFile("diff.", ".tmp", this.getTempDirectory(iSVNDiffGenerator));
        }
        catch (IOException iOException) {
            SVNFileUtil.deleteFile(file);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            return null;
        }
    }

    private File getTempDirectory(ISVNDiffGenerator iSVNDiffGenerator) {
        if (this.myTempDirectory == null || !this.myTempDirectory.exists()) {
            this.myTempDirectory = iSVNDiffGenerator.createTempDirectory();
        }
        return this.myTempDirectory;
    }

    private void cleanup() {
        if (this.myTempDirectory != null) {
            SVNFileUtil.deleteAll(this.myTempDirectory, true);
        }
    }

    private void traverseChangedDirsImpl(SVNNodeEditor$Node sVNNodeEditor$Node, String string, ISVNChangedDirectoriesHandler iSVNChangedDirectoriesHandler) {
        if (this.myCancelHandler != null) {
            this.myCancelHandler.checkCancelled();
        }
        if (sVNNodeEditor$Node == null || sVNNodeEditor$Node.myKind != SVNNodeKind.DIR) {
            return;
        }
        boolean bl2 = sVNNodeEditor$Node.myHasPropModifications;
        if (!bl2 && sVNNodeEditor$Node.myChildren != null) {
            Iterator iterator = sVNNodeEditor$Node.myChildren.iterator();
            while (iterator.hasNext() && !bl2) {
                SVNNodeEditor$Node sVNNodeEditor$Node2 = (SVNNodeEditor$Node)iterator.next();
                if (sVNNodeEditor$Node2.myKind != SVNNodeKind.FILE && !sVNNodeEditor$Node2.myHasTextModifications && sVNNodeEditor$Node2.myAction != 'A' && sVNNodeEditor$Node2.myAction != 'D') continue;
                bl2 = true;
            }
        }
        if (bl2 && iSVNChangedDirectoriesHandler != null) {
            iSVNChangedDirectoriesHandler.handleDir(string);
        }
        if (sVNNodeEditor$Node.myChildren == null || sVNNodeEditor$Node.myChildren.size() == 0) {
            return;
        }
        for (SVNNodeEditor$Node sVNNodeEditor$Node2 : sVNNodeEditor$Node.myChildren) {
            String string2 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, sVNNodeEditor$Node2.myName));
            this.traverseChangedDirsImpl(sVNNodeEditor$Node2, string2, iSVNChangedDirectoriesHandler);
        }
    }

    private void traverseChangedTreeImpl(SVNNodeEditor$Node sVNNodeEditor$Node, String string, boolean bl2, ISVNChangeEntryHandler iSVNChangeEntryHandler) {
        if (this.myCancelHandler != null) {
            this.myCancelHandler.checkCancelled();
        }
        if (sVNNodeEditor$Node == null) {
            return;
        }
        SVNChangeEntry sVNChangeEntry = null;
        if (sVNNodeEditor$Node.myAction == 'A') {
            String string2 = bl2 ? sVNNodeEditor$Node.myCopyFromPath : null;
            long l2 = bl2 ? sVNNodeEditor$Node.myCopyFromRevision : -1L;
            sVNChangeEntry = new SVNChangeEntry(string, sVNNodeEditor$Node.myKind, sVNNodeEditor$Node.myAction, string2, l2, false, false);
        } else if (sVNNodeEditor$Node.myAction == 'D') {
            sVNChangeEntry = new SVNChangeEntry(string, sVNNodeEditor$Node.myKind, sVNNodeEditor$Node.myAction, null, -1L, false, false);
        } else if (sVNNodeEditor$Node.myAction == 'R' && (sVNNodeEditor$Node.myHasPropModifications || sVNNodeEditor$Node.myHasTextModifications)) {
            sVNChangeEntry = new SVNChangeEntry(string, sVNNodeEditor$Node.myKind, 'U', null, -1L, sVNNodeEditor$Node.myHasTextModifications, sVNNodeEditor$Node.myHasPropModifications);
        }
        if (sVNChangeEntry != null && iSVNChangeEntryHandler != null) {
            iSVNChangeEntryHandler.handleEntry(sVNChangeEntry);
        }
        if (sVNNodeEditor$Node.myChildren == null || sVNNodeEditor$Node.myChildren.size() == 0) {
            return;
        }
        for (SVNNodeEditor$Node sVNNodeEditor$Node2 : sVNNodeEditor$Node.myChildren) {
            String string3 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, sVNNodeEditor$Node2.myName));
            this.traverseChangedTreeImpl(sVNNodeEditor$Node2, string3, bl2, iSVNChangeEntryHandler);
        }
    }

    private SVNLocationEntry findRealBaseLocation(SVNNodeEditor$Node sVNNodeEditor$Node) {
        if (sVNNodeEditor$Node.myAction == 'A' && sVNNodeEditor$Node.myCopyFromPath != null && SVNRevision.isValidRevisionNumber(sVNNodeEditor$Node.myCopyFromRevision)) {
            return new SVNLocationEntry(sVNNodeEditor$Node.myCopyFromRevision, sVNNodeEditor$Node.myCopyFromPath);
        }
        if (sVNNodeEditor$Node.myParent != null) {
            SVNLocationEntry sVNLocationEntry = this.findRealBaseLocation(sVNNodeEditor$Node.myParent);
            return new SVNLocationEntry(sVNLocationEntry.getRevision(), SVNPathUtil.getAbsolutePath(SVNPathUtil.append(sVNLocationEntry.getPath(), sVNNodeEditor$Node.myName)));
        }
        return new SVNLocationEntry(-1L, "/");
    }

    private SVNNodeEditor$Node addOrOpen(String string, char c2, SVNNodeKind sVNNodeKind, SVNNodeEditor$Node sVNNodeEditor$Node, String string2, long l2) {
        if (sVNNodeEditor$Node.myChildren == null) {
            sVNNodeEditor$Node.myChildren = new LinkedList();
        }
        SVNNodeEditor$Node sVNNodeEditor$Node2 = new SVNNodeEditor$Node(this);
        sVNNodeEditor$Node2.myName = SVNPathUtil.tail(string);
        sVNNodeEditor$Node2.myAction = c2;
        sVNNodeEditor$Node2.myKind = sVNNodeKind;
        sVNNodeEditor$Node2.myCopyFromPath = string2;
        sVNNodeEditor$Node2.myCopyFromRevision = l2;
        sVNNodeEditor$Node2.myParent = sVNNodeEditor$Node;
        sVNNodeEditor$Node.myChildren.add(sVNNodeEditor$Node2);
        return sVNNodeEditor$Node2;
    }
}

