/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMethodCallLogger
implements InvocationHandler {
    static Method OBJECT_TOSTRING;
    static Method OBJECT_HASHCODE;
    static Method OBJECT_EQUALS;
    private final Object myTarget;
    private final Class[] myCallSites;

    public static Object newInstance(Object object, Class[] classArray) {
        return Proxy.newProxyInstance(object.getClass().getClassLoader(), object.getClass().getInterfaces(), (InvocationHandler)new SVNMethodCallLogger(object, classArray));
    }

    public SVNMethodCallLogger(Object object, Class[] classArray) {
        this.myTarget = object;
        this.myCallSites = classArray == null ? new Class[]{} : classArray;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        if (OBJECT_TOSTRING.equals(method)) {
            return "Logger: " + this.myTarget.toString();
        }
        if (OBJECT_HASHCODE.equals(method)) {
            return this.myTarget.hashCode();
        }
        if (OBJECT_EQUALS.equals(method)) {
            return this.myTarget.equals(objectArray[0]);
        }
        Object object2 = null;
        Throwable throwable = null;
        try {
            object2 = method.invoke(this.myTarget, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw illegalAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        String string = this.createMessage(method, objectArray, object2, throwable);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, string);
        if (throwable != null) {
            throw throwable;
        }
        return object2;
    }

    private String createMessage(Method method, Object[] objectArray, Object object, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        stringBuffer.append("Invoked: ");
        stringBuffer.append('\n');
        stringBuffer.append(method);
        stringBuffer.append('\n');
        stringBuffer.append("Arguments:");
        stringBuffer.append('\n');
        Class<?>[] classArray = method.getParameterTypes();
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Class<?> clazz;
            Object object2 = objectArray[i2];
            if (classArray != null && classArray.length > i2 && (clazz = classArray[i2]) != null) {
                stringBuffer.append(this.getShortClassName(clazz));
                stringBuffer.append(" = ");
            }
            stringBuffer.append(String.valueOf(object2));
            stringBuffer.append('\n');
        }
        stringBuffer.append("Call Site:");
        stringBuffer.append('\n');
        stringBuffer.append(this.findCallSite());
        stringBuffer.append("Returned:");
        stringBuffer.append('\n');
        stringBuffer.append(String.valueOf(object));
        stringBuffer.append('\n');
        if (throwable != null) {
            stringBuffer.append("Thrown:");
            stringBuffer.append('\n');
            stringBuffer.append(throwable.getMessage());
            stringBuffer.append('\n');
            stringBuffer.append(this.generateStackTrace(throwable));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private String getShortClassName(Class clazz) {
        if (clazz == null) {
            return "null";
        }
        int n2 = clazz.getName().lastIndexOf(".");
        if (n2 >= 0 && n2 < clazz.getName().length() - 1) {
            return clazz.getName().substring(n2 + 1);
        }
        return clazz.getName();
    }

    private String findCallSite() {
        Throwable throwable = new Throwable();
        throwable = throwable.fillInStackTrace();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            if (this.myCallSites != null) {
                for (int i3 = 0; i3 < this.myCallSites.length; ++i3) {
                    Class clazz = this.myCallSites[i3];
                    if (!stackTraceElement.getClassName().equalsIgnoreCase(clazz.getName()) && stackTraceElement.getClassName().indexOf(clazz.getName()) < 0) continue;
                    stringBuffer.append(stackTraceElement.toString());
                    stringBuffer.append('\n');
                }
                continue;
            }
            stringBuffer.append(stackTraceElement);
            stringBuffer.append('\n');
        }
        if (stringBuffer.length() == 0) {
            return "[NOT DETECTED]";
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        try {
            throwable.printStackTrace(printWriter);
        }
        finally {
            SVNFileUtil.closeFile(printWriter);
        }
        try {
            return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byteArrayOutputStream.toByteArray());
        }
    }

    static {
        try {
            OBJECT_TOSTRING = Object.class.getMethod("toString", new Class[0]);
            OBJECT_HASHCODE = Object.class.getMethod("hashCode", new Class[0]);
            OBJECT_EQUALS = Object.class.getMethod("equals", Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

