/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeInfoManager {
    public Map getMergeInfo(String[] stringArray, FSRevisionRoot fSRevisionRoot, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean bl2) {
        Object object;
        if (!fSRevisionRoot.getOwner().supportsMergeInfo()) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Querying mergeinfo requires version {0} of the FSFS filesystem schema; filesystem ''{1}'' uses only version {2}", 3, fSRevisionRoot.getOwner().getDBRoot(), fSRevisionRoot.getOwner().getDBFormat());
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = this.getMergeInfoForPaths(fSRevisionRoot, stringArray, sVNMergeInfoInheritance, bl2);
        TreeMap<String, SVNMergeInfo> treeMap = new TreeMap<String, SVNMergeInfo>();
        for (String string : object.keySet()) {
            Map map = (Map)object.get(string);
            treeMap.put(string, new SVNMergeInfo(string, map));
        }
        return treeMap;
    }

    private Map getMergeInfoForPaths(FSRevisionRoot fSRevisionRoot, String[] stringArray, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean bl2) {
        TreeMap<String, Map> treeMap = new TreeMap<String, Map>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            Map map = this.getMergeInfoForPath(fSRevisionRoot, string, sVNMergeInfoInheritance);
            if (map != null) {
                treeMap.put(string, map);
            }
            if (!bl2) continue;
            this.addDescendantMergeInfo(treeMap, fSRevisionRoot, string);
        }
        return treeMap;
    }

    private void addDescendantMergeInfo(Map map, FSRevisionRoot fSRevisionRoot, String string) {
        FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string);
        if (fSRevisionNode.hasDescendantsWithMergeInfo()) {
            this.crawlDirectoryForMergeInfo(fSRevisionRoot, string, fSRevisionNode, map);
        }
    }

    private Map crawlDirectoryForMergeInfo(FSRevisionRoot fSRevisionRoot, String string, FSRevisionNode fSRevisionNode, Map map) {
        FSFS fSFS = fSRevisionRoot.getOwner();
        Map map2 = fSRevisionNode.getDirEntries(fSFS);
        for (FSEntry fSEntry : map2.values()) {
            String string2 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, fSEntry.getName()));
            FSRevisionNode fSRevisionNode2 = fSRevisionRoot.getRevisionNode(string2);
            if (fSRevisionNode2.hasMergeInfo()) {
                Object object;
                SVNProperties sVNProperties = fSRevisionNode2.getProperties(fSFS);
                String string3 = sVNProperties.getStringValue("svn:mergeinfo");
                if (string3 == null) {
                    object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Node-revision #''{0}'' claims to have mergeinfo but doesn''t", (Object)fSEntry.getId());
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
                }
                object = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string3), null);
                map.put(string2, object);
            }
            if (!fSRevisionNode2.hasDescendantsWithMergeInfo()) continue;
            this.crawlDirectoryForMergeInfo(fSRevisionRoot, string2, fSRevisionNode2, map);
        }
        return map;
    }

    private Map getMergeInfoForPath(FSRevisionRoot fSRevisionRoot, String string, SVNMergeInfoInheritance sVNMergeInfoInheritance) {
        Object object;
        boolean bl2;
        Map map = null;
        string = SVNPathUtil.canonicalizeAbsolutePath(string);
        FSParentPath fSParentPath = fSRevisionRoot.openPath(string, true, true);
        if (sVNMergeInfoInheritance == SVNMergeInfoInheritance.NEAREST_ANCESTOR && fSParentPath.getParent() == null) {
            return map;
        }
        FSParentPath fSParentPath2 = null;
        fSParentPath2 = sVNMergeInfoInheritance == SVNMergeInfoInheritance.NEAREST_ANCESTOR ? fSParentPath.getParent() : fSParentPath;
        FSFS fSFS = fSRevisionRoot.getOwner();
        while (!(bl2 = fSParentPath2.getRevNode().hasMergeInfo())) {
            if (sVNMergeInfoInheritance == SVNMergeInfoInheritance.EXPLICIT) {
                return map;
            }
            if ((fSParentPath2 = fSParentPath2.getParent()) != null) continue;
            return map;
        }
        SVNProperties sVNProperties = fSParentPath2.getRevNode().getProperties(fSFS);
        String string2 = sVNProperties.getStringValue("svn:mergeinfo");
        if (string2 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Node-revision ''{0}@{1}'' claims to have mergeinfo but doesn''t", fSParentPath2.getAbsPath(), fSRevisionRoot.getRevision());
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (fSParentPath2 == fSParentPath) {
            return SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string2), null);
        }
        object = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string2), null);
        object = SVNMergeInfoUtil.getInheritableMergeInfo((Map)object, null, -1L, -1L);
        map = this.appendToMergedFroms((Map)object, fSParentPath.getRelativePath(fSParentPath2));
        return map;
    }

    private Map appendToMergedFroms(Map map, String string) {
        TreeMap<String, SVNMergeRangeList> treeMap = new TreeMap<String, SVNMergeRangeList>();
        for (String string2 : map.keySet()) {
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string2);
            treeMap.put(SVNPathUtil.append(string2, string), sVNMergeRangeList.dup());
        }
        return treeMap;
    }
}

