/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.ISVNMergeStrategy;
import org.tmatesoft.svn.core.internal.wc.ISVNReusableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeCallback;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$1;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$2;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$3;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$CopyFromReceiver;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$LogHandlerFilter;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$MergeInfoFetcher;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$MergePath;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$MergeSource;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$NoopLogHandler;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$SubTreeMergeInfoHandler;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteDiffEditor;
import org.tmatesoft.svn.core.internal.wc.SVNRevisionStatus;
import org.tmatesoft.svn.core.internal.wc.SVNStatusUtil;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate$SVNRepositoryLocation;
import org.tmatesoft.svn.core.internal.wc16.SVNDiffClient16;
import org.tmatesoft.svn.core.internal.wc16.SVNLogClient16;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNMergeDriver
extends SVNBasicDelegate
implements ISVNMergeStrategy {
    protected boolean myAreSourcesAncestral;
    protected boolean myIsSameRepository;
    protected boolean myIsDryRun;
    protected boolean myIsRecordOnly;
    protected boolean myIsForce;
    protected boolean myIsTargetMissingChild;
    protected boolean myHasExistingMergeInfo;
    protected boolean myIsIgnoreAncestry;
    protected boolean myIsSingleFileMerge;
    protected boolean myIsMergeInfoCapable;
    protected boolean myIsReIntegrateMerge;
    protected boolean myIsAddNecessitatedMerge;
    protected int myOperativeNotificationsNumber;
    protected int myNotificationsNumber;
    protected int myCurrentAncestorIndex;
    protected Map myConflictedPaths;
    protected Map myDryRunDeletions;
    protected SVNURL myURL;
    protected File myTarget;
    private List myMergedPaths;
    private List mySkippedPaths;
    private List myChildrenWithMergeInfo;
    private List myAddedPaths;
    protected SVNWCAccess myWCAccess;
    protected SVNRepository myRepository1;
    protected SVNRepository myRepository2;
    private SVNLogClient16 myLogClient;
    private List myPathsWithNewMergeInfo;
    private LinkedList myPathsWithDeletedMergeInfo;
    private SVNMergeDriver$MergeSource myCurrentMergeSource;
    private SVNMergeRangeList myImplicitSrcGap;

    public SVNMergeDriver(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    protected SVNMergeDriver(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public abstract SVNDiffOptions getMergeOptions();

    public void getLogMergedMergeInfo(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            sVNDiffClient16.doGetLogMergedMergeInfo(file, sVNRevision, sVNURL, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
        }
    }

    public void getLogMergedMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            sVNDiffClient16.doGetLogMergedMergeInfo(sVNURL, sVNRevision, sVNURL2, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
        }
    }

    public void getLogMergedMergeInfo(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            sVNDiffClient16.doGetLogMergedMergeInfo(file, sVNRevision, file2, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
        }
    }

    public void getLogMergedMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            sVNDiffClient16.doGetLogMergedMergeInfo(sVNURL, sVNRevision, file, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
        }
    }

    public void getLogEligibleMergeInfo(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            sVNDiffClient16.doGetLogEligibleMergeInfo(file, sVNRevision, sVNURL, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
        }
    }

    public void getLogEligibleMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            sVNDiffClient16.doGetLogEligibleMergeInfo(sVNURL, sVNRevision, sVNURL2, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
        }
    }

    public void getLogEligibleMergeInfo(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            sVNDiffClient16.doGetLogEligibleMergeInfo(file, sVNRevision, file2, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
        }
    }

    public void getLogEligibleMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            sVNDiffClient16.doGetLogEligibleMergeInfo(sVNURL, sVNRevision, file, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
        }
    }

    public Map getMergedMergeInfo(File file, SVNRevision sVNRevision) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            return sVNDiffClient16.doGetMergedMergeInfo(file, sVNRevision);
        }
        return null;
    }

    public Map getMergedMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            return sVNDiffClient16.doGetMergedMergeInfo(sVNURL, sVNRevision);
        }
        return null;
    }

    public Collection suggestMergeSources(File file, SVNRevision sVNRevision) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            return sVNDiffClient16.doSuggestMergeSources(file, sVNRevision);
        }
        return null;
    }

    public Collection suggestMergeSources(SVNURL sVNURL, SVNRevision sVNRevision) {
        if (this instanceof SVNDiffClient16) {
            SVNDiffClient16 sVNDiffClient16 = (SVNDiffClient16)this;
            return sVNDiffClient16.doSuggestMergeSources(sVNURL, sVNRevision);
        }
        return null;
    }

    @Override
    public void handleEvent(SVNEvent sVNEvent, double d2) {
        boolean bl2 = false;
        if (this.isOperativeNotification(sVNEvent)) {
            ++this.myOperativeNotificationsNumber;
            bl2 = true;
        }
        if (this.myAreSourcesAncestral) {
            Comparable comparable;
            Object object;
            ++this.myNotificationsNumber;
            if (!this.myIsSingleFileMerge && bl2) {
                int n2;
                object = null;
                if (this.myChildrenWithMergeInfo != null) {
                    object = this.myChildrenWithMergeInfo.toArray();
                }
                if ((n2 = this.findNearestAncestor((Object[])object, sVNEvent.getAction() != SVNEventAction.UPDATE_DELETE, sVNEvent.getFile())) != this.myCurrentAncestorIndex) {
                    comparable = (SVNMergeDriver$MergePath)object[n2];
                    this.myCurrentAncestorIndex = n2;
                    if (!comparable.myIsAbsent && !comparable.myRemainingRanges.isEmpty()) {
                        SVNMergeRange[] sVNMergeRangeArray = comparable.myRemainingRanges.getRanges();
                        SVNEvent sVNEvent2 = SVNEventFactory.createSVNEvent(comparable.myPath, SVNNodeKind.UNKNOWN, null, -1L, this.myIsSameRepository ? SVNEventAction.MERGE_BEGIN : SVNEventAction.FOREIGN_MERGE_BEGIN, null, null, sVNMergeRangeArray[0]);
                        super.handleEvent(sVNEvent2, -1.0);
                    }
                }
            }
            if (sVNEvent.getContentsStatus() == SVNStatusType.MERGED || sVNEvent.getContentsStatus() == SVNStatusType.CHANGED || sVNEvent.getPropertiesStatus() == SVNStatusType.MERGED || sVNEvent.getPropertiesStatus() == SVNStatusType.CHANGED || sVNEvent.getAction() == SVNEventAction.UPDATE_ADD) {
                object = sVNEvent.getFile();
                if (this.myMergedPaths == null) {
                    this.myMergedPaths = new LinkedList();
                }
                this.myMergedPaths.add(object);
            }
            if (sVNEvent.getAction() == SVNEventAction.SKIP) {
                object = sVNEvent.getFile();
                if (this.mySkippedPaths == null) {
                    this.mySkippedPaths = new LinkedList();
                }
                this.mySkippedPaths.add(object);
            } else if (sVNEvent.getAction() == SVNEventAction.UPDATE_ADD) {
                boolean bl3 = false;
                File file = sVNEvent.getFile();
                if (this.myAddedPaths == null) {
                    bl3 = true;
                    this.myAddedPaths = new LinkedList();
                } else {
                    comparable = file.getParentFile();
                    boolean bl4 = bl3 = !this.myAddedPaths.contains(comparable);
                }
                if (bl3) {
                    this.myAddedPaths.add(file);
                }
            }
        } else if (!this.myIsSingleFileMerge && this.myOperativeNotificationsNumber == 1 && bl2) {
            SVNEvent sVNEvent3 = SVNEventFactory.createSVNEvent(this.myTarget, SVNNodeKind.UNKNOWN, null, -1L, this.myIsSameRepository ? SVNEventAction.MERGE_BEGIN : SVNEventAction.FOREIGN_MERGE_BEGIN, null, null, null);
            super.handleEvent(sVNEvent3, -1.0);
        }
        super.handleEvent(sVNEvent, d2);
    }

    @Override
    public void checkCancelled() {
        super.checkCancelled();
    }

    protected SVNLocationEntry getCopySource(File file, SVNURL sVNURL, SVNRevision sVNRevision) {
        long[] lArray = new long[]{-1L};
        SVNRepository sVNRepository = this.createRepository(sVNURL, file, null, sVNRevision, sVNRevision, lArray);
        SVNLocationEntry sVNLocationEntry = null;
        String string = this.getPathRelativeToRoot(file, sVNURL, null, null, sVNRepository);
        SVNMergeDriver$CopyFromReceiver sVNMergeDriver$CopyFromReceiver = new SVNMergeDriver$CopyFromReceiver(string);
        try {
            sVNRepository.log(new String[]{""}, lArray[0], 1L, true, true, 0L, false, new String[0], sVNMergeDriver$CopyFromReceiver);
            sVNLocationEntry = sVNMergeDriver$CopyFromReceiver.getCopyFromLocation();
        }
        catch (SVNException sVNException) {
            SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
            if (sVNErrorCode == SVNErrorCode.FS_NOT_FOUND || sVNErrorCode == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
                return new SVNLocationEntry(-1L, null);
            }
            throw sVNException;
        }
        return sVNLocationEntry == null ? new SVNLocationEntry(-1L, null) : sVNLocationEntry;
    }

    protected void getLogsForMergeInfoRangeList(SVNURL sVNURL, String[] stringArray, SVNMergeRangeList sVNMergeRangeList, boolean bl2, String[] stringArray2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        if (sVNMergeRangeList.isEmpty()) {
            return;
        }
        Object[] objectArray = sVNMergeRangeList.getRanges();
        Arrays.sort(objectArray);
        Object object = objectArray[objectArray.length - 1];
        SVNRevision sVNRevision = SVNRevision.create(((SVNMergeRange)object).getEndRevision());
        Object object2 = objectArray[0];
        SVNRevision sVNRevision2 = SVNRevision.create(((SVNMergeRange)object2).getStartRevision());
        SVNMergeDriver$LogHandlerFilter sVNMergeDriver$LogHandlerFilter = new SVNMergeDriver$LogHandlerFilter(this, iSVNLogEntryHandler, sVNMergeRangeList);
        SVNLogClient16 sVNLogClient16 = this.getLogClient();
        sVNLogClient16.doLog(sVNURL, stringArray, sVNRevision, sVNRevision2, sVNRevision, false, bl2, false, 0L, stringArray2, sVNMergeDriver$LogHandlerFilter);
        this.checkCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getMergeInfo(File file, SVNRevision sVNRevision, SVNURL[] sVNURLArray) {
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            SVNAdminArea sVNAdminArea = sVNWCAccess.probeOpen(file, false, 0);
            SVNEntry sVNEntry = sVNWCAccess.getVersionedEntry(file, false);
            long[] lArray = new long[]{-1L};
            SVNURL sVNURL = this.getEntryLocation(file, sVNEntry, lArray, SVNRevision.WORKING);
            SVNRepository sVNRepository = null;
            try {
                sVNRepository = this.createRepository(sVNURL, null, null, false);
                sVNRepository.assertServerIsMergeInfoCapable(file.toString());
            }
            finally {
                sVNRepository.closeSession();
            }
            SVNURL sVNURL2 = this.getReposRoot(file, null, sVNRevision, sVNAdminArea, sVNWCAccess);
            if (sVNURLArray != null && sVNURLArray.length > 0) {
                sVNURLArray[0] = sVNURL2;
            }
            boolean[] blArray = new boolean[]{false};
            Map map = this.getWCOrRepositoryMergeInfo(file, sVNEntry, SVNMergeInfoInheritance.INHERITED, blArray, false, null);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL[] sVNURLArray) {
        SVNRepository sVNRepository = null;
        try {
            String string;
            sVNRepository = this.createRepository(sVNURL, null, null, true);
            long l2 = this.getRevisionNumber(sVNRevision, sVNRepository, null);
            SVNURL sVNURL2 = sVNRepository.getRepositoryRoot(true);
            if (sVNURLArray != null && sVNURLArray.length > 0) {
                sVNURLArray[0] = sVNURL2;
            }
            if ((string = this.getPathRelativeToSession(sVNURL, null, sVNRepository)) == null) {
                sVNRepository.setLocation(sVNURL, false);
                string = "";
            }
            Map map = this.getReposMergeInfo(sVNRepository, string, l2, SVNMergeInfoInheritance.INHERITED, false);
            return map;
        }
        finally {
            if (sVNRepository != null) {
                sVNRepository.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPeggedMerge(SVNURL sVNURL, File file, Collection collection, SVNRevision sVNRevision, File file2, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.myWCAccess = this.createWCAccess();
        file2 = file2.getAbsoluteFile();
        try {
            Object object;
            SVNURL sVNURL2;
            SVNAdminArea sVNAdminArea = this.myWCAccess.probeOpen(file2, !bl2, -1);
            SVNEntry sVNEntry = this.myWCAccess.getVersionedEntry(file2, false);
            SVNURL sVNURL3 = sVNURL2 = sVNURL == null ? this.getURL(file) : sVNURL;
            if (sVNURL2 == null) {
                object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object = this.getReposRoot(file2, null, SVNRevision.WORKING, sVNAdminArea, this.myWCAccess);
            List list = null;
            SVNRepository sVNRepository = null;
            SVNURL sVNURL4 = null;
            try {
                sVNRepository = this.createRepository(sVNURL2, null, null, true);
                sVNURL4 = sVNRepository.getRepositoryRoot(true);
                list = this.normalizeMergeSources(file, sVNURL2, sVNURL4, sVNRevision, collection, sVNRepository);
            }
            finally {
                sVNRepository.closeSession();
            }
            this.doMerge(null, list, file2, sVNEntry, sVNAdminArea, true, true, ((SVNURL)object).equals(sVNURL4), bl4, bl3, bl2, bl5, false, sVNDepth);
        }
        finally {
            this.myWCAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runMerge(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Object object;
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        object = null;
        SVNRepository sVNRepository = null;
        this.myWCAccess = this.createWCAccess();
        file = file.getAbsoluteFile();
        try {
            void var28_32;
            boolean bl6;
            boolean bl7;
            boolean bl8;
            SVNEntry sVNEntry;
            SVNAdminArea sVNAdminArea;
            block18: {
                long l2;
                long l3;
                block19: {
                    sVNAdminArea = this.myWCAccess.probeOpen(file, !bl2, -1);
                    sVNEntry = this.myWCAccess.getVersionedEntry(file, false);
                    SVNURL sVNURL3 = this.getReposRoot(file, null, SVNRevision.WORKING, sVNAdminArea, this.myWCAccess);
                    long[] lArray = new long[]{-1L};
                    object = this.createRepository(sVNURL, null, null, false);
                    SVNURL sVNURL4 = ((SVNRepository)object).getRepositoryRoot(true);
                    l3 = this.getRevisionNumber(sVNRevision, lArray, (SVNRepository)object, null);
                    sVNRepository = this.createRepository(sVNURL2, null, null, false);
                    l2 = this.getRevisionNumber(sVNRevision2, lArray, sVNRepository, null);
                    bl8 = sVNURL4.equals(sVNURL3);
                    String string = null;
                    long l4 = -1L;
                    if (!bl4) {
                        SVNLocationEntry sVNLocationEntry = this.getYoungestCommonAncestor(null, sVNURL, l3, null, sVNURL2, l2);
                        string = sVNLocationEntry.getPath();
                        l4 = sVNLocationEntry.getRevision();
                    }
                    bl7 = false;
                    bl6 = false;
                    Object var28_27 = null;
                    if (string == null || !SVNRevision.isValidRevisionNumber(l4)) break block19;
                    SVNRevisionRange sVNRevisionRange = null;
                    LinkedList<SVNRevisionRange> linkedList = new LinkedList<SVNRevisionRange>();
                    bl7 = true;
                    SVNURL sVNURL5 = sVNURL4.appendPath(string, false);
                    if (sVNURL5.equals(sVNURL2) && l4 == l2) {
                        bl6 = true;
                        SVNRevision sVNRevision3 = SVNRevision.create(l3);
                        SVNRevision sVNRevision4 = SVNRevision.create(l4);
                        sVNRevisionRange = new SVNRevisionRange(sVNRevision3, sVNRevision4);
                        linkedList.add(sVNRevisionRange);
                        List list = this.normalizeMergeSources(null, sVNURL, sVNURL4, sVNRevision3, linkedList, (SVNRepository)object);
                        break block18;
                    } else if (sVNURL5.equals(sVNURL) && l4 == l3) {
                        bl6 = true;
                        SVNRevision sVNRevision5 = SVNRevision.create(l4);
                        SVNRevision sVNRevision6 = SVNRevision.create(l2);
                        sVNRevisionRange = new SVNRevisionRange(sVNRevision5, sVNRevision6);
                        linkedList.add(sVNRevisionRange);
                        List list = this.normalizeMergeSources(null, sVNURL2, sVNURL4, sVNRevision6, linkedList, sVNRepository);
                        break block18;
                    } else {
                        this.mergeCousinsAndSupplementMergeInfo(file, sVNEntry, sVNAdminArea, (SVNRepository)object, sVNRepository, sVNURL, l3, sVNURL2, l2, l4, sVNURL4, sVNURL3, sVNDepth, bl4, bl3, bl5, bl2);
                        return;
                    }
                }
                SVNMergeDriver$MergeSource sVNMergeDriver$MergeSource = new SVNMergeDriver$MergeSource(this);
                SVNMergeDriver$MergeSource.access$002(sVNMergeDriver$MergeSource, sVNURL);
                SVNMergeDriver$MergeSource.access$102(sVNMergeDriver$MergeSource, sVNURL2);
                SVNMergeDriver$MergeSource.access$202(sVNMergeDriver$MergeSource, l3);
                SVNMergeDriver$MergeSource.access$302(sVNMergeDriver$MergeSource, l2);
                LinkedList<SVNMergeDriver$MergeSource> linkedList = new LinkedList<SVNMergeDriver$MergeSource>();
                linkedList.add(sVNMergeDriver$MergeSource);
            }
            ((SVNRepository)object).closeSession();
            sVNRepository.closeSession();
            this.doMerge(null, (List)var28_32, file, sVNEntry, sVNAdminArea, bl6, bl7, bl8, bl4, bl3, bl2, bl5, false, sVNDepth);
            return;
        }
        finally {
            if (object != null) {
                ((SVNRepository)object).closeSession();
            }
            if (sVNRepository != null) {
                sVNRepository.closeSession();
            }
            try {
                this.myWCAccess.close();
            }
            catch (SVNException sVNException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runMergeReintegrate(SVNURL sVNURL, File file, SVNRevision sVNRevision, File file2, boolean bl2) {
        this.myWCAccess = this.createWCAccess();
        file2 = file2.getAbsoluteFile();
        try {
            Object object;
            SVNURL sVNURL2;
            SVNAdminArea sVNAdminArea = this.myWCAccess.probeOpen(file2, !bl2, -1);
            SVNEntry sVNEntry = this.myWCAccess.getVersionedEntry(file2, false);
            SVNURL sVNURL3 = sVNURL2 = sVNURL == null ? this.getURL(file) : sVNURL;
            if (sVNURL2 == null) {
                object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object = this.getReposRoot(file2, null, SVNRevision.WORKING, sVNAdminArea, this.myWCAccess);
            SVNURL sVNURL4 = this.getReposRoot(null, sVNURL2, sVNRevision, null, null);
            SVNRepository sVNRepository = null;
            SVNRepository sVNRepository2 = null;
            try {
                Object object2;
                Object object3;
                Object object4;
                sVNRepository = this.createRepository(sVNURL2, null, true);
                sVNURL4 = sVNRepository.getRepositoryRoot(true);
                sVNRepository2 = this.createRepository(sVNEntry.getSVNURL(), null, null, false);
                if (!((SVNURL)object).equals(sVNURL4)) {
                    object4 = file;
                    if (object4 == null) {
                        object4 = sVNURL;
                    }
                    object3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "''{0}'' must be from the same repository as ''{1}''", object4, file2);
                    SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
                }
                this.ensureWCReflectsRepositorySubTree(file2);
                object4 = new long[]{sVNEntry.getRevision()};
                object3 = SVNURLUtil.getCommonURLAncestor((SVNURL)object, sVNURL2).toString();
                object3 = sVNURL2.toString().substring(((String)object3).length());
                if (((String)object3).startsWith("/")) {
                    object3 = ((String)object3).substring(1);
                }
                object3 = SVNEncodingUtil.uriDecode((String)object3);
                String string = this.getPathRelativeToRoot(file2, null, (SVNURL)object, null, sVNRepository);
                if (((String)object3).length() == 0 || string.length() == 0) {
                    object2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Neither the reintegrate source nor target can be the root of the repository");
                    SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                }
                object2 = new SVNMergeDriver$SubTreeMergeInfoHandler(this, file2, (SVNURL)object);
                this.myWCAccess.walkEntries(file2, (ISVNEntryHandler)object2, true, SVNDepth.INFINITY);
                long l2 = this.getRevisionNumber(sVNRevision, sVNRepository, file);
                SVNURL[] sVNURLArray = new SVNURL[]{null};
                Map map = this.calculateLeftHandSide(sVNURLArray, (long[])object4, string, ((SVNMergeDriver$SubTreeMergeInfoHandler)object2).getSubTreesWithMergeInfoPaths(), (long)object4[0], (String)object3, sVNURL4, l2, sVNRepository, sVNRepository2);
                if (sVNURLArray[0] != null && sVNURLArray[0].equals(sVNEntry.getSVNURL())) {
                    sVNRepository2.setLocation(sVNURLArray[0], false);
                }
                SVNLocationEntry sVNLocationEntry = this.getYoungestCommonAncestor(null, sVNURL2, l2, null, sVNURLArray[0], (long)object4[0]);
                String string2 = sVNLocationEntry.getPath();
                long l3 = sVNLocationEntry.getRevision();
                if (string2 == null || !SVNRevision.isValidRevisionNumber(l3)) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "''{0}@{1}'' must be ancestrally related to ''{2}@{3}''", sVNURLArray[0], (long)object4[0], sVNURL2, l2);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                if (object4[0] > l3) {
                    try {
                        this.ensureAllMissingRangesArePhantoms(sVNRepository2, map);
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_NOT_READY_TO_MERGE) {
                            String string3 = SVNMergeInfoUtil.formatMergeInfoCatalogToString(map, "  ", "    Missing ranges: ");
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Reintegrate can only be used if revisions {0} through {1} were previously merged from {2} to the reintegrate source, but this is not the case:\n{3}", String.valueOf(l3 + 1L), String.valueOf(l2), sVNEntry.getURL(), string3);
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                        }
                        throw sVNException;
                    }
                }
                this.mergeCousinsAndSupplementMergeInfo(file2, sVNEntry, sVNAdminArea, sVNRepository2, sVNRepository, sVNURLArray[0], (long)object4[0], sVNURL2, l2, l3, sVNURL4, (SVNURL)object, SVNDepth.INFINITY, false, false, false, bl2);
            }
            finally {
                sVNRepository2.closeSession();
                sVNRepository.closeSession();
            }
        }
        finally {
            this.myWCAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMerge(Map map, List list, File file, SVNEntry sVNEntry, SVNAdminArea sVNAdminArea, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, SVNDepth sVNDepth) {
        if (bl8) {
            SVNErrorMessage sVNErrorMessage;
            if (!bl2) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Use of two URLs is not compatible with mergeinfo modification");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            }
            if (!bl4) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Merge from foreign repository is not compatible with mergeinfo modification");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            if (bl7) {
                return;
            }
        }
        if (sVNDepth == SVNDepth.UNKNOWN) {
            sVNDepth = SVNDepth.INFINITY;
        }
        this.myIsForce = bl6;
        this.myIsDryRun = bl7;
        this.myIsRecordOnly = bl8;
        this.myIsIgnoreAncestry = bl5;
        this.myIsSameRepository = bl4;
        this.myIsMergeInfoCapable = false;
        this.myAreSourcesAncestral = bl2;
        this.myIsTargetMissingChild = false;
        this.myIsSingleFileMerge = false;
        this.myTarget = file;
        this.myNotificationsNumber = 0;
        this.myOperativeNotificationsNumber = 0;
        this.myCurrentAncestorIndex = -1;
        this.myMergedPaths = null;
        this.mySkippedPaths = null;
        this.myAddedPaths = null;
        this.myChildrenWithMergeInfo = null;
        this.myPathsWithNewMergeInfo = null;
        this.myHasExistingMergeInfo = false;
        this.myIsReIntegrateMerge = bl9;
        this.myImplicitSrcGap = null;
        boolean bl10 = false;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            long l2;
            SVNMergeDriver$MergeSource sVNMergeDriver$MergeSource = (SVNMergeDriver$MergeSource)list.get(i2);
            SVNURL sVNURL = SVNMergeDriver$MergeSource.access$000(sVNMergeDriver$MergeSource);
            SVNURL sVNURL2 = SVNMergeDriver$MergeSource.access$100(sVNMergeDriver$MergeSource);
            long l3 = SVNMergeDriver$MergeSource.access$200(sVNMergeDriver$MergeSource);
            if (l3 == (l2 = SVNMergeDriver$MergeSource.access$300(sVNMergeDriver$MergeSource)) && SVNMergeDriver$MergeSource.access$000(sVNMergeDriver$MergeSource).equals(SVNMergeDriver$MergeSource.access$100(sVNMergeDriver$MergeSource))) continue;
            try {
                this.myRepository1 = this.ensureRepository(this.myRepository1, sVNURL);
                this.myRepository2 = this.ensureRepository(this.myRepository2, sVNURL2);
                this.myURL = sVNURL2;
                this.myConflictedPaths = null;
                this.myDryRunDeletions = bl7 ? new SVNHashMap() : null;
                this.myIsAddNecessitatedMerge = false;
                this.myCurrentMergeSource = sVNMergeDriver$MergeSource;
                if (!bl10) {
                    this.myIsMergeInfoCapable = this.myRepository1.hasCapability(SVNCapability.MERGE_INFO);
                    bl10 = true;
                }
                if (sVNEntry.isFile()) {
                    this.doFileMerge(map, sVNURL, l3, sVNURL2, l2, file, sVNAdminArea, bl3);
                } else if (sVNEntry.isDirectory()) {
                    this.doDirectoryMerge(map, sVNURL, l3, sVNURL2, l2, sVNEntry, sVNAdminArea, sVNDepth);
                }
                if (!bl7) {
                    this.elideMergeInfo(this.myWCAccess, file, sVNEntry, null);
                }
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.NONE, null, -1L, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.MERGE_COMPLETE, null, null, null);
                super.handleEvent(sVNEvent, -1.0);
                continue;
            }
            finally {
                if (this.myRepository1 != null) {
                    this.myRepository1.closeSession();
                }
                if (this.myRepository2 != null) {
                    this.myRepository2.closeSession();
                }
            }
        }
    }

    protected void addPathWithNewMergeInfo(File file) {
        if (this.myPathsWithNewMergeInfo == null) {
            this.myPathsWithNewMergeInfo = new LinkedList();
        }
        this.myPathsWithNewMergeInfo.add(file);
    }

    protected void addPathWithDeletedMergeInfo(File file) {
        if (this.myPathsWithDeletedMergeInfo == null) {
            this.myPathsWithDeletedMergeInfo = new LinkedList();
        }
        this.myPathsWithDeletedMergeInfo.add(file);
    }

    protected SVNRepository ensureRepository(SVNRepository sVNRepository, SVNURL sVNURL) {
        if (sVNRepository != null) {
            try {
                this.ensureSessionURL(sVNRepository, sVNURL);
                return sVNRepository;
            }
            catch (SVNException sVNException) {
                sVNRepository = null;
            }
        }
        if (sVNRepository == null) {
            sVNRepository = this.createRepository(sVNURL, null, null, false);
        }
        return sVNRepository;
    }

    @Override
    public Object[] calculateRemainingRangeList(File file, SVNEntry sVNEntry, SVNURL sVNURL, boolean[] blArray, SVNURL sVNURL2, long l2, SVNURL sVNURL3, long l3, SVNMergeRange sVNMergeRange) {
        SVNMergeRangeList sVNMergeRangeList = null;
        Map map = null;
        Map map2 = null;
        boolean bl2 = this.isHonorMergeInfo();
        if (bl2) {
            SVNMergeDriver$MergePath sVNMergeDriver$MergePath = new SVNMergeDriver$MergePath(this, file);
            this.myRepository1.setLocation(sVNEntry.getSVNURL(), false);
            Map[] mapArray = this.getFullMergeInfo(sVNEntry, true, true, blArray, SVNMergeInfoInheritance.INHERITED, this.myRepository1, file, Math.max(l2, l3), Math.min(l2, l3));
            map = mapArray[0];
            map2 = mapArray[1];
            this.myRepository1.setLocation(sVNURL2, false);
            if (!this.myIsRecordOnly) {
                this.calculateRemainingRanges(null, sVNMergeDriver$MergePath, sVNURL, sVNURL2, l2, sVNURL3, l3, map, this.myImplicitSrcGap, false, false, sVNEntry, this.myRepository1);
                sVNMergeRangeList = sVNMergeDriver$MergePath.myRemainingRanges;
            }
        }
        if (!bl2 || this.myIsRecordOnly) {
            sVNMergeRangeList = new SVNMergeRangeList(sVNMergeRange);
        }
        return new Object[]{sVNMergeRangeList, map, map2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findGapsInMergeSourceHistory(long[] lArray, String string, SVNURL sVNURL, long l2, SVNURL sVNURL2, long l3, SVNRepository sVNRepository) {
        long l4 = Math.max(l2, l3);
        long l5 = Math.min(l2, l3);
        SVNURL sVNURL3 = l3 < l2 ? sVNURL : sVNURL2;
        lArray[1] = -1L;
        lArray[0] = -1L;
        SVNRevision sVNRevision = SVNRevision.create(l4);
        SVNURL sVNURL4 = null;
        if (sVNRepository != null) {
            sVNURL4 = this.ensureSessionURL(sVNRepository, sVNURL3);
        }
        Map map = null;
        try {
            map = this.getHistoryAsMergeInfo(sVNURL3, null, sVNRevision, l4, l5, sVNRepository, null);
        }
        finally {
            if (sVNRepository != null && sVNURL4 != null) {
                sVNRepository.setLocation(sVNURL4, false);
            }
        }
        SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string);
        if (sVNMergeRangeList != null) {
            if (sVNMergeRangeList.getSize() > 1) {
                lArray[0] = Math.min(l2, l3);
                lArray[1] = sVNMergeRangeList.getRanges()[sVNMergeRangeList.getSize() - 1].getStartRevision();
            } else if (map.size() > 1) {
                SVNMergeRangeList sVNMergeRangeList2 = new SVNMergeRangeList(new SVNMergeRange[0]);
                SVNMergeRangeList sVNMergeRangeList3 = new SVNMergeRangeList(Math.min(l2, l3), Math.max(l2, l3), true);
                for (String string2 : map.keySet()) {
                    sVNMergeRangeList = (SVNMergeRangeList)map.get(string2);
                    sVNMergeRangeList2 = sVNMergeRangeList2 != null ? sVNMergeRangeList2.merge(sVNMergeRangeList) : sVNMergeRangeList;
                }
                SVNMergeRangeList sVNMergeRangeList4 = sVNMergeRangeList3.diff(sVNMergeRangeList2, false);
                if (sVNMergeRangeList4.getSize() > 0) {
                    lArray[0] = sVNMergeRangeList4.getRanges()[0].getStartRevision();
                    lArray[1] = sVNMergeRangeList4.getRanges()[0].getEndRevision();
                }
            }
        }
    }

    protected void doFileMerge(SVNURL sVNURL, long l2, SVNURL sVNURL2, long l3, File file, SVNAdminArea sVNAdminArea, boolean bl2) {
        this.doFileMerge(null, sVNURL, l2, sVNURL2, l3, file, sVNAdminArea, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFileMerge(Map map, SVNURL sVNURL, long l2, SVNURL sVNURL2, long l3, File file, SVNAdminArea sVNAdminArea, boolean bl2) {
        Object object;
        Object object2;
        SVNMergeRange[] sVNMergeRangeArray;
        Map map2;
        Map map3;
        SVNMergeRange sVNMergeRange;
        SVNEntry sVNEntry;
        SVNMergeRange sVNMergeRange2;
        String string;
        boolean[] blArray;
        boolean bl3;
        boolean bl4;
        block15: {
            bl4 = l2 > l3;
            SVNURL sVNURL3 = bl4 ? sVNURL : sVNURL2;
            boolean bl5 = this.isHonorMergeInfo();
            bl3 = this.isRecordMergeInfo();
            this.myIsSingleFileMerge = true;
            blArray = new boolean[]{false};
            boolean[] blArray2 = new boolean[]{false};
            SVNURL sVNURL4 = null;
            string = null;
            sVNMergeRange2 = null;
            this.myWCAccess.probeTry(file, true, -1);
            sVNEntry = this.myWCAccess.getVersionedEntry(file, false);
            if (bl5) {
                sVNURL4 = this.myRepository1.getRepositoryRoot(true);
                string = this.getPathRelativeToRoot(null, sVNURL3, sVNURL4, null, null);
            }
            sVNMergeRange = new SVNMergeRange(l2, l3, true);
            Object[] objectArray = this.calculateRemainingRangeList(file, sVNEntry, sVNURL4, blArray, sVNURL, l2, sVNURL2, l3, sVNMergeRange);
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)objectArray[0];
            map3 = (Map)objectArray[1];
            map2 = (Map)objectArray[1];
            sVNMergeRangeArray = sVNMergeRangeList.getRanges();
            SVNMergeCallback sVNMergeCallback = this.getMergeCallback(sVNAdminArea);
            String string2 = file.getName();
            if (this.myIsRecordOnly) break block15;
            object2 = sVNMergeRangeList;
            if (this.myAreSourcesAncestral && sVNMergeRangeList.getSize() > 1) {
                object = this.ensureSessionURL(this.myRepository1, sVNURL3);
                object2 = this.removeNoOpMergeRanges(this.myRepository1, sVNMergeRangeList);
                if (object != null) {
                    this.myRepository1.setLocation((SVNURL)object, false);
                }
            }
            object = ((SVNMergeRangeList)object2).getRanges();
            for (int i2 = 0; i2 < ((SVNMergeRange[])object).length; ++i2) {
                File file2;
                File file3;
                SVNMergeRange sVNMergeRange3;
                block14: {
                    sVNMergeRange3 = object[i2];
                    boolean bl6 = false;
                    SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.UNKNOWN, null, -1L, this.myIsSameRepository ? SVNEventAction.MERGE_BEGIN : SVNEventAction.FOREIGN_MERGE_BEGIN, null, null, this.myAreSourcesAncestral ? sVNMergeRange3 : null);
                    SVNProperties sVNProperties = new SVNProperties();
                    SVNProperties sVNProperties2 = new SVNProperties();
                    file3 = null;
                    file2 = null;
                    SVNRepository sVNRepository = this.myRepository1;
                    SVNRepository sVNRepository2 = this.myRepository2;
                    if (bl5 && !sVNURL.equals(sVNURL2)) {
                        if (!bl4 && sVNMergeRange3.getStartRevision() != l2) {
                            sVNRepository = sVNRepository2;
                        } else if (bl4 && sVNMergeRange3.getEndRevision() != l3) {
                            sVNRepository2 = sVNRepository;
                        }
                    }
                    try {
                        SVNStatusType[] sVNStatusTypeArray;
                        file3 = this.loadFile(sVNRepository, sVNMergeRange3.getStartRevision(), sVNProperties, sVNAdminArea);
                        file2 = this.loadFile(sVNRepository2, sVNMergeRange3.getEndRevision(), sVNProperties2, sVNAdminArea);
                        String string3 = sVNProperties.getStringValue("svn:mime-type");
                        String string4 = sVNProperties2.getStringValue("svn:mime-type");
                        sVNProperties = SVNMergeDriver.filterProperties(sVNProperties, true, false, false);
                        sVNProperties2 = SVNMergeDriver.filterProperties(sVNProperties2, true, false, false);
                        SVNProperties sVNProperties3 = SVNMergeDriver.computePropsDiff(sVNProperties, sVNProperties2);
                        if (!this.myIsIgnoreAncestry && !bl2) {
                            SVNStatusType sVNStatusType = ((AbstractDiffCallback)sVNMergeCallback).fileDeleted(string2, file3, file2, string3, string4, sVNProperties, blArray2);
                            bl6 = this.notifySingleFileMerge(file, blArray2[0] ? SVNEventAction.TREE_CONFLICT : SVNEventAction.UPDATE_DELETE, sVNStatusType, SVNStatusType.UNKNOWN, sVNEvent, bl6);
                            sVNStatusTypeArray = ((AbstractDiffCallback)sVNMergeCallback).fileAdded(string2, file3, file2, sVNMergeRange3.getStartRevision(), sVNMergeRange3.getEndRevision(), string3, string4, sVNProperties, sVNProperties3, blArray2);
                            bl6 = this.notifySingleFileMerge(file, blArray2[0] ? SVNEventAction.TREE_CONFLICT : SVNEventAction.UPDATE_ADD, sVNStatusTypeArray[0], sVNStatusTypeArray[1], sVNEvent, bl6);
                            break block14;
                        }
                        sVNStatusTypeArray = ((AbstractDiffCallback)sVNMergeCallback).fileChanged(string2, file3, file2, sVNMergeRange3.getStartRevision(), sVNMergeRange3.getEndRevision(), string3, string4, sVNProperties, sVNProperties3, blArray2);
                        bl6 = this.notifySingleFileMerge(file, blArray2[0] ? SVNEventAction.TREE_CONFLICT : SVNEventAction.UPDATE_UPDATE, sVNStatusTypeArray[0], sVNStatusTypeArray[1], sVNEvent, bl6);
                    }
                    catch (Throwable throwable) {
                        SVNFileUtil.deleteAll(file3, null);
                        SVNFileUtil.deleteAll(file2, null);
                        throw throwable;
                    }
                }
                SVNFileUtil.deleteAll(file3, null);
                SVNFileUtil.deleteAll(file2, null);
                if (i2 >= ((Object)object).length - 1 || this.myConflictedPaths == null || this.myConflictedPaths.isEmpty()) continue;
                sVNMergeRange2 = sVNMergeRange3;
                break;
            }
        }
        if (bl3 && sVNMergeRangeArray.length > 0 && !((SVNMergeRangeList)(object2 = this.filterNaturalHistoryFromMergeInfo(string, map2, sVNMergeRange))).isEmpty() && (this.mySkippedPaths == null || this.mySkippedPaths.isEmpty())) {
            if (blArray[0]) {
                SVNPropertiesManager.recordWCMergeInfo(file, map3, this.myWCAccess);
            }
            object = new TreeMap();
            object.put(file, object2);
            this.updateWCMergeInfo(map, file, string, sVNEntry, (Map)object, bl4);
        }
        this.sleepForTimeStamp();
        if (sVNMergeRange2 != null) {
            object2 = this.makeMergeConflictError(file, sVNMergeRange2);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
    }

    protected void doMergeInfoUnawareDirectoryMerge(SVNURL sVNURL, long l2, SVNURL sVNURL2, long l3, SVNAdminArea sVNAdminArea, SVNDepth sVNDepth) {
        File file = sVNAdminArea.getRoot();
        boolean bl2 = l2 > l3;
        SVNMergeDriver$MergePath sVNMergeDriver$MergePath = new SVNMergeDriver$MergePath(this, file);
        SVNMergeRange sVNMergeRange = new SVNMergeRange(l2, l3, true);
        sVNMergeDriver$MergePath.myRemainingRanges = new SVNMergeRangeList(sVNMergeRange);
        this.myChildrenWithMergeInfo.add(sVNMergeDriver$MergePath);
        this.driveMergeReportEditor(file, sVNURL, l2, sVNURL2, l3, null, bl2, sVNDepth, sVNAdminArea, this.getMergeCallback(sVNAdminArea), null);
    }

    protected void recordMergeInfoForDirectoryMerge(Map map, SVNEntry sVNEntry, SVNMergeRange sVNMergeRange, String string, SVNDepth sVNDepth) {
        boolean bl2 = sVNMergeRange.getStartRevision() > sVNMergeRange.getEndRevision();
        this.removeAbsentChildren(this.myTarget, this.myChildrenWithMergeInfo);
        for (int i2 = 0; i2 < this.myChildrenWithMergeInfo.size(); ++i2) {
            SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)this.myChildrenWithMergeInfo.get(i2);
            if (sVNMergeDriver$MergePath == null || sVNMergeDriver$MergePath.myIsAbsent) continue;
            String string2 = null;
            string2 = sVNMergeDriver$MergePath.myPath.equals(this.myTarget) ? "" : SVNPathUtil.getRelativePath(this.myTarget.getAbsolutePath(), sVNMergeDriver$MergePath.myPath.getAbsolutePath());
            SVNEntry sVNEntry2 = this.myWCAccess.getVersionedEntry(sVNMergeDriver$MergePath.myPath, false);
            String string3 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, string2));
            SVNMergeRangeList sVNMergeRangeList = this.filterNaturalHistoryFromMergeInfo(string3, sVNMergeDriver$MergePath.myImplicitMergeInfo, sVNMergeRange);
            if (sVNMergeRangeList.isEmpty()) continue;
            if (i2 == 0) {
                this.recordSkips(string, sVNEntry, bl2);
            }
            this.calculateMergeInheritance(sVNMergeRangeList, sVNEntry2, i2 == 0, sVNMergeDriver$MergePath.myHasMissingChildren, sVNDepth);
            if (sVNMergeDriver$MergePath.myIsIndirectMergeInfo) {
                SVNPropertiesManager.recordWCMergeInfo(sVNMergeDriver$MergePath.myPath, sVNMergeDriver$MergePath.myPreMergeMergeInfo, this.myWCAccess);
            }
            if (this.myImplicitSrcGap != null) {
                if (bl2) {
                    sVNMergeRangeList.reverse();
                }
                sVNMergeRangeList = sVNMergeRangeList.diff(this.myImplicitSrcGap, false);
                if (bl2) {
                    sVNMergeRangeList.reverse();
                }
            }
            TreeMap<File, SVNMergeRangeList> treeMap = new TreeMap<File, SVNMergeRangeList>();
            treeMap.put(sVNMergeDriver$MergePath.myPath, sVNMergeRangeList);
            this.updateWCMergeInfo(map, sVNMergeDriver$MergePath.myPath, string3, sVNEntry2, treeMap, bl2);
            if (i2 <= 0) continue;
            boolean bl3 = false;
            if (sVNMergeDriver$MergePath.myIsSwitched) {
                bl3 = true;
            } else if (i2 > 1) {
                for (int i3 = i2 - 1; i3 > 0; --i3) {
                    SVNMergeDriver$MergePath sVNMergeDriver$MergePath2 = (SVNMergeDriver$MergePath)this.myChildrenWithMergeInfo.get(i3);
                    if (sVNMergeDriver$MergePath2 == null || !sVNMergeDriver$MergePath2.myIsSwitched || !SVNPathUtil.isAncestor(sVNMergeDriver$MergePath2.myPath.getAbsolutePath().replace(File.separatorChar, '/'), sVNMergeDriver$MergePath.myPath.getAbsolutePath().replace(File.separatorChar, '/'))) continue;
                    bl3 = true;
                    break;
                }
            }
            this.elideMergeInfo(this.myWCAccess, sVNMergeDriver$MergePath.myPath, sVNEntry2, bl3 ? null : this.myTarget);
        }
    }

    protected void recordMergeInfoForAddedSubtrees(SVNMergeRange sVNMergeRange, String string, SVNDepth sVNDepth) {
        if (this.myAddedPaths != null) {
            for (File file : this.myAddedPaths) {
                SVNPropertyValue sVNPropertyValue = SVNPropertiesManager.getProperty(this.myWCAccess, file.getParentFile(), "svn:mergeinfo");
                String string2 = sVNPropertyValue != null ? sVNPropertyValue.getString() : null;
                if (string2 == null || string2.indexOf(SVNMergeRangeList.MERGE_INFO_NONINHERITABLE_STRING) == -1) continue;
                SVNEntry sVNEntry = this.myWCAccess.getVersionedEntry(file, false);
                Map<String, SVNMergeRangeList> map = new TreeMap<String, SVNMergeRangeList>();
                SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)this.myChildrenWithMergeInfo.get(0);
                SVNMergeRange sVNMergeRange2 = sVNMergeRange.dup();
                if (sVNEntry.isFile()) {
                    sVNMergeRange2.setInheritable(true);
                } else {
                    sVNMergeRange2.setInheritable(sVNDepth != SVNDepth.INFINITY && sVNDepth != SVNDepth.IMMEDIATES);
                }
                String string3 = SVNPathUtil.validateFilePath(file.getAbsolutePath());
                String string4 = SVNPathUtil.validateFilePath(sVNMergeDriver$MergePath.myPath.getAbsolutePath());
                String string5 = SVNPathUtil.getCommonPathAncestor(string3, string4);
                String string6 = SVNPathUtil.getRelativePath(string5, string3);
                if (string6.startsWith("/")) {
                    string6 = string6.substring(1);
                }
                SVNMergeRangeList sVNMergeRangeList = new SVNMergeRangeList(sVNMergeRange2);
                map.put(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, string6)), sVNMergeRangeList);
                boolean[] blArray = new boolean[]{false};
                Map map2 = this.getWCMergeInfo(file, sVNEntry, null, SVNMergeInfoInheritance.EXPLICIT, false, blArray);
                if (map2 != null) {
                    map = SVNMergeInfoUtil.mergeMergeInfos(map, map2);
                }
                SVNPropertiesManager.recordWCMergeInfo(file, map, this.myWCAccess);
            }
        }
    }

    protected void doDirectoryMerge(SVNURL sVNURL, long l2, SVNURL sVNURL2, long l3, SVNEntry sVNEntry, SVNAdminArea sVNAdminArea, SVNDepth sVNDepth) {
        this.doDirectoryMerge(null, sVNURL, l2, sVNURL2, l3, sVNEntry, sVNAdminArea, sVNDepth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDirectoryMerge(Map map, SVNURL sVNURL, long l2, SVNURL sVNURL2, long l3, SVNEntry sVNEntry, SVNAdminArea sVNAdminArea, SVNDepth sVNDepth) {
        boolean bl2 = l2 > l3;
        SVNURL sVNURL3 = bl2 ? sVNURL : sVNURL2;
        boolean bl3 = this.isHonorMergeInfo();
        boolean bl4 = this.isRecordMergeInfo();
        boolean bl5 = sVNURL.equals(sVNURL2);
        SVNMergeCallback sVNMergeCallback = this.getMergeCallback(sVNAdminArea);
        this.myChildrenWithMergeInfo = new LinkedList();
        if (!bl3) {
            this.doMergeInfoUnawareDirectoryMerge(sVNURL, l2, sVNURL2, l3, sVNAdminArea, sVNDepth);
            return;
        }
        SVNRepository sVNRepository = bl2 ? this.myRepository1 : this.myRepository2;
        SVNURL sVNURL4 = sVNRepository.getRepositoryRoot(true);
        String string = this.getPathRelativeToRoot(null, sVNURL3, sVNURL4, null, null);
        this.myChildrenWithMergeInfo = this.getMergeInfoPaths(this.myChildrenWithMergeInfo, string, sVNEntry, sVNURL4, l2, l3, bl3, sVNRepository, sVNDepth);
        SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)this.myChildrenWithMergeInfo.get(0);
        this.myIsTargetMissingChild = sVNMergeDriver$MergePath.myHasMissingChildren;
        this.populateRemainingRanges(this.myChildrenWithMergeInfo, sVNURL4, sVNURL, l2, sVNURL2, l3, bl3, sVNRepository, string);
        SVNMergeRange sVNMergeRange = new SVNMergeRange(l2, l3, true);
        ISVNReusableEditor iSVNReusableEditor = null;
        SVNErrorMessage sVNErrorMessage = null;
        if (bl3 && !this.myIsRecordOnly) {
            long l4 = this.getMostInclusiveStartRevision(this.myChildrenWithMergeInfo, bl2);
            if (SVNRevision.isValidRevisionNumber(l4)) {
                sVNMergeRange.setStartRevision(l4);
            }
            if (!bl2) {
                this.removeNoOpSubtreeRanges(sVNURL, l2, sVNURL2, l3, sVNRepository);
            }
            this.fixDeletedSubtreeRanges(sVNURL, l2, sVNURL2, l3, sVNRepository);
            long l5 = this.getMostInclusiveStartRevision(this.myChildrenWithMergeInfo, bl2);
            if (SVNRevision.isValidRevisionNumber(l5)) {
                long l6 = this.getMostInclusiveEndRevision(this.myChildrenWithMergeInfo, bl2);
                while (SVNRevision.isValidRevisionNumber(l6)) {
                    SVNURL sVNURL5 = sVNURL;
                    SVNURL sVNURL6 = sVNURL2;
                    SVNURL sVNURL7 = null;
                    SVNURL sVNURL8 = null;
                    long l7 = -1L;
                    this.sliceRemainingRanges(this.myChildrenWithMergeInfo, bl2, l6);
                    this.myCurrentAncestorIndex = -1;
                    if (!bl5) {
                        if (bl2 && l6 != l3) {
                            sVNURL6 = sVNURL;
                            sVNURL8 = this.ensureSessionURL(this.myRepository2, sVNURL6);
                        }
                        if (!bl2 && l5 != l2) {
                            sVNURL5 = sVNURL2;
                            sVNURL7 = this.ensureSessionURL(this.myRepository1, sVNURL5);
                        }
                    }
                    try {
                        iSVNReusableEditor = this.driveMergeReportEditor(this.myTarget, sVNURL5, l5, sVNURL6, l6, this.myChildrenWithMergeInfo, bl2, sVNDepth, sVNAdminArea, sVNMergeCallback, iSVNReusableEditor);
                        if (sVNURL7 != null) {
                            this.myRepository1.setLocation(sVNURL7, false);
                        }
                        if (sVNURL8 != null) {
                            this.myRepository2.setLocation(sVNURL8, false);
                        }
                    }
                    catch (Throwable throwable) {
                        if (sVNURL7 != null) {
                            this.myRepository1.setLocation(sVNURL7, false);
                        }
                        if (sVNURL8 != null) {
                            this.myRepository2.setLocation(sVNURL8, false);
                        }
                        throw throwable;
                    }
                    this.processChildrenWithNewMergeInfo();
                    this.processChildrenWithDeletedMergeInfo();
                    this.removeFirstRangeFromRemainingRanges(l6, this.myChildrenWithMergeInfo);
                    l7 = this.getMostInclusiveEndRevision(this.myChildrenWithMergeInfo, bl2);
                    if (SVNRevision.isValidRevisionNumber(l7) && this.myConflictedPaths != null && !this.myConflictedPaths.isEmpty() && !this.myIsDryRun) {
                        SVNMergeRange sVNMergeRange2 = new SVNMergeRange(l5, l6, false);
                        sVNErrorMessage = this.makeMergeConflictError(this.myTarget, sVNMergeRange2);
                        sVNMergeRange.setEndRevision(l6);
                        break;
                    }
                    l5 = this.getMostInclusiveStartRevision(this.myChildrenWithMergeInfo, bl2);
                    l6 = l7;
                }
            }
        } else if (!this.myIsRecordOnly) {
            this.myCurrentAncestorIndex = -1;
            iSVNReusableEditor = this.driveMergeReportEditor(this.myTarget, sVNURL, l2, sVNURL2, l3, null, bl2, sVNDepth, sVNAdminArea, sVNMergeCallback, iSVNReusableEditor);
        }
        if (bl4) {
            this.recordMergeInfoForDirectoryMerge(map, sVNEntry, sVNMergeRange, string, sVNDepth);
            this.recordMergeInfoForAddedSubtrees(sVNMergeRange, string, sVNDepth);
        }
        if (sVNErrorMessage != null) {
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    protected SVNProperties filterSelfReferentialMergeInfo(SVNProperties sVNProperties, File file) {
        boolean bl2 = this.isHonorMergeInfo();
        if (!bl2 && this.myIsSameRepository && !this.myIsReIntegrateMerge) {
            return null;
        }
        SVNEntry sVNEntry = this.myWCAccess.getVersionedEntry(file, false);
        if (this.myIsSameRepository && (sVNEntry.isScheduledForAddition() || sVNEntry.isScheduledForReplacement())) {
            return null;
        }
        SVNProperties sVNProperties2 = new SVNProperties();
        for (String string : sVNProperties.nameSet()) {
            Object object2;
            SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string);
            if ("svn:mergeinfo".equals(string) && !this.myIsSameRepository) continue;
            if (!"svn:mergeinfo".equals(string) || sVNPropertyValue == null || "".equals(sVNPropertyValue.getString())) {
                sVNProperties2.put(string, sVNPropertyValue);
                continue;
            }
            SVNURL sVNURL = this.myRepository2.getRepositoryRoot(true);
            SVNURL sVNURL2 = this.getURL(file);
            SVNURL sVNURL3 = this.ensureSessionURL(this.myRepository2, sVNURL2);
            TreeMap<Object, SVNMergeRangeList> treeMap = null;
            Map map = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(sVNPropertyValue.getString()), null);
            Map[] mapArray = new Map[]{map};
            Map map2 = this.splitMergeInfoOnRevision(mapArray, sVNEntry.getRevision());
            map = mapArray[0];
            if (map2 != null) {
                for (Object object2 : map2.keySet()) {
                    SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map2.get(object2);
                    SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList.getRanges();
                    LinkedList<SVNMergeRange> linkedList = new LinkedList<SVNMergeRange>();
                    SVNURL sVNURL4 = sVNURL.appendPath((String)object2, false);
                    for (int i2 = 0; i2 < sVNMergeRangeArray.length; ++i2) {
                        SVNMergeRange sVNMergeRange = sVNMergeRangeArray[i2];
                        SVNBasicDelegate$SVNRepositoryLocation[] sVNBasicDelegate$SVNRepositoryLocationArray = null;
                        try {
                            sVNBasicDelegate$SVNRepositoryLocationArray = this.getLocations(sVNURL2, null, this.myRepository2, SVNRevision.create(sVNEntry.getRevision()), SVNRevision.create(sVNMergeRange.getStartRevision() + 1L), SVNRevision.UNDEFINED);
                            SVNURL sVNURL5 = sVNBasicDelegate$SVNRepositoryLocationArray[0].getURL();
                            if (sVNURL4.equals(sVNURL5)) continue;
                            linkedList.add(sVNMergeRange);
                            continue;
                        }
                        catch (SVNException sVNException) {
                            SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
                            if (sVNErrorCode == SVNErrorCode.CLIENT_UNRELATED_RESOURCES || sVNErrorCode == SVNErrorCode.RA_DAV_PATH_NOT_FOUND || sVNErrorCode == SVNErrorCode.FS_NOT_FOUND || sVNErrorCode == SVNErrorCode.FS_NO_SUCH_REVISION) {
                                linkedList.add(sVNMergeRange);
                                continue;
                            }
                            throw sVNException;
                        }
                    }
                    if (linkedList.isEmpty()) continue;
                    if (treeMap == null) {
                        treeMap = new TreeMap<Object, SVNMergeRangeList>();
                    }
                    SVNMergeRangeList sVNMergeRangeList2 = SVNMergeRangeList.fromCollection(linkedList);
                    treeMap.put(object2, sVNMergeRangeList2);
                }
            }
            Object object3 = null;
            if (map != null && !map.isEmpty()) {
                object2 = this.getHistoryAsMergeInfo(null, file, SVNRevision.create(sVNEntry.getRevision()), sVNEntry.getRevision(), -1L, this.myRepository2, this.myWCAccess);
                object3 = SVNMergeInfoUtil.removeMergeInfo((Map)object2, map);
            }
            if (sVNURL3 != null) {
                this.myRepository2.setLocation(sVNURL3, false);
            }
            if (object3 != null && treeMap != null) {
                object3 = SVNMergeInfoUtil.mergeMergeInfos(object3, treeMap);
            } else if (treeMap != null) {
                object3 = treeMap;
            }
            if (object3 == null || object3.isEmpty()) continue;
            object2 = SVNMergeInfoUtil.formatMergeInfoToString((Map)object3, null);
            sVNProperties2.put("svn:mergeinfo", (String)object2);
        }
        return sVNProperties2;
    }

    protected SVNLogClient16 getLogClient() {
        if (this.myLogClient == null) {
            this.myLogClient = new SVNLogClient16(this.getRepositoryPool(), this.getOptions());
        }
        return this.myLogClient;
    }

    protected void recordTreeConflict(File file, SVNAdminArea sVNAdminArea, SVNNodeKind sVNNodeKind, SVNConflictAction sVNConflictAction, SVNConflictReason sVNConflictReason) {
        if (this.myIsRecordOnly || this.myIsDryRun) {
            return;
        }
        SVNTreeConflictDescription sVNTreeConflictDescription = this.makeTreeConflict(file, sVNNodeKind, sVNConflictAction, sVNConflictReason);
        sVNAdminArea.addTreeConflict(sVNTreeConflictDescription);
    }

    protected void recordTreeConflictOnAdd(File file, SVNAdminArea sVNAdminArea, SVNNodeKind sVNNodeKind, SVNConflictAction sVNConflictAction, SVNConflictReason sVNConflictReason) {
        if (this.myIsRecordOnly || this.myIsDryRun) {
            return;
        }
        SVNTreeConflictDescription sVNTreeConflictDescription = this.makeTreeConflict(file, sVNNodeKind, sVNConflictAction, sVNConflictReason);
        SVNTreeConflictDescription sVNTreeConflictDescription2 = this.myWCAccess.getTreeConflict(sVNTreeConflictDescription.getPath());
        if (sVNTreeConflictDescription2 != null && sVNTreeConflictDescription2.getConflictAction() == SVNConflictAction.DELETE && sVNTreeConflictDescription.getConflictAction() == SVNConflictAction.ADD) {
            sVNAdminArea.deleteTreeConflict(sVNTreeConflictDescription.getPath().getName());
            sVNTreeConflictDescription = new SVNTreeConflictDescription(sVNTreeConflictDescription.getPath(), sVNTreeConflictDescription.getNodeKind(), SVNConflictAction.DELETE, sVNTreeConflictDescription2.getConflictReason(), sVNTreeConflictDescription.getOperation(), sVNTreeConflictDescription2.getSourceLeftVersion(), sVNTreeConflictDescription.getSourceRightVersion());
        }
        sVNAdminArea.addTreeConflict(sVNTreeConflictDescription);
    }

    protected SVNTreeConflictDescription makeTreeConflict(File file, SVNNodeKind sVNNodeKind, SVNConflictAction sVNConflictAction, SVNConflictReason sVNConflictReason) {
        SVNURL sVNURL = this.myRepository1.getRepositoryRoot(true);
        String string = SVNPathUtil.getRelativePath(this.myTarget.getAbsolutePath(), file.getAbsolutePath());
        SVNURL sVNURL2 = null;
        SVNURL sVNURL3 = null;
        if (string != null) {
            sVNURL2 = SVNMergeDriver$MergeSource.access$000(this.myCurrentMergeSource).appendPath(string, false);
            sVNURL3 = SVNMergeDriver$MergeSource.access$100(this.myCurrentMergeSource).appendPath(string, false);
        } else {
            sVNURL2 = SVNMergeDriver$MergeSource.access$000(this.myCurrentMergeSource);
            sVNURL3 = SVNMergeDriver$MergeSource.access$100(this.myCurrentMergeSource);
        }
        SVNConflictVersion sVNConflictVersion = new SVNConflictVersion(sVNURL, SVNURLUtil.getRelativeURL(sVNURL, sVNURL2, false), SVNMergeDriver$MergeSource.access$200(this.myCurrentMergeSource), sVNNodeKind);
        SVNConflictVersion sVNConflictVersion2 = new SVNConflictVersion(sVNURL, SVNURLUtil.getRelativeURL(sVNURL, sVNURL3, false), SVNMergeDriver$MergeSource.access$300(this.myCurrentMergeSource), sVNNodeKind);
        SVNTreeConflictDescription sVNTreeConflictDescription = new SVNTreeConflictDescription(file, sVNNodeKind, sVNConflictAction, sVNConflictReason, SVNOperation.MERGE, sVNConflictVersion, sVNConflictVersion2);
        return sVNTreeConflictDescription;
    }

    private SVNMergeCallback getMergeCallback(SVNAdminArea sVNAdminArea) {
        return this.myWCAccess.createMergeCallback(this, sVNAdminArea, this.myURL, this.getMergeOptions(), this.myConflictedPaths, this.myIsForce, this.myIsDryRun);
    }

    private void processChildrenWithNewMergeInfo() {
        if (this.myPathsWithNewMergeInfo != null && !this.myIsDryRun) {
            for (File file : this.myPathsWithNewMergeInfo) {
                SVNEntry sVNEntry = this.myWCAccess.getVersionedEntry(file, false);
                boolean[] blArray = new boolean[]{false};
                Map map = this.getWCMergeInfo(file, sVNEntry, null, SVNMergeInfoInheritance.EXPLICIT, false, blArray);
                SVNURL sVNURL = null;
                if (map != null) {
                    SVNMergeDriver$MergePath sVNMergeDriver$MergePath;
                    sVNURL = this.ensureSessionURL(this.myRepository2, sVNEntry.getSVNURL());
                    Map map2 = this.getWCOrRepositoryMergeInfo(file, sVNEntry, SVNMergeInfoInheritance.NEAREST_ANCESTOR, blArray, false, this.myRepository2);
                    if (map2 != null) {
                        map = SVNMergeInfoUtil.mergeMergeInfos(map, map2);
                        SVNPropertiesManager.recordWCMergeInfo(file, map, this.myWCAccess);
                    }
                    if (!this.myChildrenWithMergeInfo.contains(sVNMergeDriver$MergePath = new SVNMergeDriver$MergePath(this, file))) {
                        int n2 = this.findNearestAncestor(this.myChildrenWithMergeInfo.toArray(), false, file);
                        SVNMergeDriver$MergePath sVNMergeDriver$MergePath2 = (SVNMergeDriver$MergePath)this.myChildrenWithMergeInfo.get(n2);
                        sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath2.myRemainingRanges.dup();
                        this.myChildrenWithMergeInfo.add(sVNMergeDriver$MergePath);
                        Collections.sort(this.myChildrenWithMergeInfo);
                    }
                }
                if (sVNURL == null) continue;
                this.myRepository2.setLocation(sVNURL, false);
            }
        }
    }

    private void processChildrenWithDeletedMergeInfo() {
        if (this.myPathsWithDeletedMergeInfo != null && !this.myIsDryRun) {
            Iterator iterator = this.myChildrenWithMergeInfo.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)iterator.next();
                if (sVNMergeDriver$MergePath == null || !this.myPathsWithDeletedMergeInfo.contains(sVNMergeDriver$MergePath.myPath)) continue;
                iterator.remove();
            }
        }
    }

    private Map splitMergeInfoOnRevision(Map[] mapArray, long l2) {
        TreeMap<String, SVNMergeRangeList> treeMap = null;
        block0: for (String string : mapArray[0].keySet()) {
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)mapArray[0].get(string);
            SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList.getRanges();
            for (int i2 = 0; i2 < sVNMergeRangeArray.length; ++i2) {
                SVNMergeRange sVNMergeRange = sVNMergeRangeArray[i2];
                if (sVNMergeRange.getEndRevision() < l2) continue;
                LinkedList<SVNMergeRange> linkedList = new LinkedList<SVNMergeRange>();
                for (int i3 = i2; i3 < sVNMergeRangeArray.length; ++i3) {
                    SVNMergeRange sVNMergeRange2 = sVNMergeRangeArray[i3].dup();
                    if (i3 == i2 && sVNMergeRange2.getStartRevision() < l2) {
                        sVNMergeRange2.setStartRevision(l2);
                        sVNMergeRange.setEndRevision(l2);
                    }
                    linkedList.add(sVNMergeRange2);
                }
                if (treeMap == null) {
                    treeMap = new TreeMap<String, SVNMergeRangeList>();
                }
                treeMap.put(string, SVNMergeRangeList.fromCollection(linkedList));
                mapArray[0] = SVNMergeInfoUtil.removeMergeInfo(treeMap, mapArray[0]);
                continue block0;
            }
        }
        return treeMap;
    }

    private void ensureWCReflectsRepositorySubTree(File file) {
        SVNErrorMessage sVNErrorMessage;
        SVNRevisionStatus sVNRevisionStatus = SVNStatusUtil.getRevisionStatus(file, null, false, this.getEventDispatcher());
        if (sVNRevisionStatus.isSwitched()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reintegrate into a working copy with a switched subtree");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (sVNRevisionStatus.isSparseCheckout()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reintegrate into a working copy not entirely at infinite depth");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (sVNRevisionStatus.isModified()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reintegrate into a working copy that has local modifications");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (!SVNRevision.isValidRevisionNumber(sVNRevisionStatus.getMinRevision()) || !SVNRevision.isValidRevisionNumber(sVNRevisionStatus.getMaxRevision())) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot determine revision of working copy");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (sVNRevisionStatus.getMinRevision() != sVNRevisionStatus.getMaxRevision()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reintegrate into mixed-revision working copy; try updating first");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
    }

    private void ensureAllMissingRangesArePhantoms(SVNRepository sVNRepository, Map map) {
        for (String string : map.keySet()) {
            Map map2 = (Map)map.get(string);
            for (String string2 : map2.keySet()) {
                SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map2.get(string2);
                SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList.getRanges();
                for (int i2 = 0; i2 < sVNMergeRangeArray.length; ++i2) {
                    Object object;
                    SVNMergeRange sVNMergeRange = sVNMergeRangeArray[i2];
                    if (sVNMergeRange.getStartRevision() >= sVNMergeRange.getEndRevision()) {
                        object = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "range start >= end");
                        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
                    }
                    if (!this.mergeRangeContainsRevision(sVNMergeRange, ((SVNDirEntry)(object = sVNRepository.info(string2, sVNMergeRange.getEndRevision()))).getRevision())) continue;
                    SVNURL sVNURL = sVNRepository.getLocation();
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                    sVNURL = sVNURL.appendPath(string2, false);
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "At least one revision (r{0}) not yet merged from ''{1}''", ((SVNDirEntry)object).getRevision(), sVNURL);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
                }
            }
        }
    }

    private Map findUnmergedMergeInfo(boolean[] blArray, long[] lArray, long[] lArray2, Map map, Map map2, String string, String string2, long l2, long l3, SVNRepository sVNRepository, SVNRepository sVNRepository2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        blArray[0] = true;
        lArray[0] = -1L;
        Map<String, Map> map3 = new TreeMap();
        String string3 = null;
        for (String string4 : map2.keySet()) {
            Map map4;
            object7 = (Collection)map2.get(string4);
            object6 = string4.substring(string2.length());
            if (((String)object6).startsWith("/")) {
                object6 = ((String)object6).substring(1);
            }
            string3 = object6;
            if (!((String)(object6 = SVNPathUtil.append(string, (String)object6))).startsWith("/")) {
                object6 = "/" + (String)object6;
            }
            object5 = SVNMergeDriver.getMergeInfoFromSegments((Collection)object7);
            object5 = SVNMergeInfoUtil.filterMergeInfoByRanges((Map)object5, l3, lArray2[0]);
            object4 = (SVNMergeInfo)map.get(object6);
            TreeMap treeMap = map4 = object4 != null ? ((SVNMergeInfo)object4).getMergeSourcesToMergeLists() : null;
            if (map4 != null) {
                map.remove(object6);
                object3 = SVNMergeInfoUtil.intersectMergeInfo(map4, (Map)object5);
                if (!object3.isEmpty()) {
                    blArray[0] = false;
                    object2 = SVNMergeInfoUtil.getRangeEndPoints((Map)object3);
                    Object object8 = object2[0];
                    if (!SVNRevision.isValidRevisionNumber(lArray[0]) || object8 > lArray[0]) {
                        lArray[0] = (long)object8;
                    }
                }
            } else {
                object3 = sVNRepository.checkPath(string3, l3);
                if (object3 == SVNNodeKind.NONE) continue;
                object2 = sVNRepository.getMergeInfo(new String[]{string3}, l3, SVNMergeInfoInheritance.INHERITED, false);
                if (object2 != null) {
                    object = (SVNMergeInfo)object2.get(object6);
                    Map map5 = map4 = object != null ? ((SVNMergeInfo)object).getMergeSourcesToMergeLists() : null;
                }
                if (map4 == null) {
                    map4 = new TreeMap();
                }
            }
            object7 = sVNRepository.getLocationSegments(string3, l3, l3, -1L);
            object3 = SVNMergeDriver.getMergeInfoFromSegments((Collection)object7);
            map4 = SVNMergeInfoUtil.mergeMergeInfos(map4, (Map)object3);
            object2 = SVNMergeInfoUtil.intersectMergeInfo(map4, (Map)object5);
            object = SVNMergeInfoUtil.removeMergeInfo((Map)object2, (Map)object5);
            map3.put((String)object6, (Map)object);
        }
        if (!map.isEmpty()) {
            for (String string4 : map.keySet()) {
                Map map6;
                Map map7;
                object7 = (SVNMergeInfo)map.get(string4);
                object6 = ((SVNMergeInfo)object7).getMergeSourcesToMergeLists();
                object5 = string4.substring(string.length());
                if (((String)object5).startsWith("/")) {
                    object5 = ((String)object5).substring(1);
                }
                if ((string3 = string4.substring(string.length())).startsWith("/")) {
                    string3 = string3.substring(1);
                }
                object4 = null;
                boolean bl2 = true;
                try {
                    object4 = sVNRepository2.getLocationSegments((String)object5, l2, l2, -1L);
                }
                catch (SVNException sVNException) {
                    object2 = sVNException.getErrorMessage();
                    object = ((SVNErrorMessage)object2).getErrorCode();
                    if (object != SVNErrorCode.FS_NOT_FOUND && object != SVNErrorCode.RA_DAV_REQUEST_FAILED) {
                        throw sVNException;
                    }
                    bl2 = false;
                }
                if (!bl2) continue;
                object3 = SVNMergeDriver.getMergeInfoFromSegments((Collection)object4);
                object2 = SVNMergeInfoUtil.intersectMergeInfo((Map)object6, (Map)object3);
                if (!object2.isEmpty()) {
                    blArray[0] = false;
                    object = SVNMergeInfoUtil.getRangeEndPoints((Map)object2);
                    Object object9 = object[0];
                    if (!SVNRevision.isValidRevisionNumber(lArray[0]) || object9 > lArray[0]) {
                        lArray[0] = (long)object9;
                    }
                }
                if ((map7 = SVNMergeInfoUtil.removeMergeInfo(map6 = SVNMergeInfoUtil.intersectMergeInfo((Map)(object6 = SVNMergeInfoUtil.mergeMergeInfos((Map)object6, (Map)(object = SVNMergeDriver.getMergeInfoFromSegments((Collection)(object4 = sVNRepository.getLocationSegments(string3, l2, l2, -1L)))))), (Map)object3), (Map)object3)).isEmpty()) continue;
                map3.put(string4, map7);
            }
        }
        if (SVNRevision.isValidRevisionNumber(lArray[0])) {
            map3 = SVNMergeInfoUtil.filterCatalogByRanges(map3, lArray[0], 0L);
        }
        return map3;
    }

    private Map calculateLeftHandSide(SVNURL[] sVNURLArray, long[] lArray, String string, Collection collection, long l2, String string2, SVNURL sVNURL, long l3, SVNRepository sVNRepository, SVNRepository sVNRepository2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        TreeMap<Object, List> treeMap = new TreeMap<Object, List>();
        Map map = collection.iterator();
        while (map.hasNext()) {
            object3 = object4 = (String)map.next();
            if (((String)(object3 = ((String)object3).substring(string.length()))).startsWith("/")) {
                object3 = ((String)object3).substring(1);
            }
            object2 = sVNRepository2.getLocationSegments((String)object3, l2, l2, -1L);
            treeMap.put(object4, (List)object2);
        }
        map = sVNRepository.getMergeInfo(new String[]{""}, l3, SVNMergeInfoInheritance.INHERITED, true);
        if (map == null) {
            map = new TreeMap();
        }
        object4 = new boolean[1];
        object3 = new long[1];
        object2 = sVNURL.appendPath(string2.startsWith("/") ? string2.substring(1) : string2, false);
        SVNURL sVNURL2 = sVNURL.appendPath(string.startsWith("/") ? string.substring(1) : string, false);
        SVNLocationEntry sVNLocationEntry = this.getYoungestCommonAncestor(null, (SVNURL)object2, l3, null, sVNURL2, l2);
        String string3 = sVNLocationEntry.getPath();
        lArray[0] = sVNLocationEntry.getRevision();
        if (string3 == null || !SVNRevision.isValidRevisionNumber(lArray[0])) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "''{0}@{1}'' must be ancestrally related to ''{2}@{3}''", object2, l3, sVNURL2, l2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        object = this.findUnmergedMergeInfo((boolean[])object4, (long[])object3, lArray, map, treeMap, string2, string, l2, l3, sVNRepository, sVNRepository2);
        object = SVNMergeInfoUtil.elideMergeInfoCatalog((Map)object);
        if (object4[0] != false) {
            sVNURLArray[0] = sVNURL.appendPath(string3.startsWith("/") ? string3.substring(1) : string3, false);
        } else {
            lArray[0] = (long)object3[0];
            sVNURLArray[0] = this.deriveLocation(null, sVNURL.appendPath(string, false), null, SVNRevision.create((long)object3[0]), sVNRepository2, null);
        }
        return object;
    }

    private boolean mergeRangeContainsRevision(SVNMergeRange sVNMergeRange, long l2) {
        SVNErrorMessage sVNErrorMessage;
        if (!SVNRevision.isValidRevisionNumber(sVNMergeRange.getStartRevision())) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "invalid start range revision");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (!SVNRevision.isValidRevisionNumber(sVNMergeRange.getEndRevision())) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "invalid end range revision");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (sVNMergeRange.getStartRevision() == sVNMergeRange.getEndRevision()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "start range revision is equal to end range revision");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (sVNMergeRange.getStartRevision() < sVNMergeRange.getEndRevision()) {
            return l2 > sVNMergeRange.getStartRevision() && l2 <= sVNMergeRange.getEndRevision();
        }
        return l2 > sVNMergeRange.getEndRevision() && l2 <= sVNMergeRange.getStartRevision();
    }

    private void mergeCousinsAndSupplementMergeInfo(File file, SVNEntry sVNEntry, SVNAdminArea sVNAdminArea, SVNRepository sVNRepository, SVNRepository sVNRepository2, SVNURL sVNURL, long l2, SVNURL sVNURL2, long l3, long l4, SVNURL sVNURL3, SVNURL sVNURL4, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Cloneable cloneable;
        TreeMap treeMap;
        List list = null;
        List list2 = null;
        SVNRevision sVNRevision = SVNRevision.create(l2);
        SVNRevision sVNRevision2 = SVNRevision.create(l4);
        SVNRevisionRange sVNRevisionRange = new SVNRevisionRange(sVNRevision, sVNRevision2);
        LinkedList<SVNRevisionRange> linkedList = new LinkedList<SVNRevisionRange>();
        linkedList.add(sVNRevisionRange);
        sVNRepository.setLocation(sVNURL, false);
        list2 = this.normalizeMergeSources(null, sVNURL, sVNURL3, sVNRevision, linkedList, sVNRepository);
        sVNRevision = sVNRevision2;
        sVNRevision2 = SVNRevision.create(l3);
        sVNRevisionRange = new SVNRevisionRange(sVNRevision, sVNRevision2);
        linkedList.clear();
        linkedList.add(sVNRevisionRange);
        sVNRepository2.setLocation(sVNURL2, false);
        list = this.normalizeMergeSources(null, sVNURL2, sVNURL3, sVNRevision2, linkedList, sVNRepository2);
        boolean bl6 = sVNURL3.equals(sVNURL4);
        if (!bl4) {
            treeMap = new SVNMergeDriver$MergeSource(this);
            SVNMergeDriver$MergeSource.access$002((SVNMergeDriver$MergeSource)((Object)treeMap), sVNURL);
            SVNMergeDriver$MergeSource.access$102(treeMap, sVNURL2);
            SVNMergeDriver$MergeSource.access$202(treeMap, l2);
            SVNMergeDriver$MergeSource.access$302(treeMap, l3);
            cloneable = new LinkedList();
            cloneable.add(treeMap);
            this.doMerge(null, (List)((Object)cloneable), file, sVNEntry, sVNAdminArea, false, true, sVNURL3.equals(sVNURL4), bl2, bl3, bl5, false, true, sVNDepth);
        } else if (!bl6) {
            treeMap = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Merge from foreign repository is not compatible with mergeinfo modification");
            SVNErrorManager.error(treeMap, SVNLogType.DEFAULT);
        }
        if (bl6) {
            treeMap = new TreeMap();
            cloneable = new TreeMap();
            this.doMerge(treeMap, list, file, sVNEntry, sVNAdminArea, true, true, bl6, bl2, bl3, bl5, true, true, sVNDepth);
            this.doMerge((Map)((Object)cloneable), list2, file, sVNEntry, sVNAdminArea, true, true, bl6, bl2, bl3, bl5, true, true, sVNDepth);
            SVNMergeInfoUtil.mergeCatalog(treeMap, (Map)((Object)cloneable));
            if (!treeMap.isEmpty()) {
                for (String string : treeMap.keySet()) {
                    Map map = (Map)treeMap.get(string);
                    File file2 = new File(string);
                    try {
                        SVNPropertiesManager.recordWCMergeInfo(file2, map, this.myWCAccess);
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) continue;
                        throw sVNException;
                    }
                }
            }
        }
    }

    public boolean isSameRepository() {
        return this.myIsSameRepository;
    }

    protected boolean isHonorMergeInfo() {
        return this.myIsMergeInfoCapable && this.myAreSourcesAncestral && this.myIsSameRepository && !this.myIsIgnoreAncestry;
    }

    @Override
    public boolean isRecordMergeInfo() {
        return this.myIsMergeInfoCapable && this.myAreSourcesAncestral && this.myIsSameRepository && !this.myIsIgnoreAncestry && !this.myIsDryRun;
    }

    protected SVNMergeDriver$MergeSource getCurrentMergeSource() {
        return this.myCurrentMergeSource;
    }

    private List normalizeMergeSources(File file, SVNURL sVNURL, SVNURL sVNURL2, SVNRevision sVNRevision, Collection collection, SVNRepository sVNRepository) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        long[] lArray = new long[]{-1L};
        long l2 = this.getRevisionNumber(sVNRevision, lArray, sVNRepository, file);
        if (!SVNRevision.isValidRevisionNumber(l2)) {
            object5 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.DEFAULT);
        }
        object5 = new ArrayList(collection.size());
        for (SVNRevisionRange sVNRevisionRange : collection) {
            long l3;
            long l4;
            SVNRevision sVNRevision2 = sVNRevisionRange.getStartRevision();
            SVNRevision sVNRevision3 = sVNRevisionRange.getEndRevision();
            if (!sVNRevision2.isValid() || !sVNRevision3.isValid()) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            }
            if ((l4 = this.getRevisionNumber(sVNRevision2, lArray, sVNRepository, file)) == (l3 = this.getRevisionNumber(sVNRevision3, lArray, sVNRepository, file))) continue;
            object4 = new SVNMergeRange(l4, l3, true);
            object5.add(object4);
        }
        SVNMergeRangeList sVNMergeRangeList = SVNMergeRangeList.fromCollection((Collection)object5);
        if ((object5 = sVNMergeRangeList.getRangesAsList()).isEmpty()) {
            return object5;
        }
        long l5 = -1L;
        long l6 = -1L;
        Object object6 = object5.iterator();
        while (object6.hasNext()) {
            SVNMergeRange sVNMergeRange = (SVNMergeRange)object6.next();
            long l7 = Math.min(sVNMergeRange.getStartRevision(), sVNMergeRange.getEndRevision());
            long l8 = Math.max(sVNMergeRange.getStartRevision(), sVNMergeRange.getEndRevision());
            if (!SVNRevision.isValidRevisionNumber(l5) || l7 < l5) {
                l5 = l7;
            }
            if (SVNRevision.isValidRevisionNumber(l6) && l8 <= l6) continue;
            l6 = l8;
        }
        if (l2 < l6) {
            this.getLocations(sVNURL, null, sVNRepository, SVNRevision.create(l2), SVNRevision.create(l6), SVNRevision.UNDEFINED);
            l2 = l6;
        }
        object6 = (LinkedList)sVNRepository.getLocationSegments("", l2, l6, l5);
        long l9 = -1L;
        if (!((AbstractCollection)object6).isEmpty()) {
            object4 = (SVNLocationSegment)((LinkedList)object6).get(0);
            if (object4.getStartRevision() != l5) {
                l9 = object4.getStartRevision();
            } else if (object4.getPath() == null && ((LinkedList)object6).size() > 1) {
                SVNLocationSegment sVNLocationSegment = (SVNLocationSegment)((LinkedList)object6).get(1);
                object3 = sVNURL2.appendPath(sVNLocationSegment.getPath(), false);
                object2 = this.getCopySource(null, (SVNURL)object3, SVNRevision.create(sVNLocationSegment.getStartRevision()));
                object = ((SVNLocationEntry)object2).getPath();
                long l10 = ((SVNLocationEntry)object2).getRevision();
                if (object != null && SVNRevision.isValidRevisionNumber(l10)) {
                    SVNLocationSegment sVNLocationSegment2 = new SVNLocationSegment(l10, l10, (String)object);
                    object4.setStartRevision(l10 + 1L);
                    ((LinkedList)object6).addFirst(sVNLocationSegment2);
                }
            }
        }
        object4 = ((LinkedList)object6).toArray(new SVNLocationSegment[((LinkedList)object6).size()]);
        LinkedList linkedList = new LinkedList();
        object3 = object5.iterator();
        while (object3.hasNext()) {
            object2 = (SVNMergeRange)object3.next();
            if (SVNRevision.isValidRevisionNumber(l9)) {
                if (Math.max(((SVNMergeRange)object2).getStartRevision(), ((SVNMergeRange)object2).getEndRevision()) < l9) continue;
                if (((SVNMergeRange)object2).getStartRevision() < l9) {
                    ((SVNMergeRange)object2).setStartRevision(l9);
                }
                if (((SVNMergeRange)object2).getEndRevision() < l9) {
                    ((SVNMergeRange)object2).setEndRevision(l9);
                }
            }
            object = this.combineRangeWithSegments((SVNMergeRange)object2, (SVNLocationSegment[])object4, sVNURL2);
            linkedList.addAll(object);
        }
        return linkedList;
    }

    private List combineRangeWithSegments(SVNMergeRange sVNMergeRange, SVNLocationSegment[] sVNLocationSegmentArray, SVNURL sVNURL) {
        long l2 = Math.min(sVNMergeRange.getStartRevision(), sVNMergeRange.getEndRevision()) + 1L;
        long l3 = Math.max(sVNMergeRange.getStartRevision(), sVNMergeRange.getEndRevision());
        boolean bl2 = sVNMergeRange.getStartRevision() > sVNMergeRange.getEndRevision();
        LinkedList<SVNMergeDriver$MergeSource> linkedList = new LinkedList<SVNMergeDriver$MergeSource>();
        for (int i2 = 0; i2 < sVNLocationSegmentArray.length; ++i2) {
            SVNLocationSegment sVNLocationSegment = sVNLocationSegmentArray[i2];
            if (sVNLocationSegment.getEndRevision() < l2 || sVNLocationSegment.getStartRevision() > l3 || sVNLocationSegment.getPath() == null) continue;
            String string = null;
            long l4 = Math.max(sVNLocationSegment.getStartRevision(), l2) - 1L;
            if (l2 <= sVNLocationSegment.getStartRevision()) {
                if (i2 > 0) {
                    string = sVNLocationSegmentArray[i2 - 1].getPath();
                }
                if (string == null && i2 > 1) {
                    string = sVNLocationSegmentArray[i2 - 2].getPath();
                    l4 = sVNLocationSegmentArray[i2 - 2].getEndRevision();
                }
            } else {
                string = sVNLocationSegment.getPath();
            }
            if (string == null || sVNLocationSegment.getPath() == null) continue;
            SVNMergeDriver$MergeSource sVNMergeDriver$MergeSource = new SVNMergeDriver$MergeSource(this);
            SVNMergeDriver$MergeSource.access$002(sVNMergeDriver$MergeSource, sVNURL.appendPath(string, false));
            SVNMergeDriver$MergeSource.access$102(sVNMergeDriver$MergeSource, sVNURL.appendPath(sVNLocationSegment.getPath(), false));
            SVNMergeDriver$MergeSource.access$202(sVNMergeDriver$MergeSource, l4);
            SVNMergeDriver$MergeSource.access$302(sVNMergeDriver$MergeSource, Math.min(sVNLocationSegment.getEndRevision(), l3));
            if (bl2) {
                long l5 = SVNMergeDriver$MergeSource.access$200(sVNMergeDriver$MergeSource);
                SVNURL sVNURL2 = SVNMergeDriver$MergeSource.access$000(sVNMergeDriver$MergeSource);
                SVNMergeDriver$MergeSource.access$202(sVNMergeDriver$MergeSource, SVNMergeDriver$MergeSource.access$300(sVNMergeDriver$MergeSource));
                SVNMergeDriver$MergeSource.access$002(sVNMergeDriver$MergeSource, SVNMergeDriver$MergeSource.access$100(sVNMergeDriver$MergeSource));
                SVNMergeDriver$MergeSource.access$302(sVNMergeDriver$MergeSource, l5);
                SVNMergeDriver$MergeSource.access$102(sVNMergeDriver$MergeSource, sVNURL2);
            }
            linkedList.add(sVNMergeDriver$MergeSource);
        }
        if (bl2 && !linkedList.isEmpty()) {
            Collections.sort(linkedList, new SVNMergeDriver$1(this));
        }
        return linkedList;
    }

    private SVNLocationEntry getYoungestCommonAncestor(File file, SVNURL sVNURL, long l2, File file2, SVNURL sVNURL2, long l3) {
        Map map = this.getHistoryAsMergeInfo(sVNURL, file, SVNRevision.create(l2), -1L, -1L, null, null);
        Map map2 = this.getHistoryAsMergeInfo(sVNURL2, file2, SVNRevision.create(l3), -1L, -1L, null, null);
        long l4 = -1L;
        String string = null;
        for (Map.Entry entry : map.entrySet()) {
            SVNMergeRangeList sVNMergeRangeList;
            String string2 = (String)entry.getKey();
            SVNMergeRangeList sVNMergeRangeList2 = (SVNMergeRangeList)entry.getValue();
            SVNMergeRangeList sVNMergeRangeList3 = (SVNMergeRangeList)map2.get(string2);
            if (sVNMergeRangeList3 == null || (sVNMergeRangeList = sVNMergeRangeList3.intersect(sVNMergeRangeList2, true)).isEmpty()) continue;
            SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList.getRanges();
            SVNMergeRange sVNMergeRange = sVNMergeRangeArray[sVNMergeRangeArray.length - 1];
            if (SVNRevision.isValidRevisionNumber(l4) && sVNMergeRange.getEndRevision() <= l4) continue;
            l4 = sVNMergeRange.getEndRevision();
            string = string2;
        }
        return new SVNLocationEntry(l4, string);
    }

    protected Map[] getFullMergeInfo(SVNEntry sVNEntry, boolean bl2, boolean bl3, boolean[] blArray, SVNMergeInfoInheritance sVNMergeInfoInheritance, SVNRepository sVNRepository, File file, long l2, long l3) {
        Map[] mapArray = new Map[2];
        SVNErrorManager.assertionFailure(SVNRevision.isValidRevisionNumber(l2) && SVNRevision.isValidRevisionNumber(l3) && l2 > l3, null, SVNLogType.WC);
        if (bl2) {
            mapArray[0] = this.getWCOrRepositoryMergeInfo(file, sVNEntry, sVNMergeInfoInheritance, blArray, false, sVNRepository);
        }
        if (bl3) {
            long[] lArray = new long[]{-1L};
            SVNURL sVNURL = this.deriveLocation(file, null, lArray, SVNRevision.WORKING, sVNRepository, this.myWCAccess);
            if (lArray[0] <= l3) {
                mapArray[1] = new TreeMap();
                return mapArray;
            }
            Map map = this.calculateImplicitMergeInfo(sVNRepository, sVNURL, lArray, l2, l3);
            if (map != null) {
                mapArray[1] = map;
            }
        }
        return mapArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map calculateImplicitMergeInfo(SVNRepository sVNRepository, SVNURL sVNURL, long[] lArray, long l2, long l3) {
        Map map = null;
        boolean bl2 = false;
        SVNURL sVNURL2 = null;
        try {
            if (sVNRepository != null) {
                sVNURL2 = this.ensureSessionURL(sVNRepository, sVNURL);
            } else {
                sVNRepository = this.createRepository(sVNURL, null, null, false);
                bl2 = true;
            }
            if (lArray[0] < l2) {
                this.getLocations(sVNURL, null, sVNRepository, SVNRevision.create(lArray[0]), SVNRevision.create(l2), SVNRevision.UNDEFINED);
                lArray[0] = l2;
            }
            map = this.getHistoryAsMergeInfo(sVNURL, null, SVNRevision.create(lArray[0]), l2, l3, sVNRepository, null);
            if (sVNURL2 != null) {
                sVNRepository.setLocation(sVNURL2, false);
            }
        }
        finally {
            if (bl2) {
                sVNRepository.closeSession();
            }
        }
        return map;
    }

    private int findNearestAncestor(Object[] objectArray, boolean bl2, File file) {
        if (objectArray == null) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string;
            SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)objectArray[i2];
            String string2 = sVNMergeDriver$MergePath.myPath.getAbsolutePath().replace(File.separatorChar, '/');
            if (!SVNPathUtil.isAncestor(string2, string = file.getAbsolutePath().replace(File.separatorChar, '/')) || string2.equals(string) && !bl2) continue;
            n2 = i2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getHistoryAsMergeInfo(SVNURL sVNURL, File file, SVNRevision sVNRevision, long l2, long l3, SVNRepository sVNRepository, SVNWCAccess sVNWCAccess) {
        long[] lArray = new long[]{-1L};
        sVNURL = this.deriveLocation(file, sVNURL, lArray, sVNRevision, sVNRepository, sVNWCAccess);
        boolean bl2 = false;
        try {
            if (sVNRepository == null) {
                sVNRepository = this.createRepository(sVNURL, null, null, false);
                bl2 = true;
            }
            if (!SVNRevision.isValidRevisionNumber(l2)) {
                l2 = lArray[0];
            }
            if (!SVNRevision.isValidRevisionNumber(l3)) {
                l3 = 0L;
            }
            List list = sVNRepository.getLocationSegments("", lArray[0], l2, l3);
            Map map = SVNMergeDriver.getMergeInfoFromSegments(list);
            return map;
        }
        finally {
            if (bl2) {
                sVNRepository.closeSession();
            }
        }
    }

    public static Map getMergeInfoFromSegments(Collection collection) {
        LinkedList<SVNMergeRange> linkedList;
        TreeMap treeMap = new TreeMap();
        for (Object object : collection) {
            if (((SVNLocationSegment)object).getPath() == null) continue;
            String string = ((SVNLocationSegment)object).getPath();
            linkedList = (LinkedList<SVNMergeRange>)treeMap.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<SVNMergeRange>();
                treeMap.put(string, linkedList);
            }
            SVNMergeRange sVNMergeRange = new SVNMergeRange(Math.max(((SVNLocationSegment)object).getStartRevision() - 1L, 0L), ((SVNLocationSegment)object).getEndRevision(), true);
            linkedList.add(sVNMergeRange);
        }
        TreeMap treeMap2 = new TreeMap();
        for (String string : treeMap.keySet()) {
            linkedList = (Collection)treeMap.get(string);
            treeMap2.put(string, SVNMergeRangeList.fromCollection(linkedList));
        }
        return treeMap2;
    }

    private void removeAbsentChildren(File file, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)iterator.next();
            String string = file.getAbsolutePath().replace(File.separatorChar, '/');
            String string2 = sVNMergeDriver$MergePath.myPath.getAbsolutePath().replace(File.separatorChar, '/');
            if (sVNMergeDriver$MergePath == null || !sVNMergeDriver$MergePath.myIsAbsent && !sVNMergeDriver$MergePath.myIsScheduledForDeletion || !SVNPathUtil.isAncestor(string, string2)) continue;
            if (this.mySkippedPaths != null) {
                this.mySkippedPaths.remove(sVNMergeDriver$MergePath.myPath);
            }
            iterator.remove();
        }
    }

    private void removeFirstRangeFromRemainingRanges(long l2, List list) {
        for (SVNMergeDriver$MergePath sVNMergeDriver$MergePath : list) {
            SVNMergeRange[] sVNMergeRangeArray;
            SVNMergeRange sVNMergeRange;
            if (sVNMergeDriver$MergePath == null || sVNMergeDriver$MergePath.myIsAbsent || sVNMergeDriver$MergePath.myRemainingRanges.isEmpty() || (sVNMergeRange = (sVNMergeRangeArray = sVNMergeDriver$MergePath.myRemainingRanges.getRanges())[0]).getEndRevision() != l2) continue;
            SVNMergeRange[] sVNMergeRangeArray2 = new SVNMergeRange[sVNMergeRangeArray.length - 1];
            System.arraycopy(sVNMergeRangeArray, 1, sVNMergeRangeArray2, 0, sVNMergeRangeArray.length - 1);
            sVNMergeDriver$MergePath.myRemainingRanges = new SVNMergeRangeList(sVNMergeRangeArray2);
        }
    }

    private SVNMergeRangeList removeNoOpMergeRanges(SVNRepository sVNRepository, SVNMergeRangeList sVNMergeRangeList) {
        long l2 = -1L;
        long l3 = -1L;
        SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList.getRanges();
        for (int i2 = 0; i2 < sVNMergeRangeList.getSize(); ++i2) {
            SVNMergeRange sVNMergeRange = sVNMergeRangeArray[i2];
            long l4 = Math.max(sVNMergeRange.getStartRevision(), sVNMergeRange.getEndRevision());
            long l5 = Math.min(sVNMergeRange.getStartRevision(), sVNMergeRange.getEndRevision());
            if (!SVNRevision.isValidRevisionNumber(l3) || l4 > l3) {
                l3 = l4;
            }
            if (SVNRevision.isValidRevisionNumber(l2) && l5 >= l2) continue;
            l2 = l5;
        }
        LinkedList linkedList = new LinkedList();
        sVNRepository.log(new String[]{""}, l3, l2, false, false, 0L, false, new String[0], new SVNMergeDriver$2(this, linkedList));
        long l6 = -1L;
        long l7 = -1L;
        if (linkedList.size() > 0) {
            l6 = (Long)linkedList.get(0);
            l7 = (Long)linkedList.get(linkedList.size() - 1);
        }
        LinkedList<SVNMergeRange> linkedList2 = new LinkedList<SVNMergeRange>();
        block1: for (int i3 = 0; i3 < sVNMergeRangeList.getSize(); ++i3) {
            SVNMergeRange sVNMergeRange = sVNMergeRangeArray[i3];
            long l8 = Math.min(sVNMergeRange.getStartRevision(), sVNMergeRange.getEndRevision()) + 1L;
            long l9 = Math.max(sVNMergeRange.getStartRevision(), sVNMergeRange.getEndRevision());
            if (l8 > l6 || l9 < l7) continue;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                long l10 = (Long)iterator.next();
                if (l10 < l8 || l10 > l9) continue;
                linkedList2.add(sVNMergeRange);
                continue block1;
            }
        }
        return SVNMergeRangeList.fromCollection(linkedList2);
    }

    private SVNMergeRangeList filterNaturalHistoryFromMergeInfo(String string, Map map, SVNMergeRange sVNMergeRange) {
        SVNMergeRangeList sVNMergeRangeList;
        SVNMergeRangeList sVNMergeRangeList2 = new SVNMergeRangeList(sVNMergeRange.dup());
        SVNMergeRangeList sVNMergeRangeList3 = null;
        if (map != null && sVNMergeRange.getStartRevision() < sVNMergeRange.getEndRevision() && (sVNMergeRangeList = (SVNMergeRangeList)map.get(string)) != null) {
            sVNMergeRangeList3 = sVNMergeRangeList2.diff(sVNMergeRangeList, false);
        }
        if (sVNMergeRangeList3 == null) {
            sVNMergeRangeList3 = sVNMergeRangeList2;
        }
        return sVNMergeRangeList3;
    }

    private void sliceRemainingRanges(List list, boolean bl2, long l2) {
        for (SVNMergeDriver$MergePath sVNMergeDriver$MergePath : list) {
            if (sVNMergeDriver$MergePath == null || sVNMergeDriver$MergePath.myIsAbsent || sVNMergeDriver$MergePath.myRemainingRanges.isEmpty()) continue;
            SVNMergeRange[] sVNMergeRangeArray = sVNMergeDriver$MergePath.myRemainingRanges.getRanges();
            SVNMergeRange sVNMergeRange = sVNMergeRangeArray[0];
            if ((!bl2 || sVNMergeRange.getStartRevision() <= l2 || sVNMergeRange.getEndRevision() >= l2) && (bl2 || sVNMergeRange.getStartRevision() >= l2 || sVNMergeRange.getEndRevision() <= l2)) continue;
            SVNMergeRange sVNMergeRange2 = new SVNMergeRange(sVNMergeRange.getStartRevision(), l2, sVNMergeRange.isInheritable());
            SVNMergeRange sVNMergeRange3 = new SVNMergeRange(l2, sVNMergeRange.getEndRevision(), sVNMergeRange.isInheritable());
            SVNMergeRange[] sVNMergeRangeArray2 = new SVNMergeRange[sVNMergeRangeArray.length + 1];
            sVNMergeRangeArray2[0] = sVNMergeRange2;
            sVNMergeRangeArray2[1] = sVNMergeRange3;
            System.arraycopy(sVNMergeRangeArray, 1, sVNMergeRangeArray2, 2, sVNMergeRangeArray.length - 1);
            sVNMergeDriver$MergePath.myRemainingRanges = new SVNMergeRangeList(sVNMergeRangeArray2);
        }
    }

    private long getMostInclusiveEndRevision(List list, boolean bl2) {
        long l2 = -1L;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)list.get(i2);
            if (sVNMergeDriver$MergePath == null || sVNMergeDriver$MergePath.myIsAbsent || sVNMergeDriver$MergePath.myRemainingRanges.getSize() <= 0) continue;
            SVNMergeRange[] sVNMergeRangeArray = sVNMergeDriver$MergePath.myRemainingRanges.getRanges();
            SVNMergeRange sVNMergeRange = sVNMergeRangeArray[0];
            if (SVNRevision.isValidRevisionNumber(l2) && (!bl2 || sVNMergeRange.getEndRevision() <= l2) && (bl2 || sVNMergeRange.getEndRevision() >= l2)) continue;
            l2 = sVNMergeRange.getEndRevision();
        }
        return l2;
    }

    private void inheritImplicitMergeinfoFromParent(SVNMergeDriver$MergePath sVNMergeDriver$MergePath, SVNMergeDriver$MergePath sVNMergeDriver$MergePath2, long l2, long l3, SVNRepository sVNRepository) {
        Object object;
        Object object2;
        if (sVNMergeDriver$MergePath.myImplicitMergeInfo == null) {
            object2 = this.myWCAccess.getEntry(sVNMergeDriver$MergePath.myPath, false);
            object = this.getFullMergeInfo((SVNEntry)object2, false, true, null, SVNMergeInfoInheritance.INHERITED, sVNRepository, sVNMergeDriver$MergePath.myPath, Math.max(l2, l3), Math.min(l2, l3));
            sVNMergeDriver$MergePath.myImplicitMergeInfo = object[1];
        }
        sVNMergeDriver$MergePath2.myImplicitMergeInfo = new TreeMap();
        object2 = SVNPathUtil.getCommonPathAncestor(sVNMergeDriver$MergePath.myPath.getAbsolutePath().replace(File.separatorChar, '/'), sVNMergeDriver$MergePath2.myPath.getAbsolutePath().replace(File.separatorChar, '/'));
        object = SVNPathUtil.getPathAsChild((String)object2, sVNMergeDriver$MergePath2.myPath.getAbsolutePath().replace(File.separatorChar, '/'));
        if (((String)object).startsWith("/")) {
            object = ((String)object).substring(1);
        }
        SVNMergeInfoUtil.adjustMergeInfoSourcePaths(sVNMergeDriver$MergePath2.myImplicitMergeInfo, (String)object, sVNMergeDriver$MergePath.myImplicitMergeInfo);
    }

    private void ensureImplicitMergeinfo(SVNMergeDriver$MergePath sVNMergeDriver$MergePath, SVNMergeDriver$MergePath sVNMergeDriver$MergePath2, boolean bl2, SVNEntry sVNEntry, long l2, long l3, SVNRepository sVNRepository) {
        if (sVNMergeDriver$MergePath2.myImplicitMergeInfo != null) {
            return;
        }
        if (bl2) {
            this.inheritImplicitMergeinfoFromParent(sVNMergeDriver$MergePath, sVNMergeDriver$MergePath2, l2, l3, sVNRepository);
        } else {
            boolean[] blArray = new boolean[]{false};
            Map[] mapArray = this.getFullMergeInfo(sVNEntry, false, true, blArray, SVNMergeInfoInheritance.INHERITED, sVNRepository, sVNMergeDriver$MergePath2.myPath, Math.max(l2, l3), Math.min(l2, l3));
            sVNMergeDriver$MergePath2.myImplicitMergeInfo = mapArray[1];
        }
    }

    private long getMostInclusiveStartRevision(List list, boolean bl2) {
        long l2 = -1L;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)list.get(i2);
            if (sVNMergeDriver$MergePath == null || sVNMergeDriver$MergePath.myIsAbsent || sVNMergeDriver$MergePath.myRemainingRanges.isEmpty()) continue;
            SVNMergeRange[] sVNMergeRangeArray = sVNMergeDriver$MergePath.myRemainingRanges.getRanges();
            SVNMergeRange sVNMergeRange = sVNMergeRangeArray[0];
            if (i2 == 0 && sVNMergeRange.getStartRevision() == sVNMergeRange.getEndRevision() || SVNRevision.isValidRevisionNumber(l2) && (!bl2 || sVNMergeRange.getStartRevision() <= l2) && (bl2 || sVNMergeRange.getStartRevision() >= l2)) continue;
            l2 = sVNMergeRange.getStartRevision();
        }
        return l2;
    }

    private void populateRemainingRanges(List list, SVNURL sVNURL, SVNURL sVNURL2, long l2, SVNURL sVNURL3, long l3, boolean bl2, SVNRepository sVNRepository, String string) {
        if (!bl2 || this.myIsRecordOnly) {
            int n2 = 0;
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Map[] mapArray;
                SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)listIterator.next();
                SVNMergeRange sVNMergeRange = new SVNMergeRange(l2, l3, true);
                sVNMergeDriver$MergePath.myRemainingRanges = new SVNMergeRangeList(sVNMergeRange);
                SVNEntry sVNEntry = this.myWCAccess.getVersionedEntry(sVNMergeDriver$MergePath.myPath, false);
                if (n2 == 0) {
                    boolean[] blArray = new boolean[]{false};
                    mapArray = this.getFullMergeInfo(sVNEntry, false, true, blArray, SVNMergeInfoInheritance.INHERITED, sVNRepository, sVNMergeDriver$MergePath.myPath, Math.max(l2, l3), Math.min(l2, l3));
                    sVNMergeDriver$MergePath.myImplicitMergeInfo = mapArray[1];
                } else {
                    int n3 = this.findNearestAncestor(this.myChildrenWithMergeInfo.toArray(), false, sVNMergeDriver$MergePath.myPath);
                    mapArray = (Map[])this.myChildrenWithMergeInfo.get(n3);
                    boolean bl3 = mapArray != null && !sVNMergeDriver$MergePath.myIsSwitched;
                    this.ensureImplicitMergeinfo((SVNMergeDriver$MergePath)mapArray, sVNMergeDriver$MergePath, bl3, sVNEntry, l2, l3, sVNRepository);
                }
                ++n2;
            }
            return;
        }
        long[] lArray = new long[2];
        this.findGapsInMergeSourceHistory(lArray, string, sVNURL2, l2, sVNURL3, l3, sVNRepository);
        if (lArray[0] >= 0L && lArray[1] >= 0L) {
            this.myImplicitSrcGap = new SVNMergeRangeList(lArray[0], lArray[1], true);
        }
        int n4 = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object[] objectArray;
            int n5;
            SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)listIterator.next();
            if (sVNMergeDriver$MergePath == null || sVNMergeDriver$MergePath.myIsAbsent) {
                ++n4;
                continue;
            }
            String string2 = null;
            string2 = this.myTarget.equals(sVNMergeDriver$MergePath.myPath) ? "" : SVNPathUtil.getRelativePath(this.myTarget.getAbsolutePath(), sVNMergeDriver$MergePath.myPath.getAbsolutePath());
            SVNMergeDriver$MergePath sVNMergeDriver$MergePath2 = null;
            SVNURL sVNURL4 = sVNURL2.appendPath(string2, false);
            SVNURL sVNURL5 = sVNURL3.appendPath(string2, false);
            SVNEntry sVNEntry = this.myWCAccess.getVersionedEntry(sVNMergeDriver$MergePath.myPath, false);
            boolean[] blArray = new boolean[]{false};
            Map[] mapArray = this.getFullMergeInfo(sVNEntry, true, n4 == 0, blArray, SVNMergeInfoInheritance.INHERITED, sVNRepository, sVNMergeDriver$MergePath.myPath, Math.max(l2, l3), Math.min(l2, l3));
            sVNMergeDriver$MergePath.myPreMergeMergeInfo = mapArray[0];
            if (n4 == 0) {
                sVNMergeDriver$MergePath.myImplicitMergeInfo = mapArray[1];
            }
            sVNMergeDriver$MergePath.myIsIndirectMergeInfo = blArray[0];
            if (n4 > 0 && (n5 = this.findNearestAncestor(objectArray = list.toArray(), false, sVNMergeDriver$MergePath.myPath)) >= 0 && n5 < objectArray.length) {
                sVNMergeDriver$MergePath2 = (SVNMergeDriver$MergePath)objectArray[n5];
            }
            boolean bl4 = sVNMergeDriver$MergePath2 != null && !sVNMergeDriver$MergePath.myIsSwitched;
            this.calculateRemainingRanges(sVNMergeDriver$MergePath2, sVNMergeDriver$MergePath, sVNURL, sVNURL4, l2, sVNURL5, l3, sVNMergeDriver$MergePath.myPreMergeMergeInfo, this.myImplicitSrcGap, n4 > 0, bl4, sVNEntry, sVNRepository);
            if (sVNMergeDriver$MergePath.myRemainingRanges.getSize() > 0 && this.myImplicitSrcGap != null) {
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                if (l2 > l3) {
                    sVNMergeDriver$MergePath.myRemainingRanges.reverse();
                }
                for (int i2 = 0; i2 < sVNMergeDriver$MergePath.myRemainingRanges.getSize(); ++i2) {
                    long l4 = sVNMergeDriver$MergePath.myRemainingRanges.getRanges()[i2].getStartRevision();
                    long l5 = sVNMergeDriver$MergePath.myRemainingRanges.getRanges()[i2].getEndRevision();
                    if (l4 <= lArray[0] && lArray[1] < l5 || l4 < lArray[0] && lArray[1] <= l5) {
                        bl5 = true;
                        break;
                    }
                    if (lArray[0] == l4 && lArray[1] == l5) {
                        bl6 = true;
                        break;
                    }
                    if (lArray[0] > l5 || l4 > lArray[1]) continue;
                    bl7 = true;
                    break;
                }
                if (!bl5) {
                    if (bl7) {
                        sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.merge(this.myImplicitSrcGap);
                    } else if (bl6) {
                        sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.diff(this.myImplicitSrcGap, false);
                    }
                }
                if (l2 > l3) {
                    sVNMergeDriver$MergePath.myRemainingRanges.reverse();
                }
            }
            ++n4;
        }
    }

    private void removeNoOpSubtreeRanges(SVNURL sVNURL, long l2, SVNURL sVNURL2, long l3, SVNRepository sVNRepository) {
        Object object;
        Comparable comparable;
        if (l2 > l3) {
            return;
        }
        if (this.myChildrenWithMergeInfo.size() < 2) {
            return;
        }
        Iterator iterator = this.myChildrenWithMergeInfo.iterator();
        SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)iterator.next();
        SVNMergeRangeList sVNMergeRangeList = new SVNMergeRangeList(new SVNMergeRange(Math.min(l2, l3), Math.max(l2, l3), true));
        SVNMergeRangeList sVNMergeRangeList2 = sVNMergeRangeList.remove(sVNMergeDriver$MergePath.myRemainingRanges, false);
        if (sVNMergeRangeList2.isEmpty()) {
            return;
        }
        SVNMergeRangeList sVNMergeRangeList3 = new SVNMergeRangeList(new SVNMergeRange[0]);
        while (iterator.hasNext()) {
            comparable = (SVNMergeDriver$MergePath)iterator.next();
            if (((SVNMergeDriver$MergePath)comparable).myRemainingRanges == null || ((SVNMergeDriver$MergePath)comparable).myRemainingRanges.isEmpty()) continue;
            sVNMergeRangeList3 = sVNMergeRangeList3.merge(((SVNMergeDriver$MergePath)comparable).myRemainingRanges);
        }
        if (sVNMergeRangeList3.isEmpty()) {
            return;
        }
        if ((sVNMergeRangeList2 = sVNMergeRangeList2.intersect(sVNMergeRangeList3, false)).isEmpty()) {
            return;
        }
        comparable = sVNMergeRangeList2.getRanges()[0];
        SVNMergeRange sVNMergeRange = sVNMergeRangeList2.getRanges()[sVNMergeRangeList2.getSize() - 1];
        SVNEntry sVNEntry = this.myWCAccess.getEntry(this.myTarget, false);
        if (sVNEntry == null) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED, "''{0}'' is not under version control", (Object)this.myTarget);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = sVNEntry.getRepositoryRootURL();
        SVNMergeDriver$NoopLogHandler sVNMergeDriver$NoopLogHandler = new SVNMergeDriver$NoopLogHandler(this, null);
        SVNMergeDriver$NoopLogHandler.access$502(sVNMergeDriver$NoopLogHandler, this.getPathRelativeToRoot(null, sVNURL2, (SVNURL)object, this.myWCAccess, null));
        SVNMergeDriver$NoopLogHandler.access$602(sVNMergeDriver$NoopLogHandler, new SVNMergeRangeList(new SVNMergeRange[0]));
        SVNMergeDriver$NoopLogHandler.access$702(sVNMergeDriver$NoopLogHandler, new SVNMergeRangeList(new SVNMergeRange[0]));
        sVNRepository.log(new String[]{""}, ((SVNMergeRange)comparable).getStartRevision() + 1L, sVNMergeRange.getEndRevision(), true, true, -1L, false, null, sVNMergeDriver$NoopLogHandler);
        SVNMergeRangeList sVNMergeRangeList4 = new SVNMergeRangeList(((SVNMergeRange)comparable).getStartRevision(), sVNMergeRange.getEndRevision(), true);
        sVNMergeRangeList4 = sVNMergeRangeList4.remove(SVNMergeDriver$NoopLogHandler.access$700(sVNMergeDriver$NoopLogHandler), false);
        SVNMergeDriver$NoopLogHandler.access$602(sVNMergeDriver$NoopLogHandler, SVNMergeDriver$NoopLogHandler.access$600(sVNMergeDriver$NoopLogHandler).merge(sVNMergeRangeList4));
        Iterator iterator2 = this.myChildrenWithMergeInfo.iterator();
        if (iterator2.hasNext()) {
            iterator2.next();
        }
        while (iterator2.hasNext()) {
            SVNMergeDriver$MergePath sVNMergeDriver$MergePath2 = (SVNMergeDriver$MergePath)iterator2.next();
            if (sVNMergeDriver$MergePath2.myRemainingRanges == null || sVNMergeDriver$MergePath2.myRemainingRanges.isEmpty()) continue;
            sVNMergeDriver$MergePath2.myRemainingRanges = sVNMergeDriver$MergePath2.myRemainingRanges.remove(SVNMergeDriver$NoopLogHandler.access$600(sVNMergeDriver$NoopLogHandler), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISVNReusableEditor driveMergeReportEditor(File file, SVNURL sVNURL, long l2, SVNURL sVNURL2, long l3, List list, boolean bl2, SVNDepth sVNDepth, SVNAdminArea sVNAdminArea, SVNMergeCallback sVNMergeCallback, ISVNReusableEditor iSVNReusableEditor) {
        Object object;
        Object object2;
        boolean bl3 = this.isHonorMergeInfo();
        long l4 = l2;
        long l5 = l2;
        if (bl3) {
            l5 = l3;
            if (list != null && !list.isEmpty()) {
                object2 = (SVNMergeDriver$MergePath)list.get(0);
                object = ((SVNMergeDriver$MergePath)object2).myRemainingRanges;
                if (object != null && !((SVNMergeRangeList)object).isEmpty()) {
                    SVNMergeRange[] sVNMergeRangeArray = ((SVNMergeRangeList)object).getRanges();
                    SVNMergeRange sVNMergeRange = sVNMergeRangeArray[0];
                    l5 = !bl2 && sVNMergeRange.getStartRevision() > l3 || bl2 && sVNMergeRange.getStartRevision() < l3 ? l3 : sVNMergeRange.getStartRevision();
                }
            }
        }
        iSVNReusableEditor = this.getMergeReportEditor(l4, l3, sVNAdminArea, sVNDepth, sVNMergeCallback, iSVNReusableEditor);
        object2 = this.ensureSessionURL(this.myRepository2, sVNURL);
        try {
            object = sVNDepth;
            long l6 = l5;
            String string = file.getAbsolutePath().replace(File.separatorChar, '/');
            this.myRepository1.diff(sVNURL2, l3, l3, null, this.myIsIgnoreAncestry, sVNDepth, true, (ISVNReporterBaton)new SVNMergeDriver$3(this, l6, (SVNDepth)object, bl3, list, bl2, l3, string), SVNCancellableEditor.newInstance(iSVNReusableEditor, this, this.getDebugLog()));
        }
        finally {
            if (object2 != null) {
                this.myRepository2.setLocation((SVNURL)object2, false);
            }
            iSVNReusableEditor.cleanup();
        }
        this.sleepForTimeStamp();
        if (this.myConflictedPaths == null) {
            this.myConflictedPaths = sVNMergeCallback.getConflictedPaths();
        }
        return iSVNReusableEditor;
    }

    @Override
    public ISVNReusableEditor getMergeReportEditor(long l2, long l3, SVNAdminArea sVNAdminArea, SVNDepth sVNDepth, AbstractDiffCallback abstractDiffCallback, ISVNReusableEditor iSVNReusableEditor) {
        if (iSVNReusableEditor == null) {
            iSVNReusableEditor = new SVNRemoteDiffEditor(sVNAdminArea, sVNAdminArea.getRoot(), abstractDiffCallback, this.myRepository2, l2, l3, this.myIsDryRun, this, this);
        } else {
            iSVNReusableEditor.reset(l2, l3);
        }
        return iSVNReusableEditor;
    }

    private SVNErrorMessage makeMergeConflictError(File file, SVNMergeRange sVNMergeRange) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "One or more conflicts were produced while merging r{0}:{1} into\n''{2}'' --\nresolve all conflicts and rerun the merge to apply the remaining\nunmerged revisions", Long.toString(sVNMergeRange.getStartRevision()), Long.toString(sVNMergeRange.getEndRevision()), file);
        return sVNErrorMessage;
    }

    private List getMergeInfoPaths(List list, String string, SVNEntry sVNEntry, SVNURL sVNURL, long l2, long l3, boolean bl2, SVNRepository sVNRepository, SVNDepth sVNDepth) {
        List list2 = list == null ? new LinkedList() : list;
        ISVNEntryHandler iSVNEntryHandler = this.getMergeInfoEntryHandler(string, sVNURL, l2, l3, sVNRepository, sVNDepth, list2);
        if (sVNEntry.isFile()) {
            iSVNEntryHandler.handleEntry(this.myTarget, sVNEntry);
        } else {
            this.myWCAccess.walkEntries(this.myTarget, iSVNEntryHandler, true, bl2 ? sVNDepth : SVNDepth.EMPTY);
        }
        if (bl2 && SVNDepth.EMPTY.compareTo(sVNDepth) < 0) {
            Collections.sort(list2);
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                Object object;
                SVNEntry sVNEntry2;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                SVNMergeDriver$MergePath sVNMergeDriver$MergePath = (SVNMergeDriver$MergePath)list2.get(i2);
                if (sVNMergeDriver$MergePath.myHasNonInheritableMergeInfo) {
                    object5 = this.myWCAccess.probeTry(sVNMergeDriver$MergePath.myPath, true, -1);
                    Iterator iterator = ((SVNAdminArea)object5).entries(false);
                    while (iterator.hasNext()) {
                        object4 = (SVNEntry)iterator.next();
                        if (((SVNAdminArea)object5).getThisDirName().equals(((SVNEntry)object4).getName()) || list2.contains(object3 = new SVNMergeDriver$MergePath(this, (File)(object2 = ((SVNAdminArea)object5).getFile(((SVNEntry)object4).getName())))) || sVNDepth == SVNDepth.FILES && ((sVNEntry2 = this.myWCAccess.getEntry((File)object2, false)) == null || !sVNEntry2.isFile())) continue;
                        list2.add(object3);
                        Collections.sort(list2);
                        if (this.myIsDryRun || !this.myIsSameRepository) continue;
                        sVNEntry2 = this.myWCAccess.getVersionedEntry(((SVNMergeDriver$MergePath)object3).myPath, false);
                        object = this.getWCMergeInfo(((SVNMergeDriver$MergePath)object3).myPath, sVNEntry2, this.myTarget, SVNMergeInfoInheritance.NEAREST_ANCESTOR, false, new boolean[1]);
                        SVNPropertiesManager.recordWCMergeInfo((File)object2, (Map)object, this.myWCAccess);
                    }
                }
                if (!sVNMergeDriver$MergePath.myIsAbsent && (!sVNMergeDriver$MergePath.myIsSwitched || this.myTarget.equals(sVNMergeDriver$MergePath.myPath))) continue;
                object5 = sVNMergeDriver$MergePath.myPath.getParentFile();
                int n2 = list2.indexOf(new SVNMergeDriver$MergePath(this, (File)object5));
                Object object6 = object4 = n2 != -1 ? (SVNMergeDriver$MergePath)list2.get(n2) : null;
                if (object4 != null) {
                    ((SVNMergeDriver$MergePath)object4).myHasMissingChildren = true;
                } else {
                    object4 = new SVNMergeDriver$MergePath(this, (File)object5);
                    ((SVNMergeDriver$MergePath)object4).myHasMissingChildren = true;
                    list2.add(object4);
                    Collections.sort(list2);
                    ++i2;
                }
                object2 = this.myWCAccess.probeTry((File)object5, true, -1);
                object3 = ((SVNAdminArea)object2).entries(false);
                while (object3.hasNext()) {
                    SVNEntry sVNEntry3;
                    SVNMergeDriver$MergePath sVNMergeDriver$MergePath2;
                    sVNEntry2 = (SVNEntry)object3.next();
                    if (((SVNAdminArea)object2).getThisDirName().equals(sVNEntry2.getName()) || list2.contains(sVNMergeDriver$MergePath2 = new SVNMergeDriver$MergePath(this, (File)(object = ((SVNAdminArea)object2).getFile(sVNEntry2.getName())))) || sVNDepth == SVNDepth.FILES && ((sVNEntry3 = this.myWCAccess.getEntry((File)object, false)) == null || !sVNEntry3.isFile())) continue;
                    list2.add(sVNMergeDriver$MergePath2);
                    Collections.sort(list2);
                }
            }
        }
        return list2;
    }

    @Override
    public ISVNEntryHandler getMergeInfoEntryHandler(String string, SVNURL sVNURL, long l2, long l3, SVNRepository sVNRepository, SVNDepth sVNDepth, List list) {
        return new SVNMergeDriver$MergeInfoFetcher(this, sVNDepth, list);
    }

    private boolean notifySingleFileMerge(File file, SVNEventAction sVNEventAction, SVNStatusType sVNStatusType, SVNStatusType sVNStatusType2, SVNEvent sVNEvent, boolean bl2) {
        SVNEvent sVNEvent2;
        SVNEventAction sVNEventAction2 = null;
        if (sVNStatusType == SVNStatusType.MISSING) {
            sVNEventAction2 = sVNEventAction;
            sVNEventAction = SVNEventAction.SKIP;
        }
        if (this.isOperativeNotification(sVNEvent2 = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, sVNStatusType, sVNStatusType2, SVNStatusType.LOCK_INAPPLICABLE, sVNEventAction, sVNEventAction2, null, null)) && sVNEvent != null && !bl2) {
            this.handleEvent(sVNEvent, -1.0);
            bl2 = true;
        }
        this.handleEvent(sVNEvent2, -1.0);
        return bl2;
    }

    private boolean isOperativeNotification(SVNEvent sVNEvent) {
        return sVNEvent.getContentsStatus() == SVNStatusType.CONFLICTED || sVNEvent.getContentsStatus() == SVNStatusType.MERGED || sVNEvent.getContentsStatus() == SVNStatusType.CHANGED || sVNEvent.getPropertiesStatus() == SVNStatusType.CONFLICTED || sVNEvent.getPropertiesStatus() == SVNStatusType.MERGED || sVNEvent.getPropertiesStatus() == SVNStatusType.CHANGED || sVNEvent.getAction() == SVNEventAction.UPDATE_ADD || sVNEvent.getAction() == SVNEventAction.TREE_CONFLICT;
    }

    private void calculateMergeInheritance(SVNMergeRangeList sVNMergeRangeList, SVNEntry sVNEntry, boolean bl2, boolean bl3, SVNDepth sVNDepth) {
        if (sVNEntry.isFile()) {
            sVNMergeRangeList.setInheritable(true);
        } else if (sVNEntry.isDirectory()) {
            if (bl2) {
                if (bl3 || sVNDepth == SVNDepth.FILES || sVNDepth == SVNDepth.EMPTY) {
                    sVNMergeRangeList.setInheritable(false);
                } else {
                    sVNMergeRangeList.setInheritable(true);
                }
            } else if (bl3 || sVNDepth == SVNDepth.IMMEDIATES) {
                sVNMergeRangeList.setInheritable(false);
            } else {
                sVNMergeRangeList.setInheritable(true);
            }
        }
    }

    private void recordSkips(String string, SVNEntry sVNEntry, boolean bl2) {
        int n2;
        int n3 = n2 = this.mySkippedPaths != null ? this.mySkippedPaths.size() : 0;
        if (n2 > 0) {
            TreeMap<File, SVNMergeRangeList> treeMap = new TreeMap<File, SVNMergeRangeList>();
            for (File file : this.mySkippedPaths) {
                SVNStatus sVNStatus = SVNStatusUtil.getStatus(file, this.myWCAccess);
                if (sVNStatus.getContentsStatus() == SVNStatusType.STATUS_NONE || sVNStatus.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED) continue;
                treeMap.put(file, new SVNMergeRangeList(new SVNMergeRange[0]));
            }
            this.updateWCMergeInfo(null, this.myTarget, string, sVNEntry, treeMap, bl2);
        }
    }

    private void updateWCMergeInfo(Map map, File file, String string, SVNEntry sVNEntry, Map map2, boolean bl2) {
        for (Map.Entry entry : map2.entrySet()) {
            Object object;
            Object object2;
            File file2 = (File)entry.getKey();
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)entry.getValue();
            Map<String, Object> map3 = null;
            try {
                object2 = sVNEntry.getAdminArea().getWCAccess().getEntry(file2, false);
                if (object2 != null && ((SVNEntry)object2).isDirectory()) {
                    ((SVNEntry)object2).getAdminArea().getWCAccess().retrieve(file2);
                }
                map3 = SVNPropertiesManager.parseMergeInfo(file2, sVNEntry, false);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) continue;
                throw sVNException;
            }
            if (map3 == null && sVNMergeRangeList.isEmpty()) {
                map3 = this.getWCMergeInfo(file2, sVNEntry, null, SVNMergeInfoInheritance.NEAREST_ANCESTOR, true, new boolean[1]);
            }
            if (map3 == null) {
                map3 = new TreeMap();
            }
            object2 = file.getAbsolutePath();
            object2 = ((String)object2).replace(File.separatorChar, '/');
            String string2 = file2.getAbsolutePath();
            string2 = string2.replace(File.separatorChar, '/');
            String string3 = null;
            if (((String)object2).length() < string2.length()) {
                object = string2.substring(((String)object2).length());
                if (((String)object).startsWith("/")) {
                    object = ((String)object).substring(1);
                }
                string3 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, (String)object));
            } else {
                string3 = string;
            }
            object = (SVNMergeRangeList)map3.get(string3);
            if (object == null) {
                object = new SVNMergeRangeList(new SVNMergeRange[0]);
            }
            if (bl2) {
                sVNMergeRangeList = sVNMergeRangeList.dup();
                sVNMergeRangeList = sVNMergeRangeList.reverse();
                object = ((SVNMergeRangeList)object).diff(sVNMergeRangeList, false);
            } else {
                object = ((SVNMergeRangeList)object).merge(sVNMergeRangeList);
            }
            map3.put(string3, object);
            if (bl2 && map3.isEmpty()) {
                map3 = null;
            }
            SVNMergeInfoUtil.removeEmptyRangeLists(map3);
            if (map != null) {
                Map map4 = (Map)map.get(string2);
                if (map4 != null) {
                    map3 = SVNMergeInfoUtil.mergeMergeInfos(map3, map4);
                }
                map.put(string2, map3);
                continue;
            }
            try {
                SVNPropertiesManager.recordWCMergeInfo(file2, map3, this.myWCAccess);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.ENTRY_NOT_FOUND) {
                    throw sVNException;
                }
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, sVNException);
            }
        }
    }

    public void calculateRemainingRanges(SVNMergeDriver$MergePath sVNMergeDriver$MergePath, SVNMergeDriver$MergePath sVNMergeDriver$MergePath2, SVNURL sVNURL, SVNURL sVNURL2, long l2, SVNURL sVNURL3, long l3, Map map, SVNMergeRangeList sVNMergeRangeList, boolean bl2, boolean bl3, SVNEntry sVNEntry, SVNRepository sVNRepository) {
        block7: {
            Object object;
            SVNBasicDelegate$SVNRepositoryLocation[] sVNBasicDelegate$SVNRepositoryLocationArray;
            SVNURL sVNURL4 = l2 < l3 ? sVNURL3 : sVNURL2;
            Map map2 = null;
            String string = this.getPathRelativeToRoot(null, sVNURL4, sVNURL, null, sVNRepository);
            if (sVNMergeRangeList != null && sVNMergeDriver$MergePath2.myPreMergeMergeInfo != null) {
                sVNBasicDelegate$SVNRepositoryLocationArray = (SVNBasicDelegate$SVNRepositoryLocation[])sVNMergeDriver$MergePath2.myPreMergeMergeInfo.get(string);
                if (sVNBasicDelegate$SVNRepositoryLocationArray != null) {
                    object = new TreeMap<String, SVNMergeRangeList>();
                    object.put(string, sVNMergeRangeList);
                    map2 = SVNMergeInfoUtil.removeMergeInfo(object, map, false);
                }
            } else {
                map2 = map;
            }
            this.filterMergedRevisions(sVNMergeDriver$MergePath, sVNMergeDriver$MergePath2, sVNEntry, sVNRepository, string, map2, l2, l3, bl3);
            if ((sVNMergeDriver$MergePath2.myRemainingRanges == null || sVNMergeDriver$MergePath2.myRemainingRanges.isEmpty()) && l3 < l2 && sVNEntry.getRevision() <= l3) {
                sVNBasicDelegate$SVNRepositoryLocationArray = null;
                try {
                    sVNBasicDelegate$SVNRepositoryLocationArray = this.getLocations(sVNURL2, null, sVNRepository, SVNRevision.create(l2), SVNRevision.create(sVNEntry.getRevision()), SVNRevision.UNDEFINED);
                    object = sVNBasicDelegate$SVNRepositoryLocationArray[0].getURL();
                    if (((SVNURL)object).equals(sVNEntry.getSVNURL())) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reverse-merge a range from a path's own future history; try updating first");
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
                    }
                }
                catch (SVNException sVNException) {
                    SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
                    if (sVNErrorCode == SVNErrorCode.FS_NOT_FOUND || sVNErrorCode == SVNErrorCode.RA_DAV_PATH_NOT_FOUND || sVNErrorCode == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block7;
                    throw sVNException;
                }
            }
        }
    }

    private void adjustDeletedSubTreeRanges(SVNMergeDriver$MergePath sVNMergeDriver$MergePath, SVNMergeDriver$MergePath sVNMergeDriver$MergePath2, long l2, long l3, SVNURL sVNURL, SVNRepository sVNRepository) {
        Object object;
        Object object2;
        long l4;
        SVNErrorManager.assertionFailure(sVNMergeDriver$MergePath2.myRemainingRanges != null, "parent must already have non-null remaining ranges set", SVNLogType.WC);
        String string = this.getPathRelativeToRoot(null, sVNURL, sVNRepository.getLocation(), null, sVNRepository);
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        boolean bl2 = l3 < l2;
        long l5 = l4 = bl2 ? l2 : l3;
        long l6 = bl2 ? l3 : l2;
        List list = null;
        try {
            list = sVNRepository.getLocationSegments(string, l4, l5, l6);
        }
        catch (SVNException sVNException) {
            object2 = sVNException.getErrorMessage().getErrorCode();
            if (object2 == SVNErrorCode.FS_NOT_FOUND || object2 == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
                object = sVNRepository.checkPath(string, l6);
                if (object == SVNNodeKind.NONE) {
                    sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath2.myRemainingRanges.dup();
                } else {
                    long l7 = sVNRepository.getDeletedRevision(string, l6, l5);
                    SVNErrorManager.assertionFailure(SVNRevision.isValidRevisionNumber(l7), "deleted revision must exist", SVNLogType.WC);
                    if (bl2) {
                        sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.reverse();
                        sVNMergeDriver$MergePath2.myRemainingRanges = sVNMergeDriver$MergePath2.myRemainingRanges.reverse();
                    }
                    SVNMergeRangeList sVNMergeRangeList = new SVNMergeRangeList(new SVNMergeRange(l6, l7 - 1L, true));
                    sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.intersect(sVNMergeRangeList, false);
                    SVNMergeRangeList sVNMergeRangeList2 = new SVNMergeRangeList(new SVNMergeRange(l7 - 1L, l4, true));
                    sVNMergeRangeList2 = sVNMergeDriver$MergePath2.myRemainingRanges.intersect(sVNMergeRangeList2, false);
                    sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.merge(sVNMergeRangeList2);
                    if (bl2) {
                        sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.reverse();
                        sVNMergeDriver$MergePath2.myRemainingRanges = sVNMergeDriver$MergePath2.myRemainingRanges.reverse();
                    }
                }
            }
            throw sVNException;
        }
        if (list != null && !list.isEmpty()) {
            SVNLocationSegment sVNLocationSegment = (SVNLocationSegment)list.get(list.size() - 1);
            if (sVNLocationSegment.getStartRevision() == l6) {
                return;
            }
            if (bl2) {
                sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.reverse();
                sVNMergeDriver$MergePath2.myRemainingRanges = sVNMergeDriver$MergePath2.myRemainingRanges.reverse();
            }
            object2 = new SVNMergeRangeList(new SVNMergeRange(sVNLocationSegment.getStartRevision(), l4, true));
            sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.intersect((SVNMergeRangeList)object2, false);
            object = new SVNMergeRangeList(new SVNMergeRange(l6, sVNLocationSegment.getStartRevision(), true));
            object = sVNMergeDriver$MergePath2.myRemainingRanges.intersect((SVNMergeRangeList)object, false);
            sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.merge((SVNMergeRangeList)object);
            if (bl2) {
                sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.reverse();
                sVNMergeDriver$MergePath2.myRemainingRanges = sVNMergeDriver$MergePath2.myRemainingRanges.reverse();
            }
        }
    }

    private void filterMergedRevisions(SVNMergeDriver$MergePath sVNMergeDriver$MergePath, SVNMergeDriver$MergePath sVNMergeDriver$MergePath2, SVNEntry sVNEntry, SVNRepository sVNRepository, String string, Map map, long l2, long l3, boolean bl2) {
        SVNMergeRangeList sVNMergeRangeList = null;
        SVNMergeRangeList sVNMergeRangeList2 = null;
        SVNMergeRangeList sVNMergeRangeList3 = null;
        SVNMergeRangeList sVNMergeRangeList4 = new SVNMergeRangeList(new SVNMergeRange(l2, l3, true));
        if (l2 > l3) {
            SVNMergeRangeList[] sVNMergeRangeListArray = SVNMergeInfoUtil.diffMergeRangeLists(sVNMergeRangeList4 = sVNMergeRangeList4.reverse(), sVNMergeRangeList3 = (sVNMergeRangeList = map != null ? (SVNMergeRangeList)map.get(string) : null) != null ? sVNMergeRangeList.intersect(sVNMergeRangeList4, false) : new SVNMergeRangeList(new SVNMergeRange[0]), false);
            SVNMergeRangeList sVNMergeRangeList5 = sVNMergeRangeListArray[0];
            if (sVNMergeRangeList5 == null || sVNMergeRangeList5.isEmpty()) {
                sVNMergeRangeList4 = sVNMergeRangeList4.reverse();
                sVNMergeDriver$MergePath2.myRemainingRanges = sVNMergeRangeList4.dup();
            } else {
                SVNMergeRangeList sVNMergeRangeList6 = null;
                this.ensureImplicitMergeinfo(sVNMergeDriver$MergePath, sVNMergeDriver$MergePath2, bl2, sVNEntry, l2, l3, sVNRepository);
                sVNMergeRangeList2 = (SVNMergeRangeList)sVNMergeDriver$MergePath2.myImplicitMergeInfo.get(string);
                sVNMergeRangeList6 = sVNMergeRangeList2 != null ? sVNMergeRangeList2.intersect(sVNMergeRangeList4, false) : new SVNMergeRangeList(new SVNMergeRange[0]);
                sVNMergeRangeList6 = sVNMergeRangeList6.merge(sVNMergeRangeList3);
                sVNMergeRangeList6 = sVNMergeRangeList6.reverse();
                sVNMergeDriver$MergePath2.myRemainingRanges = sVNMergeRangeList6.dup();
            }
        } else {
            sVNMergeRangeList = map != null ? (SVNMergeRangeList)map.get(string) : null;
            sVNMergeRangeList3 = sVNMergeRangeList != null ? sVNMergeRangeList4.remove(sVNMergeRangeList, false) : sVNMergeRangeList4.dup();
            if (sVNMergeRangeList3 == null || sVNMergeRangeList3.isEmpty()) {
                sVNMergeDriver$MergePath2.myRemainingRanges = new SVNMergeRangeList(new SVNMergeRange[0]);
            } else if (this.getOptions().isAllowAllForwardMergesFromSelf()) {
                sVNMergeDriver$MergePath2.myRemainingRanges = sVNMergeRangeList3.dup();
            } else {
                this.ensureImplicitMergeinfo(sVNMergeDriver$MergePath, sVNMergeDriver$MergePath2, bl2, sVNEntry, l2, l3, sVNRepository);
                sVNMergeRangeList2 = (SVNMergeRangeList)sVNMergeDriver$MergePath2.myImplicitMergeInfo.get(string);
                sVNMergeDriver$MergePath2.myRemainingRanges = sVNMergeRangeList2 != null ? sVNMergeRangeList3.remove(sVNMergeRangeList2, false) : sVNMergeRangeList3.dup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File loadFile(SVNRepository sVNRepository, long l2, SVNProperties sVNProperties, SVNAdminArea sVNAdminArea) {
        File file = sVNAdminArea.getAdminTempDirectory();
        File file2 = SVNFileUtil.createUniqueFile(file, ".merge", ".tmp", false);
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file2);
            sVNRepository.getFile("", l2, sVNProperties, new SVNCancellableOutputStream(outputStream, this));
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
        return file2;
    }

    private static SVNProperties computePropsDiff(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        SVNProperties sVNProperties3 = new SVNProperties();
        for (String string : sVNProperties2.nameSet()) {
            if (sVNProperties.containsName(string)) {
                SVNPropertyValue sVNPropertyValue = sVNProperties2.getSVNPropertyValue(string);
                if (sVNPropertyValue.equals(sVNProperties.getSVNPropertyValue(string))) continue;
                sVNProperties3.put(string, sVNProperties2.getSVNPropertyValue(string));
                continue;
            }
            sVNProperties3.put(string, sVNProperties2.getSVNPropertyValue(string));
        }
        for (String string : sVNProperties.nameSet()) {
            if (sVNProperties2.containsName(string)) continue;
            sVNProperties3.put(string, (SVNPropertyValue)null);
        }
        return sVNProperties3;
    }

    public static SVNProperties filterProperties(SVNProperties sVNProperties, boolean bl2, boolean bl3, boolean bl4) {
        return SVNMergeDriver.filterProperties(sVNProperties, bl2, bl3, bl4, bl3);
    }

    public static SVNProperties filterProperties(SVNProperties sVNProperties, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        SVNProperties sVNProperties2 = new SVNProperties();
        for (String string : sVNProperties.nameSet()) {
            if (!bl3 && string.startsWith("svn:entry:") && (!bl5 || !"svn:entry:last-author".equals(string) && !"svn:entry:committed-rev".equals(string) && !"svn:entry:committed-date".equals(string)) || !bl4 && string.startsWith("svn:wc:") || !bl2 && !string.startsWith("svn:entry:") && !string.startsWith("svn:wc:")) continue;
            sVNProperties2.put(string, sVNProperties.getSVNPropertyValue(string));
        }
        return sVNProperties2;
    }

    private void fixDeletedSubtreeRanges(SVNURL sVNURL, long l2, SVNURL sVNURL2, long l3, SVNRepository sVNRepository) {
        boolean bl2 = l3 < l2;
        SVNURL sVNURL3 = sVNRepository.getRepositoryRoot(true);
        Object[] objectArray = this.myChildrenWithMergeInfo.toArray();
        for (SVNMergeDriver$MergePath sVNMergeDriver$MergePath : this.myChildrenWithMergeInfo) {
            if (sVNMergeDriver$MergePath.myIsAbsent) continue;
            int n2 = this.findNearestAncestor(objectArray, false, sVNMergeDriver$MergePath.myPath);
            SVNMergeDriver$MergePath sVNMergeDriver$MergePath2 = (SVNMergeDriver$MergePath)objectArray[n2];
            if (bl2) {
                sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.reverse();
                sVNMergeDriver$MergePath2.myRemainingRanges = sVNMergeDriver$MergePath2.myRemainingRanges.reverse();
            }
            SVNMergeRangeList sVNMergeRangeList = sVNMergeDriver$MergePath.myRemainingRanges.diff(sVNMergeDriver$MergePath2.myRemainingRanges, true);
            SVNMergeRangeList sVNMergeRangeList2 = sVNMergeDriver$MergePath2.myRemainingRanges.diff(sVNMergeDriver$MergePath.myRemainingRanges, true);
            if (bl2) {
                sVNMergeDriver$MergePath.myRemainingRanges = sVNMergeDriver$MergePath.myRemainingRanges.reverse();
                sVNMergeDriver$MergePath2.myRemainingRanges = sVNMergeDriver$MergePath2.myRemainingRanges.reverse();
            }
            if (sVNMergeRangeList.isEmpty() && sVNMergeRangeList2.isEmpty()) continue;
            String string = SVNWCUtils.getPathAsChild(this.myTarget, sVNMergeDriver$MergePath.myPath);
            SVNURL sVNURL4 = l2 < l3 ? sVNURL2 : sVNURL;
            sVNURL4 = sVNURL4.appendPath(string, false);
            this.adjustDeletedSubTreeRanges(sVNMergeDriver$MergePath, sVNMergeDriver$MergePath2, l2, l3, sVNURL4, sVNRepository);
        }
    }

    static /* synthetic */ int access$800(SVNMergeDriver sVNMergeDriver, Object[] objectArray, boolean bl2, File file) {
        return sVNMergeDriver.findNearestAncestor(objectArray, bl2, file);
    }

    static /* synthetic */ String access$900(SVNMergeDriver sVNMergeDriver, File file, SVNURL sVNURL, SVNURL sVNURL2, SVNWCAccess sVNWCAccess, SVNRepository sVNRepository) {
        return sVNMergeDriver.getPathRelativeToRoot(file, sVNURL, sVNURL2, sVNWCAccess, sVNRepository);
    }

    static /* synthetic */ List access$1000(SVNMergeDriver sVNMergeDriver) {
        return sVNMergeDriver.myChildrenWithMergeInfo;
    }
}

