/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeDriver$SubTreeMergeInfoHandler
implements ISVNEntryHandler {
    private File myTargetPath;
    private SVNURL myTargetReposRoot;
    private Collection mySubTreesWithMergeInfoPaths = new LinkedList();
    final /* synthetic */ SVNMergeDriver this$0;

    public SVNMergeDriver$SubTreeMergeInfoHandler(SVNMergeDriver sVNMergeDriver, File file, SVNURL sVNURL) {
        this.this$0 = sVNMergeDriver;
        this.myTargetPath = file;
        this.myTargetReposRoot = sVNURL;
    }

    @Override
    public void handleEntry(File file, SVNEntry sVNEntry) {
        SVNAdminArea sVNAdminArea = sVNEntry.getAdminArea();
        if (sVNEntry.getKind() == SVNNodeKind.DIR && !sVNAdminArea.getThisDirName().equals(sVNEntry.getName()) && !sVNEntry.isAbsent()) {
            return;
        }
        SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getProperties(sVNEntry.getName());
        String string = sVNVersionedProperties.getStringPropertyValue("svn:mergeinfo");
        if (string != null || file.equals(this.myTargetPath)) {
            String string2 = SVNMergeDriver.access$900(this.this$0, file, null, this.myTargetReposRoot, sVNAdminArea.getWCAccess(), null);
            this.mySubTreesWithMergeInfoPaths.add(string2);
        }
    }

    @Override
    public void handleError(File file, SVNErrorMessage sVNErrorMessage) {
        while (sVNErrorMessage.hasChildErrorMessage()) {
            sVNErrorMessage = sVNErrorMessage.getChildErrorMessage();
        }
        if (sVNErrorMessage.getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND || sVNErrorMessage.getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
            return;
        }
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
    }

    public Collection getSubTreesWithMergeInfoPaths() {
        return this.mySubTreesWithMergeInfoPaths;
    }
}

