/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;

class SVNMergeDriver$CopyFromReceiver
implements ISVNLogEntryHandler {
    private String myTargetPath;
    private SVNLocationEntry myCopyFromLocation;

    public SVNMergeDriver$CopyFromReceiver(String string) {
        this.myTargetPath = string;
    }

    @Override
    public void handleLogEntry(SVNLogEntry sVNLogEntry) {
        if (this.myCopyFromLocation != null) {
            return;
        }
        Map map = sVNLogEntry.getChangedPaths();
        if (map != null && !map.isEmpty()) {
            TreeMap treeMap = new TreeMap(Collections.reverseOrder());
            treeMap.putAll(map);
            for (String string : treeMap.keySet()) {
                SVNLogEntryPath sVNLogEntryPath = (SVNLogEntryPath)treeMap.get(string);
                if (sVNLogEntryPath.getCopyPath() == null || !SVNRevision.isValidRevisionNumber(sVNLogEntryPath.getCopyRevision()) || !SVNPathUtil.isAncestor(string, this.myTargetPath)) continue;
                String string2 = null;
                if (string.equals(this.myTargetPath)) {
                    string2 = sVNLogEntryPath.getCopyPath();
                } else {
                    String string3 = this.myTargetPath.substring(string.length());
                    if (string3.startsWith("/")) {
                        string3 = string3.substring(1);
                    }
                    string2 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(sVNLogEntryPath.getCopyPath(), string3));
                }
                this.myCopyFromLocation = new SVNLocationEntry(sVNLogEntryPath.getCopyRevision(), string2);
                break;
            }
        }
    }

    public SVNLocationEntry getCopyFromLocation() {
        return this.myCopyFromLocation;
    }
}

