/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeCallback;
import org.tmatesoft.svn.core.internal.wc.SVNMergeCallback15$1;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$MergeSource;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeCallback15
extends SVNMergeCallback {
    public SVNMergeCallback15(SVNAdminArea sVNAdminArea, SVNURL sVNURL, boolean bl2, boolean bl3, SVNDiffOptions sVNDiffOptions, Map map, SVNMergeDriver sVNMergeDriver) {
        super(sVNAdminArea, sVNURL, bl2, bl3, sVNDiffOptions, map, sVNMergeDriver);
    }

    @Override
    public SVNStatusType propertiesChanged(String string, SVNProperties sVNProperties, SVNProperties sVNProperties2, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        SVNProperties sVNProperties3 = new SVNProperties();
        this.categorizeProperties(sVNProperties2, sVNProperties3, null, null);
        if (sVNProperties3.isEmpty()) {
            return SVNStatusType.UNKNOWN;
        }
        try {
            Object object;
            SVNMergeDriver$MergeSource sVNMergeDriver$MergeSource;
            File file = this.getFile(string);
            SVNWCAccess sVNWCAccess = this.getWCAccess();
            if (sVNWCAccess.getAdminArea(file) == null) {
                sVNWCAccess.probeTry(file, true, -1);
            }
            if (!((sVNMergeDriver$MergeSource = this.myMergeDriver.getCurrentMergeSource()).getRevision1() >= sVNMergeDriver$MergeSource.getRevision2() && this.myMergeDriver.myAreSourcesAncestral || (object = this.myMergeDriver.filterSelfReferentialMergeInfo(sVNProperties3, file)) == null)) {
                sVNProperties3 = object;
            }
            object = SVNPropertiesManager.mergeProperties(this.getWCAccess(), file, sVNProperties, sVNProperties3, false, this.myIsDryRun);
            if (!this.myIsDryRun) {
                for (String string2 : sVNProperties3.nameSet()) {
                    SVNPropertyValue sVNPropertyValue = sVNProperties3.getSVNPropertyValue(string2);
                    if (!"svn:mergeinfo".equals(string2)) continue;
                    SVNPropertyValue sVNPropertyValue2 = sVNProperties.getSVNPropertyValue("svn:mergeinfo");
                    if (sVNPropertyValue2 == null && sVNPropertyValue != null) {
                        this.myMergeDriver.addPathWithNewMergeInfo(file);
                        continue;
                    }
                    if (sVNPropertyValue2 == null || sVNPropertyValue != null) continue;
                    this.myMergeDriver.addPathWithDeletedMergeInfo(file);
                }
            }
            return object;
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) {
                return SVNStatusType.MISSING;
            }
            throw sVNException;
        }
    }

    @Override
    public SVNStatusType directoryAdded(String string, long l2, boolean[] blArray) {
        SVNFileType sVNFileType;
        this.setIsConflicted(blArray, false);
        File file = this.getFile(string);
        SVNAdminArea sVNAdminArea = this.retrieve(file.getParentFile(), true);
        if (sVNAdminArea == null) {
            if (this.myIsDryRun && this.myAddedPath != null && SVNPathUtil.isAncestor(this.myAddedPath, string)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.MISSING;
        }
        SVNURL sVNURL = null;
        long l3 = -1L;
        if (this.myMergeDriver.myIsSameRepository) {
            sVNURL = this.myURL.appendPath(string, false);
            l3 = l2;
        }
        if ((sVNFileType = SVNFileType.getType(file)) == SVNFileType.NONE) {
            SVNEntry sVNEntry = this.getWCAccess().getEntry(file, false);
            if (sVNEntry != null && !sVNEntry.isScheduledForDeletion()) {
                return SVNStatusType.OBSTRUCTED;
            }
            if (this.myIsDryRun) {
                this.myAddedPath = string;
            } else {
                Object object;
                if (!file.mkdirs() && SVNFileType.getType(file) != SVNFileType.DIRECTORY) {
                    object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
                }
                object = sVNAdminArea.getWCAccess().getEventHandler();
                sVNAdminArea.getWCAccess().setEventHandler(null);
                SVNWCManager.add(file, sVNAdminArea, sVNURL, l3, null);
                sVNAdminArea.getWCAccess().setEventHandler((ISVNEventHandler)object);
            }
            return SVNStatusType.CHANGED;
        }
        if (sVNFileType == SVNFileType.DIRECTORY) {
            SVNEntry sVNEntry = this.getWCAccess().getEntry(file, false);
            if (sVNEntry == null || sVNEntry.isScheduledForDeletion()) {
                if (!this.myIsDryRun) {
                    ISVNEventHandler iSVNEventHandler = sVNAdminArea.getWCAccess().getEventHandler();
                    sVNAdminArea.getWCAccess().setEventHandler(null);
                    SVNWCManager.add(file, sVNAdminArea, sVNURL, l3, null);
                    sVNAdminArea.getWCAccess().setEventHandler(iSVNEventHandler);
                }
                if (this.myIsDryRun) {
                    this.myAddedPath = string;
                }
                return SVNStatusType.CHANGED;
            }
            if (this.myIsDryRun && this.isPathDeleted(string)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.OBSTRUCTED;
        }
        if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
            SVNEntry sVNEntry;
            if (this.myIsDryRun) {
                this.myAddedPath = null;
            }
            if ((sVNEntry = this.getWCAccess().getEntry(file, false)) != null && this.myIsDryRun && this.isPathDeleted(string)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.OBSTRUCTED;
        }
        if (this.myIsDryRun) {
            this.myAddedPath = null;
        }
        return SVNStatusType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNStatusType directoryDeleted(String string, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        File file = this.getFile(string);
        SVNAdminArea sVNAdminArea = this.retrieve(file.getParentFile(), true);
        if (sVNAdminArea == null) {
            return SVNStatusType.MISSING;
        }
        SVNEntry sVNEntry = this.getWCAccess().getEntry(file, true);
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.DIRECTORY) {
            if (sVNEntry != null && !sVNEntry.isScheduledForDeletion()) {
                ISVNEventHandler iSVNEventHandler = this.getWCAccess().getEventHandler();
                SVNMergeCallback15$1 sVNMergeCallback15$1 = new SVNMergeCallback15$1(this, iSVNEventHandler);
                this.getWCAccess().setEventHandler(sVNMergeCallback15$1);
                try {
                    this.delete(file, this.myIsForce, this.myIsDryRun);
                }
                catch (SVNException sVNException) {
                    SVNStatusType sVNStatusType = SVNStatusType.OBSTRUCTED;
                    return sVNStatusType;
                }
                finally {
                    this.getWCAccess().setEventHandler(iSVNEventHandler);
                }
                return SVNStatusType.CHANGED;
            }
        } else {
            if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
                return SVNStatusType.OBSTRUCTED;
            }
            if (sVNFileType == SVNFileType.NONE) {
                return SVNStatusType.MISSING;
            }
        }
        return SVNStatusType.UNKNOWN;
    }

    @Override
    public void directoryOpened(String string, long l2, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
    }

    @Override
    public SVNStatusType[] fileChanged(String string, File file, File file2, long l2, long l3, String string2, String string3, SVNProperties sVNProperties, SVNProperties sVNProperties2, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        boolean bl2 = true;
        File file3 = this.getFile(string);
        SVNAdminArea sVNAdminArea = this.retrieve(file3.getParentFile(), this.myIsDryRun);
        if (sVNAdminArea == null) {
            return new SVNStatusType[]{SVNStatusType.MISSING, SVNStatusType.MISSING};
        }
        SVNStatusType[] sVNStatusTypeArray = new SVNStatusType[]{SVNStatusType.UNCHANGED, SVNStatusType.UNCHANGED};
        SVNEntry sVNEntry = this.getWCAccess().getEntry(file3, false);
        SVNFileType sVNFileType = null;
        if (sVNEntry != null) {
            sVNFileType = SVNFileType.getType(file3);
        }
        if (sVNEntry == null || sVNFileType != SVNFileType.FILE && sVNFileType != SVNFileType.SYMLINK) {
            return new SVNStatusType[]{SVNStatusType.MISSING, SVNStatusType.MISSING};
        }
        if (sVNProperties2 != null && !sVNProperties2.isEmpty()) {
            sVNStatusTypeArray[1] = this.propertiesChanged(string, sVNProperties, sVNProperties2, null);
        }
        String string4 = file3.getName();
        if (file != null) {
            boolean bl3;
            boolean bl4 = sVNAdminArea.hasTextModifications(string4, false);
            if (!bl4 && (SVNProperty.isBinaryMimeType(string2) || SVNProperty.isBinaryMimeType(string3)) && (bl3 = SVNFileUtil.compareFiles(!this.myIsAddNecessitatedMerge ? file : file2, file3, null))) {
                if (!this.myIsDryRun && !this.myIsAddNecessitatedMerge) {
                    SVNFileUtil.rename(file2, file3);
                    boolean bl5 = false;
                    bl5 = sVNProperties2 != null && sVNProperties2.containsName("svn:executable") ? sVNProperties2.getStringValue("svn:executable") != null : sVNProperties != null && sVNProperties.getStringValue("svn:executable") != null;
                    SVNFileUtil.setExecutable(file3, bl5);
                }
                sVNStatusTypeArray[0] = SVNStatusType.CHANGED;
                bl2 = false;
            }
            if (bl2) {
                String string5 = ".working";
                String string6 = ".merge-left.r" + l2;
                String string7 = ".merge-right.r" + l3;
                SVNStatusType sVNStatusType = sVNAdminArea.mergeText(string4, file, file2, null, string5, string6, string7, sVNProperties2, this.myIsDryRun, this.myDiffOptions, null);
                sVNAdminArea.runLogs();
                if (sVNStatusType == SVNStatusType.CONFLICTED || sVNStatusType == SVNStatusType.CONFLICTED_UNRESOLVED) {
                    sVNStatusTypeArray[0] = sVNStatusType;
                } else if (bl4 && sVNStatusType != SVNStatusType.UNCHANGED) {
                    sVNStatusTypeArray[0] = SVNStatusType.MERGED;
                } else if (sVNStatusType == SVNStatusType.MERGED) {
                    sVNStatusTypeArray[0] = SVNStatusType.CHANGED;
                } else if (sVNStatusType != SVNStatusType.MISSING) {
                    sVNStatusTypeArray[0] = SVNStatusType.UNCHANGED;
                }
                if (sVNStatusType == SVNStatusType.CONFLICTED) {
                    if (this.myConflictedPaths == null) {
                        this.myConflictedPaths = new SVNHashMap();
                    }
                    this.myConflictedPaths.put(string, string);
                }
            }
        }
        return sVNStatusTypeArray;
    }

    @Override
    public SVNStatusType[] fileAdded(String string, File file, File file2, long l2, long l3, String string2, String string3, SVNProperties sVNProperties, SVNProperties sVNProperties2, boolean[] blArray) {
        Object object;
        Object object22;
        this.setIsConflicted(blArray, false);
        SVNStatusType[] sVNStatusTypeArray = new SVNStatusType[]{null, SVNStatusType.UNKNOWN};
        SVNProperties sVNProperties3 = new SVNProperties(sVNProperties);
        for (Object object22 : sVNProperties2.nameSet()) {
            if (SVNProperty.isWorkingCopyProperty((String)object22) || !this.myMergeDriver.isSameRepository() && !SVNProperty.isRegularProperty((String)object22) || !this.myMergeDriver.isSameRepository() && "svn:mergeinfo".equals(object22)) continue;
            object = sVNProperties2.getSVNPropertyValue((String)object22);
            sVNProperties3.put((String)object22, (SVNPropertyValue)object);
        }
        File file3 = this.getFile(string);
        object22 = this.retrieve(file3.getParentFile(), true);
        if (object22 == null) {
            if (this.myIsDryRun && this.myAddedPath != null && SVNPathUtil.isAncestor(this.myAddedPath, string)) {
                sVNStatusTypeArray[0] = SVNStatusType.CHANGED;
                if (!sVNProperties3.isEmpty()) {
                    sVNStatusTypeArray[1] = SVNStatusType.CHANGED;
                }
            } else {
                sVNStatusTypeArray[0] = SVNStatusType.MISSING;
            }
            return sVNStatusTypeArray;
        }
        object = SVNFileType.getType(file3);
        if (object == SVNFileType.NONE) {
            SVNEntry sVNEntry = this.getWCAccess().getEntry(file3, false);
            if (sVNEntry != null && !sVNEntry.isScheduledForDeletion()) {
                sVNStatusTypeArray[0] = SVNStatusType.OBSTRUCTED;
                return sVNStatusTypeArray;
            }
            if (!this.myIsDryRun) {
                String string4 = null;
                long l4 = -1L;
                if (this.myMergeDriver.myIsSameRepository) {
                    String string5 = this.myMergeDriver.myTarget.getAbsolutePath();
                    String string6 = file3.getAbsolutePath();
                    String string7 = SVNPathUtil.getRelativePath(string5, string6);
                    string4 = this.myURL.appendPath(string7, false).toString();
                    l4 = l3;
                }
                SVNWCManager.addRepositoryFile((SVNAdminArea)object22, file3.getName(), null, file2, sVNProperties3, null, string4, l4);
            }
            sVNStatusTypeArray[0] = SVNStatusType.CHANGED;
            if (!sVNProperties3.isEmpty()) {
                sVNStatusTypeArray[1] = SVNStatusType.CHANGED;
            }
        } else if (object == SVNFileType.DIRECTORY) {
            sVNStatusTypeArray[0] = this.myIsDryRun && this.isPathDeleted(string) ? SVNStatusType.CHANGED : SVNStatusType.OBSTRUCTED;
        } else if (object == SVNFileType.FILE || object == SVNFileType.SYMLINK) {
            SVNEntry sVNEntry = this.getWCAccess().getEntry(file3, false);
            if (sVNEntry == null || sVNEntry.isScheduledForDeletion()) {
                sVNStatusTypeArray[0] = SVNStatusType.OBSTRUCTED;
            } else if (this.myIsDryRun && this.isPathDeleted(string)) {
                sVNStatusTypeArray[0] = SVNStatusType.CHANGED;
            } else {
                this.myIsAddNecessitatedMerge = true;
                sVNStatusTypeArray = this.fileChanged(string, file, file2, l2, l3, string2, string3, sVNProperties, sVNProperties2, null);
                this.myIsAddNecessitatedMerge = false;
            }
        }
        return sVNStatusTypeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNStatusType fileDeleted(String string, File file, File file2, String string2, String string3, SVNProperties sVNProperties, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        File file3 = this.getFile(string);
        SVNAdminArea sVNAdminArea = this.retrieve(file3.getParentFile(), true);
        if (sVNAdminArea == null) {
            return SVNStatusType.MISSING;
        }
        SVNFileType sVNFileType = SVNFileType.getType(file3);
        if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
            if (this.areFilesTheSame(file, sVNProperties, file3, sVNAdminArea) || this.myMergeDriver.myIsForce || this.myMergeDriver.myIsRecordOnly) {
                ISVNEventHandler iSVNEventHandler = this.getWCAccess().getEventHandler();
                this.getWCAccess().setEventHandler(null);
                try {
                    this.delete(file3, this.myIsForce, this.myIsDryRun);
                }
                catch (SVNException sVNException) {
                    SVNStatusType sVNStatusType = SVNStatusType.OBSTRUCTED;
                    return sVNStatusType;
                }
                finally {
                    this.getWCAccess().setEventHandler(iSVNEventHandler);
                }
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.OBSTRUCTED;
        }
        if (sVNFileType == SVNFileType.DIRECTORY) {
            return SVNStatusType.OBSTRUCTED;
        }
        if (sVNFileType == SVNFileType.NONE) {
            return SVNStatusType.MISSING;
        }
        return SVNStatusType.UNKNOWN;
    }

    @Override
    public SVNStatusType[] directoryClosed(String string, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        return new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};
    }

    protected void delete(File file, boolean bl2, boolean bl3) {
        if (!bl2) {
            SVNWCManager.canDelete(file, this.getWCAccess().getOptions(), this.getWCAccess());
        }
        SVNAdminArea sVNAdminArea = this.getWCAccess().retrieve(file.getParentFile());
        if (!bl3) {
            SVNWCManager.delete(this.getWCAccess(), sVNAdminArea, file, true, false);
        }
    }
}

