/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeCallback$1;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$MergeSource;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeCallback
extends AbstractDiffCallback {
    protected boolean myIsDryRun;
    protected SVNURL myURL;
    protected boolean myIsAddNecessitatedMerge;
    protected String myAddedPath = null;
    protected boolean myIsForce;
    protected SVNDiffOptions myDiffOptions;
    protected Map myConflictedPaths;
    protected SVNMergeDriver myMergeDriver;

    public SVNMergeCallback(SVNAdminArea sVNAdminArea, SVNURL sVNURL, boolean bl2, boolean bl3, SVNDiffOptions sVNDiffOptions, Map map, SVNMergeDriver sVNMergeDriver) {
        super(sVNAdminArea);
        this.myURL = sVNURL;
        this.myIsDryRun = bl3;
        this.myIsForce = bl2;
        this.myDiffOptions = sVNDiffOptions;
        this.myConflictedPaths = map;
        this.myMergeDriver = sVNMergeDriver;
    }

    @Override
    public File createTempDirectory() {
        return SVNFileUtil.createTempDirectory("merge");
    }

    @Override
    public boolean isDiffUnversioned() {
        return false;
    }

    @Override
    public boolean isDiffCopiedAsAdded() {
        return false;
    }

    public Map getConflictedPaths() {
        return this.myConflictedPaths;
    }

    @Override
    public SVNStatusType propertiesChanged(String string, SVNProperties sVNProperties, SVNProperties sVNProperties2, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        SVNStatusType sVNStatusType = this.getStatusForObstructedOrMissing(string);
        if (sVNStatusType != SVNStatusType.INAPPLICABLE) {
            return sVNStatusType;
        }
        SVNProperties sVNProperties3 = new SVNProperties();
        this.categorizeProperties(sVNProperties2, sVNProperties3, null, null);
        if (sVNProperties3.isEmpty()) {
            return SVNStatusType.UNKNOWN;
        }
        try {
            Object object;
            SVNMergeDriver$MergeSource sVNMergeDriver$MergeSource;
            File file = this.getFile(string);
            SVNWCAccess sVNWCAccess = this.getWCAccess();
            if (sVNWCAccess.getAdminArea(file) == null) {
                sVNWCAccess.probeTry(file, true, -1);
            }
            if (!((sVNMergeDriver$MergeSource = this.myMergeDriver.getCurrentMergeSource()).getRevision1() >= sVNMergeDriver$MergeSource.getRevision2() && this.myMergeDriver.myAreSourcesAncestral || (object = this.myMergeDriver.filterSelfReferentialMergeInfo(sVNProperties3, file)) == null)) {
                sVNProperties3 = object;
            }
            object = SVNPropertiesManager.mergeProperties(this.getWCAccess(), file, sVNProperties, sVNProperties3, false, this.myIsDryRun);
            if (!this.myIsDryRun) {
                for (String string2 : sVNProperties3.nameSet()) {
                    SVNPropertyValue sVNPropertyValue = sVNProperties3.getSVNPropertyValue(string2);
                    if (!"svn:mergeinfo".equals(string2)) continue;
                    SVNPropertyValue sVNPropertyValue2 = sVNProperties.getSVNPropertyValue("svn:mergeinfo");
                    if (sVNPropertyValue2 == null && sVNPropertyValue != null) {
                        this.myMergeDriver.addPathWithNewMergeInfo(file);
                        continue;
                    }
                    if (sVNPropertyValue2 == null || sVNPropertyValue != null) continue;
                    this.myMergeDriver.addPathWithDeletedMergeInfo(file);
                }
            }
            return object;
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) {
                this.setIsConflicted(blArray, true);
                return SVNStatusType.MISSING;
            }
            throw sVNException;
        }
    }

    @Override
    public SVNStatusType directoryAdded(String string, long l2, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        File file = this.getFile(string);
        SVNAdminArea sVNAdminArea = this.retrieve(file.getParentFile(), true);
        if (sVNAdminArea == null) {
            if (this.myIsDryRun && this.myAddedPath != null && SVNPathUtil.isAncestor(this.myAddedPath, string)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.MISSING;
        }
        SVNURL sVNURL = null;
        long l3 = -1L;
        if (this.myMergeDriver.myIsSameRepository) {
            sVNURL = this.myURL.appendPath(string, false);
            l3 = l2;
        }
        SVNFileType sVNFileType = SVNFileType.getType(file);
        SVNStatusType sVNStatusType = this.getStatusForObstructedOrMissing(string);
        if (sVNStatusType == SVNStatusType.MISSING || sVNStatusType == SVNStatusType.OBSTRUCTED && (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK)) {
            return sVNStatusType;
        }
        if (sVNFileType == SVNFileType.NONE) {
            if (this.myIsDryRun) {
                this.myAddedPath = string;
            } else {
                Object object;
                if (!file.mkdirs() && SVNFileType.getType(file) != SVNFileType.DIRECTORY) {
                    object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
                }
                object = sVNAdminArea.getWCAccess().getEventHandler();
                sVNAdminArea.getWCAccess().setEventHandler(null);
                SVNWCManager.add(file, sVNAdminArea, sVNURL, l3, null);
                sVNAdminArea.getWCAccess().setEventHandler((ISVNEventHandler)object);
            }
            return SVNStatusType.CHANGED;
        }
        if (sVNFileType == SVNFileType.DIRECTORY) {
            SVNEntry sVNEntry = this.getWCAccess().getEntry(file, false);
            if (sVNEntry == null || sVNEntry.isScheduledForDeletion()) {
                if (!this.myIsDryRun) {
                    ISVNEventHandler iSVNEventHandler = sVNAdminArea.getWCAccess().getEventHandler();
                    sVNAdminArea.getWCAccess().setEventHandler(null);
                    SVNWCManager.add(file, sVNAdminArea, sVNURL, l3, null);
                    sVNAdminArea.getWCAccess().setEventHandler(iSVNEventHandler);
                }
                if (this.myIsDryRun) {
                    this.myAddedPath = string;
                }
                return SVNStatusType.CHANGED;
            }
            if (this.myIsDryRun && this.isPathDeleted(string)) {
                return SVNStatusType.CHANGED;
            }
            this.myMergeDriver.recordTreeConflictOnAdd(file, sVNAdminArea, SVNNodeKind.DIR, SVNConflictAction.ADD, SVNConflictReason.ADDED);
            this.setIsConflicted(blArray, true);
            return SVNStatusType.OBSTRUCTED;
        }
        if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
            SVNEntry sVNEntry;
            if (this.myIsDryRun) {
                this.myAddedPath = null;
            }
            if ((sVNEntry = this.getWCAccess().getEntry(file, false)) != null && this.myIsDryRun && this.isPathDeleted(string)) {
                return SVNStatusType.CHANGED;
            }
            this.myMergeDriver.recordTreeConflictOnAdd(file, sVNAdminArea, SVNNodeKind.DIR, SVNConflictAction.ADD, SVNConflictReason.OBSTRUCTED);
            this.setIsConflicted(blArray, true);
            return SVNStatusType.OBSTRUCTED;
        }
        if (this.myIsDryRun) {
            this.myAddedPath = null;
        }
        return SVNStatusType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNStatusType directoryDeleted(String string, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        File file = this.getFile(string);
        SVNAdminArea sVNAdminArea = this.retrieve(file.getParentFile(), true);
        if (sVNAdminArea == null) {
            return SVNStatusType.MISSING;
        }
        SVNEntry sVNEntry = this.getWCAccess().getEntry(file, true);
        SVNStatusType sVNStatusType = this.getStatusForObstructedOrMissing(string);
        if (sVNStatusType != SVNStatusType.INAPPLICABLE) {
            return sVNStatusType;
        }
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.DIRECTORY) {
            if (sVNEntry != null && !sVNEntry.isScheduledForDeletion()) {
                ISVNEventHandler iSVNEventHandler = this.getWCAccess().getEventHandler();
                SVNMergeCallback$1 sVNMergeCallback$1 = new SVNMergeCallback$1(this, iSVNEventHandler);
                this.getWCAccess().setEventHandler(sVNMergeCallback$1);
                try {
                    this.delete(file, this.myIsForce, this.myIsDryRun, false);
                }
                catch (SVNException sVNException) {
                    this.myMergeDriver.recordTreeConflict(file, sVNAdminArea, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.EDITED);
                    this.setIsConflicted(blArray, true);
                    SVNStatusType sVNStatusType2 = SVNStatusType.CONFLICTED;
                    return sVNStatusType2;
                }
                finally {
                    this.getWCAccess().setEventHandler(iSVNEventHandler);
                }
                return SVNStatusType.CHANGED;
            }
            this.myMergeDriver.recordTreeConflict(file, sVNAdminArea, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
            this.setIsConflicted(blArray, true);
        } else {
            if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
                return SVNStatusType.OBSTRUCTED;
            }
            if (sVNFileType == SVNFileType.NONE) {
                this.myMergeDriver.recordTreeConflict(file, sVNAdminArea, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
                this.setIsConflicted(blArray, true);
                return SVNStatusType.MISSING;
            }
        }
        return SVNStatusType.UNKNOWN;
    }

    @Override
    public void directoryOpened(String string, long l2, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        File file = this.getFile(string);
        SVNAdminArea sVNAdminArea = this.retrieve(file.getParentFile(), this.myIsDryRun);
        if (sVNAdminArea == null) {
            return;
        }
        SVNEntry sVNEntry = this.getWCAccess().getEntry(file, true);
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNEntry == null || sVNEntry.isScheduledForDeletion()) {
            this.myMergeDriver.recordTreeConflict(file, sVNAdminArea, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.DELETED);
            this.setIsConflicted(blArray, true);
        } else if (sVNEntry.isDirectory() && sVNFileType == SVNFileType.NONE) {
            this.myMergeDriver.recordTreeConflict(file, sVNAdminArea, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.MISSING);
            this.setIsConflicted(blArray, true);
        } else if (sVNEntry.isDirectory() && sVNFileType != SVNFileType.DIRECTORY) {
            this.myMergeDriver.recordTreeConflict(file, sVNAdminArea, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.OBSTRUCTED);
            this.setIsConflicted(blArray, true);
        } else if (sVNFileType != SVNFileType.DIRECTORY) {
            this.myMergeDriver.recordTreeConflict(file, sVNAdminArea, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.DELETED);
            this.setIsConflicted(blArray, true);
        }
    }

    @Override
    public SVNStatusType[] fileChanged(String string, File file, File file2, long l2, long l3, String string2, String string3, SVNProperties sVNProperties, SVNProperties sVNProperties2, boolean[] blArray) {
        Object object;
        this.setIsConflicted(blArray, false);
        boolean bl2 = true;
        File file3 = this.getFile(string);
        SVNAdminArea sVNAdminArea = this.retrieve(file3.getParentFile(), this.myIsDryRun);
        if (sVNAdminArea == null) {
            return new SVNStatusType[]{SVNStatusType.MISSING, SVNStatusType.MISSING};
        }
        SVNStatusType sVNStatusType = this.getStatusForObstructedOrMissing(string);
        if (sVNStatusType != SVNStatusType.INAPPLICABLE) {
            return new SVNStatusType[]{sVNStatusType, SVNStatusType.UNCHANGED};
        }
        SVNStatusType[] sVNStatusTypeArray = new SVNStatusType[]{SVNStatusType.UNCHANGED, SVNStatusType.UNCHANGED};
        SVNEntry sVNEntry = this.getWCAccess().getEntry(file3, false);
        SVNFileType sVNFileType = null;
        if (sVNEntry != null) {
            sVNFileType = SVNFileType.getType(file3);
        }
        if (sVNEntry == null || sVNFileType != SVNFileType.FILE && sVNFileType != SVNFileType.SYMLINK) {
            this.myMergeDriver.recordTreeConflict(file3, sVNAdminArea, SVNNodeKind.FILE, SVNConflictAction.EDIT, SVNConflictReason.MISSING);
            this.setIsConflicted(blArray, true);
            return new SVNStatusType[]{SVNStatusType.MISSING, SVNStatusType.MISSING};
        }
        if (sVNProperties2 != null && !sVNProperties2.isEmpty()) {
            object = new boolean[]{false};
            sVNStatusTypeArray[1] = this.propertiesChanged(string, sVNProperties, sVNProperties2, (boolean[])object);
            if (object[0] != false) {
                this.setIsConflicted(blArray, true);
                return sVNStatusTypeArray;
            }
        }
        object = file3.getName();
        if (file != null) {
            boolean bl3;
            boolean bl4 = sVNAdminArea.hasTextModifications((String)object, false);
            if (!bl4 && (SVNProperty.isBinaryMimeType(string2) || SVNProperty.isBinaryMimeType(string3)) && (bl3 = SVNFileUtil.compareFiles(!this.myIsAddNecessitatedMerge ? file : file2, file3, null))) {
                if (!this.myIsDryRun && !this.myIsAddNecessitatedMerge) {
                    SVNFileUtil.rename(file2, file3);
                    boolean bl5 = false;
                    bl5 = sVNProperties2 != null && sVNProperties2.containsName("svn:executable") ? sVNProperties2.getStringValue("svn:executable") != null : sVNProperties != null && sVNProperties.getStringValue("svn:executable") != null;
                    SVNFileUtil.setExecutable(file3, bl5);
                }
                sVNStatusTypeArray[0] = SVNStatusType.CHANGED;
                bl2 = false;
            }
            if (bl2) {
                String string4 = ".working";
                String string5 = ".merge-left.r" + l2;
                String string6 = ".merge-right.r" + l3;
                SVNStatusType sVNStatusType2 = sVNAdminArea.mergeText((String)object, file, file2, null, string4, string5, string6, sVNProperties2, this.myIsDryRun, this.myDiffOptions, null);
                sVNAdminArea.runLogs();
                if (sVNStatusType2 == SVNStatusType.CONFLICTED || sVNStatusType2 == SVNStatusType.CONFLICTED_UNRESOLVED) {
                    sVNStatusTypeArray[0] = sVNStatusType2;
                } else if (bl4 && sVNStatusType2 != SVNStatusType.UNCHANGED) {
                    sVNStatusTypeArray[0] = SVNStatusType.MERGED;
                } else if (sVNStatusType2 == SVNStatusType.MERGED) {
                    sVNStatusTypeArray[0] = SVNStatusType.CHANGED;
                } else if (sVNStatusType2 != SVNStatusType.MISSING) {
                    sVNStatusTypeArray[0] = SVNStatusType.UNCHANGED;
                }
                if (sVNStatusType2 == SVNStatusType.CONFLICTED) {
                    if (this.myConflictedPaths == null) {
                        this.myConflictedPaths = new SVNHashMap();
                    }
                    this.myConflictedPaths.put(string, string);
                }
            }
        }
        return sVNStatusTypeArray;
    }

    @Override
    public SVNStatusType[] fileAdded(String string, File file, File file2, long l2, long l3, String string2, String string3, SVNProperties sVNProperties, SVNProperties sVNProperties2, boolean[] blArray) {
        Object object;
        Object object22;
        this.setIsConflicted(blArray, false);
        SVNStatusType[] sVNStatusTypeArray = new SVNStatusType[]{null, SVNStatusType.UNKNOWN};
        SVNProperties sVNProperties3 = new SVNProperties(sVNProperties);
        for (Object object22 : sVNProperties2.nameSet()) {
            if (SVNProperty.isWorkingCopyProperty((String)object22) || !this.myMergeDriver.isSameRepository() && !SVNProperty.isRegularProperty((String)object22) || !this.myMergeDriver.isSameRepository() && "svn:mergeinfo".equals(object22)) continue;
            object = sVNProperties2.getSVNPropertyValue((String)object22);
            sVNProperties3.put((String)object22, (SVNPropertyValue)object);
        }
        File file3 = this.getFile(string);
        object22 = this.retrieve(file3.getParentFile(), true);
        if (object22 == null) {
            if (this.myIsDryRun && this.myAddedPath != null && SVNPathUtil.isAncestor(this.myAddedPath, string)) {
                sVNStatusTypeArray[0] = SVNStatusType.CHANGED;
                if (!sVNProperties3.isEmpty()) {
                    sVNStatusTypeArray[1] = SVNStatusType.CHANGED;
                }
            } else {
                sVNStatusTypeArray[0] = SVNStatusType.MISSING;
            }
            return sVNStatusTypeArray;
        }
        object = this.getStatusForObstructedOrMissing(string);
        if (object != SVNStatusType.INAPPLICABLE) {
            return new SVNStatusType[]{object, SVNStatusType.UNCHANGED};
        }
        SVNFileType sVNFileType = SVNFileType.getType(file3);
        if (sVNFileType == SVNFileType.NONE) {
            if (!this.myIsDryRun) {
                File file4;
                File file5;
                SVNProperties sVNProperties4;
                SVNProperties sVNProperties5;
                Object object3;
                String string4 = null;
                long l4 = -1L;
                if (this.myMergeDriver.myIsSameRepository) {
                    String string5;
                    object3 = this.myMergeDriver.myTarget.getAbsolutePath();
                    String string6 = SVNPathUtil.getRelativePath((String)object3, string5 = file3.getAbsolutePath());
                    string4 = string6 != null ? this.myURL.appendPath(string6, false).toString() : this.myURL.toString();
                    l4 = l3;
                    sVNProperties5 = sVNProperties3;
                    sVNProperties4 = null;
                    file5 = file2;
                    file4 = null;
                } else {
                    string4 = null;
                    l4 = -1L;
                    sVNProperties5 = new SVNProperties();
                    sVNProperties4 = sVNProperties3;
                    file5 = null;
                    file4 = file2;
                }
                object3 = this.getWCAccess().getTreeConflict(file3);
                if (object3 != null) {
                    this.myMergeDriver.recordTreeConflictOnAdd(file3, this.getAdminArea(), SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.ADDED);
                    this.setIsConflicted(blArray, true);
                } else {
                    SVNWCManager.addRepositoryFile((SVNAdminArea)object22, file3.getName(), file4, file5, sVNProperties5, sVNProperties4, string4, l4);
                }
            }
            sVNStatusTypeArray[0] = SVNStatusType.CHANGED;
            if (!sVNProperties3.isEmpty()) {
                sVNStatusTypeArray[1] = SVNStatusType.CHANGED;
            }
        } else if (sVNFileType == SVNFileType.DIRECTORY) {
            this.myMergeDriver.recordTreeConflictOnAdd(file3, (SVNAdminArea)object22, SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.OBSTRUCTED);
            this.setIsConflicted(blArray, true);
            sVNStatusTypeArray[0] = this.myIsDryRun && this.isPathDeleted(string) ? SVNStatusType.CHANGED : SVNStatusType.OBSTRUCTED;
        } else if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
            if (this.myIsDryRun && this.isPathDeleted(string)) {
                sVNStatusTypeArray[0] = SVNStatusType.CHANGED;
            } else {
                this.myMergeDriver.recordTreeConflictOnAdd(file3, (SVNAdminArea)object22, SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.ADDED);
                this.setIsConflicted(blArray, true);
            }
        }
        return sVNStatusTypeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNStatusType fileDeleted(String string, File file, File file2, String string2, String string3, SVNProperties sVNProperties, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        File file3 = this.getFile(string);
        SVNAdminArea sVNAdminArea = this.retrieve(file3.getParentFile(), true);
        if (sVNAdminArea == null) {
            return SVNStatusType.MISSING;
        }
        SVNStatusType sVNStatusType = this.getStatusForObstructedOrMissing(string);
        if (sVNStatusType != SVNStatusType.INAPPLICABLE) {
            return sVNStatusType;
        }
        SVNFileType sVNFileType = SVNFileType.getType(file3);
        if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
            if (this.areFilesTheSame(file, sVNProperties, file3, sVNAdminArea) || this.myMergeDriver.myIsForce || this.myMergeDriver.myIsRecordOnly) {
                ISVNEventHandler iSVNEventHandler = this.getWCAccess().getEventHandler();
                this.getWCAccess().setEventHandler(null);
                try {
                    this.delete(file3, true, this.myIsDryRun, false);
                }
                catch (SVNException sVNException) {
                    SVNStatusType sVNStatusType2 = SVNStatusType.OBSTRUCTED;
                    return sVNStatusType2;
                }
                finally {
                    this.getWCAccess().setEventHandler(iSVNEventHandler);
                }
                return SVNStatusType.CHANGED;
            }
            this.myMergeDriver.recordTreeConflict(file3, sVNAdminArea, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.EDITED);
            this.setIsConflicted(blArray, true);
            return SVNStatusType.OBSTRUCTED;
        }
        if (sVNFileType == SVNFileType.DIRECTORY) {
            this.myMergeDriver.recordTreeConflict(file3, sVNAdminArea, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.OBSTRUCTED);
            this.setIsConflicted(blArray, true);
            return SVNStatusType.OBSTRUCTED;
        }
        if (sVNFileType == SVNFileType.NONE) {
            this.myMergeDriver.recordTreeConflict(file3, sVNAdminArea, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
            this.setIsConflicted(blArray, true);
            return SVNStatusType.MISSING;
        }
        return SVNStatusType.UNKNOWN;
    }

    @Override
    public SVNStatusType[] directoryClosed(String string, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        return new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};
    }

    protected File getFile(String string) {
        return this.getAdminArea().getFile(string);
    }

    protected SVNAdminArea retrieve(File file, boolean bl2) {
        if (this.getAdminArea() == null) {
            return null;
        }
        try {
            return this.getAdminArea().getWCAccess().retrieve(file);
        }
        catch (SVNException sVNException) {
            if (bl2) {
                return null;
            }
            throw sVNException;
        }
    }

    protected void delete(File file, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl2 && !bl4) {
            SVNWCManager.canDelete(file, this.getWCAccess().getOptions(), this.getWCAccess());
        }
        SVNAdminArea sVNAdminArea = this.getWCAccess().retrieve(file.getParentFile());
        if (!bl3) {
            SVNWCManager.delete(this.getWCAccess(), sVNAdminArea, file, !bl4, false);
        }
    }

    protected boolean areFilesTheSame(File file, SVNProperties sVNProperties, File file2, SVNAdminArea sVNAdminArea) {
        SVNProperties sVNProperties2 = sVNAdminArea.getProperties(file2.getName()).asMap();
        if (this.arePropsTheSame(sVNProperties, sVNProperties2)) {
            return !sVNAdminArea.hasVersionedFileTextChanges(file2, file, true);
        }
        return false;
    }

    private SVNStatusType getStatusForObstructedOrMissing(String string) {
        File file = this.getFile(string);
        SVNEntry sVNEntry = null;
        try {
            sVNEntry = this.getWCAccess().getEntry(file, true);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        if (sVNEntry != null && sVNEntry.isAbsent()) {
            return SVNStatusType.MISSING;
        }
        SVNNodeKind sVNNodeKind = this.getWorkingNodeKind(sVNEntry, string);
        SVNNodeKind sVNNodeKind2 = this.getDiskKind(string);
        if (sVNEntry != null && sVNEntry.isDirectory() && sVNEntry.isScheduledForDeletion() && sVNNodeKind2 == SVNNodeKind.DIR) {
            sVNNodeKind = SVNNodeKind.DIR;
        }
        if (sVNNodeKind == sVNNodeKind2) {
            return SVNStatusType.INAPPLICABLE;
        }
        if (sVNNodeKind2 == SVNNodeKind.NONE) {
            return SVNStatusType.MISSING;
        }
        return SVNStatusType.OBSTRUCTED;
    }

    private SVNNodeKind getWorkingNodeKind(SVNEntry sVNEntry, String string) {
        if (sVNEntry == null || sVNEntry.isScheduledForDeletion() || this.myIsDryRun && this.isPathDeleted(string) || sVNEntry.isDeleted() && !sVNEntry.isScheduledForAddition()) {
            return SVNNodeKind.NONE;
        }
        return sVNEntry.getKind();
    }

    private SVNNodeKind getDiskKind(String string) {
        File file = this.getFile(string);
        SVNFileType sVNFileType = null;
        sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.UNKNOWN) {
            return SVNNodeKind.UNKNOWN;
        }
        if (this.myIsDryRun && this.isPathDeleted(string)) {
            return SVNNodeKind.NONE;
        }
        return SVNFileType.getNodeKind(sVNFileType);
    }

    private boolean arePropsTheSame(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        SVNProperties sVNProperties3 = sVNProperties2.compareTo(sVNProperties);
        SVNProperties sVNProperties4 = new SVNProperties();
        this.categorizeProperties(sVNProperties3, sVNProperties4, null, null);
        for (String string : sVNProperties4.nameSet()) {
            if ("svn:mergeinfo".equals(string)) continue;
            return false;
        }
        return true;
    }
}

