/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.CharsetDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.util.SVNVersion;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.util.jna.SVNOS2Util;
import org.tmatesoft.svn.core.internal.wc.ISVNInputFile;
import org.tmatesoft.svn.core.internal.wc.ISVNReturnValueCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil$1;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil$2;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNFileUtil {
    private static final String ID_COMMAND;
    private static final String LN_COMMAND;
    public static final String LS_COMMAND;
    private static final String CHMOD_COMMAND;
    private static final String ATTRIB_COMMAND;
    private static final String ENV_COMMAND;
    private static final String STAT_COMMAND;
    public static final boolean logNativeCalls;
    public static final boolean isWindows;
    public static final boolean isOS2;
    public static final boolean isOSX;
    public static final boolean isBSD;
    public static final boolean isIno64;
    public static boolean isLinux;
    public static final boolean isSolaris;
    public static final boolean isOpenVMS;
    public static final boolean is32Bit;
    public static final boolean is64Bit;
    public static final boolean isAMD64;
    public static final boolean isAarchh64;
    public static final int STREAM_CHUNK_SIZE = 16384;
    public static final int FILE_CREATION_ATTEMPTS_COUNT;
    public static final OutputStream DUMMY_OUT;
    public static final InputStream DUMMY_IN;
    private static boolean ourUseUnsafeCopyOnly;
    private static boolean ourCopyOnSetWritable;
    private static boolean ourUseNIOCopying;
    private static String nativeEOLMarker;
    private static String ourGroupID;
    private static String ourUserID;
    private static File ourAppDataPath;
    private static String ourAdminDirectoryName;
    private static File ourSystemAppDataPath;
    private static Method ourSetWritableMethod;
    private static Method ourSetExecutableMethod;
    private static volatile boolean ourIsSleepForTimeStamp;
    public static final String BINARY_MIME_TYPE = "application/octet-stream";
    private static String ourTestEditor;
    private static String ourTestMergeTool;
    private static String ourTestFunction;
    private static Method java7readAttributesMethod;
    private static Method java7toPathMethod;
    private static Method java7lastModifiedTimeMethod;
    private static Method java7setLastModifiedTimeMethod;
    private static Method java7toTimeMethod;
    private static Method java7fromTimeMethod;
    private static Class java7BasciFileAttributesClazz;
    private static Class java7FileTimeClazz;
    private static Object java7noFollowLinksParam;
    private static Boolean ourLastModifiedHasMicrosecondPrecision;
    private static final int[] MICROSECOND_PRECISION_JAVA_VERSION;
    private static final String SVNKIT_FS_MTIME_MICROSECOND_PRECISION = "svnkit.fs.mtime_microsecond_precision";

    public static boolean isCaseInsensitiveFS() {
        return isWindows || isOS2;
    }

    public static synchronized boolean useUnsafeCopyOnly() {
        return ourUseUnsafeCopyOnly;
    }

    public static synchronized void setUseUnsafeCopyOnly(boolean bl2) {
        ourUseUnsafeCopyOnly = bl2;
    }

    public static synchronized boolean useCopyOnSetWritable() {
        return ourCopyOnSetWritable;
    }

    public static synchronized void setUseCopyOnSetWritable(boolean bl2) {
        ourCopyOnSetWritable = bl2;
    }

    public static synchronized boolean useNIOCopying() {
        return ourUseNIOCopying;
    }

    public static synchronized void setUseNIOCopying(boolean bl2) {
        ourUseNIOCopying = bl2;
    }

    public static String getIdCommand() {
        return ID_COMMAND;
    }

    public static String getLnCommand() {
        return LN_COMMAND;
    }

    public static String getLsCommand() {
        return LS_COMMAND;
    }

    public static String getChmodCommand() {
        return CHMOD_COMMAND;
    }

    public static String getAttribCommand() {
        return ATTRIB_COMMAND;
    }

    public static String getEnvCommand() {
        return ENV_COMMAND;
    }

    public static String getStatCommand() {
        return STAT_COMMAND;
    }

    public static int getJavaVersion() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.")) {
            string = string.substring(2, 3);
        } else {
            int n2 = string.indexOf(".");
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static File getParentFile(File file) {
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            if ("\\".equals(string) && file.getPath().startsWith("\\\\")) {
                return null;
            }
            if (file.getPath().equals("\\")) {
                return null;
            }
        }
        string = string.replace(File.separatorChar, '/');
        string = SVNPathUtil.canonicalizePath(string);
        int n2 = 0;
        while (string.endsWith("/..")) {
            string = SVNPathUtil.removeTail(string);
            ++n2;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            string = SVNPathUtil.removeTail(string);
        }
        string = string.replace('/', File.separatorChar);
        file = new File(string);
        return file.getParentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(File file) {
        byte[] byArray = new byte[(int)file.length()];
        InputStream inputStream = SVNFileUtil.openFileForReading(file);
        try {
            Object object;
            int n2 = SVNFileUtil.readIntoBuffer(inputStream, byArray, 0, byArray.length);
            if (n2 != byArray.length) {
                object = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
            }
            object = byArray;
            return object;
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) {
        InputStream inputStream = null;
        try {
            inputStream = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
            String string = SVNFileUtil.readFile(inputStream);
            return string;
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from file ''{0}'': {1}", file, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, Level.FINE, SVNLogType.WC);
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
        return null;
    }

    public static String readFile(InputStream inputStream) {
        byte[] byArray = new byte[16384];
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        while ((n2 = inputStream.read(byArray)) != -1) {
            if (n2 == 0) continue;
            stringBuffer.append(new String(byArray, 0, n2, "UTF-8"));
        }
        return stringBuffer.toString();
    }

    public static int readIntoBuffer(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n3 > 0) {
            int n5 = inputStream.read(byArray, n2 + n4, n3);
            if (n5 < 0) {
                if (n4 != 0) break;
                n4 = -1;
                break;
            }
            n4 += n5;
            n3 -= n5;
        }
        return n4;
    }

    public static String getBasePath(File file) {
        Object object;
        File file2 = SVNFileUtil.getFileDir(file);
        while (!(file2 == null || file2.isDirectory() && ((File)(object = new File(file2, SVNFileUtil.getAdminDirectoryName()))).exists() && ((File)object).isDirectory())) {
            file2 = SVNFileUtil.getFileDir(file2);
        }
        object = file.getAbsolutePath();
        if (file2 != null) {
            object = ((String)object).substring(file2.getAbsolutePath().length());
        }
        if (((String)(object = ((String)object).replace(File.separatorChar, '/'))).startsWith("/")) {
            object = ((String)object).substring(1);
        }
        return object;
    }

    public static void createEmptyFile(File file) {
        boolean bl2;
        if (file != null && SVNFileUtil.getFileDir(file) != null && !SVNFileUtil.getFileDir(file).exists()) {
            SVNFileUtil.getFileDir(file).mkdirs();
        }
        IOException iOException = null;
        try {
            bl2 = SVNFileUtil.createNewFile(file);
        }
        catch (IOException iOException2) {
            bl2 = false;
            iOException = iOException2;
        }
        if (!bl2) {
            SVNErrorMessage sVNErrorMessage = null;
            sVNErrorMessage = iOException != null ? SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create new file ''{0}'': {1}", file, iOException.getMessage()) : SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create new file ''{0}''", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, iOException != null ? iOException : new Exception(), Level.FINE, SVNLogType.WC);
        }
    }

    public static boolean createNewFile(File file) {
        if (file == null) {
            return false;
        }
        boolean bl2 = false;
        long l2 = 1L;
        for (int i2 = isWindows ? FILE_CREATION_ATTEMPTS_COUNT : 1; !bl2 && i2 > 0; --i2) {
            IOException iOException = null;
            try {
                bl2 = file.createNewFile();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (iOException != null) {
                if (i2 == 1) {
                    throw iOException;
                }
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, interruptedException, Level.FINEST);
                }
                if (l2 < 128L) {
                    l2 *= 2L;
                }
            }
            if (iOException != null || bl2) continue;
            return false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(File file, String string, String string2) {
        SVNFileUtil.createEmptyFile(file);
        if (string == null || string.length() == 0) {
            return;
        }
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file);
            if (string2 != null) {
                outputStream.write(string.getBytes(string2));
            } else {
                outputStream.write(string.getBytes());
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to file ''{0}'': {1}", file, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to file ''{0}''", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, sVNException, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, String string, String string2) {
        if (string == null || string.length() == 0) {
            return;
        }
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file);
            if (string2 != null) {
                outputStream.write(string.getBytes(string2));
            } else {
                outputStream.write(string.getBytes());
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to file ''{0}'': {1}", file, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to file ''{0}''", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, sVNException, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to file ''{0}'': {1}", file, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to file ''{0}''", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, sVNException, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeVersionFile(File file, int n2) {
        Object object;
        if (n2 < 0) {
            object = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Version {0} is not non-negative", new Object[]{n2});
            SVNErrorManager.error((SVNErrorMessage)object, Level.FINE, SVNLogType.WC);
        }
        object = n2 + "\n";
        File file2 = SVNFileUtil.createUniqueFile(SVNFileUtil.getFileDir(file), SVNFileUtil.getFileName(file), ".tmp", false);
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file2);
            outputStream.write(((String)object).getBytes("US-ASCII"));
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
        if (isWindows) {
            SVNFileUtil.setReadonly(file, false);
        }
        SVNFileUtil.rename(file2, file);
        SVNFileUtil.setReadonly(file, true);
    }

    public static synchronized File createUniqueFile(File file, String string, String string2, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (bl2) {
            stringBuffer.append(".");
            stringBuffer.append(SVNUUIDGenerator.generateUUIDString());
        }
        stringBuffer.append(string2);
        File file2 = new File(file, stringBuffer.toString());
        int n2 = 2;
        do {
            if (SVNFileType.getType(file2) == SVNFileType.NONE) {
                SVNFileUtil.createEmptyFile(file2);
                return file2;
            }
            stringBuffer.setLength(0);
            stringBuffer.append(string);
            stringBuffer.append(".");
            if (bl2) {
                stringBuffer.append(SVNUUIDGenerator.generateUUIDString());
            } else {
                stringBuffer.append(n2);
            }
            stringBuffer.append(string2);
            file2 = new File(file, stringBuffer.toString());
        } while (++n2 < 99999);
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_UNIQUE_NAMES_EXHAUSTED, "Unable to make name for ''{0}''", (Object)new File(file, string));
        SVNErrorManager.error(sVNErrorMessage, Level.FINE, SVNLogType.WC);
        return null;
    }

    public static synchronized File createUniqueDir(File file, String string, String string2, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (bl2) {
            stringBuffer.append(".");
            stringBuffer.append(SVNUUIDGenerator.generateUUIDString());
        }
        stringBuffer.append(string2);
        File file2 = new File(file, stringBuffer.toString());
        int n2 = 2;
        do {
            if (SVNFileType.getType(file2) == SVNFileType.NONE) {
                file2.mkdir();
                return file2;
            }
            stringBuffer.setLength(0);
            stringBuffer.append(string);
            stringBuffer.append(".");
            if (bl2) {
                stringBuffer.append(SVNUUIDGenerator.generateUUIDString());
            } else {
                stringBuffer.append(n2);
            }
            stringBuffer.append(string2);
            file2 = new File(file, stringBuffer.toString());
        } while (++n2 < 99999);
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_UNIQUE_NAMES_EXHAUSTED, "Unable to make name for ''{0}''", (Object)new File(file, string));
        SVNErrorManager.error(sVNErrorMessage, Level.FINE, SVNLogType.WC);
        return null;
    }

    public static void moveFile(File file, File file2) {
        File file3 = SVNFileUtil.createUniqueFile(SVNFileUtil.getFileDir(file2), SVNFileUtil.getFileName(file), "tmp", false);
        try {
            SVNFileUtil.copyFile(file, file3, true);
        }
        catch (SVNException sVNException) {
            try {
                SVNFileUtil.deleteFile(file3);
            }
            catch (SVNException sVNException2) {
                // empty catch block
            }
            throw sVNException;
        }
        try {
            SVNFileUtil.rename(file3, file2);
        }
        catch (SVNException sVNException) {
            try {
                SVNFileUtil.deleteFile(file3);
            }
            catch (SVNException sVNException3) {
                // empty catch block
            }
            throw sVNException;
        }
        try {
            SVNFileUtil.deleteFile(file);
        }
        catch (SVNException sVNException) {
            try {
                SVNFileUtil.deleteFile(file2);
            }
            catch (SVNException sVNException4) {
                // empty catch block
            }
            throw sVNException;
        }
    }

    public static void moveDir(File file, File file2) {
        File file3 = SVNFileUtil.createUniqueDir(SVNFileUtil.getFileDir(file2), SVNFileUtil.getFileName(file), "tmp", false);
        try {
            SVNFileUtil.copyDirectory(file, file3, false, null);
        }
        catch (SVNException sVNException) {
            SVNFileUtil.deleteAll(file3, true);
            throw sVNException;
        }
        try {
            SVNFileUtil.rename(file3, file2);
        }
        catch (SVNException sVNException) {
            SVNFileUtil.deleteAll(file3, true);
            throw sVNException;
        }
        try {
            SVNFileUtil.deleteAll(file, true, null);
        }
        catch (SVNException sVNException) {
            SVNFileUtil.deleteAll(file2, true);
            throw sVNException;
        }
    }

    public static void rename(File file, File file2) {
        boolean bl2;
        if (SVNFileType.getType(file) == SVNFileType.NONE) {
            SVNFileUtil.deleteFile(file2);
            return;
        }
        boolean bl3 = false;
        if (!isWindows) {
            bl3 = file.renameTo(file2);
            if (!bl3 && file.isFile() && !file2.exists()) {
                SVNFileUtil.copyFile(file, file2, true);
                if (!file2.isFile()) {
                    SVNFileUtil.copyFile(file, file2, false);
                }
                bl3 = (bl2 = SVNFileUtil.deleteFile(file)) && file2.isFile();
            }
        } else {
            if (isOS2) {
                if (SVNOS2Util.moveFile(file, file2)) {
                    bl3 = true;
                }
            } else if (SVNJNAUtil.moveFile(file, file2)) {
                bl3 = true;
            }
            if (!bl3) {
                bl2 = file2.getAbsolutePath().equalsIgnoreCase(file.getAbsolutePath());
                boolean bl4 = file2.exists() && !file2.canWrite();
                SVNFileUtil.setReadonly(file, false);
                if (!bl2) {
                    SVNFileUtil.setReadonly(file2, false);
                }
                if (file.renameTo(file2)) {
                    return;
                }
                long l2 = 1L;
                for (int i2 = 0; i2 < FILE_CREATION_ATTEMPTS_COUNT; ++i2) {
                    if (!bl2) {
                        file2.delete();
                    }
                    if (file.renameTo(file2)) {
                        if (bl4 && !isOpenVMS) {
                            file2.setReadOnly();
                        }
                        return;
                    }
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (l2 >= 128L) continue;
                    l2 *= 2L;
                }
            }
        }
        if (!bl3) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot rename file ''{0}'' to ''{1}''", file, file2);
            SVNErrorManager.error(sVNErrorMessage, Level.FINE, SVNLogType.WC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setReadonly(File file, boolean bl2) {
        block18: {
            Object object;
            if (!file.exists()) {
                return false;
            }
            if (isOpenVMS) {
                return true;
            }
            if (bl2) {
                return file.setReadOnly();
            }
            if (ourSetWritableMethod != null) {
                try {
                    object = ourSetWritableMethod.invoke((Object)file, Boolean.TRUE);
                    if (Boolean.TRUE.equals(object)) {
                        return true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (isOS2 ? SVNOS2Util.setWritable(file) : (isWindows ? SVNJNAUtil.setWritable(file) : (isLinux || isOSX || isBSD || isSolaris) && SVNJNAUtil.setWritable(file))) {
                return true;
            }
            try {
                object = SVNFileType.getType(file);
                if (object == SVNFileType.FILE && SVNFileUtil.useCopyOnSetWritable() && file.length() < 102400L) {
                    File file2 = SVNFileUtil.createUniqueFile(SVNFileUtil.getFileDir(file), SVNFileUtil.getFileName(file), ".ro", true);
                    SVNFileUtil.copyFile(file, file2, false);
                    SVNFileUtil.copyFile(file2, file, false);
                    SVNFileUtil.deleteFile(file2);
                    break block18;
                }
                if (isWindows) {
                    Process process = null;
                    try {
                        process = Runtime.getRuntime().exec(ATTRIB_COMMAND + " -R \"" + file.getAbsolutePath() + "\"");
                        process.waitFor();
                        break block18;
                    }
                    finally {
                        if (process != null) {
                            SVNFileUtil.closeFile(process.getInputStream());
                            SVNFileUtil.closeFile(process.getOutputStream());
                            SVNFileUtil.closeFile(process.getErrorStream());
                            process.destroy();
                        }
                    }
                }
                SVNFileUtil.execCommand(new String[]{CHMOD_COMMAND, "ugo+w", file.getAbsolutePath()});
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, throwable);
                return false;
            }
        }
        return true;
    }

    public static void setExecutable(File file, boolean bl2) {
        if (isWindows || isOpenVMS || file == null || !file.exists() || SVNFileType.getType(file) == SVNFileType.SYMLINK) {
            return;
        }
        if (ourSetExecutableMethod != null) {
            try {
                ourSetExecutableMethod.invoke((Object)file, bl2, Boolean.FALSE);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (SVNJNAUtil.setExecutable(file, bl2)) {
            return;
        }
        try {
            if (file.canWrite()) {
                SVNFileUtil.execCommand(new String[]{CHMOD_COMMAND, bl2 ? "ugo+x" : "ugo-x", file.getAbsolutePath()});
            }
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, throwable);
        }
    }

    public static boolean symlinksSupported() {
        return !isWindows && !isOpenVMS && SVNFileType.isSymlinkSupportEnabled();
    }

    public static void setSGID(File file) {
        if (isWindows || isOpenVMS || file == null || !file.exists() || !file.isDirectory()) {
            return;
        }
        if (SVNJNAUtil.setSGID(file)) {
            return;
        }
        try {
            SVNFileUtil.execCommand(new String[]{CHMOD_COMMAND, "g+s", file.getAbsolutePath()});
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, throwable);
        }
    }

    public static File resolveSymlinkToFile(File file) {
        if (!SVNFileUtil.symlinksSupported()) {
            return null;
        }
        File file2 = SVNFileUtil.resolveSymlink(file);
        if (file2 == null || !file2.isFile()) {
            return null;
        }
        return file2;
    }

    public static File resolveSymlink(File file) {
        if (!SVNFileUtil.symlinksSupported()) {
            return null;
        }
        File file2 = file;
        while (SVNFileType.getType(file2) == SVNFileType.SYMLINK) {
            String string = SVNFileUtil.getSymlinkName(file2);
            if (string == null) {
                return null;
            }
            if (string.startsWith("/")) {
                file2 = new File(string);
                continue;
            }
            file2 = new File(SVNFileUtil.getFileDir(file2), string);
        }
        return file2;
    }

    public static void copy(File file, File file2, boolean bl2, boolean bl3) {
        String string;
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.FILE) {
            SVNFileUtil.copyFile(file, file2, bl2);
        } else if (sVNFileType == SVNFileType.DIRECTORY) {
            SVNFileUtil.copyDirectory(file, file2, bl3, null);
        } else if (sVNFileType == SVNFileType.SYMLINK && (string = SVNFileUtil.getSymlinkName(file)) != null) {
            SVNFileUtil.createSymlink(file2, string);
        }
    }

    public static void copyFile(File file, File file2, boolean bl2) {
        SVNFileUtil.copyFile(file, file2, bl2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2, boolean bl2, boolean bl3) {
        Closeable closeable;
        Closeable closeable2;
        if (file == null || file2 == null) {
            return;
        }
        if (file.equals(file2)) {
            return;
        }
        if (!file.exists()) {
            file2.delete();
            return;
        }
        File file3 = file2;
        if (SVNFileType.getType(file2) != SVNFileType.NONE) {
            if (bl2 && !SVNFileUtil.useUnsafeCopyOnly()) {
                file3 = SVNFileUtil.createUniqueFile(SVNFileUtil.getFileDir(file2), ".copy", ".tmp", true);
            } else {
                file2.delete();
            }
        }
        boolean bl4 = SVNFileUtil.isExecutable(file);
        SVNFileUtil.getFileDir(file2).mkdirs();
        SVNErrorMessage sVNErrorMessage = null;
        boolean bl5 = SVNFileUtil.useNIOCopying();
        if (bl5) {
            closeable2 = null;
            closeable = null;
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                long l2;
                fileInputStream = SVNFileUtil.createFileInputStream(file);
                closeable2 = fileInputStream.getChannel();
                fileOutputStream = SVNFileUtil.createFileOutputStream(file3, false);
                closeable = fileOutputStream.getChannel();
                for (long i2 = l2 = ((FileChannel)closeable2).size(); i2 > 0L; i2 -= ((FileChannel)closeable).transferFrom((ReadableByteChannel)closeable2, l2 - i2, i2)) {
                }
            }
            catch (IOException iOException) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy file ''{0}'' to ''{1}'': {2}", file, file2, iOException.getLocalizedMessage());
            }
            finally {
                if (closeable2 != null) {
                    try {
                        ((AbstractInterruptibleChannel)closeable2).close();
                    }
                    catch (IOException iOException) {}
                }
                if (closeable != null) {
                    try {
                        ((AbstractInterruptibleChannel)closeable).close();
                    }
                    catch (IOException iOException) {}
                }
                SVNFileUtil.closeFile(fileInputStream);
                SVNFileUtil.closeFile(fileOutputStream);
            }
        }
        if (!bl5 || sVNErrorMessage != null) {
            sVNErrorMessage = null;
            closeable2 = null;
            closeable = null;
            try {
                closeable2 = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
                closeable = SVNFileUtil.openFileForWriting(file3);
                SVNTranslator.copy((InputStream)closeable2, (OutputStream)closeable);
            }
            catch (IOException iOException) {
                try {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy file ''{0}'' to ''{1}'': {2}", file, file2, iOException.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(closeable);
                    SVNFileUtil.closeFile((InputStream)closeable2);
                    throw throwable;
                }
                SVNFileUtil.closeFile((OutputStream)closeable);
                SVNFileUtil.closeFile((InputStream)closeable2);
            }
            SVNFileUtil.closeFile((OutputStream)closeable);
            SVNFileUtil.closeFile((InputStream)closeable2);
        }
        if (sVNErrorMessage != null) {
            SVNErrorManager.error(sVNErrorMessage, Level.FINE, SVNLogType.WC);
        }
        if (bl2 && file3 != file2) {
            SVNFileUtil.rename(file3, file2);
        }
        if (bl4) {
            SVNFileUtil.setExecutable(file2, true);
        }
        if (bl3) {
            SVNFileUtil.setLastModified(file2, file.lastModified());
        }
    }

    public static boolean setLastModified(File file, long l2) {
        if (file != null && l2 >= 0L) {
            return file.setLastModified(l2);
        }
        return false;
    }

    public static boolean createSymlink(File file, File file2) {
        Object object;
        if (!SVNFileUtil.symlinksSupported()) {
            return false;
        }
        if (SVNFileType.getType(file) != SVNFileType.NONE) {
            object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create symbolic link ''{0}''; file already exists", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, Level.FINE, SVNLogType.WC);
        }
        object = "";
        try {
            object = SVNFileUtil.readSingleLine(file2);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        if (((String)object).startsWith("link ")) {
            object = ((String)object).substring("link".length()).trim();
            return SVNFileUtil.createSymlink(file, (String)object);
        }
        SVNFileUtil.createFile(file, (String)object, "UTF-8");
        return true;
    }

    public static boolean createSymlink(File file, String string) {
        if (!SVNFileUtil.symlinksSupported()) {
            return false;
        }
        if (SVNJNAUtil.createSymlink(file, string)) {
            return true;
        }
        try {
            SVNFileUtil.execCommand(new String[]{LN_COMMAND, "-s", string, file.getAbsolutePath()});
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, throwable);
        }
        return SVNFileType.getType(file) == SVNFileType.SYMLINK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean detranslateSymlink(File file, File file2) {
        Object object;
        Object object2;
        if (!SVNFileUtil.symlinksSupported()) {
            return false;
        }
        if (SVNFileType.getType(file) != SVNFileType.SYMLINK) {
            object2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object2, Level.FINE, SVNLogType.WC);
        }
        if ((object2 = SVNFileUtil.getSymlinkName(file)) == null) {
            object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, Level.FINE, SVNLogType.WC);
        }
        object = SVNFileUtil.openFileForWriting(file2);
        try {
            ((OutputStream)object).write("link ".getBytes("UTF-8"));
            ((OutputStream)object).write(((String)object2).getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile((OutputStream)object);
        }
        return true;
    }

    public static String getSymlinkName(File file) {
        if (!SVNFileUtil.symlinksSupported() || file == null) {
            return null;
        }
        String string = null;
        string = SVNJNAUtil.getLinkTarget(file);
        if (string != null) {
            return string;
        }
        try {
            string = SVNFileUtil.execCommand(new String[]{LS_COMMAND, "-ld", file.getAbsolutePath()});
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, throwable);
        }
        if (string == null || string.lastIndexOf(" -> ") < 0) {
            return null;
        }
        int n2 = string.lastIndexOf(" -> ") + " -> ".length();
        if (n2 <= string.length()) {
            return string.substring(n2);
        }
        return null;
    }

    public static void copySymlink(File file, File file2) {
        if (file.equals(file2)) {
            return;
        }
        SVNFileUtil.createSymlink(file2, SVNFileUtil.getSymlinkName(file));
    }

    public static String computeChecksum(String string) {
        MessageDigest messageDigest;
        if (string == null) {
            return null;
        }
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        if (messageDigest == null) {
            return null;
        }
        messageDigest.update(string.getBytes());
        return SVNFileUtil.toHexDigest(messageDigest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeChecksum(File file) {
        MessageDigest messageDigest;
        if (file == null || file.isDirectory() || !file.exists()) {
            return null;
        }
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)noSuchAlgorithmException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, noSuchAlgorithmException, Level.FINE, SVNLogType.DEFAULT);
            return null;
        }
        InputStream inputStream = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
        byte[] byArray = new byte[16384];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) >= 0) {
                if (n2 == 0) continue;
                messageDigest.update(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
        return SVNFileUtil.toHexDigest(messageDigest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareFiles(File file, File file2, MessageDigest messageDigest) {
        if (file == null || file2 == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "NULL paths are supported in compareFiles method");
            SVNErrorManager.error(sVNErrorMessage, Level.FINE, SVNLogType.WC);
            return false;
        }
        if (file.equals(file2)) {
            return true;
        }
        boolean bl2 = true;
        if (file.length() != file2.length()) {
            if (messageDigest == null) {
                return false;
            }
            bl2 = false;
        }
        InputStream inputStream = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
        InputStream inputStream2 = SVNFileUtil.openFileForReading(file2, SVNLogType.WC);
        try {
            while (true) {
                int n2;
                int n3;
                if ((n3 = inputStream.read()) != (n2 = inputStream2.read())) {
                    if (messageDigest == null) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    bl2 = false;
                }
                if (n3 < 0) {
                    break;
                }
                if (messageDigest == null) continue;
                messageDigest.update((byte)(n3 & 0xFF));
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
            SVNFileUtil.closeFile(inputStream2);
        }
        return bl2;
    }

    public static void truncate(File file, long l2) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = SVNFileUtil.openRAFileForWriting(file, false);
            randomAccessFile.setLength(l2);
        }
        catch (SVNException sVNException) {
            throw (IOException)new IOException(sVNException.getMessage()).initCause(sVNException);
        }
        finally {
            SVNFileUtil.closeFile(randomAccessFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHidden(File file, boolean bl2) {
        if (isOS2 && SVNOS2Util.setHidden(file, bl2)) {
            return;
        }
        if (isWindows && SVNJNAUtil.setHidden(file)) {
            return;
        }
        if (!isWindows || file == null || !file.exists() || file.isHidden()) {
            return;
        }
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("attrib " + (bl2 ? "+" : "-") + "H \"" + file.getAbsolutePath() + "\"");
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, throwable);
        }
        finally {
            if (process != null) {
                SVNFileUtil.closeFile(process.getErrorStream());
                SVNFileUtil.closeFile(process.getInputStream());
                SVNFileUtil.closeFile(process.getOutputStream());
                process.destroy();
            }
        }
    }

    public static void deleteAll(File file, ISVNEventHandler iSVNEventHandler) {
        SVNFileUtil.deleteAll(file, true, iSVNEventHandler);
    }

    public static void deleteAll(File file, boolean bl2) {
        try {
            SVNFileUtil.deleteAll(file, bl2, null);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    public static void deleteAll(File file, boolean bl2, ISVNCanceller iSVNCanceller) {
        File[] fileArray;
        if (file == null) {
            return;
        }
        SVNFileType sVNFileType = SVNFileType.getType(file);
        File[] fileArray2 = fileArray = sVNFileType == SVNFileType.DIRECTORY ? SVNFileListUtil.listFiles(file) : null;
        if (fileArray != null) {
            if (iSVNCanceller != null) {
                iSVNCanceller.checkCancelled();
            }
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                File file2 = fileArray[i2];
                SVNFileUtil.deleteAll(file2, bl2, iSVNCanceller);
            }
            if (iSVNCanceller != null) {
                iSVNCanceller.checkCancelled();
            }
        }
        if (sVNFileType == SVNFileType.DIRECTORY && !bl2) {
            return;
        }
        SVNFileUtil.deleteFile(file);
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            return true;
        }
        if (!isWindows || file.isDirectory() || !file.exists()) {
            return file.delete();
        }
        long l2 = 1L;
        for (int i2 = 0; i2 < FILE_CREATION_ATTEMPTS_COUNT; ++i2) {
            if (file.delete() && !file.exists()) {
                return true;
            }
            if (!file.exists()) {
                return true;
            }
            SVNFileUtil.setReadonly(file, false);
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (l2 >= 128L) continue;
            l2 *= 2L;
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot delete file ''{0}''", (Object)file);
        SVNErrorManager.error(sVNErrorMessage, Level.FINE, SVNLogType.WC);
        return false;
    }

    public static String toHexDigest(MessageDigest messageDigest) {
        if (messageDigest == null) {
            return null;
        }
        byte[] byArray = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            SVNFormatUtil.appendHexNumber(stringBuffer, byArray[i2]);
        }
        return stringBuffer.toString();
    }

    public static String toHexDigest(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            SVNFormatUtil.appendHexNumber(stringBuffer, byArray[i2]);
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHexDigest(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n2 = (string = string.toLowerCase()).length() / 2;
        if (n2 == 0 || 2 * n2 != string.length()) {
            return null;
        }
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < string.length() / 2; ++i2) {
            byte by;
            if (!SVNFileUtil.isHex(string.charAt(2 * i2)) || !SVNFileUtil.isHex(string.charAt(2 * i2 + 1))) {
                return null;
            }
            int n3 = Character.digit(string.charAt(2 * i2), 16) << 4;
            int n4 = Character.digit(string.charAt(2 * i2 + 1), 16);
            Integer n5 = n3 | n4;
            byArray[i2] = by = n5.byteValue();
        }
        return byArray;
    }

    public static String getNativeEOLMarker(ISVNOptions iSVNOptions) {
        if (nativeEOLMarker == null) {
            nativeEOLMarker = new String(iSVNOptions.getNativeEOL());
        }
        return nativeEOLMarker;
    }

    public static long roundTimeStamp(long l2) {
        return l2 / 1000L * 1000L;
    }

    public static void sleepForTimestamp() {
        if (!ourIsSleepForTimeStamp) {
            return;
        }
        long l2 = System.currentTimeMillis();
        l2 = 1100L - (l2 - l2 / 1000L * 1000L);
        try {
            Thread.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void setSleepForTimestamp(boolean bl2) {
        ourIsSleepForTimeStamp = bl2;
    }

    public static String readLineFromStream(InputStream inputStream, StringBuffer stringBuffer, CharsetDecoder charsetDecoder) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = -1;
        while ((n2 = inputStream.read()) != 10) {
            if (n2 == -1) {
                String string = SVNFileUtil.decode(charsetDecoder, byteArrayOutputStream.toByteArray());
                stringBuffer.append(string);
                return null;
            }
            byteArrayOutputStream.write(n2);
        }
        String string = SVNFileUtil.decode(charsetDecoder, byteArrayOutputStream.toByteArray());
        stringBuffer.append(string);
        return string;
    }

    public static String detectMimeType(InputStream inputStream) {
        byte[] byArray = new byte[1024];
        int n2 = SVNFileUtil.readIntoBuffer(inputStream, byArray, 0, byArray.length);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray[i2];
            if (by == 0) {
                return BINARY_MIME_TYPE;
            }
            if (by >= 7 && (by <= 13 || by >= 32) && by <= 127) continue;
            ++n3;
        }
        if (n2 > 0 && n3 * 1000 / n2 > 850) {
            return BINARY_MIME_TYPE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectMimeType(File file, Map map) {
        String string;
        Object object;
        if (file == null || !file.exists()) {
            return null;
        }
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType != SVNFileType.FILE) {
            object = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "Can''t detect MIME type of non-file ''{0}''", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, Level.FINE, SVNLogType.WC);
        }
        if (map != null) {
            String string2;
            object = SVNFileUtil.getFileName(file);
            string = "";
            int n2 = ((String)object).lastIndexOf(46);
            if (n2 != -1 && n2 != 0 && n2 != ((String)object).length() - 1) {
                string = ((String)object).substring(n2 + 1);
            }
            if ((string2 = (String)map.get(string)) != null) {
                return string2;
            }
        }
        object = null;
        try {
            object = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
            string = SVNFileUtil.detectMimeType((InputStream)object);
            return string;
        }
        catch (IOException iOException) {
            String string3 = null;
            return string3;
        }
        catch (SVNException sVNException) {
            String string4 = null;
            return string4;
        }
        finally {
            SVNFileUtil.closeFile((InputStream)object);
        }
    }

    public static boolean isExecutable(File file) {
        if (isWindows || isOpenVMS) {
            return false;
        }
        Boolean bl2 = SVNJNAUtil.isExecutable(file);
        if (bl2 != null) {
            return bl2;
        }
        String[] stringArray = new String[]{LS_COMMAND, "-ln", file.getAbsolutePath()};
        String string = null;
        try {
            if (file.canRead()) {
                string = SVNFileUtil.execCommand(stringArray);
            }
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, throwable);
        }
        if (string == null || string.indexOf(32) < 0) {
            return false;
        }
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (n2 == 0) {
                string2 = string5;
            } else if (n2 == 2) {
                string3 = string5;
            } else if (n2 == 3) {
                string4 = string5;
            } else if (n2 > 3) break;
            ++n2;
        }
        if (string2 == null) {
            return false;
        }
        if (SVNFileUtil.getCurrentUser().equals(string3)) {
            return string2.toLowerCase().indexOf(120) >= 0 && string2.toLowerCase().indexOf(120) < 4;
        }
        if (SVNFileUtil.getCurrentGroup().equals(string4)) {
            return string2.toLowerCase().indexOf(120, 4) >= 4 && string2.toLowerCase().indexOf(120, 4) < 7;
        }
        return string2.toLowerCase().indexOf(120, 7) >= 7;
    }

    public static File ensureDirectoryExists(File file) {
        boolean bl2;
        SVNFileType sVNFileType = SVNFileType.getType(file);
        SVNNodeKind sVNNodeKind = SVNFileType.getNodeKind(sVNFileType);
        if (sVNNodeKind != SVNNodeKind.NONE && sVNNodeKind != SVNNodeKind.DIR) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' is not a directory", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        } else if (sVNNodeKind == SVNNodeKind.NONE && !(bl2 = file.mkdirs())) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Unable to make directories", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return file;
    }

    public static void copyDirectory(File file, File file2, boolean bl2, ISVNEventHandler iSVNEventHandler) {
        if (!file2.exists()) {
            file2.mkdirs();
            SVNFileUtil.setLastModified(file2, file.lastModified());
        }
        File[] fileArray = SVNFileListUtil.listFiles(file);
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            String string;
            File file3 = fileArray[i2];
            if (SVNFileUtil.getFileName(file3).equals("..") || SVNFileUtil.getFileName(file3).equals(".") || file3.equals(file2)) continue;
            if (iSVNEventHandler != null) {
                iSVNEventHandler.checkCancelled();
            }
            if (!bl2 && SVNFileUtil.getFileName(file3).equals(SVNFileUtil.getAdminDirectoryName())) continue;
            SVNFileType sVNFileType = SVNFileType.getType(file3);
            File file4 = new File(file2, SVNFileUtil.getFileName(file3));
            if (sVNFileType == SVNFileType.FILE) {
                boolean bl3 = SVNFileUtil.isExecutable(file3);
                SVNFileUtil.copyFile(file3, file4, false);
                if (!bl3) continue;
                SVNFileUtil.setExecutable(file4, bl3);
                continue;
            }
            if (sVNFileType == SVNFileType.DIRECTORY) {
                SVNFileUtil.copyDirectory(file3, file4, bl2, iSVNEventHandler);
                if (!file3.isHidden() && !SVNFileUtil.getAdminDirectoryName().equals(SVNFileUtil.getFileName(file3))) continue;
                SVNFileUtil.setHidden(file4, true);
                continue;
            }
            if (sVNFileType != SVNFileType.SYMLINK || (string = SVNFileUtil.getSymlinkName(file3)) == null) continue;
            SVNFileUtil.createSymlink(file4, string);
        }
    }

    public static OutputStream openFileForWriting(File file) {
        return SVNFileUtil.openFileForWriting(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream openFileForWriting(File file, boolean bl2) {
        if (file == null) {
            return null;
        }
        if (SVNFileUtil.getFileDir(file) != null && !SVNFileUtil.getFileDir(file).exists()) {
            SVNFileUtil.getFileDir(file).mkdirs();
        }
        if (isOpenVMS && !bl2 && file.isFile()) {
            SVNFileUtil.deleteFile(file);
        } else if (file.isFile() && !file.canWrite()) {
            SVNFileUtil.setReadonly(file, false);
        }
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            fileOutputStream = SVNFileUtil.createFileOutputStream(file, bl2);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        }
        catch (IOException iOException) {
            SVNFileUtil.closeFile(fileOutputStream);
            SVNFileUtil.closeFile(bufferedOutputStream);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to ''{0}'': {1}", file, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            if (bufferedOutputStream == null) {
                SVNFileUtil.closeFile(fileOutputStream);
            }
        }
        return bufferedOutputStream;
    }

    public static FileOutputStream createFileOutputStream(File file, boolean bl2) {
        int n2 = isWindows ? FILE_CREATION_ATTEMPTS_COUNT : 1;
        FileOutputStream fileOutputStream = null;
        long l2 = 1L;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                fileOutputStream = new FileOutputStream(file, bl2);
                break;
            }
            catch (IOException iOException) {
                SVNFileUtil.closeFile(fileOutputStream);
                if (i2 + 1 >= n2) {
                    throw iOException;
                }
                if (file.exists() && file.isFile() && file.canWrite()) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (l2 >= 128L) continue;
                    l2 *= 2L;
                    continue;
                }
                throw iOException;
            }
        }
        return fileOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomAccessFile openRAFileForWriting(File file, boolean bl2) {
        if (file == null) {
            return null;
        }
        if (SVNFileUtil.getFileDir(file) != null && !SVNFileUtil.getFileDir(file).exists()) {
            SVNFileUtil.getFileDir(file).mkdirs();
        }
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            if (bl2) {
                randomAccessFile.seek(randomAccessFile.length());
            }
            randomAccessFile2 = randomAccessFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            SVNFileUtil.closeFile(randomAccessFile);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not write to file ''{0}'': {1}", file, fileNotFoundException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, fileNotFoundException, Level.FINE, SVNLogType.DEFAULT);
        }
        catch (IOException iOException) {
            SVNFileUtil.closeFile(randomAccessFile);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not set position pointer in file ''{0}'': {1}", file, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            if (randomAccessFile2 == null) {
                SVNFileUtil.closeFile(randomAccessFile);
            }
        }
        return randomAccessFile2;
    }

    public static InputStream openFileForReading(File file) {
        return SVNFileUtil.openFileForReading(file, Level.FINE, SVNLogType.DEFAULT);
    }

    public static InputStream openFileForReading(File file, SVNLogType sVNLogType) {
        return SVNFileUtil.openFileForReading(file, Level.FINE, sVNLogType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream openFileForReading(File file, Level level, SVNLogType sVNLogType) {
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = SVNFileUtil.createFileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            SVNFileUtil.closeFile(fileInputStream);
            SVNFileUtil.closeFile(bufferedInputStream);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from ''{0}'': {1}", file, fileNotFoundException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, level, sVNLogType);
        }
        catch (IOException iOException) {
            SVNFileUtil.closeFile(fileInputStream);
            SVNFileUtil.closeFile(bufferedInputStream);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from ''{0}'': {1}", file, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, level, sVNLogType);
        }
        finally {
            if (bufferedInputStream == null) {
                SVNFileUtil.closeFile(fileInputStream);
            }
        }
        return bufferedInputStream;
    }

    public static FileInputStream createFileInputStream(File file) {
        int n2 = isWindows ? FILE_CREATION_ATTEMPTS_COUNT : 1;
        FileInputStream fileInputStream = null;
        long l2 = 1L;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                fileInputStream = new FileInputStream(file);
                break;
            }
            catch (IOException iOException) {
                SVNFileUtil.closeFile(fileInputStream);
                if (i2 + 1 >= n2) {
                    throw iOException;
                }
                if (file.exists() && file.isFile() && file.canRead()) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (l2 >= 128L) continue;
                    l2 *= 2L;
                    continue;
                }
                throw iOException;
            }
        }
        return fileInputStream;
    }

    public static RandomAccessFile openRAFileForReading(File file) {
        SVNErrorMessage sVNErrorMessage;
        if (file == null) {
            return null;
        }
        if (!file.isFile() || !file.canRead()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from ''{0}'': path refers to a directory or read access is denied", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, Level.FINE, SVNLogType.WC);
        }
        if (!file.exists()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "File ''{0}'' does not exist", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, Level.FINE, SVNLogType.WC);
        }
        try {
            return new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from ''{0}'': {1}", file, fileNotFoundException.getMessage());
            SVNErrorManager.error(sVNErrorMessage2, Level.FINE, SVNLogType.WC);
            return null;
        }
    }

    public static void closeFile(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeFile(ISVNInputFile iSVNInputFile) {
        if (iSVNInputFile == null) {
            return;
        }
        try {
            iSVNInputFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeFile(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeFile(RandomAccessFile randomAccessFile) {
        if (randomAccessFile == null) {
            return;
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String execCommand(String[] stringArray) {
        return SVNFileUtil.execCommand(stringArray, false, null);
    }

    public static String execCommand(String[] stringArray, boolean bl2, ISVNReturnValueCallback iSVNReturnValueCallback) {
        return SVNFileUtil.execCommand(stringArray, null, bl2, iSVNReturnValueCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String execCommand(String[] stringArray, String[] stringArray2, boolean bl2, ISVNReturnValueCallback iSVNReturnValueCallback) {
        String string;
        Process process;
        StringBuffer stringBuffer;
        boolean bl3;
        InputStream inputStream;
        block13: {
            int n2;
            block12: {
                inputStream = null;
                bl3 = iSVNReturnValueCallback != null && iSVNReturnValueCallback.isHandleProgramOutput();
                stringBuffer = bl3 ? null : new StringBuffer();
                process = null;
                process = Runtime.getRuntime().exec(stringArray, stringArray2);
                inputStream = process.getInputStream();
                if (bl2) break block12;
                n2 = process.waitFor();
                if (iSVNReturnValueCallback != null) {
                    iSVNReturnValueCallback.handleReturnValue(n2);
                }
                if (n2 == 0) break block12;
                String string2 = null;
                SVNFileUtil.closeFile(inputStream);
                if (process == null) return string2;
                process.destroy();
                return string2;
            }
            while ((n2 = inputStream.read()) >= 0) {
                char c2 = (char)(n2 & 0xFF);
                if (bl3) {
                    iSVNReturnValueCallback.handleChar(c2);
                    continue;
                }
                stringBuffer.append(c2);
            }
            if (!bl2) break block13;
            int n3 = process.waitFor();
            if (iSVNReturnValueCallback != null) {
                iSVNReturnValueCallback.handleReturnValue(n3);
            }
            if (n3 == 0) break block13;
            String string3 = null;
            SVNFileUtil.closeFile(inputStream);
            if (process == null) return string3;
            process.destroy();
            return string3;
        }
        try {
            string = bl3 ? null : stringBuffer.toString().trim();
        }
        catch (IOException iOException) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, iOException);
            SVNFileUtil.closeFile(inputStream);
            if (process == null) return null;
            process.destroy();
            return null;
        }
        catch (InterruptedException interruptedException) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, interruptedException);
            {
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(inputStream);
                    if (process == null) throw throwable;
                    process.destroy();
                    throw throwable;
                }
            }
            SVNFileUtil.closeFile(inputStream);
            if (process == null) return null;
            process.destroy();
            return null;
        }
        SVNFileUtil.closeFile(inputStream);
        if (process == null) return string;
        process.destroy();
        return string;
    }

    public static void closeFile(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeFile(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getAdminDirectoryName() {
        if (ourAdminDirectoryName == null) {
            String string = ".svn";
            if (SVNFileUtil.getEnvironmentVariable("SVN_ASP_DOT_NET_HACK") != null) {
                string = "_svn";
            }
            if ((ourAdminDirectoryName = System.getProperty("svnkit.admindir", System.getProperty("javasvn.admindir", string))) == null || "".equals(ourAdminDirectoryName.trim())) {
                ourAdminDirectoryName = string;
            }
        }
        return ourAdminDirectoryName;
    }

    public static void setAdminDirectoryName(String string) {
        ourAdminDirectoryName = string;
    }

    public static File getApplicationDataPath() {
        if (ourAppDataPath != null) {
            return ourAppDataPath;
        }
        String string = SVNJNAUtil.getApplicationDataPath(false);
        if (string != null) {
            ourAppDataPath = new File(string);
            return ourAppDataPath;
        }
        String string2 = SVNFileUtil.getEnvironmentVariable("APPDATA");
        ourAppDataPath = string2 == null ? SVNFileUtil.getSystemApplicationDataPath() : new File(string2);
        return ourAppDataPath;
    }

    public static File getSystemApplicationDataPath() {
        if (ourSystemAppDataPath != null) {
            return ourSystemAppDataPath;
        }
        String string = SVNJNAUtil.getApplicationDataPath(true);
        if (string != null) {
            ourSystemAppDataPath = new File(string);
            return ourSystemAppDataPath;
        }
        String string2 = SVNFileUtil.getEnvironmentVariable("ALLUSERSPROFILE");
        ourSystemAppDataPath = string2 == null ? new File(new File("C:/Documents and Settings/All Users"), "Application Data") : new File(string2, "Application Data");
        return ourSystemAppDataPath;
    }

    public static String getEnvironmentVariable(String string) {
        try {
            Object object;
            Method method = System.class.getMethod("getenv", String.class);
            if (method != null && (object = method.invoke(null, string)) instanceof String) {
                return (String)object;
            }
        }
        catch (Throwable throwable) {
            try {
                return SVNFileUtil.getEnvironment().getProperty(string);
            }
            catch (Throwable throwable2) {
                SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, throwable);
                SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, throwable2);
                return null;
            }
        }
        return null;
    }

    public static void setTestEnvironment(String string, String string2, String string3) {
        ourTestEditor = string;
        ourTestMergeTool = string2;
        ourTestFunction = string3;
    }

    public static String[] getTestEnvironment() {
        return new String[]{ourTestEditor, ourTestMergeTool, ourTestFunction};
    }

    public static Properties getEnvironment() {
        Process process = null;
        Properties properties = new Properties();
        Runtime runtime = Runtime.getRuntime();
        process = isWindows ? (System.getProperty("os.name").toLowerCase().indexOf("windows 9") >= 0 ? runtime.exec("command.com /c set") : runtime.exec("cmd.exe /c set")) : runtime.exec(ENV_COMMAND);
        if (process != null) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                int n2 = string.indexOf(61);
                if (n2 < 0) continue;
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                properties.setProperty(string2, string3);
            }
        }
        return properties;
    }

    public static File createTempDirectory(String string) {
        File file = null;
        try {
            file = File.createTempFile("svnkit" + string, ".tmp");
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create temporary directory: {0}", (Object)iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        if (file.exists()) {
            file.delete();
        }
        file.mkdirs();
        return file;
    }

    public static File createTempFile(String string, String string2) {
        File file = null;
        try {
            if (string.length() < 3) {
                string = "svn" + string;
            }
            file = File.createTempFile(string, string2);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create temporary file: {0}", (Object)iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, Level.FINE, SVNLogType.DEFAULT);
        }
        return file;
    }

    public static File getSystemConfigurationDirectory() {
        if (isWindows) {
            return new File(SVNFileUtil.getSystemApplicationDataPath(), "Subversion");
        }
        if (isOpenVMS) {
            return new File("/sys$config", "subversion").getAbsoluteFile();
        }
        return new File("/etc/subversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSingleLine(File file) {
        if (!file.isFile() || !file.canRead()) {
            throw new IOException("can't open file '" + file.getAbsolutePath() + "'");
        }
        BufferedReader bufferedReader = null;
        String string = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = SVNFileUtil.createFileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            string = bufferedReader.readLine();
        }
        finally {
            SVNFileUtil.closeFile(fileInputStream);
        }
        return string;
    }

    private static String decode(CharsetDecoder charsetDecoder, byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.allocate(byteBuffer.capacity() * Math.round(charsetDecoder.maxCharsPerByte() + 0.5f));
        charsetDecoder.decode(byteBuffer, charBuffer, true);
        charsetDecoder.flush(charBuffer);
        charsetDecoder.reset();
        return charBuffer.flip().toString();
    }

    public static String getCurrentUser() {
        if (isWindows || isOpenVMS) {
            return System.getProperty("user.name");
        }
        if (ourUserID == null && (ourUserID = SVNFileUtil.execCommand(new String[]{ID_COMMAND, "-u"})) == null) {
            ourUserID = "0";
        }
        return ourUserID;
    }

    public static String getCurrentGroup() {
        if (isWindows || isOpenVMS) {
            return System.getProperty("user.name");
        }
        if (ourGroupID == null && (ourGroupID = SVNFileUtil.execCommand(new String[]{ID_COMMAND, "-g"})) == null) {
            ourGroupID = "0";
        }
        return ourGroupID;
    }

    private static boolean isHex(char c2) {
        return Character.isDigit(c2) || Character.toUpperCase(c2) >= 'A' && Character.toUpperCase(c2) <= 'F';
    }

    public static boolean isAbsolute(File file) {
        return file != null && file.isAbsolute();
    }

    public static String getFilePath(File file) {
        if (file == null) {
            return null;
        }
        String string = file.getPath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        return string;
    }

    public static String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    public static File getFileDir(File file) {
        if (file == null || "".equals(file.getPath())) {
            return null;
        }
        File file2 = file.getParentFile();
        return file2 != null ? file2 : new File("");
    }

    public static File createFilePath(String string) {
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public static File createFilePath(File file, File file2) {
        if (file2 == null) {
            return file;
        }
        if (SVNFileUtil.isAbsolute(file2)) {
            return file2;
        }
        return SVNFileUtil.createFilePath(file, file2.toString());
    }

    public static File createFilePath(File file, String string) {
        if (string == null) {
            return file;
        }
        if (file == null) {
            return SVNFileUtil.createFilePath(string);
        }
        return SVNFileUtil.createFilePath(file.toString(), string.toString());
    }

    public static File createFilePath(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string == null || "".equals(string)) {
            return SVNFileUtil.createFilePath(string2);
        }
        if (SVNPathUtil.isAbsolute(string2)) {
            return SVNFileUtil.createFilePath(string2);
        }
        return new File(string, string2.toString());
    }

    public static File skipAncestor(File file, File file2) {
        String string;
        String string2 = SVNFileUtil.getFilePath(file);
        if (SVNPathUtil.isAncestor(string2, string = SVNFileUtil.getFilePath(file2))) {
            return SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(string2, string));
        }
        return null;
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return SVNFileUtil.getFileNameExtension(file.getName());
    }

    public static String getFileNameExtension(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 != -1 && n2 != 0 && n2 != string.length() - 1) {
            return string.substring(n2 + 1);
        }
        return null;
    }

    public static boolean compare(InputStream inputStream, InputStream inputStream2) {
        try {
            int n2;
            do {
                int n3;
                if ((n2 = inputStream.read()) == (n3 = inputStream2.read())) continue;
                return false;
            } while (n2 >= 0);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static InputStream readSymlink(File file) {
        SVNFileType sVNFileType;
        if (SVNFileUtil.symlinksSupported() && (sVNFileType = SVNFileType.getType(file)) == SVNFileType.SYMLINK) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("link ");
            stringBuffer.append(SVNFileUtil.getSymlinkName(file));
            try {
                return new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new ByteArrayInputStream(stringBuffer.toString().getBytes());
            }
        }
        return SVNFileUtil.openFileForReading(file);
    }

    public static long getFileLength(File file) {
        SVNFileType sVNFileType;
        if (SVNFileUtil.symlinksSupported() && (sVNFileType = SVNFileType.getType(file)) == SVNFileType.SYMLINK) {
            try {
                return SVNFileUtil.getSymlinkName(file).getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return SVNFileUtil.getSymlinkName(file).getBytes().length;
            }
        }
        return file.length();
    }

    public static long getFileLastModified(File file) {
        return SVNFileUtil.getFileLastModifiedMicros(file) / 1000L;
    }

    public static void setLastModifiedHasMicrosecondPrecision(boolean bl2) {
        ourLastModifiedHasMicrosecondPrecision = bl2;
    }

    private static Long getLastModifiedMicrosJava7(File file) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4 = java7toPathMethod.invoke((Object)file, new Object[0]);
            if (object4 != null && (object3 = java7readAttributesMethod.invoke(null, object4, java7BasciFileAttributesClazz, java7noFollowLinksParam)) != null && (object2 = java7lastModifiedTimeMethod.invoke(object3, new Object[0])) != null && (object = java7toTimeMethod.invoke(object2, new Object[]{TimeUnit.MICROSECONDS})) instanceof Long) {
                return (Long)object;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public static void setFileLastModifiedMicros(File file, long l2) {
        if (ourLastModifiedHasMicrosecondPrecision.booleanValue() && java7BasciFileAttributesClazz != null && l2 >= 0L && file != null) {
            try {
                Object object;
                Object object2 = java7toPathMethod.invoke((Object)file, new Object[0]);
                if (object2 != null && (object = java7fromTimeMethod.invoke(null, new Object[]{l2, TimeUnit.MICROSECONDS})) != null) {
                    java7setLastModifiedTimeMethod.invoke(null, object2, object);
                    return;
                }
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        SVNFileUtil.setLastModified(file, l2 / 1000L);
    }

    public static long getFileLastModifiedMicros(File file) {
        Long l2;
        Object object;
        if (ourLastModifiedHasMicrosecondPrecision.booleanValue() && java7BasciFileAttributesClazz != null && (object = SVNFileUtil.getLastModifiedMicrosJava7(file)) != null) {
            return (Long)object;
        }
        if (SVNJNAUtil.isJNAPresent() && (object = SVNJNAUtil.getLastModifiedMicros(file)) != null) {
            return (Long)object;
        }
        if (java7BasciFileAttributesClazz != null && (object = SVNFileUtil.getLastModifiedMicrosJava7(file)) != null) {
            return (Long)object;
        }
        if (SVNFileUtil.symlinksSupported() && (object = SVNFileType.getType(file)) == SVNFileType.SYMLINK && (l2 = SVNFileUtil.getLastModifiedSecsStatCommand(file)) != null) {
            return l2 * 1000000L;
        }
        return file.lastModified() * 1000L;
    }

    private static Long getLastModifiedSecsStatCommand(File file) {
        try {
            String string = SVNFileUtil.execCommand(new String[]{STAT_COMMAND, "-c", "%Y", file.getAbsolutePath()});
            if (string != null) {
                try {
                    return Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, throwable);
        }
        return null;
    }

    public static boolean compareFileTimestamps(long l2, long l3) {
        if (ourLastModifiedHasMicrosecondPrecision.booleanValue() && java7BasciFileAttributesClazz != null || SVNJNAUtil.isJNAPresent() && !isWindows) {
            return l2 == l3;
        }
        return l2 / 1000000L == l3 / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block32: {
            Object object;
            Object object2;
            boolean bl2;
            DUMMY_OUT = new SVNFileUtil$1();
            DUMMY_IN = new SVNFileUtil$2();
            ourUseUnsafeCopyOnly = Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("svnkit.no.safe.copy", System.getProperty("javasvn.no.safe.copy", "false")));
            ourCopyOnSetWritable = Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("svnkit.fast.setWritable", "true"));
            ourUseNIOCopying = Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("svnkit.nio.copy", "true"));
            ourIsSleepForTimeStamp = true;
            String string = System.getProperty("svnkit.log.native.calls", "false");
            logNativeCalls = string == null ? false : Boolean.parseBoolean(string);
            Object object3 = System.getProperty("svnkit.fs.win32_retry_count", "100");
            int n2 = -1;
            try {
                n2 = Integer.parseInt((String)object3);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            if (n2 < 0) {
                n2 = 100;
            }
            FILE_CREATION_ATTEMPTS_COUNT = n2;
            Object object4 = System.getProperty("os.name");
            Object object5 = object4 == null ? null : ((String)object4).toLowerCase();
            boolean bl3 = bl2 = object4 != null && ((String)object5).indexOf("windows") >= 0;
            isOS2 = !bl2 && object4 != null ? (bl2 = ((String)object5).indexOf("os/2") >= 0) : false;
            isWindows = bl2;
            isOSX = object4 != null && (((String)object5).indexOf("mac") >= 0 || ((String)object5).indexOf("darwin") >= 0);
            isLinux = object4 != null && (((String)object5).indexOf("linux") >= 0 || ((String)object5).indexOf("hp-ux") >= 0);
            isBSD = !isLinux && object4 != null && ((String)object5).indexOf("bsd") >= 0;
            isSolaris = !isLinux && !isBSD && object4 != null && (((String)object5).indexOf("solaris") >= 0 || ((String)object5).indexOf("sunos") >= 0);
            boolean bl4 = isOpenVMS = !isOSX && object4 != null && ((String)object5).indexOf("openvms") >= 0;
            if (!(isWindows || isOSX || isLinux || isBSD || isSolaris || isOpenVMS || isOS2)) {
                isLinux = true;
            }
            is32Bit = "32".equals(System.getProperty("sun.arch.data.model", "32"));
            is64Bit = "64".equals(System.getProperty("sun.arch.data.model", "64"));
            String[] stringArray = System.getProperty("os.arch", "").toLowerCase();
            isAMD64 = stringArray.equals("amd64") || stringArray.equals("x86_64");
            isAarchh64 = stringArray.equals("aarch64");
            if (isBSD && "freebsd".equals(object5)) {
                object2 = SVNVersion.parse("12.0-CURRENT");
                object = SVNVersion.parse(System.getProperty("os.version"));
                isIno64 = object != null && object2 != null && ((SVNVersion)object2).compareNumericParts((SVNVersion)object) <= 0;
            } else {
                isIno64 = false;
            }
            if (isOpenVMS) {
                SVNFileUtil.setAdminDirectoryName("_svn");
            }
            object2 = "svnkit.program.";
            object = new Properties();
            InputStream inputStream = SVNFileUtil.class.getResourceAsStream("/svnkit.runtime.properties");
            if (inputStream != null) {
                try {
                    ((Properties)object).load(inputStream);
                }
                catch (IOException iOException) {
                }
                finally {
                    SVNFileUtil.closeFile(inputStream);
                }
            }
            ID_COMMAND = ((Properties)object).getProperty((String)object2 + "id", "id");
            LN_COMMAND = ((Properties)object).getProperty((String)object2 + "ln", "ln");
            LS_COMMAND = ((Properties)object).getProperty((String)object2 + "ls", "ls");
            CHMOD_COMMAND = ((Properties)object).getProperty((String)object2 + "chmod", "chmod");
            ATTRIB_COMMAND = ((Properties)object).getProperty((String)object2 + "attrib", "attrib");
            ENV_COMMAND = ((Properties)object).getProperty((String)object2 + "env", "env");
            STAT_COMMAND = ((Properties)object).getProperty((String)object2 + "stat", "stat");
            try {
                ourSetWritableMethod = File.class.getMethod("setWritable", Boolean.TYPE);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                ourSetExecutableMethod = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            ourTestEditor = null;
            ourTestMergeTool = null;
            ourTestFunction = null;
            java7readAttributesMethod = null;
            java7toPathMethod = null;
            java7lastModifiedTimeMethod = null;
            java7setLastModifiedTimeMethod = null;
            java7toTimeMethod = null;
            java7fromTimeMethod = null;
            java7BasciFileAttributesClazz = null;
            java7FileTimeClazz = null;
            java7noFollowLinksParam = null;
            ourLastModifiedHasMicrosecondPrecision = null;
            MICROSECOND_PRECISION_JAVA_VERSION = new int[]{1, 9};
            string = System.getProperty(SVNKIT_FS_MTIME_MICROSECOND_PRECISION);
            if (Boolean.TRUE.toString().equalsIgnoreCase(string)) {
                ourLastModifiedHasMicrosecondPrecision = true;
            } else if (Boolean.FALSE.toString().equalsIgnoreCase(string)) {
                ourLastModifiedHasMicrosecondPrecision = false;
            }
            object3 = SVNFileUtil.class.getClassLoader();
            try {
                Class<?> clazz = ((ClassLoader)object3).loadClass("java.nio.file.Files");
                object4 = ((ClassLoader)object3).loadClass("java.nio.file.Path");
                java7BasciFileAttributesClazz = ((ClassLoader)object3).loadClass("java.nio.file.attribute.BasicFileAttributes");
                object5 = ((ClassLoader)object3).loadClass("java.nio.file.LinkOption");
                java7FileTimeClazz = ((ClassLoader)object3).loadClass("java.nio.file.attribute.FileTime");
                java7noFollowLinksParam = Array.newInstance(object5, 1);
                if (((Class)object5).getEnumConstants() != null && ((Class)object5).getEnumConstants().length >= 1) {
                    Array.set(java7noFollowLinksParam, 0, ((Class)object5).getEnumConstants()[0]);
                } else {
                    java7noFollowLinksParam = Array.newInstance(object5, 0);
                }
                java7readAttributesMethod = clazz.getMethod("readAttributes", new Class[]{object4, Class.class, java7noFollowLinksParam.getClass()});
                java7toPathMethod = File.class.getMethod("toPath", new Class[0]);
                java7lastModifiedTimeMethod = java7BasciFileAttributesClazz.getMethod("lastModifiedTime", new Class[0]);
                java7setLastModifiedTimeMethod = clazz.getMethod("setLastModifiedTime", new Class[]{object4, java7FileTimeClazz});
                java7toTimeMethod = java7FileTimeClazz.getMethod("to", TimeUnit.class);
                java7fromTimeMethod = java7FileTimeClazz.getMethod("from", Long.TYPE, TimeUnit.class);
                if (ourLastModifiedHasMicrosecondPrecision != null) break block32;
                ourLastModifiedHasMicrosecondPrecision = false;
                String string2 = System.getProperty("java.version");
                if (string2 == null || (stringArray = string2.split("\\.")).length < 2) break block32;
                try {
                    int n3 = Integer.parseInt(stringArray[0]);
                    int n4 = Integer.parseInt(stringArray[1]);
                    if (n3 > MICROSECOND_PRECISION_JAVA_VERSION[0] || n3 == MICROSECOND_PRECISION_JAVA_VERSION[0] && n4 >= MICROSECOND_PRECISION_JAVA_VERSION[1]) {
                        ourLastModifiedHasMicrosecondPrecision = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (ClassNotFoundException classNotFoundException) {
                java7BasciFileAttributesClazz = null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                java7BasciFileAttributesClazz = null;
            }
            catch (SecurityException securityException) {
                java7BasciFileAttributesClazz = null;
            }
        }
    }
}

