/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNFileType {
    public static final SVNFileType UNKNOWN = new SVNFileType(0);
    public static final SVNFileType NONE = new SVNFileType(1);
    public static final SVNFileType FILE = new SVNFileType(2);
    public static final SVNFileType SYMLINK = new SVNFileType(3);
    public static final SVNFileType DIRECTORY = new SVNFileType(4);
    private static final boolean ourFastSymlinkResoution = !"false".equalsIgnoreCase(System.getProperty("svnkit.fastSymlinkResolution", System.getProperty("javasvn.fastSymlinkResolution")));
    private static final boolean ourCanonPathCacheUsed = !"false".equalsIgnoreCase(System.getProperty("sun.io.useCanonCaches"));
    private static boolean ourDetectSymlinks = !"false".equalsIgnoreCase(System.getProperty("svnkit.symlinks", System.getProperty("javasvn.symlinks", "true")));
    private static final Set ADMIN_FILE_PARENTS = new SVNHashSet();
    private int myType;

    private SVNFileType(int n2) {
        this.myType = n2;
    }

    public String toString() {
        switch (this.myType) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "none";
            }
            case 2: {
                return "file";
            }
            case 3: {
                return "symlink";
            }
            case 4: {
                return "directory";
            }
        }
        return Integer.toString(this.myType);
    }

    public static synchronized void setSymlinkSupportEnabled(boolean bl2) {
        ourDetectSymlinks = bl2;
    }

    public static synchronized boolean isSymlinkSupportEnabled() {
        return ourDetectSymlinks;
    }

    public static SVNFileType getType(File file) {
        Object object;
        boolean bl2 = SVNFileType.isSymlinkSupportEnabled();
        if (file == null) {
            return UNKNOWN;
        }
        if ((SVNFileUtil.isLinux || SVNFileUtil.isBSD || SVNFileUtil.isOSX || SVNFileUtil.isSolaris) && bl2 && (object = SVNJNAUtil.getFileType(file)) != null) {
            return object;
        }
        if (bl2 && SVNFileUtil.symlinksSupported() && !SVNFileType.isAdminFile(file)) {
            if (ourCanonPathCacheUsed && !ourFastSymlinkResoution && SVNFileType.isSymlink(file)) {
                return SYMLINK;
            }
            if (!ourCanonPathCacheUsed || ourFastSymlinkResoution) {
                if (!file.exists()) {
                    object = file.getParentFile() != null ? SVNFileListUtil.listFiles(file.getParentFile()) : null;
                    for (int i2 = 0; object != null && i2 < ((Object)object).length; ++i2) {
                        Object object2 = object[i2];
                        if (!((File)object2).getName().equals(file.getName()) || !SVNFileType.isSymlink(file)) continue;
                        return SYMLINK;
                    }
                } else {
                    String string;
                    object = file.getAbsolutePath();
                    try {
                        string = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string = file.getAbsolutePath();
                    }
                    if (!((String)object).equals(string) && SVNFileType.isSymlink(file)) {
                        return SYMLINK;
                    }
                }
            }
        }
        if (file.isFile()) {
            return FILE;
        }
        if (file.isDirectory()) {
            return DIRECTORY;
        }
        if (!file.exists()) {
            return NONE;
        }
        return UNKNOWN;
    }

    public static boolean equals(SVNFileType sVNFileType, SVNNodeKind sVNNodeKind) {
        if (sVNNodeKind == SVNNodeKind.DIR) {
            return sVNFileType == DIRECTORY;
        }
        if (sVNNodeKind == SVNNodeKind.FILE) {
            return sVNFileType == FILE || sVNFileType == SYMLINK;
        }
        if (sVNNodeKind == SVNNodeKind.NONE) {
            return sVNFileType == NONE;
        }
        if (sVNNodeKind == SVNNodeKind.UNKNOWN) {
            return sVNFileType == UNKNOWN;
        }
        return false;
    }

    private static boolean isAdminFile(File file) {
        String string;
        String string2 = file.getAbsolutePath().replace(File.separatorChar, '/');
        return string2.lastIndexOf((string = "/" + SVNFileUtil.getAdminDirectoryName()) + "/") > 0 || string2.endsWith(string);
    }

    private static boolean isSymlink(File file) {
        String string = null;
        try {
            string = SVNFileUtil.execCommand(new String[]{SVNFileUtil.LS_COMMAND, "-ld", file.getAbsolutePath()});
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, throwable);
        }
        return string != null && string.startsWith("l");
    }

    public int getID() {
        return this.myType;
    }

    public boolean isFile() {
        return this == FILE || this == SYMLINK;
    }

    public static SVNNodeKind getNodeKind(SVNFileType sVNFileType) {
        if (sVNFileType == null || sVNFileType == NONE || sVNFileType == UNKNOWN) {
            return SVNNodeKind.NONE;
        }
        if (sVNFileType == DIRECTORY) {
            return SVNNodeKind.DIR;
        }
        return SVNNodeKind.FILE;
    }

    static {
        ADMIN_FILE_PARENTS.add("text-base");
        ADMIN_FILE_PARENTS.add("prop-base");
        ADMIN_FILE_PARENTS.add("props");
        ADMIN_FILE_PARENTS.add("wcprops");
        ADMIN_FILE_PARENTS.add("tmp");
    }
}

