/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNFileListUtil {
    private static boolean ourIsCompositionEnabled = Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("svnkit.fs.composeFileNames", "true"));

    public static synchronized void setCompositionEnabled(boolean bl2) {
        ourIsCompositionEnabled = bl2;
    }

    public static synchronized boolean isCompositionEnabled() {
        return ourIsCompositionEnabled;
    }

    private static String[] list(File file) {
        if (!SVNFileUtil.isOSX) {
            return file.list();
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            stringArray2[i2] = !SVNFileListUtil.isCompositionEnabled() ? SVNFileListUtil.decompose(stringArray[i2]) : SVNFileListUtil.compose(stringArray[i2]);
        }
        return stringArray2;
    }

    public static File[] listFiles(File file) {
        if (SVNFileUtil.isOSX) {
            String[] stringArray = SVNFileListUtil.list(file);
            if (stringArray == null) {
                return null;
            }
            File[] fileArray = new File[stringArray.length];
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                fileArray[i2] = new File(file.getPath(), stringArray[i2]);
            }
            return fileArray;
        }
        if (SVNFileUtil.isOpenVMS) {
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                return fileArray;
            }
            File[] fileArray2 = new File[fileArray.length];
            for (int i3 = 0; i3 < fileArray.length; ++i3) {
                File file2 = fileArray[i3];
                String string = file2.getName();
                fileArray2[i3] = file2.isFile() && string.endsWith(".") && (file2 = new File(file, string = string.substring(0, string.lastIndexOf(46)))).exists() && file2.isFile() ? file2 : file2;
            }
            return fileArray2;
        }
        File[] fileArray = file.listFiles();
        return fileArray != null ? SVNFileListUtil.sort(fileArray) : null;
    }

    private static File[] sort(File[] fileArray) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            sVNHashMap.put(fileArray[i2].getName(), fileArray[i2]);
        }
        return sVNHashMap.values().toArray(new File[sVNHashMap.size()]);
    }

    private static String compose(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        int n2 = string.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\u0300') {
                stringBuffer = SVNFileListUtil.compose(i2, "AaEeIiOoUu", "\u00c0\u00e0\u00c8\u00e8\u00cc\u00ec\u00d2\u00f2\u00d9\u00f9", string, stringBuffer);
                continue;
            }
            if (c2 == '\u0301') {
                stringBuffer = SVNFileListUtil.compose(i2, "AaEeIiOoUuYy", "\u00c1\u00e1\u00c9\u00e9\u00cd\u00ed\u00d3\u00f3\u00da\u00fa\u00dd\u00fd", string, stringBuffer);
                continue;
            }
            if (c2 == '\u0302') {
                stringBuffer = SVNFileListUtil.compose(i2, "AaEeIiOoUuYy", "\u00c2\u00e2\u00ca\u00ea\u00ce\u00ee\u00d4\u00f4\u00db\u00fb\u0176\u0177", string, stringBuffer);
                continue;
            }
            if (c2 == '\u0303') {
                stringBuffer = SVNFileListUtil.compose(i2, "AaNnOoUu", "\u00c3\u00e3\u00d1\u00f1\u00d5\u00f5\u0168\u0169", string, stringBuffer);
                continue;
            }
            if (c2 == '\u0308') {
                stringBuffer = SVNFileListUtil.compose(i2, "AaEeIiOoUuYy", "\u00c4\u00e4\u00cb\u00eb\u00cf\u00ef\u00d6\u00f6\u00dc\u00fc\u0178\u00ff", string, stringBuffer);
                continue;
            }
            if (c2 == '\u030a') {
                stringBuffer = SVNFileListUtil.compose(i2, "Aa", "\u00c5\u00e5", string, stringBuffer);
                continue;
            }
            if (c2 == '\u0327') {
                stringBuffer = SVNFileListUtil.compose(i2, "Cc", "\u00c7\u00e7", string, stringBuffer);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c2);
        }
        if (stringBuffer == null) {
            return string;
        }
        return stringBuffer.toString();
    }

    private static String decompose(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        int n2 = string.length();
        block60: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\u00c0': {
                    stringBuffer = SVNFileListUtil.decompose("A\u0300", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00c1': {
                    stringBuffer = SVNFileListUtil.decompose("A\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00c2': {
                    stringBuffer = SVNFileListUtil.decompose("A\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00c3': {
                    stringBuffer = SVNFileListUtil.decompose("A\u0303", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00c4': {
                    stringBuffer = SVNFileListUtil.decompose("A\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00c5': {
                    stringBuffer = SVNFileListUtil.decompose("A\u030a", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00c7': {
                    stringBuffer = SVNFileListUtil.decompose("C\u0327", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00c8': {
                    stringBuffer = SVNFileListUtil.decompose("E\u0300", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00c9': {
                    stringBuffer = SVNFileListUtil.decompose("E\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00ca': {
                    stringBuffer = SVNFileListUtil.decompose("E\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00cb': {
                    stringBuffer = SVNFileListUtil.decompose("E\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00cc': {
                    stringBuffer = SVNFileListUtil.decompose("I\u0300", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00cd': {
                    stringBuffer = SVNFileListUtil.decompose("I\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00ce': {
                    stringBuffer = SVNFileListUtil.decompose("I\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00cf': {
                    stringBuffer = SVNFileListUtil.decompose("I\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00d1': {
                    stringBuffer = SVNFileListUtil.decompose("N\u0303", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00d2': {
                    stringBuffer = SVNFileListUtil.decompose("O\u0300", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00d3': {
                    stringBuffer = SVNFileListUtil.decompose("O\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00d4': {
                    stringBuffer = SVNFileListUtil.decompose("O\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00d5': {
                    stringBuffer = SVNFileListUtil.decompose("O\u0303", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00d6': {
                    stringBuffer = SVNFileListUtil.decompose("O\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00d9': {
                    stringBuffer = SVNFileListUtil.decompose("U\u0300", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00da': {
                    stringBuffer = SVNFileListUtil.decompose("U\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00db': {
                    stringBuffer = SVNFileListUtil.decompose("U\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00dc': {
                    stringBuffer = SVNFileListUtil.decompose("U\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00dd': {
                    stringBuffer = SVNFileListUtil.decompose("Y\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00e0': {
                    stringBuffer = SVNFileListUtil.decompose("a\u0300", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00e1': {
                    stringBuffer = SVNFileListUtil.decompose("a\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00e2': {
                    stringBuffer = SVNFileListUtil.decompose("a\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00e3': {
                    stringBuffer = SVNFileListUtil.decompose("a\u0303", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00e4': {
                    stringBuffer = SVNFileListUtil.decompose("a\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00e5': {
                    stringBuffer = SVNFileListUtil.decompose("a\u030a", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00e7': {
                    stringBuffer = SVNFileListUtil.decompose("c\u0327", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00e8': {
                    stringBuffer = SVNFileListUtil.decompose("e\u0300", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00e9': {
                    stringBuffer = SVNFileListUtil.decompose("e\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00ea': {
                    stringBuffer = SVNFileListUtil.decompose("e\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00eb': {
                    stringBuffer = SVNFileListUtil.decompose("e\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00ec': {
                    stringBuffer = SVNFileListUtil.decompose("i\u0300", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00ed': {
                    stringBuffer = SVNFileListUtil.decompose("i\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00ee': {
                    stringBuffer = SVNFileListUtil.decompose("i\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00ef': {
                    stringBuffer = SVNFileListUtil.decompose("i\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00ff': {
                    stringBuffer = SVNFileListUtil.decompose("y\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00f1': {
                    stringBuffer = SVNFileListUtil.decompose("n\u0303", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00f2': {
                    stringBuffer = SVNFileListUtil.decompose("o\u0300", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00f3': {
                    stringBuffer = SVNFileListUtil.decompose("o\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00f4': {
                    stringBuffer = SVNFileListUtil.decompose("o\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00f5': {
                    stringBuffer = SVNFileListUtil.decompose("o\u0303", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00f6': {
                    stringBuffer = SVNFileListUtil.decompose("o\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00f9': {
                    stringBuffer = SVNFileListUtil.decompose("u\u0300", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00fa': {
                    stringBuffer = SVNFileListUtil.decompose("u\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00fb': {
                    stringBuffer = SVNFileListUtil.decompose("u\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00fc': {
                    stringBuffer = SVNFileListUtil.decompose("u\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u00fd': {
                    stringBuffer = SVNFileListUtil.decompose("y\u0301", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u0168': {
                    stringBuffer = SVNFileListUtil.decompose("U\u0303", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u0169': {
                    stringBuffer = SVNFileListUtil.decompose("u\u0303", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u0176': {
                    stringBuffer = SVNFileListUtil.decompose("Y\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u0177': {
                    stringBuffer = SVNFileListUtil.decompose("y\u0302", i2, string, stringBuffer);
                    continue block60;
                }
                case '\u0178': {
                    stringBuffer = SVNFileListUtil.decompose("Y\u0308", i2, string, stringBuffer);
                    continue block60;
                }
                default: {
                    if (stringBuffer == null) continue block60;
                    stringBuffer.append(c2);
                }
            }
        }
        if (stringBuffer == null) {
            return string;
        }
        return stringBuffer.toString();
    }

    private static StringBuffer decompose(String string, int n2, String string2, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(string2.length());
            stringBuffer.append(string2, 0, n2);
        }
        stringBuffer.append(string);
        return stringBuffer;
    }

    private static StringBuffer compose(int n2, String string, String string2, String string3, StringBuffer stringBuffer) {
        char c2 = string3.charAt(n2 - 1);
        int n3 = string.indexOf(c2);
        if (n3 >= 0) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string3.length() + 2);
                stringBuffer.append(string3.substring(0, n2 - 1));
            } else {
                stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
            }
            stringBuffer.append(string2.charAt(n3));
        } else if (stringBuffer == null) {
            stringBuffer = new StringBuffer(string3.length() + 2);
            stringBuffer.append(string3.substring(0, n2));
        }
        return stringBuffer;
    }
}

