/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNExternalsUtil$1;
import org.tmatesoft.svn.core.internal.wc.SVNExternalsUtil$2;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$SVNWCNodeReposInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$ExternalNodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbReader;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.remote.SvnRemoteGetProperties;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNExternalsUtil {
    public static Map resolvePinnedExternals(SVNWCContext sVNWCContext, SvnRepositoryAccess svnRepositoryAccess, Map map, SvnTarget svnTarget, SvnTarget svnTarget2, long l2, SVNRepository sVNRepository, SVNURL sVNURL) {
        String string;
        Serializable serializable;
        HashMap<String, File> hashMap = new HashMap<String, File>();
        HashMap<SvnTarget, SVNPropertyValue> hashMap2 = new HashMap<SvnTarget, SVNPropertyValue>();
        SVNURL sVNURL2 = null;
        if (svnTarget.isURL()) {
            sVNURL2 = sVNRepository.getLocation();
            sVNRepository.setLocation(svnTarget.getURL(), false);
            SvnRemoteGetProperties.remotePropertyGet(svnTarget.getURL(), SVNNodeKind.DIR, "", sVNRepository, l2, SVNDepth.INFINITY, new SVNExternalsUtil$1(hashMap2));
        } else {
            SVNExternalsStore sVNExternalsStore = new SVNExternalsStore();
            sVNWCContext.getDb().gatherExternalDefinitions(svnTarget.getFile(), sVNExternalsStore);
            Map object = sVNExternalsStore.getNewExternals();
            for (Map.Entry entry : object.entrySet()) {
                serializable = (File)entry.getKey();
                string = (String)entry.getValue();
                hashMap2.put(SvnTarget.fromFile(serializable), SVNPropertyValue.create(string));
            }
        }
        if (hashMap2.size() == 0) {
            if (sVNURL2 != null) {
                sVNRepository.setLocation(sVNURL2, false);
            }
            return Collections.emptyMap();
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            SvnTarget svnTarget3 = (SvnTarget)entry.getKey();
            SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)entry.getValue();
            serializable = SVNExternalsUtil.pinExternalProps(sVNWCContext, svnRepositoryAccess, sVNPropertyValue, map, sVNURL, svnTarget3);
            if (serializable == null) continue;
            string = SVNPathUtil.getRelativePath(svnTarget.getPathOrUrlDecodedString(), svnTarget3.getPathOrUrlDecodedString());
            hashMap.put(string, (File)serializable);
        }
        if (sVNURL2 != null) {
            sVNRepository.setLocation(sVNURL2, false);
        }
        return hashMap;
    }

    private static SVNPropertyValue pinExternalProps(SVNWCContext sVNWCContext, SvnRepositoryAccess svnRepositoryAccess, SVNPropertyValue sVNPropertyValue, Map map, SVNURL sVNURL, SvnTarget svnTarget) {
        List list;
        StringBuilder stringBuilder = new StringBuilder();
        SVNExternal[] sVNExternalArray = SVNExternal.parseExternals(svnTarget, SVNPropertyValue.getPropertyAsString(sVNPropertyValue));
        if (map != null) {
            list = (List)map.get(svnTarget);
            if (list == null) {
                return null;
            }
        } else {
            list = null;
        }
        int n2 = 0;
        for (SVNExternal sVNExternal : sVNExternalArray) {
            Object object;
            SVNRevision sVNRevision;
            Object object2;
            if (list != null) {
                object2 = null;
                for (Object object3 : list) {
                    if (object3 == null || !((SVNExternal)object3).getUnresolvedUrl().equals(sVNExternal.getUnresolvedUrl()) || !((SVNExternal)object3).getPath().equals(sVNExternal.getPath())) continue;
                    object2 = object3;
                    break;
                }
                if (object2 == null) {
                    sVNRevision = SVNRevision.UNDEFINED;
                    object = SVNExternalsUtil.makeExternalDescription(svnTarget, sVNExternal, sVNRevision);
                    stringBuilder.append((String)object);
                    continue;
                }
            }
            if (sVNExternal.getPegRevision().getDate() != null) {
                sVNRevision = sVNExternal.getPegRevision();
            } else if (SVNRevision.isValidRevisionNumber(sVNExternal.getPegRevision().getNumber())) {
                sVNRevision = sVNExternal.getPegRevision();
            } else {
                assert (sVNExternal.getPegRevision() == SVNRevision.HEAD || sVNExternal.getPegRevision() == SVNRevision.UNDEFINED);
                ++n2;
                if (svnTarget.isURL()) {
                    object2 = sVNExternal.resolveURL(sVNURL, svnTarget.getURL());
                    object = svnRepositoryAccess.createRepository((SVNURL)object2, null, true);
                    sVNRevision = SVNRevision.create(((SVNRepository)object).getLatestRevision());
                } else {
                    Object object4;
                    object2 = SVNFileUtil.createFilePath(svnTarget.getFile(), sVNExternal.getPath());
                    try {
                        Object object3;
                        object3 = SvnWcDbExternals.readExternal(sVNWCContext, (File)object2, svnTarget.getFile(), StructureFields$ExternalNodeInfo.kind, StructureFields$ExternalNodeInfo.presence);
                        assert (object3 != null);
                        assert (((Structure)object3).hasField(StructureFields$ExternalNodeInfo.presence));
                        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)((Structure)object3).get(StructureFields$ExternalNodeInfo.presence));
                        if (iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Normal) {
                            object = ISVNWCDb$SVNWCDbKind.Unknown;
                        } else {
                            object4 = (ISVNWCDb$SVNWCDbKind)((Object)((Structure)object3).get(StructureFields$ExternalNodeInfo.kind));
                            switch (SVNExternalsUtil$2.$SwitchMap$org$tmatesoft$svn$core$internal$wc17$db$ISVNWCDb$SVNWCDbKind[((Enum)object4).ordinal()]) {
                                case 1: 
                                case 2: {
                                    object = ISVNWCDb$SVNWCDbKind.File;
                                    break;
                                }
                                case 3: {
                                    object = ISVNWCDb$SVNWCDbKind.Dir;
                                    break;
                                }
                                default: {
                                    object = null;
                                }
                            }
                        }
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                            throw sVNException;
                        }
                        object = null;
                    }
                    long l2 = 0L;
                    if (object == null) {
                        object4 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot pin external ''{0}'' defined in {1} at ''{2}'' because it is not checked out in the working copy at ''{3}''", sVNExternal.getUnresolvedUrl(), "svn:externals", svnTarget.getFile(), ((File)object2).getAbsolutePath(), "svn:externals");
                        SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.CLIENT);
                    } else if (object == ISVNWCDb$SVNWCDbKind.Dir) {
                        Object object5;
                        boolean bl2;
                        boolean bl3 = SvnWcDbReader.hasSwitchedSubtrees((SVNWCDb)sVNWCContext.getDb(), (File)object2);
                        if (bl3) {
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot pin external ''{0}'' defined in {1} at ''{2}'' because ''{3}'' has switched subtrees (switches cannot be represented in {4})", sVNExternal.getUnresolvedUrl(), "svn:externals", svnTarget.getFile(), ((File)object2).getAbsolutePath(), "svn:externals");
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
                        }
                        if (bl2 = SvnWcDbReader.hasLocalModifications(sVNWCContext, (File)object2)) {
                            object5 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot pin external ''{0}'' defined in {1} at ''{2}'' because ''{3}'' has local modifications (local modifications cannot be represented in {4})", sVNExternal.getUnresolvedUrl(), "svn:externals", svnTarget.getFile(), ((File)object2).getAbsolutePath(), "svn:externals");
                            SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.CLIENT);
                        }
                        if ((object5 = SvnWcDbReader.getMinAndMaxRevisions((SVNWCDb)sVNWCContext.getDb(), (File)object2))[0] != object5[1]) {
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot pin external ''{0}'' defined in {1} at ''{2}'' because ''{3}'' is a mixed-revision working copy (mixed-revisions cannot be represented in {4})", sVNExternal.getUnresolvedUrl(), "svn:externals", svnTarget.getFile(), ((File)object2).getAbsolutePath(), "svn:externals");
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
                        }
                        l2 = object5[0];
                    } else {
                        assert (object == ISVNWCDb$SVNWCDbKind.File);
                        object4 = sVNWCContext.getNodeReposInfo((File)object2);
                        l2 = ((SVNWCContext$SVNWCNodeReposInfo)object4).revision;
                    }
                    sVNRevision = SVNRevision.create(l2);
                }
            }
            assert (sVNRevision.getDate() != null || SVNRevision.isValidRevisionNumber(sVNRevision.getNumber()));
            object2 = SVNExternalsUtil.makeExternalDescription(svnTarget, sVNExternal, sVNRevision);
            stringBuilder.append((String)object2);
        }
        if (n2 > 0) {
            return SVNPropertyValue.create(stringBuilder.toString());
        }
        return null;
    }

    private static String makeExternalDescription(SvnTarget svnTarget, SVNExternal sVNExternal, SVNRevision sVNRevision) {
        String string = sVNExternal.getRevisionString();
        String string2 = sVNExternal.getPegRevisionString();
        switch (sVNExternal.getFormat()) {
            case 1: {
                String string3;
                if (sVNRevision == SVNRevision.UNDEFINED) {
                    string3 = string + " ";
                } else if (string != null && sVNExternal.getRevision() != SVNRevision.HEAD) {
                    string3 = string + " ";
                } else {
                    assert (SVNRevision.isValidRevisionNumber(sVNRevision.getNumber()));
                    string3 = "-r" + sVNRevision.getNumber() + " ";
                }
                return SVNExternalsUtil.maybeQuote(sVNExternal.getPath()) + " " + string3 + SVNExternalsUtil.maybeQuote(sVNExternal.getRawURL()) + "\n";
            }
            case 2: {
                String string4;
                String string5 = sVNRevision == SVNRevision.UNDEFINED ? string + " " : (string != null && sVNExternal.getRevision() != SVNRevision.HEAD ? string + " " : "");
                if (sVNRevision == SVNRevision.UNDEFINED) {
                    string4 = string2 != null ? string2 : "";
                } else if (string2 != null && sVNExternal.getRevision() != SVNRevision.HEAD) {
                    string4 = string2;
                } else {
                    assert (SVNRevision.isValidRevisionNumber(sVNRevision.getNumber()));
                    string4 = "@" + sVNRevision.getNumber();
                }
                return string5 + SVNExternalsUtil.maybeQuote(sVNExternal.getRawURL() + string4) + " " + SVNExternalsUtil.maybeQuote(sVNExternal.getPath()) + "\n";
            }
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "{0} property defined at ''{1}'' is using an unsupported syntax", "svn:externals", svnTarget.getFile());
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
        return null;
    }

    private static String maybeQuote(String string) {
        String[] stringArray = string.split("\\s");
        if (stringArray.length == 1 && stringArray[0].equals(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\' || c2 == '\"' || c2 == '\'') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c2);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

