/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternal$ExternalTokenizer;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNExternal {
    private SVNRevision myRevision;
    private SVNRevision myPegRevision;
    private String myURL;
    private String myRawURL;
    private String myPath;
    private SVNURL myResolvedURL;
    private boolean myIsRevisionExplicit;
    private boolean myIsPegRevisionExplicit;
    private boolean myIsNewFormat;
    private String myRawValue;

    private SVNExternal() {
        this.myRevision = SVNRevision.UNDEFINED;
        this.myPegRevision = SVNRevision.UNDEFINED;
    }

    public SVNExternal(String string, String string2, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, boolean bl3, boolean bl4) {
        this.myPath = string;
        this.myURL = string2;
        this.myRawURL = string2;
        this.myRevision = sVNRevision2;
        this.myPegRevision = sVNRevision;
        this.myIsRevisionExplicit = bl2;
        this.myIsPegRevisionExplicit = bl3;
        this.myIsNewFormat = bl4;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public SVNRevision getPegRevision() {
        return this.myPegRevision;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getUnresolvedUrl() {
        return this.myURL;
    }

    public String getRawValue() {
        return this.myRawValue;
    }

    @Deprecated
    protected String getRawURL() {
        return this.myRawURL;
    }

    public boolean isRevisionExplicit() {
        return this.myIsRevisionExplicit;
    }

    public boolean isPegRevisionExplicit() {
        return this.myIsPegRevisionExplicit;
    }

    public boolean isNewFormat() {
        return this.myIsNewFormat;
    }

    public int getFormat() {
        return this.isNewFormat() ? 2 : 1;
    }

    public SVNURL getResolvedURL() {
        return this.myResolvedURL;
    }

    public SVNURL resolveURL(SVNURL sVNURL, SVNURL sVNURL2) {
        SVNErrorMessage sVNErrorMessage;
        String string = this.myURL != null && this.myURL.startsWith("^/") ? "^/" + SVNPathUtil.canonicalizePath(this.myURL.substring("^/".length())) : SVNPathUtil.canonicalizePath(this.myURL);
        if (SVNPathUtil.isURL(string)) {
            this.myResolvedURL = SVNURL.parseURIEncoded(string);
            return this.getResolvedURL();
        }
        if (this.myURL.startsWith("../") || this.myURL.startsWith("^/")) {
            String[] stringArray = this.myURL.startsWith("../") ? sVNURL2.getPath().split("/") : sVNURL.getPath().split("/");
            LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
            if (string.startsWith("^/")) {
                string = string.substring("^/".length());
            }
            String[] stringArray2 = string.split("/");
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                if ("..".equals(stringArray2[i2])) {
                    if (linkedList.isEmpty()) continue;
                    linkedList.removeLast();
                    continue;
                }
                linkedList.add(stringArray2[i2]);
            }
            String string2 = "/";
            for (String string3 : linkedList) {
                string2 = SVNPathUtil.append(string2, string3);
            }
            this.myResolvedURL = sVNURL2.setPath(string2, true);
            return this.getResolvedURL();
        }
        if (this.myURL.indexOf("/../") >= 0 || this.myURL.startsWith("../") || this.myURL.endsWith("/..")) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "The external relative URL ''{0}'' cannot have backpaths, i.e. ''..''.", (Object)this.myURL);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (this.myURL.startsWith("//")) {
            this.myResolvedURL = SVNURL.parseURIEncoded(SVNPathUtil.canonicalizePath(sVNURL.getProtocol() + ":" + this.myURL));
            return this.getResolvedURL();
        }
        if (this.myURL.startsWith("/")) {
            this.myResolvedURL = sVNURL2.setPath(this.myURL, true);
            return this.getResolvedURL();
        }
        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Unrecognized format for the relative external URL ''{0}''.", (Object)this.myURL);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        return null;
    }

    public String toString() {
        String string = "";
        String string2 = SVNExternal.quotePath(this.myPath);
        String string3 = SVNExternal.quotePath(this.myURL);
        if (this.myIsPegRevisionExplicit && SVNRevision.isValidRevisionNumber(this.myPegRevision.getNumber())) {
            if (this.myIsRevisionExplicit && SVNRevision.isValidRevisionNumber(this.myRevision.getNumber())) {
                string = string + "-r" + this.myRevision + " ";
            }
            string = string + string3 + "@" + this.myPegRevision + " " + string2;
        } else if (this.myIsNewFormat) {
            if (this.myIsRevisionExplicit && SVNRevision.isValidRevisionNumber(this.myRevision.getNumber())) {
                string = string + "-r" + this.myRevision + " ";
            }
            string = string + string3 + " " + string2;
        } else {
            string = string + string2;
            if (this.myIsRevisionExplicit && SVNRevision.isValidRevisionNumber(this.myRevision.getNumber())) {
                string = string + " -r" + this.myRevision;
            }
            string = string + " " + string3;
        }
        return string;
    }

    public static SVNExternal[] parseExternals(Object object, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object2 = new StringTokenizer(string, "\r\n");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            arrayList.add(((StringTokenizer)object2).nextToken());
        }
        object2 = new ArrayList();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            SVNErrorMessage sVNErrorMessage;
            String string2 = ((String)arrayList.get(i2)).trim();
            if ("".equals(string2) || string2.startsWith("#")) continue;
            ArrayList arrayList2 = new ArrayList();
            Object object3 = new SVNExternal$ExternalTokenizer(string2);
            while (object3.hasNext()) {
                arrayList2.add(object3.next());
            }
            if (arrayList2.size() < 2 || arrayList2.size() > 4) {
                SVNExternal.reportParsingError(object, string2);
            }
            object3 = new SVNExternal();
            int n2 = SVNExternal.fetchRevision((SVNExternal)object3, object, string2, arrayList2);
            String string3 = (String)arrayList2.get(0);
            String string4 = (String)arrayList2.get(1);
            boolean bl2 = SVNPathUtil.isURL(string3);
            boolean bl3 = SVNPathUtil.isURL(string4);
            if (bl2 && bl3) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Invalid svn:external property on ''{0}'': cannot use two absolute URLs (''{1}'' and ''{2}'') in an external; one must be a path where an absolute or relative URL is checked out to", object, string3, string4);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            if (n2 == 0 && bl3) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Invalid svn:external property on ''{0}'': cannot use a URL ''{1}'' as the target directory for an external definition", object, string4);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            if (n2 == 1 && bl2) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Invalid svn:external property on ''{0}'': cannot use a URL ''{1}'' as the target directory for an external definition", object, string3);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            if (n2 == 0 || n2 == -1 && (bl2 || !bl3)) {
                ((SVNExternal)object3).myPath = string4;
                boolean bl4 = string3.startsWith("//");
                if (bl4) {
                    string3 = string3.substring(2);
                }
                SVNPath sVNPath = new SVNPath(string3, true);
                ((SVNExternal)object3).myURL = bl4 ? "//" + sVNPath.getTarget() : sVNPath.getTarget();
                ((SVNExternal)object3).myRawURL = (bl4 ? "//" : "") + (string3.contains("@") ? string3.substring(0, string3.lastIndexOf(64)) : string3);
                ((SVNExternal)object3).myPegRevision = sVNPath.getPegRevision();
                if (((SVNExternal)object3).myPegRevision == SVNRevision.BASE) {
                    ((SVNExternal)object3).myPegRevision = SVNRevision.HEAD;
                }
                if (((SVNExternal)object3).myPegRevision != SVNRevision.UNDEFINED) {
                    ((SVNExternal)object3).myIsPegRevisionExplicit = true;
                }
                ((SVNExternal)object3).myIsNewFormat = true;
            } else {
                ((SVNExternal)object3).myPath = string3;
                ((SVNExternal)object3).myURL = string4;
                ((SVNExternal)object3).myRawURL = string4;
                ((SVNExternal)object3).myPegRevision = ((SVNExternal)object3).myRevision;
            }
            if (((SVNExternal)object3).myPegRevision == SVNRevision.UNDEFINED) {
                ((SVNExternal)object3).myPegRevision = SVNRevision.HEAD;
            }
            if (((SVNExternal)object3).myRevision == SVNRevision.UNDEFINED) {
                ((SVNExternal)object3).myRevision = ((SVNExternal)object3).myPegRevision;
            }
            ((SVNExternal)object3).myPath = SVNPathUtil.canonicalizePath(((SVNExternal)object3).myPath.replace(File.separatorChar, '/'));
            if (((SVNExternal)object3).myPath.length() == 0 || ((SVNExternal)object3).myPath.equals(".") || ((SVNExternal)object3).myPath.equals("..") || ((SVNExternal)object3).myPath.startsWith("../") || ((SVNExternal)object3).myPath.startsWith("/") || ((SVNExternal)object3).myPath.indexOf("/../") > 0 || ((SVNExternal)object3).myPath.endsWith("/..")) {
                SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Invalid {0} property on ''{1}'': target ''{2}'' is an absolute path or involves ''..''", "svn:externals", object, ((SVNExternal)object3).myPath);
                SVNErrorManager.error(sVNErrorMessage2, SVNLogType.DEFAULT);
            }
            ((SVNExternal)object3).myRawValue = string2;
            if (((SVNExternal)object3).myURL != null && SVNPathUtil.isURL(((SVNExternal)object3).myURL)) {
                SVNURL.parseURIEncoded(((SVNExternal)object3).myURL);
            }
            object2.add(object3);
        }
        return object2.toArray(new SVNExternal[object2.size()]);
    }

    private static String quotePath(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (!Character.isWhitespace(string.charAt(i2))) continue;
            return "\"" + string + "\"";
        }
        return string;
    }

    private static int fetchRevision(SVNExternal sVNExternal, Object object, String string, List list) {
        for (int i2 = 0; i2 < list.size() && i2 < 2; ++i2) {
            String string2 = (String)list.get(i2);
            String string3 = null;
            if (string2.length() < 2 || string2.charAt(0) != '-' || string2.charAt(1) != 'r') continue;
            if (string2.length() == 2 && list.size() == 4) {
                string3 = (String)list.get(i2 + 1);
                list.remove(i2);
            } else if (list.size() == 3) {
                string3 = string2.substring(2);
            }
            if (string3 == null || "".equals(string3)) {
                SVNExternal.reportParsingError(object, string);
            }
            long l2 = -1L;
            try {
                l2 = Long.parseLong(string3);
                if (l2 < 0L) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Negative revision number found parsing '" + string3 + "'");
                    SVNExternal.reportParsingError(object, string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Invalid revision number found parsing '" + string3 + "'");
                SVNExternal.reportParsingError(object, string);
            }
            sVNExternal.myRevision = SVNRevision.create(l2);
            sVNExternal.myIsRevisionExplicit = true;
            list.remove(i2);
            return i2;
        }
        if (list.size() == 2) {
            return -1;
        }
        SVNExternal.reportParsingError(object, string);
        return -1;
    }

    private static void reportParsingError(Object object, String string) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Error parsing {0} property on ''{1}'': ''{2}''", "svn:externals", object, string);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
    }

    public static List findTargetDuplications(SVNExternal[] sVNExternalArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < sVNExternalArray.length; ++i2) {
            SVNExternal sVNExternal = sVNExternalArray[i2];
            String string = sVNExternal.getPath();
            for (int i3 = i2 + 1; i3 < sVNExternalArray.length; ++i3) {
                SVNExternal sVNExternal2 = sVNExternalArray[i3];
                String string2 = sVNExternal2.getPath();
                if (!string.equals(string2)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public String getRevisionString() {
        return this.isRevisionExplicit() ? this.formatRevisionString("-r", this.getRevision()) : null;
    }

    public String getPegRevisionString() {
        return this.isPegRevisionExplicit() ? this.formatRevisionString("@", this.getPegRevision()) : null;
    }

    private String formatRevisionString(String string, SVNRevision sVNRevision) {
        if (sVNRevision == null) {
            return null;
        }
        if (sVNRevision == SVNRevision.HEAD) {
            return string + "HEAD";
        }
        if (sVNRevision.getDate() != null) {
            return string + "{" + SVNDate.formatDate(sVNRevision.getDate(), true) + "}";
        }
        if (SVNRevision.isValidRevisionNumber(sVNRevision.getNumber())) {
            return string + sVNRevision.getNumber();
        }
        return null;
    }
}

