/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNExportEditor
implements ISVNEditor {
    private File myRoot;
    private boolean myIsForce;
    private String myEOLStyle;
    private File myCurrentDirectory;
    private File myCurrentFile;
    private File myCurrentTmpFile;
    private String myCurrentPath;
    private Map myExternals;
    private SVNProperties myFileProperties;
    private ISVNEventHandler myEventDispatcher;
    private String myURL;
    private String myRepositoryRootUrl;
    private ISVNOptions myOptions;
    private SVNDeltaProcessor myDeltaProcessor;
    private boolean myIsExpandKeywords;
    private String myChecksum;

    public SVNExportEditor(ISVNEventHandler iSVNEventHandler, String string, File file, boolean bl2, String string2, boolean bl3, String string3, ISVNOptions iSVNOptions) {
        this.myRoot = file;
        this.myIsForce = bl2;
        this.myEOLStyle = string2;
        this.myExternals = new SVNHashMap();
        this.myEventDispatcher = iSVNEventHandler;
        this.myURL = string;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myOptions = iSVNOptions;
        this.myIsExpandKeywords = bl3;
        this.myRepositoryRootUrl = string3;
    }

    public Map getCollectedExternals() {
        return this.myExternals;
    }

    @Override
    public void openRoot(long l2) {
        this.addDir("", null, -1L);
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        this.myCurrentDirectory = new File(this.myRoot, string);
        this.myCurrentPath = string;
        SVNFileType sVNFileType = SVNFileType.getType(this.myCurrentDirectory);
        if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
            if (!this.myIsForce) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' exists and is not a directory", (Object)this.myCurrentDirectory);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else {
                SVNFileUtil.deleteAll(this.myCurrentDirectory, this.myEventDispatcher);
            }
        } else if (sVNFileType == SVNFileType.DIRECTORY && !this.myIsForce) {
            Object object;
            if (!"".equals(string)) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' already exists", (Object)this.myCurrentDirectory);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if ((object = SVNFileListUtil.listFiles(this.myCurrentDirectory)) != null && ((File[])object).length > 0) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' already exists", (Object)this.myCurrentDirectory);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        } else if (sVNFileType == SVNFileType.NONE && !this.myCurrentDirectory.mkdirs()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "Cannot create directory ''{0}''", (Object)this.myCurrentDirectory);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        this.myEventDispatcher.handleEvent(SVNEventFactory.createSVNEvent(this.myCurrentDirectory, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null), -1.0);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if ("svn:externals".equals(string) && sVNPropertyValue != null) {
            this.myExternals.put(this.myCurrentPath, sVNPropertyValue.getString());
        }
    }

    @Override
    public void closeDir() {
        this.myCurrentDirectory = this.myCurrentDirectory.getParentFile();
        this.myCurrentPath = SVNPathUtil.removeTail(this.myCurrentPath);
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        File file = new File(this.myRoot, string);
        if (!this.myIsForce && file.exists()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "File ''{0}'' already exists", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        this.myCurrentFile = file;
        this.myFileProperties = new SVNProperties();
        this.myChecksum = null;
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        this.myFileProperties.put(string2, sVNPropertyValue);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        String string3 = SVNPathUtil.tail(string);
        this.myCurrentTmpFile = SVNFileUtil.createUniqueFile(this.myCurrentDirectory, string3, ".tmp", false);
        this.myDeltaProcessor.applyTextDelta((File)null, this.myCurrentTmpFile, true);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        return this.myDeltaProcessor.textDeltaChunk(sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        this.myChecksum = this.myDeltaProcessor.textDeltaEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(String string, String string2) {
        Object object;
        if (string2 == null) {
            string2 = this.myFileProperties.getStringValue("svn:entry:checksum");
        }
        if (this.myIsForce) {
            this.myCurrentFile.delete();
        }
        String string3 = this.myChecksum != null ? this.myChecksum : SVNFileUtil.computeChecksum(this.myCurrentTmpFile);
        this.myChecksum = null;
        if (string2 != null && !string2.equals(string3)) {
            object = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", this.myCurrentFile, string2, string3);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (!this.myIsExpandKeywords) {
            this.myFileProperties.put("svn:mime-type", "application/octet-stream");
        }
        try {
            boolean bl2;
            Object object2;
            String string4;
            object = this.myFileProperties.getStringValue("svn:entry:committed-date");
            boolean bl3 = this.myFileProperties.getStringValue("svn:special") != null;
            String string5 = this.myFileProperties.getStringValue("svn:mime-type");
            boolean bl4 = SVNProperty.isBinaryMimeType(string5);
            String string6 = this.myFileProperties.getStringValue("svn:keywords");
            Map map = null;
            if (string6 != null) {
                string4 = SVNPathUtil.append(this.myURL, SVNEncodingUtil.uriEncode(this.myCurrentPath));
                string4 = SVNPathUtil.append(string4, SVNEncodingUtil.uriEncode(this.myCurrentFile.getName()));
                object2 = this.myFileProperties.getStringValue("svn:entry:last-author");
                String string7 = this.myFileProperties.getStringValue("svn:entry:committed-rev");
                map = SVNTranslator.computeKeywords(string6, string4, this.myRepositoryRootUrl, (String)object2, (String)object, string7, this.myOptions);
            }
            string4 = SVNTranslator.getCharset(this.myFileProperties.getStringValue("svnkit:charset"), string5, this.myCurrentFile.getPath(), this.myOptions);
            object2 = null;
            if ("native".equals(this.myFileProperties.getStringValue("svn:eol-style"))) {
                object2 = SVNTranslator.getEOL(this.myEOLStyle != null ? this.myEOLStyle : this.myFileProperties.getStringValue("svn:eol-style"), this.myOptions);
            } else if (this.myFileProperties.containsName("svn:eol-style")) {
                object2 = SVNTranslator.getEOL(this.myFileProperties.getStringValue("svn:eol-style"), this.myOptions);
            }
            if (bl4) {
                string4 = null;
                object2 = null;
                map = null;
            }
            if (string4 != null || object2 != null || map != null && !map.isEmpty() || bl3) {
                SVNTranslator.translate(this.myCurrentTmpFile, this.myCurrentFile, string4, (byte[])object2, map, bl3, true);
            } else {
                SVNFileUtil.rename(this.myCurrentTmpFile, this.myCurrentFile);
            }
            boolean bl5 = bl2 = this.myFileProperties.getStringValue("svn:executable") != null;
            if (bl2) {
                SVNFileUtil.setExecutable(this.myCurrentFile, true);
            }
            if (!bl3 && object != null) {
                SVNFileUtil.setLastModified(this.myCurrentFile, SVNDate.parseDate((String)object).getTime());
            }
            this.myEventDispatcher.handleEvent(SVNEventFactory.createSVNEvent(this.myCurrentFile, SVNNodeKind.FILE, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null), -1.0);
        }
        finally {
            this.myCurrentTmpFile.delete();
        }
    }

    @Override
    public SVNCommitInfo closeEdit() {
        return null;
    }

    @Override
    public void targetRevision(long l2) {
    }

    @Override
    public void deleteEntry(String string, long l2) {
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    @Override
    public void openDir(String string, long l2) {
    }

    @Override
    public void openFile(String string, long l2) {
    }

    @Override
    public void abortEdit() {
    }
}

