/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNAuthenticationCancelledException;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNErrorManager {
    public static void cancel(String string, SVNLogType sVNLogType) {
        SVNErrorManager.cancel(string, Level.FINE, sVNLogType);
    }

    public static void cancel(String string, Level level, SVNLogType sVNLogType) {
        SVNDebugLog.getDefaultLog().log(sVNLogType, string, level);
        throw new SVNCancelException(SVNErrorMessage.create(SVNErrorCode.CANCELLED, string));
    }

    public static void cancelAuthentication(SVNErrorMessage sVNErrorMessage, SVNAuthentication sVNAuthentication) {
        throw new SVNAuthenticationCancelledException(sVNErrorMessage, sVNAuthentication);
    }

    public static void authenticationFailed(String string, Object object) {
        SVNErrorManager.authenticationFailed(string, object, Level.FINE);
    }

    public static void authenticationFailed(String string, Object object, Level level) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, string, object);
        SVNDebugLog.getDefaultLog().log(SVNLogType.NETWORK, sVNErrorMessage.getMessage(), level);
        throw new SVNAuthenticationException(sVNErrorMessage);
    }

    public static void error(SVNErrorMessage sVNErrorMessage, SVNLogType sVNLogType) {
        SVNErrorManager.error(sVNErrorMessage, Level.FINE, sVNLogType);
    }

    public static void error(SVNErrorMessage sVNErrorMessage, Level level, SVNLogType sVNLogType) {
        if (sVNErrorMessage == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);
        }
        SVNDebugLog.getDefaultLog().log(sVNLogType, sVNErrorMessage.getFullMessage(), level);
        if (sVNErrorMessage.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(sVNErrorMessage);
        }
        if (sVNErrorMessage.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(sVNErrorMessage);
        }
        throw new SVNException(sVNErrorMessage);
    }

    public static void error(SVNErrorMessage sVNErrorMessage, Throwable throwable, SVNLogType sVNLogType) {
        SVNErrorManager.error(sVNErrorMessage, throwable, Level.FINE, sVNLogType);
    }

    public static void error(SVNErrorMessage sVNErrorMessage, Throwable throwable, Level level, SVNLogType sVNLogType) {
        if (sVNErrorMessage == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);
        }
        SVNDebugLog.getDefaultLog().log(sVNLogType, sVNErrorMessage.getMessage(), level);
        if (throwable != null) {
            SVNDebugLog.getDefaultLog().log(sVNLogType, throwable, level);
        }
        if (sVNErrorMessage.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(sVNErrorMessage);
        }
        if (sVNErrorMessage.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(sVNErrorMessage);
        }
        throw new SVNException(sVNErrorMessage, throwable);
    }

    public static void error(SVNErrorMessage sVNErrorMessage, SVNErrorMessage sVNErrorMessage2, SVNLogType sVNLogType) {
        SVNErrorManager.error(sVNErrorMessage, sVNErrorMessage2, Level.FINE, sVNLogType);
    }

    public static void error(SVNErrorMessage sVNErrorMessage, SVNErrorMessage sVNErrorMessage2, Level level, SVNLogType sVNLogType) {
        if (sVNErrorMessage == null) {
            SVNErrorManager.error(sVNErrorMessage2, level, sVNLogType);
        } else if (sVNErrorMessage2 == null) {
            SVNErrorManager.error(sVNErrorMessage, level, sVNLogType);
        }
        sVNErrorMessage.setChildErrorMessage(sVNErrorMessage2);
        SVNDebugLog.getDefaultLog().log(sVNLogType, sVNErrorMessage.getMessage(), level);
        if (sVNErrorMessage.getErrorCode() == SVNErrorCode.CANCELLED || sVNErrorMessage2.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(sVNErrorMessage);
        }
        if (sVNErrorMessage.getErrorCode().isAuthentication() || sVNErrorMessage2.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(sVNErrorMessage);
        }
        throw new SVNException(sVNErrorMessage);
    }

    public static void error(SVNErrorMessage sVNErrorMessage, SVNErrorMessage sVNErrorMessage2, Throwable throwable, SVNLogType sVNLogType) {
        SVNErrorManager.error(sVNErrorMessage, sVNErrorMessage2, throwable, Level.FINE, sVNLogType);
    }

    public static void error(SVNErrorMessage sVNErrorMessage, SVNErrorMessage sVNErrorMessage2, Throwable throwable, Level level, SVNLogType sVNLogType) {
        if (sVNErrorMessage == null) {
            SVNErrorManager.error(sVNErrorMessage2, throwable, level, sVNLogType);
        } else if (sVNErrorMessage2 == null) {
            SVNErrorManager.error(sVNErrorMessage, throwable, level, sVNLogType);
        }
        sVNErrorMessage.setChildErrorMessage(sVNErrorMessage2);
        SVNDebugLog.getDefaultLog().log(sVNLogType, sVNErrorMessage.getMessage(), level);
        if (sVNErrorMessage.getErrorCode() == SVNErrorCode.CANCELLED || sVNErrorMessage2.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(sVNErrorMessage, throwable);
        }
        if (sVNErrorMessage.getErrorCode().isAuthentication() || sVNErrorMessage2.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(sVNErrorMessage, throwable);
        }
        throw new SVNException(sVNErrorMessage, throwable);
    }

    public static void assertionFailure(boolean bl2, String string, SVNLogType sVNLogType) {
        if (!bl2) {
            try {
                throw new Exception();
            }
            catch (Exception exception) {
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                StackTraceElement stackTraceElement = stackTraceElementArray[1];
                String string2 = "Assertion failure in class ''{0}'' (file {1}) in method ''{2}'' on line {3}";
                string2 = string != null ? string2 + ": {4}" : string2;
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL, string2, stackTraceElement.getClassName(), stackTraceElement.getFileName(), stackTraceElement.getMethodName(), String.valueOf(stackTraceElement.getLineNumber()), string);
                SVNErrorManager.error(sVNErrorMessage, sVNLogType);
            }
        }
    }
}

