/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharsetDecoder;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.ISVNLoadHandler;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDumpStreamParser {
    private ISVNCanceller myCanceller;

    public SVNDumpStreamParser(ISVNCanceller iSVNCanceller) {
        this.myCanceller = iSVNCanceller;
    }

    public void parseDumpStream(InputStream inputStream, ISVNLoadHandler iSVNLoadHandler, CharsetDecoder charsetDecoder) {
        String string = null;
        int n2 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Object object;
            SVNErrorMessage sVNErrorMessage;
            string = SVNFileUtil.readLineFromStream(inputStream, stringBuffer, charsetDecoder);
            if (string == null) {
                SVNAdminHelper.generateIncompleteDataError();
            }
            if (!string.startsWith("SVN-fs-dump-format-version:")) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            try {
                string = string.substring("SVN-fs-dump-format-version".length() + 1);
                string = string.trim();
                n2 = Integer.parseInt(string);
                if (n2 > 3) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Unsupported dumpfile version: {0}", new Object[]{n2});
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header");
                SVNErrorManager.error((SVNErrorMessage)object, numberFormatException, SVNLogType.FSFS);
            }
            while (true) {
                SVNErrorMessage sVNErrorMessage2;
                SVNErrorMessage sVNErrorMessage3;
                long l2;
                boolean bl2;
                String string2;
                Object object2;
                Object object3;
                this.myCanceller.checkCancelled();
                boolean bl3 = false;
                stringBuffer.setLength(0);
                string = SVNFileUtil.readLineFromStream(inputStream, stringBuffer, charsetDecoder);
                if (string == null) {
                    if (stringBuffer.length() <= 0) break;
                    SVNAdminHelper.generateIncompleteDataError();
                }
                if (string.length() == 0 || Character.isWhitespace(string.charAt(0))) continue;
                object = this.readHeaderBlock(inputStream, string, charsetDecoder);
                if (object.containsKey("Revision-number")) {
                    iSVNLoadHandler.closeRevision();
                    iSVNLoadHandler.openRevision((Map)object);
                } else if (object.containsKey("Node-path")) {
                    iSVNLoadHandler.openNode((Map)object);
                    bl3 = true;
                } else if (object.containsKey("UUID")) {
                    object3 = (String)object.get("UUID");
                    iSVNLoadHandler.parseUUID((String)object3);
                } else if (object.containsKey("SVN-fs-dump-format-version")) {
                    try {
                        n2 = Integer.parseInt((String)object.get("SVN-fs-dump-format-version"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        object2 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header");
                        SVNErrorManager.error((SVNErrorMessage)object2, numberFormatException, SVNLogType.FSFS);
                    }
                } else {
                    object3 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Unrecognized record type in stream");
                    SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.FSFS);
                }
                object3 = (String)object.get("Content-length");
                object2 = (String)object.get("Prop-content-length");
                String string3 = (String)object.get("Text-content-length");
                boolean bl4 = n2 == 1 && object3 != null && object2 == null && string3 == null;
                long l3 = 0L;
                if (object2 != null || bl4) {
                    string2 = (String)object.get("Prop-delta");
                    boolean bl5 = bl2 = string2 != null && "true".equals(string2);
                    if (bl3 && !bl2) {
                        iSVNLoadHandler.removeNodeProperties();
                    }
                    l2 = 0L;
                    try {
                        l2 = Long.parseLong((String)(object2 != null ? object2 : object3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse property block length header");
                        SVNErrorManager.error(sVNErrorMessage3, numberFormatException, SVNLogType.FSFS);
                    }
                    l3 += this.parsePropertyBlock(inputStream, iSVNLoadHandler, charsetDecoder, l2, bl3);
                }
                if (string3 != null) {
                    string2 = (String)object.get("Text-delta");
                    bl2 = string2 != null && "true".equals(string2);
                    l2 = 0L;
                    try {
                        l2 = Long.parseLong(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse text block length header");
                        SVNErrorManager.error(sVNErrorMessage3, numberFormatException, SVNLogType.FSFS);
                    }
                    iSVNLoadHandler.parseTextBlock(inputStream, l2, bl2);
                } else if (bl4) {
                    long l4 = 0L;
                    try {
                        l4 = Long.parseLong((String)object3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse content length header");
                        SVNErrorManager.error(sVNErrorMessage2, numberFormatException, SVNLogType.FSFS);
                    }
                    if ((l4 -= l3) > 0L || SVNNodeKind.parseKind((String)object.get("Node-kind")) == SVNNodeKind.FILE) {
                        iSVNLoadHandler.parseTextBlock(inputStream, l4, false);
                    }
                }
                if (object3 != null && !bl4) {
                    int n3;
                    int n4;
                    Object object4;
                    long l5 = 0L;
                    try {
                        l5 = Long.parseLong((String)object3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse content length header");
                        SVNErrorManager.error(sVNErrorMessage2, numberFormatException, SVNLogType.FSFS);
                    }
                    long l6 = 0L;
                    if (object2 != null) {
                        try {
                            l6 = Long.parseLong((String)object2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse property block length header");
                            SVNErrorManager.error(sVNErrorMessage3, numberFormatException, SVNLogType.FSFS);
                        }
                    }
                    l5 -= l6;
                    long l7 = 0L;
                    if (string3 != null) {
                        try {
                            l7 = Long.parseLong(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            SVNErrorMessage sVNErrorMessage4 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse text block length header");
                            SVNErrorManager.error(sVNErrorMessage4, numberFormatException, SVNLogType.FSFS);
                        }
                    }
                    if ((l5 -= l7) < 0L) {
                        object4 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Sum of subblock sizes larger than total block content length");
                        SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.FSFS);
                    }
                    object4 = new byte[16384];
                    long l8 = 0L;
                    long l9 = l5;
                    while (l5 > 0L && (n4 = inputStream.read((byte[])object4, 0, n3 = l5 >= 16384L ? 16384 : (int)l5)) >= 0) {
                        l8 += (long)n4;
                        l5 -= (long)n4;
                    }
                    if (l8 != l9) {
                        SVNAdminHelper.generateIncompleteDataError();
                    }
                }
                if (!bl3) continue;
                iSVNLoadHandler.closeNode();
                bl3 = false;
            }
            iSVNLoadHandler.closeRevision();
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
    }

    private long parsePropertyBlock(InputStream inputStream, ISVNLoadHandler iSVNLoadHandler, CharsetDecoder charsetDecoder, long l2, boolean bl2) {
        long l3 = 0L;
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        try {
            while (l2 != l3) {
                byte[] byArray;
                Object object;
                stringBuffer.setLength(0);
                string = SVNFileUtil.readLineFromStream(inputStream, stringBuffer, charsetDecoder);
                if (string == null) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Incomplete or unterminated property block");
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                }
                l3 += (long)(string.length() + 1);
                if ("PROPS-END".equals(string)) break;
                if (string.charAt(0) == 'K' && string.charAt(1) == ' ') {
                    int n2 = 0;
                    try {
                        n2 = Integer.parseInt(string.substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        object = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse node property key length");
                        SVNErrorManager.error((SVNErrorMessage)object, numberFormatException, SVNLogType.FSFS);
                    }
                    byArray = new byte[n2 + 1];
                    l3 += (long)SVNAdminHelper.readKeyOrValue(inputStream, byArray, n2 + 1);
                    object = new String(byArray, 0, n2, "UTF-8");
                    stringBuffer.setLength(0);
                    string = SVNFileUtil.readLineFromStream(inputStream, stringBuffer, charsetDecoder);
                    if (string == null) {
                        SVNAdminHelper.generateIncompleteDataError();
                    }
                    l3 += (long)(string.length() + 1);
                    if (string.charAt(0) == 'V' && string.charAt(1) == ' ') {
                        try {
                            n2 = Integer.parseInt(string.substring(2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse node property value length");
                            SVNErrorManager.error(sVNErrorMessage, numberFormatException, SVNLogType.FSFS);
                        }
                        byArray = new byte[n2 + 1];
                        l3 += (long)SVNAdminHelper.readKeyOrValue(inputStream, byArray, n2 + 1);
                        SVNPropertyValue sVNPropertyValue = SVNPropertyValue.create((String)object, byArray, 0, n2);
                        if (bl2) {
                            iSVNLoadHandler.setNodeProperty((String)object, sVNPropertyValue);
                            continue;
                        }
                        iSVNLoadHandler.setRevisionProperty((String)object, sVNPropertyValue);
                        continue;
                    }
                    SVNAdminHelper.generateStreamMalformedError();
                    continue;
                }
                if (string.charAt(0) == 'D' && string.charAt(1) == ' ') {
                    int n3 = 0;
                    try {
                        n3 = Integer.parseInt(string.substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        object = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse node property key length");
                        SVNErrorManager.error((SVNErrorMessage)object, numberFormatException, SVNLogType.FSFS);
                    }
                    byArray = new byte[n3 + 1];
                    l3 += (long)SVNAdminHelper.readKeyOrValue(inputStream, byArray, n3 + 1);
                    if (!bl2) {
                        SVNAdminHelper.generateStreamMalformedError();
                    }
                    object = new String(byArray, 0, n3, "UTF-8");
                    iSVNLoadHandler.deleteNodeProperty((String)object);
                    continue;
                }
                SVNAdminHelper.generateStreamMalformedError();
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        return l3;
    }

    private Map readHeaderBlock(InputStream inputStream, String string, CharsetDecoder charsetDecoder) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            Object object;
            Object object2;
            String string2 = null;
            stringBuffer.setLength(0);
            if (string != null) {
                string2 = string;
                string = null;
            } else {
                string2 = SVNFileUtil.readLineFromStream(inputStream, stringBuffer, charsetDecoder);
                if (string2 == null && stringBuffer.length() > 0) {
                    SVNAdminHelper.generateIncompleteDataError();
                } else if (stringBuffer.length() == 0) break;
            }
            int n2 = string2.indexOf(58);
            if (n2 == -1) {
                object2 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Dump stream contains a malformed header (with no '':'') at ''{0}''", (Object)(string2.length() > 20 ? string2.substring(0, 19) : string2));
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
            }
            object2 = string2.substring(0, n2);
            if (n2 + 2 > string2.length()) {
                object = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Dump stream contains a malformed header (with no value) at ''{0}''", (Object)(string2.length() > 20 ? string2.substring(0, 19) : string2));
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            object = string2.substring(n2 + 2);
            sVNHashMap.put(object2, object);
        }
        return sVNHashMap;
    }
}

