/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNDumpEditor$1;
import org.tmatesoft.svn.core.internal.wc.SVNDumpEditor$DirectoryInfo;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDumpEditor
implements ISVNEditor {
    private FSRoot myRoot;
    private FSFS myFSFS;
    private long myTargetRevision;
    private long myOldestDumpedRevision;
    private String myRootPath;
    private OutputStream myDumpStream;
    private boolean myUseDeltas;
    private boolean myIsVerify;
    private SVNDumpEditor$DirectoryInfo myCurrentDirInfo;
    private SVNDeltaCombiner myDeltaCombiner;
    private SVNDeltaGenerator myDeltaGenerator;

    public SVNDumpEditor(FSFS fSFS, FSRoot fSRoot, long l2, long l3, String string, OutputStream outputStream, boolean bl2, boolean bl3) {
        this.myRoot = fSRoot;
        this.myFSFS = fSFS;
        this.myTargetRevision = l2;
        this.myOldestDumpedRevision = l3;
        this.myRootPath = string;
        this.myDumpStream = outputStream;
        this.myUseDeltas = bl2;
        this.myIsVerify = bl3;
    }

    public void reset(FSFS fSFS, FSRoot fSRoot, long l2, long l3, String string, OutputStream outputStream, boolean bl2, boolean bl3) {
        this.myRoot = fSRoot;
        this.myFSFS = fSFS;
        this.myTargetRevision = l2;
        this.myOldestDumpedRevision = l3;
        this.myRootPath = string;
        this.myDumpStream = outputStream;
        this.myUseDeltas = bl2;
        this.myIsVerify = bl3;
        this.myCurrentDirInfo = null;
    }

    @Override
    public void abortEdit() {
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        SVNDumpEditor$DirectoryInfo sVNDumpEditor$DirectoryInfo = this.myCurrentDirInfo;
        this.myCurrentDirInfo = this.createDirectoryInfo(string, string2, l2, sVNDumpEditor$DirectoryInfo);
        boolean bl2 = sVNDumpEditor$DirectoryInfo.myDeletedEntries.containsKey(string);
        boolean bl3 = string2 != null && SVNRevision.isValidRevisionNumber(l2);
        this.dumpNode(string, SVNNodeKind.DIR, bl2 ? 3 : 1, bl3, bl3 ? string2 : null, bl3 ? l2 : -1L);
        if (bl2) {
            sVNDumpEditor$DirectoryInfo.myDeletedEntries.remove(string);
        }
        this.myCurrentDirInfo.myIsWrittenOut = true;
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        boolean bl2 = string2 != null && SVNRevision.isValidRevisionNumber(l2);
        boolean bl3 = this.myCurrentDirInfo.myDeletedEntries.containsKey(string);
        this.dumpNode(string, SVNNodeKind.FILE, bl3 ? 3 : 1, bl2, bl2 ? string2 : null, bl2 ? l2 : -1L);
        if (bl3) {
            this.myCurrentDirInfo.myDeletedEntries.remove(string);
        }
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (!this.myCurrentDirInfo.myIsWrittenOut) {
            this.dumpNode(this.myCurrentDirInfo.myFullPath, SVNNodeKind.DIR, 0, false, this.myCurrentDirInfo.myComparePath, this.myCurrentDirInfo.myCompareRevision);
            this.myCurrentDirInfo.myIsWrittenOut = true;
        }
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
    }

    @Override
    public void closeDir() {
        if (this.myIsVerify) {
            FSRevisionNode fSRevisionNode = this.myRoot.getRevisionNode(this.myCurrentDirInfo.myFullPath);
            Object object = fSRevisionNode.getDirEntries(this.myFSFS);
            for (String string : object.keySet()) {
                String string2 = SVNPathUtil.append(this.myCurrentDirInfo.myFullPath, string);
                SVNNodeKind sVNNodeKind = this.myRoot.checkNodeKind(string2);
                FSRevisionNode fSRevisionNode2 = this.myRoot.getRevisionNode(string2);
                if (sVNNodeKind == SVNNodeKind.DIR) {
                    fSRevisionNode2.getDirEntries(this.myFSFS);
                    continue;
                }
                if (sVNNodeKind == SVNNodeKind.FILE) {
                    fSRevisionNode2.getFileLength();
                    continue;
                }
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "Unexpected node kind {0} for ''{1}''", sVNNodeKind, string2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
        for (Object object : this.myCurrentDirInfo.myDeletedEntries.keySet()) {
            this.dumpNode((String)object, SVNNodeKind.UNKNOWN, 2, false, null, -1L);
        }
        this.myCurrentDirInfo = this.myCurrentDirInfo.myParentInfo;
    }

    @Override
    public SVNCommitInfo closeEdit() {
        return null;
    }

    @Override
    public void closeFile(String string, String string2) {
    }

    @Override
    public void deleteEntry(String string, long l2) {
        this.myCurrentDirInfo.myDeletedEntries.put(string, string);
    }

    @Override
    public void openDir(String string, long l2) {
        SVNDumpEditor$DirectoryInfo sVNDumpEditor$DirectoryInfo = this.myCurrentDirInfo;
        String string2 = null;
        long l3 = -1L;
        if (sVNDumpEditor$DirectoryInfo != null && sVNDumpEditor$DirectoryInfo.myComparePath != null && SVNRevision.isValidRevisionNumber(sVNDumpEditor$DirectoryInfo.myCompareRevision)) {
            string2 = SVNPathUtil.append(sVNDumpEditor$DirectoryInfo.myComparePath, SVNPathUtil.tail(string));
            l3 = sVNDumpEditor$DirectoryInfo.myCompareRevision;
        }
        this.myCurrentDirInfo = this.createDirectoryInfo(string, string2, l3, sVNDumpEditor$DirectoryInfo);
    }

    @Override
    public void openFile(String string, long l2) {
        String string2 = null;
        long l3 = -1L;
        if (this.myCurrentDirInfo != null && this.myCurrentDirInfo.myComparePath != null && SVNRevision.isValidRevisionNumber(this.myCurrentDirInfo.myCompareRevision)) {
            string2 = SVNPathUtil.append(this.myCurrentDirInfo.myComparePath, SVNPathUtil.tail(string));
            l3 = this.myCurrentDirInfo.myCompareRevision;
        }
        this.dumpNode(string, SVNNodeKind.FILE, 0, false, string2, l3);
    }

    @Override
    public void openRoot(long l2) {
        this.myCurrentDirInfo = this.createDirectoryInfo(null, null, -1L, null);
    }

    @Override
    public void targetRevision(long l2) {
    }

    @Override
    public void applyTextDelta(String string, String string2) {
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        return null;
    }

    @Override
    public void textDeltaEnd(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpNode(String string, SVNNodeKind sVNNodeKind, int n2, boolean bl2, String string2, long l2) {
        File file = null;
        try {
            Object object;
            Object object2;
            Object object3;
            this.writeDumpData("Node-path: " + (string.startsWith("/") ? string.substring(1) : string) + "\n");
            if (sVNNodeKind == SVNNodeKind.FILE) {
                this.writeDumpData("Node-kind: file\n");
            } else if (sVNNodeKind == SVNNodeKind.DIR) {
                this.writeDumpData("Node-kind: dir\n");
            }
            if (string2 != null) {
                string2 = string2.startsWith("/") ? string2.substring(1) : string2;
            }
            String string3 = string;
            long l3 = this.myTargetRevision - 1L;
            if (string2 != null && SVNRevision.isValidRevisionNumber(l2)) {
                string3 = string2;
                l3 = l2;
            }
            string3 = SVNPathUtil.canonicalizePath(string3);
            string3 = SVNPathUtil.getAbsolutePath(string3);
            FSRevisionRoot fSRevisionRoot = null;
            boolean bl3 = false;
            boolean bl4 = false;
            String string4 = SVNPathUtil.getAbsolutePath(SVNPathUtil.canonicalizePath(string));
            switch (n2) {
                case 0: {
                    this.writeDumpData("Node-action: change\n");
                    fSRevisionRoot = this.myFSFS.createRevisionRoot(l3);
                    bl3 = FSRepositoryUtil.arePropertiesChanged(fSRevisionRoot, string3, this.myRoot, string4);
                    if (sVNNodeKind != SVNNodeKind.FILE) break;
                    bl4 = FSRepositoryUtil.areFileContentsChanged(fSRevisionRoot, string3, this.myRoot, string4);
                    break;
                }
                case 3: {
                    if (!bl2) {
                        this.writeDumpData("Node-action: replace\n");
                        if (sVNNodeKind == SVNNodeKind.FILE) {
                            bl4 = true;
                        }
                        bl3 = true;
                        break;
                    }
                    this.writeDumpData("Node-action: delete\n\n");
                    this.dumpNode(string, sVNNodeKind, 1, bl2, string3, l3);
                    bl4 = false;
                    bl3 = false;
                    break;
                }
                case 2: {
                    this.writeDumpData("Node-action: delete\n");
                    bl4 = false;
                    bl3 = false;
                    break;
                }
                case 1: {
                    this.writeDumpData("Node-action: add\n");
                    if (!bl2) {
                        if (sVNNodeKind == SVNNodeKind.FILE) {
                            bl4 = true;
                        }
                        bl3 = true;
                        break;
                    }
                    if (!this.myIsVerify && l2 < this.myOldestDumpedRevision) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, "WARNING: Referencing data in revision " + l2 + ", which is older than the oldest\nWARNING: dumped revision (" + this.myOldestDumpedRevision + ").  Loading this dump into an empty repository\nWARNING: will fail.\n");
                    }
                    this.writeDumpData("Node-copyfrom-rev: " + l2 + "\n");
                    this.writeDumpData("Node-copyfrom-path: " + string2 + "\n");
                    fSRevisionRoot = this.myFSFS.createRevisionRoot(l3);
                    bl3 = FSRepositoryUtil.arePropertiesChanged(fSRevisionRoot, string3, this.myRoot, string4);
                    if (sVNNodeKind != SVNNodeKind.FILE) break;
                    bl4 = FSRepositoryUtil.areFileContentsChanged(fSRevisionRoot, string3, this.myRoot, string4);
                    FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string3);
                    String string5 = fSRevisionNode.getFileMD5Checksum();
                    if (string5 != null && string5.length() > 0) {
                        this.writeDumpData("Text-copy-source-md5: " + string5 + "\n");
                    }
                    if ((string5 = fSRevisionNode.getFileSHA1Checksum()) == null || string5.length() <= 0) break;
                    this.writeDumpData("Text-copy-source-sha1: " + string5 + "\n");
                }
            }
            if (!bl3 && !bl4) {
                this.writeDumpData("\n\n");
                return;
            }
            long l4 = 0L;
            String string6 = null;
            if (bl3) {
                object3 = this.myRoot.getRevisionNode(string4);
                SVNProperties sVNProperties = ((FSRevisionNode)object3).getProperties(this.myFSFS);
                object2 = null;
                if (this.myUseDeltas && fSRevisionRoot != null) {
                    object = fSRevisionRoot.getRevisionNode(string3);
                    object2 = ((FSRevisionNode)object).getProperties(this.myFSFS);
                    this.writeDumpData("Prop-delta: true\n");
                }
                object = new ByteArrayOutputStream();
                SVNAdminHelper.writeProperties(sVNProperties, (SVNProperties)object2, (OutputStream)object);
                string6 = new String(((ByteArrayOutputStream)object).toByteArray(), "UTF-8");
                l4 += (long)string6.length();
                this.writeDumpData("Prop-content-length: " + string6.length() + "\n");
            }
            if (bl4 && sVNNodeKind == SVNNodeKind.FILE) {
                long l5 = 0L;
                object2 = this.myRoot.getRevisionNode(string4);
                if (this.myUseDeltas) {
                    OutputStream outputStream;
                    InputStream inputStream;
                    block42: {
                        file = SVNFileUtil.createTempFile("dump", ".tmp");
                        object = null;
                        inputStream = null;
                        outputStream = null;
                        SVNDeltaCombiner sVNDeltaCombiner = this.getDeltaCombiner();
                        SVNDeltaGenerator sVNDeltaGenerator = this.getDeltaGenerator();
                        try {
                            object = fSRevisionRoot != null && string3 != null ? fSRevisionRoot.getFileStreamForPath(sVNDeltaCombiner, string3) : SVNFileUtil.DUMMY_IN;
                            inputStream = this.myRoot.getFileStreamForPath(sVNDeltaCombiner, string4);
                            outputStream = SVNFileUtil.openFileForWriting(file);
                            CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream, 0L);
                            SVNDumpEditor$1 sVNDumpEditor$1 = new SVNDumpEditor$1(this, countingOutputStream);
                            sVNDeltaGenerator.sendDelta(null, (InputStream)object, 0L, inputStream, sVNDumpEditor$1, false);
                            l5 = countingOutputStream.getPosition();
                            if (fSRevisionRoot == null) break block42;
                            FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string3);
                            String string7 = fSRevisionNode.getFileMD5Checksum();
                            if (string7 != null && string7.length() > 0) {
                                this.writeDumpData("Text-delta-base-md5: " + string7 + "\n");
                            }
                            if ((string7 = fSRevisionNode.getFileSHA1Checksum()) == null) {
                                string7 = this.computeSHA1Checksum(fSRevisionRoot, string3);
                            }
                            if (string7 != null && string7.length() > 0) {
                                this.writeDumpData("Text-delta-base-sha1: " + string7 + "\n");
                            }
                        }
                        catch (Throwable throwable) {
                            SVNFileUtil.closeFile((InputStream)object);
                            SVNFileUtil.closeFile(inputStream);
                            SVNFileUtil.closeFile(outputStream);
                            throw throwable;
                        }
                    }
                    SVNFileUtil.closeFile((InputStream)object);
                    SVNFileUtil.closeFile(inputStream);
                    SVNFileUtil.closeFile(outputStream);
                    this.writeDumpData("Text-delta: true\n");
                } else {
                    l5 = ((FSRevisionNode)object2).getFileLength();
                }
                l4 += l5;
                this.writeDumpData("Text-content-length: " + l5 + "\n");
                object = ((FSRevisionNode)object2).getFileMD5Checksum();
                if (object != null && ((String)object).length() > 0) {
                    this.writeDumpData("Text-content-md5: " + (String)object + "\n");
                }
                if ((object = ((FSRevisionNode)object2).getFileSHA1Checksum()) == null) {
                    object = this.computeSHA1Checksum(this.myRoot, string4);
                }
                if (object != null && ((String)object).length() > 0) {
                    this.writeDumpData("Text-content-sha1: " + (String)object + "\n");
                }
            }
            this.writeDumpData("Content-length: " + l4 + "\n\n");
            if (bl3) {
                this.writeDumpData(string6);
            }
            if (bl4 && sVNNodeKind == SVNNodeKind.FILE) {
                object3 = null;
                try {
                    object3 = file != null ? SVNFileUtil.openFileForReading(file, SVNLogType.WC) : this.myRoot.getFileStreamForPath(this.getDeltaCombiner(), string4);
                    FSRepositoryUtil.copy((InputStream)object3, this.myDumpStream, null);
                }
                finally {
                    SVNFileUtil.closeFile((InputStream)object3);
                }
            }
            this.writeDumpData("\n\n");
            SVNFileUtil.deleteFile(file);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.deleteFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeSHA1Checksum(FSRoot fSRoot, String string) {
        InputStream inputStream = fSRoot.getFileStreamForPath(this.getDeltaCombiner(), string);
        SVNChecksumInputStream sVNChecksumInputStream = null;
        try {
            sVNChecksumInputStream = new SVNChecksumInputStream(inputStream, "SHA1");
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(sVNChecksumInputStream);
            throw throwable;
        }
        SVNFileUtil.closeFile(sVNChecksumInputStream);
        return sVNChecksumInputStream != null ? sVNChecksumInputStream.getDigest() : null;
    }

    private SVNDeltaGenerator getDeltaGenerator() {
        if (this.myDeltaGenerator == null) {
            this.myDeltaGenerator = new SVNDeltaGenerator();
        }
        return this.myDeltaGenerator;
    }

    private SVNDeltaCombiner getDeltaCombiner() {
        if (this.myDeltaCombiner == null) {
            this.myDeltaCombiner = new SVNDeltaCombiner();
        } else {
            this.myDeltaCombiner.reset();
        }
        return this.myDeltaCombiner;
    }

    private SVNDumpEditor$DirectoryInfo createDirectoryInfo(String string, String string2, long l2, SVNDumpEditor$DirectoryInfo sVNDumpEditor$DirectoryInfo) {
        String string3 = null;
        string3 = sVNDumpEditor$DirectoryInfo != null ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myRootPath, string)) : this.myRootPath;
        String string4 = null;
        if (string2 != null) {
            string4 = string2.startsWith("/") ? string2.substring(1) : string2;
        }
        return new SVNDumpEditor$DirectoryInfo(this, string3, string4, l2, sVNDumpEditor$DirectoryInfo);
    }

    private void writeDumpData(String string) {
        this.myDumpStream.write(string.getBytes("UTF-8"));
    }
}

