/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDiffStatusEditor$SVNSummarize;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.SVNDiffStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNDiffStatusEditor
implements ISVNEditor {
    private SVNDiffStatusEditor$SVNSummarize myCurrentDirSummarize;
    private SVNDiffStatusEditor$SVNSummarize myCurrentFileSummarize;
    private SVNRepository myRepository;
    private ISVNDiffStatusHandler myHandler;
    private long myRevision;
    private SVNURL myRootURL;
    private File myAnchor;
    private String myTarget;

    public SVNDiffStatusEditor(File file, String string, SVNRepository sVNRepository, long l2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.myRepository = sVNRepository;
        this.myHandler = iSVNDiffStatusHandler;
        this.myRevision = l2;
        this.myRootURL = sVNRepository.getLocation();
        this.myAnchor = file;
        this.myTarget = string;
    }

    @Override
    public void openRoot(long l2) {
        this.myCurrentDirSummarize = new SVNDiffStatusEditor$SVNSummarize(this, null, "", SVNNodeKind.DIR);
    }

    @Override
    public void targetRevision(long l2) {
    }

    @Override
    public void deleteEntry(String string, long l2) {
        SVNNodeKind sVNNodeKind = this.myRepository.checkPath(string, this.myRevision);
        String string2 = this.getStatusPath(string);
        SVNDiffStatus sVNDiffStatus = new SVNDiffStatus(this.myAnchor != null ? new File(this.myAnchor, string) : null, this.myRootURL.appendPath(string, false), string2, SVNStatusType.STATUS_DELETED, false, sVNNodeKind);
        this.myHandler.handleDiffStatus(sVNDiffStatus);
        if (sVNNodeKind == SVNNodeKind.DIR) {
            this.diffDeletedDir(string);
        }
    }

    private void diffDeletedDir(String string) {
        Collection collection = this.myRepository.getDir(string, this.myRevision, null, 1, (Collection)null);
        for (SVNDirEntry sVNDirEntry : collection) {
            String string2 = sVNDirEntry.getName();
            if ("".equals(string2)) continue;
            String string3 = SVNPathUtil.append(string, string2);
            String string4 = this.getStatusPath(string3);
            SVNDiffStatus sVNDiffStatus = new SVNDiffStatus(this.myAnchor != null ? new File(this.myAnchor, string3) : null, this.myRootURL.appendPath(string3, false), string4, SVNStatusType.STATUS_DELETED, false, sVNDirEntry.getKind());
            this.myHandler.handleDiffStatus(sVNDiffStatus);
            if (sVNDirEntry.getKind() != SVNNodeKind.DIR) continue;
            this.diffDeletedDir(string3);
        }
    }

    private String getStatusPath(String string) {
        String string2 = string;
        if (this.myTarget != null && (string.equals(this.myTarget) || string.startsWith(this.myTarget + "/"))) {
            string2 = SVNPathUtil.removeHead(string);
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    @Override
    public void openDir(String string, long l2) {
        this.myCurrentDirSummarize = new SVNDiffStatusEditor$SVNSummarize(this, this.myCurrentDirSummarize, string, SVNNodeKind.DIR);
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        this.myCurrentDirSummarize = new SVNDiffStatusEditor$SVNSummarize(this, this.myCurrentDirSummarize, string, SVNNodeKind.DIR);
        SVNDiffStatusEditor$SVNSummarize.access$002(this.myCurrentDirSummarize, SVNStatusType.STATUS_ADDED);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (SVNProperty.isRegularProperty(string) && SVNDiffStatusEditor$SVNSummarize.access$000(this.myCurrentDirSummarize) != SVNStatusType.STATUS_ADDED) {
            SVNDiffStatusEditor$SVNSummarize.access$102(this.myCurrentDirSummarize, true);
        }
    }

    @Override
    public void closeDir() {
        this.myHandler.handleDiffStatus(this.myCurrentDirSummarize.toStatus());
        this.myCurrentDirSummarize = SVNDiffStatusEditor$SVNSummarize.access$200(this.myCurrentDirSummarize);
    }

    @Override
    public void openFile(String string, long l2) {
        this.myCurrentFileSummarize = new SVNDiffStatusEditor$SVNSummarize(this, this.myCurrentDirSummarize, string, SVNNodeKind.FILE);
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        this.myCurrentFileSummarize = new SVNDiffStatusEditor$SVNSummarize(this, this.myCurrentDirSummarize, string, SVNNodeKind.FILE);
        SVNDiffStatusEditor$SVNSummarize.access$002(this.myCurrentFileSummarize, SVNStatusType.STATUS_ADDED);
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (SVNProperty.isRegularProperty(string2) && SVNDiffStatusEditor$SVNSummarize.access$000(this.myCurrentFileSummarize) != SVNStatusType.STATUS_ADDED) {
            SVNDiffStatusEditor$SVNSummarize.access$102(this.myCurrentFileSummarize, true);
        }
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        if (SVNDiffStatusEditor$SVNSummarize.access$000(this.myCurrentFileSummarize) != SVNStatusType.STATUS_ADDED) {
            SVNDiffStatusEditor$SVNSummarize.access$002(this.myCurrentFileSummarize, SVNStatusType.STATUS_MODIFIED);
        }
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        return null;
    }

    @Override
    public void textDeltaEnd(String string) {
    }

    @Override
    public void closeFile(String string, String string2) {
        this.myHandler.handleDiffStatus(this.myCurrentFileSummarize.toStatus());
        this.myCurrentFileSummarize = null;
    }

    @Override
    public SVNCommitInfo closeEdit() {
        if (this.myCurrentDirSummarize != null) {
            this.myHandler.handleDiffStatus(this.myCurrentDirSummarize.toStatus());
        }
        return null;
    }

    @Override
    public void abortEdit() {
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    static /* synthetic */ File access$300(SVNDiffStatusEditor sVNDiffStatusEditor) {
        return sVNDiffStatusEditor.myAnchor;
    }

    static /* synthetic */ String access$400(SVNDiffStatusEditor sVNDiffStatusEditor, String string) {
        return sVNDiffStatusEditor.getStatusPath(string);
    }

    static /* synthetic */ SVNURL access$500(SVNDiffStatusEditor sVNDiffStatusEditor) {
        return sVNDiffStatusEditor.myRootURL;
    }
}

