/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDiffEditor$SVNDirectoryInfo;
import org.tmatesoft.svn.core.internal.wc.SVNDiffEditor$SVNFileInfo;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDiffEditor
implements ISVNEditor {
    private SVNWCAccess myWCAccess;
    private boolean myUseAncestry;
    private boolean myIsReverseDiff;
    private boolean myIsCompareToBase;
    private boolean myIsRootOpen;
    private long myTargetRevision;
    private SVNDiffEditor$SVNDirectoryInfo myCurrentDirectory;
    private SVNDiffEditor$SVNFileInfo myCurrentFile;
    private SVNDeltaProcessor myDeltaProcessor;
    private SVNAdminAreaInfo myAdminInfo;
    private SVNDepth myDepth;
    private File myTempDirectory;
    private AbstractDiffCallback myDiffCallback;
    private Collection myChangeLists;
    private String myWCRootPath;

    public SVNDiffEditor(SVNWCAccess sVNWCAccess, SVNAdminAreaInfo sVNAdminAreaInfo, AbstractDiffCallback abstractDiffCallback, boolean bl2, boolean bl3, boolean bl4, SVNDepth sVNDepth, Collection collection) {
        this.myWCAccess = sVNWCAccess;
        this.myAdminInfo = sVNAdminAreaInfo;
        this.myUseAncestry = bl2;
        this.myIsReverseDiff = bl3;
        this.myDepth = sVNDepth;
        this.myIsCompareToBase = bl4;
        this.myDiffCallback = abstractDiffCallback;
        this.myChangeLists = collection != null ? collection : Collections.EMPTY_LIST;
        this.myDeltaProcessor = new SVNDeltaProcessor();
    }

    @Override
    public void targetRevision(long l2) {
        this.myTargetRevision = l2;
    }

    @Override
    public void openRoot(long l2) {
        this.myIsRootOpen = true;
        this.myCurrentDirectory = this.createDirInfo(null, "", false, this.myDepth);
    }

    @Override
    public void deleteEntry(String string, long l2) {
        File file = new File(this.myAdminInfo.getAnchor().getRoot(), string);
        SVNAdminArea sVNAdminArea = this.myWCAccess.probeRetrieve(file);
        SVNEntry sVNEntry = this.myWCAccess.getEntry(file, false);
        if (sVNEntry == null) {
            return;
        }
        String string2 = SVNPathUtil.tail(string);
        SVNDiffEditor$SVNDirectoryInfo.access$000(this.myCurrentDirectory).add(string2);
        if (!this.myIsCompareToBase && sVNEntry.isScheduledForDeletion()) {
            return;
        }
        if (sVNEntry.isFile()) {
            if (this.myIsReverseDiff) {
                File file2 = sVNAdminArea.getBaseFile(string2, false);
                SVNProperties sVNProperties = sVNAdminArea.getBaseProperties(string2).asMap();
                this.getDiffCallback().fileDeleted(string, file2, null, null, null, sVNProperties, null);
            } else {
                this.reportAddedFile(this.myCurrentDirectory, string, sVNEntry);
            }
        } else if (sVNEntry.isDirectory()) {
            SVNDiffEditor$SVNDirectoryInfo sVNDiffEditor$SVNDirectoryInfo = this.createDirInfo(this.myCurrentDirectory, string, false, SVNDepth.INFINITY);
            this.reportAddedDir(sVNDiffEditor$SVNDirectoryInfo);
        }
    }

    private void reportAddedDir(SVNDiffEditor$SVNDirectoryInfo sVNDiffEditor$SVNDirectoryInfo) {
        Object object;
        Object object2;
        SVNAdminArea sVNAdminArea = this.retrieve(SVNDiffEditor$SVNDirectoryInfo.access$100(sVNDiffEditor$SVNDirectoryInfo));
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
        if (SVNWCAccess.matchesChangeList(this.myChangeLists, sVNEntry) && !((SVNProperties)(object2 = SVNDiffEditor.computePropsDiff(new SVNProperties(), (SVNProperties)(object = this.myIsCompareToBase ? sVNAdminArea.getBaseProperties(sVNAdminArea.getThisDirName()).asMap() : sVNAdminArea.getProperties(sVNAdminArea.getThisDirName()).asMap())))).isEmpty()) {
            this.getDiffCallback().propertiesChanged(SVNDiffEditor$SVNDirectoryInfo.access$100(sVNDiffEditor$SVNDirectoryInfo), null, (SVNProperties)object2, null);
        }
        object = sVNAdminArea.entries(false);
        while (object.hasNext()) {
            object2 = (SVNEntry)object.next();
            if (sVNAdminArea.getThisDirName().equals(((SVNEntry)object2).getName()) || !this.myIsCompareToBase && ((SVNEntry)object2).isScheduledForDeletion()) continue;
            if (((SVNEntry)object2).isFile()) {
                this.reportAddedFile(sVNDiffEditor$SVNDirectoryInfo, SVNPathUtil.append(SVNDiffEditor$SVNDirectoryInfo.access$100(sVNDiffEditor$SVNDirectoryInfo), ((SVNEntry)object2).getName()), (SVNEntry)object2);
                continue;
            }
            if (!((SVNEntry)object2).isDirectory() || SVNDiffEditor$SVNDirectoryInfo.access$200(sVNDiffEditor$SVNDirectoryInfo).compareTo(SVNDepth.FILES) <= 0 && SVNDiffEditor$SVNDirectoryInfo.access$200(sVNDiffEditor$SVNDirectoryInfo) != SVNDepth.UNKNOWN) continue;
            SVNDepth sVNDepth = SVNDiffEditor$SVNDirectoryInfo.access$200(sVNDiffEditor$SVNDirectoryInfo);
            if (sVNDepth == SVNDepth.IMMEDIATES) {
                sVNDepth = SVNDepth.EMPTY;
            }
            SVNDiffEditor$SVNDirectoryInfo sVNDiffEditor$SVNDirectoryInfo2 = this.createDirInfo(sVNDiffEditor$SVNDirectoryInfo, SVNPathUtil.append(SVNDiffEditor$SVNDirectoryInfo.access$100(sVNDiffEditor$SVNDirectoryInfo), ((SVNEntry)object2).getName()), false, sVNDepth);
            this.reportAddedDir(sVNDiffEditor$SVNDirectoryInfo2);
        }
    }

    private void reportAddedFile(SVNDiffEditor$SVNDirectoryInfo sVNDiffEditor$SVNDirectoryInfo, String string, SVNEntry sVNEntry) {
        if (!SVNWCAccess.matchesChangeList(this.myChangeLists, sVNEntry)) {
            return;
        }
        if (sVNEntry.isCopied()) {
            if (this.myIsCompareToBase) {
                return;
            }
            this.reportModifiedFile(sVNDiffEditor$SVNDirectoryInfo, sVNEntry);
            return;
        }
        SVNAdminArea sVNAdminArea = this.retrieve(SVNDiffEditor$SVNDirectoryInfo.access$100(sVNDiffEditor$SVNDirectoryInfo));
        String string2 = SVNPathUtil.tail(string);
        SVNProperties sVNProperties = null;
        sVNProperties = this.myIsCompareToBase ? sVNAdminArea.getBaseProperties(string2).asMap() : sVNAdminArea.getProperties(string2).asMap();
        String string3 = sVNProperties.getStringValue("svn:mime-type");
        SVNProperties sVNProperties2 = SVNDiffEditor.computePropsDiff(new SVNProperties(), sVNProperties);
        File file = this.myIsCompareToBase ? sVNAdminArea.getBaseFile(string2, false) : this.detranslateFile(sVNAdminArea, string2);
        this.getDiffCallback().fileAdded(string, null, file, 0L, sVNEntry.getRevision(), null, string3, null, sVNProperties2, null);
    }

    private void reportModifiedFile(SVNDiffEditor$SVNDirectoryInfo sVNDiffEditor$SVNDirectoryInfo, SVNEntry sVNEntry) {
        String string;
        boolean bl2;
        SVNAdminArea sVNAdminArea = this.retrieve(SVNDiffEditor$SVNDirectoryInfo.access$100(sVNDiffEditor$SVNDirectoryInfo));
        if (!SVNWCAccess.matchesChangeList(this.myChangeLists, sVNEntry)) {
            return;
        }
        String string2 = sVNEntry.getSchedule();
        String string3 = sVNEntry.getName();
        if (!this.getDiffCallback().isDiffCopiedAsAdded() && sVNEntry.isCopied()) {
            string2 = null;
        }
        if (!this.myUseAncestry && sVNEntry.isScheduledForReplacement()) {
            string2 = null;
        }
        SVNProperties sVNProperties = null;
        SVNProperties sVNProperties2 = null;
        File file = sVNAdminArea.getBaseFile(string3, false);
        if (SVNFileType.getType(file) == SVNFileType.NONE) {
            file = sVNAdminArea.getFile(SVNAdminUtil.getTextRevertPath(string3, false));
        }
        if (!sVNEntry.isScheduledForDeletion()) {
            if (this.getDiffCallback().isDiffCopiedAsAdded() && sVNEntry.isCopied()) {
                sVNProperties2 = new SVNProperties();
                sVNProperties = sVNAdminArea.getProperties(string3).asMap();
            } else {
                sVNProperties2 = sVNAdminArea.getBaseProperties(string3).asMap();
                bl2 = sVNAdminArea.hasPropModifications(string3);
                sVNProperties = bl2 ? SVNDiffEditor.computePropsDiff(sVNProperties2, sVNAdminArea.getProperties(string3).asMap()) : new SVNProperties();
            }
        } else {
            sVNProperties2 = sVNAdminArea.getBaseProperties(string3).asMap();
        }
        bl2 = string2 != null && sVNEntry.isScheduledForAddition();
        String string4 = SVNPathUtil.append(SVNDiffEditor$SVNDirectoryInfo.access$100(sVNDiffEditor$SVNDirectoryInfo), string3);
        if (string2 != null && (sVNEntry.isScheduledForDeletion() || sVNEntry.isScheduledForReplacement())) {
            string = sVNAdminArea.getBaseProperties(string3).getStringPropertyValue("svn:mime-type");
            this.getDiffCallback().fileDeleted(string4, file, null, string, null, sVNAdminArea.getBaseProperties(string3).asMap(), null);
            bl2 = sVNEntry.isScheduledForReplacement();
        }
        if (bl2) {
            string = sVNAdminArea.getProperties(string3).getStringPropertyValue("svn:mime-type");
            File file2 = this.detranslateFile(sVNAdminArea, string3);
            SVNProperties sVNProperties3 = null;
            long l2 = sVNEntry.getRevision();
            if (sVNEntry.isCopied() && this.getDiffCallback().isDiffCopiedAsAdded()) {
                sVNProperties3 = new SVNProperties();
                l2 = 0L;
            } else {
                sVNProperties3 = sVNAdminArea.getBaseProperties(string3).asMap();
            }
            this.getDiffCallback().fileAdded(string4, null, file2, 0L, l2, string, null, sVNProperties3, sVNProperties, null);
        } else if (string2 == null) {
            boolean bl3 = sVNAdminArea.hasTextModifications(string3, false);
            File file3 = null;
            if (bl3) {
                file3 = this.detranslateFile(sVNAdminArea, string3);
            }
            if (bl3 || sVNProperties != null && !sVNProperties.isEmpty()) {
                String string5 = sVNAdminArea.getBaseProperties(string3).getStringPropertyValue("svn:mime-type");
                String string6 = sVNAdminArea.getProperties(string3).getStringPropertyValue("svn:mime-type");
                this.getDiffCallback().fileChanged(string4, bl3 ? file : null, file3, sVNEntry.getRevision(), -1L, string5, string6, sVNProperties2, sVNProperties, null);
            }
        }
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        SVNDepth sVNDepth = SVNDiffEditor$SVNDirectoryInfo.access$200(this.myCurrentDirectory);
        if (sVNDepth == SVNDepth.IMMEDIATES) {
            sVNDepth = SVNDepth.EMPTY;
        }
        this.myCurrentDirectory = this.createDirInfo(this.myCurrentDirectory, string, true, sVNDepth);
    }

    @Override
    public void openDir(String string, long l2) {
        SVNDepth sVNDepth = SVNDiffEditor$SVNDirectoryInfo.access$200(this.myCurrentDirectory);
        if (sVNDepth == SVNDepth.IMMEDIATES) {
            sVNDepth = SVNDepth.EMPTY;
        }
        this.myCurrentDirectory = this.createDirInfo(this.myCurrentDirectory, string, false, sVNDepth);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (SVNDiffEditor$SVNDirectoryInfo.access$300(this.myCurrentDirectory) == null) {
            SVNDiffEditor$SVNDirectoryInfo.access$302(this.myCurrentDirectory, new SVNProperties());
        }
        SVNDiffEditor$SVNDirectoryInfo.access$300(this.myCurrentDirectory).put(string, sVNPropertyValue);
    }

    @Override
    public void closeDir() {
        Object object;
        SVNProperties sVNProperties = SVNDiffEditor$SVNDirectoryInfo.access$300(this.myCurrentDirectory);
        if (sVNProperties != null && !sVNProperties.isEmpty()) {
            object = null;
            if (SVNDiffEditor$SVNDirectoryInfo.access$400(this.myCurrentDirectory)) {
                object = new SVNProperties();
            } else {
                SVNAdminArea sVNAdminArea = this.retrieve(SVNDiffEditor$SVNDirectoryInfo.access$100(this.myCurrentDirectory));
                if (sVNAdminArea != null && this.myIsCompareToBase) {
                    object = sVNAdminArea.getBaseProperties(sVNAdminArea.getThisDirName()).asMap();
                } else {
                    object = sVNAdminArea.getProperties(sVNAdminArea.getThisDirName()).asMap();
                    SVNProperties sVNProperties2 = sVNAdminArea.getBaseProperties(sVNAdminArea.getThisDirName()).asMap();
                    SVNProperties sVNProperties3 = this.applyPropChanges(sVNProperties2, SVNDiffEditor$SVNDirectoryInfo.access$300(this.myCurrentDirectory));
                    sVNProperties = SVNDiffEditor.computePropsDiff((SVNProperties)object, sVNProperties3);
                }
            }
            if (!this.myIsReverseDiff) {
                SVNDiffEditor.reversePropChanges((SVNProperties)object, sVNProperties);
            }
            this.getDiffCallback().propertiesChanged(SVNDiffEditor$SVNDirectoryInfo.access$100(this.myCurrentDirectory), (SVNProperties)object, sVNProperties, null);
            SVNDiffEditor$SVNDirectoryInfo.access$000(this.myCurrentDirectory).add("");
        }
        if (!SVNDiffEditor$SVNDirectoryInfo.access$400(this.myCurrentDirectory)) {
            this.localDirectoryDiff(this.myCurrentDirectory);
        }
        object = SVNPathUtil.tail(SVNDiffEditor$SVNDirectoryInfo.access$100(this.myCurrentDirectory));
        this.myCurrentDirectory = SVNDiffEditor$SVNDirectoryInfo.access$500(this.myCurrentDirectory);
        if (this.myCurrentDirectory != null) {
            SVNDiffEditor$SVNDirectoryInfo.access$000(this.myCurrentDirectory).add(object);
        }
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        String string3 = SVNPathUtil.tail(string);
        this.myCurrentFile = this.createFileInfo(this.myCurrentDirectory, string, true);
        SVNDiffEditor$SVNDirectoryInfo.access$000(this.myCurrentDirectory).add(string3);
    }

    @Override
    public void openFile(String string, long l2) {
        String string2 = SVNPathUtil.tail(string);
        this.myCurrentFile = this.createFileInfo(this.myCurrentDirectory, string, false);
        SVNDiffEditor$SVNDirectoryInfo.access$000(this.myCurrentDirectory).add(string2);
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile) == null) {
            SVNDiffEditor$SVNFileInfo.access$602(this.myCurrentFile, new SVNProperties());
        }
        SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile).put(string2, sVNPropertyValue);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        SVNEntry sVNEntry = this.myWCAccess.getEntry(this.myAdminInfo.getAnchor().getFile(SVNDiffEditor$SVNFileInfo.access$700(this.myCurrentFile)), false);
        if (sVNEntry != null && sVNEntry.isCopied()) {
            SVNDiffEditor$SVNFileInfo.access$802(this.myCurrentFile, false);
        }
        if (!SVNDiffEditor$SVNFileInfo.access$800(this.myCurrentFile)) {
            SVNAdminArea sVNAdminArea = this.retrieve(SVNDiffEditor$SVNDirectoryInfo.access$100(this.myCurrentDirectory));
            String string3 = SVNPathUtil.tail(SVNDiffEditor$SVNFileInfo.access$700(this.myCurrentFile));
            SVNDiffEditor$SVNFileInfo.access$902(this.myCurrentFile, sVNAdminArea.getBaseFile(string3, false));
        }
        SVNDiffEditor$SVNFileInfo.access$1002(this.myCurrentFile, this.createTempFile());
        this.myDeltaProcessor.applyTextDelta(SVNDiffEditor$SVNFileInfo.access$900(this.myCurrentFile), SVNDiffEditor$SVNFileInfo.access$1000(this.myCurrentFile), false);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        return this.myDeltaProcessor.textDeltaChunk(sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        this.myDeltaProcessor.textDeltaEnd();
    }

    @Override
    public void closeFile(String string, String string2) {
        boolean bl2;
        String string3 = SVNPathUtil.tail(SVNDiffEditor$SVNFileInfo.access$700(this.myCurrentFile));
        File file = this.myAdminInfo.getAnchor().getFile(SVNDiffEditor$SVNFileInfo.access$700(this.myCurrentFile));
        SVNAdminArea sVNAdminArea = this.myWCAccess.probeRetrieve(file);
        SVNEntry sVNEntry = this.myWCAccess.getEntry(file, false);
        SVNProperties sVNProperties = null;
        sVNProperties = SVNDiffEditor$SVNFileInfo.access$800(this.myCurrentFile) ? new SVNProperties() : (sVNAdminArea != null ? sVNAdminArea.getBaseProperties(string3).asMap() : new SVNProperties());
        SVNProperties sVNProperties2 = this.applyPropChanges(sVNProperties, SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile));
        String string4 = sVNProperties2.getStringValue("svn:mime-type");
        File file2 = SVNDiffEditor$SVNFileInfo.access$1000(this.myCurrentFile);
        File file3 = null;
        if (file2 == null) {
            file2 = sVNAdminArea.getBaseFile(string3, false);
        }
        if (SVNDiffEditor$SVNFileInfo.access$800(this.myCurrentFile) || !this.myIsCompareToBase && sVNEntry.isScheduledForDeletion()) {
            if (this.myIsReverseDiff) {
                this.getDiffCallback().fileAdded(string, null, file2, 0L, this.myTargetRevision, null, string4, null, SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile), null);
            } else {
                this.getDiffCallback().fileDeleted(string, file2, null, string4, null, sVNProperties2, null);
            }
            return;
        }
        boolean bl3 = bl2 = SVNDiffEditor$SVNFileInfo.access$1000(this.myCurrentFile) != null;
        if (!bl2 && !this.myIsCompareToBase) {
            bl2 = sVNAdminArea.hasTextModifications(string3, false);
        }
        if (bl2) {
            file3 = this.myIsCompareToBase ? sVNAdminArea.getBaseFile(string3, false) : this.detranslateFile(sVNAdminArea, string3);
        } else {
            file3 = null;
            file2 = null;
        }
        SVNProperties sVNProperties3 = null;
        if (this.myIsCompareToBase) {
            sVNProperties3 = sVNProperties;
        } else {
            sVNProperties3 = sVNAdminArea.getProperties(string3).asMap();
            SVNDiffEditor$SVNFileInfo.access$602(this.myCurrentFile, SVNDiffEditor.computePropsDiff(sVNProperties3, sVNProperties2));
        }
        if (file3 != null || SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile) != null && !SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile).isEmpty()) {
            String string5 = sVNProperties3.getStringValue("svn:mime-type");
            if (SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile) != null && !SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile).isEmpty() && !this.myIsReverseDiff) {
                SVNDiffEditor.reversePropChanges(sVNProperties3, SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile));
            }
            if (file3 != null || file2 != null || SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile) != null && !SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile).isEmpty()) {
                this.getDiffCallback().fileChanged(string, this.myIsReverseDiff ? file3 : file2, this.myIsReverseDiff ? file2 : file3, this.myIsReverseDiff ? -1L : this.myTargetRevision, this.myIsReverseDiff ? this.myTargetRevision : -1L, this.myIsReverseDiff ? string5 : string4, this.myIsReverseDiff ? string4 : string5, sVNProperties3, SVNDiffEditor$SVNFileInfo.access$600(this.myCurrentFile), null);
            }
        }
    }

    @Override
    public SVNCommitInfo closeEdit() {
        if (!this.myIsRootOpen) {
            this.localDirectoryDiff(this.createDirInfo(null, "", false, this.myDepth));
        }
        return null;
    }

    @Override
    public void abortEdit() {
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    public void cleanup() {
        if (this.myTempDirectory != null) {
            SVNFileUtil.deleteAll(this.myTempDirectory, true);
        }
    }

    private SVNProperties applyPropChanges(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        SVNProperties sVNProperties3 = new SVNProperties(sVNProperties);
        if (sVNProperties2 != null) {
            for (String string : sVNProperties2.nameSet()) {
                SVNPropertyValue sVNPropertyValue = sVNProperties2.getSVNPropertyValue(string);
                if (sVNPropertyValue == null) {
                    sVNProperties3.remove(string);
                    continue;
                }
                sVNProperties3.put(string, sVNPropertyValue);
            }
        }
        return sVNProperties3;
    }

    private void localDirectoryDiff(SVNDiffEditor$SVNDirectoryInfo sVNDiffEditor$SVNDirectoryInfo) {
        Object object;
        Object object2;
        if (this.myIsCompareToBase) {
            return;
        }
        SVNAdminArea sVNAdminArea = this.retrieve(SVNDiffEditor$SVNDirectoryInfo.access$100(sVNDiffEditor$SVNDirectoryInfo));
        boolean bl2 = !"".equals(this.myAdminInfo.getTargetName()) && sVNAdminArea == this.myAdminInfo.getAnchor();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
        if (SVNWCAccess.matchesChangeList(this.myChangeLists, sVNEntry) && !bl2 && !SVNDiffEditor$SVNDirectoryInfo.access$000(sVNDiffEditor$SVNDirectoryInfo).contains("") && sVNAdminArea.hasPropModifications(sVNAdminArea.getThisDirName())) {
            object2 = sVNAdminArea.getBaseProperties(sVNAdminArea.getThisDirName());
            object = ((SVNVersionedProperties)object2).compareTo(sVNAdminArea.getProperties(sVNAdminArea.getThisDirName())).asMap();
            this.getDiffCallback().propertiesChanged(SVNDiffEditor$SVNDirectoryInfo.access$100(sVNDiffEditor$SVNDirectoryInfo), ((SVNVersionedProperties)object2).asMap(), (SVNProperties)object, null);
        }
        if (SVNDiffEditor$SVNDirectoryInfo.access$200(sVNDiffEditor$SVNDirectoryInfo) == SVNDepth.EMPTY && !bl2) {
            return;
        }
        object2 = null;
        if (this.getDiffCallback().isDiffUnversioned()) {
            object2 = new SVNHashSet();
        }
        object = sVNAdminArea.entries(false);
        while (object.hasNext()) {
            SVNEntry sVNEntry2 = (SVNEntry)object.next();
            if (object2 != null && !sVNAdminArea.getThisDirName().equals(sVNEntry2.getName())) {
                object2.add(sVNEntry2.getName());
            }
            if (bl2 && !this.myAdminInfo.getTargetName().equals(sVNEntry2.getName()) || sVNAdminArea.getThisDirName().equals(sVNEntry2.getName()) || SVNDiffEditor$SVNDirectoryInfo.access$000(sVNDiffEditor$SVNDirectoryInfo).contains(sVNEntry2.getName())) continue;
            SVNDiffEditor$SVNDirectoryInfo.access$000(sVNDiffEditor$SVNDirectoryInfo).add(sVNEntry2.getName());
            if (sVNEntry2.isFile()) {
                this.reportModifiedFile(sVNDiffEditor$SVNDirectoryInfo, sVNEntry2);
                continue;
            }
            if (!sVNEntry2.isDirectory() || !bl2 && SVNDiffEditor$SVNDirectoryInfo.access$200(sVNDiffEditor$SVNDirectoryInfo).compareTo(SVNDepth.FILES) <= 0 && SVNDiffEditor$SVNDirectoryInfo.access$200(sVNDiffEditor$SVNDirectoryInfo) != SVNDepth.UNKNOWN) continue;
            SVNDepth sVNDepth = SVNDiffEditor$SVNDirectoryInfo.access$200(sVNDiffEditor$SVNDirectoryInfo);
            if (sVNDepth == SVNDepth.IMMEDIATES) {
                sVNDepth = SVNDepth.EMPTY;
            }
            SVNDiffEditor$SVNDirectoryInfo sVNDiffEditor$SVNDirectoryInfo2 = this.createDirInfo(sVNDiffEditor$SVNDirectoryInfo, SVNPathUtil.append(SVNDiffEditor$SVNDirectoryInfo.access$100(sVNDiffEditor$SVNDirectoryInfo), sVNEntry2.getName()), false, sVNDepth);
            this.localDirectoryDiff(sVNDiffEditor$SVNDirectoryInfo2);
        }
        if (this.getDiffCallback().isDiffUnversioned()) {
            object = sVNAdminArea.getRelativePath(this.myAdminInfo.getAnchor());
            this.diffUnversioned(sVNAdminArea.getRoot(), sVNAdminArea, (String)object, bl2, (Set)object2);
        }
    }

    private void diffUnversioned(File file, SVNAdminArea sVNAdminArea, String string, boolean bl2, Set set) {
        File[] fileArray = SVNFileListUtil.listFiles(file);
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            String string2;
            Collection collection;
            Object object;
            File file2 = fileArray[i2];
            if (SVNFileUtil.getAdminDirectoryName().equals(file2.getName()) || set != null && set.contains(file2.getName()) || bl2 && !this.myAdminInfo.getTargetName().equals(file2.getName())) continue;
            if (sVNAdminArea != null) {
                object = SVNStatusEditor.getGlobalIgnores(this.myWCAccess.getOptions());
                collection = SVNStatusEditor.getIgnorePatterns(sVNAdminArea, (Collection)object);
                string2 = null;
                boolean bl3 = false;
                for (String string3 : collection) {
                    if (!string3.startsWith("/")) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    if (this.myWCRootPath == null) {
                        File file3 = SVNWCUtil.getWorkingCopyRoot(sVNAdminArea.getRoot(), true);
                        this.myWCRootPath = file3.getAbsolutePath().replace(File.separatorChar, '/');
                    }
                    if (this.myWCRootPath != null) {
                        string2 = file2.getAbsolutePath().replace(File.separatorChar, '/');
                        if ((string2 = SVNPathUtil.getPathAsChild(this.myWCRootPath, string2)) != null && !string2.startsWith("/")) {
                            string2 = "/" + string2;
                        }
                    }
                }
                if (SVNStatusEditor.isIgnored(collection, file2, string2)) continue;
            }
            if ((object = SVNFileType.getType(file2)) == SVNFileType.DIRECTORY) {
                this.diffUnversioned(file2, null, SVNPathUtil.append(string, file2.getName()), false, null);
                continue;
            }
            if (object != SVNFileType.FILE && object != SVNFileType.SYMLINK) continue;
            collection = null;
            string2 = SVNFileUtil.detectMimeType(file2, null);
            String string4 = SVNPathUtil.append(string, file2.getName());
            this.getDiffCallback().fileAdded(string4, null, file2, 0L, 0L, (String)((Object)collection), string2, null, null, null);
        }
    }

    private SVNDiffEditor$SVNDirectoryInfo createDirInfo(SVNDiffEditor$SVNDirectoryInfo sVNDiffEditor$SVNDirectoryInfo, String string, boolean bl2, SVNDepth sVNDepth) {
        SVNDiffEditor$SVNDirectoryInfo sVNDiffEditor$SVNDirectoryInfo2 = new SVNDiffEditor$SVNDirectoryInfo();
        SVNDiffEditor$SVNDirectoryInfo.access$502(sVNDiffEditor$SVNDirectoryInfo2, sVNDiffEditor$SVNDirectoryInfo);
        SVNDiffEditor$SVNDirectoryInfo.access$102(sVNDiffEditor$SVNDirectoryInfo2, string);
        SVNDiffEditor$SVNDirectoryInfo.access$402(sVNDiffEditor$SVNDirectoryInfo2, bl2);
        SVNDiffEditor$SVNDirectoryInfo.access$202(sVNDiffEditor$SVNDirectoryInfo2, sVNDepth);
        return sVNDiffEditor$SVNDirectoryInfo2;
    }

    private SVNDiffEditor$SVNFileInfo createFileInfo(SVNDiffEditor$SVNDirectoryInfo sVNDiffEditor$SVNDirectoryInfo, String string, boolean bl2) {
        SVNDiffEditor$SVNFileInfo sVNDiffEditor$SVNFileInfo = new SVNDiffEditor$SVNFileInfo(null);
        SVNDiffEditor$SVNFileInfo.access$702(sVNDiffEditor$SVNFileInfo, string);
        SVNDiffEditor$SVNFileInfo.access$802(sVNDiffEditor$SVNFileInfo, bl2);
        if (SVNDiffEditor$SVNDirectoryInfo.access$400(sVNDiffEditor$SVNDirectoryInfo)) {
            while (SVNDiffEditor$SVNDirectoryInfo.access$400(sVNDiffEditor$SVNDirectoryInfo)) {
                sVNDiffEditor$SVNDirectoryInfo = SVNDiffEditor$SVNDirectoryInfo.access$500(sVNDiffEditor$SVNDirectoryInfo);
            }
            SVNDiffEditor$SVNFileInfo.access$702(sVNDiffEditor$SVNFileInfo, SVNPathUtil.append(SVNDiffEditor$SVNDirectoryInfo.access$100(sVNDiffEditor$SVNDirectoryInfo), "fake"));
        }
        return sVNDiffEditor$SVNFileInfo;
    }

    private File detranslateFile(SVNAdminArea sVNAdminArea, String string) {
        boolean bl2;
        SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getProperties(string);
        String string2 = sVNVersionedProperties.getStringPropertyValue("svn:keywords");
        String string3 = sVNVersionedProperties.getStringPropertyValue("svn:eol-style");
        String string4 = sVNVersionedProperties.getStringPropertyValue("svnkit:charset");
        String string5 = sVNVersionedProperties.getStringPropertyValue("svn:mime-type");
        ISVNOptions iSVNOptions = sVNAdminArea.getWCAccess().getOptions();
        String string6 = SVNTranslator.getCharset(string4, string5, sVNAdminArea.getFile(string).getPath(), iSVNOptions);
        boolean bl3 = bl2 = sVNVersionedProperties.getPropertyValue("svn:special") != null;
        if (!(string6 != null || string2 != null || string3 != null || bl2 && SVNFileUtil.symlinksSupported())) {
            return sVNAdminArea.getFile(string);
        }
        byte[] byArray = SVNTranslator.getEOL(string3, iSVNOptions);
        File file = this.createTempFile();
        Map map = SVNTranslator.computeKeywords(string2, null, null, null, null, null, null);
        SVNTranslator.translate(sVNAdminArea.getFile(string), file, string6, byArray, map, bl2, false);
        return file;
    }

    private File createTempFile() {
        File file = null;
        try {
            return File.createTempFile("diff.", ".tmp", this.getTempDirectory());
        }
        catch (IOException iOException) {
            SVNFileUtil.deleteFile(file);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            return null;
        }
    }

    private File getTempDirectory() {
        if (this.myTempDirectory == null) {
            this.myTempDirectory = this.getDiffCallback().createTempDirectory();
        }
        return this.myTempDirectory;
    }

    private SVNAdminArea retrieve(String string) {
        File file = this.myAdminInfo.getAnchor().getFile(string);
        return this.myWCAccess.retrieve(file);
    }

    private AbstractDiffCallback getDiffCallback() {
        return this.myDiffCallback;
    }

    private static void reversePropChanges(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        ArrayList arrayList = new ArrayList(sVNProperties2.nameSet());
        for (String string : arrayList) {
            SVNPropertyValue sVNPropertyValue = sVNProperties2.getSVNPropertyValue(string);
            SVNPropertyValue sVNPropertyValue2 = sVNProperties.getSVNPropertyValue(string);
            if (sVNPropertyValue2 == null && sVNPropertyValue != null) {
                sVNProperties.put(string, sVNPropertyValue);
                sVNProperties2.put(string, (SVNPropertyValue)null);
                continue;
            }
            if (sVNPropertyValue2 != null && sVNPropertyValue == null) {
                sVNProperties.put(string, (SVNPropertyValue)null);
                sVNProperties2.put(string, sVNPropertyValue2);
                continue;
            }
            if (sVNPropertyValue2 == null || sVNPropertyValue == null) continue;
            sVNProperties.put(string, sVNPropertyValue);
            sVNProperties2.put(string, sVNPropertyValue2);
        }
    }

    private static SVNProperties computePropsDiff(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        SVNProperties sVNProperties3 = new SVNProperties();
        for (String string : sVNProperties2.nameSet()) {
            if (sVNProperties.containsName(string)) {
                SVNPropertyValue sVNPropertyValue = sVNProperties2.getSVNPropertyValue(string);
                SVNPropertyValue sVNPropertyValue2 = sVNProperties.getSVNPropertyValue(string);
                if (sVNPropertyValue != null && !sVNPropertyValue.equals(sVNPropertyValue2)) {
                    sVNProperties3.put(string, sVNPropertyValue);
                    continue;
                }
                if (sVNPropertyValue != null || sVNPropertyValue2 == null) continue;
                sVNProperties3.put(string, sVNPropertyValue);
                continue;
            }
            sVNProperties3.put(string, sVNProperties2.getSVNPropertyValue(string));
        }
        for (String string : sVNProperties.nameSet()) {
            if (sVNProperties2.containsName(string)) continue;
            sVNProperties3.put(string, (String)null);
        }
        return sVNProperties3;
    }
}

