/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNCharsetOutputStream;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnPropertiesDiffHandler;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDiffCallback
extends AbstractDiffCallback {
    private ISVNDiffGenerator myGenerator;
    private OutputStream myResult;
    private long myRevision2;
    private long myRevision1;
    private static final SVNStatusType[] EMPTY_STATUS = new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};

    public SVNDiffCallback(SVNAdminArea sVNAdminArea, ISVNDiffGenerator iSVNDiffGenerator, long l2, long l3, OutputStream outputStream) {
        super(sVNAdminArea);
        this.myGenerator = iSVNDiffGenerator;
        this.myResult = outputStream;
        this.myRevision1 = l2;
        this.myRevision2 = l3;
    }

    @Override
    public File createTempDirectory() {
        return this.myGenerator.createTempDirectory();
    }

    @Override
    public boolean isDiffUnversioned() {
        return this.myGenerator.isDiffUnversioned();
    }

    @Override
    public boolean isDiffCopiedAsAdded() {
        return this.myGenerator.isDiffCopied();
    }

    @Override
    public SVNStatusType directoryAdded(String string, long l2, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        this.myGenerator.displayAddedDirectory(this.getDisplayPath(string), this.getRevision(this.myRevision1), this.getRevision(l2));
        return SVNStatusType.UNKNOWN;
    }

    public SVNStatusType directoryDeleted(String string) {
        this.myGenerator.displayDeletedDirectory(this.getDisplayPath(string), this.getRevision(this.myRevision1), this.getRevision(this.myRevision2));
        return SVNStatusType.UNKNOWN;
    }

    @Override
    public SVNStatusType[] fileAdded(String string, File file, File file2, long l2, long l3, String string2, String string3, SVNProperties sVNProperties, SVNProperties sVNProperties2, boolean[] blArray) {
        if (!this.myGenerator.isDiffAdded()) {
            return EMPTY_STATUS;
        }
        if (file2 != null) {
            this.displayFileDiff(string, null, file2, l2, l3, string2, string3, sVNProperties, sVNProperties2);
        }
        if (sVNProperties2 != null && !sVNProperties2.isEmpty()) {
            this.propertiesChanged(string, sVNProperties, sVNProperties2, null);
        }
        return EMPTY_STATUS;
    }

    @Override
    public SVNStatusType[] fileChanged(String string, File file, File file2, long l2, long l3, String string2, String string3, SVNProperties sVNProperties, SVNProperties sVNProperties2, boolean[] blArray) {
        if (file != null) {
            this.displayFileDiff(string, file, file2, l2, l3, string2, string3, sVNProperties, sVNProperties2);
        }
        if (sVNProperties2 != null && !sVNProperties2.isEmpty()) {
            this.propertiesChanged(string, sVNProperties, sVNProperties2, null);
        }
        return EMPTY_STATUS;
    }

    @Override
    public SVNStatusType fileDeleted(String string, File file, File file2, String string2, String string3, SVNProperties sVNProperties, boolean[] blArray) {
        if (!this.myGenerator.isDiffDeleted()) {
            return SVNStatusType.UNKNOWN;
        }
        if (file != null) {
            this.displayFileDiff(string, file, file2, this.myRevision1, this.myRevision2, string2, string3, sVNProperties, null);
        }
        return SVNStatusType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayFileDiff(String string, File file, File file2, long l2, long l3, String string2, String string3, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        boolean bl2 = false;
        OutputStream outputStream = this.myResult;
        String string4 = this.defineEncoding(sVNProperties, sVNProperties2);
        if (string4 != null) {
            this.myGenerator.setEncoding(string4);
            bl2 = true;
        } else {
            String string5 = this.defineConversionEncoding(sVNProperties, sVNProperties2);
            if (string5 != null) {
                bl2 = this.adjustDiffGenerator("UTF-8");
                outputStream = new SVNCharsetOutputStream(outputStream, Charset.forName("UTF-8"), Charset.forName(string5), CodingErrorAction.IGNORE, CodingErrorAction.IGNORE);
            }
        }
        try {
            if (this.myGenerator instanceof ISvnPropertiesDiffHandler) {
                ((ISvnPropertiesDiffHandler)((Object)this.myGenerator)).handlePropertiesDiff(sVNProperties, sVNProperties2);
            }
            this.myGenerator.displayFileDiff(this.getDisplayPath(string), file, file2, this.getRevision(l2), this.getRevision(l3), string2, string3, outputStream);
        }
        finally {
            if (bl2) {
                this.myGenerator.setEncoding(null);
                this.myGenerator.setEOL(null);
            }
            if (outputStream instanceof SVNCharsetOutputStream) {
                try {
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException), iOException, SVNLogType.WC);
                }
            }
        }
    }

    private boolean adjustDiffGenerator(String string) {
        if (this.myGenerator instanceof DefaultSVNDiffGenerator) {
            DefaultSVNDiffGenerator defaultSVNDiffGenerator = (DefaultSVNDiffGenerator)this.myGenerator;
            boolean bl2 = false;
            if (!defaultSVNDiffGenerator.hasEncoding()) {
                defaultSVNDiffGenerator.setEncoding(string);
                bl2 = true;
            }
            if (!defaultSVNDiffGenerator.hasEOL()) {
                byte[] byArray;
                String string2 = System.getProperty("line.separator");
                try {
                    byArray = string2.getBytes(string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = string2.getBytes();
                }
                defaultSVNDiffGenerator.setEOL(byArray);
            }
            return bl2;
        }
        return false;
    }

    @Override
    public SVNStatusType propertiesChanged(String string, SVNProperties sVNProperties, SVNProperties sVNProperties2, boolean[] blArray) {
        sVNProperties = sVNProperties == null ? new SVNProperties() : sVNProperties;
        sVNProperties2 = sVNProperties2 == null ? new SVNProperties() : sVNProperties2;
        SVNProperties sVNProperties3 = new SVNProperties();
        this.categorizeProperties(sVNProperties2, sVNProperties3, null, null);
        if (sVNProperties3.isEmpty()) {
            return SVNStatusType.UNKNOWN;
        }
        this.myGenerator.displayPropDiff(this.getDisplayPath(string), sVNProperties, sVNProperties3, this.myResult);
        return SVNStatusType.UNKNOWN;
    }

    private String getRevision(long l2) {
        if (l2 >= 0L) {
            return "(revision " + l2 + ")";
        }
        return "(working copy)";
    }

    private String defineEncoding(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        if (this.myGenerator instanceof DefaultSVNDiffGenerator) {
            DefaultSVNDiffGenerator defaultSVNDiffGenerator = (DefaultSVNDiffGenerator)this.myGenerator;
            if (defaultSVNDiffGenerator.hasEncoding()) {
                return null;
            }
            String string = this.getCharsetByMimeType(sVNProperties, defaultSVNDiffGenerator);
            if (string != null) {
                return string;
            }
            String string2 = this.getCharsetByMimeType(sVNProperties2, defaultSVNDiffGenerator);
            if (string2 != null) {
                return string2;
            }
        }
        return null;
    }

    private String defineConversionEncoding(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        if (this.myGenerator instanceof DefaultSVNDiffGenerator) {
            DefaultSVNDiffGenerator defaultSVNDiffGenerator = (DefaultSVNDiffGenerator)this.myGenerator;
            if (defaultSVNDiffGenerator.hasEncoding()) {
                return null;
            }
            String string = this.getCharset(sVNProperties, defaultSVNDiffGenerator);
            if (string != null) {
                return string;
            }
            String string2 = this.getCharset(sVNProperties2, defaultSVNDiffGenerator);
            if (string2 != null) {
                return string2;
            }
            String string3 = this.getCharset(defaultSVNDiffGenerator.getGlobalEncoding(), defaultSVNDiffGenerator, false);
            if (string3 != null) {
                return string3;
            }
        }
        return null;
    }

    private String getCharsetByMimeType(SVNProperties sVNProperties, DefaultSVNDiffGenerator defaultSVNDiffGenerator) {
        if (sVNProperties == null) {
            return null;
        }
        String string = sVNProperties.getStringValue("svn:mime-type");
        String string2 = SVNPropertiesManager.determineEncodingByMimeType(string);
        return this.getCharset(string2, defaultSVNDiffGenerator, false);
    }

    private String getCharset(SVNProperties sVNProperties, DefaultSVNDiffGenerator defaultSVNDiffGenerator) {
        if (sVNProperties == null) {
            return null;
        }
        String string = sVNProperties.getStringValue("svnkit:charset");
        return this.getCharset(string, defaultSVNDiffGenerator, true);
    }

    private String getCharset(String string, DefaultSVNDiffGenerator defaultSVNDiffGenerator, boolean bl2) {
        if (string == null) {
            return null;
        }
        if (bl2 && "native".equals(string)) {
            return defaultSVNDiffGenerator.getEncoding();
        }
        if (Charset.isSupported(string)) {
            return string;
        }
        return null;
    }

    @Override
    public SVNStatusType directoryDeleted(String string, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        return this.directoryDeleted(string);
    }

    @Override
    public void directoryOpened(String string, long l2, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
    }

    @Override
    public SVNStatusType[] directoryClosed(String string, boolean[] blArray) {
        this.setIsConflicted(blArray, false);
        return EMPTY_STATUS;
    }
}

