/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNConfigFile {
    private File myFile;
    private String[] myLines;
    private long myLastModified;

    public SVNConfigFile(File file) {
        this.myFile = file.getAbsoluteFile();
    }

    protected String[] getLines() {
        return this.myLines;
    }

    public Set getGroupNames() {
        HashSet<String> hashSet = new HashSet<String>();
        this.load();
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.myLines.length; ++i2) {
            String string = this.myLines[i2];
            if (string == null || !SVNConfigFile.matchGroup(string, null)) continue;
            hashSet.add(string.trim().substring("[".length(), string.length() - "]".length()).trim());
        }
        return hashSet;
    }

    public Map getProperties(String string) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.load();
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.myLines.length; ++i2) {
            String string2 = this.myLines[i2];
            if (string2 == null) continue;
            if (!bl2 && SVNConfigFile.matchGroup(string2, string)) {
                bl2 = true;
                continue;
            }
            if (!bl2) continue;
            if (SVNConfigFile.matchGroup(string2, null)) break;
            if (!SVNConfigFile.matchProperty(string2, null)) continue;
            linkedHashMap.put(SVNConfigFile.getPropertyName(string2), null);
        }
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        for (String string3 : linkedHashMap.keySet()) {
            linkedHashMap2.put(string3, this.getPropertyValue(string, string3));
        }
        return linkedHashMap2;
    }

    public String getPropertyValue(String string, String string2) {
        this.load();
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.myLines.length; ++i2) {
            String string3 = this.myLines[i2];
            if (string3 == null) continue;
            if (!bl2 && SVNConfigFile.matchGroup(string3, string)) {
                bl2 = true;
                continue;
            }
            if (!bl2) continue;
            if (SVNConfigFile.matchGroup(string3, null)) {
                return null;
            }
            if (!SVNConfigFile.matchProperty(string3, string2)) continue;
            String string4 = SVNConfigFile.getPropertyValue(string3);
            if (string4 != null) {
                String string5;
                int n2 = i2 + 1;
                while (n2 < this.myLines.length && this.myLines[n2] != null && !SVNConfigFile.matchGroup(string5 = this.myLines[n2++], null) && !SVNConfigFile.matchProperty(string5, null) && string5.length() > 0 && Character.isWhitespace(string5.charAt(0))) {
                    string4 = string4 + string5;
                }
            }
            return string4;
        }
        return null;
    }

    public void setPropertyValue(String string, String string2, String string3, boolean bl2) {
        this.load();
        boolean bl3 = false;
        for (int i2 = 0; i2 < this.myLines.length; ++i2) {
            String string4 = this.myLines[i2];
            if (string4 == null) continue;
            if (!bl3 && SVNConfigFile.matchGroup(string4, string)) {
                bl3 = true;
                continue;
            }
            if (!bl3) continue;
            if (SVNConfigFile.matchGroup(string4, null)) {
                if (string3 != null) {
                    String[] stringArray = new String[this.myLines.length + 1];
                    System.arraycopy(this.myLines, 0, stringArray, 0, i2);
                    System.arraycopy(this.myLines, i2, stringArray, i2 + 1, this.myLines.length - i2);
                    stringArray[i2] = string2 + "  = " + string3;
                    this.myLines = stringArray;
                    if (bl2) {
                        this.save();
                    }
                }
                return;
            }
            if (!SVNConfigFile.matchProperty(string4, string2)) continue;
            this.myLines[i2] = string3 == null ? null : string2 + " = " + string3;
            if (bl2) {
                this.save();
            }
            return;
        }
        if (string3 != null) {
            String[] stringArray = new String[this.myLines.length + (bl3 ? 1 : 2)];
            if (!bl3) {
                stringArray[stringArray.length - 2] = "[" + string + "]";
            }
            stringArray[stringArray.length - 1] = string2 + "  = " + string3;
            System.arraycopy(this.myLines, 0, stringArray, 0, this.myLines.length);
            this.myLines = stringArray;
            if (bl2) {
                this.save();
            }
        }
    }

    public void deleteGroup(String string, boolean bl2) {
        this.load();
        boolean bl3 = false;
        for (int i2 = 0; i2 < this.myLines.length; ++i2) {
            String string2 = this.myLines[i2];
            if (string2 == null) continue;
            if (!bl3 && SVNConfigFile.matchGroup(string2, string)) {
                bl3 = true;
                this.myLines[i2] = null;
                continue;
            }
            if (!bl3) continue;
            if (SVNConfigFile.matchGroup(string2, null)) break;
            this.myLines[i2] = null;
        }
        if (bl2) {
            this.save();
        }
    }

    private static boolean matchGroup(String string, String string2) {
        if ((string = string.trim()).startsWith("[") && string.endsWith("]")) {
            return string2 == null || string.substring(1, string.length() - 1).equals(string2);
        }
        return false;
    }

    private static boolean matchProperty(String string, String string2) {
        if ((string = string.trim()).startsWith("#")) {
            return false;
        }
        if (string.indexOf(61) < 0) {
            return false;
        }
        string = string.substring(0, string.indexOf(61));
        return string2 == null || string.trim().equals(string2);
    }

    private static String getPropertyValue(String string) {
        if ((string = string.trim()).indexOf(61) < 0) {
            return null;
        }
        string = string.substring(string.indexOf(61) + 1);
        return string.trim();
    }

    private static String getPropertyName(String string) {
        if ((string = string.trim()).indexOf(61) < 0) {
            return null;
        }
        string = string.substring(0, string.indexOf(61));
        return string.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (this.myLines == null) {
            return;
        }
        if (this.myFile.isDirectory()) {
            return;
        }
        if (this.myFile.getParentFile() != null) {
            this.myFile.getParentFile().mkdirs();
        }
        FileWriter fileWriter = null;
        String string = System.getProperty("line.separator");
        string = string == null ? "\n" : string;
        try {
            fileWriter = new FileWriter(this.myFile);
            for (int i2 = 0; i2 < this.myLines.length; ++i2) {
                String string2 = this.myLines[i2];
                if (string2 == null) continue;
                fileWriter.write(string2);
                fileWriter.write(string);
            }
        }
        catch (IOException iOException) {
            SVNFileUtil.closeFile(fileWriter);
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(fileWriter);
            throw throwable;
        }
        SVNFileUtil.closeFile(fileWriter);
        this.myLastModified = this.myFile.lastModified();
        this.myLines = this.doLoad(this.myFile);
    }

    private void load() {
        if (this.myLines != null && this.myFile.lastModified() == this.myLastModified) {
            return;
        }
        this.myLastModified = this.myFile.lastModified();
        this.myLines = this.doLoad(this.myFile);
        this.myLastModified = this.myFile.lastModified();
    }

    public boolean isModified() {
        if (this.myLines == null) {
            return false;
        }
        String[] stringArray = this.doLoad(this.myFile);
        if (stringArray.length != this.myLines.length) {
            return true;
        }
        for (int i2 = 0; i2 < this.myLines.length; ++i2) {
            String string = this.myLines[i2];
            if (string == null) {
                return true;
            }
            if (string.equals(stringArray[i2])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] doLoad(File file) {
        if (!file.isFile() || !file.canRead()) {
            return new String[0];
        }
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(this.myFile));
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            SVNFileUtil.closeFile(bufferedReader);
        }
        catch (IOException iOException) {
            arrayList.clear();
        }
        finally {
            SVNFileUtil.closeFile(bufferedReader);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void createDefaultConfiguration(File file) {
        if (!file.isDirectory() && !file.mkdirs()) {
            return;
        }
        File file2 = new File(file, "config");
        File file3 = new File(file, "servers");
        File file4 = new File(file, "README.txt");
        SVNConfigFile.writeFile("/org/tmatesoft/svn/core/internal/wc/config", file2);
        SVNConfigFile.writeFile("/org/tmatesoft/svn/core/internal/wc/servers", file3);
        SVNConfigFile.writeFile("/org/tmatesoft/svn/core/internal/wc/README.txt", file4);
        File file5 = new File(file, "auth");
        File file6 = new File(file5, "svn.simple");
        File file7 = new File(file5, "svn.ssl.client-passphrase");
        File file8 = new File(file5, "svn.username");
        File file9 = new File(file5, "svn.ssl.server");
        file5.mkdir();
        file6.mkdir();
        file7.mkdir();
        file8.mkdir();
        file9.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void writeFile(String string, File file) {
        if (string == null || file == null || file.exists()) {
            return;
        }
        InputStream inputStream = SVNConfigFile.class.getResourceAsStream(string);
        if (inputStream == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = System.getProperty("line.separator", "\n");
        BufferedWriter bufferedWriter = null;
        try {
            String string3;
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(SVNFileUtil.openFileForWriting(file)));
            while ((string3 = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string3);
                bufferedWriter.write(string2);
            }
        }
        catch (IOException iOException) {
            SVNFileUtil.closeFile(bufferedWriter);
            SVNFileUtil.closeFile(bufferedReader);
        }
        catch (SVNException sVNException) {
            SVNFileUtil.closeFile(bufferedWriter);
            SVNFileUtil.closeFile(bufferedReader);
            {
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(bufferedWriter);
                    SVNFileUtil.closeFile(bufferedReader);
                    throw throwable;
                }
            }
        }
        SVNFileUtil.closeFile(bufferedWriter);
        SVNFileUtil.closeFile(bufferedReader);
    }
}

