/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCommitter$CopyingStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitter
implements ISVNCommitPathHandler {
    private Map myCommitItems;
    private Map myModifiedFiles;
    private Collection myTmpFiles;
    private String myRepositoryRoot;
    private SVNDeltaGenerator myDeltaGenerator;

    public SVNCommitter(Map map, String string, Collection collection) {
        this.myCommitItems = map;
        this.myModifiedFiles = new TreeMap();
        this.myTmpFiles = collection;
        this.myRepositoryRoot = string;
    }

    @Override
    public boolean handleCommitPath(String string, ISVNEditor iSVNEditor) {
        Object object;
        SVNCommitItem sVNCommitItem = (SVNCommitItem)this.myCommitItems.get(string);
        SVNWCAccess sVNWCAccess = sVNCommitItem.getWCAccess();
        sVNWCAccess.checkCancelled();
        if (sVNCommitItem.isCopied()) {
            if (sVNCommitItem.getCopyFromURL() == null) {
                object = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Commit item ''{0}'' has copy flag but no copyfrom URL", (Object)sVNCommitItem.getFile());
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            } else if (sVNCommitItem.getRevision().getNumber() < 0L) {
                object = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Commit item ''{0}'' has copy flag but an invalid revision", (Object)sVNCommitItem.getFile());
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
        }
        object = null;
        boolean bl2 = false;
        File file = null;
        if (sVNCommitItem.getFile() != null) {
            file = sVNCommitItem.getFile();
        } else if (sVNCommitItem.getPath() != null) {
            file = new File(sVNWCAccess.getAnchor(), sVNCommitItem.getPath());
        }
        long l2 = sVNCommitItem.getRevision().getNumber();
        if (sVNCommitItem.isAdded() && sVNCommitItem.isDeleted()) {
            object = SVNEventFactory.createSVNEvent(file, sVNCommitItem.getKind(), null, -1L, SVNEventAction.COMMIT_REPLACED, null, null, null);
            ((SVNEvent)object).setPreviousRevision(l2);
        } else if (sVNCommitItem.isAdded()) {
            String string2 = null;
            if (sVNCommitItem.getKind() == SVNNodeKind.FILE && file != null) {
                SVNAdminArea sVNAdminArea = sVNCommitItem.getWCAccess().retrieve(file.getParentFile());
                string2 = sVNAdminArea.getProperties(file.getName()).getStringPropertyValue("svn:mime-type");
            }
            object = SVNEventFactory.createSVNEvent(file, sVNCommitItem.getKind(), string2, -1L, SVNEventAction.COMMIT_ADDED, null, null, null);
            ((SVNEvent)object).setPreviousRevision(sVNCommitItem.getCopyFromRevision() != null ? sVNCommitItem.getCopyFromRevision().getNumber() : -1L);
            ((SVNEvent)object).setPreviousURL(sVNCommitItem.getCopyFromURL());
        } else if (sVNCommitItem.isDeleted()) {
            object = SVNEventFactory.createSVNEvent(file, sVNCommitItem.getKind(), null, -1L, SVNEventAction.COMMIT_DELETED, null, null, null);
            ((SVNEvent)object).setPreviousRevision(l2);
        } else if (sVNCommitItem.isContentsModified() || sVNCommitItem.isPropertiesModified()) {
            object = SVNEventFactory.createSVNEvent(file, sVNCommitItem.getKind(), null, -1L, SVNEventAction.COMMIT_MODIFIED, null, null, null);
            ((SVNEvent)object).setPreviousRevision(l2);
        }
        if (object != null) {
            ((SVNEvent)object).setURL(sVNCommitItem.getURL());
            sVNWCAccess.handleEvent((SVNEvent)object, -1.0);
        }
        long l3 = sVNCommitItem.getCopyFromRevision().getNumber();
        if (sVNCommitItem.isDeleted()) {
            try {
                iSVNEditor.deleteEntry(string, l2);
            }
            catch (SVNException sVNException) {
                this.fixError(string, sVNException, SVNNodeKind.FILE);
            }
        }
        boolean bl3 = false;
        Map map = sVNCommitItem.getOutgoingProperties();
        if (sVNCommitItem.isAdded()) {
            String string3 = this.getCopyFromPath(sVNCommitItem.getCopyFromURL());
            if (sVNCommitItem.getKind() == SVNNodeKind.FILE) {
                iSVNEditor.addFile(string, string3, l3);
                bl3 = true;
            } else {
                iSVNEditor.addDir(string, string3, l3);
                bl2 = true;
            }
            if (map != null) {
                for (Object object2 : map.keySet()) {
                    SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)map.get(object2);
                    if (sVNCommitItem.getKind() == SVNNodeKind.FILE) {
                        iSVNEditor.changeFileProperty(string, (String)object2, sVNPropertyValue);
                        continue;
                    }
                    iSVNEditor.changeDirProperty((String)object2, sVNPropertyValue);
                }
                map = null;
            }
        }
        if (sVNCommitItem.isPropertiesModified() || map != null && !map.isEmpty()) {
            if (sVNCommitItem.getKind() == SVNNodeKind.FILE) {
                if (!bl3) {
                    try {
                        iSVNEditor.openFile(string, l2);
                    }
                    catch (SVNException sVNException) {
                        this.fixError(string, sVNException, SVNNodeKind.FILE);
                    }
                }
                bl3 = true;
            } else if (!sVNCommitItem.isAdded()) {
                try {
                    if ("".equals(string)) {
                        iSVNEditor.openRoot(l2);
                    } else {
                        iSVNEditor.openDir(string, l2);
                    }
                }
                catch (SVNException sVNException) {
                    this.fixError(string, sVNException, SVNNodeKind.DIR);
                }
                bl2 = true;
            }
            if (sVNCommitItem.isPropertiesModified()) {
                try {
                    this.sendPropertiesDelta(string, sVNCommitItem, iSVNEditor);
                }
                catch (SVNException sVNException) {
                    this.fixError(string, sVNException, sVNCommitItem.getKind());
                }
            }
            if (map != null) {
                for (Object object3 : map.keySet()) {
                    Object object2;
                    object2 = (SVNPropertyValue)map.get(object3);
                    if (sVNCommitItem.getKind() == SVNNodeKind.FILE) {
                        iSVNEditor.changeFileProperty(string, (String)object3, (SVNPropertyValue)object2);
                        continue;
                    }
                    iSVNEditor.changeDirProperty((String)object3, (SVNPropertyValue)object2);
                }
            }
        }
        if (sVNCommitItem.isContentsModified() && sVNCommitItem.getKind() == SVNNodeKind.FILE) {
            if (!bl3) {
                try {
                    iSVNEditor.openFile(string, l2);
                }
                catch (SVNException sVNException) {
                    this.fixError(string, sVNException, SVNNodeKind.FILE);
                }
            }
            this.myModifiedFiles.put(string, sVNCommitItem);
        } else if (bl3) {
            iSVNEditor.closeFile(string, null);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTextDeltas(ISVNEditor iSVNEditor) {
        for (String string : this.myModifiedFiles.keySet()) {
            Object object;
            SVNCommitItem sVNCommitItem = (SVNCommitItem)this.myModifiedFiles.get(string);
            SVNWCAccess sVNWCAccess = sVNCommitItem.getWCAccess();
            sVNWCAccess.checkCancelled();
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(new File(sVNWCAccess.getAnchor(), sVNCommitItem.getPath()), SVNNodeKind.FILE, null, -1L, SVNEventAction.COMMIT_DELTA_SENT, null, null, null);
            sVNWCAccess.handleEvent(sVNEvent, -1.0);
            SVNAdminArea sVNAdminArea = sVNWCAccess.retrieve(sVNCommitItem.getFile().getParentFile());
            String string2 = SVNPathUtil.tail(sVNCommitItem.getPath());
            SVNEntry sVNEntry = sVNAdminArea.getEntry(string2, false);
            File file = sVNAdminArea.getBaseFile(string2, true);
            this.myTmpFiles.add(file);
            String string3 = null;
            String string4 = null;
            String string5 = null;
            SVNChecksumInputStream sVNChecksumInputStream = null;
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            OutputStream outputStream = null;
            File file2 = sVNAdminArea.getBaseFile(string2, false);
            SVNErrorMessage sVNErrorMessage = null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!sVNCommitItem.isAdded()) {
                bl3 = true;
                string3 = sVNEntry.getChecksum();
                if (string3 != null) {
                    bl2 = true;
                } else {
                    string3 = SVNFileUtil.computeChecksum(file2);
                }
            } else {
                inputStream = SVNFileUtil.DUMMY_IN;
            }
            iSVNEditor.applyTextDelta(string, string3);
            if (this.myDeltaGenerator == null) {
                this.myDeltaGenerator = new SVNDeltaGenerator();
            }
            try {
                InputStream inputStream3 = inputStream = bl3 ? SVNFileUtil.openFileForReading(file2, SVNLogType.WC) : inputStream;
                if (bl2) {
                    sVNChecksumInputStream = new SVNChecksumInputStream(inputStream, "MD5");
                    inputStream = sVNChecksumInputStream;
                }
                inputStream2 = SVNTranslator.getTranslatedStream(sVNAdminArea, string2, true, false);
                outputStream = SVNFileUtil.openFileForWriting(file);
                object = new SVNCommitter$CopyingStream(this, outputStream, inputStream2);
                string5 = this.myDeltaGenerator.sendDelta(string, inputStream, 0L, (InputStream)object, iSVNEditor, true);
            }
            catch (SVNException sVNException) {
                try {
                    sVNErrorMessage = sVNException.getErrorMessage().wrap("While preparing ''{0}'' for commit", sVNAdminArea.getFile(string2));
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(inputStream);
                    SVNFileUtil.closeFile(inputStream2);
                    SVNFileUtil.closeFile(outputStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile(inputStream);
                SVNFileUtil.closeFile(inputStream2);
                SVNFileUtil.closeFile(outputStream);
            }
            SVNFileUtil.closeFile(inputStream);
            SVNFileUtil.closeFile(inputStream2);
            SVNFileUtil.closeFile(outputStream);
            if (sVNChecksumInputStream != null) {
                string4 = sVNChecksumInputStream.getDigest();
            }
            if (string3 != null && string4 != null && !string3.equals(string4)) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", sVNAdminArea.getFile(string2), string3, string4);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if (sVNErrorMessage != null) {
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            iSVNEditor.closeFile(string, string5);
        }
    }

    private void sendPropertiesDelta(String string, SVNCommitItem sVNCommitItem, ISVNEditor iSVNEditor) {
        SVNProperties sVNProperties;
        String string2;
        SVNAdminArea sVNAdminArea;
        SVNWCAccess sVNWCAccess = sVNCommitItem.getWCAccess();
        if (sVNCommitItem.getKind() == SVNNodeKind.DIR) {
            sVNAdminArea = sVNWCAccess.retrieve(sVNCommitItem.getFile());
            string2 = "";
        } else {
            sVNAdminArea = sVNWCAccess.retrieve(sVNCommitItem.getFile().getParentFile());
            string2 = SVNPathUtil.tail(sVNCommitItem.getPath());
        }
        if (!sVNAdminArea.hasPropModifications(string2)) {
            return;
        }
        SVNEntry sVNEntry = sVNAdminArea.getEntry(string2, false);
        boolean bl2 = false;
        if (sVNEntry != null) {
            bl2 = sVNEntry.isScheduledForReplacement();
        }
        SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getProperties(string2);
        SVNVersionedProperties sVNVersionedProperties2 = bl2 ? null : sVNAdminArea.getBaseProperties(string2);
        SVNProperties sVNProperties2 = sVNProperties = bl2 ? sVNVersionedProperties.asMap() : sVNVersionedProperties2.compareTo(sVNVersionedProperties).asMap();
        if (sVNProperties != null && !sVNProperties.isEmpty()) {
            SVNPropertyValue sVNPropertyValue;
            File file = sVNAdminArea.getPropertiesFile(string2, true);
            SVNWCProperties sVNWCProperties = new SVNWCProperties(file, null);
            for (String string3 : sVNVersionedProperties.getPropertyNames(null)) {
                sVNPropertyValue = sVNVersionedProperties.getPropertyValue(string3);
                sVNWCProperties.setPropertyValue(string3, sVNPropertyValue);
            }
            if (!file.exists()) {
                SVNFileUtil.createEmptyFile(file);
            }
            this.myTmpFiles.add(file);
            for (String string3 : sVNProperties.nameSet()) {
                sVNPropertyValue = sVNProperties.getSVNPropertyValue(string3);
                if (sVNCommitItem.getKind() == SVNNodeKind.FILE) {
                    iSVNEditor.changeFileProperty(string, string3, sVNPropertyValue);
                    continue;
                }
                iSVNEditor.changeDirProperty(string3, sVNPropertyValue);
            }
        }
    }

    private String getCopyFromPath(SVNURL sVNURL) {
        if (sVNURL == null) {
            return null;
        }
        String string = sVNURL.getPath();
        if (this.myRepositoryRoot.equals(string)) {
            return "/";
        }
        return string.substring(this.myRepositoryRoot.length());
    }

    private void fixError(String string, SVNException sVNException, SVNNodeKind sVNNodeKind) {
        SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage();
        if (sVNErrorMessage.getErrorCode() == SVNErrorCode.FS_NOT_FOUND || sVNErrorMessage.getErrorCode() == SVNErrorCode.RA_DAV_PATH_NOT_FOUND) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_UP_TO_DATE, sVNNodeKind == SVNNodeKind.DIR ? "Directory ''{0}'' is out of date" : "File ''{0}'' is out of date", (Object)string);
            throw new SVNException(sVNErrorMessage);
        }
        throw sVNException;
    }

    public static SVNCommitInfo commit(Collection collection, Map map, SVNURL sVNURL, ISVNEditor iSVNEditor, ISVNEventHandler iSVNEventHandler) {
        String string = sVNURL.getPath();
        SVNCommitter sVNCommitter = new SVNCommitter(map, string, collection);
        SVNCommitUtil.driveCommitEditor(sVNCommitter, map.keySet(), iSVNEditor, -1L);
        sVNCommitter.sendTextDeltas(iSVNEditor);
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(null, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.COMMIT_FINALIZING, SVNEventAction.COMMIT_FINALIZING, null, null);
        sVNEvent.setURL(sVNURL);
        if (iSVNEventHandler != null) {
            iSVNEventHandler.handleEvent(sVNEvent, -1.0);
        }
        return iSVNEditor.closeEdit();
    }
}

