/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil$1;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil$2;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNStatusClient16;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitUtil {
    public static final Comparator FILE_COMPARATOR = new SVNCommitUtil$1();

    public static void driveCommitEditor(ISVNCommitPathHandler iSVNCommitPathHandler, Collection collection, ISVNEditor iSVNEditor, long l2) {
        if (collection == null || collection.isEmpty() || iSVNCommitPathHandler == null || iSVNEditor == null) {
            return;
        }
        String[] stringArray = collection.toArray(new String[collection.size()]);
        Arrays.sort(stringArray, SVNPathUtil.PATH_COMPARATOR);
        int n2 = 0;
        int n3 = 0;
        String string = null;
        if ("".equals(stringArray[n2])) {
            iSVNCommitPathHandler.handleCommitPath("", iSVNEditor);
            string = stringArray[n2];
            ++n2;
        } else {
            iSVNEditor.openRoot(l2);
        }
        ++n3;
        while (n2 < stringArray.length) {
            boolean bl2;
            String string2;
            String string3;
            String string4 = stringArray[n2];
            SVNErrorManager.assertionFailure(SVNPathUtil.isCanonical(string4), "path '" + string4 + "' is not canonical", SVNLogType.DEFAULT);
            String string5 = string3 = string == null || "".equals(string) ? "" : SVNPathUtil.getCommonPathAncestor(string4, string);
            if (string != null) {
                while (!string.equals(string3)) {
                    iSVNEditor.closeDir();
                    --n3;
                    if (string.lastIndexOf(47) >= 0) {
                        string = string.substring(0, string.lastIndexOf(47));
                        continue;
                    }
                    string = "";
                }
            }
            if ((string2 = string4.substring(string3.length())).startsWith("/")) {
                string2 = string2.substring(1);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                String string7 = string3 = "".equals(string3) ? string6 : string3 + "/" + string6;
                if (string3.equals(string4)) break;
                iSVNEditor.openDir(string3, l2);
                ++n3;
            }
            if (bl2 = iSVNCommitPathHandler.handleCommitPath(string4, iSVNEditor)) {
                string = string4;
                ++n3;
            } else {
                string = n2 + 1 < stringArray.length ? SVNPathUtil.removeTail(string4) : string4;
            }
            ++n2;
        }
        while (n3 > 0) {
            iSVNEditor.closeDir();
            --n3;
        }
    }

    public static SVNWCAccess createCommitWCAccess(File[] fileArray, SVNDepth sVNDepth, boolean bl2, Collection collection, SVNStatusClient16 sVNStatusClient16) {
        Object object;
        Serializable serializable;
        Object object2;
        Iterator iterator;
        Object object32;
        String[] stringArray = new String[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            sVNStatusClient16.checkCancelled();
            File file = fileArray[i2];
            stringArray[i2] = file.getAbsolutePath().replace(File.separatorChar, '/');
        }
        String string = SVNPathUtil.condencePaths(stringArray, collection, sVNDepth == SVNDepth.INFINITY);
        if (string == null) {
            return null;
        }
        boolean bl3 = false;
        if (sVNDepth == SVNDepth.FILES || sVNDepth == SVNDepth.IMMEDIATES) {
            for (Object object32 : collection) {
                if (!"".equals(object32)) continue;
                bl3 = true;
                break;
            }
        }
        Object object4 = new File(string).getAbsoluteFile();
        string = ((File)object4).getAbsolutePath().replace(File.separatorChar, '/');
        object32 = new SVNHashSet();
        Object object5 = new SVNHashSet();
        if (collection.isEmpty()) {
            sVNStatusClient16.checkCancelled();
            iterator = SVNWCManager.getActualTarget((File)object4);
            if (!"".equals(iterator)) {
                object2 = SVNFileType.getType(new File(string));
                collection.add(iterator);
                if (object2 == SVNFileType.DIRECTORY) {
                    if (sVNDepth == SVNDepth.INFINITY || sVNDepth == SVNDepth.IMMEDIATES || bl2 && SVNCommitUtil.isRecursiveCommitForced((File)object4)) {
                        object5.add(iterator);
                    } else {
                        object32.add(iterator);
                    }
                }
                object4 = ((File)object4).getParentFile();
            } else {
                bl3 = true;
            }
        } else if (!bl3) {
            object4 = SVNCommitUtil.adjustRelativePaths((File)object4, collection);
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                sVNStatusClient16.checkCancelled();
                object2 = (String)iterator.next();
                serializable = new File((File)object4, (String)object2);
                object = SVNFileType.getType((File)serializable);
                if (object == SVNFileType.DIRECTORY) {
                    if (sVNDepth == SVNDepth.INFINITY || sVNDepth == SVNDepth.IMMEDIATES || bl2 && SVNCommitUtil.isRecursiveCommitForced((File)serializable)) {
                        object5.add(object2);
                    } else if (!((File)serializable).equals(object4)) {
                        object32.add(object2);
                    }
                }
                if (((File)serializable).equals(object4)) continue;
                object2 = SVNPathUtil.removeTail((String)object2);
                for (serializable = ((File)serializable).getParentFile(); serializable != null && !((File)serializable).equals(object4) && !object32.contains(object2); serializable = ((File)serializable).getParentFile()) {
                    object32.add(object2);
                    object2 = SVNPathUtil.removeTail(object2);
                }
            }
        }
        iterator = SVNWCAccess.newInstance(new SVNCommitUtil$2(sVNStatusClient16));
        ((SVNWCAccess)((Object)iterator)).setOptions(sVNStatusClient16.getOptions());
        try {
            Object object6;
            Object object7;
            ((SVNWCAccess)((Object)iterator)).open((File)object4, true, bl3 ? -1 : 0);
            sVNStatusClient16.checkCancelled();
            object32 = new ArrayList<Object>((Collection<Object>)object32);
            object5 = new ArrayList(object5);
            Collections.sort((List)object32, SVNPathUtil.PATH_COMPARATOR);
            Collections.sort((List)object5, SVNPathUtil.PATH_COMPARATOR);
            if (!bl3) {
                object2 = new ArrayList();
                object2.addAll(object5);
                serializable = new SVNHashMap();
                object = object2.iterator();
                block8: while (object.hasNext()) {
                    object7 = (String)object.next();
                    if (serializable.containsKey(object7)) {
                        object.remove();
                        continue;
                    }
                    serializable.put(object7, object7);
                    object6 = object5.iterator();
                    while (object6.hasNext()) {
                        String string2 = (String)object6.next();
                        if (!((String)object7).startsWith(string2 + "/")) continue;
                        object.remove();
                        continue block8;
                    }
                }
                Collections.sort(object2, SVNPathUtil.PATH_COMPARATOR);
                object5 = object2;
                SVNCommitUtil.removeRedundantPaths((Collection)object5, object32);
                object = object32.iterator();
                while (object.hasNext()) {
                    sVNStatusClient16.checkCancelled();
                    object7 = (String)object.next();
                    object6 = new File((File)object4, (String)object7);
                    ((SVNWCAccess)((Object)iterator)).open((File)object6, true, 0);
                }
                object = object5.iterator();
                while (object.hasNext()) {
                    sVNStatusClient16.checkCancelled();
                    object7 = (String)object.next();
                    object6 = new File((File)object4, (String)object7);
                    ((SVNWCAccess)((Object)iterator)).open((File)object6, true, -1);
                }
            }
            for (int i3 = 0; i3 < fileArray.length; ++i3) {
                sVNStatusClient16.checkCancelled();
                serializable = fileArray[i3].getAbsoluteFile();
                serializable = ((File)serializable).getAbsoluteFile();
                try {
                    ((SVNWCAccess)((Object)iterator)).probeRetrieve((File)serializable);
                }
                catch (SVNException sVNException) {
                    object7 = sVNException.getErrorMessage().wrap("Are all the targets part of the same working copy?");
                    SVNErrorManager.error((SVNErrorMessage)object7, SVNLogType.WC);
                }
                if (sVNDepth == SVNDepth.INFINITY || bl2 || SVNFileType.getType((File)serializable) != SVNFileType.DIRECTORY || (object = sVNStatusClient16.doStatus((File)serializable, false)) == null || ((SVNStatus)object).getContentsStatus() != SVNStatusType.STATUS_DELETED && ((SVNStatus)object).getContentsStatus() != SVNStatusType.STATUS_REPLACED) continue;
                object7 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot non-recursively commit a directory deletion");
                SVNErrorManager.error((SVNErrorMessage)object7, SVNLogType.WC);
            }
            if (sVNDepth != SVNDepth.INFINITY && bl2) {
                SVNAdminArea[] sVNAdminAreaArray = ((SVNWCAccess)((Object)iterator)).getAdminAreas();
                for (int i4 = 0; i4 < sVNAdminAreaArray.length; ++i4) {
                    sVNStatusClient16.checkCancelled();
                    object = sVNAdminAreaArray[i4];
                    if (object == null || ((SVNEntry)(object7 = ((SVNWCAccess)((Object)iterator)).getEntry(((SVNAdminArea)object).getRoot(), true))).getCopyFromURL() == null) continue;
                    object6 = ((SVNAdminArea)object).getRoot();
                    boolean bl4 = false;
                    for (int i5 = 0; i5 < fileArray.length; ++i5) {
                        if (!((File)object6).equals(fileArray[i5])) continue;
                        bl4 = true;
                        break;
                    }
                    if (bl4) continue;
                    ((SVNWCAccess)((Object)iterator)).closeAdminArea(((SVNAdminArea)object).getRoot());
                }
            }
        }
        catch (SVNException sVNException) {
            ((SVNWCAccess)((Object)iterator)).close();
            throw sVNException;
        }
        ((SVNWCAccess)((Object)iterator)).setAnchor((File)object4);
        return iterator;
    }

    public static SVNWCAccess[] createCommitWCAccess2(File[] fileArray, SVNDepth sVNDepth, boolean bl2, Map map, SVNStatusClient16 sVNStatusClient16) {
        Object object;
        Object object3;
        Object object4;
        SVNHashMap sVNHashMap = new SVNHashMap();
        SVNHashMap sVNHashMap2 = new SVNHashMap();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            sVNStatusClient16.checkCancelled();
            object3 = object4 = fileArray[i2];
            if (((File)object3).isFile()) {
                object3 = ((File)object3).getParentFile();
            }
            File object22 = sVNHashMap2.containsKey(object3) ? (File)sVNHashMap2.get(object3) : SVNWCUtil.getWorkingCopyRoot((File)object3, true);
            sVNHashMap2.put(object4, object22);
            if (!sVNHashMap.containsKey(object22)) {
                sVNHashMap.put(object22, new ArrayList());
            }
            object = (Collection)sVNHashMap.get(object22);
            object.add(object4);
        }
        ArrayList<SVNWCAccess> arrayList = new ArrayList<SVNWCAccess>();
        try {
            object4 = sVNHashMap.keySet().iterator();
            while (object4.hasNext()) {
                sVNStatusClient16.checkCancelled();
                object3 = (File)object4.next();
                Collection collection = (Collection)sVNHashMap.get(object3);
                object = collection.toArray(new File[collection.size()]);
                ArrayList arrayList2 = new ArrayList();
                SVNWCAccess sVNWCAccess = SVNCommitUtil.createCommitWCAccess((File[])object, sVNDepth, bl2, arrayList2, sVNStatusClient16);
                map.put(sVNWCAccess, arrayList2);
                arrayList.add(sVNWCAccess);
            }
        }
        catch (SVNException sVNException) {
            for (SVNWCAccess sVNWCAccess : arrayList) {
                sVNWCAccess.close();
            }
            throw sVNException;
        }
        return arrayList.toArray(new SVNWCAccess[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNCommitItem[] harvestCommitables(SVNWCAccess sVNWCAccess, Collection collection, Map map, boolean bl2, SVNDepth sVNDepth, boolean bl3, Collection collection2, ISVNCommitParameters iSVNCommitParameters) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        TreeMap treeMap = new TreeMap(FILE_COMPARATOR);
        SVNHashSet sVNHashSet = new SVNHashSet();
        Iterator iterator2 = collection.iterator();
        boolean bl4 = false;
        do {
            Serializable serializable;
            Object object5;
            Object object6;
            iterator = iterator2.hasNext() ? (String)iterator2.next() : "";
            sVNWCAccess.checkCancelled();
            object4 = new File(sVNWCAccess.getAnchor(), (String)((Object)iterator));
            object3 = SVNPathUtil.removeTail((String)((Object)iterator));
            object2 = sVNWCAccess.probeRetrieve((File)object4);
            object = null;
            try {
                object = sVNWCAccess.getVersionedEntry((File)object4, false);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage() != null && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND && (object6 = sVNWCAccess.getTreeConflict((File)object4)) != null) {
                    object5 = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", object4);
                    SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.WC);
                }
                throw sVNException;
            }
            String string = null;
            if (((SVNEntry)object).getURL() == null) {
                if (!((SVNEntry)object).isThisDir() && ((SVNEntry)object).getName() != null && ((SVNEntry)object).isDirectory() && !((SVNEntry)object).isScheduledForAddition() && !((SVNEntry)object).isScheduledForReplacement() && SVNFileType.getType((File)object4) == SVNFileType.NONE && (object6 = ((File)object4).getParentFile()) != null && (object5 = sVNWCAccess.getEntry((File)object6, false)) != null) {
                    string = SVNPathUtil.append(((SVNEntry)object5).getURL(), SVNEncodingUtil.uriEncode(((SVNEntry)object).getName()));
                }
                if (string == null) {
                    object6 = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Entry for ''{0}'' has no URL", object4);
                    SVNErrorManager.error((SVNErrorMessage)object6, SVNLogType.WC);
                }
            } else {
                string = ((SVNEntry)object).getURL();
            }
            object6 = null;
            if (((SVNEntry)object).isScheduledForAddition() || ((SVNEntry)object).isScheduledForReplacement()) {
                try {
                    sVNWCAccess.retrieve(((File)object4).getParentFile());
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                        sVNWCAccess.open(((File)object4).getParentFile(), true, 0);
                    }
                    throw sVNException;
                }
                object6 = sVNWCAccess.getEntry(((File)object4).getParentFile(), false);
                if (object6 == null) {
                    object5 = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "''{0}'' is scheduled for addition within unversioned parent", object4);
                    SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.WC);
                } else if (((SVNEntry)object6).isScheduledForAddition() || ((SVNEntry)object6).isScheduledForReplacement()) {
                    sVNHashSet.add(((File)object4).getParentFile());
                }
            }
            object5 = sVNDepth;
            if (((SVNEntry)object).isCopied() && ((SVNEntry)object).getSchedule() == null) {
                if (bl3) continue;
                serializable = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Entry for ''{0}'' is marked as 'copied' but is not itself scheduled\nfor addition.  Perhaps you're committing a target that is\ninside an unversioned (or not-yet-versioned) directory?", object4);
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
            } else if (((SVNEntry)object).isCopied() && ((SVNEntry)object).isScheduledForAddition()) {
                if (bl3) {
                    bl4 = sVNDepth != SVNDepth.INFINITY;
                    object5 = SVNDepth.INFINITY;
                }
            } else if (((SVNEntry)object).isScheduledForDeletion() && bl3 && sVNDepth != SVNDepth.INFINITY) {
                serializable = ((File)object4).getParentFile();
                object6 = sVNWCAccess.getEntry((File)serializable, false);
                if (object6 == null) {
                    try {
                        sVNWCAccess.retrieve((File)serializable);
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                            sVNWCAccess.open((File)serializable, true, 0);
                        }
                        throw sVNException;
                    }
                    object6 = sVNWCAccess.getEntry((File)serializable, false);
                }
                if (object6 != null && ((SVNEntry)object6).isScheduledForDeletion() && collection.contains(object3)) continue;
                object5 = SVNDepth.INFINITY;
            }
            serializable = ((SVNAdminArea)object2).getRoot();
            SVNWCAccess sVNWCAccess2 = SVNWCAccess.newInstance(null);
            sVNWCAccess2.open((File)serializable, false, 0);
            try {
                boolean bl5;
                while (!(bl5 = sVNWCAccess2.isWCRoot((File)serializable))) {
                    File file = ((File)serializable).getParentFile();
                    sVNWCAccess2.open(file, false, 0);
                    if (sVNWCAccess2.hasTreeConflict((File)serializable)) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in tree-conflict", (Object)serializable);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    serializable = file;
                }
            }
            finally {
                sVNWCAccess2.close();
            }
            SVNCommitUtil.harvestCommitables(treeMap, (SVNAdminArea)object2, (File)object4, (SVNEntry)object6, (SVNEntry)object, string, null, false, false, bl2, map, (SVNDepth)object5, bl4, collection2, iSVNCommitParameters, null);
        } while (iterator2.hasNext());
        iterator = sVNHashSet.iterator();
        while (iterator.hasNext()) {
            sVNWCAccess.checkCancelled();
            object4 = (File)iterator.next();
            if (treeMap.containsKey(object4)) continue;
            object3 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not under version control\nand is not part of the commit, \nyet its child is part of the commit", object4);
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
        }
        SVNCommitUtil.filterOutFileExternals(collection, treeMap, sVNWCAccess);
        if (bl4) {
            iterator = treeMap.values().iterator();
            while (iterator.hasNext()) {
                sVNWCAccess.checkCancelled();
                object4 = (SVNCommitItem)iterator.next();
                if (((SVNCommitItem)object4).isDeleted()) {
                    object3 = ((SVNCommitItem)object4).getFile();
                    if (((SVNCommitItem)object4).getKind() == SVNNodeKind.DIR) {
                        if (!((File)object3).exists()) {
                            continue;
                        }
                    } else {
                        object2 = SVNPathUtil.tail(((SVNCommitItem)object4).getPath());
                        object = sVNWCAccess.retrieve(((SVNCommitItem)object4).getFile().getParentFile());
                        if (!((SVNAdminArea)object).getBaseFile((String)object2, false).exists()) continue;
                    }
                }
                if (!((SVNCommitItem)object4).isContentsModified() && !((SVNCommitItem)object4).isDeleted() && !((SVNCommitItem)object4).isPropertiesModified() || collection.contains(object3 = ((SVNCommitItem)object4).getPath())) continue;
                iterator.remove();
            }
        }
        return treeMap.values().toArray(new SVNCommitItem[treeMap.values().size()]);
    }

    public static void filterOutFileExternals(Collection collection, Map map, SVNWCAccess sVNWCAccess) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            sVNWCAccess.checkCancelled();
            SVNCommitItem sVNCommitItem = (SVNCommitItem)iterator.next();
            SVNEntry sVNEntry = sVNWCAccess.getEntry(sVNCommitItem.getFile(), false);
            if (sVNEntry == null || !sVNEntry.isFile() || sVNEntry.getExternalFilePath() == null || collection.contains(sVNCommitItem.getPath())) continue;
            iterator.remove();
        }
    }

    public static SVNURL translateCommitables(SVNCommitItem[] sVNCommitItemArray, Map map) {
        Object object;
        Object object2;
        SVNHashMap sVNHashMap = new SVNHashMap();
        for (int i2 = 0; i2 < sVNCommitItemArray.length; ++i2) {
            object2 = sVNCommitItemArray[i2];
            if (sVNHashMap.containsKey(((SVNCommitItem)object2).getURL())) {
                object = (SVNCommitItem)sVNHashMap.get(((SVNCommitItem)object2).getURL());
                Object object3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_DUPLICATE_COMMIT_URL, "Cannot commit both ''{0}'' and ''{1}'' as they refer to the same URL", ((SVNCommitItem)object2).getFile(), ((SVNCommitItem)object).getFile());
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            sVNHashMap.put(((SVNCommitItem)object2).getURL(), object2);
        }
        Iterator iterator = sVNHashMap.keySet().iterator();
        object2 = (SVNURL)iterator.next();
        while (iterator.hasNext()) {
            object = (SVNURL)iterator.next();
            object2 = SVNURLUtil.getCommonURLAncestor((SVNURL)object2, (SVNURL)object);
        }
        if (sVNHashMap.containsKey(object2)) {
            object = (SVNCommitItem)sVNHashMap.get(object2);
            if (((SVNCommitItem)object).getKind() != SVNNodeKind.DIR) {
                object2 = ((SVNURL)object2).removePathTail();
            } else if (((SVNCommitItem)object).getKind() == SVNNodeKind.DIR && (((SVNCommitItem)object).isAdded() || ((SVNCommitItem)object).isDeleted() || ((SVNCommitItem)object).isCopied() || ((SVNCommitItem)object).isLocked())) {
                object2 = ((SVNURL)object2).removePathTail();
            }
        }
        if (object2 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Cannot compute base URL for commit operation");
            SVNErrorManager.error(object, SVNLogType.WC);
        }
        for (Object object3 : sVNHashMap.keySet()) {
            SVNCommitItem sVNCommitItem = (SVNCommitItem)sVNHashMap.get(object3);
            String string = ((SVNURL)object3).equals(object2) ? "" : SVNPathUtil.getRelativePath(((SVNURL)object2).getPath(), ((SVNURL)object3).getPath());
            map.put(string, sVNCommitItem);
        }
        return object2;
    }

    public static Map translateLockTokens(Map map, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (String string2 : map.keySet()) {
            String string3 = (String)map.get(string2);
            string2 = string2.equals(string) ? "" : string2.substring(string.length() + 1);
            treeMap.put(SVNEncodingUtil.uriDecode(string2), string3);
        }
        map.clear();
        map.putAll(treeMap);
        return map;
    }

    public static void harvestCommitables(Map map, SVNAdminArea object, File file, SVNEntry sVNEntry, SVNEntry sVNEntry2, String string, String string2, boolean bl2, boolean bl3, boolean bl4, Map map2, SVNDepth sVNDepth, boolean bl5, Collection collection, ISVNCommitParameters iSVNCommitParameters, Map map3) {
        boolean bl6;
        Object object2;
        Object object3;
        boolean bl7;
        Object object4;
        Object object5;
        boolean bl8;
        Object object6;
        boolean bl9;
        Object object7;
        Object object8;
        if (map.containsKey(file)) {
            return;
        }
        if (object != null && ((SVNAdminArea)object).getWCAccess() != null) {
            ((SVNAdminArea)object).getWCAccess().checkCancelled();
        }
        long l2 = sVNEntry2.getCopyFromRevision();
        String string3 = null;
        if (sVNEntry2.getKind() != SVNNodeKind.DIR && sVNEntry2.getKind() != SVNNodeKind.FILE) {
            object8 = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown entry kind for ''{0}''", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object8, SVNLogType.WC);
        }
        object8 = SVNFileType.getType(file);
        boolean bl10 = SVNWCAccess.matchesChangeList(collection, sVNEntry2);
        if (object8 != SVNFileType.DIRECTORY && object8 != SVNFileType.NONE && !bl10) {
            return;
        }
        if (object8 == SVNFileType.UNKNOWN) {
            object7 = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown entry kind for ''{0}''", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object7, SVNLogType.WC);
        }
        object7 = ((SVNAdminArea)object).getProperties(sVNEntry2.getName()).getStringPropertyValue("svn:special");
        boolean bl11 = bl9 = object8 == SVNFileType.SYMLINK;
        if (SVNFileType.isSymlinkSupportEnabled() && (object7 == null && bl9 || SVNFileUtil.symlinksSupported() && object7 != null && !bl9) && object8 != SVNFileType.NONE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "Entry ''{0}'' has unexpectedly changed special status", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl12 = false;
        boolean bl13 = ((SVNAdminArea)object).hasTreeConflict(sVNEntry2.getName());
        SVNAdminArea sVNAdminArea = null;
        if (sVNEntry2.getKind() == SVNNodeKind.DIR) {
            object6 = null;
            try {
                object6 = ((SVNAdminArea)object).getWCAccess().retrieve(((SVNAdminArea)object).getFile(sVNEntry2.getName()));
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    object6 = null;
                }
                throw sVNException;
            }
            if (object6 != null && ((SVNAdminArea)object6).entries(true) != null && (sVNAdminArea = object6).getEntry("", false) != null) {
                sVNEntry2 = sVNAdminArea.getEntry("", false);
                object = object6;
            }
            bl8 = ((SVNAdminArea)object).hasPropConflict(sVNEntry2.getName());
            object5 = sVNEntry2.getTreeConflicts();
            for (File file2 : object5.keySet()) {
                SVNTreeConflictDescription sVNTreeConflictDescription = (SVNTreeConflictDescription)object5.get(file2);
                if (sVNTreeConflictDescription.getNodeKind() == SVNNodeKind.DIR && sVNDepth == SVNDepth.FILES) continue;
                SVNEntry sVNEntry3 = null;
                if (sVNTreeConflictDescription.getNodeKind() == SVNNodeKind.DIR) {
                    object4 = ((SVNAdminArea)object).getWCAccess().getAdminArea(file2);
                    if (object4 != null) {
                        sVNEntry3 = ((SVNAdminArea)object4).getEntry("", true);
                    }
                    sVNEntry3 = ((SVNAdminArea)object6).getEntry(file2.getName(), true);
                } else {
                    sVNEntry3 = ((SVNAdminArea)object).getEntry(file2.getName(), true);
                }
                if (collection != null && !collection.isEmpty() && (sVNEntry3 == null || !SVNWCAccess.matchesChangeList(collection, sVNEntry3))) continue;
                object4 = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
            }
        } else {
            bl8 = ((SVNAdminArea)object).hasPropConflict(sVNEntry2.getName());
            bl12 = ((SVNAdminArea)object).hasTextConflict(sVNEntry2.getName());
        }
        if ((bl8 || bl12 || bl13) && SVNWCAccess.matchesChangeList(collection, sVNEntry2)) {
            object6 = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object6, SVNLogType.WC);
        }
        if (sVNEntry2.getURL() != null && !bl2) {
            string = sVNEntry2.getURL();
        }
        boolean bl14 = bl7 = !bl3 && (sVNEntry2.isDeleted() && sVNEntry2.getSchedule() == null || sVNEntry2.isScheduledForDeletion() || sVNEntry2.isScheduledForReplacement());
        if (!bl3 && !bl7 && object8 == SVNFileType.NONE && iSVNCommitParameters != null) {
            Object object9 = object5 = sVNEntry2.getKind() == SVNNodeKind.DIR ? iSVNCommitParameters.onMissingDirectory(file) : iSVNCommitParameters.onMissingFile(file);
            if (object5 == ISVNCommitParameters.ERROR) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy file ''{0}'' is missing", (Object)file);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else if (object5 == ISVNCommitParameters.DELETE) {
                bl7 = true;
                sVNEntry2.scheduleForDeletion();
                ((SVNAdminArea)object).saveEntries(false);
            }
        }
        boolean bl15 = false;
        boolean bl16 = false;
        if (sVNEntry2.isScheduledForAddition() || sVNEntry2.isScheduledForReplacement()) {
            bl15 = true;
            if (sVNEntry2.getCopyFromURL() != null) {
                string3 = sVNEntry2.getCopyFromURL();
                bl3 = false;
                bl16 = true;
            } else {
                bl3 = true;
            }
        }
        if ((sVNEntry2.isCopied() || bl2) && !sVNEntry2.isDeleted() && sVNEntry2.getSchedule() == null) {
            long l3 = sVNEntry2.getRevision() - 1L;
            boolean bl17 = false;
            if (sVNEntry2 != null && sVNEntry != null) {
                boolean bl18 = bl17 = !sVNEntry2.getURL().equals(SVNPathUtil.append(sVNEntry.getURL(), SVNEncodingUtil.uriEncode(file.getName())));
            }
            if (!bl17 && !((SVNAdminArea)object).getWCAccess().isWCRoot(file)) {
                if (sVNEntry != null) {
                    l3 = sVNEntry.getRevision();
                }
            } else if (!bl2) {
                object4 = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Did not expect ''{0}'' to be a working copy root", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
            }
            if (l3 != sVNEntry2.getRevision()) {
                bl15 = true;
                bl16 = true;
                bl3 = false;
                l2 = sVNEntry2.getRevision();
                if (bl2) {
                    string3 = sVNEntry2.getURL();
                } else if (string2 != null) {
                    string3 = string2;
                } else {
                    object4 = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Commit item ''{0}'' has copy flag but no copyfrom URL", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
                }
            }
        }
        boolean bl19 = false;
        boolean bl20 = false;
        if (bl15) {
            object4 = SVNFileType.getType(file);
            if (object4 == SVNFileType.NONE) {
                object3 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' is scheduled for addition, but is missing", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            object3 = ((SVNAdminArea)object).getProperties(sVNEntry2.getName());
            object2 = ((SVNAdminArea)object).getBaseProperties(sVNEntry2.getName());
            SVNProperties sVNProperties = null;
            sVNProperties = sVNEntry2.isScheduledForReplacement() ? ((SVNVersionedProperties)object3).asMap() : ((SVNVersionedProperties)object2).compareTo((SVNVersionedProperties)object3).asMap();
            bl19 = sVNProperties != null && sVNProperties.containsName("svn:eol-style");
            boolean bl21 = bl19;
            boolean bl22 = sVNProperties != null && sVNProperties.containsName("svnkit:charset");
            boolean bl23 = bl19 = bl21 || bl22;
            if (sVNEntry2.getKind() == SVNNodeKind.FILE) {
                if (bl16) {
                    boolean bl24 = bl19 = sVNProperties != null && (sVNProperties.containsName("svn:eol-style") || sVNProperties.containsName("svnkit:charset"));
                    if (!bl19) {
                        bl19 = ((SVNAdminArea)object).hasTextModifications(sVNEntry2.getName(), bl21);
                    }
                } else {
                    bl19 = true;
                }
            }
            bl20 = sVNProperties != null && !sVNProperties.isEmpty();
        } else if (!bl7) {
            object4 = ((SVNAdminArea)object).getProperties(sVNEntry2.getName());
            object3 = ((SVNAdminArea)object).getBaseProperties(sVNEntry2.getName());
            object2 = ((SVNVersionedProperties)object3).compareTo((SVNVersionedProperties)object4).asMap();
            bl19 = object2 != null && (((SVNProperties)object2).containsName("svn:eol-style") || ((SVNProperties)object2).containsName("svnkit:charset"));
            boolean bl25 = bl19;
            boolean bl26 = bl20 = object2 != null && !((SVNProperties)object2).isEmpty();
            if (sVNEntry2.getKind() == SVNNodeKind.FILE) {
                bl19 = ((SVNAdminArea)object).hasTextModifications(sVNEntry2.getName(), bl25);
            }
        }
        boolean bl27 = bl6 = sVNEntry2.getLockToken() != null && (bl4 || bl19 || bl20 || bl7 || bl15 || bl16);
        if ((bl15 || bl7 || bl19 || bl20 || bl16 || bl6) && SVNWCAccess.matchesChangeList(collection, sVNEntry2)) {
            object4 = new SVNCommitItem(file, SVNURL.parseURIEncoded(string), string3 != null ? SVNURL.parseURIEncoded(string3) : null, sVNEntry2.getKind(), SVNRevision.create(sVNEntry2.getRevision()), SVNRevision.create(l2), bl15, bl7, bl20, bl19, bl16, bl6);
            object3 = ((SVNAdminArea)object).getRelativePath(((SVNAdminArea)object).getWCAccess().retrieve(((SVNAdminArea)object).getWCAccess().getAnchor()));
            if ("".equals(object3)) {
                object3 = (String)object3 + sVNEntry2.getName();
            } else if (!"".equals(sVNEntry2.getName())) {
                object3 = (String)object3 + "/" + sVNEntry2.getName();
            }
            ((SVNCommitItem)object4).setPath((String)object3);
            map.put(file, object4);
            if (map2 != null && sVNEntry2.getLockToken() != null) {
                map2.put(string, sVNEntry2.getLockToken());
            }
        }
        if (map3 != null && SVNWCAccess.matchesChangeList(collection, sVNEntry2) && (object3 = ((SVNVersionedProperties)(object4 = ((SVNAdminArea)object).getProperties(sVNEntry2.getName()))).getStringPropertyValue("svn:externals")) != null) {
            map3.put(((SVNAdminArea)object).getFile(sVNEntry2.getName()), object3);
        }
        if (sVNAdminArea != null && SVNDepth.EMPTY.compareTo(sVNDepth) < 0 && (bl15 || !bl7)) {
            object4 = sVNAdminArea.entries(bl2);
            while (object4.hasNext()) {
                Object object10;
                if (object != null && ((SVNAdminArea)object).getWCAccess() != null) {
                    ((SVNAdminArea)object).getWCAccess().checkCancelled();
                }
                if (((SVNEntry)(object3 = (SVNEntry)object4.next())).isThisDir() || bl5 && ((SVNEntry)object3).isCopied() && ((SVNEntry)object3).getCopyFromURL() != null || ((SVNEntry)object3).getDepth() == SVNDepth.EXCLUDE || sVNEntry2.isScheduledForReplacement() && ((SVNEntry)object3).isScheduledForDeletion()) continue;
                Object object11 = object2 = string3 != null ? string3 : string2;
                if (object2 != null) {
                    object2 = SVNPathUtil.append((String)object2, SVNEncodingUtil.uriEncode(((SVNEntry)object3).getName()));
                }
                String string4 = ((SVNEntry)object3).getURL();
                if (bl2 || ((SVNEntry)object3).getURL() == null) {
                    string4 = SVNPathUtil.append(string, SVNEncodingUtil.uriEncode(((SVNEntry)object3).getName()));
                }
                File file3 = ((SVNAdminArea)object).getFile(((SVNEntry)object3).getName());
                if (((SVNEntry)object3).getKind() == SVNNodeKind.DIR) {
                    SVNAdminArea sVNAdminArea2;
                    if (SVNDepth.FILES.compareTo(sVNDepth) >= 0) continue;
                    try {
                        sVNAdminArea2 = ((SVNAdminArea)object).getWCAccess().retrieve(((SVNAdminArea)object).getFile(((SVNEntry)object3).getName()));
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                            sVNAdminArea2 = null;
                        }
                        throw sVNException;
                    }
                    if (sVNAdminArea2 == null) {
                        Object object12;
                        Object object13;
                        object10 = SVNFileType.getType(file3);
                        if (object10 == SVNFileType.NONE && ((SVNEntry)object3).isScheduledForDeletion()) {
                            if (SVNWCAccess.matchesChangeList(collection, sVNEntry2)) {
                                object13 = new SVNCommitItem(file3, SVNURL.parseURIEncoded(string4), null, ((SVNEntry)object3).getKind(), SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, false, true, false, false, false, false);
                                object12 = ((SVNAdminArea)object).getRelativePath(((SVNAdminArea)object).getWCAccess().retrieve(((SVNAdminArea)object).getWCAccess().getAnchor()));
                                ((SVNCommitItem)object13).setPath(SVNPathUtil.append((String)object12, ((SVNEntry)object3).getName()));
                                map.put(file3, object13);
                                continue;
                            }
                        } else if (object10 != SVNFileType.NONE) {
                            object13 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy ''{0}'' is missing or not locked", (Object)file3);
                            SVNErrorManager.error((SVNErrorMessage)object13, SVNLogType.WC);
                        } else {
                            Object object14 = object13 = iSVNCommitParameters != null ? iSVNCommitParameters.onMissingDirectory(((SVNAdminArea)object).getFile(((SVNEntry)object3).getName())) : ISVNCommitParameters.ERROR;
                            if (object13 == ISVNCommitParameters.DELETE) {
                                object12 = new SVNCommitItem(file3, SVNURL.parseURIEncoded(string4), null, ((SVNEntry)object3).getKind(), SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, false, true, false, false, false, false);
                                String string5 = ((SVNAdminArea)object).getRelativePath(((SVNAdminArea)object).getWCAccess().retrieve(((SVNAdminArea)object).getWCAccess().getAnchor()));
                                ((SVNCommitItem)object12).setPath(SVNPathUtil.append(string5, ((SVNEntry)object3).getName()));
                                map.put(file3, object12);
                                ((SVNEntry)object3).scheduleForDeletion();
                                sVNAdminArea.saveEntries(false);
                                continue;
                            }
                            if (object13 != ISVNCommitParameters.ERROR) continue;
                            object12 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy ''{0}'' is missing or not locked", (Object)file3);
                            SVNErrorManager.error((SVNErrorMessage)object12, SVNLogType.WC);
                        }
                    }
                }
                object10 = sVNDepth;
                if (sVNDepth == SVNDepth.FILES || sVNDepth == SVNDepth.IMMEDIATES) {
                    object10 = SVNDepth.EMPTY;
                }
                SVNCommitUtil.harvestCommitables(map, (SVNAdminArea)object, file3, sVNEntry2, (SVNEntry)object3, string4, (String)object2, bl2, bl3, bl4, map2, (SVNDepth)object10, bl5, collection, iSVNCommitParameters, map3);
            }
        }
        if (map2 != null && sVNEntry2.getKind() == SVNNodeKind.DIR && bl7) {
            SVNCommitUtil.collectLocks((SVNAdminArea)object, map2);
        }
    }

    private static void collectLocks(SVNAdminArea sVNAdminArea, Map map) {
        Iterator iterator = sVNAdminArea.entries(false);
        while (iterator.hasNext()) {
            SVNAdminArea sVNAdminArea2;
            SVNEntry sVNEntry = (SVNEntry)iterator.next();
            if (sVNEntry.getURL() != null && sVNEntry.getLockToken() != null) {
                map.put(sVNEntry.getURL(), sVNEntry.getLockToken());
            }
            if (sVNAdminArea.getThisDirName().equals(sVNEntry.getName()) || !sVNEntry.isDirectory()) continue;
            try {
                sVNAdminArea2 = sVNAdminArea.getWCAccess().retrieve(sVNAdminArea.getFile(sVNEntry.getName()));
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    sVNAdminArea2 = null;
                }
                throw sVNException;
            }
            if (sVNAdminArea2 == null) continue;
            SVNCommitUtil.collectLocks(sVNAdminArea2, map);
        }
        sVNAdminArea.closeEntries();
    }

    private static void removeRedundantPaths(Collection collection, Collection collection2) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        Iterator iterator = collection2.iterator();
        block0: while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (sVNHashMap.containsKey(string)) {
                iterator.remove();
                continue;
            }
            sVNHashMap.put(string, string);
            if (collection.contains(string)) {
                iterator.remove();
                continue;
            }
            for (String string2 : collection) {
                if (!string.startsWith(string2 + "/")) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    private static File adjustRelativePaths(File file, Collection collection) {
        String string;
        if (collection.contains("") && !"".equals(string = SVNWCManager.getActualTarget(file)) && file.getParentFile() != null) {
            file = file.getParentFile();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : collection) {
                string2 = "".equals(string2) ? string : SVNPathUtil.append(string, string2);
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            collection.clear();
            Collections.sort(arrayList);
            collection.addAll(arrayList);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRecursiveCommitForced(File file) {
        try (SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(null);){
            sVNWCAccess.open(file, false, 0);
            SVNEntry sVNEntry = sVNWCAccess.getEntry(file, false);
            if (sVNEntry != null) {
                boolean bl2 = sVNEntry.isCopied() || sVNEntry.isScheduledForDeletion() || sVNEntry.isScheduledForReplacement();
                return bl2;
            }
        }
        return false;
    }

    public static String validateCommitMessage(String string) {
        if (string == null) {
            return string;
        }
        string = string.replaceAll("\r\n", "\n");
        string = string.replace('\r', '\n');
        return string;
    }
}

