/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.wc.SVNCommitItem;

public class SVNCommitMediator
implements ISVNWorkspaceMediator {
    private Collection myTmpFiles = new ArrayList();
    private Map myWCPropsMap = new SVNHashMap();
    private Map myCommitItems;

    public SVNCommitMediator(Map map) {
        this.myCommitItems = map;
    }

    public SVNProperties getWCProperties(SVNCommitItem sVNCommitItem) {
        return (SVNProperties)this.myWCPropsMap.get(sVNCommitItem);
    }

    public Collection getTmpFiles() {
        return this.myTmpFiles;
    }

    @Override
    public SVNPropertyValue getWorkspaceProperty(String string, String string2) {
        String string3;
        SVNAdminArea sVNAdminArea;
        SVNCommitItem sVNCommitItem = (SVNCommitItem)this.myCommitItems.get(string);
        if (sVNCommitItem == null) {
            return null;
        }
        SVNWCAccess sVNWCAccess = sVNCommitItem.getWCAccess();
        if (sVNCommitItem.getKind() == SVNNodeKind.DIR) {
            sVNAdminArea = sVNWCAccess.retrieve(sVNCommitItem.getFile());
            string3 = "";
        } else {
            sVNAdminArea = sVNWCAccess.retrieve(sVNCommitItem.getFile().getParentFile());
            string3 = SVNPathUtil.tail(sVNCommitItem.getPath());
        }
        SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getWCProperties(string3);
        if (sVNVersionedProperties != null) {
            return sVNVersionedProperties.getPropertyValue(string2);
        }
        return null;
    }

    @Override
    public void setWorkspaceProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (string2 == null) {
            return;
        }
        SVNCommitItem sVNCommitItem = (SVNCommitItem)this.myCommitItems.get(string);
        if (!this.myWCPropsMap.containsKey(sVNCommitItem)) {
            this.myWCPropsMap.put(sVNCommitItem, new SVNProperties());
        }
        ((SVNProperties)this.myWCPropsMap.get(sVNCommitItem)).put(string2, sVNPropertyValue);
    }
}

