/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.fs.repcache.IFSRepresentationCacheManagerFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNAuthenticator;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.util.ISVNThreadPool;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNClassLoader {
    private static final String SVNKIT_PROPERTIES = "svnkit.properties";
    private static final String SVNKIT_PROPERTIES_PATH = "svnkit.properties.property";
    private static final String DEFAULT_PROPERTIES = "svnkit.adminareafactory.1=org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea16Factory\nsvnkit.adminareafactory.2=org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea15Factory\nsvnkit.adminareafactory.3=org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14Factory\nsvnkit.adminareafactory.4=org.tmatesoft.svn.core.internal.wc.admin.SVNXMLAdminAreaFactory\nsvnkit.repcachemanagerfactory.1=org.tmatesoft.svn.core.internal.io.fs.repcache.FSRepresentationCacheManagerFactory\nsvnkit.repcachemanagerfactory.2=org.tmatesoft.svn.core.internal.io.fs.repcache.FSEmptyRepresentationCacheManagerFactory\nsvnkit.saslauthenticator.1=org.tmatesoft.svn.core.internal.io.svn.sasl.SVNSaslAuthenticator\nsvnkit.saslauthenticator.2=org.tmatesoft.svn.core.internal.io.svn.SVNPlainAuthenticator\nsvnkit.threadpool.1=org.tmatesoft.svn.core.internal.util.SVNThreadPool\nsvnkit.threadpool.2=org.tmatesoft.svn.core.internal.util.SVNEmptyThreadPool\n";

    public static ISVNThreadPool getThreadPool() {
        Collection collection = SVNClassLoader.getAllClasses("svnkit.threadpool.");
        for (Class clazz : collection) {
            Object var3_3 = null;
            try {
                var3_3 = clazz.newInstance();
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, "Could not instantiate a thread pool class " + clazz.getName() + ": " + throwable.getMessage());
            }
            if (var3_3 == null || !(var3_3 instanceof ISVNThreadPool)) continue;
            return var3_3;
        }
        return null;
    }

    public static Collection getAvailableAdminAreaFactories() {
        Collection collection = SVNClassLoader.getAllClasses("svnkit.adminareafactory.");
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (Class clazz : collection) {
            Object e2 = null;
            try {
                e2 = clazz.newInstance();
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "Failed to instantiate an admin area factory class " + clazz.getName() + ": " + throwable.getMessage());
                continue;
            }
            if (e2 == null || !(e2 instanceof SVNAdminAreaFactory)) continue;
            treeSet.add(e2);
        }
        return treeSet;
    }

    public static SVNAuthenticator getSASLAuthenticator(SVNConnection sVNConnection) {
        Collection collection = SVNClassLoader.getAllClasses("svnkit.saslauthenticator.");
        for (Class clazz : collection) {
            Constructor constructor = null;
            try {
                constructor = clazz.getConstructor(SVNConnection.class);
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Failed to get constructor of a SASL authenticator (" + clazz.getName() + "): " + throwable.getMessage());
            }
            if (constructor == null) continue;
            Object var5_5 = null;
            try {
                var5_5 = constructor.newInstance(sVNConnection);
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Failed to instantiate a SASL authenticator ( " + clazz.getName() + "): " + throwable.getMessage());
            }
            if (var5_5 == null || !(var5_5 instanceof SVNAuthenticator)) continue;
            return var5_5;
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "No SASL authenticator class found!");
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        return null;
    }

    public static IFSRepresentationCacheManagerFactory getFSRepresentationCacheManagerFactory() {
        Collection collection = SVNClassLoader.getAllClasses("svnkit.repcachemanagerfactory.");
        for (Class clazz : collection) {
            Object var3_3 = null;
            try {
                var3_3 = clazz.newInstance();
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, "Could not instantiate a rep-cache manager class " + clazz.getName() + ": " + throwable.getMessage());
            }
            if (var3_3 == null || !(var3_3 instanceof IFSRepresentationCacheManagerFactory)) continue;
            return var3_3;
        }
        return null;
    }

    private static Collection getAllClasses(String string) {
        LinkedList linkedList = new LinkedList();
        Map map = SVNClassLoader.loadProperties();
        for (String string2 : map.keySet()) {
            String string3;
            if (!string2.startsWith(string) || (string3 = (String)map.get(string2)) == null) continue;
            Class<?> clazz = null;
            try {
                clazz = SVNClassLoader.class.getClassLoader().loadClass(string3);
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "Failed to load class " + string3 + ": " + throwable.getMessage());
                continue;
            }
            if (clazz == null) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "Failed to load class " + string3);
                continue;
            }
            linkedList.add(clazz);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map loadProperties() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Properties properties = new Properties();
        InputStream inputStream = new ByteArrayInputStream(DEFAULT_PROPERTIES.getBytes());
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Failed to load default SVNKit properties: " + iOException.getMessage());
        }
        String string = System.getProperty(SVNKIT_PROPERTIES_PATH, SVNKIT_PROPERTIES);
        try {
            inputStream = SVNClassLoader.class.getClassLoader().getResourceAsStream(string);
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Failed to load '" + string + "': " + iOException.getMessage());
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
        for (String string2 : properties.keySet()) {
            String string3 = properties.getProperty(string2);
            string3 = System.getProperty(string2, string3);
            treeMap.put(string2, string3);
        }
        return treeMap;
    }
}

