/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.OutputStream;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCancellableEditor
implements ISVNUpdateEditor {
    private ISVNEditor myDelegate;
    private ISVNCanceller myCancel;
    private ISVNDebugLog myLog;

    public static ISVNEditor newInstance(ISVNEditor iSVNEditor, ISVNCanceller iSVNCanceller, ISVNDebugLog iSVNDebugLog) {
        if (iSVNCanceller != null) {
            return new SVNCancellableEditor(iSVNEditor, iSVNCanceller, iSVNDebugLog);
        }
        return iSVNEditor;
    }

    private SVNCancellableEditor(ISVNEditor iSVNEditor, ISVNCanceller iSVNCanceller, ISVNDebugLog iSVNDebugLog) {
        this.myDelegate = iSVNEditor;
        this.myCancel = iSVNCanceller;
        this.myLog = iSVNDebugLog == null ? SVNDebugLog.getDefaultLog() : iSVNDebugLog;
    }

    @Override
    public void targetRevision(long l2) {
        this.myCancel.checkCancelled();
        this.myDelegate.targetRevision(l2);
    }

    @Override
    public void openRoot(long l2) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "root");
        this.myDelegate.openRoot(l2);
    }

    @Override
    public void deleteEntry(String string, long l2) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "del " + string);
        this.myDelegate.deleteEntry(string, l2);
    }

    @Override
    public void absentDir(String string) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "absent dir " + string);
        this.myDelegate.absentDir(string);
    }

    @Override
    public void absentFile(String string) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "absent file " + string);
        this.myDelegate.absentFile(string);
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "add dir " + string);
        this.myDelegate.addDir(string, string2, l2);
    }

    @Override
    public void openDir(String string, long l2) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "open dir " + string);
        this.myDelegate.openDir(string, l2);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "change dir prop " + string + " = " + SVNPropertyValue.getPropertyAsString(sVNPropertyValue));
        this.myDelegate.changeDirProperty(string, sVNPropertyValue);
    }

    @Override
    public void closeDir() {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "close dir");
        this.myDelegate.closeDir();
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "add file " + string);
        this.myDelegate.addFile(string, string2, l2);
    }

    @Override
    public void openFile(String string, long l2) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "open file " + string);
        this.myDelegate.openFile(string, l2);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "apply delta " + string);
        this.myDelegate.applyTextDelta(string, string2);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        this.myLog.logFine(SVNLogType.WC, "delta chunk " + string);
        return this.myDelegate.textDeltaChunk(string, sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        this.myLog.logFine(SVNLogType.WC, "delta end " + string);
        this.myDelegate.textDeltaEnd(string);
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "change file prop " + string2 + " = " + SVNPropertyValue.getPropertyAsString(sVNPropertyValue));
        this.myDelegate.changeFileProperty(string, string2, sVNPropertyValue);
    }

    @Override
    public void closeFile(String string, String string2) {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "close file " + string);
        this.myDelegate.closeFile(string, string2);
    }

    @Override
    public SVNCommitInfo closeEdit() {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "close edit");
        return this.myDelegate.closeEdit();
    }

    @Override
    public void abortEdit() {
        this.myLog.logFine(SVNLogType.WC, "abort edit");
        this.myDelegate.abortEdit();
    }

    @Override
    public long getTargetRevision() {
        if (this.myDelegate instanceof ISVNUpdateEditor) {
            return ((ISVNUpdateEditor)this.myDelegate).getTargetRevision();
        }
        return -1L;
    }
}

