/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.LinkedList;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.SVNAmbientDepthFilterEditor$DirBaton;
import org.tmatesoft.svn.core.internal.wc.SVNAmbientDepthFilterEditor$FileBaton;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAmbientDepthFilterEditor
implements ISVNEditor {
    private ISVNEditor myDelegate;
    private SVNWCAccess myWCAccess;
    private File myAnchor;
    private String myTarget;
    private SVNAmbientDepthFilterEditor$DirBaton myCurrentDirBaton;
    private SVNAmbientDepthFilterEditor$FileBaton myCurrentFileBaton;
    private LinkedList myDirs;

    public static ISVNEditor wrap(ISVNEditor iSVNEditor, SVNAdminAreaInfo sVNAdminAreaInfo, boolean bl2) {
        if (!bl2) {
            return new SVNAmbientDepthFilterEditor(iSVNEditor, sVNAdminAreaInfo.getWCAccess(), sVNAdminAreaInfo.getAnchor().getRoot(), sVNAdminAreaInfo.getTargetName());
        }
        return iSVNEditor;
    }

    private SVNAmbientDepthFilterEditor(ISVNEditor iSVNEditor, SVNWCAccess sVNWCAccess, File file, String string) {
        this.myDelegate = iSVNEditor;
        this.myWCAccess = sVNWCAccess;
        this.myAnchor = file;
        this.myTarget = string;
        this.myDirs = new LinkedList();
    }

    @Override
    public void abortEdit() {
        this.myDelegate.abortEdit();
    }

    @Override
    public void absentDir(String string) {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.absentDir(string);
    }

    @Override
    public void absentFile(String string) {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.absentFile(string);
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        SVNAmbientDepthFilterEditor$DirBaton sVNAmbientDepthFilterEditor$DirBaton = this.myCurrentDirBaton;
        this.myCurrentDirBaton = this.makeDirBaton(string, sVNAmbientDepthFilterEditor$DirBaton);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myCurrentDirBaton.myAmbientDepth = string.equals(this.myTarget) ? SVNDepth.INFINITY : (sVNAmbientDepthFilterEditor$DirBaton.myAmbientDepth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : SVNDepth.INFINITY);
        this.myDelegate.addDir(string, string2, l2);
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        this.myCurrentFileBaton = this.makeFileBaton(this.myCurrentDirBaton, string);
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.addFile(string, string2, l2);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.changeDirProperty(string, sVNPropertyValue);
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.changeFileProperty(string, string2, sVNPropertyValue);
    }

    @Override
    public void closeDir() {
        SVNAmbientDepthFilterEditor$DirBaton sVNAmbientDepthFilterEditor$DirBaton = (SVNAmbientDepthFilterEditor$DirBaton)this.myDirs.removeLast();
        this.myCurrentDirBaton = this.myDirs.isEmpty() ? null : (SVNAmbientDepthFilterEditor$DirBaton)this.myDirs.getLast();
        if (sVNAmbientDepthFilterEditor$DirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.closeDir();
    }

    @Override
    public SVNCommitInfo closeEdit() {
        return this.myDelegate.closeEdit();
    }

    @Override
    public void closeFile(String string, String string2) {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.closeFile(string, string2);
    }

    @Override
    public void deleteEntry(String string, long l2) {
        File file;
        SVNEntry sVNEntry;
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        if (this.myCurrentDirBaton.myAmbientDepth.compareTo(SVNDepth.IMMEDIATES) < 0 && (sVNEntry = this.myWCAccess.getEntry(file = new File(this.myAnchor, string), false)) == null) {
            return;
        }
        this.myDelegate.deleteEntry(string, l2);
    }

    @Override
    public void openDir(String string, long l2) {
        SVNAmbientDepthFilterEditor$DirBaton sVNAmbientDepthFilterEditor$DirBaton = this.myCurrentDirBaton;
        this.myCurrentDirBaton = this.makeDirBaton(string, sVNAmbientDepthFilterEditor$DirBaton);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.openDir(string, l2);
        SVNEntry sVNEntry = this.myWCAccess.getEntry(this.myCurrentDirBaton.myPath, false);
        if (sVNEntry != null) {
            this.myCurrentDirBaton.myAmbientDepth = sVNEntry.getDepth();
        }
    }

    @Override
    public void openFile(String string, long l2) {
        this.myCurrentFileBaton = this.makeFileBaton(this.myCurrentDirBaton, string);
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.openFile(string, l2);
    }

    @Override
    public void openRoot(long l2) {
        SVNEntry sVNEntry;
        this.myCurrentDirBaton = this.makeDirBaton(null, null);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        if ((this.myTarget == null || "".equals(this.myTarget)) && (sVNEntry = this.myWCAccess.getEntry(this.myCurrentDirBaton.myPath, false)) != null) {
            this.myCurrentDirBaton.myAmbientDepth = sVNEntry.getDepth();
        }
        this.myDelegate.openRoot(l2);
    }

    @Override
    public void targetRevision(long l2) {
        this.myDelegate.targetRevision(l2);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.applyTextDelta(string, string2);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return SVNFileUtil.DUMMY_OUT;
        }
        return this.myDelegate.textDeltaChunk(string, sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.textDeltaEnd(string);
    }

    private SVNAmbientDepthFilterEditor$FileBaton makeFileBaton(SVNAmbientDepthFilterEditor$DirBaton sVNAmbientDepthFilterEditor$DirBaton, String string) {
        SVNEntry sVNEntry;
        Object object;
        if (string == null) {
            object = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "aborting in SVNAmbientDepthFilterEditor.makeFileBation(): path == null");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        object = new SVNAmbientDepthFilterEditor$FileBaton(this);
        if (sVNAmbientDepthFilterEditor$DirBaton.myIsAmbientlyExcluded) {
            ((SVNAmbientDepthFilterEditor$FileBaton)object).myIsAmbientlyExcluded = true;
            return object;
        }
        if (sVNAmbientDepthFilterEditor$DirBaton.myAmbientDepth == SVNDepth.EMPTY && (sVNEntry = this.myWCAccess.getEntry(new File(this.myAnchor, string), false)) == null) {
            ((SVNAmbientDepthFilterEditor$FileBaton)object).myIsAmbientlyExcluded = true;
        }
        return object;
    }

    private SVNAmbientDepthFilterEditor$DirBaton makeDirBaton(String string, SVNAmbientDepthFilterEditor$DirBaton sVNAmbientDepthFilterEditor$DirBaton) {
        SVNEntry sVNEntry;
        Object object;
        if (sVNAmbientDepthFilterEditor$DirBaton != null && string == null) {
            object = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "aborting in SVNAmbientDepthFilterEditor.makeDirBation(): parentBaton != null while path == null");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        if (sVNAmbientDepthFilterEditor$DirBaton != null && sVNAmbientDepthFilterEditor$DirBaton.myIsAmbientlyExcluded) {
            this.myDirs.addLast(sVNAmbientDepthFilterEditor$DirBaton);
            return sVNAmbientDepthFilterEditor$DirBaton;
        }
        object = new SVNAmbientDepthFilterEditor$DirBaton(this);
        this.myDirs.addLast(object);
        ((SVNAmbientDepthFilterEditor$DirBaton)object).myPath = this.myAnchor;
        if (string != null) {
            ((SVNAmbientDepthFilterEditor$DirBaton)object).myPath = new File(this.myAnchor, string);
        }
        if (sVNAmbientDepthFilterEditor$DirBaton != null && (sVNAmbientDepthFilterEditor$DirBaton.myAmbientDepth == SVNDepth.EMPTY || sVNAmbientDepthFilterEditor$DirBaton.myAmbientDepth == SVNDepth.FILES) && (sVNEntry = this.myWCAccess.getEntry(((SVNAmbientDepthFilterEditor$DirBaton)object).myPath, false)) == null) {
            ((SVNAmbientDepthFilterEditor$DirBaton)object).myIsAmbientlyExcluded = true;
            return object;
        }
        ((SVNAmbientDepthFilterEditor$DirBaton)object).myAmbientDepth = SVNDepth.UNKNOWN;
        return object;
    }
}

