/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminUtil {
    private static final byte[] FORMAT_TEXT;
    private static final byte[] README_TEXT;
    private static final boolean SKIP_README;
    private static final String BASE_EXT = ".svn-base";
    private static final String REVERT_EXT = ".svn-revert";
    private static final String WORK_EXT = ".svn-work";
    private static final String TEXT_BASE_DIR_NAME = "text-base";
    private static final String PROP_BASE_DIR_NAME = "prop-base";
    private static final String PROP_WORK_DIR_NAME = "props";
    private static final String PROP_WC_DIR_NAME = "wcprops";
    private static final String TMP_DIR_NAME = "tmp";
    private static final String DIR_PROPS_FILE = "dir-props";
    private static final String DIR_BASE_PROPS_FILE = "dir-prop-base";
    private static final String DIR_REVERT_PROPS_FILE = "dir-prop-revert";
    private static final String DIR_WC_PROPS_FILE = "dir-wcprops";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createReadmeFile(File file) {
        if (SKIP_README) {
            return;
        }
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(new File(file, "README.txt"));
            outputStream.write(README_TEXT);
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(outputStream);
                throw throwable;
            }
            SVNFileUtil.closeFile(outputStream);
        }
        SVNFileUtil.closeFile(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFormatFile(File file) {
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(new File(file, "format"));
            outputStream.write(FORMAT_TEXT);
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(outputStream);
                throw throwable;
            }
            SVNFileUtil.closeFile(outputStream);
        }
        SVNFileUtil.closeFile(outputStream);
    }

    public static String getTextBasePath(String string, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SVNFileUtil.getAdminDirectoryName());
        stringBuffer.append('/');
        if (bl2) {
            stringBuffer.append(TMP_DIR_NAME);
            stringBuffer.append('/');
        }
        stringBuffer.append(TEXT_BASE_DIR_NAME);
        stringBuffer.append('/');
        stringBuffer.append(string);
        stringBuffer.append(BASE_EXT);
        return stringBuffer.toString();
    }

    public static String getTextRevertPath(String string, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SVNFileUtil.getAdminDirectoryName());
        stringBuffer.append('/');
        if (bl2) {
            stringBuffer.append(TMP_DIR_NAME);
            stringBuffer.append('/');
        }
        stringBuffer.append(TEXT_BASE_DIR_NAME);
        stringBuffer.append('/');
        stringBuffer.append(string);
        stringBuffer.append(REVERT_EXT);
        return stringBuffer.toString();
    }

    public static String getPropPath(String string, SVNNodeKind sVNNodeKind, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SVNFileUtil.getAdminDirectoryName());
        stringBuffer.append('/');
        if (bl2) {
            stringBuffer.append(TMP_DIR_NAME);
            stringBuffer.append('/');
        }
        if (sVNNodeKind == SVNNodeKind.DIR) {
            stringBuffer.append(DIR_PROPS_FILE);
        } else {
            stringBuffer.append(PROP_WORK_DIR_NAME);
            stringBuffer.append('/');
            stringBuffer.append(string);
            stringBuffer.append(WORK_EXT);
        }
        return stringBuffer.toString();
    }

    public static String getPropBasePath(String string, SVNNodeKind sVNNodeKind, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SVNFileUtil.getAdminDirectoryName());
        stringBuffer.append('/');
        if (bl2) {
            stringBuffer.append(TMP_DIR_NAME);
            stringBuffer.append('/');
        }
        if (sVNNodeKind == SVNNodeKind.DIR) {
            stringBuffer.append(DIR_BASE_PROPS_FILE);
        } else {
            stringBuffer.append(PROP_BASE_DIR_NAME);
            stringBuffer.append('/');
            stringBuffer.append(string);
            stringBuffer.append(BASE_EXT);
        }
        return stringBuffer.toString();
    }

    public static String getPropRevertPath(String string, SVNNodeKind sVNNodeKind, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SVNFileUtil.getAdminDirectoryName());
        stringBuffer.append('/');
        if (bl2) {
            stringBuffer.append(TMP_DIR_NAME);
            stringBuffer.append('/');
        }
        if (sVNNodeKind == SVNNodeKind.DIR) {
            stringBuffer.append(DIR_REVERT_PROPS_FILE);
        } else {
            stringBuffer.append(PROP_BASE_DIR_NAME);
            stringBuffer.append('/');
            stringBuffer.append(string);
            stringBuffer.append(REVERT_EXT);
        }
        return stringBuffer.toString();
    }

    public static String getWCPropPath(String string, SVNNodeKind sVNNodeKind, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SVNFileUtil.getAdminDirectoryName());
        stringBuffer.append('/');
        if (bl2) {
            stringBuffer.append(TMP_DIR_NAME);
            stringBuffer.append('/');
        }
        if (sVNNodeKind == SVNNodeKind.DIR) {
            stringBuffer.append(DIR_WC_PROPS_FILE);
        } else {
            stringBuffer.append(PROP_WC_DIR_NAME);
            stringBuffer.append('/');
            stringBuffer.append(string);
            stringBuffer.append(WORK_EXT);
        }
        return stringBuffer.toString();
    }

    public static File createTmpFile(SVNAdminArea sVNAdminArea) {
        return SVNAdminUtil.createTmpFile(sVNAdminArea, "tempfile", ".tmp", true);
    }

    public static File createTmpFile(SVNAdminArea sVNAdminArea, String string, String string2, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SVNFileUtil.getAdminDirectoryName());
        stringBuffer.append('/');
        if (bl2) {
            stringBuffer.append(TMP_DIR_NAME);
            stringBuffer.append('/');
        }
        String string3 = stringBuffer.toString();
        File file = sVNAdminArea.getFile(string3);
        return SVNFileUtil.createUniqueFile(file, string, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getVersion(File file) {
        SVNErrorMessage sVNErrorMessage;
        File file2 = new File(file, SVNFileUtil.getAdminDirectoryName());
        File file3 = new File(file2, "entries");
        int n2 = -1;
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(file3, Level.FINEST, SVNLogType.WC), "UTF-8"));
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", file3, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
            SVNFileUtil.closeFile(bufferedReader);
        }
        catch (SVNException sVNException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
            sVNErrorMessage.setChildErrorMessage(sVNException.getErrorMessage());
            SVNErrorManager.error(sVNErrorMessage, sVNException, Level.FINEST, SVNLogType.WC);
            {
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(bufferedReader);
                    throw throwable;
                }
            }
            SVNFileUtil.closeFile(bufferedReader);
        }
        SVNFileUtil.closeFile(bufferedReader);
        if (string == null || string.length() == 0) {
            SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Reading ''{0}''", (Object)file3);
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
            sVNErrorMessage.setChildErrorMessage(sVNErrorMessage2);
            SVNErrorManager.error(sVNErrorMessage, Level.FINEST, SVNLogType.WC);
        }
        try {
            n2 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", (Object)file3);
            SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
            sVNErrorMessage3.setChildErrorMessage(sVNErrorMessage);
            SVNErrorManager.error(sVNErrorMessage3, Level.FINEST, SVNLogType.WC);
        }
        return n2;
    }

    public static void unserializeExternalFileData(SVNEntry sVNEntry, String string) {
        SVNRevision sVNRevision = SVNRevision.UNDEFINED;
        SVNRevision sVNRevision2 = SVNRevision.UNDEFINED;
        String string2 = null;
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            sVNRevision = SVNAdminUtil.parseRevision(stringBuffer);
            sVNRevision2 = SVNAdminUtil.parseRevision(stringBuffer);
            string2 = stringBuffer.toString();
        }
        sVNEntry.setExternalFilePath(string2);
        sVNEntry.setExternalFileRevision(sVNRevision2);
        sVNEntry.setExternalFilePegRevision(sVNRevision);
    }

    public static SVNRevision parseRevision(StringBuffer stringBuffer) {
        Object object;
        int n2 = stringBuffer.indexOf(":");
        if (n2 == -1) {
            object = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Found an unexpected \\0 in the file external ''{0}''", (Object)stringBuffer);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = null;
        String string = stringBuffer.substring(0, n2);
        object = string.equals(SVNRevision.HEAD.getName()) ? SVNRevision.HEAD : SVNRevision.parse(string);
        stringBuffer = stringBuffer.delete(0, n2 + 1);
        return object;
    }

    public static String serializeExternalFileData(SVNEntry sVNEntry) {
        String string = null;
        String string2 = sVNEntry.getExternalFilePath();
        SVNRevision sVNRevision = sVNEntry.getExternalFileRevision();
        SVNRevision sVNRevision2 = sVNEntry.getExternalFilePegRevision();
        if (string2 != null) {
            String string3 = SVNAdminUtil.asString(sVNRevision, string2);
            String string4 = SVNAdminUtil.asString(sVNRevision2, string2);
            string = string4 + ":" + string3 + ":" + string2;
        }
        return string;
    }

    public static String asString(SVNRevision sVNRevision, String string) {
        if (sVNRevision == SVNRevision.HEAD || SVNRevision.isValidRevisionNumber(sVNRevision.getNumber())) {
            return sVNRevision.toString();
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Illegal file external revision kind {0} for path ''{1}''", sVNRevision.toString(), string);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        return null;
    }

    static {
        String string = System.getProperty("line.separator");
        FORMAT_TEXT = new byte[]{52, 10};
        README_TEXT = ("This is a Subversion working copy administrative directory." + string + "Visit http://subversion.tigris.org/ for more information." + string).getBytes();
        SKIP_README = Boolean.getBoolean("javasvn.skipReadme") ? true : Boolean.getBoolean("svnkit.skipReadme");
    }
}

