/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminHelper {
    public static final String DUMPFILE_MAGIC_HEADER = "SVN-fs-dump-format-version";
    public static final String DUMPFILE_CONTENT_LENGTH = "Content-length";
    public static final String DUMPFILE_NODE_ACTION = "Node-action";
    public static final String DUMPFILE_NODE_COPYFROM_PATH = "Node-copyfrom-path";
    public static final String DUMPFILE_NODE_COPYFROM_REVISION = "Node-copyfrom-rev";
    public static final String DUMPFILE_NODE_KIND = "Node-kind";
    public static final String DUMPFILE_NODE_PATH = "Node-path";
    public static final String DUMPFILE_PROP_CONTENT_LENGTH = "Prop-content-length";
    public static final String DUMPFILE_PROP_DELTA = "Prop-delta";
    public static final String DUMPFILE_REVISION_NUMBER = "Revision-number";
    public static final String DUMPFILE_TEXT_CONTENT_LENGTH = "Text-content-length";
    public static final String DUMPFILE_TEXT_DELTA = "Text-delta";
    public static final String DUMPFILE_UUID = "UUID";
    public static final String DUMPFILE_TEXT_CONTENT_MD5 = "Text-content-md5";
    public static final String DUMPFILE_TEXT_CONTENT_SHA1 = "Text-content-sha1";
    public static final String DUMPFILE_TEXT_COPY_SOURCE_MD5 = "Text-copy-source-md5";
    public static final String DUMPFILE_TEXT_COPY_SOURCE_SHA1 = "Text-copy-source-sha1";
    public static final String DUMPFILE_TEXT_DELTA_BASE_MD5 = "Text-delta-base-md5";
    public static final String DUMPFILE_TEXT_DELTA_BASE_SHA1 = "Text-delta-base-sha1";
    public static final int DUMPFILE_FORMAT_VERSION = 3;
    public static final int NODE_ACTION_ADD = 1;
    public static final int NODE_ACTION_CHANGE = 0;
    public static final int NODE_ACTION_DELETE = 2;
    public static final int NODE_ACTION_REPLACE = 3;
    public static final int NODE_ACTION_UNKNOWN = -1;

    public static int writeRevisionProperties(SVNRepository sVNRepository, long l2, SVNProperties sVNProperties) {
        int n2 = 0;
        for (String string : sVNProperties.nameSet()) {
            SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string);
            if (string.startsWith("svn:sync-")) {
                ++n2;
                continue;
            }
            sVNRepository.setRevisionPropertyValue(l2, string, sVNPropertyValue);
        }
        return n2;
    }

    public static void removePropertiesNotInSource(SVNRepository sVNRepository, long l2, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        for (String string : sVNProperties2.nameSet()) {
            if (sVNProperties.getSVNPropertyValue(string) != null) continue;
            sVNRepository.setRevisionPropertyValue(l2, string, null);
        }
    }

    public static FSFS openRepository(File file, boolean bl2) {
        FSFS fSFS = new FSFS(file);
        if (bl2) {
            fSFS.open();
        } else {
            fSFS.openRoot();
            fSFS.getFSType();
        }
        return fSFS;
    }

    public static void closeRepository(FSFS fSFS) {
        if (fSFS != null) {
            try {
                fSFS.close();
            }
            catch (SVNException sVNException) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, sVNException);
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, sVNException.getMessage());
            }
        }
    }

    public static FSFS openRepositoryForRecovery(File file) {
        FSFS fSFS = new FSFS(file);
        fSFS.openForRecovery();
        return fSFS;
    }

    public static long getRevisionNumber(SVNRevision sVNRevision, long l2, FSFS fSFS) {
        SVNErrorMessage sVNErrorMessage;
        long l3 = -1L;
        if (sVNRevision.getNumber() >= 0L) {
            l3 = sVNRevision.getNumber();
        } else if (sVNRevision == SVNRevision.HEAD) {
            l3 = l2;
        } else if (sVNRevision.getDate() != null) {
            l3 = fSFS.getDatedRevision(sVNRevision.getDate());
        } else if (sVNRevision != SVNRevision.UNDEFINED) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Invalid revision specifier");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (l3 > l2) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Revisions must not be greater than the youngest revision ({0})", (Object)l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        return l3;
    }

    public static void writeProperties(SVNProperties sVNProperties, SVNProperties sVNProperties2, OutputStream outputStream) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object : sVNProperties.nameSet()) {
            if ("svn:log".equals(object)) {
                linkedList.addFirst(object);
                continue;
            }
            if ("svn:author".equals(object)) {
                if (linkedList.contains("svn:log")) {
                    int n2 = linkedList.indexOf("svn:log");
                    linkedList.add(n2 + 1, object);
                    continue;
                }
                linkedList.addFirst(object);
                continue;
            }
            linkedList.addLast(object);
        }
        for (Object object : linkedList) {
            SVNPropertyValue sVNPropertyValue;
            SVNPropertyValue sVNPropertyValue2 = sVNProperties.getSVNPropertyValue((String)object);
            if (sVNProperties2 != null && (sVNPropertyValue = sVNProperties2.getSVNPropertyValue((String)object)) != null && sVNPropertyValue.equals(sVNPropertyValue2)) continue;
            SVNWCProperties.appendProperty((String)object, sVNPropertyValue2, outputStream);
        }
        if (sVNProperties2 != null) {
            for (Object object : sVNProperties2.nameSet()) {
                if (sVNProperties.containsName((String)object)) continue;
                SVNWCProperties.appendPropertyDeleted((String)object, outputStream);
            }
        }
        try {
            Object object = "PROPS-END\n".getBytes("UTF-8");
            outputStream.write((byte[])object);
        }
        catch (IOException iOException) {
            Object object;
            object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error((SVNErrorMessage)object, iOException, SVNLogType.FSFS);
        }
    }

    public static void deltifyDir(FSFS fSFS, FSRevisionRoot fSRevisionRoot, String string, String string2, FSRevisionRoot fSRevisionRoot2, String string3, ISVNEditor iSVNEditor) {
        Object object;
        if (string == null) {
            SVNAdminHelper.generateNotADirError("source parent", string);
        }
        if (string3 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid target path");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, string2));
        SVNNodeKind sVNNodeKind = fSRevisionRoot2.checkNodeKind(string3);
        SVNNodeKind sVNNodeKind2 = fSRevisionRoot.checkNodeKind((String)object);
        if (sVNNodeKind == SVNNodeKind.NONE && sVNNodeKind2 == SVNNodeKind.NONE) {
            iSVNEditor.closeEdit();
            return;
        }
        if (string2 == null && (sVNNodeKind2 != SVNNodeKind.DIR || sVNNodeKind != SVNNodeKind.DIR)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid editor anchoring; at least one of the input paths is not a directory and there was no source entry");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        iSVNEditor.targetRevision(fSRevisionRoot2.getRevision());
        long l2 = fSRevisionRoot.getRevision();
        if (sVNNodeKind == SVNNodeKind.NONE) {
            iSVNEditor.openRoot(l2);
            iSVNEditor.deleteEntry(string2, -1L);
            iSVNEditor.closeDir();
            iSVNEditor.closeEdit();
            return;
        }
        if (sVNNodeKind2 == SVNNodeKind.NONE) {
            iSVNEditor.openRoot(l2);
            SVNAdminHelper.addFileOrDir(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, string3, string2, sVNNodeKind);
            iSVNEditor.closeDir();
            iSVNEditor.closeEdit();
            return;
        }
        FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode((String)object);
        FSRevisionNode fSRevisionNode2 = fSRevisionRoot2.getRevisionNode(string3);
        int n2 = fSRevisionNode.getId().compareTo(fSRevisionNode2.getId());
        if (n2 == 0) {
            iSVNEditor.closeEdit();
            return;
        }
        if (string2 != null) {
            if (sVNNodeKind2 != sVNNodeKind || n2 == -1) {
                iSVNEditor.openRoot(l2);
                iSVNEditor.deleteEntry(string2, -1L);
                SVNAdminHelper.addFileOrDir(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, string3, string2, sVNNodeKind);
            } else {
                iSVNEditor.openRoot(l2);
                SVNAdminHelper.replaceFileOrDir(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, (String)object, string3, string2, sVNNodeKind);
            }
            iSVNEditor.closeDir();
            iSVNEditor.closeEdit();
        } else {
            iSVNEditor.openRoot(l2);
            SVNAdminHelper.deltifyDirs(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, (String)object, string3, "");
            iSVNEditor.closeDir();
            iSVNEditor.closeEdit();
        }
    }

    public static void generateIncompleteDataError() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, new Exception());
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Premature end of content data in dumpstream");
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
    }

    public static void generateStreamMalformedError() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, new Exception());
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Dumpstream data appears to be malformed");
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
    }

    public static int readKeyOrValue(InputStream inputStream, byte[] byArray, int n2) {
        int n3;
        int n4 = 0;
        while (n2 - n4 > 0 && (n3 = inputStream.read(byArray, n4, n2 - n4)) >= 0) {
            n4 += n3;
        }
        if (n4 != n2) {
            SVNAdminHelper.generateIncompleteDataError();
        }
        if (byArray[n2 - 1] != 10) {
            SVNAdminHelper.generateStreamMalformedError();
        }
        return n4 - 1;
    }

    private static void addFileOrDir(FSFS fSFS, ISVNEditor iSVNEditor, FSRevisionRoot fSRevisionRoot, FSRevisionRoot fSRevisionRoot2, String string, String string2, SVNNodeKind sVNNodeKind) {
        if (sVNNodeKind == SVNNodeKind.DIR) {
            iSVNEditor.addDir(string2, null, -1L);
            SVNAdminHelper.deltifyDirs(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, null, string, string2);
            iSVNEditor.closeDir();
        } else {
            iSVNEditor.addFile(string2, null, -1L);
            SVNAdminHelper.deltifyFiles(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, null, string, string2);
            FSRevisionNode fSRevisionNode = fSRevisionRoot2.getRevisionNode(string);
            iSVNEditor.closeFile(string2, fSRevisionNode.getFileMD5Checksum());
        }
    }

    private static void replaceFileOrDir(FSFS fSFS, ISVNEditor iSVNEditor, FSRevisionRoot fSRevisionRoot, FSRevisionRoot fSRevisionRoot2, String string, String string2, String string3, SVNNodeKind sVNNodeKind) {
        long l2 = fSRevisionRoot.getRevision();
        if (sVNNodeKind == SVNNodeKind.DIR) {
            iSVNEditor.openDir(string3, l2);
            SVNAdminHelper.deltifyDirs(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, string, string2, string3);
            iSVNEditor.closeDir();
        } else {
            iSVNEditor.openFile(string3, l2);
            SVNAdminHelper.deltifyFiles(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, string, string2, string3);
            FSRevisionNode fSRevisionNode = fSRevisionRoot2.getRevisionNode(string2);
            iSVNEditor.closeFile(string3, fSRevisionNode.getFileMD5Checksum());
        }
    }

    private static void deltifyFiles(FSFS fSFS, ISVNEditor iSVNEditor, FSRevisionRoot fSRevisionRoot, FSRevisionRoot fSRevisionRoot2, String string, String string2, String string3) {
        SVNAdminHelper.deltifyProperties(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, string, string2, string3, false);
        boolean bl2 = false;
        if (string != null) {
            bl2 = FSRepositoryUtil.areFileContentsChanged(fSRevisionRoot, string, fSRevisionRoot2, string2);
        }
        if (bl2) {
            String string4 = null;
            if (string != null) {
                FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string);
                string4 = fSRevisionNode.getFileMD5Checksum();
            }
            iSVNEditor.applyTextDelta(string3, string4);
            iSVNEditor.textDeltaChunk(string3, SVNDiffWindow.EMPTY);
        }
    }

    private static void deltifyDirs(FSFS fSFS, ISVNEditor iSVNEditor, FSRevisionRoot fSRevisionRoot, FSRevisionRoot fSRevisionRoot2, String string, String string2, String string3) {
        Object object;
        FSEntry fSEntry;
        SVNAdminHelper.deltifyProperties(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, string, string2, string3, true);
        FSRevisionNode fSRevisionNode = fSRevisionRoot2.getRevisionNode(string2);
        Map map = fSRevisionNode.getDirEntries(fSFS);
        Map map2 = null;
        if (string != null) {
            Iterator iterator = fSRevisionRoot.getRevisionNode(string);
            map2 = ((FSRevisionNode)((Object)iterator)).getDirEntries(fSFS);
        }
        for (String string4 : map.keySet()) {
            fSEntry = (FSEntry)map.get(string4);
            object = fSEntry.getType();
            String string5 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string2, fSEntry.getName()));
            String string6 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string3, fSEntry.getName()));
            if (map2 != null && map2.containsKey(string4)) {
                FSEntry fSEntry2 = (FSEntry)map2.get(string4);
                String string7 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, fSEntry.getName()));
                SVNNodeKind sVNNodeKind = fSEntry2.getType();
                int n2 = fSEntry2.getId().compareTo(fSEntry.getId());
                if (sVNNodeKind != object || n2 == -1) {
                    iSVNEditor.deleteEntry(string6, -1L);
                    SVNAdminHelper.addFileOrDir(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, string5, string6, (SVNNodeKind)object);
                } else if (n2 != 0) {
                    SVNAdminHelper.replaceFileOrDir(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, string7, string5, string6, (SVNNodeKind)object);
                }
                map2.remove(string4);
                continue;
            }
            SVNAdminHelper.addFileOrDir(fSFS, iSVNEditor, fSRevisionRoot, fSRevisionRoot2, string5, string6, (SVNNodeKind)object);
        }
        if (map2 != null) {
            for (String string4 : map2.keySet()) {
                fSEntry = (FSEntry)map2.get(string4);
                object = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string3, fSEntry.getName()));
                iSVNEditor.deleteEntry((String)object, -1L);
            }
        }
    }

    private static void deltifyProperties(FSFS fSFS, ISVNEditor iSVNEditor, FSRevisionRoot fSRevisionRoot, FSRevisionRoot fSRevisionRoot2, String string, String string2, String string3, boolean bl2) {
        Object object;
        FSRevisionNode fSRevisionNode = fSRevisionRoot2.getRevisionNode(string2);
        SVNProperties sVNProperties = null;
        if (string != null) {
            boolean bl3;
            object = fSRevisionRoot.getRevisionNode(string);
            boolean bl4 = bl3 = !FSRepositoryUtil.arePropertiesEqual((FSRevisionNode)object, fSRevisionNode);
            if (!bl3) {
                return;
            }
            sVNProperties = ((FSRevisionNode)object).getProperties(fSFS);
        } else {
            sVNProperties = new SVNProperties();
        }
        object = fSRevisionNode.getProperties(fSFS);
        SVNProperties sVNProperties2 = FSRepositoryUtil.getPropsDiffs(sVNProperties, (SVNProperties)object);
        Object[] objectArray = sVNProperties2.nameSet().toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string4 = (String)objectArray[i2];
            SVNPropertyValue sVNPropertyValue = sVNProperties2.getSVNPropertyValue(string4);
            if (bl2) {
                iSVNEditor.changeDirProperty(string4, sVNPropertyValue);
                continue;
            }
            iSVNEditor.changeFileProperty(string3, string4, sVNPropertyValue);
        }
    }

    private static void generateNotADirError(String string, String string2) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Invalid {0} directory ''{1}''", string, string2 != null ? string2 : "(null)");
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
    }
}

