/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminDeltifier {
    private FSFS myFSFS;
    private SVNDepth myDepth;
    private boolean myIsIncludeEntryProperties;
    private boolean myIsIgnoreAncestry;
    private boolean myIsSendTextDeltas;
    private ISVNEditor myEditor;
    private SVNDeltaCombiner myDeltaCombiner;
    private SVNDeltaGenerator myDeltaGenerator;

    public SVNAdminDeltifier(FSFS fSFS, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, ISVNEditor iSVNEditor) {
        this.myFSFS = fSFS;
        this.myDepth = sVNDepth;
        this.myIsIncludeEntryProperties = bl2;
        this.myIsIgnoreAncestry = bl3;
        this.myIsSendTextDeltas = bl4;
        this.myEditor = iSVNEditor;
        this.myDeltaCombiner = new SVNDeltaCombiner();
        this.myDeltaGenerator = new SVNDeltaGenerator();
    }

    public void setEditor(ISVNEditor iSVNEditor) {
        this.myEditor = iSVNEditor;
    }

    public void deltifyDir(FSRevisionRoot fSRevisionRoot, String string, String string2, FSRevisionRoot fSRevisionRoot2, String string3) {
        Object object;
        if (string == null) {
            SVNAdminDeltifier.generateNotADirError("source parent", string);
        }
        if (string3 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid target path");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, string2));
        SVNNodeKind sVNNodeKind = fSRevisionRoot2.checkNodeKind(string3);
        SVNNodeKind sVNNodeKind2 = fSRevisionRoot.checkNodeKind((String)object);
        if (sVNNodeKind == SVNNodeKind.NONE && sVNNodeKind2 == SVNNodeKind.NONE) {
            this.myEditor.closeEdit();
            return;
        }
        if (string2 == null && (sVNNodeKind2 != SVNNodeKind.DIR || sVNNodeKind != SVNNodeKind.DIR)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid editor anchoring; at least one of the input paths is not a directory and there was no source entry");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        this.myEditor.targetRevision(fSRevisionRoot2.getRevision());
        long l2 = fSRevisionRoot.getRevision();
        if (sVNNodeKind == SVNNodeKind.NONE) {
            this.myEditor.openRoot(l2);
            this.myEditor.deleteEntry(string2, -1L);
            this.myEditor.closeDir();
            this.myEditor.closeEdit();
            return;
        }
        if (sVNNodeKind2 == SVNNodeKind.NONE) {
            this.myEditor.openRoot(l2);
            this.addFileOrDir(fSRevisionRoot, fSRevisionRoot2, string3, string2, sVNNodeKind);
            this.myEditor.closeDir();
            this.myEditor.closeEdit();
            return;
        }
        FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode((String)object);
        FSRevisionNode fSRevisionNode2 = fSRevisionRoot2.getRevisionNode(string3);
        int n2 = fSRevisionNode.getId().compareTo(fSRevisionNode2.getId());
        if (n2 == 0) {
            this.myEditor.closeEdit();
        } else if (string2 != null) {
            if (sVNNodeKind2 != sVNNodeKind || n2 == -1) {
                this.myEditor.openRoot(l2);
                this.myEditor.deleteEntry(string2, -1L);
                this.addFileOrDir(fSRevisionRoot, fSRevisionRoot2, string3, string2, sVNNodeKind);
            } else {
                this.myEditor.openRoot(l2);
                this.replaceFileOrDir(fSRevisionRoot, fSRevisionRoot2, (String)object, string3, string2, sVNNodeKind);
            }
            this.myEditor.closeDir();
            this.myEditor.closeEdit();
        } else {
            this.myEditor.openRoot(l2);
            this.deltifyDirs(fSRevisionRoot, fSRevisionRoot2, (String)object, string3, "");
            this.myEditor.closeDir();
            this.myEditor.closeEdit();
        }
    }

    private void addFileOrDir(FSRevisionRoot fSRevisionRoot, FSRevisionRoot fSRevisionRoot2, String string, String string2, SVNNodeKind sVNNodeKind) {
        if (sVNNodeKind == SVNNodeKind.DIR) {
            this.myEditor.addDir(string2, null, -1L);
            this.deltifyDirs(fSRevisionRoot, fSRevisionRoot2, null, string, string2);
            this.myEditor.closeDir();
        } else {
            this.myEditor.addFile(string2, null, -1L);
            this.deltifyFiles(fSRevisionRoot, fSRevisionRoot2, null, string, string2);
            FSRevisionNode fSRevisionNode = fSRevisionRoot2.getRevisionNode(string);
            this.myEditor.closeFile(string2, fSRevisionNode.getFileMD5Checksum());
        }
    }

    private void deltifyDirs(FSRevisionRoot fSRevisionRoot, FSRevisionRoot fSRevisionRoot2, String string, String string2, String string3) {
        Object object;
        FSEntry fSEntry;
        this.deltifyProperties(fSRevisionRoot, fSRevisionRoot2, string, string2, string3, true);
        FSRevisionNode fSRevisionNode = fSRevisionRoot2.getRevisionNode(string2);
        Map map = fSRevisionNode.getDirEntries(this.myFSFS);
        Map map2 = null;
        if (string != null) {
            Iterator iterator = fSRevisionRoot.getRevisionNode(string);
            map2 = ((FSRevisionNode)((Object)iterator)).getDirEntries(this.myFSFS);
        }
        for (String string4 : map.keySet()) {
            fSEntry = (FSEntry)map.get(string4);
            object = fSEntry.getType();
            String string5 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string2, fSEntry.getName()));
            String string6 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string3, fSEntry.getName()));
            if (map2 != null && map2.containsKey(string4)) {
                FSEntry fSEntry2 = (FSEntry)map2.get(string4);
                String string7 = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string, fSEntry.getName()));
                SVNNodeKind sVNNodeKind = fSEntry2.getType();
                if (this.myDepth == SVNDepth.INFINITY || sVNNodeKind != SVNNodeKind.DIR) {
                    int n2 = fSEntry2.getId().compareTo(fSEntry.getId());
                    if (sVNNodeKind != object || n2 == -1 && !this.myIsIgnoreAncestry) {
                        this.myEditor.deleteEntry(string6, -1L);
                        this.addFileOrDir(fSRevisionRoot, fSRevisionRoot2, string5, string6, (SVNNodeKind)object);
                    } else if (n2 != 0) {
                        this.replaceFileOrDir(fSRevisionRoot, fSRevisionRoot2, string7, string5, string6, (SVNNodeKind)object);
                    }
                }
                map2.remove(string4);
                continue;
            }
            if (this.myDepth != SVNDepth.INFINITY && object == SVNNodeKind.DIR) continue;
            this.addFileOrDir(fSRevisionRoot, fSRevisionRoot2, string5, string6, (SVNNodeKind)object);
        }
        if (map2 != null) {
            for (String string4 : map2.keySet()) {
                fSEntry = (FSEntry)map2.get(string4);
                object = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string3, fSEntry.getName()));
                if (this.myDepth != SVNDepth.INFINITY && fSEntry.getType() == SVNNodeKind.DIR) continue;
                this.myEditor.deleteEntry((String)object, -1L);
            }
        }
    }

    private void replaceFileOrDir(FSRevisionRoot fSRevisionRoot, FSRevisionRoot fSRevisionRoot2, String string, String string2, String string3, SVNNodeKind sVNNodeKind) {
        long l2 = fSRevisionRoot.getRevision();
        if (sVNNodeKind == SVNNodeKind.DIR) {
            this.myEditor.openDir(string3, l2);
            this.deltifyDirs(fSRevisionRoot, fSRevisionRoot2, string, string2, string3);
            this.myEditor.closeDir();
        } else {
            this.myEditor.openFile(string3, l2);
            this.deltifyFiles(fSRevisionRoot, fSRevisionRoot2, string, string2, string3);
            FSRevisionNode fSRevisionNode = fSRevisionRoot2.getRevisionNode(string2);
            this.myEditor.closeFile(string3, fSRevisionNode.getFileMD5Checksum());
        }
    }

    private void deltifyFiles(FSRevisionRoot fSRevisionRoot, FSRevisionRoot fSRevisionRoot2, String string, String string2, String string3) {
        this.deltifyProperties(fSRevisionRoot, fSRevisionRoot2, string, string2, string3, false);
        boolean bl2 = false;
        if (string != null) {
            bl2 = this.myIsIgnoreAncestry ? FSRepositoryUtil.checkFilesDifferent(fSRevisionRoot, string, fSRevisionRoot2, string2, this.myDeltaCombiner) : FSRepositoryUtil.areFileContentsChanged(fSRevisionRoot, string, fSRevisionRoot2, string2);
        }
        if (bl2) {
            String string4 = null;
            if (string != null) {
                FSRevisionNode fSRevisionNode = fSRevisionRoot.getRevisionNode(string);
                string4 = fSRevisionNode.getFileMD5Checksum();
            }
            FSRepositoryUtil.sendTextDelta(this.myEditor, string3, string, string4, fSRevisionRoot, string2, fSRevisionRoot2, this.myIsSendTextDeltas, this.myDeltaCombiner, this.myDeltaGenerator, this.myFSFS);
        }
    }

    private void deltifyProperties(FSRevisionRoot fSRevisionRoot, FSRevisionRoot fSRevisionRoot2, String string, String string2, String string3, boolean bl2) {
        Object object;
        String string4;
        Object object2;
        FSRevisionNode fSRevisionNode;
        long l2;
        if (this.myIsIncludeEntryProperties && SVNRevision.isValidRevisionNumber(l2 = (fSRevisionNode = fSRevisionRoot2.getRevisionNode(string2)).getCreatedRevision())) {
            String string5;
            if (bl2) {
                this.myEditor.changeDirProperty("svn:entry:committed-rev", SVNPropertyValue.create(String.valueOf(l2)));
            } else {
                this.myEditor.changeFileProperty(string3, "svn:entry:committed-rev", SVNPropertyValue.create(String.valueOf(l2)));
            }
            SVNProperties sVNProperties = this.myFSFS.getRevisionProperties(l2);
            object2 = sVNProperties.getStringValue("svn:date");
            if (object2 != null || string != null) {
                if (bl2) {
                    this.myEditor.changeDirProperty("svn:entry:committed-date", SVNPropertyValue.create((String)object2));
                } else {
                    this.myEditor.changeFileProperty(string3, "svn:entry:committed-date", SVNPropertyValue.create((String)object2));
                }
            }
            if ((string5 = sVNProperties.getStringValue("svn:author")) != null || string != null) {
                if (bl2) {
                    this.myEditor.changeDirProperty("svn:entry:last-author", SVNPropertyValue.create(string5));
                } else {
                    this.myEditor.changeFileProperty(string3, "svn:entry:last-author", SVNPropertyValue.create(string5));
                }
            }
            string4 = this.myFSFS.getUUID();
            if (bl2) {
                this.myEditor.changeDirProperty("svn:entry:uuid", SVNPropertyValue.create(string4));
            } else {
                this.myEditor.changeFileProperty(string3, "svn:entry:uuid", SVNPropertyValue.create(string4));
            }
        }
        fSRevisionNode = fSRevisionRoot2.getRevisionNode(string2);
        SVNProperties sVNProperties = null;
        if (string != null) {
            boolean bl3;
            object = fSRevisionRoot.getRevisionNode(string);
            boolean bl4 = bl3 = !FSRepositoryUtil.arePropertiesEqual((FSRevisionNode)object, fSRevisionNode);
            if (!bl3) {
                return;
            }
            sVNProperties = ((FSRevisionNode)object).getProperties(this.myFSFS);
        } else {
            sVNProperties = new SVNProperties();
        }
        object = fSRevisionNode.getProperties(this.myFSFS);
        SVNProperties sVNProperties2 = FSRepositoryUtil.getPropsDiffs(sVNProperties, (SVNProperties)object);
        object2 = sVNProperties2.nameSet().toArray();
        for (int i2 = 0; i2 < ((Object[])object2).length; ++i2) {
            string4 = (String)object2[i2];
            SVNPropertyValue sVNPropertyValue = sVNProperties2.getSVNPropertyValue(string4);
            if (bl2) {
                this.myEditor.changeDirProperty(string4, sVNPropertyValue);
                continue;
            }
            this.myEditor.changeFileProperty(string3, string4, sVNPropertyValue);
        }
    }

    private static void generateNotADirError(String string, String string2) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Invalid {0} directory ''{1}''", string, string2 != null ? string2 : "(null)");
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
    }
}

