/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.line.QSequenceLine;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineMedia;
import de.regnis.q.sequence.line.QSequenceLineRAData;
import de.regnis.q.sequence.line.QSequenceLineResult;
import de.regnis.q.sequence.line.simplifier.QSequenceLineDummySimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineEOLUnifyingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineTeeSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceReducingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceSkippingSimplifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.svn.core.internal.wc.FSMergerBySequenceList;
import org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;

public class FSMergerBySequence {
    public static final String DEFAULT_EOL = System.getProperty("line.separator");
    public static final int NOT_MODIFIED = 0;
    public static final int MERGED = 4;
    public static final int CONFLICTED = 2;
    private final byte[] myConflictStart;
    private final byte[] myConflictSeparator;
    private final byte[] myConflictEnd;
    private final byte[] myOriginalMarker;

    public FSMergerBySequence(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this(byArray, byArray2, byArray3, null);
    }

    public FSMergerBySequence(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.myConflictStart = byArray;
        this.myConflictSeparator = byArray2;
        this.myConflictEnd = byArray3;
        this.myOriginalMarker = byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int merge(QSequenceLineRAData qSequenceLineRAData, QSequenceLineRAData qSequenceLineRAData2, QSequenceLineRAData qSequenceLineRAData3, SVNDiffOptions sVNDiffOptions, OutputStream outputStream, SVNDiffConflictChoiceStyle sVNDiffConflictChoiceStyle) {
        QSequenceLineResult qSequenceLineResult;
        QSequenceLineResult qSequenceLineResult2;
        sVNDiffConflictChoiceStyle = sVNDiffConflictChoiceStyle == null ? SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST : sVNDiffConflictChoiceStyle;
        QSequenceLineTeeSimplifier qSequenceLineTeeSimplifier = this.createSimplifier(sVNDiffOptions);
        try {
            qSequenceLineResult2 = QSequenceLineMedia.createBlocks(qSequenceLineRAData, qSequenceLineRAData2, qSequenceLineTeeSimplifier);
            qSequenceLineResult = QSequenceLineMedia.createBlocks(qSequenceLineRAData, qSequenceLineRAData3, qSequenceLineTeeSimplifier);
        }
        catch (QSequenceException qSequenceException) {
            throw new IOException(qSequenceException.getMessage());
        }
        try {
            QSequenceLineCache qSequenceLineCache = qSequenceLineResult2.getLeftCache();
            QSequenceLineCache qSequenceLineCache2 = qSequenceLineResult2.getRightCache();
            QSequenceLineCache qSequenceLineCache3 = qSequenceLineResult.getRightCache();
            FSMergerBySequenceList fSMergerBySequenceList = new FSMergerBySequenceList(qSequenceLineResult2.getBlocks());
            FSMergerBySequenceList fSMergerBySequenceList2 = new FSMergerBySequenceList(qSequenceLineResult.getBlocks());
            List list = this.transformLocalLines(qSequenceLineResult2.getBlocks(), qSequenceLineCache2);
            int n2 = -1;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_ONLY_CONFLICTS;
            OutputStream outputStream2 = outputStream;
            if (bl4) {
                outputStream = SVNFileUtil.DUMMY_OUT;
            }
            while (fSMergerBySequenceList.hasCurrent() || fSMergerBySequenceList2.hasCurrent()) {
                if (fSMergerBySequenceList.hasCurrent() && fSMergerBySequenceList2.hasCurrent() && this.isEqualChange(fSMergerBySequenceList.current(), fSMergerBySequenceList2.current(), qSequenceLineCache2, qSequenceLineCache3)) {
                    n2 = this.appendLines(outputStream, fSMergerBySequenceList.current(), qSequenceLineCache2, n2, list);
                    fSMergerBySequenceList.forward();
                    fSMergerBySequenceList2.forward();
                    continue;
                }
                if (fSMergerBySequenceList.hasCurrent() && fSMergerBySequenceList2.hasCurrent()) {
                    QSequenceDifferenceBlock qSequenceDifferenceBlock = fSMergerBySequenceList.current();
                    QSequenceDifferenceBlock qSequenceDifferenceBlock2 = fSMergerBySequenceList2.current();
                    if (this.checkConflict(fSMergerBySequenceList, fSMergerBySequenceList2, qSequenceLineCache2, qSequenceLineCache3, qSequenceLineCache.getLineCount())) {
                        if (sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_LATEST) {
                            n2 = this.createConflict(outputStream, qSequenceDifferenceBlock, fSMergerBySequenceList.current(), qSequenceDifferenceBlock2, fSMergerBySequenceList2.current(), qSequenceLineCache2, qSequenceLineCache3, n2, list, sVNDiffConflictChoiceStyle);
                            fSMergerBySequenceList.forward();
                            fSMergerBySequenceList2.forward();
                            bl3 = true;
                            continue;
                        }
                        if (sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED) {
                            n2 = this.createConflict(outputStream, qSequenceDifferenceBlock, fSMergerBySequenceList.current(), qSequenceDifferenceBlock2, fSMergerBySequenceList2.current(), qSequenceLineCache2, qSequenceLineCache3, n2, list, sVNDiffConflictChoiceStyle);
                            fSMergerBySequenceList.forward();
                            fSMergerBySequenceList2.forward();
                            bl3 = true;
                            continue;
                        }
                        if (sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST || sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_ORIGINAL_LATEST) {
                            n2 = this.createConflict(outputStream, qSequenceDifferenceBlock, fSMergerBySequenceList.current(), qSequenceDifferenceBlock2, fSMergerBySequenceList2.current(), qSequenceLineCache2, qSequenceLineCache3, n2, list, sVNDiffConflictChoiceStyle);
                            fSMergerBySequenceList.forward();
                            fSMergerBySequenceList2.forward();
                            bl2 = true;
                            continue;
                        }
                        if (sVNDiffConflictChoiceStyle != SVNDiffConflictChoiceStyle.CHOOSE_ONLY_CONFLICTS) continue;
                        n2 = this.createOnlyConflictWithContext(outputStream2, qSequenceDifferenceBlock, fSMergerBySequenceList.current(), qSequenceDifferenceBlock2, fSMergerBySequenceList2.current(), qSequenceLineCache2, qSequenceLineCache3, qSequenceLineCache);
                        fSMergerBySequenceList.forward();
                        fSMergerBySequenceList2.forward();
                        bl2 = true;
                        continue;
                    }
                }
                if (fSMergerBySequenceList.hasCurrent() && this.isBefore(fSMergerBySequenceList.current(), fSMergerBySequenceList2.hasCurrent() ? fSMergerBySequenceList2.current() : null)) {
                    n2 = this.appendLines(outputStream, fSMergerBySequenceList.current(), qSequenceLineCache2, n2, list);
                    fSMergerBySequenceList.forward();
                    bl3 = true;
                    continue;
                }
                if (!fSMergerBySequenceList2.hasCurrent()) continue;
                n2 = this.appendLines(outputStream, fSMergerBySequenceList2.current(), qSequenceLineCache3, n2, list);
                fSMergerBySequenceList2.forward();
                bl3 = true;
            }
            this.appendTransformedLocalLines(n2, qSequenceLineCache.getLineCount(), list, outputStream);
            if (bl2) {
                int n3 = 2;
                return n3;
            }
            if (bl3) {
                int n4 = 4;
                return n4;
            }
            int n5 = 0;
            return n5;
        }
        finally {
            qSequenceLineResult.close();
            qSequenceLineResult2.close();
        }
    }

    private List transformLocalLines(List list, QSequenceLineCache qSequenceLineCache) {
        ArrayList<QSequenceLine> arrayList = new ArrayList<QSequenceLine>();
        FSMergerBySequenceList fSMergerBySequenceList = new FSMergerBySequenceList(list);
        int n2 = 0;
        int n3 = 0;
        while (n2 < qSequenceLineCache.getLineCount()) {
            int n4;
            if (fSMergerBySequenceList.hasCurrent()) {
                QSequenceDifferenceBlock qSequenceDifferenceBlock = fSMergerBySequenceList.current();
                n4 = qSequenceDifferenceBlock.getLeftFrom() - 1;
            } else {
                n4 = Integer.MAX_VALUE;
            }
            while (n2 < qSequenceLineCache.getLineCount() && n3 <= n4) {
                arrayList.add(qSequenceLineCache.getLine(n2));
                ++n2;
                ++n3;
            }
            if (!fSMergerBySequenceList.hasCurrent()) continue;
            for (int i2 = 0; i2 < fSMergerBySequenceList.current().getLeftSize(); ++i2) {
                arrayList.add(null);
            }
            n3 += fSMergerBySequenceList.current().getLeftSize();
            n2 += fSMergerBySequenceList.current().getRightSize();
            fSMergerBySequenceList.forward();
        }
        return arrayList;
    }

    private boolean isBefore(QSequenceDifferenceBlock qSequenceDifferenceBlock, QSequenceDifferenceBlock qSequenceDifferenceBlock2) {
        return qSequenceDifferenceBlock != null && (qSequenceDifferenceBlock2 == null || qSequenceDifferenceBlock.getLeftTo() < qSequenceDifferenceBlock2.getLeftFrom());
    }

    private boolean intersect(QSequenceDifferenceBlock qSequenceDifferenceBlock, QSequenceDifferenceBlock qSequenceDifferenceBlock2, int n2) {
        int n3 = qSequenceDifferenceBlock.getLeftFrom();
        int n4 = qSequenceDifferenceBlock2.getLeftFrom();
        int n5 = qSequenceDifferenceBlock.getLeftTo();
        int n6 = qSequenceDifferenceBlock2.getLeftTo();
        if (n5 < n3) {
            if (n6 < n4) {
                return n3 == n4;
            }
            if (n3 == n2 && n6 >= n2 - 1) {
                return true;
            }
            return n3 >= n4 && n3 <= n6;
        }
        if (n6 < n4) {
            if (n4 == n2 && n5 >= n2 - 1) {
                return true;
            }
            return n4 >= n3 && n4 <= n5;
        }
        return n3 >= n4 && n3 <= n6 || n4 >= n3 && n4 <= n5;
    }

    private int appendLines(OutputStream outputStream, QSequenceDifferenceBlock qSequenceDifferenceBlock, QSequenceLineCache qSequenceLineCache, int n2, List list) {
        this.appendTransformedLocalLines(n2, qSequenceDifferenceBlock.getLeftFrom(), list, outputStream);
        for (int i2 = qSequenceDifferenceBlock.getRightFrom(); i2 <= qSequenceDifferenceBlock.getRightTo(); ++i2) {
            this.writeLine(outputStream, qSequenceLineCache.getLine(i2));
        }
        return qSequenceDifferenceBlock.getLeftTo();
    }

    private boolean isEqualChange(QSequenceDifferenceBlock qSequenceDifferenceBlock, QSequenceDifferenceBlock qSequenceDifferenceBlock2, QSequenceLineCache qSequenceLineCache, QSequenceLineCache qSequenceLineCache2) {
        if (qSequenceDifferenceBlock.getLeftFrom() != qSequenceDifferenceBlock2.getLeftFrom() || qSequenceDifferenceBlock.getLeftTo() != qSequenceDifferenceBlock2.getLeftTo()) {
            return false;
        }
        if (qSequenceDifferenceBlock.getRightTo() - qSequenceDifferenceBlock.getRightFrom() != qSequenceDifferenceBlock2.getRightTo() - qSequenceDifferenceBlock2.getRightFrom()) {
            return false;
        }
        for (int i2 = 0; i2 < qSequenceDifferenceBlock.getRightTo() - qSequenceDifferenceBlock.getRightFrom() + 1; ++i2) {
            QSequenceLine qSequenceLine;
            QSequenceLine qSequenceLine2 = qSequenceLineCache.getLine(qSequenceDifferenceBlock.getRightFrom() + i2);
            if (qSequenceLine2.equals(qSequenceLine = qSequenceLineCache2.getLine(qSequenceDifferenceBlock2.getRightFrom() + i2))) continue;
            return false;
        }
        return true;
    }

    private boolean checkConflict(FSMergerBySequenceList fSMergerBySequenceList, FSMergerBySequenceList fSMergerBySequenceList2, QSequenceLineCache qSequenceLineCache, QSequenceLineCache qSequenceLineCache2, int n2) {
        boolean bl2 = false;
        while (this.intersect(fSMergerBySequenceList.current(), fSMergerBySequenceList2.current(), n2) && !this.isEqualChange(fSMergerBySequenceList.current(), fSMergerBySequenceList2.current(), qSequenceLineCache, qSequenceLineCache2)) {
            bl2 = true;
            if (fSMergerBySequenceList.current().getLeftTo() <= fSMergerBySequenceList2.current().getLeftTo()) {
                if (!fSMergerBySequenceList.hasNext() || !this.intersect(fSMergerBySequenceList.peekNext(), fSMergerBySequenceList2.current(), n2)) break;
                fSMergerBySequenceList.forward();
                continue;
            }
            if (!fSMergerBySequenceList2.hasNext() || !this.intersect(fSMergerBySequenceList.current(), fSMergerBySequenceList2.peekNext(), n2)) break;
            fSMergerBySequenceList2.forward();
        }
        return bl2;
    }

    private int createConflict(OutputStream outputStream, QSequenceDifferenceBlock qSequenceDifferenceBlock, QSequenceDifferenceBlock qSequenceDifferenceBlock2, QSequenceDifferenceBlock qSequenceDifferenceBlock3, QSequenceDifferenceBlock qSequenceDifferenceBlock4, QSequenceLineCache qSequenceLineCache, QSequenceLineCache qSequenceLineCache2, int n2, List list, SVNDiffConflictChoiceStyle sVNDiffConflictChoiceStyle) {
        int n3;
        int n4 = Math.min(qSequenceDifferenceBlock.getLeftFrom(), qSequenceDifferenceBlock3.getLeftFrom());
        int n5 = Math.max(qSequenceDifferenceBlock2.getLeftTo(), qSequenceDifferenceBlock4.getLeftTo());
        this.appendTransformedLocalLines(n2, n4, list, outputStream);
        int n6 = Math.max(0, qSequenceDifferenceBlock.getRightFrom() - (qSequenceDifferenceBlock.getLeftFrom() - n4));
        int n7 = Math.min(qSequenceLineCache.getLineCount() - 1, qSequenceDifferenceBlock2.getRightTo() + (n5 - qSequenceDifferenceBlock2.getLeftTo()));
        int n8 = Math.max(0, qSequenceDifferenceBlock3.getRightFrom() - (qSequenceDifferenceBlock3.getLeftFrom() - n4));
        int n9 = Math.min(qSequenceLineCache2.getLineCount() - 1, qSequenceDifferenceBlock4.getRightTo() + (n5 - qSequenceDifferenceBlock4.getLeftTo()));
        if (sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST || sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_ORIGINAL_LATEST) {
            this.writeBytesAndEol(outputStream, this.myConflictStart);
        }
        if (sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED || sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST || sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_ORIGINAL_LATEST) {
            for (n3 = n6; n3 <= n7; ++n3) {
                this.writeLine(outputStream, qSequenceLineCache.getLine(n3));
            }
        }
        if (sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_ORIGINAL_LATEST) {
            this.writeBytesAndEol(outputStream, this.myOriginalMarker);
        }
        if (sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST || sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_ORIGINAL_LATEST) {
            this.writeBytesAndEol(outputStream, this.myConflictSeparator);
        }
        if (sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_LATEST || sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST || sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_ORIGINAL_LATEST) {
            for (n3 = n8; n3 <= n9; ++n3) {
                this.writeLine(outputStream, qSequenceLineCache2.getLine(n3));
            }
        }
        if (sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST || sVNDiffConflictChoiceStyle == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_ORIGINAL_LATEST) {
            this.writeBytesAndEol(outputStream, this.myConflictEnd);
        }
        return n5;
    }

    private int createOnlyConflictWithContext(OutputStream outputStream, QSequenceDifferenceBlock qSequenceDifferenceBlock, QSequenceDifferenceBlock qSequenceDifferenceBlock2, QSequenceDifferenceBlock qSequenceDifferenceBlock3, QSequenceDifferenceBlock qSequenceDifferenceBlock4, QSequenceLineCache qSequenceLineCache, QSequenceLineCache qSequenceLineCache2, QSequenceLineCache qSequenceLineCache3) {
        int n2;
        int n3;
        int n4 = Math.min(qSequenceDifferenceBlock.getLeftFrom(), qSequenceDifferenceBlock3.getLeftFrom());
        int n5 = Math.max(qSequenceDifferenceBlock2.getLeftTo(), qSequenceDifferenceBlock4.getLeftTo());
        int n6 = Math.max(0, qSequenceDifferenceBlock.getRightFrom() - (qSequenceDifferenceBlock.getLeftFrom() - n4));
        int n7 = Math.min(qSequenceLineCache.getLineCount() - 1, qSequenceDifferenceBlock2.getRightTo() + (n5 - qSequenceDifferenceBlock2.getLeftTo()));
        int n8 = Math.max(0, qSequenceDifferenceBlock3.getRightFrom() - (qSequenceDifferenceBlock3.getLeftFrom() - n4));
        int n9 = Math.min(qSequenceLineCache2.getLineCount() - 1, qSequenceDifferenceBlock4.getRightTo() + (n5 - qSequenceDifferenceBlock4.getLeftTo()));
        this.writeBytes(outputStream, this.myConflictStart);
        int n10 = n7 - n6 + 1;
        String string = null;
        int n11 = n6 + 1;
        string = n10 > 1 ? " (" + n11 + "," + n10 + ")" : " (" + n11 + ")";
        this.writeBytesAndEol(outputStream, string.getBytes());
        for (n3 = n6; n3 <= n7; ++n3) {
            this.writeLine(outputStream, qSequenceLineCache.getLine(n3));
        }
        this.writeBytes(outputStream, this.myOriginalMarker);
        n3 = n5 - n4 + 1;
        String string2 = null;
        int n12 = n4 + 1;
        string2 = n3 > 1 ? " (" + n12 + "," + n3 + ")" : " (" + n12 + ")";
        this.writeBytesAndEol(outputStream, string2.getBytes());
        for (n2 = n4; n2 <= n5; ++n2) {
            this.writeLine(outputStream, qSequenceLineCache3.getLine(n2));
        }
        this.writeBytesAndEol(outputStream, this.myConflictSeparator);
        for (n2 = n8; n2 <= n9; ++n2) {
            this.writeLine(outputStream, qSequenceLineCache2.getLine(n2));
        }
        this.writeBytes(outputStream, this.myConflictEnd);
        n2 = n9 - n8 + 1;
        String string3 = null;
        int n13 = n8 + 1;
        string3 = n2 > 1 ? " (" + n13 + "," + n2 + ")" : " (" + n13 + ")";
        this.writeBytesAndEol(outputStream, string3.getBytes());
        return n5;
    }

    private void appendTransformedLocalLines(int n2, int n3, List list, OutputStream outputStream) {
        ++n2;
        while (n2 < n3) {
            QSequenceLine qSequenceLine = (QSequenceLine)list.get(n2);
            if (qSequenceLine == null) {
                throw new IOException("Can not merge: sequence line is null for this base index");
            }
            this.writeLine(outputStream, qSequenceLine);
            ++n2;
        }
    }

    private void writeLine(OutputStream outputStream, QSequenceLine qSequenceLine) {
        byte[] byArray = qSequenceLine.getContentBytes();
        if (byArray.length == 0) {
            return;
        }
        outputStream.write(byArray);
    }

    private void writeBytesAndEol(OutputStream outputStream, byte[] byArray) {
        if (byArray.length > 0) {
            outputStream.write(byArray);
            outputStream.write(DEFAULT_EOL.getBytes());
        }
    }

    private void writeBytes(OutputStream outputStream, byte[] byArray) {
        if (byArray.length > 0) {
            outputStream.write(byArray);
        }
    }

    private QSequenceLineTeeSimplifier createSimplifier(SVNDiffOptions sVNDiffOptions) {
        QSequenceLineDummySimplifier qSequenceLineDummySimplifier = sVNDiffOptions != null && sVNDiffOptions.isIgnoreEOLStyle() ? new QSequenceLineEOLUnifyingSimplifier() : new QSequenceLineDummySimplifier();
        QSequenceLineSimplifier qSequenceLineSimplifier = new QSequenceLineDummySimplifier();
        if (sVNDiffOptions != null) {
            if (sVNDiffOptions.isIgnoreAllWhitespace()) {
                qSequenceLineSimplifier = new QSequenceLineWhiteSpaceSkippingSimplifier();
            } else if (sVNDiffOptions.isIgnoreAmountOfWhitespace()) {
                qSequenceLineSimplifier = new QSequenceLineWhiteSpaceReducingSimplifier();
            }
        }
        return new QSequenceLineTeeSimplifier(qSequenceLineDummySimplifier, qSequenceLineSimplifier);
    }
}

