/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil$CertificateDoesNotConformConstraints;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil$CertificateNotTrustedException;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNSSLTrustManager
implements X509TrustManager {
    private SVNURL myURL;
    private DefaultSVNAuthenticationManager myAuthManager;
    private X509Certificate[] myTrustedCerts;
    private String myRealm;
    private File myAuthDirectory;
    private boolean myIsUseKeyStore;
    private File[] myServerCertFiles;
    private X509TrustManager[] myDefaultTrustManagers;

    public DefaultSVNSSLTrustManager(File file, SVNURL sVNURL, File[] fileArray, boolean bl2, DefaultSVNAuthenticationManager defaultSVNAuthenticationManager) {
        this.myURL = sVNURL;
        this.myAuthDirectory = file;
        this.myRealm = "https://" + sVNURL.getHost() + ":" + sVNURL.getPort();
        this.myAuthManager = defaultSVNAuthenticationManager;
        this.myIsUseKeyStore = bl2;
        this.myServerCertFiles = fileArray;
    }

    private X509TrustManager[] getDefaultTrustManagers() {
        if (this.myDefaultTrustManagers == null && this.myIsUseKeyStore) {
            this.myDefaultTrustManagers = this.initDefaultTrustManagers();
        }
        return this.myDefaultTrustManagers;
    }

    private X509TrustManager[] initDefaultTrustManagers() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            if (trustManagerArray == null || trustManagerArray.length == 0) {
                return null;
            }
            ArrayList<TrustManager> arrayList = new ArrayList<TrustManager>();
            for (int i2 = 0; i2 < trustManagerArray.length; ++i2) {
                TrustManager trustManager = trustManagerArray[i2];
                if (!(trustManager instanceof X509TrustManager)) continue;
                arrayList.add(trustManager);
            }
            return arrayList.toArray(new X509TrustManager[arrayList.size()]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, noSuchAlgorithmException, Level.FINEST);
        }
        catch (KeyStoreException keyStoreException) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, keyStoreException, Level.FINEST);
        }
        return null;
    }

    private void init() {
        if (this.myTrustedCerts != null) {
            return;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (int i2 = 0; i2 < this.myServerCertFiles.length; ++i2) {
            X509Certificate x509Certificate = DefaultSVNSSLTrustManager.loadCertificate(this.myServerCertFiles[i2]);
            if (x509Certificate == null) continue;
            arrayList.add(x509Certificate);
        }
        X509TrustManager[] x509TrustManagerArray = this.getDefaultTrustManagers();
        for (int i3 = 0; x509TrustManagerArray != null && i3 < x509TrustManagerArray.length; ++i3) {
            X509TrustManager x509TrustManager = x509TrustManagerArray[i3];
            X509Certificate[] x509CertificateArray = x509TrustManager.getAcceptedIssuers();
            for (int i4 = 0; x509CertificateArray != null && i4 < x509CertificateArray.length; ++i4) {
                X509Certificate x509Certificate = x509CertificateArray[i4];
                arrayList.add(x509Certificate);
            }
        }
        this.myTrustedCerts = arrayList.toArray(new X509Certificate[arrayList.size()]);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        this.init();
        return this.myTrustedCerts;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        if (x509CertificateArray != null && x509CertificateArray.length > 0 && x509CertificateArray[0] != null) {
            String string2;
            String string3 = SVNBase64.byteArrayToBase64(x509CertificateArray[0].getEncoded());
            if (string3.equals(string2 = (String)this.myAuthManager.getRuntimeAuthStorage().getData("svn.ssl.server", this.myRealm))) {
                return;
            }
            string2 = this.getStoredServerCertificate(this.myRealm);
            if (string3.equals(string2)) {
                return;
            }
            ISVNAuthenticationProvider iSVNAuthenticationProvider = this.myAuthManager.getAuthenticationProvider();
            int n2 = SVNSSLUtil.getServerCertificateFailures(x509CertificateArray[0], this.myURL.getHost());
            if (iSVNAuthenticationProvider != null) {
                boolean bl2 = this.myAuthManager.getHostOptionsProvider().getHostOptions(this.myURL).isAuthStorageEnabled();
                CertificateException certificateException = this.checkServerTrustedByDefault(x509CertificateArray, string);
                if (certificateException != null && certificateException.getMessage().indexOf("Certificates does not conform to algorithm constraints") >= 0) {
                    throw new SVNSSLUtil$CertificateDoesNotConformConstraints("svn: Server SSL certificates chain for '" + this.myRealm + "' does not conform to algorithm constraints", certificateException);
                }
                boolean bl3 = certificateException == null;
                int n3 = bl3 ? 2 : iSVNAuthenticationProvider.acceptServerAuthentication(this.myURL, this.myRealm, x509CertificateArray[0], bl2);
                if (n3 == 2 && bl2) {
                    try {
                        this.storeServerCertificate(this.myRealm, string3, n2);
                    }
                    catch (SVNException sVNException) {
                        SVNDebugLog.getDefaultLog().logError(SVNLogType.NETWORK, sVNException);
                    }
                }
                if (n3 != 0) {
                    this.myAuthManager.getRuntimeAuthStorage().putData("svn.ssl.server", this.myRealm, string3);
                    return;
                }
                throw new SVNSSLUtil$CertificateNotTrustedException("svn: Server SSL certificate for '" + this.myRealm + "' rejected", certificateException);
            }
        }
    }

    private CertificateException checkServerTrustedByDefault(X509Certificate[] x509CertificateArray, String string) {
        X509TrustManager[] x509TrustManagerArray = this.getDefaultTrustManagers();
        if (x509TrustManagerArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < x509TrustManagerArray.length; ++i2) {
            X509TrustManager x509TrustManager = x509TrustManagerArray[i2];
            try {
                x509TrustManager.checkServerTrusted(x509CertificateArray, string);
                continue;
            }
            catch (CertificateException certificateException) {
                return certificateException;
            }
        }
        return null;
    }

    private String getStoredServerCertificate(String string) {
        File file = new File(this.myAuthDirectory, SVNFileUtil.computeChecksum(string));
        if (!file.isFile()) {
            return null;
        }
        SVNWCProperties sVNWCProperties = new SVNWCProperties(file, "");
        try {
            String string2 = sVNWCProperties.getPropertyValue("svn:realmstring");
            if (!string.equals(string2)) {
                return null;
            }
            return sVNWCProperties.getPropertyValue("ascii_cert");
        }
        catch (SVNException sVNException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeServerCertificate(String string, String string2, int n2) {
        this.myAuthDirectory.mkdirs();
        File file = new File(this.myAuthDirectory, SVNFileUtil.computeChecksum(string));
        SVNHashMap sVNHashMap = new SVNHashMap();
        sVNHashMap.put("ascii_cert", string2);
        sVNHashMap.put("svn:realmstring", string);
        sVNHashMap.put("failures", Integer.toString(n2));
        SVNFileUtil.deleteFile(file);
        File file2 = SVNFileUtil.createUniqueFile(this.myAuthDirectory, "auth", ".tmp", true);
        try {
            SVNWCProperties.setProperties(SVNProperties.wrap(sVNHashMap), file, file2, "END");
        }
        finally {
            SVNFileUtil.deleteFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadCertificate(File file) {
        InputStream inputStream = null;
        try {
            inputStream = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
        }
        catch (SVNException sVNException) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            return x509Certificate;
        }
        catch (CertificateException certificateException) {
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
    }
}

