/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNPersistentAuthenticationProvider$GnomeKeyringPasswordStorage;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNPersistentAuthenticationProvider$IPasswordStorage;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNPersistentAuthenticationProvider$MacOsKeychainPasswordStorage;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNPersistentAuthenticationProvider$SimplePasswordStorage;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNPersistentAuthenticationProvider$WinCryptPasswordStorage;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorageOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptionsProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNPersistentAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;

public class DefaultSVNPersistentAuthenticationProvider
implements ISVNAuthenticationProvider,
ISVNPersistentAuthenticationProvider {
    public static final String WINDOWS_CRYPTO_API_PASSWORD_STORAGE = "windows-cryptoapi";
    public static final String MAC_OS_KEYCHAIN_PASSWORD_STORAGE = "keychain";
    public static final String GNOME_KEYRING_PASSWORD_STORAGE = "gnome-keyring";
    public static final String SIMPLE_PASSTYPE = "simple";
    public static final String WIN_CRYPT_PASSTYPE = "wincrypt";
    public static final String MAC_OS_KEYCHAIN_PASSTYPE = "keychain";
    public static final String GNOME_KEYRING_PASSTYPE = "gnome-keyring";
    private File myDirectory;
    private String myUserName;
    private DefaultSVNPersistentAuthenticationProvider$IPasswordStorage[] myPasswordStorages;
    private ISVNAuthenticationStorageOptions myAuthOptions;
    private DefaultSVNOptions myDefaultOptions;
    private ISVNHostOptionsProvider myHostOptionsProvider;

    protected DefaultSVNPersistentAuthenticationProvider(File file, String string, ISVNAuthenticationStorageOptions iSVNAuthenticationStorageOptions, DefaultSVNOptions defaultSVNOptions, ISVNHostOptionsProvider iSVNHostOptionsProvider) {
        this.myDirectory = file;
        this.myUserName = string;
        this.myAuthOptions = iSVNAuthenticationStorageOptions;
        this.myDefaultOptions = defaultSVNOptions;
        this.myHostOptionsProvider = iSVNHostOptionsProvider;
        this.myPasswordStorages = this.createPasswordStorages(defaultSVNOptions);
    }

    protected DefaultSVNPersistentAuthenticationProvider$IPasswordStorage[] createPasswordStorages(DefaultSVNOptions defaultSVNOptions) {
        ArrayList<DefaultSVNPersistentAuthenticationProvider$IPasswordStorage> arrayList = new ArrayList<DefaultSVNPersistentAuthenticationProvider$IPasswordStorage>();
        String[] stringArray = defaultSVNOptions.getPasswordStorageTypes();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (WINDOWS_CRYPTO_API_PASSWORD_STORAGE.equals(string) && SVNJNAUtil.isWinCryptEnabled()) {
                arrayList.add(new DefaultSVNPersistentAuthenticationProvider$WinCryptPasswordStorage(this));
            }
            if ("keychain".equals(string) && SVNJNAUtil.isMacOsKeychainEnabled()) {
                arrayList.add(new DefaultSVNPersistentAuthenticationProvider$MacOsKeychainPasswordStorage(this));
            }
            if (!"gnome-keyring".equals(string) || !SVNJNAUtil.isGnomeKeyringEnabled()) continue;
            arrayList.add(new DefaultSVNPersistentAuthenticationProvider$GnomeKeyringPasswordStorage(this));
        }
        arrayList.add(new DefaultSVNPersistentAuthenticationProvider$SimplePasswordStorage(this));
        return arrayList.toArray(new DefaultSVNPersistentAuthenticationProvider$IPasswordStorage[arrayList.size()]);
    }

    private DefaultSVNPersistentAuthenticationProvider$IPasswordStorage getPasswordStorage(String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.myPasswordStorages.length; ++i2) {
            DefaultSVNPersistentAuthenticationProvider$IPasswordStorage defaultSVNPersistentAuthenticationProvider$IPasswordStorage = this.myPasswordStorages[i2];
            if (!defaultSVNPersistentAuthenticationProvider$IPasswordStorage.getPassType().equals(string)) continue;
            return defaultSVNPersistentAuthenticationProvider$IPasswordStorage;
        }
        return null;
    }

    private SVNPasswordAuthentication readSSLPassphrase(String string, String string2, boolean bl2, SVNURL sVNURL) {
        File file = new File(this.myDirectory, string);
        if (!file.isDirectory()) {
            return null;
        }
        File[] fileArray = SVNFileListUtil.listFiles(file);
        SVNHashMap sVNHashMap = new SVNHashMap();
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            if (!file2.isFile()) continue;
            SVNWCProperties sVNWCProperties = new SVNWCProperties(file2, "");
            try {
                SVNPasswordAuthentication sVNPasswordAuthentication = this.readSSLPassphrase(string2, sVNWCProperties, sVNURL);
                if (sVNPasswordAuthentication == null) continue;
                sVNHashMap.put(sVNPasswordAuthentication.getUserName(), sVNPasswordAuthentication);
                continue;
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        if (sVNHashMap.isEmpty()) {
            return null;
        }
        SVNPasswordAuthentication sVNPasswordAuthentication = (SVNPasswordAuthentication)sVNHashMap.values().iterator().next();
        if (sVNHashMap.containsKey(string2)) {
            sVNPasswordAuthentication = (SVNPasswordAuthentication)sVNHashMap.get(string2);
        }
        if (sVNPasswordAuthentication != null) {
            return SVNPasswordAuthentication.newInstance("", sVNPasswordAuthentication.getPasswordValue(), bl2, sVNURL, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNPasswordAuthentication readSSLPassphrase(String string, SVNWCProperties sVNWCProperties, SVNURL sVNURL) {
        SVNProperties sVNProperties = sVNWCProperties.asMap();
        try {
            File file;
            String string2 = sVNProperties.getStringValue("svn:realmstring");
            if (string2 == null || !SVNSSLAuthentication.isCertificatePath(string2)) {
                SVNPasswordAuthentication sVNPasswordAuthentication = null;
                return sVNPasswordAuthentication;
            }
            File file2 = new File(string.replace(File.separatorChar, '/')).getAbsoluteFile();
            if (!file2.equals(file = new File(string2.replace(File.separatorChar, '/')).getAbsoluteFile())) {
                SVNPasswordAuthentication sVNPasswordAuthentication = null;
                return sVNPasswordAuthentication;
            }
            String string3 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue("passtype"));
            DefaultSVNPersistentAuthenticationProvider$IPasswordStorage defaultSVNPersistentAuthenticationProvider$IPasswordStorage = this.getPasswordStorage(string3);
            if (string3 != null && defaultSVNPersistentAuthenticationProvider$IPasswordStorage == null) {
                SVNPasswordAuthentication sVNPasswordAuthentication = null;
                return sVNPasswordAuthentication;
            }
            char[] cArray = defaultSVNPersistentAuthenticationProvider$IPasswordStorage != null ? defaultSVNPersistentAuthenticationProvider$IPasswordStorage.readPassphrase(string2, sVNProperties) : SVNPropertyValue.getPropertyAsChars(sVNProperties.getSVNPropertyValue("passphrase"));
            SVNPasswordAuthentication sVNPasswordAuthentication = SVNPasswordAuthentication.newInstance(string2, cArray, false, sVNURL, false);
            return sVNPasswordAuthentication;
        }
        finally {
            if (sVNProperties != null) {
                sVNProperties.clear();
            }
        }
    }

    private char[] readPassword(String string, String string2, DefaultSVNPersistentAuthenticationProvider$IPasswordStorage defaultSVNPersistentAuthenticationProvider$IPasswordStorage, SVNProperties sVNProperties) {
        if (defaultSVNPersistentAuthenticationProvider$IPasswordStorage != null) {
            return defaultSVNPersistentAuthenticationProvider$IPasswordStorage.readPassword(string, string2, sVNProperties);
        }
        return SVNPropertyValue.getPropertyAsChars(sVNProperties.getSVNPropertyValue("password"));
    }

    private char[] readPassphrase(String string, DefaultSVNPersistentAuthenticationProvider$IPasswordStorage defaultSVNPersistentAuthenticationProvider$IPasswordStorage, SVNProperties sVNProperties) {
        if (defaultSVNPersistentAuthenticationProvider$IPasswordStorage != null) {
            return defaultSVNPersistentAuthenticationProvider$IPasswordStorage.readPassphrase(string, sVNProperties);
        }
        return SVNPropertyValue.getPropertyAsChars(sVNProperties.getSVNPropertyValue("passphrase"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNAuthentication requestClientAuthentication(String string, SVNURL sVNURL, String string2, SVNErrorMessage sVNErrorMessage, SVNAuthentication sVNAuthentication, boolean bl2) {
        block38: {
            String string3;
            Object object;
            string2 = this.preprocessRealm(string2);
            if ("svn.ssl.client-passphrase".equals(string)) {
                if (SVNSSLAuthentication.isCertificatePath(string2)) {
                    return this.readSSLPassphrase(string, string2, bl2, sVNURL);
                }
                object = this.myHostOptionsProvider.getHostOptions(sVNURL);
                string3 = object.getSSLClientCertFile();
                if (string3 != null && !"".equals(string3)) {
                    SVNPasswordAuthentication sVNPasswordAuthentication;
                    if (this.isMSCapi(string3)) {
                        String string4 = null;
                        if (string3.lastIndexOf(59) > 0) {
                            string4 = string3.substring(string3.lastIndexOf(59) + 1);
                        }
                        return SVNSSLAuthentication.newInstance("MSCAPI", string4, bl2, sVNURL, false);
                    }
                    String string5 = object.getSSLClientCertPassword();
                    File file = string3 != null ? new File(string3) : null;
                    char[] cArray = string5 != null ? string5.toCharArray() : null;
                    SVNSSLAuthentication sVNSSLAuthentication = SVNSSLAuthentication.newInstance(file, cArray, bl2, sVNURL, false);
                    if ((string5 == null || "".equals(string5)) && (sVNPasswordAuthentication = this.readSSLPassphrase(string, string3, bl2, sVNURL)) != null && sVNPasswordAuthentication.getPasswordValue() != null) {
                        sVNSSLAuthentication = SVNSSLAuthentication.newInstance(file, sVNPasswordAuthentication.getPasswordValue(), bl2, sVNURL, false);
                    }
                    sVNSSLAuthentication.setCertificatePath(string3);
                    return sVNSSLAuthentication;
                }
            }
            if (!((File)(object = new File(this.myDirectory, string))).isDirectory()) {
                return null;
            }
            string3 = this.getAuthFileName(string2);
            File file = new File((File)object, string3);
            if (file.exists()) {
                SVNWCProperties sVNWCProperties = new SVNWCProperties(file, "");
                SVNProperties sVNProperties = null;
                try {
                    sVNProperties = sVNWCProperties.asMap();
                    String string6 = sVNProperties.getStringValue("svn:realmstring");
                    String string7 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue("passtype"));
                    DefaultSVNPersistentAuthenticationProvider$IPasswordStorage defaultSVNPersistentAuthenticationProvider$IPasswordStorage = this.getPasswordStorage(string7);
                    if (string7 != null && defaultSVNPersistentAuthenticationProvider$IPasswordStorage == null) {
                        SVNAuthentication sVNAuthentication2 = null;
                        return sVNAuthentication2;
                    }
                    if (string6 == null || !string6.equals(string2)) {
                        SVNAuthentication sVNAuthentication3 = null;
                        return sVNAuthentication3;
                    }
                    String string8 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue("username"));
                    if (!"svn.ssl.client-passphrase".equals(string)) {
                        if (string8 == null || "".equals(string8.trim())) {
                            SVNAuthentication sVNAuthentication4 = null;
                            return sVNAuthentication4;
                        }
                        if (this.myUserName != null && !this.myUserName.equals(string8)) {
                            SVNAuthentication sVNAuthentication5 = null;
                            return sVNAuthentication5;
                        }
                    }
                    String string9 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue("key"));
                    String string10 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue("port"));
                    string10 = string10 == null ? "" + this.myDefaultOptions.getDefaultSSHPortNumber() : string10;
                    String string11 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue("ssl-kind"));
                    if ("svn.simple".equals(string)) {
                        char[] cArray;
                        SVNPasswordAuthentication sVNPasswordAuthentication = SVNPasswordAuthentication.newInstance(string8, cArray, bl2, sVNURL, (cArray = this.readPassword(string2, string8, defaultSVNPersistentAuthenticationProvider$IPasswordStorage, sVNProperties)) == null);
                        return sVNPasswordAuthentication;
                    }
                    if ("svn.ssh".equals(string)) {
                        int n2;
                        try {
                            n2 = Integer.parseInt(string10);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n2 = this.myDefaultOptions.getDefaultSSHPortNumber();
                        }
                        if (string9 != null) {
                            char[] cArray = this.readPassphrase(string6, defaultSVNPersistentAuthenticationProvider$IPasswordStorage, sVNProperties);
                            SVNSSHAuthentication sVNSSHAuthentication = SVNSSHAuthentication.newInstance(string8, new File(string9), cArray, n2, bl2, sVNURL, false);
                            return sVNSSHAuthentication;
                        }
                        char[] cArray = this.readPassword(string2, string8, defaultSVNPersistentAuthenticationProvider$IPasswordStorage, sVNProperties);
                        if (cArray != null) {
                            SVNSSHAuthentication sVNSSHAuthentication = SVNSSHAuthentication.newInstance(string8, cArray, n2, bl2, sVNURL, false);
                            return sVNSSHAuthentication;
                        }
                        break block38;
                    }
                    if ("svn.username".equals(string)) {
                        SVNUserNameAuthentication sVNUserNameAuthentication = SVNUserNameAuthentication.newInstance(string8, bl2, sVNURL, false);
                        return sVNUserNameAuthentication;
                    }
                    if ("svn.ssl.client-passphrase".equals(string)) {
                        SVNAuthentication sVNAuthentication6;
                        if (this.isMSCapi(string11)) {
                            String string12 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue("alias"));
                            SVNSSLAuthentication sVNSSLAuthentication = SVNSSLAuthentication.newInstance("MSCAPI", string12, bl2, sVNURL, false);
                            return sVNSSLAuthentication;
                        }
                        char[] cArray = this.readPassphrase(string6, defaultSVNPersistentAuthenticationProvider$IPasswordStorage, sVNProperties);
                        SVNSSLAuthentication sVNSSLAuthentication = SVNSSLAuthentication.newInstance(new File(string9), cArray, bl2, sVNURL, false);
                        if ((cArray == null || "".equals(cArray)) && (sVNAuthentication6 = this.readSSLPassphrase(string, string9, bl2, sVNURL)) != null && ((SVNPasswordAuthentication)sVNAuthentication6).getPasswordValue() != null) {
                            sVNSSLAuthentication = SVNSSLAuthentication.newInstance(new File(string9), ((SVNPasswordAuthentication)sVNAuthentication6).getPasswordValue(), bl2, sVNURL, false);
                        }
                        sVNSSLAuthentication.setCertificatePath(string9);
                        sVNAuthentication6 = sVNSSLAuthentication;
                        return sVNAuthentication6;
                    }
                }
                catch (SVNException sVNException) {
                }
                finally {
                    if (sVNProperties != null) {
                        sVNProperties.dispose();
                    }
                }
            }
        }
        return null;
    }

    protected String preprocessRealm(String string) {
        return string;
    }

    public boolean isMSCapi(String string) {
        return string != null && string.startsWith("MSCAPI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAuthentication(SVNAuthentication sVNAuthentication, String string, String string2) {
        Object object;
        File file = new File(this.myDirectory, string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            return;
        }
        if (!"svn.ssl.client-passphrase".equals(string) && ("".equals(sVNAuthentication.getUserName()) || sVNAuthentication.getUserName() == null)) {
            return;
        }
        SVNProperties sVNProperties = new SVNProperties();
        sVNProperties.put("svn:realmstring", string2);
        if ("svn.simple".equals(string)) {
            this.savePasswordCredential(sVNProperties, sVNAuthentication, string2);
        } else if ("svn.ssh".equals(string)) {
            this.saveSSHCredential(sVNProperties, sVNAuthentication, string2);
        } else if ("svn.ssl.client-passphrase".equals(string)) {
            if (!this.saveSSLCredential(sVNProperties, sVNAuthentication, string2)) {
                return;
            }
        } else if ("svn.username".equals(string)) {
            this.saveUserNameCredential(sVNProperties, sVNAuthentication);
        }
        String string3 = this.getAuthFileName(string2);
        File file2 = new File(file, string3);
        if (file2.isFile()) {
            object = new SVNWCProperties(file2, "");
            try {
                if (!this.shouldSaveCredentials(string, sVNProperties, ((SVNWCProperties)object).asMap())) {
                    return;
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        object = SVNFileUtil.createUniqueFile(file, "auth", ".tmp", true);
        try {
            SVNWCProperties.setProperties(sVNProperties, file2, (File)object, "END");
        }
        finally {
            SVNFileUtil.deleteFile((File)object);
        }
    }

    protected String getAuthFileName(String string) {
        return SVNFileUtil.computeChecksum(string);
    }

    @Override
    public int acceptServerAuthentication(SVNURL sVNURL, String string, Object object, boolean bl2) {
        return 2;
    }

    private boolean shouldSaveCredentials(String string, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        char[] cArray;
        assert (sVNProperties != null);
        assert (sVNProperties2 != null);
        if (!"svn.simple".equals(string)) {
            return !sVNProperties.equals(sVNProperties2);
        }
        String string2 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue("username"));
        String string3 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue("passtype"));
        String string4 = SVNPropertyValue.getPropertyAsString(sVNProperties.getSVNPropertyValue("svn:realmstring"));
        DefaultSVNPersistentAuthenticationProvider$IPasswordStorage defaultSVNPersistentAuthenticationProvider$IPasswordStorage = this.getPasswordStorage(string3);
        char[] cArray2 = defaultSVNPersistentAuthenticationProvider$IPasswordStorage == null ? null : defaultSVNPersistentAuthenticationProvider$IPasswordStorage.readPassword(string4, string2, sVNProperties);
        String string5 = SVNPropertyValue.getPropertyAsString(sVNProperties2.getSVNPropertyValue("username"));
        String string6 = SVNPropertyValue.getPropertyAsString(sVNProperties2.getSVNPropertyValue("passtype"));
        String string7 = SVNPropertyValue.getPropertyAsString(sVNProperties2.getSVNPropertyValue("svn:realmstring"));
        DefaultSVNPersistentAuthenticationProvider$IPasswordStorage defaultSVNPersistentAuthenticationProvider$IPasswordStorage2 = this.getPasswordStorage(string6);
        char[] cArray3 = cArray = defaultSVNPersistentAuthenticationProvider$IPasswordStorage2 == null ? null : defaultSVNPersistentAuthenticationProvider$IPasswordStorage2.readPassword(string7, string5, sVNProperties2);
        if (string2 != null) {
            if (string5 == null) {
                return true;
            }
            if (!string2.equals(string5)) {
                return true;
            }
        }
        if (cArray2 != null) {
            if (cArray == null) {
                return true;
            }
            if (!cArray2.equals(cArray)) {
                return true;
            }
        }
        return false;
    }

    private void saveUserNameCredential(SVNProperties sVNProperties, SVNAuthentication sVNAuthentication) {
        sVNProperties.put("username", sVNAuthentication.getUserName());
    }

    private void savePasswordCredential(SVNProperties sVNProperties, SVNAuthentication sVNAuthentication, String string) {
        String string2 = sVNAuthentication.getUserName();
        sVNProperties.put("username", string2);
        boolean bl2 = this.myHostOptionsProvider.getHostOptions(sVNAuthentication.getURL()).isStorePasswords();
        if (bl2) {
            SVNPasswordAuthentication sVNPasswordAuthentication = (SVNPasswordAuthentication)sVNAuthentication;
            for (int i2 = 0; i2 < this.myPasswordStorages.length; ++i2) {
                DefaultSVNPersistentAuthenticationProvider$IPasswordStorage defaultSVNPersistentAuthenticationProvider$IPasswordStorage = this.myPasswordStorages[i2];
                boolean bl3 = defaultSVNPersistentAuthenticationProvider$IPasswordStorage.savePassword(string, sVNPasswordAuthentication.getPasswordValue(), sVNPasswordAuthentication, sVNProperties);
                if (!bl3) continue;
                sVNProperties.put("passtype", defaultSVNPersistentAuthenticationProvider$IPasswordStorage.getPassType());
                break;
            }
        }
    }

    private void saveSSHCredential(SVNProperties sVNProperties, SVNAuthentication sVNAuthentication, String string) {
        Object object;
        int n2;
        sVNProperties.put("username", sVNAuthentication.getUserName());
        SVNSSHAuthentication sVNSSHAuthentication = (SVNSSHAuthentication)sVNAuthentication;
        boolean bl2 = this.myHostOptionsProvider.getHostOptions(sVNAuthentication.getURL()).isStorePasswords();
        Object object2 = null;
        if (bl2) {
            for (n2 = 0; n2 < this.myPasswordStorages.length; ++n2) {
                object = this.myPasswordStorages[n2];
                char[] cArray = sVNSSHAuthentication.getPasswordValue();
                boolean bl3 = object.savePassword(string, cArray, sVNAuthentication, sVNProperties);
                if (!bl3) continue;
                sVNProperties.put("passtype", object.getPassType());
                object2 = object;
                break;
            }
        }
        n2 = sVNSSHAuthentication.getPortNumber();
        if (sVNSSHAuthentication.getPortNumber() < 0) {
            n2 = this.myDefaultOptions.getDefaultSSHPortNumber();
        }
        sVNProperties.put("port", Integer.toString(n2));
        if (sVNSSHAuthentication.getPrivateKeyFile() != null) {
            object = sVNSSHAuthentication.getPrivateKeyFile().getAbsolutePath();
            if (object2 != null) {
                object2.savePassphrase(string, sVNSSHAuthentication.getPassphraseValue(), sVNSSHAuthentication, sVNProperties, true);
            } else {
                for (int i2 = 0; i2 < this.myPasswordStorages.length; ++i2) {
                    DefaultSVNPersistentAuthenticationProvider$IPasswordStorage defaultSVNPersistentAuthenticationProvider$IPasswordStorage = this.myPasswordStorages[i2];
                    boolean bl4 = defaultSVNPersistentAuthenticationProvider$IPasswordStorage.savePassphrase(string, sVNSSHAuthentication.getPassphraseValue(), sVNSSHAuthentication, sVNProperties, false);
                    if (!bl4) continue;
                    sVNProperties.put("passtype", defaultSVNPersistentAuthenticationProvider$IPasswordStorage.getPassType());
                    break;
                }
            }
            sVNProperties.put("key", (String)object);
        }
    }

    private boolean saveSSLCredential(SVNProperties sVNProperties, SVNAuthentication sVNAuthentication, String string) {
        Object object;
        boolean bl2 = this.myHostOptionsProvider.getHostOptions(sVNAuthentication.getURL()).isStoreSSLClientCertificatePassphrases();
        boolean bl3 = false;
        Object object2 = sVNAuthentication instanceof SVNPasswordAuthentication ? ((SVNPasswordAuthentication)sVNAuthentication).getPasswordValue() : (Object)(this.myAuthOptions.isSSLPassphrasePromptSupported() ? null : (Object)(sVNAuthentication instanceof SVNSSLAuthentication ? ((SVNSSLAuthentication)sVNAuthentication).getPasswordValue() : null));
        if (bl2 && object2 != null) {
            for (int i2 = 0; i2 < this.myPasswordStorages.length; ++i2) {
                object = this.myPasswordStorages[i2];
                boolean bl4 = object.savePassphrase(string, (char[])object2, sVNAuthentication, sVNProperties, false);
                if (!bl4) continue;
                sVNProperties.put("passtype", object.getPassType());
                bl3 = true;
                break;
            }
        }
        if (sVNAuthentication instanceof SVNSSLAuthentication) {
            SVNSSLAuthentication sVNSSLAuthentication = (SVNSSLAuthentication)sVNAuthentication;
            if ("SSL".equals(sVNSSLAuthentication.getSSLKind())) {
                if (sVNSSLAuthentication.getCertificateFile() != null) {
                    object = sVNSSLAuthentication.getCertificatePath();
                    sVNProperties.put("key", (String)object);
                    bl3 = true;
                }
            } else if ("MSCAPI".equals(sVNSSLAuthentication.getSSLKind())) {
                sVNProperties.put("ssl-kind", sVNSSLAuthentication.getSSLKind());
                if (sVNSSLAuthentication.getAlias() != null) {
                    sVNProperties.put("alias", sVNSSLAuthentication.getAlias());
                }
                bl3 = true;
            }
        }
        return bl3;
    }

    @Override
    public byte[] loadFingerprints(String string) {
        File file = new File(this.myDirectory, "svn.ssh.server");
        if (!file.isDirectory()) {
            return null;
        }
        File file2 = new File(file, this.getAuthFileName(string));
        if (!file2.isFile()) {
            return null;
        }
        SVNWCProperties sVNWCProperties = new SVNWCProperties(file2, "");
        try {
            SVNProperties sVNProperties = sVNWCProperties.asMap();
            String string2 = sVNProperties.getStringValue("svn:realmstring");
            if (!string.equals(string2)) {
                return null;
            }
            return sVNProperties.getBinaryValue("hostkey");
        }
        catch (SVNException sVNException) {
            return null;
        }
    }

    @Override
    public void saveFingerprints(String string, byte[] byArray) {
        File file = new File(this.myDirectory, "svn.ssh.server");
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        File file2 = new File(file, this.getAuthFileName(string));
        SVNProperties sVNProperties = new SVNProperties();
        sVNProperties.put("svn:realmstring", string);
        sVNProperties.put("hostkey", byArray);
        try {
            SVNWCProperties.setProperties(sVNProperties, file2, null, "END");
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    static /* synthetic */ ISVNHostOptionsProvider access$000(DefaultSVNPersistentAuthenticationProvider defaultSVNPersistentAuthenticationProvider) {
        return defaultSVNPersistentAuthenticationProvider.myHostOptionsProvider;
    }

    static /* synthetic */ ISVNAuthenticationStorageOptions access$100(DefaultSVNPersistentAuthenticationProvider defaultSVNPersistentAuthenticationProvider) {
        return defaultSVNPersistentAuthenticationProvider.myAuthOptions;
    }
}

