/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNTunnelConnector;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNMerger;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.wc.ISVNConfigEventHandler;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.ISVNMergerFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class DefaultSVNOptions
implements ISVNMergerFactory,
ISVNOptions {
    private static final String MISCELLANY_GROUP = "miscellany";
    private static final String AUTH_GROUP = "auth";
    private static final String AUTOPROPS_GROUP = "auto-props";
    private static final String SVNKIT_GROUP = "svnkit";
    private static final String OLD_SVNKIT_GROUP = "javasvn";
    private static final String HELPERS_GROUP = "helpers";
    private static final String HTTP_SPOOL_DIRECTORY = "http-spool-directory";
    private static final String USE_COMMIT_TIMES = "use-commit-times";
    private static final String GLOBAL_IGNORES = "global-ignores";
    private static final String ENABLE_AUTO_PROPS = "enable-auto-props";
    private static final String STORE_AUTH_CREDS = "store-auth-creds";
    private static final String KEYWORD_TIMEZONE = "keyword_timezone";
    private static final String KEYWORD_LOCALE = "keyword_locale";
    private static final String EDITOR_CMD = "editor-cmd";
    private static final String DIFF_CMD = "diff-cmd";
    private static final String MERGE_TOOL_CMD = "merge-tool-cmd";
    private static final String NO_UNLOCK = "no-unlock";
    private static final String LOG_ENCODING = "log-encoding";
    private static final String PRESERVED_CONFLICT_FILE_EXTENSIONS = "preserved-conflict-file-exts";
    private static final String INTERACTIVE_COFLICTS = "interactive-conflicts";
    private static final String MIME_TYPES_FILE = "mime-types-file";
    private static final String GLOBAL_CHARSET = "global-charset";
    private static final String PASSWORD_STORES = "password-stores";
    private static final String DEFAULT_IGNORES = "*.o *.lo *.la *.al .libs *.so *.so.[0-9]* *.a *.pyc *.pyo *.rej *~ #*# .#* .*.swp .DS_Store";
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String DEFAULT_LOCALE = Locale.getDefault().toString();
    private static final String DEFAULT_TIMEZONE = TimeZone.getDefault().getID();
    private static final String[] DEFAULT_PASSWORD_STORE_TYPES = new String[]{"windows-cryptoapi", "keychain", "gnome-keyring"};
    private boolean myIsReadonly;
    private File myConfigDirectory;
    private SVNCompositeConfigFile myConfigFile;
    private ISVNMergerFactory myMergerFactory;
    private ISVNConflictHandler myConflictResolver;
    private ISVNTunnelProvider myTunnelProvider;
    private String myKeywordLocale = DEFAULT_LOCALE;
    private String myKeywordTimezone = DEFAULT_TIMEZONE;
    private SimpleDateFormat myKeywordDateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss' 'ZZZZ' ('E', 'dd' 'MMM' 'yyyy')'");
    private Map myConfigOptions;
    private ISVNConfigEventHandler myConfigEventHandler;

    public DefaultSVNOptions() {
        this(null, true);
    }

    public DefaultSVNOptions(File file, boolean bl2) {
        this.myConfigDirectory = file == null ? DefaultSVNOptions.getDefaultConfigDir() : file;
        this.myIsReadonly = bl2;
    }

    @Override
    public boolean isUseCommitTimes() {
        String string = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, USE_COMMIT_TIMES);
        return DefaultSVNOptions.getBooleanValue(string, false);
    }

    public void setInMemoryConfigOptions(Map map) {
        this.myConfigOptions = map;
        if (this.myConfigFile != null) {
            this.myConfigFile.setGroupsToOptions(this.myConfigOptions);
        }
    }

    public void setUseCommitTimes(boolean bl2) {
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, USE_COMMIT_TIMES, bl2 ? YES : NO, !this.myIsReadonly);
    }

    public boolean isUseAutoProperties() {
        String string = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, ENABLE_AUTO_PROPS);
        return DefaultSVNOptions.getBooleanValue(string, false);
    }

    public void setUseAutoProperties(boolean bl2) {
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, ENABLE_AUTO_PROPS, bl2 ? YES : NO, !this.myIsReadonly);
    }

    public boolean isAuthStorageEnabled() {
        String string = this.getConfigFile().getPropertyValue(AUTH_GROUP, STORE_AUTH_CREDS);
        return DefaultSVNOptions.getBooleanValue(string, true);
    }

    public boolean isKeepLocks() {
        String string = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, NO_UNLOCK);
        return DefaultSVNOptions.getBooleanValue(string, false);
    }

    public void setAuthStorageEnabled(boolean bl2) {
        this.getConfigFile().setPropertyValue(AUTH_GROUP, STORE_AUTH_CREDS, bl2 ? YES : NO, !this.myIsReadonly);
    }

    public void setKeepLocks(boolean bl2) {
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, NO_UNLOCK, bl2 ? YES : NO, !this.myIsReadonly);
    }

    public static boolean isIgnored(ISVNOptions iSVNOptions, String string) {
        String[] stringArray = iSVNOptions.getIgnorePatterns();
        for (int i2 = 0; stringArray != null && i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (!DefaultSVNOptions.matches(string2, string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getIgnorePatterns() {
        String string = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, GLOBAL_IGNORES);
        if (string == null) {
            string = DEFAULT_IGNORES;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setIgnorePatterns(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, GLOBAL_IGNORES, null, !this.myIsReadonly);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string == null || "".equals(string.trim())) continue;
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        String string = stringBuffer.toString().trim();
        if ("".equals(string)) {
            string = null;
        }
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, GLOBAL_IGNORES, string, !this.myIsReadonly);
    }

    public void deleteIgnorePattern(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = this.getIgnorePatterns();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals(string)) continue;
            arrayList.add(string2);
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        this.setIgnorePatterns(stringArray);
    }

    public void addIgnorePattern(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = this.getIgnorePatterns();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        if (!arrayList.contains(string)) {
            arrayList.add(string);
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            this.setIgnorePatterns(stringArray);
        }
    }

    public Map getAutoProperties() {
        return this.getConfigFile().getProperties(AUTOPROPS_GROUP);
    }

    public void setAutoProperties(Map map) {
        String string;
        map = map == null ? Collections.EMPTY_MAP : map;
        Map map2 = this.getAutoProperties();
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = (String)map2.get(string2);
            if (string.equals(map.get(string2))) continue;
            this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, string2, null, false);
            iterator.remove();
        }
        for (String string2 : map.keySet()) {
            string = (String)map.get(string2);
            if (string.equals(map2.get(string2))) continue;
            this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, string2, string, false);
        }
        if (!this.myIsReadonly) {
            this.getConfigFile().save();
        }
    }

    public String getEditor() {
        return this.getConfigFile().getPropertyValue(HELPERS_GROUP, EDITOR_CMD);
    }

    public String getMergeTool() {
        return this.getConfigFile().getPropertyValue(HELPERS_GROUP, MERGE_TOOL_CMD);
    }

    public void deleteAutoProperty(String string) {
        this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, string, null, !this.myIsReadonly);
    }

    public void setAutoProperty(String string, String string2) {
        this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, string, string2, !this.myIsReadonly);
    }

    public boolean isInteractiveConflictResolution() {
        String string = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, INTERACTIVE_COFLICTS);
        return DefaultSVNOptions.getBooleanValue(string, true);
    }

    public void setInteractiveConflictResolution(boolean bl2) {
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, INTERACTIVE_COFLICTS, bl2 ? YES : NO, !this.myIsReadonly);
    }

    @Override
    public Map applyAutoProperties(File file, Map map) {
        String string = file.getName();
        Map map2 = map = map == null ? new SVNHashMap() : map;
        if (!this.isUseAutoProperties()) {
            return map;
        }
        Map map3 = this.getAutoProperties();
        for (String string2 : map3.keySet()) {
            String string3 = (String)map3.get(string2);
            if (string3 == null || "".equals(string3) || !DefaultSVNOptions.matches(string2, string)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < string3.length(); ++i2) {
                char c2 = string3.charAt(i2);
                if (c2 == ';' || i2 == string3.length() - 1) {
                    String string4;
                    int n2;
                    if (i2 + 1 < string3.length() && string3.charAt(i2 + 1) == ';') {
                        stringBuffer.append(';');
                        if (++i2 < string3.length() - 1) continue;
                    }
                    if (c2 != ';') {
                        stringBuffer.append(c2);
                    }
                    if ((n2 = (string4 = stringBuffer.toString().trim()).indexOf(61)) < 0) {
                        map.put(string4, "");
                    } else {
                        String string5;
                        String string6 = string4.substring(0, n2).trim();
                        String string7 = string5 = n2 == string4.length() - 1 ? "" : string4.substring(n2 + 1).trim();
                        if (!"".equals(string6.trim())) {
                            if (string5.startsWith("\"") && string5.endsWith("\"") && string5.length() > 1) {
                                string5 = string5.substring(1, string5.length() - 1);
                            } else if (string5.startsWith("'") && string5.endsWith("'") && string5.length() > 1) {
                                string5 = string5.substring(1, string5.length() - 1);
                            }
                            map.put(string6, string5);
                        }
                    }
                    stringBuffer = stringBuffer.delete(0, stringBuffer.length());
                    continue;
                }
                stringBuffer.append(c2);
            }
        }
        return map;
    }

    @Override
    public ISVNMergerFactory getMergerFactory() {
        if (this.myMergerFactory == null) {
            return this;
        }
        return this.myMergerFactory;
    }

    public void setMergerFactory(ISVNMergerFactory iSVNMergerFactory) {
        this.myMergerFactory = iSVNMergerFactory;
    }

    public void setTunnelProvider(ISVNTunnelProvider iSVNTunnelProvider) {
        this.myTunnelProvider = iSVNTunnelProvider;
    }

    public String getPropertyValue(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.getConfigFile().getPropertyValue(SVNKIT_GROUP, string);
        if (string2 == null) {
            string2 = this.getConfigFile().getPropertyValue(OLD_SVNKIT_GROUP, string);
        }
        return string2;
    }

    public File getHttpSpoolDirectory() {
        String string = this.getPropertyValue(HTTP_SPOOL_DIRECTORY);
        if (string != null) {
            return new File(string);
        }
        return null;
    }

    public void setPropertyValue(String string, String string2) {
        if (string == null || "".equals(string.trim())) {
            return;
        }
        this.getConfigFile().setPropertyValue(SVNKIT_GROUP, string, string2, !this.myIsReadonly);
    }

    public void setConflictHandler(ISVNConflictHandler iSVNConflictHandler) {
        this.myConflictResolver = iSVNConflictHandler;
    }

    public void setConfigEventHandler(ISVNConfigEventHandler iSVNConfigEventHandler) {
        this.myConfigEventHandler = iSVNConfigEventHandler;
    }

    @Override
    public ISVNConflictHandler getConflictResolver() {
        return this.myConflictResolver;
    }

    public static boolean matches(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        Pattern pattern = DefaultSVNOptions.compileNamePatter(string);
        if (pattern != null) {
            return pattern.matcher(string2).matches();
        }
        return false;
    }

    @Override
    public ISVNMerger createMerger(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new DefaultSVNMerger(byArray, byArray2, byArray3, this.myConflictResolver, SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST);
    }

    @Override
    public ISVNConnector createTunnelConnector(SVNURL sVNURL) {
        if (this.myTunnelProvider != null) {
            return this.myTunnelProvider.createTunnelConnector(sVNURL);
        }
        String string = sVNURL.getProtocol().substring("svn+".length());
        if (string == null) {
            return null;
        }
        Map map = this.getConfigFile().getProperties("tunnels");
        String string2 = (String)map.get(string);
        if (string2 == null) {
            return null;
        }
        return new SVNTunnelConnector(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateFormat getKeywordDateFormat() {
        SimpleDateFormat simpleDateFormat;
        Cloneable cloneable;
        String string;
        String string2 = this.getConfigFile().getPropertyValue(SVNKIT_GROUP, KEYWORD_LOCALE);
        if (string2 == null) {
            string2 = DEFAULT_LOCALE;
        }
        if ((string = this.getConfigFile().getPropertyValue(SVNKIT_GROUP, KEYWORD_TIMEZONE)) == null) {
            string = DEFAULT_TIMEZONE;
        }
        if (!this.myKeywordTimezone.equals(string)) {
            cloneable = TimeZone.getTimeZone(string);
            this.myKeywordTimezone = string;
            simpleDateFormat = this.myKeywordDateFormat;
            synchronized (simpleDateFormat) {
                this.myKeywordDateFormat.setTimeZone((TimeZone)cloneable);
            }
        }
        if (!this.myKeywordLocale.equals(string2)) {
            cloneable = DefaultSVNOptions.toLocale(string2);
            if (cloneable == null) {
                cloneable = Locale.getDefault();
            }
            this.myKeywordLocale = string2;
            simpleDateFormat = this.myKeywordDateFormat;
            synchronized (simpleDateFormat) {
                this.myKeywordDateFormat.setCalendar(Calendar.getInstance(this.myKeywordDateFormat.getTimeZone(), (Locale)cloneable));
                this.myKeywordDateFormat.setDateFormatSymbols(new DateFormatSymbols((Locale)cloneable));
            }
        }
        return this.myKeywordDateFormat;
    }

    @Override
    public String[] getPreservedConflictFileExtensions() {
        String string = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, PRESERVED_CONFLICT_FILE_EXTENSIONS);
        if (string == null) {
            string = "";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public boolean isAllowAllForwardMergesFromSelf() {
        return false;
    }

    public String getLogEncoding() {
        return this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, LOG_ENCODING);
    }

    public String getGlobalCharset() {
        return this.getPropertyValue(GLOBAL_CHARSET);
    }

    public void setGlobalCharset(String string) {
        this.setPropertyValue(GLOBAL_CHARSET, string);
    }

    @Override
    public String getNativeCharset() {
        return System.getProperty("file.encoding");
    }

    @Override
    public byte[] getNativeEOL() {
        return System.getProperty("line.separator").getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getFileExtensionsToMimeTypes() {
        String string = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, MIME_TYPES_FILE);
        if (string == null) {
            return null;
        }
        BufferedReader bufferedReader = null;
        SVNHashMap sVNHashMap = new SVNHashMap();
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            LinkedList<String> linkedList = new LinkedList<String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("#")) continue;
                linkedList.clear();
                Object object = new StringTokenizer(string2, " \t");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    if ("".equals(string3)) continue;
                    linkedList.add(string3);
                }
                if (linkedList.size() < 2) continue;
                object = (String)linkedList.get(0);
                for (int i2 = 1; i2 < linkedList.size(); ++i2) {
                    String string4 = (String)linkedList.get(i2);
                    sVNHashMap.put(string4, object);
                }
            }
            SVNFileUtil.closeFile(bufferedReader);
        }
        catch (IOException iOException) {
            Map map = null;
            return map;
        }
        finally {
            SVNFileUtil.closeFile(bufferedReader);
        }
        return sVNHashMap;
    }

    public String getDiffCommand() {
        return this.getConfigFile().getPropertyValue(HELPERS_GROUP, DIFF_CMD);
    }

    public void setDiffCommand(String string) {
        this.getConfigFile().setPropertyValue(HELPERS_GROUP, DIFF_CMD, string, !this.myIsReadonly);
    }

    public String[] getPasswordStorageTypes() {
        String string = this.getConfigFile().getPropertyValue(AUTH_GROUP, PASSWORD_STORES);
        if (string == null) {
            return DEFAULT_PASSWORD_STORE_TYPES;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2 == null ? null : string2.trim();
            if (string2 == null || "".equals(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getDefaultSSHCommandLine() {
        Map map = this.getConfigFile().getProperties("tunnels");
        if (map == null || !map.containsKey("ssh")) {
            return null;
        }
        return (String)map.get("ssh");
    }

    private String getDefaultSSHOptionValue(String string, String string2, String string3) {
        String string4;
        String string5;
        if (string != null && (string5 = this.getDefaultSSHCommandLine()) != null && (string4 = DefaultSVNOptions.getOptionValue(string5, string)) != null) {
            return string4;
        }
        return System.getProperty(string2, System.getProperty(string3));
    }

    public int getDefaultSSHPortNumber() {
        String string = this.getDefaultSSHCommandLine();
        if (string == null) {
            return -1;
        }
        String string2 = string.toLowerCase().trim().startsWith("plink") ? "-p" : "-P";
        String string3 = this.getDefaultSSHOptionValue(string2, "svnkit.ssh2.port", "javasvn.ssh2.port");
        if (string3 != null) {
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public String getDefaultSSHUserName() {
        String string = this.getDefaultSSHOptionValue("-l", "svnkit.ssh2.username", "javasvn.ssh2.username");
        if (string == null) {
            string = System.getProperty("user.name");
        }
        return string;
    }

    public String getDefaultSSHPassword() {
        return this.getDefaultSSHOptionValue("-pw", "svnkit.ssh2.password", "javasvn.ssh2.password");
    }

    public String getDefaultSSHKeyFile() {
        return this.getDefaultSSHOptionValue("-i", "svnkit.ssh2.key", "javasvn.ssh2.key");
    }

    public String getDefaultSSHPassphrase() {
        return this.getDefaultSSHOptionValue(null, "svnkit.ssh2.passphrase", "javasvn.ssh2.passphrase");
    }

    private SVNCompositeConfigFile getConfigFile() {
        if (this.myConfigFile == null) {
            if (!this.myIsReadonly) {
                SVNConfigFile.createDefaultConfiguration(this.myConfigDirectory);
            }
            SVNConfigFile sVNConfigFile = new SVNConfigFile(new File(this.myConfigDirectory, "config"));
            SVNConfigFile sVNConfigFile2 = new SVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "config"));
            this.myConfigFile = new SVNCompositeConfigFile(sVNConfigFile2, sVNConfigFile);
            this.myConfigFile.setGroupsToOptions(this.myConfigOptions);
            if (this.myConfigEventHandler != null) {
                this.myConfigEventHandler.onLoad(this.myConfigFile, null);
            }
        }
        return this.myConfigFile;
    }

    private static String getOptionValue(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \r\n\t");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string2.equals(string3) && stringTokenizer.hasMoreTokens()) {
                return stringTokenizer.nextToken();
            }
            if (!string3.startsWith(string2)) continue;
            return string3.substring(string2.length());
        }
        return null;
    }

    private static Pattern compileNamePatter(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '?': {
                    stringBuffer.append(".");
                    continue block8;
                }
                case '*': {
                    stringBuffer.append(".*");
                    continue block8;
                }
                case '\\': {
                    if (i2 + 1 < string.length()) {
                        c2 = string.charAt(i2 + 1);
                        if (c2 != '\\') continue block8;
                        ++i2;
                    }
                }
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '<': 
                case '>': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    stringBuffer.append("\\");
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        try {
            return Pattern.compile(stringBuffer.toString());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
    }

    private static Locale toLocale(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 != 2 && n2 != 5 && n2 < 7) {
            return null;
        }
        char c2 = string.charAt(0);
        char c3 = string.charAt(1);
        if (c2 < 'a' || c2 > 'z' || c3 < 'a' || c3 > 'z') {
            return null;
        }
        if (n2 == 2) {
            return new Locale(string, "");
        }
        if (string.charAt(2) != '_') {
            return null;
        }
        char c4 = string.charAt(3);
        char c5 = string.charAt(4);
        if (c4 < 'A' || c4 > 'Z' || c5 < 'A' || c5 > 'Z') {
            return null;
        }
        if (n2 == 5) {
            return new Locale(string.substring(0, 2), string.substring(3, 5));
        }
        if (string.charAt(5) != '_') {
            return null;
        }
        return new Locale(string.substring(0, 2), string.substring(3, 5), string.substring(6));
    }

    private static File getDefaultConfigDir() {
        return SVNWCUtil.getDefaultConfigurationDirectory();
    }

    public static boolean getBooleanValue(String string, boolean bl2) {
        if (string == null) {
            return bl2;
        }
        return YES.equalsIgnoreCase(string = string.trim()) || "true".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
    }

    public static long getLongValue(String string, long l2) {
        if (string == null) {
            return l2;
        }
        string = string.trim();
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }
}

