/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import de.regnis.q.sequence.line.QSequenceLineRAByteData;
import de.regnis.q.sequence.line.QSequenceLineRAData;
import de.regnis.q.sequence.line.QSequenceLineRAFileData;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractSVNMerger;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNMergerAction;
import org.tmatesoft.svn.core.internal.wc.FSMergerBySequence;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNMergeResult;
import org.tmatesoft.svn.core.wc.SVNPropertyConflictDescription;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTextConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNMerger
extends AbstractSVNMerger
implements ISVNMerger {
    private static List STATUS_ORDERING = new LinkedList();
    private ISVNConflictHandler myConflictCallback;
    private SVNDiffConflictChoiceStyle myDiffConflictStyle;

    public DefaultSVNMerger(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this(byArray, byArray2, byArray3, null);
    }

    public DefaultSVNMerger(byte[] byArray, byte[] byArray2, byte[] byArray3, ISVNConflictHandler iSVNConflictHandler) {
        this(byArray, byArray2, byArray3, iSVNConflictHandler, SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST);
    }

    public DefaultSVNMerger(byte[] byArray, byte[] byArray2, byte[] byArray3, ISVNConflictHandler iSVNConflictHandler, SVNDiffConflictChoiceStyle sVNDiffConflictChoiceStyle) {
        super(byArray, byArray2, byArray3);
        this.myConflictCallback = iSVNConflictHandler;
        this.myDiffConflictStyle = sVNDiffConflictChoiceStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNMergeResult mergeProperties(String string, SVNProperties sVNProperties, SVNProperties sVNProperties2, SVNProperties sVNProperties3, SVNProperties sVNProperties4, SVNAdminArea sVNAdminArea, SVNLog sVNLog, boolean bl2, boolean bl3) {
        Object object4;
        Object object2;
        Serializable serializable;
        Object object3;
        Serializable serializable2;
        SVNProperties sVNProperties5 = sVNProperties4 = sVNProperties4 == null ? new SVNProperties() : sVNProperties4;
        if (sVNProperties2 == null) {
            sVNProperties2 = sVNAdminArea.getBaseProperties(string).asMap();
        }
        if (sVNProperties == null) {
            sVNProperties = sVNAdminArea.getProperties(string).asMap();
        }
        if (sVNProperties3 == null) {
            sVNProperties3 = sVNProperties2 != null ? new SVNProperties(sVNProperties2) : new SVNProperties();
        }
        boolean bl4 = sVNAdminArea.getThisDirName().equals(string);
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        SVNStatusType sVNStatusType = SVNStatusType.UNCHANGED;
        for (String string2 : sVNProperties4.nameSet()) {
            serializable2 = sVNProperties4.getSVNPropertyValue(string2);
            object3 = sVNProperties3.getSVNPropertyValue(string2);
            serializable = sVNProperties.getSVNPropertyValue(string2);
            object2 = sVNProperties2.getSVNPropertyValue(string2);
            boolean bl5 = SVNProperty.isRegularProperty(string2);
            if (bl2) {
                this.changeProperty(sVNProperties2, string2, (SVNPropertyValue)serializable2);
            }
            if (bl5) {
                sVNStatusType = DefaultSVNMerger.getPropMergeStatus(sVNStatusType, SVNStatusType.CHANGED);
            }
            object4 = null;
            object4 = object3 == null ? this.applySinglePropertyAdd(string, bl4, bl5 ? sVNStatusType : null, sVNProperties, string2, (SVNPropertyValue)object2, (SVNPropertyValue)serializable2, (SVNPropertyValue)serializable, sVNAdminArea, sVNLog, linkedList2, bl3) : (serializable2 == null ? this.applySinglePropertyDelete(string, bl4, bl5 ? sVNStatusType : null, sVNProperties, string2, (SVNPropertyValue)object2, (SVNPropertyValue)object3, (SVNPropertyValue)serializable, sVNAdminArea, sVNLog, linkedList2, bl3) : this.applySinglePropertyChange(string, bl4, sVNStatusType, sVNProperties, string2, (SVNPropertyValue)object2, (SVNPropertyValue)object3, (SVNPropertyValue)serializable2, (SVNPropertyValue)serializable, sVNAdminArea, sVNLog, linkedList2, bl3));
            if (bl5) {
                sVNStatusType = object4;
            }
            if (linkedList2.isEmpty()) continue;
            if (bl5) {
                sVNStatusType = DefaultSVNMerger.getPropMergeStatus(sVNStatusType, SVNStatusType.CONFLICTED);
            }
            Object e2 = linkedList2.remove(0);
            if (bl3) continue;
            linkedList.add(e2);
        }
        if (bl3) {
            return SVNMergeResult.createMergeResult(sVNStatusType, null);
        }
        sVNLog = sVNLog == null ? sVNAdminArea.getLog() : sVNLog;
        sVNAdminArea.installProperties(string, sVNProperties2, sVNProperties, sVNLog, bl2, true);
        if (!linkedList.isEmpty()) {
            String string2;
            SVNEntry sVNEntry = sVNAdminArea.getVersionedEntry(string, false);
            string2 = sVNAdminArea.getThisDirName().equals(string) ? "tmp/dir_conflicts" : "tmp/props/" + string;
            serializable2 = SVNFileUtil.createUniqueFile(sVNAdminArea.getAdminDirectory(), string2, ".prej", false);
            string2 = SVNFileUtil.getBasePath((File)serializable2);
            object3 = sVNEntry.getPropRejectFile();
            if (object3 == null) {
                object3 = sVNAdminArea.getThisDirName().equals(string) ? "dir_conflicts" : string;
                serializable = SVNFileUtil.createUniqueFile(sVNAdminArea.getRoot(), (String)object3, ".prej", false);
                object3 = SVNFileUtil.getBasePath((File)serializable);
            }
            serializable = sVNAdminArea.getFile(string2);
            object2 = SVNFileUtil.openFileForWriting((File)serializable);
            try {
                for (Object object4 : linkedList) {
                    ((OutputStream)object2).write(SVNEncodingUtil.fuzzyEscape((String)object4).getBytes("UTF-8"));
                }
                ((OutputStream)object2).write(SVNEncodingUtil.fuzzyEscape("\n").getBytes("UTF-8"));
            }
            catch (IOException iOException) {
                object4 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write properties conflict file: {1}", (Object)iOException.getLocalizedMessage());
                SVNErrorManager.error((SVNErrorMessage)object4, iOException, SVNLogType.WC);
            }
            finally {
                SVNFileUtil.closeFile((OutputStream)object2);
            }
            SVNProperties sVNProperties6 = new SVNProperties();
            sVNProperties6.put("name", string2);
            sVNProperties6.put("dest", (String)object3);
            sVNLog.addCommand("append", sVNProperties6, false);
            sVNProperties6.clear();
            sVNProperties6.put("name", string2);
            sVNLog.addCommand("rm", sVNProperties6, false);
            sVNProperties6.clear();
            sVNProperties6.put("name", string);
            sVNProperties6.put(SVNProperty.shortPropertyName("svn:entry:prop-reject-file"), (String)object3);
            sVNLog.addCommand("modify-entry", sVNProperties6, false);
        }
        return SVNMergeResult.createMergeResult(sVNStatusType, null);
    }

    public SVNDiffConflictChoiceStyle getDiffConflictStyle() {
        return this.myDiffConflictStyle;
    }

    public void setDiffConflictStyle(SVNDiffConflictChoiceStyle sVNDiffConflictChoiceStyle) {
        this.myDiffConflictStyle = sVNDiffConflictChoiceStyle;
    }

    @Override
    protected SVNStatusType mergeBinary(File file, File file2, File file3, SVNDiffOptions sVNDiffOptions, File file4) {
        return SVNStatusType.CONFLICTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SVNStatusType mergeText(File file, File file2, File file3, SVNDiffOptions sVNDiffOptions, File file4) {
        Object object;
        FSMergerBySequence fSMergerBySequence = new FSMergerBySequence(this.getConflictStartMarker(), this.getConflictSeparatorMarker(), this.getConflictEndMarker());
        int n2 = 0;
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        RandomAccessFile randomAccessFile3 = null;
        OutputStream outputStream = null;
        try {
            outputStream = SVNFileUtil.openFileForWriting(file4);
            randomAccessFile = new RandomAccessFile(file2, "r");
            randomAccessFile2 = new RandomAccessFile(file3, "r");
            randomAccessFile3 = new RandomAccessFile(file, "r");
            object = new QSequenceLineRAFileData(randomAccessFile3);
            QSequenceLineRAFileData qSequenceLineRAFileData = new QSequenceLineRAFileData(randomAccessFile);
            QSequenceLineRAFileData qSequenceLineRAFileData2 = new QSequenceLineRAFileData(randomAccessFile2);
            n2 = fSMergerBySequence.merge((QSequenceLineRAData)object, qSequenceLineRAFileData, qSequenceLineRAFileData2, sVNDiffOptions, outputStream, this.getDiffConflictStyle());
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(outputStream);
                SVNFileUtil.closeFile(randomAccessFile);
                SVNFileUtil.closeFile(randomAccessFile3);
                SVNFileUtil.closeFile(randomAccessFile2);
                throw throwable;
            }
            SVNFileUtil.closeFile(outputStream);
            SVNFileUtil.closeFile(randomAccessFile);
            SVNFileUtil.closeFile(randomAccessFile3);
            SVNFileUtil.closeFile(randomAccessFile2);
        }
        SVNFileUtil.closeFile(outputStream);
        SVNFileUtil.closeFile(randomAccessFile);
        SVNFileUtil.closeFile(randomAccessFile3);
        SVNFileUtil.closeFile(randomAccessFile2);
        object = SVNStatusType.UNCHANGED;
        if (n2 == 2) {
            object = SVNStatusType.CONFLICTED;
        } else if (n2 == 4) {
            object = SVNStatusType.MERGED;
        }
        return object;
    }

    @Override
    protected SVNMergeResult processMergedFiles(SVNMergeFileSet sVNMergeFileSet, SVNMergeResult sVNMergeResult) {
        DefaultSVNMergerAction defaultSVNMergerAction = this.getMergeAction(sVNMergeFileSet, sVNMergeResult);
        if (defaultSVNMergerAction == DefaultSVNMergerAction.MARK_CONFLICTED) {
            sVNMergeResult = this.handleMarkConflicted(sVNMergeFileSet);
        } else if (defaultSVNMergerAction == DefaultSVNMergerAction.CHOOSE_BASE) {
            sVNMergeResult = this.handleChooseBase(sVNMergeFileSet);
        } else if (defaultSVNMergerAction == DefaultSVNMergerAction.CHOOSE_REPOSITORY) {
            sVNMergeResult = this.handleChooseRepository(sVNMergeFileSet);
        } else if (defaultSVNMergerAction == DefaultSVNMergerAction.CHOOSE_WORKING) {
            sVNMergeResult = this.handleChooseWorking(sVNMergeFileSet);
        } else if (defaultSVNMergerAction == DefaultSVNMergerAction.CHOOSE_MERGED_FILE) {
            sVNMergeResult = this.handleChooseMerged(sVNMergeFileSet, sVNMergeResult);
        } else if (defaultSVNMergerAction == DefaultSVNMergerAction.MARK_RESOLVED) {
            sVNMergeResult = this.handleMarkResolved(sVNMergeFileSet, sVNMergeResult);
        } else if (defaultSVNMergerAction == DefaultSVNMergerAction.CHOOSE_REPOSITORY_CONFLICTED) {
            sVNMergeResult = this.handleChooseConflicted(false, sVNMergeFileSet);
        } else if (defaultSVNMergerAction == DefaultSVNMergerAction.CHOOSE_WORKING_CONFLICTED) {
            sVNMergeResult = this.handleChooseConflicted(true, sVNMergeFileSet);
        }
        this.postMergeCleanup(sVNMergeFileSet);
        return sVNMergeResult;
    }

    protected DefaultSVNMergerAction getMergeAction(SVNMergeFileSet sVNMergeFileSet, SVNMergeResult sVNMergeResult) {
        if (sVNMergeResult.getMergeStatus() == SVNStatusType.CONFLICTED) {
            if (this.myConflictCallback != null) {
                Object object;
                SVNTextConflictDescription sVNTextConflictDescription = new SVNTextConflictDescription(sVNMergeFileSet, SVNNodeKind.FILE, SVNConflictAction.EDIT, SVNConflictReason.EDITED);
                SVNConflictResult sVNConflictResult = this.myConflictCallback.handleConflict(sVNTextConflictDescription);
                if (sVNConflictResult == null) {
                    object = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Conflict callback violated API: returned no results.");
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
                }
                if (sVNConflictResult.isIsSaveMerged()) {
                    object = sVNConflictResult.getMergedFile() != null ? sVNConflictResult.getMergedFile() : sVNMergeFileSet.getResultFile();
                    File file = sVNMergeFileSet.getWCFile();
                    File file2 = SVNFileUtil.createUniqueFile(file.getParentFile(), file.getName(), ".edited", false);
                    SVNLog sVNLog = sVNMergeFileSet.getLog();
                    SVNProperties sVNProperties = new SVNProperties();
                    sVNProperties.put("name", SVNFileUtil.getBasePath((File)object));
                    sVNProperties.put("dest", file2.getName());
                    sVNLog.addCommand("cp-and-translate", sVNProperties, false);
                    sVNProperties.clear();
                }
                if ((object = sVNConflictResult.getConflictChoice()) == SVNConflictChoice.BASE) {
                    return DefaultSVNMergerAction.CHOOSE_BASE;
                }
                if (object == SVNConflictChoice.MERGED) {
                    return DefaultSVNMergerAction.CHOOSE_MERGED_FILE;
                }
                if (object == SVNConflictChoice.MINE_FULL) {
                    return DefaultSVNMergerAction.CHOOSE_WORKING;
                }
                if (object == SVNConflictChoice.THEIRS_FULL) {
                    return DefaultSVNMergerAction.CHOOSE_REPOSITORY;
                }
                if (object == SVNConflictChoice.MINE_CONFLICT) {
                    return DefaultSVNMergerAction.CHOOSE_WORKING_CONFLICTED;
                }
                if (object == SVNConflictChoice.THEIRS_CONFLICT) {
                    return DefaultSVNMergerAction.CHOOSE_REPOSITORY_CONFLICTED;
                }
            }
            return DefaultSVNMergerAction.MARK_CONFLICTED;
        }
        return DefaultSVNMergerAction.CHOOSE_MERGED_FILE;
    }

    protected SVNMergeResult handleChooseBase(SVNMergeFileSet sVNMergeFileSet) {
        SVNLog sVNLog = sVNMergeFileSet.getLog();
        if (sVNLog != null) {
            SVNProperties sVNProperties = new SVNProperties();
            sVNProperties.put("name", sVNMergeFileSet.getBasePath());
            sVNProperties.put("dest", sVNMergeFileSet.getWCPath());
            sVNLog.addCommand("cp-and-translate", sVNProperties, false);
            sVNProperties.clear();
        }
        return SVNMergeResult.createMergeResult(SVNStatusType.MERGED, null);
    }

    protected SVNMergeResult handleChooseRepository(SVNMergeFileSet sVNMergeFileSet) {
        SVNLog sVNLog = sVNMergeFileSet.getLog();
        if (sVNLog != null) {
            SVNProperties sVNProperties = new SVNProperties();
            sVNProperties.put("name", sVNMergeFileSet.getRepositoryPath());
            sVNProperties.put("dest", sVNMergeFileSet.getWCPath());
            sVNLog.addCommand("cp-and-translate", sVNProperties, false);
            sVNProperties.clear();
        }
        return SVNMergeResult.createMergeResult(SVNStatusType.MERGED, null);
    }

    protected SVNMergeResult handleChooseConflicted(boolean bl2, SVNMergeFileSet sVNMergeFileSet) {
        File file = SVNAdminUtil.createTmpFile(sVNMergeFileSet.getAdminArea());
        this.setDiffConflictStyle(bl2 ? SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED : SVNDiffConflictChoiceStyle.CHOOSE_LATEST);
        File file2 = sVNMergeFileSet.getBaseFile();
        File file3 = sVNMergeFileSet.getRepositoryFile();
        File file4 = sVNMergeFileSet.getLocalFile();
        this.mergeText(file2, file4, file3, this.getDiffOptions(), file);
        SVNLog sVNLog = sVNMergeFileSet.getLog();
        if (sVNLog != null) {
            SVNProperties sVNProperties = new SVNProperties();
            String string = SVNFileUtil.getBasePath(file);
            sVNProperties.put("name", string);
            sVNProperties.put("dest", sVNMergeFileSet.getWCPath());
            sVNLog.addCommand("cp-and-translate", sVNProperties, false);
            sVNProperties.clear();
            sVNProperties.put("name", string);
            sVNLog.addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
        }
        return SVNMergeResult.createMergeResult(SVNStatusType.MERGED, null);
    }

    protected SVNMergeResult handleChooseWorking(SVNMergeFileSet sVNMergeFileSet) {
        if (sVNMergeFileSet == null) {
            SVNErrorManager.cancel("", SVNLogType.WC);
        }
        return SVNMergeResult.createMergeResult(SVNStatusType.MERGED, null);
    }

    protected SVNMergeResult handleMarkConflicted(SVNMergeFileSet sVNMergeFileSet) {
        if (sVNMergeFileSet.isBinary()) {
            return this.handleMarkBinaryConflicted(sVNMergeFileSet);
        }
        return this.handleMarkTextConflicted(sVNMergeFileSet);
    }

    protected SVNMergeResult handleMarkBinaryConflicted(SVNMergeFileSet sVNMergeFileSet) {
        String string;
        Object object;
        SVNProperties sVNProperties = new SVNProperties();
        File file = sVNMergeFileSet.getAdminArea().getRoot();
        SVNLog sVNLog = sVNMergeFileSet.getLog();
        File file2 = SVNFileUtil.createUniqueFile(file, sVNMergeFileSet.getWCPath(), sVNMergeFileSet.getBaseLabel(), false);
        File file3 = SVNFileUtil.createUniqueFile(file, sVNMergeFileSet.getWCPath(), sVNMergeFileSet.getRepositoryLabel(), false);
        SVNFileUtil.copyFile(sVNMergeFileSet.getBaseFile(), file2, false);
        SVNFileUtil.copyFile(sVNMergeFileSet.getRepositoryFile(), file3, false);
        if (!sVNMergeFileSet.getLocalPath().equals(sVNMergeFileSet.getWCPath())) {
            object = SVNFileUtil.createUniqueFile(file, sVNMergeFileSet.getWCPath(), sVNMergeFileSet.getLocalLabel(), false);
            string = SVNFileUtil.getBasePath((File)object);
            if (sVNLog != null) {
                sVNProperties.put("name", sVNMergeFileSet.getLocalPath());
                sVNProperties.put("dest", string);
                sVNLog.addCommand("mv", sVNProperties, false);
                sVNProperties.clear();
            }
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-wrk"), string);
        } else {
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-wrk"), "");
        }
        object = SVNFileUtil.getBasePath(file3);
        string = SVNFileUtil.getBasePath(file2);
        this.makeBinaryConflictEntry(sVNMergeFileSet, (String)object, string);
        return SVNMergeResult.createMergeResult(SVNStatusType.CONFLICTED, null);
    }

    protected void makeBinaryConflictEntry(SVNMergeFileSet sVNMergeFileSet, String string, String string2) {
        SVNProperties sVNProperties = new SVNProperties();
        SVNLog sVNLog = sVNMergeFileSet.getLog();
        if (sVNLog != null) {
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-new"), string);
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-old"), string2);
            sVNLog.logChangedEntryProperties(sVNMergeFileSet.getWCPath(), sVNProperties);
            sVNProperties.clear();
        }
        sVNMergeFileSet.getAdminArea().saveEntries(false);
    }

    protected SVNMergeResult handleMarkTextConflicted(SVNMergeFileSet sVNMergeFileSet) {
        Object object;
        Object object2;
        SVNProperties sVNProperties = new SVNProperties();
        File file = sVNMergeFileSet.getAdminArea().getRoot();
        SVNLog sVNLog = sVNMergeFileSet.getLog();
        if (sVNMergeFileSet.getCopyFromFile() != null) {
            object2 = sVNMergeFileSet.getCopyFromPath();
            object = sVNMergeFileSet.getWCPath();
            if (sVNLog != null) {
                sVNProperties.put("name", (String)object2);
                sVNProperties.put("dest", (String)object);
                sVNLog.addCommand("cp-and-translate", sVNProperties, false);
                sVNProperties.clear();
            }
        }
        object2 = SVNFileUtil.createUniqueFile(file, sVNMergeFileSet.getWCPath(), sVNMergeFileSet.getLocalLabel(), false);
        object = SVNFileUtil.createUniqueFile(file, sVNMergeFileSet.getWCPath(), sVNMergeFileSet.getBaseLabel(), false);
        File file2 = SVNFileUtil.createUniqueFile(file, sVNMergeFileSet.getWCPath(), sVNMergeFileSet.getRepositoryLabel(), false);
        String string = SVNFileUtil.getBasePath(file2);
        String string2 = SVNFileUtil.getBasePath((File)object);
        String string3 = SVNFileUtil.getBasePath((File)object2);
        String string4 = sVNMergeFileSet.getBasePath();
        String string5 = sVNMergeFileSet.getRepositoryPath();
        File file3 = SVNTranslator.getTranslatedFile(sVNMergeFileSet.getAdminArea(), sVNMergeFileSet.getWCPath(), sVNMergeFileSet.getWCFile(), false, false, false, true);
        String string6 = SVNFileUtil.getBasePath(file3);
        if (sVNLog != null) {
            sVNProperties.put("name", string4);
            sVNProperties.put("dest", string2);
            sVNProperties.put("arg2", sVNMergeFileSet.getWCPath());
            sVNLog.addCommand("cp-and-translate", sVNProperties, false);
            sVNProperties.clear();
            sVNProperties.put("name", string5);
            sVNProperties.put("dest", string);
            sVNProperties.put("arg2", sVNMergeFileSet.getWCPath());
            sVNLog.addCommand("cp-and-translate", sVNProperties, false);
            sVNProperties.clear();
            sVNProperties.put("name", string6);
            sVNProperties.put("dest", string3);
            sVNProperties.put("arg2", sVNMergeFileSet.getWCPath());
            sVNLog.addCommand("cp-and-translate", sVNProperties, false);
            sVNProperties.clear();
            if (!file3.equals(sVNMergeFileSet.getLocalFile())) {
                sVNProperties.put("name", string6);
                sVNLog.addCommand("rm", sVNProperties, false);
                sVNProperties.clear();
            }
            sVNProperties.put("name", sVNMergeFileSet.getResultPath());
            sVNProperties.put("dest", sVNMergeFileSet.getWCPath());
            sVNProperties.put("arg2", sVNMergeFileSet.getWCPath());
            sVNLog.addCommand("cp-and-translate", sVNProperties, false);
            sVNProperties.clear();
        }
        this.makeTextConflictEntry(sVNMergeFileSet, string3, string, string2);
        return SVNMergeResult.createMergeResult(SVNStatusType.CONFLICTED, null);
    }

    protected void makeTextConflictEntry(SVNMergeFileSet sVNMergeFileSet, String string, String string2, String string3) {
        SVNLog sVNLog = sVNMergeFileSet.getLog();
        if (sVNLog != null) {
            SVNProperties sVNProperties = new SVNProperties();
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-wrk"), string);
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-new"), string2);
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-old"), string3);
            sVNLog.logChangedEntryProperties(sVNMergeFileSet.getWCPath(), sVNProperties);
            sVNProperties.clear();
        }
    }

    protected SVNMergeResult handleChooseMerged(SVNMergeFileSet sVNMergeFileSet, SVNMergeResult sVNMergeResult) {
        SVNProperties sVNProperties = new SVNProperties();
        SVNLog sVNLog = sVNMergeFileSet.getLog();
        if (sVNMergeResult.getMergeStatus() != SVNStatusType.CONFLICTED) {
            if (sVNMergeResult.getMergeStatus() != SVNStatusType.UNCHANGED && sVNLog != null) {
                sVNProperties.put("name", sVNMergeFileSet.getResultPath());
                sVNProperties.put("dest", sVNMergeFileSet.getWCPath());
                sVNLog.addCommand("cp-and-translate", sVNProperties, false);
                sVNProperties.clear();
            }
            return sVNMergeResult;
        }
        if (sVNMergeFileSet.isBinary()) {
            return this.handleMarkConflicted(sVNMergeFileSet);
        }
        if (sVNLog != null) {
            sVNProperties.put("name", sVNMergeFileSet.getResultPath());
            sVNProperties.put("dest", sVNMergeFileSet.getWCPath());
            sVNLog.addCommand("cp-and-translate", sVNProperties, false);
            sVNProperties.clear();
        }
        return SVNMergeResult.createMergeResult(SVNStatusType.MERGED, null);
    }

    protected SVNMergeResult handleMarkResolved(SVNMergeFileSet sVNMergeFileSet, SVNMergeResult sVNMergeResult) {
        if (!sVNMergeFileSet.isBinary()) {
            return this.handleChooseMerged(sVNMergeFileSet, sVNMergeResult);
        }
        return this.handleChooseWorking(sVNMergeFileSet);
    }

    protected void postMergeCleanup(SVNMergeFileSet sVNMergeFileSet) {
        SVNProperties sVNProperties = new SVNProperties();
        SVNLog sVNLog = sVNMergeFileSet.getLog();
        if (!sVNMergeFileSet.getLocalPath().equals(sVNMergeFileSet.getWCPath()) && sVNLog != null) {
            sVNProperties.put("name", sVNMergeFileSet.getLocalPath());
            sVNLog.addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
        }
        if (sVNLog != null) {
            sVNProperties.put("name", sVNMergeFileSet.getWCPath());
            sVNLog.addCommand("maybe-executable", sVNProperties, false);
            sVNProperties.clear();
            sVNProperties.put("name", sVNMergeFileSet.getWCPath());
            sVNLog.addCommand("maybe-readonly", sVNProperties, false);
            sVNProperties.clear();
            sVNProperties.put("name", sVNMergeFileSet.getResultPath());
            sVNLog.addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
        }
    }

    private SVNStatusType applySinglePropertyAdd(String string, boolean bl2, SVNStatusType sVNStatusType, SVNProperties sVNProperties, String string2, SVNPropertyValue sVNPropertyValue, SVNPropertyValue sVNPropertyValue2, SVNPropertyValue sVNPropertyValue3, SVNAdminArea sVNAdminArea, SVNLog sVNLog, Collection collection, boolean bl3) {
        boolean bl4 = false;
        if (sVNPropertyValue3 != null) {
            if (sVNPropertyValue3.equals(sVNPropertyValue2)) {
                sVNStatusType = DefaultSVNMerger.getPropMergeStatus(sVNStatusType, SVNStatusType.MERGED);
                this.changeProperty(sVNProperties, string2, sVNPropertyValue2);
            } else if ("svn:mergeinfo".equals(string2)) {
                sVNPropertyValue2 = SVNPropertyValue.create(SVNMergeInfoUtil.combineMergeInfoProperties(sVNPropertyValue3.getString(), sVNPropertyValue2.getString()));
                this.changeProperty(sVNProperties, string2, sVNPropertyValue2);
                sVNStatusType = DefaultSVNMerger.getPropMergeStatus(sVNStatusType, SVNStatusType.MERGED);
            } else {
                bl4 = this.maybeGeneratePropConflict(string, string2, sVNProperties, null, sVNPropertyValue2, sVNPropertyValue, sVNPropertyValue3, sVNAdminArea, sVNLog, bl2, bl3);
                if (bl4) {
                    collection.add(MessageFormat.format("Trying to add new property ''{0}'' with value ''{1}'',\nbut property already exists with value ''{2}''.", string2, SVNPropertyValue.getPropertyAsString(sVNPropertyValue2), SVNPropertyValue.getPropertyAsString(sVNPropertyValue3)));
                }
            }
        } else if (sVNPropertyValue != null) {
            bl4 = this.maybeGeneratePropConflict(string, string2, sVNProperties, null, sVNPropertyValue2, sVNPropertyValue, null, sVNAdminArea, sVNLog, bl2, bl3);
            if (bl4) {
                collection.add(MessageFormat.format("Trying to create property ''{0}'' with value ''{1}'',\nbut it has been locally deleted.", string2, SVNPropertyValue.getPropertyAsString(sVNPropertyValue2)));
            }
        } else {
            this.changeProperty(sVNProperties, string2, sVNPropertyValue2);
        }
        return sVNStatusType;
    }

    private void changeProperty(SVNProperties sVNProperties, String string, SVNPropertyValue sVNPropertyValue) {
        if (sVNPropertyValue == null) {
            sVNProperties.remove(string);
        } else {
            sVNProperties.put(string, sVNPropertyValue);
        }
    }

    private SVNStatusType applySinglePropertyChange(String string, boolean bl2, SVNStatusType sVNStatusType, SVNProperties sVNProperties, String string2, SVNPropertyValue sVNPropertyValue, SVNPropertyValue sVNPropertyValue2, SVNPropertyValue sVNPropertyValue3, SVNPropertyValue sVNPropertyValue4, SVNAdminArea sVNAdminArea, SVNLog sVNLog, Collection collection, boolean bl3) {
        if ("svn:mergeinfo".equals(string2)) {
            return this.applySingleMergeInfoPropertyChange(string, bl2, sVNStatusType, sVNProperties, string2, sVNPropertyValue, sVNPropertyValue2, sVNPropertyValue3, sVNPropertyValue4, sVNAdminArea, sVNLog, collection, bl3);
        }
        return this.applySingleGenericPropertyChange(string, bl2, sVNStatusType, sVNProperties, string2, sVNPropertyValue, sVNPropertyValue2, sVNPropertyValue3, sVNPropertyValue4, sVNAdminArea, sVNLog, collection, bl3);
    }

    private SVNStatusType applySingleMergeInfoPropertyChange(String string, boolean bl2, SVNStatusType sVNStatusType, SVNProperties sVNProperties, String string2, SVNPropertyValue sVNPropertyValue, SVNPropertyValue sVNPropertyValue2, SVNPropertyValue sVNPropertyValue3, SVNPropertyValue sVNPropertyValue4, SVNAdminArea sVNAdminArea, SVNLog sVNLog, Collection collection, boolean bl3) {
        boolean bl4 = false;
        if (sVNPropertyValue4 != null && sVNPropertyValue == null || sVNPropertyValue4 == null && sVNPropertyValue != null || sVNPropertyValue4 != null && sVNPropertyValue != null && !sVNPropertyValue4.equals(sVNPropertyValue)) {
            if (sVNPropertyValue4 != null) {
                if (sVNPropertyValue4.equals(sVNPropertyValue3)) {
                    sVNStatusType = DefaultSVNMerger.getPropMergeStatus(sVNStatusType, SVNStatusType.MERGED);
                } else {
                    sVNPropertyValue3 = SVNPropertyValue.create(SVNMergeInfoUtil.combineForkedMergeInfoProperties(sVNPropertyValue2.getString(), sVNPropertyValue4.getString(), sVNPropertyValue3.getString()));
                    this.changeProperty(sVNProperties, string2, sVNPropertyValue3);
                    sVNStatusType = DefaultSVNMerger.getPropMergeStatus(sVNStatusType, SVNStatusType.MERGED);
                }
            } else {
                bl4 = this.maybeGeneratePropConflict(string, string2, sVNProperties, sVNPropertyValue2, sVNPropertyValue3, sVNPropertyValue, sVNPropertyValue4, sVNAdminArea, sVNLog, bl2, bl3);
                if (bl4) {
                    collection.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut it has been locally deleted.", string2, SVNPropertyValue.getPropertyAsString(sVNPropertyValue2), SVNPropertyValue.getPropertyAsString(sVNPropertyValue3)));
                }
            }
        } else if (sVNPropertyValue4 == null) {
            TreeMap treeMap = new TreeMap();
            SVNMergeInfoUtil.diffMergeInfoProperties(null, treeMap, sVNPropertyValue2.getString(), null, sVNPropertyValue3.getString(), null);
            sVNPropertyValue3 = SVNPropertyValue.create(SVNMergeInfoUtil.formatMergeInfoToString(treeMap, null));
            this.changeProperty(sVNProperties, string2, sVNPropertyValue3);
        } else if (sVNPropertyValue.equals(sVNPropertyValue2)) {
            this.changeProperty(sVNProperties, string2, sVNPropertyValue3);
        } else {
            sVNPropertyValue3 = SVNPropertyValue.create(SVNMergeInfoUtil.combineForkedMergeInfoProperties(sVNPropertyValue2.getString(), sVNPropertyValue4.getString(), sVNPropertyValue3.getString()));
            this.changeProperty(sVNProperties, string2, sVNPropertyValue3);
            sVNStatusType = DefaultSVNMerger.getPropMergeStatus(sVNStatusType, SVNStatusType.MERGED);
        }
        return sVNStatusType;
    }

    private SVNStatusType applySingleGenericPropertyChange(String string, boolean bl2, SVNStatusType sVNStatusType, SVNProperties sVNProperties, String string2, SVNPropertyValue sVNPropertyValue, SVNPropertyValue sVNPropertyValue2, SVNPropertyValue sVNPropertyValue3, SVNPropertyValue sVNPropertyValue4, SVNAdminArea sVNAdminArea, SVNLog sVNLog, Collection collection, boolean bl3) {
        boolean bl4 = false;
        if (sVNPropertyValue4 == null && sVNPropertyValue2 == null || sVNPropertyValue4 != null && sVNPropertyValue2 != null && sVNPropertyValue4.equals(sVNPropertyValue2)) {
            this.changeProperty(sVNProperties, string2, sVNPropertyValue3);
        } else {
            bl4 = this.maybeGeneratePropConflict(string, string2, sVNProperties, sVNPropertyValue2, sVNPropertyValue3, sVNPropertyValue, sVNPropertyValue4, sVNAdminArea, sVNLog, bl2, bl3);
            if (bl4) {
                if (sVNPropertyValue4 != null && sVNPropertyValue != null && sVNPropertyValue4.equals(sVNPropertyValue)) {
                    collection.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut property already exists with value ''{3}''.", string2, SVNPropertyValue.getPropertyAsString(sVNPropertyValue2), SVNPropertyValue.getPropertyAsString(sVNPropertyValue3), SVNPropertyValue.getPropertyAsString(sVNPropertyValue4)));
                } else if (sVNPropertyValue4 != null && sVNPropertyValue != null) {
                    collection.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut the property has been locally changed from ''{3}'' to ''{4}''.", string2, SVNPropertyValue.getPropertyAsString(sVNPropertyValue2), SVNPropertyValue.getPropertyAsString(sVNPropertyValue3), SVNPropertyValue.getPropertyAsString(sVNPropertyValue), SVNPropertyValue.getPropertyAsString(sVNPropertyValue4)));
                } else if (sVNPropertyValue4 != null) {
                    collection.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut property has been locally added with value ''{3}''.", string2, SVNPropertyValue.getPropertyAsString(sVNPropertyValue2), SVNPropertyValue.getPropertyAsString(sVNPropertyValue3), SVNPropertyValue.getPropertyAsString(sVNPropertyValue4)));
                } else if (sVNPropertyValue != null) {
                    collection.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut it has been locally deleted.", string2, SVNPropertyValue.getPropertyAsString(sVNPropertyValue2), SVNPropertyValue.getPropertyAsString(sVNPropertyValue3)));
                } else {
                    collection.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut the property does not exist.", string2, SVNPropertyValue.getPropertyAsString(sVNPropertyValue2), SVNPropertyValue.getPropertyAsString(sVNPropertyValue3)));
                }
            }
        }
        return sVNStatusType;
    }

    private SVNStatusType applySinglePropertyDelete(String string, boolean bl2, SVNStatusType sVNStatusType, SVNProperties sVNProperties, String string2, SVNPropertyValue sVNPropertyValue, SVNPropertyValue sVNPropertyValue2, SVNPropertyValue sVNPropertyValue3, SVNAdminArea sVNAdminArea, SVNLog sVNLog, Collection collection, boolean bl3) {
        boolean bl4 = false;
        if (sVNPropertyValue == null) {
            this.changeProperty(sVNProperties, string2, null);
            if (sVNPropertyValue2 != null) {
                sVNStatusType = DefaultSVNMerger.getPropMergeStatus(sVNStatusType, SVNStatusType.MERGED);
            }
        } else if (sVNPropertyValue.equals(sVNPropertyValue2)) {
            if (sVNPropertyValue3 != null) {
                if (sVNPropertyValue3.equals(sVNPropertyValue2)) {
                    this.changeProperty(sVNProperties, string2, null);
                } else {
                    bl4 = this.maybeGeneratePropConflict(string, string2, sVNProperties, sVNPropertyValue2, null, sVNPropertyValue, sVNPropertyValue3, sVNAdminArea, sVNLog, bl2, bl3);
                    if (bl4) {
                        collection.add(MessageFormat.format("Trying to delete property ''{0}'' with value ''{1}''\n but it has been modified from ''{2}'' to ''{3}''.", string2, SVNPropertyValue.getPropertyAsString(sVNPropertyValue2), SVNPropertyValue.getPropertyAsString(sVNPropertyValue), SVNPropertyValue.getPropertyAsString(sVNPropertyValue3)));
                    }
                }
            } else {
                sVNStatusType = DefaultSVNMerger.getPropMergeStatus(sVNStatusType, SVNStatusType.MERGED);
            }
        } else {
            bl4 = this.maybeGeneratePropConflict(string, string2, sVNProperties, sVNPropertyValue2, null, sVNPropertyValue, sVNPropertyValue3, sVNAdminArea, sVNLog, bl2, bl3);
            if (bl4) {
                collection.add(MessageFormat.format("Trying to delete property ''{0}'' with value ''{1}''\n but the local value is ''{2}''.", string2, SVNPropertyValue.getPropertyAsString(sVNPropertyValue), SVNPropertyValue.getPropertyAsString(sVNPropertyValue3)));
            }
        }
        return sVNStatusType;
    }

    private static SVNStatusType getPropMergeStatus(SVNStatusType sVNStatusType, SVNStatusType sVNStatusType2) {
        if (sVNStatusType == null) {
            return null;
        }
        int n2 = STATUS_ORDERING.indexOf(sVNStatusType);
        int n3 = STATUS_ORDERING.indexOf(sVNStatusType2);
        if (n3 <= n2) {
            return sVNStatusType;
        }
        return sVNStatusType2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeGeneratePropConflict(String string, String string2, SVNProperties sVNProperties, SVNPropertyValue sVNPropertyValue, SVNPropertyValue sVNPropertyValue2, SVNPropertyValue sVNPropertyValue3, SVNPropertyValue sVNPropertyValue4, SVNAdminArea sVNAdminArea, SVNLog sVNLog, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = true;
        if (this.myConflictCallback == null || bl3) {
            return bl5;
        }
        File file = sVNAdminArea.getFile(string);
        File file2 = null;
        File file3 = null;
        File file4 = null;
        File file5 = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            if (sVNPropertyValue4 != null) {
                file2 = SVNFileUtil.createUniqueFile(file.getParentFile(), file.getName(), ".tmp", false);
                object7 = SVNFileUtil.openFileForWriting(file2);
                try {
                    ((OutputStream)object7).write(SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue4));
                }
                catch (IOException iOException) {
                    object6 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write a working property value file: {1}", (Object)iOException.getLocalizedMessage());
                    SVNErrorManager.error((SVNErrorMessage)object6, iOException, SVNLogType.WC);
                }
                finally {
                    SVNFileUtil.closeFile((OutputStream)object7);
                }
            }
            if (sVNPropertyValue2 != null) {
                file3 = SVNFileUtil.createUniqueFile(file.getParentFile(), file.getName(), ".tmp", false);
                object7 = SVNFileUtil.openFileForWriting(file3);
                try {
                    ((OutputStream)object7).write(SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue2));
                }
                catch (IOException iOException) {
                    object6 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write a new property value file: {1}", (Object)iOException.getLocalizedMessage());
                    SVNErrorManager.error((SVNErrorMessage)object6, iOException, SVNLogType.WC);
                }
                finally {
                    SVNFileUtil.closeFile((OutputStream)object7);
                }
            }
            if (sVNPropertyValue3 != null && sVNPropertyValue == null || sVNPropertyValue3 == null && sVNPropertyValue != null) {
                object7 = sVNPropertyValue3 != null ? sVNPropertyValue3 : sVNPropertyValue;
                file4 = SVNFileUtil.createUniqueFile(file.getParentFile(), file.getName(), ".tmp", false);
                object5 = SVNFileUtil.openFileForWriting(file4);
                try {
                    ((OutputStream)object5).write(SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)object7));
                }
                catch (IOException iOException) {
                    object4 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write a base property value file: {1}", (Object)iOException.getLocalizedMessage());
                    SVNErrorManager.error((SVNErrorMessage)object4, iOException, SVNLogType.WC);
                }
                finally {
                    SVNFileUtil.closeFile((OutputStream)object5);
                }
            } else if (sVNPropertyValue3 != null && sVNPropertyValue != null) {
                object7 = sVNPropertyValue3;
                if (!sVNPropertyValue3.equals(sVNPropertyValue) && sVNPropertyValue4 != null && sVNPropertyValue3.equals(sVNPropertyValue4)) {
                    object7 = sVNPropertyValue;
                }
                file4 = SVNFileUtil.createUniqueFile(file.getParentFile(), file.getName(), ".tmp", false);
                object5 = SVNFileUtil.openFileForWriting(file4);
                try {
                    ((OutputStream)object5).write(SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)object7));
                }
                catch (IOException iOException) {
                    object4 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write a base property value file: {1}", (Object)iOException.getLocalizedMessage());
                    SVNErrorManager.error((SVNErrorMessage)object4, iOException, SVNLogType.WC);
                }
                finally {
                    SVNFileUtil.closeFile((OutputStream)object5);
                }
                if (sVNPropertyValue4 != null && sVNPropertyValue2 != null) {
                    object6 = new FSMergerBySequence(this.getConflictStartMarker(), this.getConflictSeparatorMarker(), this.getConflictEndMarker());
                    object4 = null;
                    try {
                        file5 = SVNFileUtil.createUniqueFile(file.getParentFile(), file.getName(), ".tmp", false);
                        object4 = SVNFileUtil.openFileForWriting(file5);
                        object3 = new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)object7));
                        object2 = new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue4));
                        object = new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue2));
                        ((FSMergerBySequence)object6).merge((QSequenceLineRAData)object3, (QSequenceLineRAData)object2, (QSequenceLineRAData)object, null, (OutputStream)object4, null);
                    }
                    catch (IOException iOException) {
                        object2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                        SVNErrorManager.error((SVNErrorMessage)object2, iOException, SVNLogType.WC);
                    }
                    finally {
                        SVNFileUtil.closeFile((OutputStream)object4);
                    }
                }
            }
            object7 = null;
            if (!bl2 && sVNProperties != null) {
                object7 = sVNProperties.getStringValue("svn:mime-type");
            }
            object5 = new SVNMergeFileSet(sVNAdminArea, sVNLog, file4, file2, string, file3, file5, null, (String)object7);
            object6 = SVNConflictAction.EDIT;
            if (sVNPropertyValue == null && sVNPropertyValue2 != null) {
                object6 = SVNConflictAction.ADD;
            } else if (sVNPropertyValue != null && sVNPropertyValue2 == null) {
                object6 = SVNConflictAction.DELETE;
            }
            object4 = SVNConflictReason.EDITED;
            if (sVNPropertyValue3 != null && sVNPropertyValue4 == null) {
                object4 = SVNConflictReason.DELETED;
            } else if (sVNPropertyValue3 == null && sVNPropertyValue4 != null) {
                object4 = SVNConflictReason.OBSTRUCTED;
            }
            object3 = new SVNPropertyConflictDescription((SVNMergeFileSet)object5, bl2 ? SVNNodeKind.DIR : SVNNodeKind.FILE, string2, (SVNConflictAction)object6, (SVNConflictReason)object4);
            object2 = this.myConflictCallback.handleConflict((SVNConflictDescription)object3);
            if (object2 == null) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Conflict callback violated API: returned no results.");
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
            }
            if ((object = ((SVNConflictResult)object2).getConflictChoice()) == SVNConflictChoice.MINE_FULL) {
                bl5 = false;
            } else if (object == SVNConflictChoice.THEIRS_FULL) {
                this.changeProperty(sVNProperties, string2, sVNPropertyValue2);
                bl5 = false;
            } else if (object == SVNConflictChoice.BASE) {
                this.changeProperty(sVNProperties, string2, sVNPropertyValue3);
                bl5 = false;
            } else if (object == SVNConflictChoice.MERGED) {
                Object object8;
                if (file5 == null && ((SVNConflictResult)object2).getMergedFile() == null) {
                    object8 = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Conflict callback violated API: returned no merged file.");
                    SVNErrorManager.error((SVNErrorMessage)object8, SVNLogType.DEFAULT);
                }
                object8 = SVNFileUtil.readFile(file5 != null ? file5 : ((SVNConflictResult)object2).getMergedFile());
                this.changeProperty(sVNProperties, string2, SVNPropertyValue.create((String)object8));
                bl5 = false;
            }
            bl4 = bl5;
        }
        catch (Throwable throwable) {
            SVNFileUtil.deleteFile(file2);
            SVNFileUtil.deleteFile(file3);
            SVNFileUtil.deleteFile(file4);
            SVNFileUtil.deleteFile(file5);
            throw throwable;
        }
        SVNFileUtil.deleteFile(file2);
        SVNFileUtil.deleteFile(file3);
        SVNFileUtil.deleteFile(file4);
        SVNFileUtil.deleteFile(file5);
        return bl4;
    }

    static {
        STATUS_ORDERING.add(SVNStatusType.UNKNOWN);
        STATUS_ORDERING.add(SVNStatusType.UNCHANGED);
        STATUS_ORDERING.add(SVNStatusType.INAPPLICABLE);
        STATUS_ORDERING.add(SVNStatusType.CHANGED);
        STATUS_ORDERING.add(SVNStatusType.MERGED);
        STATUS_ORDERING.add(SVNStatusType.OBSTRUCTED);
        STATUS_ORDERING.add(SVNStatusType.CONFLICTED);
    }
}

